/**
* @file        MODULE_rf_antenna_short.cpp
* @author      klatzer
* @copyright   INTEL
*
* @briefAntenna Short Registers
*
* This is a Spectool2 file.
*/

#include "MODULE_rf_antenna_short.h"

#include "IndirectAccessPort.h"
#include "Register.h"
#include "RField.h"
#include "Attribute.h"
#include "Format.h"
#include "Utilities.h"
#include "python/str.h"

MODULE_rf_antenna_short::MODULE_rf_antenna_short()
{
  ///////////////////////////
  //// MODULE PROPERTIES ////
  setBaseName ("rf_antenna_short");
  setLongName ("Antenna Short Registers");
  setDescription ("ANTENNAx SHORT REGISTER");
  setContact ("klatzer");
  setFile (__FILE__);
  setGenerateGraphic(true);
  setIp(true);
  // addDocuLink("path to location", "description");
  // addDocuPicture("path to picture", "title");
  // addReference("module path to reference", "title");
  
  ////////////////////////////////////////////////////////////
  /// PORTS WHICH ARE CONTROLLED EXTERNALLY (INPUT PORTS) ////
  Port* p_FCSI = new Port (this);
  p_FCSI->setInstName ("FCSI");
  p_FCSI->setLongName ("Single Antenna FCSI Interface");
  p_FCSI->setDescription ("");
  p_FCSI->setAddrBase (16);
  p_FCSI->setDataWidth (16);
  p_FCSI->setAddrSpace (0x00000040);
  p_FCSI->setAccess (AddressableNode::RW);
  p_FCSI->setOffsetAsView(0x00000000);
  p_FCSI->setAllowAddrOverlap(false);
  p_FCSI->setAddrAlignCheck(AddressableNode::AAC_AUTO_OFF);
  p_FCSI->setBusProtocol (Bus::FCSI);
  p_FCSI->setCollapse (false);

  
  ///////////////////////////////////////////////////
  /// PORTS WHICH ARE CONTROLLING EXTERNAL PORTS (OUTPUT PORTS) ////
  
  /////////////////////
  //// SUB-MODULES ////
  
  ////////////////////////
  //// INTERNAL PORTS ////
  
  ////////////////////////
  //// INTERNAL BUSES ////
  
  //////////////////////////////
  //// REGISTERS AND FIELDS ////
  Register* r_FCSI_SR0 = new Register;
  r_FCSI_SR0->setInstName ("SR0");
  r_FCSI_SR0->setLongName ("SHORT REGISTER 0");
  r_FCSI_SR0->setDescription ("FCSI-LDO1V2");
  r_FCSI_SR0->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_SR0, 0x00000000);

  RField* f_FCSI_SR0_RX_BAND = new RField;
  f_FCSI_SR0_RX_BAND->setInstName ("RX_BAND");
  f_FCSI_SR0_RX_BAND->setLongName ("RX BAND");
  f_FCSI_SR0_RX_BAND->setDescription ("Rx sub-band selection");
  f_FCSI_SR0_RX_BAND->setDataWidth (3);
  f_FCSI_SR0_RX_BAND->setResetVal ("3'b000");
  f_FCSI_SR0_RX_BAND->setAccProp (AccProp::RW);
  r_FCSI_SR0->connectRField (f_FCSI_SR0_RX_BAND, 0);

  Attribute* a_FCSI_SR0_RX_BAND_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_SR0_RX_BAND_0_0->setInstName ("0");
  a_FCSI_SR0_RX_BAND_0_0->setLongName ("");
  a_FCSI_SR0_RX_BAND_0_0->setDescription ("");
  a_FCSI_SR0_RX_BAND_0_0->addItem("0", "3'b000", "min");
  a_FCSI_SR0_RX_BAND_0_0->addItem("1", "3'b001", "");
  a_FCSI_SR0_RX_BAND_0_0->addItem("2", "3'b010", "");
  a_FCSI_SR0_RX_BAND_0_0->addItem("3", "3'b011", "");
  a_FCSI_SR0_RX_BAND_0_0->addItem("4", "3'b100", "");
  a_FCSI_SR0_RX_BAND_0_0->addItem("5", "3'b101", "");
  a_FCSI_SR0_RX_BAND_0_0->addItem("6", "3'b110", "");
  a_FCSI_SR0_RX_BAND_0_0->addItem("7", "3'b111", "max");
  f_FCSI_SR0_RX_BAND->connectAttribute (a_FCSI_SR0_RX_BAND_0_0);

  RField* f_FCSI_SR0_TX_BAND = new RField;
  f_FCSI_SR0_TX_BAND->setInstName ("TX_BAND");
  f_FCSI_SR0_TX_BAND->setLongName ("TX BAND");
  f_FCSI_SR0_TX_BAND->setDescription ("Tx sub-band selection");
  f_FCSI_SR0_TX_BAND->setDataWidth (3);
  f_FCSI_SR0_TX_BAND->setResetVal ("3'b000");
  f_FCSI_SR0_TX_BAND->setAccProp (AccProp::RW);
  r_FCSI_SR0->connectRField (f_FCSI_SR0_TX_BAND, 3);

  Attribute* a_FCSI_SR0_TX_BAND_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_SR0_TX_BAND_0_0->setInstName ("0");
  a_FCSI_SR0_TX_BAND_0_0->setLongName ("");
  a_FCSI_SR0_TX_BAND_0_0->setDescription ("");
  a_FCSI_SR0_TX_BAND_0_0->addItem("0", "3'b000", "min");
  a_FCSI_SR0_TX_BAND_0_0->addItem("1", "3'b001", "");
  a_FCSI_SR0_TX_BAND_0_0->addItem("2", "3'b010", "");
  a_FCSI_SR0_TX_BAND_0_0->addItem("3", "3'b011", "");
  a_FCSI_SR0_TX_BAND_0_0->addItem("4", "3'b100", "");
  a_FCSI_SR0_TX_BAND_0_0->addItem("5", "3'b101", "");
  a_FCSI_SR0_TX_BAND_0_0->addItem("6", "3'b110", "");
  a_FCSI_SR0_TX_BAND_0_0->addItem("7", "3'b111", "max");
  f_FCSI_SR0_TX_BAND->connectAttribute (a_FCSI_SR0_TX_BAND_0_0);

  RField* f_FCSI_SR0_MODE = new RField;
  f_FCSI_SR0_MODE->setInstName ("MODE");
  f_FCSI_SR0_MODE->setLongName ("MODE");
  f_FCSI_SR0_MODE->setDescription ("Mode selection");
  f_FCSI_SR0_MODE->setDataWidth (2);
  f_FCSI_SR0_MODE->setResetVal ("2'b00");
  f_FCSI_SR0_MODE->setAccProp (AccProp::RW);
  r_FCSI_SR0->connectRField (f_FCSI_SR0_MODE, 6);

  Attribute* a_FCSI_SR0_MODE_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_SR0_MODE_0_0->setInstName ("0");
  a_FCSI_SR0_MODE_0_0->setLongName ("");
  a_FCSI_SR0_MODE_0_0->setDescription ("");
  a_FCSI_SR0_MODE_0_0->addItem("0", "2'b00", "HP");
  a_FCSI_SR0_MODE_0_0->addItem("1", "2'b01", "RP");
  a_FCSI_SR0_MODE_0_0->addItem("2", "2'b10", "LP");
  a_FCSI_SR0_MODE_0_0->addItem("3", "2'b11", "DPD");
  f_FCSI_SR0_MODE->connectAttribute (a_FCSI_SR0_MODE_0_0);

  RField* f_FCSI_SR0_SEL_BW = new RField;
  f_FCSI_SR0_SEL_BW->setInstName ("SEL_BW");
  f_FCSI_SR0_SEL_BW->setLongName ("SELECT BANDWIDTH");
  f_FCSI_SR0_SEL_BW->setDescription ("Select bandwidth");
  f_FCSI_SR0_SEL_BW->setDataWidth (2);
  f_FCSI_SR0_SEL_BW->setResetVal ("2'b00");
  f_FCSI_SR0_SEL_BW->setAccProp (AccProp::RW);
  r_FCSI_SR0->connectRField (f_FCSI_SR0_SEL_BW, 8);

  Attribute* a_FCSI_SR0_SEL_BW_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_SR0_SEL_BW_0_0->setInstName ("0");
  a_FCSI_SR0_SEL_BW_0_0->setLongName ("");
  a_FCSI_SR0_SEL_BW_0_0->setDescription ("");
  a_FCSI_SR0_SEL_BW_0_0->addItem("0", "2'b00", "20MHz");
  a_FCSI_SR0_SEL_BW_0_0->addItem("1", "2'b01", "40MHz");
  a_FCSI_SR0_SEL_BW_0_0->addItem("2", "2'b10", "80MHz");
  a_FCSI_SR0_SEL_BW_0_0->addItem("3", "2'b11", "160MHz");
  f_FCSI_SR0_SEL_BW->connectAttribute (a_FCSI_SR0_SEL_BW_0_0);

  RField* f_FCSI_SR0_SEL_CH = new RField;
  f_FCSI_SR0_SEL_CH->setInstName ("SEL_CH");
  f_FCSI_SR0_SEL_CH->setLongName ("SELECT CHANNEL");
  f_FCSI_SR0_SEL_CH->setDescription ("Select channel for fast channel hopping");
  f_FCSI_SR0_SEL_CH->setDataWidth (3);
  f_FCSI_SR0_SEL_CH->setResetVal ("3'b000");
  f_FCSI_SR0_SEL_CH->setAccProp (AccProp::RW);
  r_FCSI_SR0->connectRField (f_FCSI_SR0_SEL_CH, 10);

  Attribute* a_FCSI_SR0_SEL_CH_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_SR0_SEL_CH_0_0->setInstName ("0");
  a_FCSI_SR0_SEL_CH_0_0->setLongName ("");
  a_FCSI_SR0_SEL_CH_0_0->setDescription ("");
  a_FCSI_SR0_SEL_CH_0_0->addItem("0", "3'b000", "Channel 0");
  a_FCSI_SR0_SEL_CH_0_0->addItem("1", "3'b001", "Channel 1");
  a_FCSI_SR0_SEL_CH_0_0->addItem("2", "3'b010", "Channel 2");
  a_FCSI_SR0_SEL_CH_0_0->addItem("3", "3'b011", "Channel 3");
  a_FCSI_SR0_SEL_CH_0_0->addItem("4", "3'b100", "Channel 4");
  a_FCSI_SR0_SEL_CH_0_0->addItem("5", "3'b101", "Channel 5");
  f_FCSI_SR0_SEL_CH->connectAttribute (a_FCSI_SR0_SEL_CH_0_0);

  RField* f_FCSI_SR0_SEL_RXDC = new RField;
  f_FCSI_SR0_SEL_RXDC->setInstName ("SEL_RXDC");
  f_FCSI_SR0_SEL_RXDC->setLongName ("SEL RX DC");
  f_FCSI_SR0_SEL_RXDC->setDescription ("Select Rx DC for 3 pre-defined channels");
  f_FCSI_SR0_SEL_RXDC->setDataWidth (2);
  f_FCSI_SR0_SEL_RXDC->setResetVal ("2'b00");
  f_FCSI_SR0_SEL_RXDC->setAccProp (AccProp::RW);
  r_FCSI_SR0->connectRField (f_FCSI_SR0_SEL_RXDC, 13);

  Attribute* a_FCSI_SR0_SEL_RXDC_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_SR0_SEL_RXDC_0_0->setInstName ("0");
  a_FCSI_SR0_SEL_RXDC_0_0->setLongName ("");
  a_FCSI_SR0_SEL_RXDC_0_0->setDescription ("");
  a_FCSI_SR0_SEL_RXDC_0_0->addItem("0", "2'b00", "RXDC Channel 0");
  a_FCSI_SR0_SEL_RXDC_0_0->addItem("1", "2'b01", "RXDC Channel 1");
  a_FCSI_SR0_SEL_RXDC_0_0->addItem("2", "2'b10", "RXDC Channel 2");
  a_FCSI_SR0_SEL_RXDC_0_0->addItem("3", "2'b11", "RXDC Channel 3");
  f_FCSI_SR0_SEL_RXDC->connectAttribute (a_FCSI_SR0_SEL_RXDC_0_0);

  Register* r_FCSI_SR1 = new Register;
  r_FCSI_SR1->setInstName ("SR1");
  r_FCSI_SR1->setLongName ("SHORT REGISTER 1");
  r_FCSI_SR1->setDescription ("FCSI-LDO1V2");
  r_FCSI_SR1->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_SR1, 0x00000001);

  RField* f_FCSI_SR1_rfrx_gain_config = new RField;
  f_FCSI_SR1_rfrx_gain_config->setInstName ("rfrx_gain_config");
  f_FCSI_SR1_rfrx_gain_config->setLongName ("RFRX GAIN CONFIG");
  f_FCSI_SR1_rfrx_gain_config->setDescription ("RFRX gain configuration");
  f_FCSI_SR1_rfrx_gain_config->setDataWidth (3);
  f_FCSI_SR1_rfrx_gain_config->setResetVal ("3'b000");
  f_FCSI_SR1_rfrx_gain_config->setAccProp (AccProp::RW);
  r_FCSI_SR1->connectRField (f_FCSI_SR1_rfrx_gain_config, 0);

  Attribute* a_FCSI_SR1_rfrx_gain_config_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_SR1_rfrx_gain_config_0_0->setInstName ("0");
  a_FCSI_SR1_rfrx_gain_config_0_0->setLongName ("");
  a_FCSI_SR1_rfrx_gain_config_0_0->setDescription ("");
  a_FCSI_SR1_rfrx_gain_config_0_0->addItem("0", "3'b000", "FECTL Config 0");
  a_FCSI_SR1_rfrx_gain_config_0_0->addItem("1", "3'b001", "FECTL Config 1");
  a_FCSI_SR1_rfrx_gain_config_0_0->addItem("2", "3'b010", "FECTL Config 2");
  a_FCSI_SR1_rfrx_gain_config_0_0->addItem("3", "3'b011", "FECTL Config 3");
  a_FCSI_SR1_rfrx_gain_config_0_0->addItem("4", "3'b100", "FECTL Config 4");
  a_FCSI_SR1_rfrx_gain_config_0_0->addItem("5", "3'b101", "FECTL Config 5");
  a_FCSI_SR1_rfrx_gain_config_0_0->addItem("6", "3'b110", "FECTL Config 6 (same DC offset as Config 5)");
  a_FCSI_SR1_rfrx_gain_config_0_0->addItem("7", "3'b111", "n.a.");
  f_FCSI_SR1_rfrx_gain_config->connectAttribute (a_FCSI_SR1_rfrx_gain_config_0_0);

  RField* f_FCSI_SR1_sel_s2d_rx = new RField;
  f_FCSI_SR1_sel_s2d_rx->setInstName ("sel_s2d_rx");
  f_FCSI_SR1_sel_s2d_rx->setLongName ("SEL_S2D_RX");
  f_FCSI_SR1_sel_s2d_rx->setDescription ("Select RSSI xSSI range for dedicated configurations");
  f_FCSI_SR1_sel_s2d_rx->setDataWidth (1);
  f_FCSI_SR1_sel_s2d_rx->setResetVal ("1'b0");
  f_FCSI_SR1_sel_s2d_rx->setAccProp (AccProp::RW);
  r_FCSI_SR1->connectRField (f_FCSI_SR1_sel_s2d_rx, 3);

  Attribute* a_FCSI_SR1_sel_s2d_rx_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_SR1_sel_s2d_rx_0_0->setInstName ("0");
  a_FCSI_SR1_sel_s2d_rx_0_0->setLongName ("");
  a_FCSI_SR1_sel_s2d_rx_0_0->setDescription ("");
  a_FCSI_SR1_sel_s2d_rx_0_0->addItem("0", "1'b0", "RSSI range 0");
  a_FCSI_SR1_sel_s2d_rx_0_0->addItem("1", "1'b1", "RSSI range 1");
  f_FCSI_SR1_sel_s2d_rx->connectAttribute (a_FCSI_SR1_sel_s2d_rx_0_0);

  RField* f_FCSI_SR1_pgc_gain = new RField;
  f_FCSI_SR1_pgc_gain->setInstName ("pgc_gain");
  f_FCSI_SR1_pgc_gain->setLongName ("PGC GAIN");
  f_FCSI_SR1_pgc_gain->setDescription ("PGC gain");
  f_FCSI_SR1_pgc_gain->setDataWidth (4);
  f_FCSI_SR1_pgc_gain->setResetVal ("4'b0000");
  f_FCSI_SR1_pgc_gain->setAccProp (AccProp::RW);
  r_FCSI_SR1->connectRField (f_FCSI_SR1_pgc_gain, 4);

  Attribute* a_FCSI_SR1_pgc_gain_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_SR1_pgc_gain_0_0->setInstName ("0");
  a_FCSI_SR1_pgc_gain_0_0->setLongName ("");
  a_FCSI_SR1_pgc_gain_0_0->setDescription ("");
  a_FCSI_SR1_pgc_gain_0_0->addItem("0", "4'b0000", " 0dB");
  a_FCSI_SR1_pgc_gain_0_0->addItem("1", "4'b0001", " 2dB");
  a_FCSI_SR1_pgc_gain_0_0->addItem("2", "4'b0010", " 4dB");
  a_FCSI_SR1_pgc_gain_0_0->addItem("3", "4'b0011", " 6dB");
  a_FCSI_SR1_pgc_gain_0_0->addItem("4", "4'b0100", " 8dB");
  a_FCSI_SR1_pgc_gain_0_0->addItem("5", "4'b0101", " 10dB");
  a_FCSI_SR1_pgc_gain_0_0->addItem("6", "4'b0110", " 12dB");
  a_FCSI_SR1_pgc_gain_0_0->addItem("7", "4'b0111", " 14dB");
  a_FCSI_SR1_pgc_gain_0_0->addItem("8", "4'b1000", " 16dB");
  a_FCSI_SR1_pgc_gain_0_0->addItem("9", "4'b1001", " 18dB");
  a_FCSI_SR1_pgc_gain_0_0->addItem("10", "4'b1010", " 20dB");
  f_FCSI_SR1_pgc_gain->connectAttribute (a_FCSI_SR1_pgc_gain_0_0);

  RField* f_FCSI_SR1_rx_filter = new RField;
  f_FCSI_SR1_rx_filter->setInstName ("rx_filter");
  f_FCSI_SR1_rx_filter->setLongName ("RX FILTER");
  f_FCSI_SR1_rx_filter->setDescription ("RX Filter");
  f_FCSI_SR1_rx_filter->setDataWidth (6);
  f_FCSI_SR1_rx_filter->setResetVal ("6'b000000");
  f_FCSI_SR1_rx_filter->setAccProp (AccProp::RW);
  r_FCSI_SR1->connectRField (f_FCSI_SR1_rx_filter, 8);

  Attribute* a_FCSI_SR1_rx_filter_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_SR1_rx_filter_0_0->setInstName ("0");
  a_FCSI_SR1_rx_filter_0_0->setLongName ("");
  a_FCSI_SR1_rx_filter_0_0->setDescription ("");
  a_FCSI_SR1_rx_filter_0_0->addItem("0", "6'b000000", " xx");
  a_FCSI_SR1_rx_filter_0_0->addItem("1", "6'b000001", " xx");
  a_FCSI_SR1_rx_filter_0_0->addItem("2", "6'b000010", " xx");
  a_FCSI_SR1_rx_filter_0_0->addItem("15", "6'b001111", "xx");
  a_FCSI_SR1_rx_filter_0_0->addItem("61", "6'b111101", "xx");
  a_FCSI_SR1_rx_filter_0_0->addItem("62", "6'b111110", "xx");
  a_FCSI_SR1_rx_filter_0_0->addItem("63", "6'b111111", "xx");
  f_FCSI_SR1_rx_filter->connectAttribute (a_FCSI_SR1_rx_filter_0_0);

  RField* f_FCSI_SR1_force_off = new RField;
  f_FCSI_SR1_force_off->setInstName ("force_off");
  f_FCSI_SR1_force_off->setLongName ("FORCE OFF");
  f_FCSI_SR1_force_off->setDescription ("FORCE OFF");
  f_FCSI_SR1_force_off->setDataWidth (1);
  f_FCSI_SR1_force_off->setResetVal ("1'b0");
  f_FCSI_SR1_force_off->setAccProp (AccProp::RW);
  r_FCSI_SR1->connectRField (f_FCSI_SR1_force_off, 14);

  Attribute* a_FCSI_SR1_force_off_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_SR1_force_off_0_0->setInstName ("0");
  a_FCSI_SR1_force_off_0_0->setLongName ("");
  a_FCSI_SR1_force_off_0_0->setDescription ("");
  a_FCSI_SR1_force_off_0_0->addItem("0", "1'b0", "disable");
  a_FCSI_SR1_force_off_0_0->addItem("1", "1'b1", "enable");
  f_FCSI_SR1_force_off->connectAttribute (a_FCSI_SR1_force_off_0_0);

  RField* f_FCSI_SR1_rxon = new RField;
  f_FCSI_SR1_rxon->setInstName ("rxon");
  f_FCSI_SR1_rxon->setLongName ("RX ON");
  f_FCSI_SR1_rxon->setDescription ("Rx on - macro-control for Rx");
  f_FCSI_SR1_rxon->setDataWidth (1);
  f_FCSI_SR1_rxon->setResetVal ("1'b0");
  f_FCSI_SR1_rxon->setAccProp (AccProp::RW);
  r_FCSI_SR1->connectRField (f_FCSI_SR1_rxon, 15);

  Attribute* a_FCSI_SR1_rxon_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_SR1_rxon_0_0->setInstName ("0");
  a_FCSI_SR1_rxon_0_0->setLongName ("");
  a_FCSI_SR1_rxon_0_0->setDescription ("");
  a_FCSI_SR1_rxon_0_0->addItem("0", "1'b0", "disable");
  a_FCSI_SR1_rxon_0_0->addItem("1", "1'b1", "enable");
  f_FCSI_SR1_rxon->connectAttribute (a_FCSI_SR1_rxon_0_0);

  Register* r_FCSI_SR2 = new Register;
  r_FCSI_SR2->setInstName ("SR2");
  r_FCSI_SR2->setLongName ("SHORT REGISTER 2");
  r_FCSI_SR2->setDescription ("FCSI-LDO1V2");
  r_FCSI_SR2->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_SR2, 0x00000002);

  RField* f_FCSI_SR2_tpc = new RField;
  f_FCSI_SR2_tpc->setInstName ("tpc");
  f_FCSI_SR2_tpc->setLongName ("TPC");
  f_FCSI_SR2_tpc->setDescription ("TPC");
  f_FCSI_SR2_tpc->setDataWidth (2);
  f_FCSI_SR2_tpc->setResetVal ("2'b00");
  f_FCSI_SR2_tpc->setAccProp (AccProp::RW);
  r_FCSI_SR2->connectRField (f_FCSI_SR2_tpc, 0);

  Attribute* a_FCSI_SR2_tpc_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_SR2_tpc_0_0->setInstName ("0");
  a_FCSI_SR2_tpc_0_0->setLongName ("");
  a_FCSI_SR2_tpc_0_0->setDescription ("");
  a_FCSI_SR2_tpc_0_0->addItem("0", "2'b00", "gain0");
  a_FCSI_SR2_tpc_0_0->addItem("1", "2'b01", "gain1");
  a_FCSI_SR2_tpc_0_0->addItem("2", "2'b10", "gain2");
  a_FCSI_SR2_tpc_0_0->addItem("3", "2'b11", "gain3");
  f_FCSI_SR2_tpc->connectAttribute (a_FCSI_SR2_tpc_0_0);

  RField* f_FCSI_SR2_pa_drv_gain = new RField;
  f_FCSI_SR2_pa_drv_gain->setInstName ("pa_drv_gain");
  f_FCSI_SR2_pa_drv_gain->setLongName ("PA DRIVER GAIN");
  f_FCSI_SR2_pa_drv_gain->setDescription ("PA driver relative gain (abs. 8dB)");
  f_FCSI_SR2_pa_drv_gain->setDataWidth (4);
  f_FCSI_SR2_pa_drv_gain->setResetVal ("4'b0000");
  f_FCSI_SR2_pa_drv_gain->setAccProp (AccProp::RW);
  r_FCSI_SR2->connectRField (f_FCSI_SR2_pa_drv_gain, 2);

  Attribute* a_FCSI_SR2_pa_drv_gain_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_SR2_pa_drv_gain_0_0->setInstName ("0");
  a_FCSI_SR2_pa_drv_gain_0_0->setLongName ("");
  a_FCSI_SR2_pa_drv_gain_0_0->setDescription ("");
  a_FCSI_SR2_pa_drv_gain_0_0->addItem("15", "4'b1111", "-36dB");
  a_FCSI_SR2_pa_drv_gain_0_0->addItem("14", "4'b1110", "-30dB");
  a_FCSI_SR2_pa_drv_gain_0_0->addItem("13", "4'b1101", "-26dB");
  a_FCSI_SR2_pa_drv_gain_0_0->addItem("12", "4'b1100", "-24dB");
  a_FCSI_SR2_pa_drv_gain_0_0->addItem("11", "4'b1011", "-22dB");
  a_FCSI_SR2_pa_drv_gain_0_0->addItem("10", "4'b1010", "-20dB");
  a_FCSI_SR2_pa_drv_gain_0_0->addItem("9", "4'b1001", "-18dB");
  a_FCSI_SR2_pa_drv_gain_0_0->addItem("8", "4'b1000", "-16dB");
  a_FCSI_SR2_pa_drv_gain_0_0->addItem("7", "4'b0111", "-14db");
  a_FCSI_SR2_pa_drv_gain_0_0->addItem("6", "4'b0110", "-12dB");
  a_FCSI_SR2_pa_drv_gain_0_0->addItem("5", "4'b0101", "-10dB");
  a_FCSI_SR2_pa_drv_gain_0_0->addItem("4", "4'b0100", "-8dB");
  a_FCSI_SR2_pa_drv_gain_0_0->addItem("3", "4'b0011", "-6dB");
  a_FCSI_SR2_pa_drv_gain_0_0->addItem("2", "4'b0010", "-4dB");
  a_FCSI_SR2_pa_drv_gain_0_0->addItem("1", "4'b0001", "-2dB");
  a_FCSI_SR2_pa_drv_gain_0_0->addItem("0", "4'b0000", "0dB");
  f_FCSI_SR2_pa_drv_gain->connectAttribute (a_FCSI_SR2_pa_drv_gain_0_0);

  RField* f_FCSI_SR2_sel_s2d_tx = new RField;
  f_FCSI_SR2_sel_s2d_tx->setInstName ("sel_s2d_tx");
  f_FCSI_SR2_sel_s2d_tx->setLongName ("SEL S2D TX");
  f_FCSI_SR2_sel_s2d_tx->setDescription ("SEL S2D TX");
  f_FCSI_SR2_sel_s2d_tx->setDataWidth (2);
  f_FCSI_SR2_sel_s2d_tx->setResetVal ("2'b00");
  f_FCSI_SR2_sel_s2d_tx->setAccProp (AccProp::RW);
  r_FCSI_SR2->connectRField (f_FCSI_SR2_sel_s2d_tx, 7);

  Attribute* a_FCSI_SR2_sel_s2d_tx_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_SR2_sel_s2d_tx_0_0->setInstName ("0");
  a_FCSI_SR2_sel_s2d_tx_0_0->setLongName ("");
  a_FCSI_SR2_sel_s2d_tx_0_0->setDescription ("");
  a_FCSI_SR2_sel_s2d_tx_0_0->addItem("0", "2'b00", "range0");
  a_FCSI_SR2_sel_s2d_tx_0_0->addItem("1", "2'b01", "range1");
  a_FCSI_SR2_sel_s2d_tx_0_0->addItem("2", "2'b10", "range2");
  a_FCSI_SR2_sel_s2d_tx_0_0->addItem("3", "2'b11", "n.a.");
  f_FCSI_SR2_sel_s2d_tx->connectAttribute (a_FCSI_SR2_sel_s2d_tx_0_0);

  RField* f_FCSI_SR2_FECTL0 = new RField;
  f_FCSI_SR2_FECTL0->setInstName ("FECTL0");
  f_FCSI_SR2_FECTL0->setLongName ("FECTL0");
  f_FCSI_SR2_FECTL0->setDescription ("FECTL0");
  f_FCSI_SR2_FECTL0->setDataWidth (1);
  f_FCSI_SR2_FECTL0->setResetVal ("1'b0");
  f_FCSI_SR2_FECTL0->setAccProp (AccProp::RW);
  r_FCSI_SR2->connectRField (f_FCSI_SR2_FECTL0, 9);

  Attribute* a_FCSI_SR2_FECTL0_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_SR2_FECTL0_0_0->setInstName ("0");
  a_FCSI_SR2_FECTL0_0_0->setLongName ("");
  a_FCSI_SR2_FECTL0_0_0->setDescription ("");
  a_FCSI_SR2_FECTL0_0_0->addItem("0", "1'b0", "disable");
  a_FCSI_SR2_FECTL0_0_0->addItem("1", "1'b1", "enable");
  f_FCSI_SR2_FECTL0->connectAttribute (a_FCSI_SR2_FECTL0_0_0);

  RField* f_FCSI_SR2_FECTL1 = new RField;
  f_FCSI_SR2_FECTL1->setInstName ("FECTL1");
  f_FCSI_SR2_FECTL1->setLongName ("FECTL1");
  f_FCSI_SR2_FECTL1->setDescription ("FECTL1");
  f_FCSI_SR2_FECTL1->setDataWidth (1);
  f_FCSI_SR2_FECTL1->setResetVal ("1'b0");
  f_FCSI_SR2_FECTL1->setAccProp (AccProp::RW);
  r_FCSI_SR2->connectRField (f_FCSI_SR2_FECTL1, 10);

  Attribute* a_FCSI_SR2_FECTL1_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_SR2_FECTL1_0_0->setInstName ("0");
  a_FCSI_SR2_FECTL1_0_0->setLongName ("");
  a_FCSI_SR2_FECTL1_0_0->setDescription ("");
  a_FCSI_SR2_FECTL1_0_0->addItem("0", "1'b0", "disable");
  a_FCSI_SR2_FECTL1_0_0->addItem("1", "1'b1", "enable");
  f_FCSI_SR2_FECTL1->connectAttribute (a_FCSI_SR2_FECTL1_0_0);

  RField* f_FCSI_SR2_FECTL2 = new RField;
  f_FCSI_SR2_FECTL2->setInstName ("FECTL2");
  f_FCSI_SR2_FECTL2->setLongName ("FECTL2");
  f_FCSI_SR2_FECTL2->setDescription ("FECTL2");
  f_FCSI_SR2_FECTL2->setDataWidth (1);
  f_FCSI_SR2_FECTL2->setResetVal ("1'b0");
  f_FCSI_SR2_FECTL2->setAccProp (AccProp::RW);
  r_FCSI_SR2->connectRField (f_FCSI_SR2_FECTL2, 11);

  Attribute* a_FCSI_SR2_FECTL2_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_SR2_FECTL2_0_0->setInstName ("0");
  a_FCSI_SR2_FECTL2_0_0->setLongName ("");
  a_FCSI_SR2_FECTL2_0_0->setDescription ("");
  a_FCSI_SR2_FECTL2_0_0->addItem("0", "1'b0", "disable");
  a_FCSI_SR2_FECTL2_0_0->addItem("1", "1'b1", "enable");
  f_FCSI_SR2_FECTL2->connectAttribute (a_FCSI_SR2_FECTL2_0_0);

  RField* f_FCSI_SR2_FECTL3 = new RField;
  f_FCSI_SR2_FECTL3->setInstName ("FECTL3");
  f_FCSI_SR2_FECTL3->setLongName ("FECTL3");
  f_FCSI_SR2_FECTL3->setDescription ("FECTL3");
  f_FCSI_SR2_FECTL3->setDataWidth (1);
  f_FCSI_SR2_FECTL3->setResetVal ("1'b0");
  f_FCSI_SR2_FECTL3->setAccProp (AccProp::RW);
  r_FCSI_SR2->connectRField (f_FCSI_SR2_FECTL3, 12);

  Attribute* a_FCSI_SR2_FECTL3_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_SR2_FECTL3_0_0->setInstName ("0");
  a_FCSI_SR2_FECTL3_0_0->setLongName ("");
  a_FCSI_SR2_FECTL3_0_0->setDescription ("");
  a_FCSI_SR2_FECTL3_0_0->addItem("0", "1'b0", "disable");
  a_FCSI_SR2_FECTL3_0_0->addItem("1", "1'b1", "enable");
  f_FCSI_SR2_FECTL3->connectAttribute (a_FCSI_SR2_FECTL3_0_0);

  RField* f_FCSI_SR2_FECTL4 = new RField;
  f_FCSI_SR2_FECTL4->setInstName ("FECTL4");
  f_FCSI_SR2_FECTL4->setLongName ("FECTL4");
  f_FCSI_SR2_FECTL4->setDescription ("FECTL4");
  f_FCSI_SR2_FECTL4->setDataWidth (1);
  f_FCSI_SR2_FECTL4->setResetVal ("1'b0");
  f_FCSI_SR2_FECTL4->setAccProp (AccProp::RW);
  r_FCSI_SR2->connectRField (f_FCSI_SR2_FECTL4, 13);

  Attribute* a_FCSI_SR2_FECTL4_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_SR2_FECTL4_0_0->setInstName ("0");
  a_FCSI_SR2_FECTL4_0_0->setLongName ("");
  a_FCSI_SR2_FECTL4_0_0->setDescription ("");
  a_FCSI_SR2_FECTL4_0_0->addItem("0", "1'b0", "disable");
  a_FCSI_SR2_FECTL4_0_0->addItem("1", "1'b1", "enable");
  f_FCSI_SR2_FECTL4->connectAttribute (a_FCSI_SR2_FECTL4_0_0);

  RField* f_FCSI_SR2_FECTL5 = new RField;
  f_FCSI_SR2_FECTL5->setInstName ("FECTL5");
  f_FCSI_SR2_FECTL5->setLongName ("FECTL5");
  f_FCSI_SR2_FECTL5->setDescription ("FECTL5");
  f_FCSI_SR2_FECTL5->setDataWidth (1);
  f_FCSI_SR2_FECTL5->setResetVal ("1'b0");
  f_FCSI_SR2_FECTL5->setAccProp (AccProp::RW);
  r_FCSI_SR2->connectRField (f_FCSI_SR2_FECTL5, 14);

  Attribute* a_FCSI_SR2_FECTL5_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_SR2_FECTL5_0_0->setInstName ("0");
  a_FCSI_SR2_FECTL5_0_0->setLongName ("");
  a_FCSI_SR2_FECTL5_0_0->setDescription ("");
  a_FCSI_SR2_FECTL5_0_0->addItem("0", "1'b0", "disable");
  a_FCSI_SR2_FECTL5_0_0->addItem("1", "1'b1", "enable");
  f_FCSI_SR2_FECTL5->connectAttribute (a_FCSI_SR2_FECTL5_0_0);

  RField* f_FCSI_SR2_txon = new RField;
  f_FCSI_SR2_txon->setInstName ("txon");
  f_FCSI_SR2_txon->setLongName ("TX ON");
  f_FCSI_SR2_txon->setDescription ("Tx on - macro-control for Rx");
  f_FCSI_SR2_txon->setDataWidth (1);
  f_FCSI_SR2_txon->setResetVal ("1'b0");
  f_FCSI_SR2_txon->setAccProp (AccProp::RW);
  r_FCSI_SR2->connectRField (f_FCSI_SR2_txon, 15);

  Attribute* a_FCSI_SR2_txon_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_SR2_txon_0_0->setInstName ("0");
  a_FCSI_SR2_txon_0_0->setLongName ("");
  a_FCSI_SR2_txon_0_0->setDescription ("");
  a_FCSI_SR2_txon_0_0->addItem("0", "1'b0", "disable");
  a_FCSI_SR2_txon_0_0->addItem("1", "1'b1", "enable");
  f_FCSI_SR2_txon->connectAttribute (a_FCSI_SR2_txon_0_0);

  Register* r_FCSI_SR3 = new Register;
  r_FCSI_SR3->setInstName ("SR3");
  r_FCSI_SR3->setLongName ("SHORT REGISTER 3");
  r_FCSI_SR3->setDescription ("FCSI-LDO1V2");
  r_FCSI_SR3->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_SR3, 0x00000003);

  RField* f_FCSI_SR3_step = new RField;
  f_FCSI_SR3_step->setInstName ("step");
  f_FCSI_SR3_step->setLongName ("STEP");
  f_FCSI_SR3_step->setDescription ("Step");
  f_FCSI_SR3_step->setDataWidth (2);
  f_FCSI_SR3_step->setResetVal ("2'b00");
  f_FCSI_SR3_step->setAccProp (AccProp::RW);
  r_FCSI_SR3->connectRField (f_FCSI_SR3_step, 14);

  Attribute* a_FCSI_SR3_step_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_SR3_step_0_0->setInstName ("0");
  a_FCSI_SR3_step_0_0->setLongName ("");
  a_FCSI_SR3_step_0_0->setDescription ("");
  a_FCSI_SR3_step_0_0->addItem("0", "2'b00", "no force");
  a_FCSI_SR3_step_0_0->addItem("1", "2'b01", "direct step 1");
  a_FCSI_SR3_step_0_0->addItem("2", "2'b10", "direct max gain");
  a_FCSI_SR3_step_0_0->addItem("3", "2'b11", "quick lna");
  f_FCSI_SR3_step->connectAttribute (a_FCSI_SR3_step_0_0);

  
}

