/**
* @file        MODULE_rf_central.cpp
* @author      klatzer
* @copyright   INTEL
*
* @briefRF CENTRAL FCSI-Register
*
* This is a Spectool2 file.
*/

#include "MODULE_rf_central.h"
#include "MODULE_rf_central_short.h"
#include "MODULE_rf_central_long.h"

#include "IndirectAccessPort.h"
#include "Register.h"
#include "RField.h"
#include "Attribute.h"
#include "Format.h"
#include "Utilities.h"
#include "python/str.h"

MODULE_rf_central::MODULE_rf_central()
{
  ///////////////////////////
  //// MODULE PROPERTIES ////
  setBaseName ("rf_central");
  setLongName ("RF CENTRAL FCSI-Register");
  setDescription ("FCSI-Register for RF CENTRAL");
  setContact ("klatzer");
  setFile (__FILE__);
  setGenerateGraphic(true);
  setIp(true);
  // addDocuLink("path to location", "description");
  // addDocuPicture("path to picture", "title");
  // addReference("module path to reference", "title");
  
  ////////////////////////////////////////////////////////////
  /// PORTS WHICH ARE CONTROLLED EXTERNALLY (INPUT PORTS) ////
  Port* p_FCSI = new Port (this);
  p_FCSI->setInstName ("FCSI");
  p_FCSI->setLongName ("CENTRAL FCSI Interface");
  p_FCSI->setDescription ("");
  p_FCSI->setAddrBase (16);
  p_FCSI->setDataWidth (16);
  p_FCSI->setAddrSpace (0x00000080);
  p_FCSI->setAccess (AddressableNode::RW);
  p_FCSI->setOffsetAsView(0x00000000);
  p_FCSI->setAllowAddrOverlap(false);
  p_FCSI->setAddrAlignCheck(AddressableNode::AAC_AUTO_OFF);
  p_FCSI->setBusProtocol (Bus::FCSI);
  p_FCSI->setCollapse (false);

  
  ///////////////////////////////////////////////////
  /// PORTS WHICH ARE CONTROLLING EXTERNAL PORTS (OUTPUT PORTS) ////
  
  /////////////////////
  //// SUB-MODULES ////
  MODULE_rf_central_short* m_short = new MODULE_rf_central_short;
  m_short->setInstName ("short");
  connectModule (m_short);

  MODULE_rf_central_long* m_long = new MODULE_rf_central_long;
  m_long->setInstName ("long");
  connectModule (m_long);

  
  ////////////////////////
  //// INTERNAL PORTS ////
  
  ////////////////////////
  //// INTERNAL BUSES ////
  Bus* b_FCSI = new Bus (this);
  b_FCSI->setInstName ("FCSI");
  b_FCSI->setLongName ("CENTRAL FCSI Interface");
  b_FCSI->setDescription ("");
  b_FCSI->setAddrBase (16);
  b_FCSI->setDataWidth (16);
  b_FCSI->setAddrSpace (0x00000080);
  b_FCSI->setAccess (AddressableNode::RW);
  b_FCSI->setAllowAddrOverlap(false);
  b_FCSI->setAddrAlignCheck(AddressableNode::AAC_AUTO_OFF);
  b_FCSI->setBusProtocol (Bus::FCSI);

  p_FCSI->connectBus (b_FCSI, 0x00000000);
  b_FCSI->connectSlavePort (m_short->getPort("FCSI"), 0x00000000);
  b_FCSI->connectSlavePort (m_long->getPort("FCSI"), 0x00000040);

  
  //////////////////////////////
  //// REGISTERS AND FIELDS ////
  
}

