/**
* @file        MODULE_rf_central_short.cpp
* @author      klatzer
* @copyright   INTEL
*
* @briefCentral Short Registers
*
* This is a Spectool2 file.
*/

#include "MODULE_rf_central_short.h"

#include "IndirectAccessPort.h"
#include "Register.h"
#include "RField.h"
#include "Attribute.h"
#include "Format.h"
#include "Utilities.h"
#include "python/str.h"

MODULE_rf_central_short::MODULE_rf_central_short()
{
  ///////////////////////////
  //// MODULE PROPERTIES ////
  setBaseName ("rf_central_short");
  setLongName ("Central Short Registers");
  setDescription ("CENTRAL SHORT REGISTER");
  setContact ("klatzer");
  setFile (__FILE__);
  setGenerateGraphic(true);
  setIp(true);
  // addDocuLink("path to location", "description");
  // addDocuPicture("path to picture", "title");
  // addReference("module path to reference", "title");
  
  ////////////////////////////////////////////////////////////
  /// PORTS WHICH ARE CONTROLLED EXTERNALLY (INPUT PORTS) ////
  Port* p_FCSI = new Port (this);
  p_FCSI->setInstName ("FCSI");
  p_FCSI->setLongName ("Single Central FCSI Interface");
  p_FCSI->setDescription ("");
  p_FCSI->setAddrBase (16);
  p_FCSI->setDataWidth (16);
  p_FCSI->setAddrSpace (0x00000040);
  p_FCSI->setAccess (AddressableNode::RW);
  p_FCSI->setOffsetAsView(0x00000000);
  p_FCSI->setAllowAddrOverlap(false);
  p_FCSI->setAddrAlignCheck(AddressableNode::AAC_AUTO_OFF);
  p_FCSI->setBusProtocol (Bus::FCSI);
  p_FCSI->setCollapse (false);

  
  ///////////////////////////////////////////////////
  /// PORTS WHICH ARE CONTROLLING EXTERNAL PORTS (OUTPUT PORTS) ////
  
  /////////////////////
  //// SUB-MODULES ////
  
  ////////////////////////
  //// INTERNAL PORTS ////
  
  ////////////////////////
  //// INTERNAL BUSES ////
  
  //////////////////////////////
  //// REGISTERS AND FIELDS ////
  Register* r_FCSI_SR0 = new Register;
  r_FCSI_SR0->setInstName ("SR0");
  r_FCSI_SR0->setLongName ("SHORT REGISTER 0");
  r_FCSI_SR0->setDescription ("FCSI-LDO1V2");
  r_FCSI_SR0->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_SR0, 0x00000000);

  RField* f_FCSI_SR0_SEL_ANT_PLL0 = new RField;
  f_FCSI_SR0_SEL_ANT_PLL0->setInstName ("SEL_ANT_PLL0");
  f_FCSI_SR0_SEL_ANT_PLL0->setLongName ("SELECTION ANTENNA PLL0");
  f_FCSI_SR0_SEL_ANT_PLL0->setDescription ("Antenna selection for PLL0 fast channel hopping");
  f_FCSI_SR0_SEL_ANT_PLL0->setDataWidth (2);
  f_FCSI_SR0_SEL_ANT_PLL0->setResetVal ("2'b00");
  f_FCSI_SR0_SEL_ANT_PLL0->setAccProp (AccProp::RW);
  r_FCSI_SR0->connectRField (f_FCSI_SR0_SEL_ANT_PLL0, 0);

  Attribute* a_FCSI_SR0_SEL_ANT_PLL0_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_SR0_SEL_ANT_PLL0_0_0->setInstName ("0");
  a_FCSI_SR0_SEL_ANT_PLL0_0_0->setLongName ("");
  a_FCSI_SR0_SEL_ANT_PLL0_0_0->setDescription ("");
  a_FCSI_SR0_SEL_ANT_PLL0_0_0->addItem("0", "2'b00", "Antenna 0");
  a_FCSI_SR0_SEL_ANT_PLL0_0_0->addItem("1", "2'b01", "Antenna 1");
  a_FCSI_SR0_SEL_ANT_PLL0_0_0->addItem("2", "2'b10", "Antenna 2");
  a_FCSI_SR0_SEL_ANT_PLL0_0_0->addItem("3", "2'b11", "Antenna 2");
  f_FCSI_SR0_SEL_ANT_PLL0->connectAttribute (a_FCSI_SR0_SEL_ANT_PLL0_0_0);

  RField* f_FCSI_SR0_SEL_ANT_PLL1 = new RField;
  f_FCSI_SR0_SEL_ANT_PLL1->setInstName ("SEL_ANT_PLL1");
  f_FCSI_SR0_SEL_ANT_PLL1->setLongName ("SELECTION ANTENNA PLL1");
  f_FCSI_SR0_SEL_ANT_PLL1->setDescription ("Antenna selection for PLL1 fast channel hopping");
  f_FCSI_SR0_SEL_ANT_PLL1->setDataWidth (2);
  f_FCSI_SR0_SEL_ANT_PLL1->setResetVal ("2'b00");
  f_FCSI_SR0_SEL_ANT_PLL1->setAccProp (AccProp::RW);
  r_FCSI_SR0->connectRField (f_FCSI_SR0_SEL_ANT_PLL1, 2);

  Attribute* a_FCSI_SR0_SEL_ANT_PLL1_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_SR0_SEL_ANT_PLL1_0_0->setInstName ("0");
  a_FCSI_SR0_SEL_ANT_PLL1_0_0->setLongName ("");
  a_FCSI_SR0_SEL_ANT_PLL1_0_0->setDescription ("");
  a_FCSI_SR0_SEL_ANT_PLL1_0_0->addItem("0", "2'b00", "Antenna 0");
  a_FCSI_SR0_SEL_ANT_PLL1_0_0->addItem("1", "2'b01", "Antenna 1");
  a_FCSI_SR0_SEL_ANT_PLL1_0_0->addItem("2", "2'b10", "Antenna 2");
  a_FCSI_SR0_SEL_ANT_PLL1_0_0->addItem("3", "2'b11", "Antenna 2");
  f_FCSI_SR0_SEL_ANT_PLL1->connectAttribute (a_FCSI_SR0_SEL_ANT_PLL1_0_0);

  Register* r_FCSI_SR1 = new Register;
  r_FCSI_SR1->setInstName ("SR1");
  r_FCSI_SR1->setLongName ("SHORT REGISTER 1");
  r_FCSI_SR1->setDescription ("FCSI-LDO1V2");
  r_FCSI_SR1->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_SR1, 0x00000001);

  Register* r_FCSI_SR2 = new Register;
  r_FCSI_SR2->setInstName ("SR2");
  r_FCSI_SR2->setLongName ("SHORT REGISTER 2");
  r_FCSI_SR2->setDescription ("FCSI-LDO1V2");
  r_FCSI_SR2->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_SR2, 0x00000002);

  RField* f_FCSI_SR2_fectl_C0 = new RField;
  f_FCSI_SR2_fectl_C0->setInstName ("fectl_C0");
  f_FCSI_SR2_fectl_C0->setLongName ("FECTL C0");
  f_FCSI_SR2_fectl_C0->setDescription ("Front end control C0");
  f_FCSI_SR2_fectl_C0->setDataWidth (1);
  f_FCSI_SR2_fectl_C0->setResetVal ("1'b0");
  f_FCSI_SR2_fectl_C0->setAccProp (AccProp::RW);
  r_FCSI_SR2->connectRField (f_FCSI_SR2_fectl_C0, 0);

  Attribute* a_FCSI_SR2_fectl_C0_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_SR2_fectl_C0_0_0->setInstName ("0");
  a_FCSI_SR2_fectl_C0_0_0->setLongName ("");
  a_FCSI_SR2_fectl_C0_0_0->setDescription ("");
  a_FCSI_SR2_fectl_C0_0_0->addItem("0", "1'b0", "disable");
  a_FCSI_SR2_fectl_C0_0_0->addItem("1", "1'b1", "enable");
  f_FCSI_SR2_fectl_C0->connectAttribute (a_FCSI_SR2_fectl_C0_0_0);

  RField* f_FCSI_SR2_fectl_C1 = new RField;
  f_FCSI_SR2_fectl_C1->setInstName ("fectl_C1");
  f_FCSI_SR2_fectl_C1->setLongName ("FECTL C1");
  f_FCSI_SR2_fectl_C1->setDescription ("Front end control C1");
  f_FCSI_SR2_fectl_C1->setDataWidth (1);
  f_FCSI_SR2_fectl_C1->setResetVal ("1'b0");
  f_FCSI_SR2_fectl_C1->setAccProp (AccProp::RW);
  r_FCSI_SR2->connectRField (f_FCSI_SR2_fectl_C1, 1);

  Attribute* a_FCSI_SR2_fectl_C1_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_SR2_fectl_C1_0_0->setInstName ("0");
  a_FCSI_SR2_fectl_C1_0_0->setLongName ("");
  a_FCSI_SR2_fectl_C1_0_0->setDescription ("");
  a_FCSI_SR2_fectl_C1_0_0->addItem("0", "1'b0", "disable");
  a_FCSI_SR2_fectl_C1_0_0->addItem("1", "1'b1", "enable");
  f_FCSI_SR2_fectl_C1->connectAttribute (a_FCSI_SR2_fectl_C1_0_0);

  RField* f_FCSI_SR2_fectl_C2 = new RField;
  f_FCSI_SR2_fectl_C2->setInstName ("fectl_C2");
  f_FCSI_SR2_fectl_C2->setLongName ("FECTL C2");
  f_FCSI_SR2_fectl_C2->setDescription ("Front end control C2");
  f_FCSI_SR2_fectl_C2->setDataWidth (1);
  f_FCSI_SR2_fectl_C2->setResetVal ("1'b0");
  f_FCSI_SR2_fectl_C2->setAccProp (AccProp::RW);
  r_FCSI_SR2->connectRField (f_FCSI_SR2_fectl_C2, 2);

  Attribute* a_FCSI_SR2_fectl_C2_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_SR2_fectl_C2_0_0->setInstName ("0");
  a_FCSI_SR2_fectl_C2_0_0->setLongName ("");
  a_FCSI_SR2_fectl_C2_0_0->setDescription ("");
  a_FCSI_SR2_fectl_C2_0_0->addItem("0", "1'b0", "disable");
  a_FCSI_SR2_fectl_C2_0_0->addItem("1", "1'b1", "enable");
  f_FCSI_SR2_fectl_C2->connectAttribute (a_FCSI_SR2_fectl_C2_0_0);

  RField* f_FCSI_SR2_fectl_C3 = new RField;
  f_FCSI_SR2_fectl_C3->setInstName ("fectl_C3");
  f_FCSI_SR2_fectl_C3->setLongName ("FECTL C3");
  f_FCSI_SR2_fectl_C3->setDescription ("Front end control C3");
  f_FCSI_SR2_fectl_C3->setDataWidth (1);
  f_FCSI_SR2_fectl_C3->setResetVal ("1'b0");
  f_FCSI_SR2_fectl_C3->setAccProp (AccProp::RW);
  r_FCSI_SR2->connectRField (f_FCSI_SR2_fectl_C3, 3);

  Attribute* a_FCSI_SR2_fectl_C3_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_SR2_fectl_C3_0_0->setInstName ("0");
  a_FCSI_SR2_fectl_C3_0_0->setLongName ("");
  a_FCSI_SR2_fectl_C3_0_0->setDescription ("");
  a_FCSI_SR2_fectl_C3_0_0->addItem("0", "1'b0", "disable");
  a_FCSI_SR2_fectl_C3_0_0->addItem("1", "1'b1", "enable");
  f_FCSI_SR2_fectl_C3->connectAttribute (a_FCSI_SR2_fectl_C3_0_0);

  RField* f_FCSI_SR2_fectl_C4 = new RField;
  f_FCSI_SR2_fectl_C4->setInstName ("fectl_C4");
  f_FCSI_SR2_fectl_C4->setLongName ("FECTL C4");
  f_FCSI_SR2_fectl_C4->setDescription ("Front end control C4");
  f_FCSI_SR2_fectl_C4->setDataWidth (1);
  f_FCSI_SR2_fectl_C4->setResetVal ("1'b0");
  f_FCSI_SR2_fectl_C4->setAccProp (AccProp::RW);
  r_FCSI_SR2->connectRField (f_FCSI_SR2_fectl_C4, 4);

  Attribute* a_FCSI_SR2_fectl_C4_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_SR2_fectl_C4_0_0->setInstName ("0");
  a_FCSI_SR2_fectl_C4_0_0->setLongName ("");
  a_FCSI_SR2_fectl_C4_0_0->setDescription ("");
  a_FCSI_SR2_fectl_C4_0_0->addItem("0", "1'b0", "disable");
  a_FCSI_SR2_fectl_C4_0_0->addItem("1", "1'b1", "enable");
  f_FCSI_SR2_fectl_C4->connectAttribute (a_FCSI_SR2_fectl_C4_0_0);

  RField* f_FCSI_SR2_fectl_C5 = new RField;
  f_FCSI_SR2_fectl_C5->setInstName ("fectl_C5");
  f_FCSI_SR2_fectl_C5->setLongName ("FECTL C5");
  f_FCSI_SR2_fectl_C5->setDescription ("Front end control C5");
  f_FCSI_SR2_fectl_C5->setDataWidth (1);
  f_FCSI_SR2_fectl_C5->setResetVal ("1'b0");
  f_FCSI_SR2_fectl_C5->setAccProp (AccProp::RW);
  r_FCSI_SR2->connectRField (f_FCSI_SR2_fectl_C5, 5);

  Attribute* a_FCSI_SR2_fectl_C5_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_SR2_fectl_C5_0_0->setInstName ("0");
  a_FCSI_SR2_fectl_C5_0_0->setLongName ("");
  a_FCSI_SR2_fectl_C5_0_0->setDescription ("");
  a_FCSI_SR2_fectl_C5_0_0->addItem("0", "1'b0", "disable");
  a_FCSI_SR2_fectl_C5_0_0->addItem("1", "1'b1", "enable");
  f_FCSI_SR2_fectl_C5->connectAttribute (a_FCSI_SR2_fectl_C5_0_0);

  RField* f_FCSI_SR2_fectl_C6 = new RField;
  f_FCSI_SR2_fectl_C6->setInstName ("fectl_C6");
  f_FCSI_SR2_fectl_C6->setLongName ("FECTL C6");
  f_FCSI_SR2_fectl_C6->setDescription ("Front end control C6");
  f_FCSI_SR2_fectl_C6->setDataWidth (1);
  f_FCSI_SR2_fectl_C6->setResetVal ("1'b0");
  f_FCSI_SR2_fectl_C6->setAccProp (AccProp::RW);
  r_FCSI_SR2->connectRField (f_FCSI_SR2_fectl_C6, 6);

  Attribute* a_FCSI_SR2_fectl_C6_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_SR2_fectl_C6_0_0->setInstName ("0");
  a_FCSI_SR2_fectl_C6_0_0->setLongName ("");
  a_FCSI_SR2_fectl_C6_0_0->setDescription ("");
  a_FCSI_SR2_fectl_C6_0_0->addItem("0", "1'b0", "disable");
  a_FCSI_SR2_fectl_C6_0_0->addItem("1", "1'b1", "enable");
  f_FCSI_SR2_fectl_C6->connectAttribute (a_FCSI_SR2_fectl_C6_0_0);

  RField* f_FCSI_SR2_fectl_C7 = new RField;
  f_FCSI_SR2_fectl_C7->setInstName ("fectl_C7");
  f_FCSI_SR2_fectl_C7->setLongName ("FECTL C7");
  f_FCSI_SR2_fectl_C7->setDescription ("Front end control C7");
  f_FCSI_SR2_fectl_C7->setDataWidth (1);
  f_FCSI_SR2_fectl_C7->setResetVal ("1'b0");
  f_FCSI_SR2_fectl_C7->setAccProp (AccProp::RW);
  r_FCSI_SR2->connectRField (f_FCSI_SR2_fectl_C7, 7);

  Attribute* a_FCSI_SR2_fectl_C7_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_SR2_fectl_C7_0_0->setInstName ("0");
  a_FCSI_SR2_fectl_C7_0_0->setLongName ("");
  a_FCSI_SR2_fectl_C7_0_0->setDescription ("");
  a_FCSI_SR2_fectl_C7_0_0->addItem("0", "1'b0", "disable");
  a_FCSI_SR2_fectl_C7_0_0->addItem("1", "1'b1", "enable");
  f_FCSI_SR2_fectl_C7->connectAttribute (a_FCSI_SR2_fectl_C7_0_0);

  RField* f_FCSI_SR2_fectl_ds_cx = new RField;
  f_FCSI_SR2_fectl_ds_cx->setInstName ("fectl_ds_cx");
  f_FCSI_SR2_fectl_ds_cx->setLongName ("FECTL DS Cx");
  f_FCSI_SR2_fectl_ds_cx->setDescription ("Front-end control driver strength Cx");
  f_FCSI_SR2_fectl_ds_cx->setDataWidth (1);
  f_FCSI_SR2_fectl_ds_cx->setResetVal ("1'b0");
  f_FCSI_SR2_fectl_ds_cx->setAccProp (AccProp::RW);
  r_FCSI_SR2->connectRField (f_FCSI_SR2_fectl_ds_cx, 8);

  Attribute* a_FCSI_SR2_fectl_ds_cx_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_SR2_fectl_ds_cx_0_0->setInstName ("0");
  a_FCSI_SR2_fectl_ds_cx_0_0->setLongName ("");
  a_FCSI_SR2_fectl_ds_cx_0_0->setDescription ("");
  a_FCSI_SR2_fectl_ds_cx_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_SR2_fectl_ds_cx_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_SR2_fectl_ds_cx->connectAttribute (a_FCSI_SR2_fectl_ds_cx_0_0);

  Register* r_FCSI_SR3 = new Register;
  r_FCSI_SR3->setInstName ("SR3");
  r_FCSI_SR3->setLongName ("SHORT REGISTER 3");
  r_FCSI_SR3->setDescription ("FCSI-LDO1V2");
  r_FCSI_SR3->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_SR3, 0x00000003);

  
}

