/**
* @file        MODULE_wrx654.cpp
* @author      klatzer
* @copyright   INTEL
*
* @briefwrx654
*
* This is a Spectool2 file.
*/

#include "MODULE_wrx654.h"
#include "MODULE_rf_antenna.h"
#include "MODULE_rf_antenna.h"
#include "MODULE_rf_antenna.h"
#include "MODULE_rf_antenna.h"
#include "MODULE_rf_central.h"

#include "IndirectAccessPort.h"
#include "Register.h"
#include "RField.h"
#include "Attribute.h"
#include "Format.h"
#include "Utilities.h"
#include "python/str.h"

MODULE_wrx654::MODULE_wrx654()
{
  ///////////////////////////
  //// MODULE PROPERTIES ////
  setBaseName ("wrx654");
  setLongName ("wrx654");
  setDescription ("");
  setContact ("klatzer");
  setFile (__FILE__);
  setGenerateGraphic(true);
  setIp(true);
  // addDocuLink("path to location", "description");
  // addDocuPicture("path to picture", "title");
  // addReference("module path to reference", "title");
  
  ////////////////////////////////////////////////////////////
  /// PORTS WHICH ARE CONTROLLED EXTERNALLY (INPUT PORTS) ////
  
  ///////////////////////////////////////////////////
  /// PORTS WHICH ARE CONTROLLING EXTERNAL PORTS (OUTPUT PORTS) ////
  
  /////////////////////
  //// SUB-MODULES ////
  MODULE_rf_antenna* m_RF_ANTENNA0 = new MODULE_rf_antenna;
  m_RF_ANTENNA0->setInstName ("RF_ANTENNA0");
  connectModule (m_RF_ANTENNA0);

  MODULE_rf_antenna* m_RF_ANTENNA1 = new MODULE_rf_antenna;
  m_RF_ANTENNA1->setInstName ("RF_ANTENNA1");
  connectModule (m_RF_ANTENNA1);

  MODULE_rf_antenna* m_RF_ANTENNA2 = new MODULE_rf_antenna;
  m_RF_ANTENNA2->setInstName ("RF_ANTENNA2");
  connectModule (m_RF_ANTENNA2);

  MODULE_rf_antenna* m_RF_ANTENNA3 = new MODULE_rf_antenna;
  m_RF_ANTENNA3->setInstName ("RF_ANTENNA3");
  connectModule (m_RF_ANTENNA3);

  MODULE_rf_central* m_CENTRAL = new MODULE_rf_central;
  m_CENTRAL->setInstName ("CENTRAL");
  connectModule (m_CENTRAL);

  
  ////////////////////////
  //// INTERNAL PORTS ////
  Port* p_FCSI0 = new Port (this);
  p_FCSI0->setInstName ("FCSI0");
  p_FCSI0->setLongName ("Single Antenna FCSI Interface");
  p_FCSI0->setDescription ("");
  p_FCSI0->setAddrBase (16);
  p_FCSI0->setDataWidth (16);
  p_FCSI0->setAddrSpace (0x00080000);
  p_FCSI0->setAccess (AddressableNode::RW);
  p_FCSI0->setOffsetAsView(0x00000000);
  p_FCSI0->setAllowAddrOverlap(false);
  p_FCSI0->setAddrAlignCheck(AddressableNode::AAC_AUTO_OFF);
  p_FCSI0->setBusProtocol (Bus::FCSI);
  p_FCSI0->setCollapse (false);

  Attribute* a_FCSI0_0_0 = new Attribute(Attribute::CONST);
  a_FCSI0_0_0->setInstName ("0");
  a_FCSI0_0_0->setLongName ("");
  a_FCSI0_0_0->setDescription ("");
  a_FCSI0_0_0->addItem("antennaNo", "32'b00000000000000000000000000000000", "");
  p_FCSI0->connectAttribute (a_FCSI0_0_0);

  Port* p_FCSI1 = new Port (this);
  p_FCSI1->setInstName ("FCSI1");
  p_FCSI1->setLongName ("Single Antenna FCSI Interface");
  p_FCSI1->setDescription ("");
  p_FCSI1->setAddrBase (16);
  p_FCSI1->setDataWidth (16);
  p_FCSI1->setAddrSpace (0x00080000);
  p_FCSI1->setAccess (AddressableNode::RW);
  p_FCSI1->setOffsetAsView(0x00000000);
  p_FCSI1->setAllowAddrOverlap(false);
  p_FCSI1->setAddrAlignCheck(AddressableNode::AAC_AUTO_OFF);
  p_FCSI1->setBusProtocol (Bus::FCSI);
  p_FCSI1->setCollapse (false);

  Attribute* a_FCSI1_0_0 = new Attribute(Attribute::CONST);
  a_FCSI1_0_0->setInstName ("0");
  a_FCSI1_0_0->setLongName ("");
  a_FCSI1_0_0->setDescription ("");
  a_FCSI1_0_0->addItem("antennaNo", "32'b00000000000000000000000000000001", "");
  p_FCSI1->connectAttribute (a_FCSI1_0_0);

  Port* p_FCSI2 = new Port (this);
  p_FCSI2->setInstName ("FCSI2");
  p_FCSI2->setLongName ("Single Antenna FCSI Interface");
  p_FCSI2->setDescription ("");
  p_FCSI2->setAddrBase (16);
  p_FCSI2->setDataWidth (16);
  p_FCSI2->setAddrSpace (0x00080000);
  p_FCSI2->setAccess (AddressableNode::RW);
  p_FCSI2->setOffsetAsView(0x00000000);
  p_FCSI2->setAllowAddrOverlap(false);
  p_FCSI2->setAddrAlignCheck(AddressableNode::AAC_AUTO_OFF);
  p_FCSI2->setBusProtocol (Bus::FCSI);
  p_FCSI2->setCollapse (false);

  Attribute* a_FCSI2_0_0 = new Attribute(Attribute::CONST);
  a_FCSI2_0_0->setInstName ("0");
  a_FCSI2_0_0->setLongName ("");
  a_FCSI2_0_0->setDescription ("");
  a_FCSI2_0_0->addItem("antennaNo", "32'b00000000000000000000000000000010", "");
  p_FCSI2->connectAttribute (a_FCSI2_0_0);

  Port* p_FCSI3 = new Port (this);
  p_FCSI3->setInstName ("FCSI3");
  p_FCSI3->setLongName ("Single Antenna FCSI Interface");
  p_FCSI3->setDescription ("");
  p_FCSI3->setAddrBase (16);
  p_FCSI3->setDataWidth (16);
  p_FCSI3->setAddrSpace (0x00080000);
  p_FCSI3->setAccess (AddressableNode::RW);
  p_FCSI3->setOffsetAsView(0x00000000);
  p_FCSI3->setAllowAddrOverlap(false);
  p_FCSI3->setAddrAlignCheck(AddressableNode::AAC_AUTO_OFF);
  p_FCSI3->setBusProtocol (Bus::FCSI);
  p_FCSI3->setCollapse (false);

  Attribute* a_FCSI3_0_0 = new Attribute(Attribute::CONST);
  a_FCSI3_0_0->setInstName ("0");
  a_FCSI3_0_0->setLongName ("");
  a_FCSI3_0_0->setDescription ("");
  a_FCSI3_0_0->addItem("antennaNo", "32'b00000000000000000000000000000011", "");
  p_FCSI3->connectAttribute (a_FCSI3_0_0);

  Port* p_CENTRAL = new Port (this);
  p_CENTRAL->setInstName ("CENTRAL");
  p_CENTRAL->setLongName ("RF CENTRAL");
  p_CENTRAL->setDescription ("RF CENTRAL FCSI-Interface");
  p_CENTRAL->setAddrBase (16);
  p_CENTRAL->setDataWidth (16);
  p_CENTRAL->setAddrSpace (0x00080000);
  p_CENTRAL->setAccess (AddressableNode::RW);
  p_CENTRAL->setOffsetAsView(0x00000000);
  p_CENTRAL->setAllowAddrOverlap(false);
  p_CENTRAL->setAddrAlignCheck(AddressableNode::AAC_AUTO_OFF);
  p_CENTRAL->setBusProtocol (Bus::FCSI);
  p_CENTRAL->setCollapse (false);

  
  ////////////////////////
  //// INTERNAL BUSES ////
  Bus* b_FCSI0 = new Bus (this);
  b_FCSI0->setInstName ("FCSI0");
  b_FCSI0->setLongName ("Single Antenna FCSI Interface");
  b_FCSI0->setDescription ("");
  b_FCSI0->setAddrBase (16);
  b_FCSI0->setDataWidth (16);
  b_FCSI0->setAddrSpace (0x00080000);
  b_FCSI0->setAccess (AddressableNode::RW);
  b_FCSI0->setAllowAddrOverlap(false);
  b_FCSI0->setAddrAlignCheck(AddressableNode::AAC_AUTO_OFF);
  b_FCSI0->setBusProtocol (Bus::FCSI);

  p_FCSI0->connectBus (b_FCSI0, 0x00000000);
  b_FCSI0->connectSlavePort (m_RF_ANTENNA0->getPort("FCSI"), 0x00000000);

  Attribute* a_FCSI0_0_0 = new Attribute(Attribute::CONST);
  a_FCSI0_0_0->setInstName ("0");
  a_FCSI0_0_0->setLongName ("");
  a_FCSI0_0_0->setDescription ("");
  a_FCSI0_0_0->addItem("antennaNo", "32'b00000000000000000000000000000000", "");
  b_FCSI0->connectAttribute (a_FCSI0_0_0);

  Bus* b_FCSI1 = new Bus (this);
  b_FCSI1->setInstName ("FCSI1");
  b_FCSI1->setLongName ("Single Antenna FCSI Interface");
  b_FCSI1->setDescription ("");
  b_FCSI1->setAddrBase (16);
  b_FCSI1->setDataWidth (16);
  b_FCSI1->setAddrSpace (0x00080000);
  b_FCSI1->setAccess (AddressableNode::RW);
  b_FCSI1->setAllowAddrOverlap(false);
  b_FCSI1->setAddrAlignCheck(AddressableNode::AAC_AUTO_OFF);
  b_FCSI1->setBusProtocol (Bus::FCSI);

  p_FCSI1->connectBus (b_FCSI1, 0x00000000);
  b_FCSI1->connectSlavePort (m_RF_ANTENNA1->getPort("FCSI"), 0x00000000);

  Attribute* a_FCSI1_0_0 = new Attribute(Attribute::CONST);
  a_FCSI1_0_0->setInstName ("0");
  a_FCSI1_0_0->setLongName ("");
  a_FCSI1_0_0->setDescription ("");
  a_FCSI1_0_0->addItem("antennaNo", "32'b00000000000000000000000000000001", "");
  b_FCSI1->connectAttribute (a_FCSI1_0_0);

  Bus* b_FCSI2 = new Bus (this);
  b_FCSI2->setInstName ("FCSI2");
  b_FCSI2->setLongName ("Single Antenna FCSI Interface");
  b_FCSI2->setDescription ("");
  b_FCSI2->setAddrBase (16);
  b_FCSI2->setDataWidth (16);
  b_FCSI2->setAddrSpace (0x00080000);
  b_FCSI2->setAccess (AddressableNode::RW);
  b_FCSI2->setAllowAddrOverlap(false);
  b_FCSI2->setAddrAlignCheck(AddressableNode::AAC_AUTO_OFF);
  b_FCSI2->setBusProtocol (Bus::FCSI);

  p_FCSI2->connectBus (b_FCSI2, 0x00000000);
  b_FCSI2->connectSlavePort (m_RF_ANTENNA2->getPort("FCSI"), 0x00000000);

  Attribute* a_FCSI2_0_0 = new Attribute(Attribute::CONST);
  a_FCSI2_0_0->setInstName ("0");
  a_FCSI2_0_0->setLongName ("");
  a_FCSI2_0_0->setDescription ("");
  a_FCSI2_0_0->addItem("antennaNo", "32'b00000000000000000000000000000010", "");
  b_FCSI2->connectAttribute (a_FCSI2_0_0);

  Bus* b_FCSI3 = new Bus (this);
  b_FCSI3->setInstName ("FCSI3");
  b_FCSI3->setLongName ("Single Antenna FCSI Interface");
  b_FCSI3->setDescription ("");
  b_FCSI3->setAddrBase (16);
  b_FCSI3->setDataWidth (16);
  b_FCSI3->setAddrSpace (0x00080000);
  b_FCSI3->setAccess (AddressableNode::RW);
  b_FCSI3->setAllowAddrOverlap(false);
  b_FCSI3->setAddrAlignCheck(AddressableNode::AAC_AUTO_OFF);
  b_FCSI3->setBusProtocol (Bus::FCSI);

  p_FCSI3->connectBus (b_FCSI3, 0x00000000);
  b_FCSI3->connectSlavePort (m_RF_ANTENNA3->getPort("FCSI"), 0x00000000);

  Attribute* a_FCSI3_0_0 = new Attribute(Attribute::CONST);
  a_FCSI3_0_0->setInstName ("0");
  a_FCSI3_0_0->setLongName ("");
  a_FCSI3_0_0->setDescription ("");
  a_FCSI3_0_0->addItem("antennaNo", "32'b00000000000000000000000000000011", "");
  b_FCSI3->connectAttribute (a_FCSI3_0_0);

  Bus* b_CENTRAL = new Bus (this);
  b_CENTRAL->setInstName ("CENTRAL");
  b_CENTRAL->setLongName ("RF CENTRAL");
  b_CENTRAL->setDescription ("RF CENTRAL FCSI-Interface");
  b_CENTRAL->setAddrBase (16);
  b_CENTRAL->setDataWidth (16);
  b_CENTRAL->setAddrSpace (0x00080000);
  b_CENTRAL->setAccess (AddressableNode::RW);
  b_CENTRAL->setAllowAddrOverlap(false);
  b_CENTRAL->setAddrAlignCheck(AddressableNode::AAC_AUTO_OFF);
  b_CENTRAL->setBusProtocol (Bus::FCSI);

  p_CENTRAL->connectBus (b_CENTRAL, 0x00000000);
  b_CENTRAL->connectSlavePort (m_CENTRAL->getPort("FCSI"), 0x00000000);

  
  //////////////////////////////
  //// REGISTERS AND FIELDS ////
  
}

