/**
* @file        PROJECT_wrx654_system.cpp
* @author      nuk
* @copyright   INTEL
*
* @briefSpectool2 Template Generator
*
* This is a Spectool2 file.
*/

#ifndef PROJECT_WRX654_SYSTEM_CPP
#define PROJECT_WRX654_SYSTEM_CPP

#include <Project.h>

class PROJECT_wrx654_system : public Project
{
public:
  virtual int main(int argc, char* argv[]);
};

#include "EXPORT.h"

#include "MODULE_wrx654.h"

int PROJECT_wrx654_system::main(int argc, char* argv[])
{
  System* s_system = new System;
  s_system->setInstName("wrx654_system");
  s_system->setLongName("Spectool2 Template Generator");
  s_system->setContact("nuk");
  s_system->setGenerateGraphic(true);
  
  MODULE_wrx654* m_wrx654 = new MODULE_wrx654;
  m_wrx654->setInstName ("wrx654");
  s_system->connectModule (m_wrx654);

  s_system->connectView(s_system->findModule("wrx654"));
  
  // FIND OUT MORE ABOUT EXPORT OPTIONS VIA COMMAND LINE: > spectool2 help --exporters
  EXPORT exporter;
  exporter.setOption("GraphViz", "links", "true");
  exporter.setOption("GraphViz", "svg", "true");
  exporter.select("AGGBUILDER, ARCASM, BBS, C, CRegArrays, FMXML, GraphViz, HTML, IPXACT, LSDXML, MLABREGS, PER, REFIGE, SPECTOOL2, SystemRDL, SystemVerilog_BH, TTY, UVM, VHDL, Verilog, e");
  exporter(s_system);
  
  return(0);
}

static PROJECT_wrx654_system prj_wrx654_system;

#endif /* PROJECT_WRX654_SYSTEM_CPP <<  */
