function [sT0, sTop, sTn] = pgc_filter_cal_accurate(oWRX, vHdB, vN, sH0dB, sFm, sGmdB)

if nargin < 6
    sGmdB = 20;
end

if nargin < 5
    sFm = 50e6;
end

if nargin < 4
    sH0dB = 0;
end

if ~iscolumn(vN)
    vN = vN';
end

if ~iscolumn(vHdB)
    vHdB = vHdB';
end

sWm = 2*pi*sFm*1e-9;     % calculate with GHz to get Time Constants in ns
sGm = 10^(sGmdB/20);
iC = 63-vN;

% sT0 = 250*0.11e-3;
% sTn = 250*20*100e-6;
% sTop = 1.5e-1;
% vHinv2 = sGm^2*sT0^2*sTop^2*iC.^2*sWm.^4 + sGm^2*sT0^2*iC.^2*sWm.^2 + 2*sGm^2*sT0*sTn*sTop^2*iC*sWm.^4 + 2*sGm^2*sT0*sTop*iC*sWm.^2 + sGm^2*sTn^2*sTop^2*sWm.^4 + sGm^2*sTop^2*sWm.^2 - 2*sGm*sTn*sTop*sWm.^2 + 2*sGm*sTop^2*sWm.^2 + sTop^2*sWm.^2 + 1;

vHinv2 = 1./10.^((vHdB-sH0dB)/10);

% vHinv2 = [19.679 7.936 1.8222]';

vUsb(1) = (vHinv2(1)*iC(2) - vHinv2(1)*iC(3) - vHinv2(2)*iC(1) + vHinv2(2)*iC(3) + vHinv2(3)*iC(1) - vHinv2(3)*iC(2))/(sGm^2*sWm^2*(iC(1) - iC(2))*(iC(1)*iC(2) - iC(1)*iC(3) - iC(2)*iC(3) + iC(3)^2));
vUsb(2) = -(vHinv2(1)*iC(2)^2 - vHinv2(1)*iC(3)^2 - vHinv2(2)*iC(1)^2 + vHinv2(2)*iC(3)^2 + vHinv2(3)*iC(1)^2 - vHinv2(3)*iC(2)^2)/(2*sGm^2*sWm^2*(iC(1) - iC(2))*(iC(1)*iC(2) - iC(1)*iC(3) - iC(2)*iC(3) + iC(3)^2));
vUsb(3) = (iC(1)*iC(2)^2 - iC(1)^2*iC(2) - iC(1)*iC(3)^2 + iC(1)^2*iC(3) + iC(2)*iC(3)^2 - iC(2)^2*iC(3) - vHinv2(1)*iC(2)*iC(3)^2 + vHinv2(1)*iC(2)^2*iC(3) + vHinv2(2)*iC(1)*iC(3)^2 - vHinv2(2)*iC(1)^2*iC(3) - vHinv2(3)*iC(1)*iC(2)^2 + vHinv2(3)*iC(1)^2*iC(2))/(sWm^2*(iC(1) - iC(2))*(iC(1)*iC(2) - iC(1)*iC(3) - iC(2)*iC(3) + iC(3)^2));

% mA = [  sGm^2*iC(1)^2*sWm^2      2*sGm^2*iC(1)*sWm^2        sWm^2;...
%         sGm^2*iC(2)^2*sWm^2      2*sGm^2*iC(2)*sWm^2        sWm^2;...
%         sGm^2*iC(3)^2*sWm^2      2*sGm^2*iC(3)*sWm^2        sWm^2];
%     
% vb = vHinv2-1;
% 
% 
% vUeq = mA\vb;

P = [-(1+sGm)^2*vUsb(1)*sWm^4,  0,  vUsb(1)*vUsb(3)*sWm^4-sGm^2*vUsb(1)*sWm^2+vUsb(1)*sWm^2*(sGm + 1)^2-2*sGm*vUsb(1)*sWm^2,...
    (1+sGm)*sGm*vUsb(2)*sqrt(vUsb(1))*sWm^2,  vUsb(1)*(sGm^2+2*sGm-vUsb(3)*sWm^2), -2*sGm*(sGm+1)*vUsb(2)*sqrt(vUsb(1)),  sGm^2*vUsb(2)^2];
vRoots = roots(P);

sTop = vRoots(5); % ??? not sure if it's always the 5th zero
sT0 = sqrt(vUsb(1)/(1+sWm^2*sTop^2));
sTn = (vUsb(2)/(sT0*sTop)-1)/(sTop*sWm^2);

sT0 = sT0*1e-9;
sTop = sTop*1e-9;
sTn = sTn*1e-9;
