function [vN, vNfrac] = pgc_filtidx_accurate(~, vPgcGaindB, sFcMHz, sT0, sTop, sTn);

sWm = 2*pi*sFcMHz*1e6;

nN = length(vPgcGaindB);

vN = zeros(1,nN);
vNfrac = zeros(1,nN);

for iN = 1:nN 
    sGm = 10^(vPgcGaindB(iN)/20);
    
    sA = sGm^2*sT0^2*sTop^2*sWm.^4 + sGm^2*sT0^2*sWm.^2;
    sB = 2*sGm^2*sT0*sTn*sTop^2*sWm.^4 + 2*sGm^2*sT0*sTop*sWm.^2;
    sC = sGm^2*sTn^2*sTop^2*sWm.^4 + sGm^2*sTop^2*sWm.^2 - 2*sGm*sTn*sTop*sWm.^2 + 2*sGm*sTop^2*sWm.^2 + sTop^2*sWm.^2 + 1 - 2;
    
    p = sB/sA;
    q = sC/sA;
    
    vRoots = zeros(2,1);
    vRoots(1) = -p/2 + sqrt(p^2/4 - q);
    vRoots(2) = -p/2 - sqrt(p^2/4 - q);
        
    vNfrac(iN) = max(0, 63 - min(63, vRoots(vRoots>0)));
    vN(iN) = round(vNfrac(iN));    
end