function [rStatus, vRead, vWrite] = FCSI_RMW(sAntMsk, sRegAdr, sBitMsk, xRegData, bDebug)
% FTDI_FCSI_RMW - USB Read+Modify+Write function for WRX6xx Level1 Test Board
    
% --- Authors -------------------------------------------------------------
% Steffen Trautmann
% -------------------------------------------------------------------------
    
% --- Copyright -----------------------------------------------------------
% Intel Austria GmbH, Connected Home Division, Villach
% -------------------------------------------------------------------------

global bbs
if (prod(size(bbs))>0)
    if length(xRegData) == 1
        X = sprintf('AntMsk:  b%s reg: 0x%04x bitmask 0x%04x data: 0x%04x ', dec2bin(sAntMsk,4), sRegAdr, sBitMsk, xRegData);
        disp(X);
        cmdstrs={['@RFIC_FCSI_RMW(b' dec2bin(sAntMsk) ',h' dec2hex(sRegAdr) ',h' dec2hex(sBitMsk)  ',h' dec2hex(xRegData) ')']};
    else
        X = sprintf('AntMsk:  b%s reg: 0x%04x bitmask 0x%04x data: 0x%04x/0x%04x/0x%04x/0x%04x', dec2bin(sAntMsk,4), sRegAdr, sBitMsk, xRegData(1:4));
        disp(X);
        cmdstrs={['@RFIC_FCSI_ParRMW(b' dec2bin(sAntMsk) ',h' dec2hex(sRegAdr) ',h' dec2hex(sBitMsk)  ',@_(h' dec2hex(xRegData(1)) ',h' dec2hex(xRegData(2))  ',h' dec2hex(xRegData(3))  ',h' dec2hex(xRegData(4)) '))']};
    end
    bbswrite(cmdstrs)
    disp(cmdstrs)
    return
end

if nargin < 5
    bDebug = 0;
end

% check dimension of xRegData
nAnt = 5;
if length(xRegData) == 1
    xRegData = repmat(xRegData, nAnt, 1);
end
xRegData = reshape(xRegData, nAnt, 1);

% check for ultrashort register
if sRegAdr < 4
    if sRegAdr == 3
        bUltraShort = 1;
    else
        bUltraShort = 0;
    end
else
    bUltraShort = 0;
end

% determine data length
nDataLen = 16 - bUltraShort*14;

% status output
vAntNo = {'0' '1' '2' '3' 'Central'};
tAnt = sprintf('%s+',vAntNo{logical(bitget(sAntMsk,[1:5]))}); tAnt = tAnt(1:end-1);
tAdr = sprintf('0x%02x', sRegAdr);
tMsk = sprintf('0x%04x', sBitMsk);
tData = sprintf('0x%04x,', xRegData(logical(bitget(sAntMsk,[1:5])))); tData = tData(1:end-1);
fprintf('RMW from/to  Ant %s: Address %s - Mask %s | %s ...\n', tAnt, tAdr, tMsk, tData);

% read the former register content
vRead = FCSI_READ(sAntMsk, sRegAdr, bDebug);

% bit-wise combination of changed and unchanged register content
vWrite = bitand(vRead, sBitMsk) + bitand(xRegData, 2^(nDataLen)-1 - sBitMsk);

% write to selected registers
FCSI_WRITE(sAntMsk, sRegAdr, vWrite, bDebug);

clear bbs
