function rStatus = FCSI_WRIT(sAntMsk, sRegAdr, xRegData, bDebug)
% FTDI_FCSI_WRITE - USB Write function for WRX6xx Level1 Test Board
    
% --- Authors -------------------------------------------------------------
% Steffen Trautmann, Denis Matveev
% -------------------------------------------------------------------------
    
% --- Copyright -----------------------------------------------------------
% Intel Austria GmbH, Connected Home Division, Villach
% -------------------------------------------------------------------------

global bbs
if (prod(size(bbs))>0)
    if length(xRegData) == 1
        X = sprintf('AntMsk:  b%s reg: 0x%04x data: 0x%04x ', dec2bin(sAntMsk,4), sRegAdr, xRegData);
        disp(X);
        cmdstrs={['@RFIC_FCSI_WRITE(b' dec2bin(sAntMsk) ',h' dec2hex(sRegAdr) ',h' dec2hex(xRegData) ')']};
    else
        X = sprintf('AntMsk:  b%s reg: 0x%04x data: 0x%04x/0x%04x/0x%04x/0x%04x', dec2bin(sAntMsk,4), sRegAdr, xRegData(1:4));
        disp(X);
        cmdstrs={['@RFIC_FCSI_ParWRITE(b' dec2bin(sAntMsk) ',h' dec2hex(sRegAdr) ',@_(h' dec2hex(xRegData(1)) ',h' dec2hex(xRegData(2))  ',h' dec2hex(xRegData(3))  ',h' dec2hex(xRegData(4)) '))']};
    end
    bbswrite(cmdstrs)
    disp(cmdstrs)
    return
end

% debugging on/off
if nargin < 4
    bDebug = 0;
end
bPlot = 0;

% check dimension of xRegData
nAnt = 5;
if length(xRegData) == 1
    xRegData = repmat(xRegData, nAnt, 1);
end
xRegData = reshape(xRegData, nAnt, 1);

% check for address range
if sRegAdr < 4
    bShort = 1;
    if sRegAdr == 3
        bUltraShort = 1;
    else
        bUltraShort = 0;
    end
elseif sRegAdr >= 64
    bShort = 0;
    bUltraShort = 0;
else
    error('Address 0x%x is not defined!',sRegAdr);
end

% determine address and data length
nAdrLen = 7 - bShort*4;
nDataLen = 16 - bUltraShort*14;

% calculate number of clock half cycles
nCycles = (nAdrLen + nDataLen + 7) * 2 - 1;

% prepare variables and mask vector 
vClk = zeros(nAnt, nCycles);
vEnable = zeros(nAnt, nCycles);
vData = zeros(nAnt, nCycles);

vAntMsk = zeros(nAnt, 1);
for iA = 1:nAnt
    vAntMsk(iA) = bitget(sAntMsk,iA);
end

% generate clock and enables for each antenna 
vClk(:,2:2:end) = repmat(vAntMsk, 1, floor(nCycles/2));
vEnable(:,4:nCycles-4) = repmat(vAntMsk, 1, nCycles-7);

% generate address+data sequence for each antenna
for iAl = 1:nAdrLen
    vData(:, 2+2*iAl:3+2*iAl) = repmat(vAntMsk * bitget(sRegAdr, nAdrLen+1-iAl),1,2);
end
for iDl = 1:nDataLen
    vData(:, 4+2*nAdrLen+2*iDl:5+2*nAdrLen+2*iDl) = repmat(vAntMsk .* bitget(xRegData, nDataLen+1-iDl),1,2);
end
  
% construct the parallel output to the USB interface
mUsbOut = zeros(nAnt*3, nCycles);
mUsbOut(1:3:end,:) = vEnable;
mUsbOut(2:3:end,:) = vClk;
mUsbOut(3:3:end,:) = vData;

% status output
vAntNo = {'0' '1' '2' '3' 'Central'};
tAnt = sprintf('%s+',vAntNo{logical(bitget(sAntMsk,[1:5]))}); tAnt = tAnt(1:end-1);
tAdr = sprintf('0x%02x', sRegAdr);
tData = sprintf('0x%04x,', xRegData(logical(bitget(sAntMsk,[1:5])))); tData = tData(1:end-1);
fprintf('Writing to   Ant %s: Address %s - %s ...\n', tAnt, tAdr, tData);

% writing in Test or USB mode
tLeg = {'En' 'Clk' 'Data'};
if bDebug
    if bPlot
        figure;
        subplot(3*nAnt,1,1);
        for iA = 1:nAnt
            for iW = 1:3
                oAx = subplot(3*nAnt,1,3*(iA-1)+iW);
                plot([0 kron(1:nCycles-1,ones(1,2)) nCycles],kron(mUsbOut(3*(iA-1)+iW,:),ones(1,2)),'linewidth',2);
%                 oAx.XLim = [0 nCycles];
%                 oAx.YLim = [0 1];
%                 oAx.YTick = [0 1];
                xlim([0 nCycles]);
                ylim([0 1]);
                set(gca,'YTick',[0 1]);
                if iA < nAnt
                    ylabel(sprintf('%s%d',tLeg{iW},iA-1));
                else
                    ylabel(sprintf('%sC',tLeg{iW}));
                end
                hold on; grid on;
            end
        end
        set(gcf,'position',[680 100 560 818]);
    end
    rStatus = 0;
else    
    % combine bit streams to parallel words
    vUsbOutPar_A = uint8(2.^([0:7])*mUsbOut(1:8,:)); 
    vUsbOutPar_B = uint8(2.^([0:6])*mUsbOut(9:15,:)); 

    h1=FTD2XX_NET.FTDI; h2=FTD2XX_NET.FTDI;
    rc = OpenByIndex(h1,0);rc = OpenByIndex(h2,1);
    rc = SetBaudRate(h1, 115200); rc = SetBaudRate(h2, 115200); 
    rc = SetBitMode(h1,255,1); rc = SetBitMode(h2,255,1);
    for i=1:nCycles
        rc = Write(h1, vUsbOutPar_A(i), 1, 0); 
        rc = Write(h2, vUsbOutPar_B(i), 1, 0);
    end;
    rc = Close(h1);rc = Close(h2);


end;
