#ifndef _INTERFACE_INTERFACE_WRX654_H
#define _INTERFACE_INTERFACE_WRX654_H

/* register packages */
#include "wrx654_fcsi0_addrmap.h"
#include "wrx654_fcsi0_regpkg.h"
#include "wrx654_rf_antenna_fcsi_fieldpkg.h"
#include "wrx654_rf_antenna_fcsi_regpkg.h"
#include "wrx654_fcsi1_addrmap.h"
#include "wrx654_fcsi1_regpkg.h"
#include "wrx654_fcsi2_addrmap.h"
#include "wrx654_fcsi2_regpkg.h"
#include "wrx654_fcsi3_addrmap.h"
#include "wrx654_fcsi3_regpkg.h"
#include "wrx654_central_addrmap.h"
//#include "wrx654_central_regpkg.h"
#include "wrx654_rf_central_fcsi_fieldpkg.h"
#include "wrx654_rf_central_fcsi_regpkg.h"

#define RFIC_FCSI_RMW(antenna, address, mask, value) RFIC_FCSI_RMW_mex(antenna, address, mask, value)
#define RFIC_FCSI_Read(antenna, address, data) RFIC_FCSI_Read_mex(antenna, address, data)
#define RFIC_FCSI_Write(antenna, address, value) RFIC_FCSI_Write_mex(antenna, address, value)
#define RFIC_FCSI_ParRMW(antenna, address, mask, values) RFIC_FCSI_ParRMW_mex(antenna, address, mask, values)
#define RFIC_FCSI_ParWrite(antenna, address, values) RFIC_FCSI_ParWrite_mex(antenna, address, values)
#define debug_printf  mexPrintf

// wait function
void RFIC_Wait(uint32_t cnt);

void RFIC_FCSI_Write_mex(uint16_t antenna, uint16_t address,uint16_t value);
uint16_t RFIC_FCSI_Read_mex(uint16_t antenna, uint16_t address, uint16_t *data);
void RFIC_FCSI_RMW_mex(uint16_t antenna,uint16_t  address,uint16_t mask, uint16_t value);
void RFIC_FCSI_ParWrite_mex(uint16_t antenna, uint16_t address,uint16_t *values);
void RFIC_FCSI_ParRMW_mex(uint16_t antenna,uint16_t  address,uint16_t mask, uint16_t *values);
#endif //  _INTERFACE_H
