#include "mex.h"
#include <math.h>
#include <stdint.h>
#include <string.h>
#include "lib_wrx654_api.c"
#include "lib_wrx654_api.h"
#include "lib_wrx654_sequences.c"
#include "lib_wrx654_sequences.h"

// Debug mode on/off
#define DEBUG 0

// The gateway function
void check_parameter(int nParamA, int nParamW)
{
    if (nParamA < nParamW+1)      //1- api_sting, 2-parameter1, 3-...
            mexErrMsgTxt("Wrong amount of parameters detected.");
}


void mexFunction( int nlhs, mxArray *plhs[],
        int nrhs, const mxArray *prhs[])
{
    char *input_buf;
    size_t buflen;
    uint16_t    iF, iFct, iK, iL;
    uint8_t     iPar, bFound;
    uint16_t    nFunc, nFuncI, nFuncR, sOut;
    uint16_t    *softfuse_data;
    uint16_t    int16_data[16];
    int8_t      ParData[6][4];
    uint16_t    PgcFc[5];
    uint16_t    BandSel[5];
    uint8_t     PgcFiltLut[5][11];
    uint8_t     Fectl[4];
    double      double_data[16];

    void        (*pApi[1000])();
    char        *tApi[1000];
    uint8_t     nPar[1000];
    char        *tPar[1000][32];
    int         vPar[32];

    uint16_t    (*pApiI[100])();
    char        *tApiI[100];
    uint8_t     nParI[100];
    char        *tParI[100][32];

    void        (*pApiR[100])();
    char        *tApiR[100];
    uint8_t     nParR[100];
    char        *tParR[100][32];

    mxArray     *FieldVal;
    int         FieldIdx[20];
    double      LoFreqsDbl[6], ArrTmpDbl[20], MatTmpDbl[20][20];

    const char  *PllCfgFieldNames[] = {"Active", "Reset", "HbLb", "LoFreqs", "LoFreqAct", "RefClk", "IntFrac", "HiPwr", "AntSet", "FastHop", "FhMaster"};
    pll_config  PllCfg;
    mwSize      PllCfgDim[2] = {1, 1};

    const char  *RxGainCfgFieldNames[] = {"LnaGainCfg", "FectlCfg", "RfGainIdx", "RssiRange", "PgcGainIdx", "PgcFiltIdx", "ShortReg3", "ForceOff", "DirStepIdx"};
    rx_gain_cfg RxGainCfg;
    mwSize      RxGainCfgDim[2] = {1, 1};

    buflen = (mxGetM(prhs[0]) * mxGetN(prhs[0])) + 1;
    input_buf = mxArrayToString(prhs[0]);

    iF = 0;
    bFound = 0;

    // ***********************************************
    // *         API FUNCTIONS WITHOUT OUTPUT        *
    // ***********************************************
    // Function Pointer                         Function Name                               No. of Pars     Parameter Names
    // Initialization
    pApi[iF] = (void (*)()) &rfic_init_1;                    tApi[iF] = "rfic_init_1";                   nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_init_2;                  tApi[iF] = "rfic_init_2";                   nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_init_3;                  tApi[iF] = "rfic_init_3";                   nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_init_3_lb_only;          tApi[iF] = "rfic_init_3_lb_only";           nPar[iF] = 0;
    pApi[++iF] = (void (*)()) &rfic_init_3_hb_only;          tApi[iF] = "rfic_init_3_hb_only";           nPar[iF] = 0;
    // RX/TX switching
    pApi[++iF] = (void (*)()) &rfic_rxon;                    tApi[iF] = "rfic_rxon";                     nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_rxoff;                   tApi[iF] = "rfic_rxoff";                    nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_txon;                    tApi[iF] = "rfic_txon";                     nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_txoff;                   tApi[iF] = "rfic_txoff";                    nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    // FSYS2 clock
    pApi[++iF] = (void (*)()) &rfic_enable_fsys2;            tApi[iF] = "rfic_enable_fsys2";             nPar[iF] = 0;
    pApi[++iF] = (void (*)()) &rfic_disable_fsys2;           tApi[iF] = "rfic_disable_fsys2";            nPar[iF] = 0;
    // DCXO
    pApi[++iF] = (void (*)()) &rfic_trim_dcxo;               tApi[iF] = "rfic_trim_dcxo";                nPar[iF] = 2;   tPar[iF][0]="CapTrimX1";tPar[iF][1]="CapTrimX2";
    // Antenna on/off, Soft Reset
    pApi[++iF] = (void (*)()) &rfic_antenna_off;             tApi[iF] = "rfic_antenna_off";              nPar[iF] = 2;   tPar[iF][0]="AntMsk";tPar[iF][1]="Twait_us";
    pApi[++iF] = (void (*)()) &rfic_set_softreset;           tApi[iF] = "rfic_set_softreset";            nPar[iF] = 0;
    pApi[++iF] = (void (*)()) &rfic_release_softreset;       tApi[iF] = "rfic_release_softreset";        nPar[iF] = 0;
    // LB/HB switching
    pApi[++iF] = (void (*)()) &rfic_activate_lb;             tApi[iF] = "rfic_activate_lb";              nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_activate_hb;             tApi[iF] = "rfic_activate_hb";              nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_set_hblb;                tApi[iF] = "rfic_set_hblb";                 nPar[iF] = 2;   tPar[iF][0]="AntMsk";tPar[iF][1]="HbLb";
    // PLL programming
    pApi[++iF] = (void (*)()) &rfic_enable_pll;              tApi[iF] = "rfic_enable_pll";               nPar[iF] = 1;   tPar[iF][0]="Pll";
    pApi[++iF] = (void (*)()) &rfic_disable_pll;             tApi[iF] = "rfic_disable_pll";              nPar[iF] = 1;   tPar[iF][0]="Pll";
    pApi[++iF] = (void (*)()) &rfic_set_pllreset;            tApi[iF] = "rfic_set_pllreset";             nPar[iF] = 1;   tPar[iF][0]="Pll";
    pApi[++iF] = (void (*)()) &rfic_release_pllreset;        tApi[iF] = "rfic_release_pllreset";         nPar[iF] = 1;   tPar[iF][0]="Pll";
    pApi[++iF] = (void (*)()) &rfic_set_pll_mode;            tApi[iF] = "rfic_set_pll_mode";             nPar[iF] = 4;   tPar[iF][0]="Pll";tPar[iF][1]="HbLb";tPar[iF][2]="RefClk";tPar[iF][3]="HiPwr";
    pApi[++iF] = (void (*)()) &rfic_set_pll_5G_10M_ax;       tApi[iF] = "rfic_set_pll_5G_10M_ax";        nPar[iF] = 1;   tPar[iF][0]="Pll";
    pApi[++iF] = (void (*)()) &rfic_set_pll_5G_20M_ax;       tApi[iF] = "rfic_set_pll_5G_20M_ax";        nPar[iF] = 1;   tPar[iF][0]="Pll";
    pApi[++iF] = (void (*)()) &rfic_set_pll_5G_40M_ax;       tApi[iF] = "rfic_set_pll_5G_40M_ax";        nPar[iF] = 1;   tPar[iF][0]="Pll";
    pApi[++iF] = (void (*)()) &rfic_set_pll_5G_10M_rp;       tApi[iF] = "rfic_set_pll_5G_10M_rp";        nPar[iF] = 1;   tPar[iF][0]="Pll";
    pApi[++iF] = (void (*)()) &rfic_set_pll_5G_20M_rp;       tApi[iF] = "rfic_set_pll_5G_20M_rp";        nPar[iF] = 1;   tPar[iF][0]="Pll";
    pApi[++iF] = (void (*)()) &rfic_set_pll_5G_40M_rp;       tApi[iF] = "rfic_set_pll_5G_40M_rp";        nPar[iF] = 1;   tPar[iF][0]="Pll";
    pApi[++iF] = (void (*)()) &rfic_set_pll_2G;              tApi[iF] = "rfic_set_pll_2G";               nPar[iF] = 1;   tPar[iF][0]="Pll";
    pApi[++iF] = (void (*)()) &rfic_set_pll_intnmode;         tApi[iF] = "rfic_set_pll_intnmode";        nPar[iF] = 1;   tPar[iF][0]="Pll";
    pApi[++iF] = (void (*)()) &rfic_set_pll_fracnmode;       tApi[iF] = "rfic_set_pll_fracnmode";        nPar[iF] = 1;   tPar[iF][0]="Pll";
    pApi[++iF] = (void (*)()) &rfic_select_pll;              tApi[iF] = "rfic_select_pll";               nPar[iF] = 3;   tPar[iF][0]="AntMsk";tPar[iF][1]="Pll";tPar[iF][2]="HbLb";
    pApi[++iF] = (void (*)()) &rfic_select_fasthop_master;   tApi[iF] = "rfic_select_fasthop_master";    nPar[iF] = 2;   tPar[iF][0]="Pll";tPar[iF][1]="Ant";
    pApi[++iF] = (void (*)()) &rfic_select_fasthop_channel;  tApi[iF] = "rfic_select_fasthop_channel";   nPar[iF] = 2;   tPar[iF][0]="MasterAnt";tPar[iF][1]="Channel";
    pApi[++iF] = (void (*)()) &rfic_set_lo_frequency_intn;   tApi[iF] = "rfic_set_lo_frequency_intn";    nPar[iF] = 4;   tPar[iF][0]="Pll";tPar[iF][1]="LoFreq";tPar[iF][2]="HbLb";tPar[iF][3]="RefClk";
    pApi[++iF] = (void (*)()) &rfic_set_lo_frequency_fracn;  tApi[iF] = "rfic_set_lo_frequency_fracn";   nPar[iF] = 3;   tPar[iF][0]="Pll";tPar[iF][1]="LoFreq";tPar[iF][2]="HbLb";
    pApi[++iF] = (void (*)()) &rfic_set_lo_frequencies_intn; tApi[iF] = "rfic_set_lo_frequencies_intn";  nPar[iF] = 9;   tPar[iF][0]="Pll";tPar[iF][1]="LoFreq0";tPar[iF][2]="LoFreq1";tPar[iF][3]="LoFreq2";
                                                                                                            tPar[iF][4]="LoFreq3";tPar[iF][5]="LoFreq4";tPar[iF][6]="LoFreq5";tPar[iF][7]="HbLb";
                                                                                                            tPar[iF][8]="RefClk";
    pApi[++iF] = (void (*)()) &rfic_set_lo_frequencies_fracn;tApi[iF] = "rfic_set_lo_frequencies_fracn"; nPar[iF] = 8;   tPar[iF][0]="Pll";tPar[iF][1]="LoFreq0";tPar[iF][2]="LoFreq1";tPar[iF][3]="LoFreq2";
                                                                                                            tPar[iF][4]="LoFreq3";tPar[iF][5]="LoFreq4";tPar[iF][6]="LoFreq5";tPar[iF][7]="HbLb";
    pApi[++iF] = (void (*)()) &rfic_check_pll_lock;          tApi[iF] = "rfic_check_pll_lock";           nPar[iF] = 1;   tPar[iF][0]="Pll";
    // Manual gain setting
    pApi[++iF] = (void (*)()) &rfic_set_lnagain;             tApi[iF] = "rfic_set_lnagain";              nPar[iF] = 2;   tPar[iF][0]="AntMsk";tPar[iF][1]="gainidx";
    pApi[++iF] = (void (*)()) &rfic_set_pgcgain;             tApi[iF] = "rfic_set_pgcgain";              nPar[iF] = 2;   tPar[iF][0]="AntMsk";tPar[iF][1]="gaindB";
    pApi[++iF] = (void (*)()) &rfic_set_tpcgain;             tApi[iF] = "rfic_set_tpcgain";              nPar[iF] = 2;   tPar[iF][0]="AntMsk";tPar[iF][1]="gaindB";
    pApi[++iF] = (void (*)()) &rfic_set_padatt;              tApi[iF] = "rfic_set_padatt";               nPar[iF] = 2;   tPar[iF][0]="AntMsk";tPar[iF][1]="attdB";
    // Gain configuration
    pApi[++iF] = (void (*)()) &rfic_set_txfectl;             tApi[iF] = "rfic_set_txfectl";              nPar[iF] = 2;   tPar[iF][0]="AntMsk";tPar[iF][1]="txfectl";
    pApi[++iF] = (void (*)()) &rfic_config_tpcgain;          tApi[iF] = "rfic_config_tpcgain";           nPar[iF] = 5;   tPar[iF][0]="AntMsk";tPar[iF][1]="gain0dB";tPar[iF][2]="gain1dB";tPar[iF][3]="gain2dB";
                                                                                                            tPar[iF][4]="gain3dB";
    pApi[++iF] = (void (*)()) &rfic_config_tpcfiltidx;       tApi[iF] = "rfic_config_tpcfiltidx";        nPar[iF] = 5;   tPar[iF][0]="AntMsk";tPar[iF][1]="tpcfiltidx160";tPar[iF][2]="tpcfiltidx80";tPar[iF][3]="tpcfiltidx40";
                                                                                                            tPar[iF][4]="tpcfiltidx20";
    pApi[++iF] = (void (*)()) &rfic_config_lnagain;          tApi[iF] = "rfic_config_lnagain";           nPar[iF] = 8;   tPar[iF][0]="AntMsk";tPar[iF][1]="gain0idx";tPar[iF][2]="gain1idx";tPar[iF][3]="gain2idx";
                                                                                                            tPar[iF][4]="gain3idx";tPar[iF][5]="gain4idx";tPar[iF][6]="gain5idx";tPar[iF][7]="gain6idx";
    pApi[++iF] = (void (*)()) &rfic_config_rfrxgain;         tApi[iF] = "rfic_config_rfrxgain";          nPar[iF] = 15;  tPar[iF][0]="AntMsk";tPar[iF][1]="fectl0";tPar[iF][2]="gain0idx";tPar[iF][3]="fectl1";
                                                                                                            tPar[iF][4]="gain1idx";tPar[iF][5]="fectl2";tPar[iF][6]="gain2idx";tPar[iF][7]="fectl3";
                                                                                                            tPar[iF][8]="gain3idx";tPar[iF][9]="fectl4";tPar[iF][10]="gain4idx";tPar[iF][11]="fectl5";
                                                                                                            tPar[iF][12]="gain5idx";tPar[iF][13]="fectl6";tPar[iF][14]="gain6idx";
    pApi[++iF] = (void (*)()) &rfic_config_rssi;             tApi[iF] = "rfic_config_rssi";              nPar[iF] = 5;   tPar[iF][0]="AntMsk";tPar[iF][1]="cfg_nr";tPar[iF][2]="gaindB";tPar[iF][3]="coarse_offset_idx";
                                                                                                            tPar[iF][4]="fine_offset_idx";
    pApi[++iF] = (void (*)()) &rfic_select_rssi;             tApi[iF] = "rfic_select_rssi";              nPar[iF] = 2;   tPar[iF][0]="AntMsk";tPar[iF][1]="cfg_nr";
    pApi[++iF] = (void (*)()) &rfic_config_tssi;             tApi[iF] = "rfic_config_tssi";              nPar[iF] = 4;   tPar[iF][0]="AntMsk";tPar[iF][1]="cfg_nr";tPar[iF][2]="gaindB";tPar[iF][3]="fine_offset_idx";
    pApi[++iF] = (void (*)()) &rfic_select_tssi;             tApi[iF] = "rfic_select_tssi";              nPar[iF] = 2;   tPar[iF][0]="AntMsk";tPar[iF][1]="cfg_nr";
    pApi[++iF] = (void (*)()) &rfic_set_tssi_rdiv;           tApi[iF] = "rfic_set_tssi_rdiv";            nPar[iF] = 2;   tPar[iF][0]="AntMsk";tPar[iF][1]="rdiv";
    pApi[++iF] = (void (*)()) &rfic_set_rxgain;              tApi[iF] = "rfic_set_rxgain";               nPar[iF] = 3;   tPar[iF][0]="AntMsk";tPar[iF][1]="rfrxgainidx";tPar[iF][2]="pgcgaindB";
    pApi[++iF] = (void (*)()) &rfic_set_rfrxgainidx;         tApi[iF] = "rfic_set_rfrxgainidx";          nPar[iF] = 2;   tPar[iF][0]="AntMsk";tPar[iF][1]="rfrxgainidx";
    pApi[++iF] = (void (*)()) &rfic_set_pgcbwidth;           tApi[iF] = "rfic_set_pgcbwidth";            nPar[iF] = 2;   tPar[iF][0]="AntMsk";tPar[iF][1]="rfbandwidth";
    pApi[++iF] = (void (*)()) &rfic_set_rxgain_filter_rssi;  tApi[iF] = "rfic_set_rxgain_filter_rssi";   nPar[iF] = 5;   tPar[iF][0]="AntMsk";tPar[iF][1]="rfrxgainidx";tPar[iF][2]="pgcgaindB";tPar[iF][3]="rxfiltidx";
                                                                                                            tPar[iF][4]="rssi";
    pApi[++iF] = (void (*)()) &rfic_set_rxgain_bwidth;       tApi[iF] = "rfic_set_rxgain_bwidth";        nPar[iF] = 4;   tPar[iF][0]="AntMsk";tPar[iF][1]="rfrxgainidx";tPar[iF][2]="pgcgaindB";tPar[iF][3]="rfbandwidth";
    pApi[++iF] = (void (*)()) &rfic_set_rxgain_bwidth_rssi;  tApi[iF] = "rfic_set_rxgain_bwidth_rssi";   nPar[iF] = 5;   tPar[iF][0]="AntMsk";tPar[iF][1]="rfrxgainidx";tPar[iF][2]="pgcgaindB";tPar[iF][3]="rfbandwidth";
                                                                                                            tPar[iF][4]="rssi";
    pApi[++iF] = (void (*)()) &rfic_set_pgcfc100khz;         tApi[iF] = "rfic_set_pgcfc100khz";          nPar[iF] = 1;   tPar[iF][0]="vPgcFc100kHzNew";
    pApi[++iF] = (void (*)()) &rfic_create_pgcfiltlut;       tApi[iF] = "rfic_create_pgcfiltlut";        nPar[iF] = 2;   tPar[iF][0]="sA";tPar[iF][1]="sB";
    pApi[++iF] = (void (*)()) &rfic_get_pgcfiltlut;          tApi[iF] = "rfic_get_pgcfiltlut";           nPar[iF] = 1;   tPar[iF][0]="PgcFiltLut";
    pApi[++iF] = (void (*)()) &rfic_set_txgain;              tApi[iF] = "rfic_set_txgain";               nPar[iF] = 3;   tPar[iF][0]="AntMsk";tPar[iF][1]="tpcgainidx";tPar[iF][2]="padattdB";
    pApi[++iF] = (void (*)()) &rfic_set_tpcgainidx;          tApi[iF] = "rfic_set_tpcgainidx";           nPar[iF] = 2;   tPar[iF][0]="AntMsk";tPar[iF][1]="tpcgainidx";
    pApi[++iF] = (void (*)()) &rfic_set_txband;              tApi[iF] = "rfic_set_txband";               nPar[iF] = 2;   tPar[iF][0]="AntMsk";tPar[iF][1]="bandsel";
    pApi[++iF] = (void (*)()) &rfic_read_txband;             tApi[iF] = "rfic_read_txband";              nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_set_rxband;              tApi[iF] = "rfic_set_rxband";               nPar[iF] = 2;   tPar[iF][0]="AntMsk";tPar[iF][1]="bandsel";
    pApi[++iF] = (void (*)()) &rfic_read_rxband;             tApi[iF] = "rfic_read_rxband";              nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_set_lnamidgain;          tApi[iF] = "rfic_set_lnamidgain";           nPar[iF] = 2;   tPar[iF][0]="AntMsk";tPar[iF][1]="lnamidgain";
    // Power Mode and Bandwidth selection
    pApi[++iF] = (void (*)()) &rfic_set_bandwidth;           tApi[iF] = "rfic_set_bandwidth";            nPar[iF] = 2;   tPar[iF][0]="AntMsk";tPar[iF][1]="rfbandwidth";
    pApi[++iF] = (void (*)()) &rfic_set_powermode;           tApi[iF] = "rfic_set_powermode";            nPar[iF] = 2;   tPar[iF][0]="AntMsk";tPar[iF][1]="modeidx";
    pApi[++iF] = (void (*)()) &rfic_set_rxdc;                tApi[iF] = "rfic_set_rxdc";                 nPar[iF] = 2;   tPar[iF][0]="AntMsk";tPar[iF][1]="rxdcidx";
    pApi[++iF] = (void (*)()) &rfic_set_rfch_dc_bw;          tApi[iF] = "rfic_set_rfch_dc_bw";           nPar[iF] = 4;   tPar[iF][0]="AntMsk";tPar[iF][1]="Channel";tPar[iF][2]="rxdcidx";tPar[iF][3]="rfbandwidth";
    // LNA Noise Source on/off
    pApi[++iF] = (void (*)()) &rfic_enable_lnanoise;         tApi[iF] = "rfic_enable_lnanoise";          nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_enable_lnanoise_old;     tApi[iF] = "rfic_enable_lnanoise_old";      nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_disable_lnanoise;        tApi[iF] = "rfic_disable_lnanoise";         nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_enable_lna;              tApi[iF] = "rfic_enable_lna";               nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_disable_lna;             tApi[iF] = "rfic_disable_lna";              nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    // Direct Step RX Gains
    pApi[++iF] = (void (*)()) &rfic_config_dirstep;          tApi[iF] = "rfic_config_dirstep";           nPar[iF] = 6;   tPar[iF][0]="AntMsk";tPar[iF][1]="dstepidx";tPar[iF][2]="lnagainidx";tPar[iF][3]="pgcgaindB";
                                                                                                            tPar[iF][4]="rssirange";tPar[iF][5]="rxfiltidx";
    pApi[++iF] = (void (*)()) &rfic_select_dirstep;          tApi[iF] = "rfic_select_dirstep";           nPar[iF] = 2;   tPar[iF][0]="AntMsk";tPar[iF][1]="dstepidx";
    pApi[++iF] = (void (*)()) &rfic_dirstep_force_on;        tApi[iF] = "rfic_dirstep_force_on";         nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_dirstep_force_off;       tApi[iF] = "rfic_dirstep_force_off";        nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    // Baseband Calibration Loops
    pApi[++iF] = (void (*)()) &rfic_enable_bbloop;           tApi[iF] = "rfic_enable_bbloop";            nPar[iF] = 4;   tPar[iF][0]="AntMsk";tPar[iF][1]="HbLb";tPar[iF][2]="LoopType";tPar[iF][3]="IqSel";
    pApi[++iF] = (void (*)()) &rfic_disable_bbloop;          tApi[iF] = "rfic_disable_bbloop";           nPar[iF] = 2;   tPar[iF][0]="AntMsk";tPar[iF][1]="HbLb";
    pApi[++iF] = (void (*)()) &rfic_set_pgc_inputres;        tApi[iF] = "rfic_set_pgc_inputres";         nPar[iF] = 3;   tPar[iF][0]="AntMsk";tPar[iF][1]="Rin";tPar[iF][2]="IqSel";
    pApi[++iF] = (void (*)()) &rfic_enable_ssbcal_hb;        tApi[iF] = "rfic_enable_ssbcal_hb";         nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_enable_ssbcal_lb;        tApi[iF] = "rfic_enable_ssbcal_lb";         nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_enable_iqcal_hb;         tApi[iF] = "rfic_enable_iqcal_hb";          nPar[iF] = 2;   tPar[iF][0]="AntMsk";tPar[iF][1]="IqSel";
    pApi[++iF] = (void (*)()) &rfic_enable_iqcal_lb;         tApi[iF] = "rfic_enable_iqcal_lb";          nPar[iF] = 2;   tPar[iF][0]="AntMsk";tPar[iF][1]="IqSel";
    pApi[++iF] = (void (*)()) &rfic_enable_filtercal_hb;     tApi[iF] = "rfic_enable_filtercal_hb";      nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_enable_filtercal_lb;     tApi[iF] = "rfic_enable_filtercal_lb";      nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_disable_ssbcal_hb;       tApi[iF] = "rfic_disable_ssbcal_hb";        nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_disable_ssbcal_lb;       tApi[iF] = "rfic_disable_ssbcal_lb";        nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_disable_iqcal_hb;        tApi[iF] = "rfic_disable_iqcal_hb";         nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_disable_iqcal_lb;        tApi[iF] = "rfic_disable_iqcal_lb";         nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_disable_filtercal_hb;    tApi[iF] = "rfic_disable_filtercal_hb";     nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_disable_filtercal_lb;    tApi[iF] = "rfic_disable_filtercal_lb";     nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_enable_dpdcal;           tApi[iF] = "rfic_enable_dpdcal";            nPar[iF] = 2;   tPar[iF][0]="AntMsk";tPar[iF][1]="HbLb";
    pApi[++iF] = (void (*)()) &rfic_disable_dpdcal;          tApi[iF] = "rfic_disable_dpdcal";           nPar[iF] = 2;   tPar[iF][0]="AntMsk";tPar[iF][1]="HbLb";
    // DC Offset Cancellation
    pApi[++iF] = (void (*)()) &rfic_start_dc_clock;          tApi[iF] = "rfic_start_dc_clock";           nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_stop_dc_clock;           tApi[iF] = "rfic_stop_dc_clock";            nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_start_dcramp;            tApi[iF] = "rfic_start_dcramp";             nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_stop_dcramp;             tApi[iF] = "rfic_stop_dcramp";              nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_start_dccancel;          tApi[iF] = "rfic_start_dccancel";           nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_stop_dccancel;           tApi[iF] = "rfic_stop_dccancel";            nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_reset_dccancel;          tApi[iF] = "rfic_reset_dccancel";           nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_set_dcintegrator;        tApi[iF] = "rfic_set_dcintegrator";         nPar[iF] = 2;   tPar[iF][0]="AntMsk";tPar[iF][1]="IntBW";
    pApi[++iF] = (void (*)()) &rfic_enable_rxdc_man;         tApi[iF] = "rfic_enable_rxdc_man";          nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_disable_rxdc_man;        tApi[iF] = "rfic_disable_rxdc_man";         nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_set_rxdcoffset;          tApi[iF] = "rfic_set_rxdcoffset";           nPar[iF] = 3;   tPar[iF][0]="AntMsk";tPar[iF][1]="dacI";tPar[iF][2]="dacQ";
    // TX DC Offset Cancellation
    pApi[++iF] = (void (*)()) &rfic_set_txdcoffset;          tApi[iF] = "rfic_set_txdcoffset";           nPar[iF] = 3;   tPar[iF][0]="AntMsk";tPar[iF][1]="dacI";tPar[iF][2]="dacQ";
    pApi[++iF] = (void (*)()) &rfic_set_txdc_tpccfg;         tApi[iF] = "rfic_set_txdc_tpccfg";          nPar[iF] = 4;   tPar[iF][0]="AntMsk";tPar[iF][1]="dacI";tPar[iF][2]="dacQ";tPar[iF][3]="TpcCfg";
    // BBO LDO
    pApi[++iF] = (void (*)()) &rfic_enable_1v2bboldo;        tApi[iF] = "rfic_enable_1v2bboldo";         nPar[iF] = 0;
    pApi[++iF] = (void (*)()) &rfic_disable_1v2bboldo;       tApi[iF] = "rfic_disable_1v2bboldo";        nPar[iF] = 0;
    pApi[++iF] = (void (*)()) &rfic_enable_bypass_1v2bboldo; tApi[iF] = "rfic_enable_bypass_1v2bboldo";  nPar[iF] = 0;
    pApi[++iF] = (void (*)()) &rfic_disable_bypass_1v2bboldo;tApi[iF] = "rfic_disable_bypass_1v2bboldo"; nPar[iF] = 0;
    pApi[++iF] = (void (*)()) &rfic_set_bbioldo_ctl_vout;    tApi[iF] = "rfic_set_bbioldo_ctl_vout";     nPar[iF] = 1;   tPar[iF][0]="step";
    pApi[++iF] = (void (*)()) &rfic_set_bbioldo_vout_vcmbuffer;tApi[iF] = "rfic_set_bbioldo_vout_vcmbuffer";nPar[iF] = 1;tPar[iF][0]="step";
    pApi[++iF] = (void (*)()) &rfic_set_bbioldo_ctl_comp;    tApi[iF] = "rfic_set_bbioldo_ctl_comp";     nPar[iF] = 1;   tPar[iF][0]="step";
    // FCSI LDO
    pApi[++iF] = (void (*)()) &rfic_set_fcsildo_ctl_vout;    tApi[iF] = "rfic_set_fcsildo_ctl_vout";     nPar[iF] = 1;   tPar[iF][0]="step";
    // ABB LDO
    pApi[++iF] = (void (*)()) &rfic_set_abbldo_ctl_rdg_prog; tApi[iF] = "rfic_set_abbldo_ctl_rdg_prog";  nPar[iF] = 1;   tPar[iF][0]="step";
    // LO Central
    pApi[++iF] = (void (*)()) &rfic_set_locenthb_ctl_vout;   tApi[iF] = "rfic_set_locenthb_ctl_vout";    nPar[iF] = 2;   tPar[iF][0]="AntMsk";tPar[iF][1]="step";
    pApi[++iF] = (void (*)()) &rfic_set_locentlb_ctl_vout;   tApi[iF] = "rfic_set_locentlb_ctl_vout";    nPar[iF] = 2;   tPar[iF][0]="AntMsk";tPar[iF][1]="step";
    pApi[++iF] = (void (*)()) &rfic_enable_lotreeldo;        tApi[iF] = "rfic_enable_lotreeldo";         nPar[iF] = 2;   tPar[iF][0]="AntMsk";tPar[iF][1]="HbLb";
    pApi[++iF] = (void (*)()) &rfic_disable_lotreeldo;       tApi[iF] = "rfic_disable_lotreeldo";        nPar[iF] = 2;   tPar[iF][0]="AntMsk";tPar[iF][1]="HbLb";
    // FSYS LDO
    pApi[++iF] = (void (*)()) &rfic_set_fsysldo_ctl_vout;    tApi[iF] = "rfic_set_fsysldo_ctl_vout";     nPar[iF] = 1;   tPar[iF][0]="step";
    pApi[++iF] = (void (*)()) &rfic_set_fsysldo_ctl_iref;    tApi[iF] = "rfic_set_fsysldo_ctl_iref";     nPar[iF] = 1;   tPar[iF][0]="step";
    // BB LDO
    pApi[++iF] = (void (*)()) &rfic_set_ctl_vout_1v2bbldo;   tApi[iF] = "rfic_set_ctl_vout_1v2bbldo";    nPar[iF] = 2;   tPar[iF][0]="AntMsk";tPar[iF][1]="step";
    pApi[++iF] = (void (*)()) &rfic_enable_1v2bbldo;         tApi[iF] = "rfic_enable_1v2bbldo";          nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_disable_1v2bbldo;        tApi[iF] = "rfic_disable_1v2bbldo";         nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_enable_bypass_1v2bbldo;  tApi[iF] = "rfic_enable_bypass_1v2bbldo";   nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_disable_bypass_1v2bbldo; tApi[iF] = "rfic_disable_bypass_1v2bbldo";  nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_enable_rload_1v2bbldo;   tApi[iF] = "rfic_enable_rload_1v2bbldo";    nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_disable_rload_1v2bbldo;  tApi[iF] = "rfic_disable_rload_1v2bbldo";   nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_force_ldo_ready_1v2bbldo;tApi[iF] = "rfic_force_ldo_ready_1v2bbldo"; nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_ctl_ldo_ready_1v2bbldo;  tApi[iF] = "rfic_ctl_ldo_ready_1v2bbldo";   nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    // 2V5 LDO
    pApi[++iF] = (void (*)()) &rfic_enable_2v5ldo;           tApi[iF] = "rfic_enable_2v5ldo";            nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_disable_2v5ldo;          tApi[iF] = "rfic_disable_2v5ldo";           nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_disable_rload_2v5ldo;    tApi[iF] = "rfic_disable_rload_2v5ldo";     nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_enable_rload_2v5ldo;     tApi[iF] = "rfic_enable_rload_2v5ldo";      nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_enable_bypass_2v5ldo;    tApi[iF] = "rfic_enable_bypass_2v5ldo";     nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_disable_bypass_2v5ldo;   tApi[iF] = "rfic_disable_bypass_2v5ldo";    nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_set_ctl_lpgain_2v5ldo;   tApi[iF] = "rfic_set_ctl_lpgain_2v5ldo";    nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_set_ctl_lpgain_off_2v5ldo;tApi[iF] = "rfic_set_ctl_lpgain_off_2v5ldo";nPar[iF] = 1;  tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_set_ctl_vout_2v5ldo;     tApi[iF] = "rfic_set_ctl_vout_2v5ldo";      nPar[iF] = 2;   tPar[iF][0]="AntMsk";tPar[iF][1]="step";
    pApi[++iF] = (void (*)()) &rfic_enable_lc_2v5ldo;        tApi[iF] = "rfic_enable_lc_2v5ldo";         nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_disable_lc_2v5ldo;       tApi[iF] = "rfic_disable_lc_2v5ldo";        nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    // RX LDO
    pApi[++iF] = (void (*)()) &rfic_enable_rxldo;            tApi[iF] = "rfic_enable_rxldo";             nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_disable_rxldo;           tApi[iF] = "rfic_disable_rxldo";            nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_enable_rload_rxldo;      tApi[iF] = "rfic_enable_rload_rxldo";       nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_disable_rload_rxldo;     tApi[iF] = "rfic_disable_rload_rxldo";      nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_enable_bypass_rxldo;     tApi[iF] = "rfic_enable_bypass_rxldo";      nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_disable_bypass_rxldo;    tApi[iF] = "rfic_disable_bypass_rxldo";     nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_set_ctl_vout_rxldo;      tApi[iF] = "rfic_set_ctl_vout_rxldo";       nPar[iF] = 2;   tPar[iF][0]="AntMsk";tPar[iF][1]="step";
    // TX HB LDO
    pApi[++iF] = (void (*)()) &rfic_enable_hbldo;            tApi[iF] = "rfic_enable_hbldo";             nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_disable_hbldo;           tApi[iF] = "rfic_disable_hbldo";            nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_enable_rload_hbldo;      tApi[iF] = "rfic_enable_rload_hbldo";       nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_disable_rload_hbldo;     tApi[iF] = "rfic_disable_rload_hbldo";      nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_enable_bypass_hbldo;     tApi[iF] = "rfic_enable_bypass_hbldo";      nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_disable_bypass_hbldo;    tApi[iF] = "rfic_disable_bypass_hbldo";     nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_set_ctl_vout_hbldo;      tApi[iF] = "rfic_set_ctl_vout_hbldo";       nPar[iF] = 2;   tPar[iF][0]="AntMsk";tPar[iF][1]="step";
    // TX LB LDO
    pApi[++iF] = (void (*)()) &rfic_enable_lbldo;            tApi[iF] = "rfic_enable_lbldo";             nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_disable_lbldo;           tApi[iF] = "rfic_disable_lbldo";            nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_enable_rload_lbldo;      tApi[iF] = "rfic_enable_rload_lbldo";       nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_disable_rload_lbldo;     tApi[iF] = "rfic_disable_rload_lbldo";      nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_enable_bypass_lbldo;     tApi[iF] = "rfic_enable_bypass_lbldo";      nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_disable_bypass_lbldo;    tApi[iF] = "rfic_disable_bypass_lbldo";     nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_set_ctl_vout_lbldo;      tApi[iF] = "rfic_set_ctl_vout_lbldo";       nPar[iF] = 2;   tPar[iF][0]="AntMsk";tPar[iF][1]="step";
    // CENTRAL VDDMON
    pApi[++iF] = (void (*)()) &rfic_enable_vddmon_central;   tApi[iF] = "rfic_enable_vddmon_central";    nPar[iF] = 0;
    pApi[++iF] = (void (*)()) &rfic_disable_vddmon_central;  tApi[iF] = "rfic_disable_vddmon_central";   nPar[iF] = 0;
    pApi[++iF] = (void (*)()) &rfic_enable_vddmon_fcsildo;   tApi[iF] = "rfic_enable_vddmon_fcsildo";    nPar[iF] = 0;
    pApi[++iF] = (void (*)()) &rfic_disable_vddmon_fcsildo;  tApi[iF] = "rfic_disable_vddmon_fcsildo";   nPar[iF] = 0;
    pApi[++iF] = (void (*)()) &rfic_enable_vddmon_fsysldo;   tApi[iF] = "rfic_enable_vddmon_fsysldo";    nPar[iF] = 0;
    pApi[++iF] = (void (*)()) &rfic_disable_vddmon_fsysldo;  tApi[iF] = "rfic_disable_vddmon_fsysldo";   nPar[iF] = 0;
    pApi[++iF] = (void (*)()) &rfic_enable_vddmon_bbioldo;   tApi[iF] = "rfic_enable_vddmon_bbioldo";    nPar[iF] = 0;
    pApi[++iF] = (void (*)()) &rfic_disable_vddmon_bbioldo;  tApi[iF] = "rfic_disable_vddmon_bbioldo";   nPar[iF] = 0;
    pApi[++iF] = (void (*)()) &rfic_enable_vddmon_lotreeldo; tApi[iF] = "rfic_enable_vddmon_lotreeldo";  nPar[iF] = 2;   tPar[iF][0]="AntMsk";tPar[iF][1]="HbLb";
    pApi[++iF] = (void (*)()) &rfic_disable_vddmon_lotreeldo;tApi[iF] = "rfic_disable_vddmon_lotreeldo"; nPar[iF] = 2;   tPar[iF][0]="AntMsk";tPar[iF][1]="HbLb";
    // Supply Monitor
    pApi[++iF] = (void (*)()) &rfic_disable_vddmon;          tApi[iF] = "rfic_disable_vddmon";           nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_enable_vddmon_1v2bbldo;  tApi[iF] = "rfic_enable_vddmon_1v2bbldo";   nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_enable_vddmon_2v5ldo;    tApi[iF] = "rfic_enable_vddmon_2v5ldo";     nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_enable_vddmon_hbldo;     tApi[iF] = "rfic_enable_vddmon_hbldo";      nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_enable_vddmon_lbldo;     tApi[iF] = "rfic_enable_vddmon_lbldo";      nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_enable_vddmon_1v2rxldo;  tApi[iF] = "rfic_enable_vddmon_1v2rxldo";   nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_enable_vddmon_1v5ldoin;  tApi[iF] = "rfic_enable_vddmon_1v5ldoin";   nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_enable_vddmon_3v3ldoin;  tApi[iF] = "rfic_enable_vddmon_3v3ldoin";   nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_enable_vddmon_tssiin;    tApi[iF] = "rfic_enable_vddmon_tssiin";     nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    // Temperature Sensor
    pApi[++iF] = (void (*)()) &rfic_start_tempsensor_clock;  tApi[iF] = "rfic_start_tempsensor_clock";   nPar[iF] = 0;
    pApi[++iF] = (void (*)()) &rfic_stop_tempsensor_clock;   tApi[iF] = "rfic_stop_tempsensor_clock";    nPar[iF] = 0;
    pApi[++iF] = (void (*)()) &rfic_start_tempsensor_cal;    tApi[iF] = "rfic_start_tempsensor_cal";     nPar[iF] = 0;
    pApi[++iF] = (void (*)()) &rfic_stop_tempsensor_cal;     tApi[iF] = "rfic_stop_tempsensor_cal";      nPar[iF] = 0;
    pApi[++iF] = (void (*)()) &rfic_start_tempsensor;        tApi[iF] = "rfic_start_tempsensor";         nPar[iF] = 0;
    // Central bias
    pApi[++iF] = (void (*)()) &rfic_set_bgp_trim;            tApi[iF] = "rfic_set_bgp_trim";             nPar[iF] = 1;   tPar[iF][0]="TuneVal";
    pApi[++iF] = (void (*)()) &rfic_set_iconst_trim;         tApi[iF] = "rfic_set_iconst_trim";          nPar[iF] = 1;   tPar[iF][0]="TuneVal";
    // FECTL
    pApi[++iF] = (void (*)()) &rfic_set_antenna_fectl_man;   tApi[iF] = "rfic_set_antenna_fectl_man";    nPar[iF] = 2;   tPar[iF][0]="AntMsk";tPar[iF][1]="fectl";
    pApi[++iF] = (void (*)()) &rfic_disable_antenna_fectl;   tApi[iF] = "rfic_disable_antenna_fectl";    nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_set_central_fectl_man;   tApi[iF] = "rfic_set_central_fectl_man";    nPar[iF] = 1;   tPar[iF][0]="fectl";
    // ANAMUX
    pApi[++iF] = (void (*)()) &rfic_enable_anamux;           tApi[iF] = "rfic_enable_anamux";            nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_disable_anamux;          tApi[iF] = "rfic_disable_anamux";           nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_enable_anamux_vddmonin;  tApi[iF] = "rfic_enable_anamux_vddmonin";   nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    pApi[++iF] = (void (*)()) &rfic_disable_anamux_vddmonin; tApi[iF] = "rfic_disable_anamux_vddmonin";  nPar[iF] = 1;   tPar[iF][0]="AntMsk";
    // eFuse Programming
    pApi[++iF] = (void (*)()) &rfic_enable_efuse;            tApi[iF] = "rfic_enable_efuse";             nPar[iF] = 0;
    pApi[++iF] = (void (*)()) &rfic_disable_efuse;           tApi[iF] = "rfic_disable_efuse";            nPar[iF] = 0;
    // New B0 Features
    pApi[++iF] = (void (*)()) &rfic_select_lnabiasmode;      tApi[iF] = "rfic_select_lnabiasmode";       nPar[iF] = 2;   tPar[iF][0]="AntMsk";tPar[iF][1]="BiasMode";
    pApi[++iF] = (void (*)()) &rfic_select_tpcdacrange;      tApi[iF] = "rfic_select_tpcdacrange";       nPar[iF] = 2;   tPar[iF][0]="AntMsk";tPar[iF][1]="DacRange";
    pApi[++iF] = (void (*)()) &rfic_select_bbovcminput;      tApi[iF] = "rfic_select_bbovcminput";       nPar[iF] = 1;   tPar[iF][0]="VcmInput";

    // Init sequence
    pApi[++iF] = (void (*)()) &rfic_init;                    tApi[iF] = "rfic_init";                     nPar[iF] = 0;
    // PLL sequences & shortcuts
    pApi[++iF] = (void (*)()) &rfic_lock_pll;                tApi[iF] = "rfic_lock_pll";                 nPar[iF] = 2;   tPar[iF][0]="Pll";tPar[iF][1]="LoFreq";
    pApi[++iF] = (void (*)()) &rfic_init_pll;                tApi[iF] = "rfic_init_pll";                 nPar[iF] = 5;   tPar[iF][0]="Pll";tPar[iF][1]="IntFracMode";tPar[iF][2]="HbLb";tPar[iF][3]="RefClk";
                                                                                                            tPar[iF][4]="HiPwr";
    pApi[++iF] = (void (*)()) &rfic_set_pll_hblb;            tApi[iF] = "rfic_set_pll_hblb";             nPar[iF] = 2;   tPar[iF][0]="Pll";tPar[iF][1]="HbLb";
    pApi[++iF] = (void (*)()) &rfic_set_pll_pwrmode;         tApi[iF] = "rfic_set_pll_pwrmode";          nPar[iF] = 2;   tPar[iF][0]="Pll";tPar[iF][1]="HiPwr";
    pApi[++iF] = (void (*)()) &rfic_set_pll_intfrac;         tApi[iF] = "rfic_set_pll_intfrac";          nPar[iF] = 2;   tPar[iF][0]="Pll";tPar[iF][1]="IntFracMode";
    pApi[++iF] = (void (*)()) &rfic_set_pll_refclk;          tApi[iF] = "rfic_set_pll_refclk";           nPar[iF] = 2;   tPar[iF][0]="Pll";tPar[iF][1]="RefClk";
    pApi[++iF] = (void (*)()) &rfic_set_lo_frequency;        tApi[iF] = "rfic_set_lo_frequency";         nPar[iF] = 2;   tPar[iF][0]="Pll";tPar[iF][1]="LoFreq";
    pApi[++iF] = (void (*)()) &rfic_set_lo_frequencies;      tApi[iF] = "rfic_set_lo_frequencies";       nPar[iF] = 7;   tPar[iF][0]="Pll";tPar[iF][1]="LoFreq0";tPar[iF][2]="LoFreq1";tPar[iF][3]="LoFreq2";tPar[iF][4]="LoFreq3";
                                                                                                            tPar[iF][5]="LoFreq4";tPar[iF][6]="LoFreq5";
    pApi[++iF] = (void (*)()) &rfic_connect_to_pll;          tApi[iF] = "rfic_connect_to_pll";           nPar[iF] = 3;   tPar[iF][0]="Pll";tPar[iF][1]="AntSet";tPar[iF][2]="bActHbLb";

    // parallel writing APIs
    pApi[++iF] = (void (*)()) &rfic_config_tpcgain_par;      tApi[iF] = "rfic_config_tpcgain_par";       nPar[iF] = 5;   tPar[iF][0]="AntMsk";tPar[iF][1]="gain0dB";tPar[iF][2]="gain1dB";tPar[iF][3]="gain2dB";
                                                                                                            tPar[iF][4]="gain3dB";
    pApi[++iF] = (void (*)()) &rfic_set_txdc_tpccfg_par;     tApi[iF] = "rfic_set_txdc_tpccfg_par";      nPar[iF] = 4;   tPar[iF][0]="AntMsk";tPar[iF][1]="dacI";tPar[iF][2]="dacQ";tPar[iF][3]="TpcCfg";
    pApi[++iF] = (void (*)()) &rfic_set_antenna_fectl_man_par;tApi[iF] = "rfic_set_antenna_fectl_man_par";nPar[iF] = 2;  tPar[iF][0]="AntMsk";tPar[iF][1]="fectl";


// save number of API functions without output and reset counter
    nFunc = ++iF;
    iF = 0;

    // mexPrintf("Number of API functions: %d.\n", nFunc+1);

    // ***********************************************
    // *        API FUNCTIONS WITH INT OUTPUT        *
    // ***********************************************
    // Function Pointer                         Function Name                               No. of Pars     Parameter Names
    // API version info
    pApiI[iF] = (uint16_t (*)()) &rfic_api_version;                  	tApiI[iF] = "rfic_api_version";              	nParI[iF] = 0;
    // DC Offset Cancellation
    pApiI[++iF] = (uint16_t (*)()) &rfic_check_dccancel;                tApiI[iF] = "rfic_check_dccancel";              nParI[iF] = 1;      tParI[iF][0]="AntMsk";
    // get TX/RX band selection
    pApiI[++iF] = (uint16_t (*)()) &rfic_get_txband;                    tApiI[iF] = "rfic_get_txband";                  nParI[iF] = 1;      tParI[iF][0]="LoFreq";
    pApiI[++iF] = (uint16_t (*)()) &rfic_get_rxband;                    tApiI[iF] = "rfic_get_rxband";                  nParI[iF] = 1;      tParI[iF][0]="LoFreq";
    // get LNA mid gain
    pApiI[++iF] = (uint16_t (*)()) &rfic_get_lnamidgain;                tApiI[iF] = "rfic_get_lnamidgain";              nParI[iF] = 2;      tParI[iF][0]="Ant";tParI[iF][1]="HbLb";
    // get RX DC offset
    pApiI[++iF] = (uint16_t (*)()) &rfic_get_rxdcoffset;                tApiI[iF] = "rfic_get_rxdcoffset";              nParI[iF] = 3;      tParI[iF][0]="Ant";tParI[iF][1]="rfrxgainidx";tParI[iF][2]="rxdx";
    // Temperature Sensor
    pApiI[++iF] = (uint16_t (*)()) &rfic_read_tempsensor;               tApiI[iF] = "rfic_read_tempsensor";             nParI[iF] = 0;
    // eFuse Readout
    pApiI[++iF] = (uint16_t (*)()) &rfic_read_efuse_values;             tApiI[iF] = "rfic_read_efuse_values";       	nParI[iF] = 2;      tParI[iF][0]="section";tParI[iF][1]="softfuse_data";
    pApiI[++iF] = (uint16_t (*)()) &rfic_get_efuse_values;              tApiI[iF] = "rfic_get_efuse_values";            nParI[iF] = 1;      tParI[iF][0]="fuse_data";
    pApiI[++iF] = (uint16_t (*)()) &rfic_read_efuse_handlertemp;        tApiI[iF] = "rfic_read_efuse_handlertemp";      nParI[iF] = 1;      tParI[iF][0]="softfuse_data";
    pApiI[++iF] = (uint16_t (*)()) &rfic_read_efuse_tempsensorresult;   tApiI[iF] = "rfic_read_efuse_tempsensorresult"; nParI[iF] = 1;      tParI[iF][0]="softfuse_data";
    // PLL Start Sequences
    pApiI[++iF] = (uint16_t (*)()) &rfic_start_pll;                     tApiI[iF] = "rfic_start_pll";                   nParI[iF] = 3;      tParI[iF][0]="Pll";tParI[iF][1]="AntSet";tParI[iF][2]="LoFreq";
    pApiI[++iF] = (uint16_t (*)()) &rfic_start_pll_fasthop;             tApiI[iF] = "rfic_start_pll_fasthop";           nParI[iF] = 8;      tParI[iF][0]="Pll";tParI[iF][1]="AntSet";tParI[iF][2]="LoFreq0";tParI[iF][3]="LoFreq1";
                                                                                                                            tParI[iF][4]="LoFreq2";tParI[iF][5]="LoFreq3";tParI[iF][6]="LoFreq4";tParI[iF][7]="LoFreq5";
    pApiI[++iF] = (uint16_t (*)()) &rfic_poll_pll_lock;                 tApiI[iF] = "rfic_poll_pll_lock";               nParI[iF] = 1;      tParI[iF][0]="Pll";
    // save number of API functions with int output and reset counter
    nFuncI = ++iF;
    iF = 0;

    // *********************************************************
    // *      API FUNCTIONS WITH STRUCT AND ARRAY OUTPUT       *
    // *********************************************************
    // Function Pointer                         Function Name                               No. of Pars     Parameter Names
    // PLL Status
    pApiR[iF] = (pll_config (*)()) &rfic_get_pll_status;                tApiR[iF] = "rfic_get_pll_status";              nParR[iF] = 1;      tParR[iF][0]="Pll";
    pApiR[++iF] = (rx_gain_cfg (*)()) &rfic_get_rxgain_status;          tApiR[iF] = "rfic_get_rxgain_status";           nParR[iF] = 1;      tParR[iF][0]="Ant";
    //pApiR[++iF] = (uint8_t (*)()) &rfic_get_pgcfiltlut;                 tApiR[iF] = "rfic_get_pgcfiltlut";              nParR[iF] = 0;

    // save number of API functions with int output and reset counter
    nFuncR = ++iF;
    iF = 0;


    // function name parser
    // first check for functions with no output
    for (iFct = 0; iFct < nFunc; iFct++)
    {
        if (0 == strcmp(input_buf, tApi[iFct]))
        {
            if (0 == strcmp(input_buf, "rfic_config_tpcgain_par"))
            {
                check_parameter(nrhs,nPar[iFct]);
                // display function name and parameter values
                mexPrintf("Executing %s: ", tApi[iFct]);
                vPar[0] = (int32_t) mxGetScalar(prhs[1]);
                mexPrintf("%s=%d ", tPar[iFct][0], vPar[0]);
                for (iPar = 1; iPar < nPar[iFct]; iPar++)
                {
                    if (!(mxGetN(prhs[iPar+1])==4 | mxGetM(prhs[iPar+1])==4))
                        mexErrMsgTxt("Array size must contain at least 4 elements\n");
                    mexPrintf("%s=[ ", tPar[iFct][iPar]);
                    memcpy(double_data, mxGetPr(prhs[iPar+1]), 4*sizeof(double));
                    for(iK=0; iK<4; iK++)
                    {
                        ParData[iPar-1][iK] = (int8_t) double_data[iK];
                        mexPrintf("%d ", ParData[iPar-1][iK]);
                    }
                    mexPrintf("] ");

                }
                mexPrintf("\n");
//                 rfic_config_tpcgain_par(vPar[0], &ParData[0][0], &ParData[1][0], &ParData[2][0], &ParData[3][0]);
                rfic_config_tpcgain_par(vPar[0], ParData[0], ParData[1], ParData[2], ParData[3]);

                // leave for() loop
                bFound = 1;
                break;
            }
            else if (0 == strcmp(input_buf, "rfic_set_txdc_tpccfg_par"))
            {
                check_parameter(nrhs,nPar[iFct]);
                // display function name and parameter values
                mexPrintf("Executing %s: ", tApi[iFct]);
                vPar[0] = (int32_t) mxGetScalar(prhs[1]);
                mexPrintf("%s=%d ", tPar[iFct][0], vPar[0]);
                for (iPar = 1; iPar < nPar[iFct]-1; iPar++)
                {
                    if (!(mxGetN(prhs[iPar+1])==4 | mxGetM(prhs[iPar+1])==4))
                        mexErrMsgTxt("Array size must contain at least 4 elements\n");
                    mexPrintf("%s=[ ", tPar[iFct][iPar]);
                    memcpy(double_data, mxGetPr(prhs[iPar+1]), 4*sizeof(double));
                    for(iK=0; iK<4; iK++)
                    {
                        ParData[iPar-1][iK] = (int8_t) double_data[iK];
                        mexPrintf("%d ", ParData[iPar-1][iK]);
                    }
                    mexPrintf("] ");

                }
                vPar[3] = (int32_t) mxGetScalar(prhs[4]);
                mexPrintf("%s=%d ", tPar[iFct][3], vPar[3]);
                mexPrintf("\n");
                rfic_set_txdc_tpccfg_par(vPar[0], &ParData[0][0], &ParData[1][0], vPar[3]);

                // leave for() loop
                bFound = 1;
                break;
            }
            else if (0 == strcmp(input_buf, "rfic_set_pgcfc100khz"))
            {
                check_parameter(nrhs,nPar[iFct]);
                // display function name and parameter values
                mexPrintf("Executing %s: ", tApi[iFct]);
                if (!(mxGetN(prhs[1])==5 | mxGetM(prhs[1])==5))
                    mexErrMsgTxt("Array size must contain at least 5 elements\n");
                mexPrintf("%s=[ ", tPar[iFct][0]);
                memcpy(double_data, mxGetPr(prhs[1]), 5*sizeof(double));
                for(iK=0; iK<5; iK++)
                {
                    PgcFc[iK] = (uint16_t) double_data[iK];
                    mexPrintf("%d ", PgcFc[iK]);
                }
                mexPrintf("]\n");
                rfic_set_pgcfc100khz(&PgcFc[0]);
				
                // leave for() loop
                bFound = 1;
                break;
            }
            else if (0 == strcmp(input_buf, "rfic_get_pgcfiltlut"))
            {
                mexPrintf("Executing rfic_get_pgcfiltlut:\n");
                // run API function
                rfic_get_pgcfiltlut(PgcFiltLut);

                // Create Matlab struct with same field names as pll_config
                plhs[0] = mxCreateDoubleMatrix(5,11,mxREAL);
                double* MatDblPr = (double *)mxGetData(plhs[0]);
                for (iF = 0; iF < 5; iF++)
                {
                    for (iK = 0; iK < 11; iK++)
                    {
                        MatDblPr[iF+iK*5] = (double) PgcFiltLut[iF][iK];
                    }
                }

                // leave for() loop
                bFound = 1;
                break;
            }
            else if (0 == strcmp(input_buf, "rfic_read_txband"))
            {
                check_parameter(nrhs,nPar[iFct]);
                mexPrintf("Executing rfic_read_txband:\n");
                // run API function
                vPar[0] = (int32_t) mxGetScalar(prhs[1]);
                rfic_read_txband(vPar[0],BandSel);

                // Create Matlab struct with same field names as pll_config
                plhs[0] = mxCreateDoubleMatrix(4,1,mxREAL);
                double* MatDblPr = (double *)mxGetData(plhs[0]);
                for (iK = 0; iK < 4; iK++)
                {
                    MatDblPr[iK] = (double) BandSel[iK];
                }

                // leave for() loop
                bFound = 1;
                break;
            }
            else if (0 == strcmp(input_buf, "rfic_read_rxband"))
            {
                check_parameter(nrhs,nPar[iFct]);
                mexPrintf("Executing rfic_read_txband:\n");
                // run API function
                vPar[0] = (int32_t) mxGetScalar(prhs[1]);
                rfic_read_rxband(vPar[0],BandSel);

                // Create Matlab struct with same field names as pll_config
                plhs[0] = mxCreateDoubleMatrix(4,1,mxREAL);
                double* MatDblPr = (double *)mxGetData(plhs[0]);
                for (iK = 0; iK < 4; iK++)
                {
                    MatDblPr[iK] = (double) BandSel[iK];
                }

                // leave for() loop
                bFound = 1;
                break;
            }
            else if (0 == strcmp(input_buf, "rfic_set_antenna_fectl_man_par"))
            {
                check_parameter(nrhs,nPar[iFct]);
                mexPrintf("Executing rfic_set_antenna_fectl_man_par:\n");
                
                vPar[0] = (int) mxGetScalar(prhs[1]);
                memcpy(double_data, mxGetPr(prhs[2]), 4*sizeof(double));
                for(iK=0; iK<4; iK++)
                {
                    Fectl[iK] = (uint8_t) double_data[iK];
                    mexPrintf("%d ", Fectl[iK]);
                }
                mexPrintf("]\n");
                memcpy(double_data, mxGetPr(prhs[1]), 4*sizeof(double));
                rfic_set_antenna_fectl_man_par(vPar[0],&Fectl[0]);
                // leave for() loop
                bFound = 1;
                break;
            }
            else
            {


                // check number of parameters
                check_parameter(nrhs,nPar[iFct]);
                // display function name and parameter values
                mexPrintf("Executing %s: ", tApi[iFct]);
                for (iPar = 0; iPar < nPar[iFct]; iPar++)
                {
                    vPar[iPar] = (int) mxGetScalar(prhs[iPar+1]);
                    mexPrintf("%s=%d ", tPar[iFct][iPar], vPar[iPar]);
                }
                mexPrintf("\n");
                // run API function
                if (nPar[iFct] == 0)
                    pApi[iFct]();
                else if (nPar[iFct] == 1)
                    pApi[iFct](vPar[0]);
                else if (nPar[iFct] == 2)
                    pApi[iFct](vPar[0],vPar[1]);
                else if (nPar[iFct] == 3)
                    pApi[iFct](vPar[0],vPar[1],vPar[2]);
                else if (nPar[iFct] == 4)
                    pApi[iFct](vPar[0],vPar[1],vPar[2],vPar[3]);
                else if (nPar[iFct] == 5)
                    pApi[iFct](vPar[0],vPar[1],vPar[2],vPar[3],vPar[4]);
                else if (nPar[iFct] == 6)
                    pApi[iFct](vPar[0],vPar[1],vPar[2],vPar[3],vPar[4],vPar[5]);
                else if (nPar[iFct] == 7)
                    pApi[iFct](vPar[0],vPar[1],vPar[2],vPar[3],vPar[4],vPar[5],vPar[6]);
                else if (nPar[iFct] == 8)
                    pApi[iFct](vPar[0],vPar[1],vPar[2],vPar[3],vPar[4],vPar[5],vPar[6],vPar[7]);
                else if (nPar[iFct] == 9)
                    pApi[iFct](vPar[0],vPar[1],vPar[2],vPar[3],vPar[4],vPar[5],vPar[6],vPar[7],vPar[8]);
                else if (nPar[iFct] == 15)
                    pApi[iFct](vPar[0],vPar[1],vPar[2],vPar[3],vPar[4],vPar[5],vPar[6],vPar[7],vPar[8],vPar[9],vPar[10],vPar[11],vPar[12],vPar[13],vPar[14]);
                else
                    mexErrMsgTxt("Unidentified Function Type.");
            }
            // leave for() loop
            bFound = 1;
            break;
        }
    }
    // then check for functions with integer output
    for (iFct = 0; iFct < nFuncI; iFct++)
    {
        if (0 == strcmp(input_buf, tApiI[iFct]))
        {
            if (0 == strcmp(input_buf, "rfic_read_efuse_values"))
            {
                mexPrintf("Executing rfic_read_efuse_values:\n");
                if (nrhs < 3)
                {
                    mexPrintf("Read eFuse Values from Chip ...\n");
                    int16_data[15] = 0;
                    if (nrhs < 2)
                        vPar[0] = 1;
                    else
                        vPar[0] = (int) mxGetScalar(prhs[1]);
                }
                else
                {
                    check_parameter(nrhs,2);
                    mexPrintf("Read eFuse Values from Softfuse Data ...\n");
                    vPar[0] = (int) mxGetScalar(prhs[1]);
                    if (!(mxGetN(prhs[2])==16 | mxGetM(prhs[2])==16))
                        mexErrMsgTxt("Array size must be at least 16 parameters\n");
                    memcpy(double_data, mxGetPr(prhs[2]), 16*sizeof(double));
                    for(iK=0; iK<16; iK++)
                    {
                        int16_data[iK] = (uint16_t) double_data[iK];
                        mexPrintf("SoftFuseData[%d]: 0x%04x\n", iK, int16_data[iK]);
                    }
                }
                sOut = rfic_read_efuse_values(vPar[0], &int16_data[0]);
                mexPrintf("Section Mask: %d\n", vPar[0]);
                mexPrintf("Chip Fused or Valid Softfuse Data: %d\n", sOut);
                plhs[0] = mxCreateDoubleScalar((double) sOut);
            }
            else if (0 == strcmp(input_buf, "rfic_read_efuse_handlertemp") | 0 == strcmp(input_buf, "rfic_read_efuse_tempsensorresult"))
            {
                mexPrintf("Executing %s:\n", tApiI[iFct]);
                if (nrhs < 2)
                {
                    mexPrintf("... from Chip ...\n");
                    int16_data[15] = 0;
                }
                else
                {
                    check_parameter(nrhs,1);
                    mexPrintf("... from Softfuse Data ...\n");
                    if (!(mxGetN(prhs[2])==16 | mxGetM(prhs[2])==16))
                        mexErrMsgTxt("Array size must be at least 16 parameters\n");
                    memcpy(double_data, mxGetPr(prhs[1]), 16*sizeof(double));
                    for(iK=0; iK<16; iK++)
                    {
                        int16_data[iK] = (uint16_t) double_data[iK];
                        mexPrintf("SoftFuseData[%d]: 0x%04x\n", iK, int16_data[iK]);
                    }
                }
                sOut = pApiI[iFct](&int16_data[0]);
                plhs[0] = mxCreateDoubleScalar((double) sOut);
            }
            else
            {
                // check number of parameters
                check_parameter(nrhs,nParI[iFct]);
                // display function name and parameter values
                mexPrintf("Executing %s: ", tApiI[iFct]);
                for (iPar = 0; iPar < nParI[iFct]; iPar++)
                {
                    vPar[iPar] = (int) mxGetScalar(prhs[iPar+1]);
                    mexPrintf("%s=%d,", tParI[iFct][iPar], vPar[iPar]);
                }
                mexPrintf("\n");
                // run API function
                if (nParI[iFct] == 0)
                    sOut = pApiI[iFct]();
                else if (nParI[iFct] == 1)
                    sOut = pApiI[iFct](vPar[0]);
                else if (nParI[iFct] == 2)
                    sOut = pApiI[iFct](vPar[0],vPar[1]);
                else if (nParI[iFct] == 3)
                    sOut = pApiI[iFct](vPar[0],vPar[1],vPar[2]);
                else if (nParI[iFct] == 8)
                    sOut = pApiI[iFct](vPar[0],vPar[1],vPar[2],vPar[3],vPar[4],vPar[5],vPar[6],vPar[7]);
                else
                    mexErrMsgTxt("Unidentified Function Type.");
                // convert to Matlab double output format
                plhs[0] = mxCreateDoubleScalar((double) sOut);
            }
            // leave for() loop
            bFound = 1;
            break;
        }
    }

    // then check for functions with struct output
    for (iFct = 0; iFct < nFuncR; iFct++)
    {
        if (0 == strcmp(input_buf, tApiR[iFct]))
        {
            if (0 == strcmp(input_buf, "rfic_get_pll_status"))
            {
                mexPrintf("Executing rfic_get_pll_status:\n");
                // convert PLL index parameter
                vPar[0] = (int) mxGetScalar(prhs[1]);
                mexPrintf("... from PLL%d\n", vPar[0]);
                // run API function
                PllCfg = rfic_get_pll_status(vPar[0]);

                // Create Matlab struct with same field names as pll_config
                plhs[0] = mxCreateStructArray(2, PllCfgDim, NUM_OF_PLLFIELDS, PllCfgFieldNames);

                for (iK = 0; iK < NUM_OF_PLLFIELDS; iK++)
                {
                    FieldIdx[iK] = mxGetFieldNumber(plhs[0], PllCfgFieldNames[iK]);

                    if (iK == 0)
                        FieldVal = mxCreateDoubleScalar((double) PllCfg.Active);
                    else if (iK == 1)
                        FieldVal = mxCreateDoubleScalar((double) PllCfg.Reset);
                    else if (iK == 2)
                    {
                        FieldVal = mxCreateDoubleScalar((double) PllCfg.HbLb);
                    }
                    else if (iK == 3)
                    {
                        FieldVal = mxCreateDoubleMatrix(1,6,mxREAL);
                        for (iF = 0; iF < 6; iF++)
                            LoFreqsDbl[iF] = (double) PllCfg.LoFreqs[iF];
                        memcpy(mxGetPr(FieldVal), LoFreqsDbl, 6 * sizeof(double));
                    }
                    else if (iK == 4)
                        FieldVal = mxCreateDoubleScalar((double) PllCfg.LoFreqAct);
                    else if (iK == 5)
                        FieldVal = mxCreateDoubleScalar((double) PllCfg.RefClk);
                    else if (iK == 6)
                        FieldVal = mxCreateDoubleScalar((double) PllCfg.IntFrac);
                    else if (iK == 7)
                        FieldVal = mxCreateDoubleScalar((double) PllCfg.HiPwr);
                    else if (iK == 8)
                        FieldVal = mxCreateDoubleScalar((double) PllCfg.AntSet);
                    else if (iK == 9)
                        FieldVal = mxCreateDoubleScalar((double) PllCfg.FastHop);
                    else if (iK == 10)
                        FieldVal = mxCreateDoubleScalar((double) PllCfg.FhMaster);
                    mxSetFieldByNumber(plhs[0],0,FieldIdx[iK],FieldVal);
                }
                // leave for() loop
                bFound = 1;
                break;
            }
            else if (0 == strcmp(input_buf, "rfic_get_rxgain_status"))
            {
                mexPrintf("Executing rfic_get_rxgain_status:\n");
                // convert PLL index parameter
                vPar[0] = (int) mxGetScalar(prhs[1]);
                mexPrintf("... from Ant%d\n", vPar[0]);
                // run API function
                RxGainCfg = rfic_get_rxgain_status(vPar[0]);

                // Create Matlab struct with same field names as pll_config
                plhs[0] = mxCreateStructArray(2, RxGainCfgDim, NUM_OF_RXGFIELDS, RxGainCfgFieldNames);

                for (iK = 0; iK < NUM_OF_RXGFIELDS; iK++)
                {
                    FieldIdx[iK] = mxGetFieldNumber(plhs[0], RxGainCfgFieldNames[iK]);

                    if (iK == 0)
                    {
                        FieldVal = mxCreateDoubleMatrix(1,7,mxREAL);
                        for (iF = 0; iF < 7; iF++)
                            ArrTmpDbl[iF] = (double) RxGainCfg.LnaGainCfg[iF];
                        memcpy(mxGetPr(FieldVal), ArrTmpDbl, 7 * sizeof(double));
                    }
                    else if (iK == 1)
                    {
                        FieldVal = mxCreateDoubleMatrix(1,7,mxREAL);
                        for (iF = 0; iF < 7; iF++)
                            ArrTmpDbl[iF] = (double) RxGainCfg.FectlCfg[iF];
                        memcpy(mxGetPr(FieldVal), ArrTmpDbl, 7 * sizeof(double));
                    }
                    else if (iK == 2)
                    {
                        FieldVal = mxCreateDoubleMatrix(1,4,mxREAL);
                        for (iF = 0; iF < 4; iF++)
                            ArrTmpDbl[iF] = (double) RxGainCfg.RfGainIdx[iF];
                        memcpy(mxGetPr(FieldVal), ArrTmpDbl, 4 * sizeof(double));
                    }
                    else if (iK == 3)
                    {
                        FieldVal = mxCreateDoubleMatrix(1,4,mxREAL);
                        for (iF = 0; iF < 4; iF++)
                            ArrTmpDbl[iF] = (double) RxGainCfg.RssiRange[iF];
                        memcpy(mxGetPr(FieldVal), ArrTmpDbl, 4 * sizeof(double));
                    }
                    else if (iK == 4)
                    {
                        FieldVal = mxCreateDoubleMatrix(1,4,mxREAL);
                        for (iF = 0; iF < 4; iF++)
                            ArrTmpDbl[iF] = (double) RxGainCfg.PgcGainIdx[iF];
                        memcpy(mxGetPr(FieldVal), ArrTmpDbl, 4 * sizeof(double));
                    }
                    else if (iK == 5)
                    {
                        FieldVal = mxCreateDoubleMatrix(1,4,mxREAL);
                        for (iF = 0; iF < 4; iF++)
                            ArrTmpDbl[iF] = (double) RxGainCfg.PgcFiltIdx[iF];
                        memcpy(mxGetPr(FieldVal), ArrTmpDbl, 4 * sizeof(double));
                    }
                    else if (iK == 6)
                        FieldVal = mxCreateDoubleScalar((double) RxGainCfg.ShortReg3);
                    else if (iK == 7)
                        FieldVal = mxCreateDoubleScalar((double) RxGainCfg.ForceOff);
                    else if (iK == 8)
                        FieldVal = mxCreateDoubleScalar((double) RxGainCfg.DirStepIdx);
                    mxSetFieldByNumber(plhs[0],0,FieldIdx[iK],FieldVal);
                }
                // leave for() loop
                bFound = 1;
                break;
            }
            else
            {
                // check number of parameters
                check_parameter(nrhs,nParR[iFct]);
                // display function name and parameter values
                mexPrintf("Executing %s: ", tApiR[iFct]);
                mexPrintf("Don't know what to do ...\n");
                // leave for() loop
                bFound = 1;
                break;
            }
        }
    }


    if (bFound == 0)
    {
        mexPrintf("Unknown API Function %s!", input_buf);
        mexErrMsgTxt("API Function Parser aborted!");
    }

    mxFree(input_buf);
    return;
}

// wait function
void RFIC_Wait(uint32_t cnt)
{
    double pauseTime = ((double) cnt) * 1.0e-6;
    mxArray *prhs = mxCreateDoubleScalar(pauseTime);
    mexCallMATLAB(0, NULL, 1, &prhs, "pause");
}

void RFIC_FCSI_Write_mex(uint16_t AntMsk, uint16_t address, uint16_t value)
{
    mxArray  *input_array[4];

    input_array[0]=mxCreateDoubleScalar((double)AntMsk);
    input_array[1]=mxCreateDoubleScalar((double)address);
    input_array[2]=mxCreateDoubleScalar((double)value);
    input_array[3]=mxCreateDoubleScalar((double)DEBUG);

    mexCallMATLAB( 0,NULL, 4 ,&input_array[0],"FCSI_WRITE");
}

void RFIC_FCSI_ParWrite_mex(uint16_t AntMsk, uint16_t address, uint16_t *values)
{
    mxArray     *input_array[4];
    uint8_t     iV;
    double      ValuesDbl[5];

    // scalar inputs
    input_array[0]=mxCreateDoubleScalar((double)AntMsk);
    input_array[1]=mxCreateDoubleScalar((double)address);
    input_array[3]=mxCreateDoubleScalar((double)DEBUG);

    // values is now a 5-element array
    input_array[2] = mxCreateDoubleMatrix(1,5,mxREAL);
    for (iV = 0; iV < 5; iV++)
        ValuesDbl[iV] = (double) values[iV];
    memcpy(mxGetPr(input_array[2]), ValuesDbl, 5 * sizeof(double));

    mexCallMATLAB( 0,NULL, 4 ,&input_array[0],"FCSI_WRITE");
}

void RFIC_FCSI_RMW_mex(uint16_t AntMsk,uint16_t  address,uint16_t mask, uint16_t value)
{
    mxArray  *input_array[5];

    input_array[0]=mxCreateDoubleScalar((double)AntMsk);
    input_array[1]=mxCreateDoubleScalar((double)address);
    input_array[2]=mxCreateDoubleScalar((double)mask);
    input_array[3]=mxCreateDoubleScalar((double)value);
    input_array[4]=mxCreateDoubleScalar((double)DEBUG);

    mexCallMATLAB( 0,NULL, 5 ,&input_array[0],"FCSI_RMW");

}

void RFIC_FCSI_ParRMW_mex(uint16_t AntMsk,uint16_t  address,uint16_t mask, uint16_t *values)
{
    mxArray     *input_array[5];
    uint8_t     iV;
    double      ValuesDbl[5];

    // scalar inputs
    input_array[0]=mxCreateDoubleScalar((double)AntMsk);
    input_array[1]=mxCreateDoubleScalar((double)address);
    input_array[2]=mxCreateDoubleScalar((double)mask);
    input_array[4]=mxCreateDoubleScalar((double)DEBUG);

    // values is now a 5-element array
    input_array[3] = mxCreateDoubleMatrix(1,5,mxREAL);
    for (iV = 0; iV < 5; iV++)
        ValuesDbl[iV] = (double) values[iV];
    memcpy(mxGetPr(input_array[3]), ValuesDbl, 5 * sizeof(double));

    mexCallMATLAB( 0,NULL, 5 ,&input_array[0],"FCSI_RMW");

}

uint16_t RFIC_FCSI_Read_mex(uint16_t AntMsk, uint16_t address, uint16_t *rdata)
{
    mxArray  *input_array[3];
    mxArray  *output_array[1];
    double_t *read_par;
    int k;

    input_array[0]=mxCreateDoubleScalar((double)AntMsk);
    input_array[1]=mxCreateDoubleScalar((double)address);
    input_array[2]=mxCreateDoubleScalar((double)DEBUG);

    mexCallMATLAB( 1,output_array, 3 ,input_array,"FCSI_READ");

    k = mxGetM(output_array[0]);     // number of colums
    if (k<5)  mexErrMsgTxt("array size must be at least 5 parameters");

    read_par = mxGetPr(output_array[0]);

    rdata[0]     = (uint16_t) read_par[0];
    rdata[1]     = (uint16_t) read_par[1];
    rdata[2]     = (uint16_t) read_par[2];
    rdata[3]     = (uint16_t) read_par[3];
    rdata[4]     = (uint16_t) read_par[4];

    return 0;
}
