% close all; clear all;

% constants
ANT0 = 1;
ANT1 = 2;
ANT2 = 4;
ANT3 = 8;
ANTALL = ANT0+ANT1+ANT2+ANT3;
CENTRAL = 16;

% parameters
sPll    = 0;            % select PLL0
sAntSet = ANTALL;  % select ANT0+1
sRefClk = 20;           % 20 MHz Ref Clock
sLoFreq = 5250;

% generate WRX654 object
oWRX = WRX_654;

% RFIC initialization
oWRX.init_1(sAntSet);
pause(0.05);
oWRX.init_2(sAntSet);
oWRX.init_3(sAntSet);
pause(0.3);

% disable the unused PLL
% oWRX.disable_pll(sPll == 0);

% program PLLx to 5G Integer mode with RefClk ref clk (PLL resets automatically)
oWRX.set_pll_mode(sPll, 1, sRefClk, 1);
% set PLLx HB single frequency
oWRX.set_lo_frequency_intn(sPll, sLoFreq, 1, sRefClk);
pause(0.5);
% release PLLx
oWRX.release_pllreset(sPll);
pause(0.5);
% set Central LO switches for AntSet to PLLx HB output and activate HB LO LDO
oWRX.select_pll(sAntSet, sPll, 1);

% activate HB for AntSet
oWRX.activate_hb(sAntSet);

% set LNA Gain
oWRX.set_lnagain(sAntSet, 3);

% set PGC Gain
oWRX.set_pgcgain(sAntSet, 20);

% set power mode
oWRX.set_powermode(sAntSet,0);

% set bandwidth
oWRX.set_bandwidth(sAntSet,160);

% switch RX ON
oWRX.rxon(sAntSet);




