% close all; clear all;

% constants
ANT0 = 1;
ANT1 = 2;
ANT2 = 4;
ANT3 = 8;
ANTALL = ANT0+ANT1+ANT2+ANT3;
CENTRAL = 16;

% parameters
sPll    = 0;            % select PLL0
sAntSet = ANTALL;  % select ANT0+1
sLoFreq = 2412;

% generate WRX654 object
oWRX = WRX_654;

% RFIC initialization
oWRX.init_1(sAntSet);
pause(0.05);
oWRX.init_2(sAntSet);
oWRX.init_3(sAntSet);
pause(0.3);

% disable the unused PLL
% oWRX.disable_pll(sPll == 0);

% program PLLx to 2G Frac-N mode (PLL resets automatically)
oWRX.set_pll_2G(sPll);
% set PLLx LB single frequency
oWRX.set_lo_frequency_fracn(sPll, sLoFreq, 0);
pause(0.5);
% release PLLx
oWRX.release_pllreset(sPll);
pause(0.5);
% set Central LO switches for AntSet to PLLx LB output and activate LB LO LDO
oWRX.select_pll(sAntSet, sPll, 0);

% activate LB for AntSet
oWRX.activate_lb(sAntSet);

% set LNA Gain
oWRX.set_lnagain(sAntSet, 3);

% set PGC Gain
oWRX.set_pgcgain(sAntSet, 20);

% set power mode
oWRX.set_powermode(sAntSet,0);

% set bandwidth
oWRX.set_bandwidth(sAntSet,40);

% switch RX ON
oWRX.rxon(sAntSet);

