// -------------------------------------------------------------
// 
// File Name: C:\repo\perforce\wrx600_vdfv\ipg_fc\wrx654\model\run\TSSI\hdlsrc\TSSI_core.v
// Created: 2018-03-02 09:04:32
// 
// Generated by MATLAB 9.3, MATLAB Coder 3.4 and HDL Coder 3.11
// 
// 
// 
// -- -------------------------------------------------------------
// -- Rate and Clocking Details
// -- -------------------------------------------------------------
// Design base rate: 1
// 
// -------------------------------------------------------------


// -------------------------------------------------------------
// 
// Module: TSSI_core
// Source Path: TSSI_core
// Hierarchy Level: 0
// 
// -------------------------------------------------------------

`timescale 1 ns / 1 ns

module TSSI_core
          (clk,
           reset_n,
           TSSI_SENSE_5G,
           TSSI_SENSE_2G,
           TSSI_S2D_IN,
           TSSI_OFFSET_CTRL,
           TSSI_GAIN_CTRL,
           TSSI_VTAP_SELECT,
           HBLB,
           TSSI_ENABLE_V2I,
           TSSI_ENABLE_COS_CTRL,
           TSSI_ENABLE_S2D,
           IREF_P2R_25u_ODAC,
           IREF_P2R_25u_S2D,
           IB_PIO_CONST_25u,
           VDDA1V2,
           VDDRF2V5LDO,
           VDDD3V3FECTL,
           VSS,
           VSSA_LDO2V5,
           VSSDFECTL,
           TSSI_S2D_OUTP,
           TSSI_S2D_OUTN);


  input   clk;
  input   reset_n;
  input   signed [23:0] TSSI_SENSE_5G;  // sfix24_En21
  input   signed [23:0] TSSI_SENSE_2G;  // sfix24_En21
  input   signed [23:0] TSSI_S2D_IN;  // sfix24_En23
  input   [4:0] TSSI_OFFSET_CTRL;  // ufix5
  input   [3:0] TSSI_GAIN_CTRL;  // ufix4
  input   TSSI_VTAP_SELECT;
  input   HBLB;
  input   TSSI_ENABLE_V2I;
  input   TSSI_ENABLE_COS_CTRL;
  input   TSSI_ENABLE_S2D;
  input   [1:0] IREF_P2R_25u_ODAC;  // ufix2
  input   IREF_P2R_25u_S2D;
  input   [1:0] IB_PIO_CONST_25u;  // ufix2
  input   VDDA1V2;
  input   VDDRF2V5LDO;
  input   VDDD3V3FECTL;
  input   VSS;
  input   VSSA_LDO2V5;
  input   VSSDFECTL;
  output  signed [23:0] TSSI_S2D_OUTP;  // sfix24_En21
  output  signed [23:0] TSSI_S2D_OUTN;  // sfix24_En21

  reg  TSSI_VTAP_SELECT_1;
  wire signed [23:0] oResDiv;  // sfix24_En21
  reg signed [23:0] oResDiv_1;  // sfix24_En21
  wire signed [23:0] oResDiv_2;  // sfix24_En21
  reg  HBLB_1;
  reg signed [23:0] TSSI_SENSE_2G_1;  // sfix24_En21
  reg  VDDA1V2_1;
  reg  VDDD3V3FECTL_1;
  wire tmp;
  reg  VSSDFECTL_1;
  wire tmp_1;
  wire tmp_2;
  wire varargin_1;
  reg  varargin_1_1;
  wire varargin_1_2;
  reg [1:0] IB_PIO_CONST_25u_1;  // ufix2
  wire tmp_3;
  reg  VSS_1;
  wire tmp_4;
  wire tmp_5;
  wire varargin_1_3;
  reg  varargin_1_4;
  wire varargin_1_5;
  reg signed [23:0] TSSI_S2D_IN_1;  // sfix24_En23
  wire signed [24:0] tmp_6;  // sfix25_En23
  reg signed [23:0] oResDiv_3;  // sfix24_En21
  wire signed [23:0] tmp_7;  // sfix24_En21
  reg signed [23:0] TSSI_SENSE_5G_1;  // sfix24_En21
  wire signed [23:0] tmp_8;  // sfix24_En21
  wire signed [47:0] tmp_9;  // sfix48_En42
  wire signed [71:0] tmp_10;  // sfix72_En42
  wire signed [60:0] p90tmp_div_temp;  // sfix61_En42
  wire signed [60:0] p90tmp_cast;  // sfix61_En55
  reg  TSSI_ENABLE_V2I_1;
  wire tmp_11;  // ufix1
  wire signed [71:0] multiplier_in1;  // sfix72_En42
  wire signed [72:0] multiplier_cast;  // sfix73_En42
  wire signed [71:0] tmp_12;  // sfix72_En42
  wire signed [72:0] tmp_13;  // sfix73_En42
  reg  varargin_1_6;
  wire tmp_14;
  wire tmp_15;  // ufix1
  wire signed [72:0] multiplier_in1_1;  // sfix73_En42
  wire signed [73:0] multiplier_cast_1;  // sfix74_En42
  wire signed [72:0] tmp_16;  // sfix73_En42
  wire signed [73:0] tmp_17;  // sfix74_En42
  wire bBiasV2I;
  wire tmp_18;  // ufix1
  wire signed [73:0] multiplier_in1_2;  // sfix74_En42
  wire signed [74:0] multiplier_cast_2;  // sfix75_En42
  wire signed [73:0] tmp_19;  // sfix74_En42
  wire signed [74:0] tmp_20;  // sfix75_En42
  wire signed [23:0] tmp_21;  // sfix24_En23
  wire signed [24:0] tmp_22;  // sfix25_En23
  wire signed [25:0] adder_add_cast;  // sfix26_En23
  wire signed [25:0] adder_add_cast_1;  // sfix26_En23
  wire signed [25:0] adder_add_temp;  // sfix26_En23
  wire signed [24:0] tmp_23;  // sfix25_En23
  wire signed [25:0] tmp_24;  // sfix26_En23
  reg [4:0] TSSI_OFFSET_CTRL_1;  // ufix5
  wire signed [28:0] tmp_25;  // sfix29_En23
  wire signed [5:0] p89tmp_cast;  // sfix6
  wire signed [29:0] p89tmp_mul_temp;  // sfix30_En23
  reg  TSSI_ENABLE_COS_CTRL_1;
  wire tmp_26;  // ufix1
  wire signed [28:0] multiplier_in1_3;  // sfix29_En23
  wire signed [29:0] multiplier_cast_3;  // sfix30_En23
  wire signed [28:0] tmp_27;  // sfix29_En23
  wire signed [29:0] tmp_28;  // sfix30_En23
  reg  varargin_1_7;
  wire tmp_29;
  wire tmp_30;  // ufix1
  wire signed [29:0] multiplier_in1_4;  // sfix30_En23
  wire signed [30:0] multiplier_cast_4;  // sfix31_En23
  wire signed [29:0] tmp_31;  // sfix30_En23
  wire signed [30:0] tmp_32;  // sfix31_En23
  reg [1:0] IREF_P2R_25u_ODAC_1;  // ufix2
  wire bBiasOC;
  wire tmp_33;  // ufix1
  wire signed [30:0] multiplier_in1_5;  // sfix31_En23
  wire signed [31:0] multiplier_cast_5;  // sfix32_En23
  wire signed [30:0] tmp_34;  // sfix31_En23
  wire signed [31:0] tmp_35;  // sfix32_En23
  wire signed [23:0] tmp_36;  // sfix24_En23
  wire signed [25:0] tmp_37;  // sfix26_En23
  wire signed [26:0] adder_add_cast_2;  // sfix27_En23
  wire signed [26:0] adder_add_cast_3;  // sfix27_En23
  wire signed [26:0] adder_add_temp_1;  // sfix27_En23
  wire signed [25:0] tmp_38;  // sfix26_En23
  reg signed [25:0] tmp_39;  // sfix26_En23
  reg [3:0] TSSI_GAIN_CTRL_1;  // ufix4
  wire [4:0] tmp_40;  // ufix5
  wire [4:0] tmp_41;  // ufix5
  wire signed [31:0] tmp_42;  // int32
  wire signed [31:0] tmp_43;  // int32
  wire [23:0] tmp_44;  // ufix24_En19
  wire [23:0] tmp_lut_tmp [0:15];  // ufix24_En19 [16]
  reg [23:0] tmp_45;  // ufix24_En19
  wire signed [24:0] multiplier_cast_6;  // sfix25_En19
  wire signed [50:0] multiplier_mul_temp;  // sfix51_En42
  wire signed [49:0] tmp_46;  // sfix50_En42
  wire signed [73:0] tmp_47;  // sfix74_En55
  wire signed [74:0] tmp_48;  // sfix75_En56
  wire signed [74:0] c_21;  // sfix75_En56
  reg  TSSI_ENABLE_S2D_1;
  wire tmp_49;  // ufix1
  reg  tmp_50;  // ufix1
  wire signed [74:0] multiplier_in1_6;  // sfix75_En56
  wire signed [75:0] multiplier_cast_7;  // sfix76_En56
  wire signed [74:0] tmp_51;  // sfix75_En56
  wire signed [75:0] tmp_52;  // sfix76_En56
  reg  VDDRF2V5LDO_1;
  wire tmp_53;
  wire tmp_54;
  reg  VSSA_LDO2V5_1;
  wire tmp_55;
  wire tmp_56;
  wire varargin_1_8;
  reg  varargin_1_9;
  wire varargin_1_10;
  reg  varargin_1_11;
  wire tmp_57;
  wire tmp_58;  // ufix1
  reg  tmp_59;  // ufix1
  wire signed [75:0] multiplier_in1_7;  // sfix76_En56
  wire signed [76:0] multiplier_cast_8;  // sfix77_En56
  wire signed [75:0] tmp_60;  // sfix76_En56
  wire signed [76:0] tmp_61;  // sfix77_En56
  wire tmp_62;
  reg  IREF_P2R_25u_S2D_1;
  wire tmp_63;
  wire varargin_1_12;
  reg  varargin_1_13;
  wire varargin_1_14;
  reg  varargin_1_15;
  wire tmp_64;
  wire tmp_65;  // ufix1
  reg  tmp_66;  // ufix1
  wire signed [76:0] multiplier_in1_8;  // sfix77_En56
  wire signed [77:0] multiplier_cast_9;  // sfix78_En56
  wire signed [76:0] tmp_67;  // sfix77_En56
  wire signed [77:0] tmp_68;  // sfix78_En56
  wire signed [23:0] tmp_69;  // sfix24_En21
  wire signed [24:0] tmp_70;  // sfix25_En21
  wire signed [24:0] tmp_71;  // sfix25_En21
  wire signed [25:0] p84tmp_cast;  // sfix26_En21
  wire signed [25:0] p84tmp_cast_1;  // sfix26_En21
  wire signed [23:0] tmp_72;  // sfix24_En21
  reg signed [23:0] TSSI_S2D_OUTP_1;  // sfix24_En21
  reg signed [23:0] TSSI_S2D_OUTN_1;  // sfix24_En21


  always @(posedge clk or negedge reset_n)
    begin : TSSI_VTAP_SELECT_reg_process
      if (reset_n == 1'b0) begin
        TSSI_VTAP_SELECT_1 <= 1'b0;
      end
      else begin
        TSSI_VTAP_SELECT_1 <= TSSI_VTAP_SELECT;
      end
    end



  // HDL code generation from MATLAB function: TSSI_core_falseregionp106
  assign oResDiv = 24'sb000100110011001100110011;



  always @(posedge clk or negedge reset_n)
    begin : delayMatch_process
      if (reset_n == 1'b0) begin
        oResDiv_1 <= 24'sb000000000000000000000000;
      end
      else begin
        oResDiv_1 <= oResDiv;
      end
    end



  // HDL code generation from MATLAB function: TSSI_core_trueregionp106
  assign oResDiv_2 = 24'sb000111001100110011001101;



  always @(posedge clk or negedge reset_n)
    begin : HBLB_reg_process
      if (reset_n == 1'b0) begin
        HBLB_1 <= 1'b0;
      end
      else begin
        HBLB_1 <= HBLB;
      end
    end



  always @(posedge clk or negedge reset_n)
    begin : TSSI_SENSE_2G_reg_process
      if (reset_n == 1'b0) begin
        TSSI_SENSE_2G_1 <= 24'sb000000000000000000000000;
      end
      else begin
        TSSI_SENSE_2G_1 <= TSSI_SENSE_2G;
      end
    end



  always @(posedge clk or negedge reset_n)
    begin : VDDA1V2_reg_process
      if (reset_n == 1'b0) begin
        VDDA1V2_1 <= 1'b0;
      end
      else begin
        VDDA1V2_1 <= VDDA1V2;
      end
    end



  always @(posedge clk or negedge reset_n)
    begin : VDDD3V3FECTL_reg_process
      if (reset_n == 1'b0) begin
        VDDD3V3FECTL_1 <= 1'b0;
      end
      else begin
        VDDD3V3FECTL_1 <= VDDD3V3FECTL;
      end
    end



  // check supplies
  assign tmp = VDDA1V2_1 & VDDD3V3FECTL_1;



  always @(posedge clk or negedge reset_n)
    begin : VSSDFECTL_reg_process
      if (reset_n == 1'b0) begin
        VSSDFECTL_1 <= 1'b0;
      end
      else begin
        VSSDFECTL_1 <= VSSDFECTL;
      end
    end



  assign tmp_1 =  ~ VSSDFECTL_1;



  assign tmp_2 = tmp & tmp_1;



  // HDL code generation from MATLAB function: TSSI_core_falseregionp103
  assign varargin_1 = 1'b0;



  always @(posedge clk or negedge reset_n)
    begin : delayMatch_1_process
      if (reset_n == 1'b0) begin
        varargin_1_1 <= 1'b0;
      end
      else begin
        varargin_1_1 <= varargin_1;
      end
    end



  // HDL code generation from MATLAB function: TSSI_core_trueregionp103
  assign varargin_1_2 = 1'b1;



  always @(posedge clk or negedge reset_n)
    begin : IB_PIO_CONST_25u_reg_process
      if (reset_n == 1'b0) begin
        IB_PIO_CONST_25u_1 <= 2'b00;
      end
      else begin
        IB_PIO_CONST_25u_1 <= IB_PIO_CONST_25u;
      end
    end



  assign tmp_3 = VDDA1V2_1 & VDDD3V3FECTL_1;



  always @(posedge clk or negedge reset_n)
    begin : VSS_reg_process
      if (reset_n == 1'b0) begin
        VSS_1 <= 1'b0;
      end
      else begin
        VSS_1 <= VSS;
      end
    end



  assign tmp_4 =  ~ VSS_1;



  assign tmp_5 = tmp_3 & tmp_4;



  // HDL code generation from MATLAB function: TSSI_core_falseregionp100
  assign varargin_1_3 = 1'b0;



  always @(posedge clk or negedge reset_n)
    begin : delayMatch_2_process
      if (reset_n == 1'b0) begin
        varargin_1_4 <= 1'b0;
      end
      else begin
        varargin_1_4 <= varargin_1_3;
      end
    end



  // HDL code generation from MATLAB function: TSSI_core_trueregionp100
  assign varargin_1_5 = 1'b1;



  always @(posedge clk or negedge reset_n)
    begin : TSSI_S2D_IN_reg_process
      if (reset_n == 1'b0) begin
        TSSI_S2D_IN_1 <= 24'sb000000000000000000000000;
      end
      else begin
        TSSI_S2D_IN_1 <= TSSI_S2D_IN;
      end
    end



  assign tmp_6 = {TSSI_S2D_IN_1[23], TSSI_S2D_IN_1};



  always @(posedge clk or negedge reset_n)
    begin : delayMatch_3_process
      if (reset_n == 1'b0) begin
        oResDiv_3 <= 24'sb000000000000000000000000;
      end
      else begin
        oResDiv_3 <= oResDiv_2;
      end
    end



  // Resistive divider selection
  // 
  // TSSI_VTAP_SELECT=1: 0.9 | TSSI_VTAP_SELECT=1: 0.9
  assign tmp_7 = (TSSI_VTAP_SELECT_1 == 1'b0 ? oResDiv_1 :
              oResDiv_3);



  always @(posedge clk or negedge reset_n)
    begin : TSSI_SENSE_5G_reg_process
      if (reset_n == 1'b0) begin
        TSSI_SENSE_5G_1 <= 24'sb000000000000000000000000;
      end
      else begin
        TSSI_SENSE_5G_1 <= TSSI_SENSE_5G;
      end
    end



  // HDL code generation from MATLAB function: TSSI_core
  // 
  // %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  // 
  //                                                                          %
  // 
  //           Generated by MATLAB 9.3 and Fixed-Point Designer 6.0           %
  // 
  //                                                                          %
  // 
  // %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  // 
  // TSSI - TSSI Behavioral Fix-Point Model for Matlab-to-Verilog Conversion
  // 
  // --- Authors -------------------------------------------------------------
  // 
  // Steffen Trautmann
  // 
  // -------------------------------------------------------------------------
  // 
  // --- Copyright -----------------------------------------------------------
  // 
  // Intel Austria GmbH, Connected Home Division, Villach
  // 
  // -------------------------------------------------------------------------
  // 
  // --------------------------------- Pin List ---------------------------------                            
  // 
  // module TSSI ( TSSI_S2D_OUTN, TSSI_S2D_OUTP, VDDA1V2, VDDRF2V5LDO, VDDD3V3FECTL,
  // 
  // VSS, IB_PIO_CONST_25u, IREF_P2R_25u_ODAC, TSSI_ENABLE_COS_CTRL, TSSI_ENABLE_S2D,
  // 
  // TSSI_ENABLE_V2I, TSSI_GAIN_CTRL, TSSI_OFFSET_CTRL, TSSI_S2D_IN, TSSI_SENSE_5G,
  // 
  // TSSI_VTAP_SELECT, IREF_P2R_25u_S2D, VSSDFECTL, TSSI_SENSE_2G, HBLB );
  // 
  //   input HBLB;
  // 
  //   input TSSI_SENSE_5G;
  // 
  //   output TSSI_S2D_OUTP;
  // 
  //   input TSSI_SENSE_2G;
  // 
  //   input TSSI_ENABLE_S2D;
  // 
  //   input  [1:0] IREF_P2R_25u_ODAC;
  // 
  //   input VDDD3V3FECTL;
  // 
  //   input VSSDFECTL;
  // 
  //   input IREF_P2R_25u_S2D;
  // 
  //   input TSSI_S2D_IN;
  // 
  //   input TSSI_ENABLE_V2I;
  // 
  //   input TSSI_ENABLE_COS_CTRL;
  // 
  //   input  [1:0] IB_PIO_CONST_25u;
  // 
  //   input TSSI_VTAP_SELECT;
  // 
  //   input  [4:0] TSSI_OFFSET_CTRL;
  // 
  //   input VSS;
  // 
  //   input VDDA1V2;
  // 
  //   output TSSI_S2D_OUTN;
  // 
  //   input  [3:0] TSSI_GAIN_CTRL;
  // 
  //   input VDDRF2V5LDO;
  // 
  // underlying fixed-point math rules
  // 
  // Highband/Lowband selection
  // 
  // HBLB=1: 5G | HBLB=0: 2G
  assign tmp_8 = (HBLB_1 == 1'b0 ? TSSI_SENSE_2G_1 :
              TSSI_SENSE_5G_1);



  // Reference resistor for V2I conversion (in kOhm!)
  // 
  // range: -1024..+1024 kOhm
  // 
  // V2I current Output 
  assign tmp_9 = tmp_7 * tmp_8;



  assign p90tmp_cast = {tmp_9, 13'b0000000000000};
  assign p90tmp_div_temp = p90tmp_cast / 24'sb000000001010000000000000;
  assign tmp_10 = {{11{p90tmp_div_temp[60]}}, p90tmp_div_temp};



  always @(posedge clk or negedge reset_n)
    begin : TSSI_ENABLE_V2I_reg_process
      if (reset_n == 1'b0) begin
        TSSI_ENABLE_V2I_1 <= 1'b0;
      end
      else begin
        TSSI_ENABLE_V2I_1 <= TSSI_ENABLE_V2I;
      end
    end



  assign tmp_11 = TSSI_ENABLE_V2I_1;



  assign multiplier_in1 = (tmp_11 == 1'b1 ? tmp_10 :
              72'sh000000000000000000);
  assign multiplier_cast = {multiplier_in1[71], multiplier_in1};
  assign tmp_12 = multiplier_cast[71:0];



  assign tmp_13 = {tmp_12[71], tmp_12};



  always @(posedge clk or negedge reset_n)
    begin : delayMatch_4_process
      if (reset_n == 1'b0) begin
        varargin_1_6 <= 1'b0;
      end
      else begin
        varargin_1_6 <= varargin_1_2;
      end
    end



  assign tmp_14 = (tmp_2 == 1'b0 ? varargin_1_1 :
              varargin_1_6);



  assign tmp_15 = tmp_14;



  assign multiplier_in1_1 = (tmp_15 == 1'b1 ? tmp_13 :
              73'sh0000000000000000000);
  assign multiplier_cast_1 = {multiplier_in1_1[72], multiplier_in1_1};
  assign tmp_16 = multiplier_cast_1[72:0];



  assign tmp_17 = {tmp_16[72], tmp_16};



  // check Biasing
  assign bBiasV2I = IB_PIO_CONST_25u_1[1] != 1'b0;



  assign tmp_18 = bBiasV2I;



  assign multiplier_in1_2 = (tmp_18 == 1'b1 ? tmp_17 :
              74'sh0000000000000000000);
  assign multiplier_cast_2 = {multiplier_in1_2[73], multiplier_in1_2};
  assign tmp_19 = multiplier_cast_2[73:0];



  assign tmp_20 = {tmp_19[73], tmp_19};



  assign tmp_21 = (((tmp_20[74] == 1'b0) && (tmp_20[73:42] != 32'b00000000000000000000000000000000)) || ((tmp_20[74] == 1'b0) && (tmp_20[42:19] == 24'sb011111111111111111111111)) ? 24'sb011111111111111111111111 :
              ((tmp_20[74] == 1'b1) && (tmp_20[73:42] != 32'b11111111111111111111111111111111) ? 24'sb100000000000000000000000 :
              tmp_20[42:19] + $signed({1'b0, tmp_20[18]})));



  assign tmp_22 = {tmp_21[23], tmp_21};



  assign adder_add_cast = {tmp_6[24], tmp_6};
  assign adder_add_cast_1 = {tmp_22[24], tmp_22};
  assign adder_add_temp = adder_add_cast + adder_add_cast_1;
  assign tmp_23 = ((adder_add_temp[25] == 1'b0) && (adder_add_temp[24] != 1'b0) ? 25'sb0111111111111111111111111 :
              ((adder_add_temp[25] == 1'b1) && (adder_add_temp[24] != 1'b1) ? 25'sb1000000000000000000000000 :
              $signed(adder_add_temp[24:0])));



  assign tmp_24 = {tmp_23[24], tmp_23};



  always @(posedge clk or negedge reset_n)
    begin : TSSI_OFFSET_CTRL_reg_process
      if (reset_n == 1'b0) begin
        TSSI_OFFSET_CTRL_1 <= 5'b00000;
      end
      else begin
        TSSI_OFFSET_CTRL_1 <= TSSI_OFFSET_CTRL;
      end
    end



  // range: -1..+1mA
  // 
  // Offset Current
  // 
  // Offset Control step size
  assign p89tmp_cast = {1'b0, TSSI_OFFSET_CTRL_1};
  assign p89tmp_mul_temp = p89tmp_cast * 24'sb111111110101110000101001;
  assign tmp_25 = ((p89tmp_mul_temp[29] == 1'b0) && (p89tmp_mul_temp[28] != 1'b0) ? 29'sb01111111111111111111111111111 :
              ((p89tmp_mul_temp[29] == 1'b1) && (p89tmp_mul_temp[28] != 1'b1) ? 29'sb10000000000000000000000000000 :
              $signed(p89tmp_mul_temp[28:0])));



  always @(posedge clk or negedge reset_n)
    begin : TSSI_ENABLE_COS_CTRL_reg_process
      if (reset_n == 1'b0) begin
        TSSI_ENABLE_COS_CTRL_1 <= 1'b0;
      end
      else begin
        TSSI_ENABLE_COS_CTRL_1 <= TSSI_ENABLE_COS_CTRL;
      end
    end



  assign tmp_26 = TSSI_ENABLE_COS_CTRL_1;



  assign multiplier_in1_3 = (tmp_26 == 1'b1 ? tmp_25 :
              29'sb00000000000000000000000000000);
  assign multiplier_cast_3 = {multiplier_in1_3[28], multiplier_in1_3};
  assign tmp_27 = multiplier_cast_3[28:0];



  assign tmp_28 = {tmp_27[28], tmp_27};



  always @(posedge clk or negedge reset_n)
    begin : delayMatch_5_process
      if (reset_n == 1'b0) begin
        varargin_1_7 <= 1'b0;
      end
      else begin
        varargin_1_7 <= varargin_1_5;
      end
    end



  assign tmp_29 = (tmp_5 == 1'b0 ? varargin_1_4 :
              varargin_1_7);



  assign tmp_30 = tmp_29;



  assign multiplier_in1_4 = (tmp_30 == 1'b1 ? tmp_28 :
              30'sb000000000000000000000000000000);
  assign multiplier_cast_4 = {multiplier_in1_4[29], multiplier_in1_4};
  assign tmp_31 = multiplier_cast_4[29:0];



  assign tmp_32 = {tmp_31[29], tmp_31};



  always @(posedge clk or negedge reset_n)
    begin : IREF_P2R_25u_ODAC_reg_process
      if (reset_n == 1'b0) begin
        IREF_P2R_25u_ODAC_1 <= 2'b00;
      end
      else begin
        IREF_P2R_25u_ODAC_1 <= IREF_P2R_25u_ODAC;
      end
    end



  assign bBiasOC = IREF_P2R_25u_ODAC_1 == 2'b11;



  assign tmp_33 = bBiasOC;



  assign multiplier_in1_5 = (tmp_33 == 1'b1 ? tmp_32 :
              31'sb0000000000000000000000000000000);
  assign multiplier_cast_5 = {multiplier_in1_5[30], multiplier_in1_5};
  assign tmp_34 = multiplier_cast_5[30:0];



  assign tmp_35 = {tmp_34[30], tmp_34};



  assign tmp_36 = ((tmp_35[31] == 1'b0) && (tmp_35[30:23] != 8'b00000000) ? 24'sb011111111111111111111111 :
              ((tmp_35[31] == 1'b1) && (tmp_35[30:23] != 8'b11111111) ? 24'sb100000000000000000000000 :
              $signed(tmp_35[23:0])));



  assign tmp_37 = {{2{tmp_36[23]}}, tmp_36};



  assign adder_add_cast_2 = {tmp_24[25], tmp_24};
  assign adder_add_cast_3 = {tmp_37[25], tmp_37};
  assign adder_add_temp_1 = adder_add_cast_2 + adder_add_cast_3;
  assign tmp_38 = ((adder_add_temp_1[26] == 1'b0) && (adder_add_temp_1[25] != 1'b0) ? 26'sb01111111111111111111111111 :
              ((adder_add_temp_1[26] == 1'b1) && (adder_add_temp_1[25] != 1'b1) ? 26'sb10000000000000000000000000 :
              $signed(adder_add_temp_1[25:0])));



  always @(posedge clk or negedge reset_n)
    begin : delayMatch_6_process
      if (reset_n == 1'b0) begin
        tmp_39 <= 26'sb00000000000000000000000000;
      end
      else begin
        tmp_39 <= tmp_38;
      end
    end



  always @(posedge clk or negedge reset_n)
    begin : TSSI_GAIN_CTRL_reg_process
      if (reset_n == 1'b0) begin
        TSSI_GAIN_CTRL_1 <= 4'b0000;
      end
      else begin
        TSSI_GAIN_CTRL_1 <= TSSI_GAIN_CTRL;
      end
    end



  assign tmp_40 = {1'b0, TSSI_GAIN_CTRL_1};



  assign tmp_41 = tmp_40 + 5'b00001;



  assign tmp_42 = {27'b0, tmp_41};



  assign tmp_43 = tmp_42 - 32'sd1;



  // range: -1..+1mA
  // 
  // S2D Voltage Output (inverted)
  // 
  // (linear) gain range: 0..32
  assign tmp_lut_tmp[0] = 24'b000000101000011110100010;
  assign tmp_lut_tmp[1] = 24'b000000110010111101010011;
  assign tmp_lut_tmp[2] = 24'b000001000000001001101110;
  assign tmp_lut_tmp[3] = 24'b000001010000110000110011;
  assign tmp_lut_tmp[4] = 24'b000001100101101011001001;
  assign tmp_lut_tmp[5] = 24'b000010000000000000000000;
  assign tmp_lut_tmp[6] = 24'b000010100001001001000111;
  assign tmp_lut_tmp[7] = 24'b000011001010110111011100;
  assign tmp_lut_tmp[8] = 24'b000011111111011001001100;
  assign tmp_lut_tmp[9] = 24'b000101000001100001011000;
  assign tmp_lut_tmp[10] = 24'b000110010100110001011000;
  assign tmp_lut_tmp[11] = 24'b000111111101100100111100;
  assign tmp_lut_tmp[12] = 24'b001010000001100001010001;
  assign tmp_lut_tmp[13] = 24'b001100100111101000000010;
  assign tmp_lut_tmp[14] = 24'b001111111000101111011000;
  assign tmp_lut_tmp[15] = 24'b010100000000000000000000;
  assign tmp_44 = tmp_lut_tmp[tmp_43];



  always @(posedge clk)
    begin : tmp_lut_reg_process
      tmp_45 <= tmp_44;
    end



  assign multiplier_cast_6 = {1'b0, tmp_45};
  assign multiplier_mul_temp = tmp_39 * multiplier_cast_6;
  assign tmp_46 = multiplier_mul_temp[49:0];



  assign tmp_47 = tmp_46 * 24'sb000000001010000000000000;



  assign tmp_48 = {tmp_47, 1'b0};



  assign c_21 = tmp_48 >>> 8'd1;



  always @(posedge clk or negedge reset_n)
    begin : TSSI_ENABLE_S2D_reg_process
      if (reset_n == 1'b0) begin
        TSSI_ENABLE_S2D_1 <= 1'b0;
      end
      else begin
        TSSI_ENABLE_S2D_1 <= TSSI_ENABLE_S2D;
      end
    end



  assign tmp_49 = TSSI_ENABLE_S2D_1;



  always @(posedge clk or negedge reset_n)
    begin : delayMatch_7_process
      if (reset_n == 1'b0) begin
        tmp_50 <= 1'b0;
      end
      else begin
        tmp_50 <= tmp_49;
      end
    end



  assign multiplier_in1_6 = (tmp_50 == 1'b1 ? c_21 :
              75'sh0000000000000000000);
  assign multiplier_cast_7 = {multiplier_in1_6[74], multiplier_in1_6};
  assign tmp_51 = multiplier_cast_7[74:0];



  assign tmp_52 = {tmp_51[74], tmp_51};



  always @(posedge clk or negedge reset_n)
    begin : VDDRF2V5LDO_reg_process
      if (reset_n == 1'b0) begin
        VDDRF2V5LDO_1 <= 1'b0;
      end
      else begin
        VDDRF2V5LDO_1 <= VDDRF2V5LDO;
      end
    end



  assign tmp_53 = VDDA1V2_1 & VDDRF2V5LDO_1;



  assign tmp_54 = tmp_53 & VDDD3V3FECTL_1;



  always @(posedge clk or negedge reset_n)
    begin : VSSA_LDO2V5_reg_process
      if (reset_n == 1'b0) begin
        VSSA_LDO2V5_1 <= 1'b0;
      end
      else begin
        VSSA_LDO2V5_1 <= VSSA_LDO2V5;
      end
    end



  assign tmp_55 =  ~ VSSA_LDO2V5_1;



  assign tmp_56 = tmp_54 & tmp_55;



  // HDL code generation from MATLAB function: TSSI_core_falseregionp97
  assign varargin_1_8 = 1'b0;



  always @(posedge clk or negedge reset_n)
    begin : delayMatch_8_process
      if (reset_n == 1'b0) begin
        varargin_1_9 <= 1'b0;
      end
      else begin
        varargin_1_9 <= varargin_1_8;
      end
    end



  // HDL code generation from MATLAB function: TSSI_core_trueregionp97
  assign varargin_1_10 = 1'b1;



  always @(posedge clk or negedge reset_n)
    begin : delayMatch_9_process
      if (reset_n == 1'b0) begin
        varargin_1_11 <= 1'b0;
      end
      else begin
        varargin_1_11 <= varargin_1_10;
      end
    end



  assign tmp_57 = (tmp_56 == 1'b0 ? varargin_1_9 :
              varargin_1_11);



  assign tmp_58 = tmp_57;



  always @(posedge clk or negedge reset_n)
    begin : delayMatch_10_process
      if (reset_n == 1'b0) begin
        tmp_59 <= 1'b0;
      end
      else begin
        tmp_59 <= tmp_58;
      end
    end



  assign multiplier_in1_7 = (tmp_59 == 1'b1 ? tmp_52 :
              76'sh0000000000000000000);
  assign multiplier_cast_8 = {multiplier_in1_7[75], multiplier_in1_7};
  assign tmp_60 = multiplier_cast_8[75:0];



  assign tmp_61 = {tmp_60[75], tmp_60};



  assign tmp_62 = IB_PIO_CONST_25u_1[0] != 1'b0;



  always @(posedge clk or negedge reset_n)
    begin : IREF_P2R_25u_S2D_reg_process
      if (reset_n == 1'b0) begin
        IREF_P2R_25u_S2D_1 <= 1'b0;
      end
      else begin
        IREF_P2R_25u_S2D_1 <= IREF_P2R_25u_S2D;
      end
    end



  assign tmp_63 = tmp_62 & IREF_P2R_25u_S2D_1;



  // HDL code generation from MATLAB function: TSSI_core_falseregionp91
  assign varargin_1_12 = 1'b0;



  always @(posedge clk or negedge reset_n)
    begin : delayMatch_11_process
      if (reset_n == 1'b0) begin
        varargin_1_13 <= 1'b0;
      end
      else begin
        varargin_1_13 <= varargin_1_12;
      end
    end



  // HDL code generation from MATLAB function: TSSI_core_trueregionp91
  assign varargin_1_14 = 1'b1;



  always @(posedge clk or negedge reset_n)
    begin : delayMatch_12_process
      if (reset_n == 1'b0) begin
        varargin_1_15 <= 1'b0;
      end
      else begin
        varargin_1_15 <= varargin_1_14;
      end
    end



  assign tmp_64 = (tmp_63 == 1'b0 ? varargin_1_13 :
              varargin_1_15);



  assign tmp_65 = tmp_64;



  always @(posedge clk or negedge reset_n)
    begin : delayMatch_13_process
      if (reset_n == 1'b0) begin
        tmp_66 <= 1'b0;
      end
      else begin
        tmp_66 <= tmp_65;
      end
    end



  assign multiplier_in1_8 = (tmp_66 == 1'b1 ? tmp_61 :
              77'sh00000000000000000000);
  assign multiplier_cast_9 = {multiplier_in1_8[76], multiplier_in1_8};
  assign tmp_67 = multiplier_cast_9[76:0];



  assign tmp_68 = {tmp_67[76], tmp_67};



  assign tmp_69 = (((tmp_68[77] == 1'b0) && (tmp_68[76:58] != 19'b0000000000000000000)) || ((tmp_68[77] == 1'b0) && (tmp_68[58:35] == 24'sb011111111111111111111111)) ? 24'sb011111111111111111111111 :
              ((tmp_68[77] == 1'b1) && (tmp_68[76:58] != 19'b1111111111111111111) ? 24'sb100000000000000000000000 :
              tmp_68[58:35] + $signed({1'b0, tmp_68[34]})));



  assign tmp_70 = {tmp_69[23], tmp_69};



  assign p84tmp_cast = {tmp_70[24], tmp_70};
  assign p84tmp_cast_1 =  - (p84tmp_cast);
  assign tmp_71 = ((p84tmp_cast_1[25] == 1'b0) && (p84tmp_cast_1[24] != 1'b0) ? 25'sb0111111111111111111111111 :
              ((p84tmp_cast_1[25] == 1'b1) && (p84tmp_cast_1[24] != 1'b1) ? 25'sb1000000000000000000000000 :
              $signed(p84tmp_cast_1[24:0])));



  assign tmp_72 = ((tmp_71[24] == 1'b0) && (tmp_71[23] != 1'b0) ? 24'sb011111111111111111111111 :
              ((tmp_71[24] == 1'b1) && (tmp_71[23] != 1'b1) ? 24'sb100000000000000000000000 :
              $signed(tmp_71[23:0])));



  always @(posedge clk or negedge reset_n)
    begin : TSSI_S2D_OUTP_reg_process
      if (reset_n == 1'b0) begin
        TSSI_S2D_OUTP_1 <= 24'sb000000000000000000000000;
      end
      else begin
        TSSI_S2D_OUTP_1 <= tmp_72;
      end
    end



  always @(posedge clk or negedge reset_n)
    begin : TSSI_S2D_OUTN_reg_process
      if (reset_n == 1'b0) begin
        TSSI_S2D_OUTN_1 <= 24'sb000000000000000000000000;
      end
      else begin
        TSSI_S2D_OUTN_1 <= tmp_69;
      end
    end



  assign TSSI_S2D_OUTP = TSSI_S2D_OUTP_1;

  assign TSSI_S2D_OUTN = TSSI_S2D_OUTN_1;

endmodule  // TSSI_core

