//Verilog HDL for "wk_sha", "dts_ana" "functional"
`timescale 1ns / 1ps 

module dts_ana_core ( comp_out_1v1, en_dts_1v1, tst_out_1v1, VDDA3V3, VDDD1V2, VSSA3V3, VSSD1V2,
bg_swap_1v1, cmp_boost_1v1, cmp_swap_1v1, disc_ref_1v1, disc_ref_d_1v1, disc_temp_1v1,
disc_temp_d_1v1, en_1v1, en_3v3, en_vcal_1v1, i_swap_d_1v1, off_ref_1v1, off_ref_d_1v1, off_temp_1v1,
off_temp_d_1v1, temp_refc_1v1, tst_sel_1v1, vcal_val_1v1 );

  input  [4:0] vcal_val_1v1;
  input off_ref_d_1v1;
  input bg_swap_1v1;
  output tst_out_1v1;
  output en_dts_1v1;
  input i_swap_d_1v1;
  input off_temp_d_1v1;
  input cmp_boost_1v1;
  input VSSA3V3;
  input VDDD1V2;
  input VDDA3V3;
  input off_temp_1v1;
  output comp_out_1v1;
  input temp_refc_1v1;
  input off_ref_1v1;
  input disc_temp_d_1v1;
  input disc_temp_1v1;
  input disc_ref_d_1v1;
  input disc_ref_1v1;
  input cmp_swap_1v1;
  input VSSD1V2;
  input  [3:0] tst_sel_1v1;
  input en_1v1;
  input en_3v3;
  input en_vcal_1v1;
  

  wire pwd_1v1;


  
  real temp;
  real vr,vt,vbg,vcal_ref,k,vdd;
  real cr,ct,ts,isc,ir,it;
  // ofs-values
  real ofs_bg,ofs_ref,ofs_cmp,del_cmp,mm_im;
  // swap vars
  real bg_ofs,ref_ofs,cmp_ofs,cmp_del,im_mm;
  
  reg tick,en_ramp,ramp,comp_out_1v1;
  reg tst_out_1v1;
  
  initial begin
   en_ramp=1;
   ramp=0;
   if(en_ramp==1) temp=0; else temp=70.0;
   vdd=3.3;
   ts=0.5*12.5;
   tick=0;
   k=6e-3;
   vcal_ref=2.0*vdd/3.0;
   // current from bg~10u, down scaled to ~2.5u?
   //isc=(0.5+0.25)/9;
   isc=4.0/(12.0+8.0);
   // offsets in V
   ofs_bg=0.0;
   ofs_ref=0.0;
   ofs_cmp=0.0;
   del_cmp=0;
   mm_im=0;
   //
   bg_ofs=ofs_bg;
   ref_ofs=ofs_ref;
   cmp_ofs=ofs_cmp;
   cmp_del=del_cmp;
   im_mm=1+mm_im;
   // 154 caps+ transistor (51.573)
   ct=104e-15*(154+51.6);
   cr=104e-15*(154+51.6);
   // bg-curvator: ~20mV over half range ->20mV/70
   k=20e-3/(70.0*70);
   vbg=1.2-(k*(temp-60)*(temp-60));
   ir=isc*(vbg+ref_ofs)/120e3;
   // 130C -> 1, 70C~ 0.851, 0C~0.6774, -40~0.578
   it=im_mm*isc*(vbg+bg_ofs)/120e3*(temp+273)/(273+130);
  end
  
  //new "en_dts"
  assign en_dts_1v1=en_1v1 && en_3v3;
  assign pwd_1v1=~en_dts_1v1;  

  //vcal
  always @(vcal_val_1v1 or posedge en_vcal_1v1) begin
   isc=0;
   if(vcal_val_1v1[4]===0) isc=isc+16;
   if(vcal_val_1v1[3]===0) isc=isc+8;
   if(vcal_val_1v1[2]===0) isc=isc+4;
   if(vcal_val_1v1[1]===0) isc=isc+2;
   // bit 0 not implemented
   //if(vcal[0]==0) isc=isc+1;
   //isc=(0.5+(isc/64))/9;
   isc=4.0/(12.0+isc*0.5);
   ir=isc*(vbg+ref_ofs)/120e3;
   // 130C -> 1, 70C~ 0.851, 0C~0.6774, -40~0.578
   it=im_mm*isc*(vbg+bg_ofs)/120e3*(temp+273)/(273+130);
  end
       
  //bandgap and current mirror
  always @(bg_swap_1v1) begin
   if(bg_swap_1v1===0) begin
    bg_ofs=ofs_bg;
    ref_ofs=ofs_ref;
    //im_mm=1+mm_im;
   end
   if(bg_swap_1v1===1) begin
    bg_ofs= -ofs_bg;
    ref_ofs= -ofs_ref;
    //im_mm=1-mm_im;
   end
   ir=isc*(vbg+ref_ofs)/120e3;
   // 130C -> 1, 70C~ 0.851, 0C~0.6774, -40~0.578
   it=im_mm*isc*(vbg+bg_ofs)/120e3*(temp+273)/(273+130);
 end 

  //bandgap and current mirror
  always @(i_swap_d_1v1) begin
   if(i_swap_d_1v1===0) begin
    im_mm=1+mm_im;
   end
   if(i_swap_d_1v1===1) begin
    im_mm=1-mm_im;
   end
   ir=isc*(vbg+ref_ofs)/120e3;
   // 130C -> 1, 70C~ 0.851, 0C~0.6774, -40~0.578
   it=im_mm*isc*(vbg+bg_ofs)/120e3*(temp+273)/(273+130);
 end 
 
  // comparator swap
  always @(cmp_swap_1v1) begin
   if(cmp_swap_1v1===0) begin
    cmp_ofs=ofs_cmp;
    cmp_del=del_cmp;
   end
   if(cmp_swap_1v1===1) begin
    cmp_ofs= -ofs_cmp;
    cmp_del=del_cmp;
   end
  end
    
  always @(negedge pwd_1v1 or negedge tick) begin
   if(pwd_1v1===0) begin
    if(off_temp_1v1===0 && vt<vdd) vt=vt+ts*1e-9*it/ct;
    if(off_ref_1v1===0 && vr<vdd) vr=vr+ts*1e-9*ir/cr;
    if(en_vcal_1v1==1) begin
     if(vr<vdd*2/3.0) comp_out_1v1=1;
     else comp_out_1v1=0;
     end
    else begin
     if(vr<vt) comp_out_1v1=1;
     else comp_out_1v1=0;
    end
    #ts tick=1;
   end
   else comp_out_1v1=0;
  end
  
  always @(posedge pwd_1v1 or posedge disc_temp_1v1) begin
   vt=0.0;
  end

  always @(posedge pwd_1v1 or posedge disc_ref_1v1) begin
   vr=0.0;
  end
  
  always @(posedge tick) begin
   if(pwd_1v1===0) begin
    if(off_temp_1v1===0 && vt<vdd) vt=vt+ts*1e-9*it/ct;
    if(off_ref_1v1===0 && vr<vdd) vr=vr+ts*1e-9*ir/cr;
    if(vr<vt) comp_out_1v1=1;
    else comp_out_1v1=0; 
   end
   else comp_out_1v1=0;
   #ts tick=0;
  end
  
  // generating ramp: inc with every second disc
  always @(posedge disc_ref_1v1) begin
   if(pwd_1v1==0 && en_ramp==1) begin
    if(ramp==1) begin
     //10*20=200C -> 5*26=130
     temp=temp+5.0;
     vbg=1.2-(k*(temp-60)*(temp-60));
     ir=isc*(vbg+ref_ofs)/120e3;
     // 130C -> 1, 70C~ 0.851, 0C~0.6774, -40~0.578
     it=im_mm*isc*(vbg+bg_ofs)/120e3*(temp+273)/(273+130);
     ramp=0;
     end
    else ramp=1;
   end
  end
  // tempsensor
  //testmux-> netzliste erzeugen
  always @(tst_sel_1v1) begin
   if(tst_sel_1v1==4'b0000) assign tst_out_1v1=disc_temp_1v1;
   if(tst_sel_1v1==4'b0001) assign tst_out_1v1=off_temp_d_1v1;
   if(tst_sel_1v1==4'b0010) assign tst_out_1v1=off_temp_1v1;
   if(tst_sel_1v1==4'b0011) assign tst_out_1v1=disc_temp_d_1v1;
   
   if(tst_sel_1v1==4'b0100) assign tst_out_1v1=disc_ref_d_1v1;  
   if(tst_sel_1v1==4'b0101) assign tst_out_1v1=disc_ref_1v1;  
   if(tst_sel_1v1==4'b0110) assign tst_out_1v1=off_ref_d_1v1;  
   if(tst_sel_1v1==4'b0111) assign tst_out_1v1=off_ref_1v1;  

   if(tst_sel_1v1==4'b1000) assign tst_out_1v1=~i_swap_d_1v1;  
   if(tst_sel_1v1==4'b1001) assign tst_out_1v1=i_swap_d_1v1;  
   if(tst_sel_1v1==4'b1010) assign tst_out_1v1=temp_refc_1v1;  
   if(tst_sel_1v1==4'b1011) assign tst_out_1v1=cmp_swap_1v1;  

   if(tst_sel_1v1==4'b1100) assign tst_out_1v1=~cmp_swap_1v1;  
   if(tst_sel_1v1==4'b1101) assign tst_out_1v1=en_vcal_1v1;  
   if(tst_sel_1v1==4'b1110) assign tst_out_1v1=~en_vcal_1v1;  
   if(tst_sel_1v1==4'b1111) assign tst_out_1v1=cmp_boost_1v1;  
  end
  
endmodule // dts_ana_core
