// -------------------------------------------------------------
// 
// File Name: C:\repo\perforce\wrx600_vdfv\ipg_fc\wrx654\model\run\supplymon\hdlsrc\supplymon_core.v
// Created: 2018-03-02 09:12:35
// 
// Generated by MATLAB 9.3, MATLAB Coder 3.4 and HDL Coder 3.11
// 
// 
// 
// -- -------------------------------------------------------------
// -- Rate and Clocking Details
// -- -------------------------------------------------------------
// Design base rate: 1
// 
// -------------------------------------------------------------


// -------------------------------------------------------------
// 
// Module: supplymon_core
// Source Path: supplymon_core
// Hierarchy Level: 0
// 
// -------------------------------------------------------------

`timescale 1 ns / 1 ns

module supplymon_core
          (clk,
           reset_n,
           VDDA1V2RXLDO,
           VDDA1V2TXLDO,
           VDDRF1V2BBLDO,
           VDDRF1V2BBFILTLDO,
           VDDRF2V5LDO,
           VDD1V5LDO12in,
           VDD3V3LDO25in,
           VDD3V3FECTL,
           TSSI_cal_sens,
           ctl,
           ib_pc_const_25u_supplymon1,
           ib_pc_const_25u_supplymon2,
           VDD,
           VSS,
           supplymon_oup,
           supplymon_oun);


  input   clk;
  input   reset_n;
  input   VDDA1V2RXLDO;
  input   VDDA1V2TXLDO;
  input   VDDRF1V2BBLDO;
  input   VDDRF1V2BBFILTLDO;
  input   VDDRF2V5LDO;
  input   VDD1V5LDO12in;
  input   VDD3V3LDO25in;
  input   VDD3V3FECTL;
  input   signed [23:0] TSSI_cal_sens;  // sfix24_En21
  input   [11:0] ctl;  // ufix12
  input   ib_pc_const_25u_supplymon1;
  input   ib_pc_const_25u_supplymon2;
  input   VDD;
  input   VSS;
  output  signed [23:0] supplymon_oup;  // sfix24_En21
  output  signed [23:0] supplymon_oun;  // sfix24_En21

  reg [11:0] ctl_1;  // ufix12
  wire tmp;
  wire tmp_1;
  wire bToggle;
  reg  VDD_1;
  reg  VSS_1;
  wire tmp_2;
  wire tmp_3;
  wire out;
  reg  out_1;
  wire out_2;
  reg  ib_pc_const_25u_supplymon1_1;
  wire bEnable;
  reg  out_3;
  wire tmp_4;
  wire tmp_5;
  reg  ib_pc_const_25u_supplymon2_1;
  wire bBias;
  wire tmp_6;
  wire varargin_1;
  reg  varargin_1_1;
  wire varargin_1_2;
  reg  varargin_1_3;
  wire tmp_7;
  wire tmp_8;  // ufix1
  reg signed [23:0] TSSI_cal_sens_1;  // sfix24_En21
  wire signed [23:0] multiplier_in0;  // sfix24_En21
  wire signed [24:0] multiplier_cast;  // sfix25_En21
  wire signed [23:0] tmp_9;  // sfix24_En21
  wire signed [24:0] tmp_10;  // sfix25_En21
  wire signed [23:0] tmp_11;  // sfix24_En21
  wire tmp_12;  // ufix1
  reg  VDD3V3FECTL_1;
  wire signed [23:0] oVcal07;  // sfix24_En21
  reg signed [23:0] oVcal07_1;  // sfix24_En21
  wire signed [23:0] oVcal07_2;  // sfix24_En21
  reg signed [23:0] oVcal07_3;  // sfix24_En21
  wire signed [23:0] tmp_13;  // sfix24_En21
  wire signed [23:0] multiplier_in0_1;  // sfix24_En21
  wire signed [24:0] multiplier_cast_1;  // sfix25_En21
  wire signed [23:0] tmp_14;  // sfix24_En21
  wire signed [24:0] tmp_15;  // sfix25_En21
  wire signed [23:0] tmp_16;  // sfix24_En21
  wire signed [23:0] tmp_17;  // sfix24_En21
  wire signed [23:0] tmp_18;  // sfix24_En21
  reg signed [23:0] tmp_19;  // sfix24_En21
  wire [9:0] tmp_20;  // ufix10
  wire signed [31:0] tmp_21;  // int32
  reg signed [23:0] tmp_22;  // sfix24_En13
  wire signed [25:0] tmp_23;  // sfix26_En13
  wire signed [25:0] tmp_24;  // sfix26_En13
  wire signed [26:0] p155tmp_add_cast;  // sfix27_En13
  wire signed [26:0] p155tmp_add_temp;  // sfix27_En13
  wire tmp_25;
  wire tmp_26;  // ufix1
  wire [9:0] tmp_27;  // ufix10
  wire signed [31:0] tmp_28;  // int32
  reg  VDDA1V2RXLDO_1;
  wire tmp_29;  // ufix1
  wire signed [24:0] tmp_30;  // sfix25_En21
  wire signed [23:0] p161tmp_1;  // sfix24_En21
  wire signed [23:0] tmp_31;  // sfix24_En21
  reg  VDDA1V2TXLDO_1;
  wire tmp_32;  // ufix1
  wire signed [24:0] tmp_33;  // sfix25_En21
  wire signed [23:0] p162tmp_1;  // sfix24_En21
  wire signed [23:0] tmp_34;  // sfix24_En21
  reg  VDDRF1V2BBLDO_1;
  wire tmp_35;  // ufix1
  wire signed [24:0] tmp_36;  // sfix25_En21
  wire signed [23:0] p163tmp_1;  // sfix24_En21
  wire signed [23:0] tmp_37;  // sfix24_En21
  reg  VDDRF1V2BBFILTLDO_1;
  wire tmp_38;  // ufix1
  wire signed [24:0] tmp_39;  // sfix25_En21
  wire signed [23:0] p164tmp_1;  // sfix24_En21
  wire signed [23:0] tmp_40;  // sfix24_En21
  reg  VDDRF2V5LDO_1;
  wire tmp_41;  // ufix1
  wire signed [24:0] tmp_42;  // sfix25_En21
  wire signed [23:0] p165tmp_1;  // sfix24_En21
  wire signed [23:0] tmp_43;  // sfix24_En21
  reg  VDD1V5LDO12in_1;
  wire tmp_44;  // ufix1
  wire signed [24:0] tmp_45;  // sfix25_En21
  wire signed [23:0] p166tmp_1;  // sfix24_En21
  wire signed [23:0] tmp_46;  // sfix24_En21
  reg  VDD3V3LDO25in_1;
  wire tmp_47;  // ufix1
  wire signed [24:0] tmp_48;  // sfix25_En21
  wire signed [23:0] p167tmp_1;  // sfix24_En21
  wire signed [23:0] tmp_49;  // sfix24_En21
  reg signed [23:0] tmp_50;  // sfix24_En21
  wire signed [23:0] multiplier_in0_2;  // sfix24_En21
  wire signed [24:0] multiplier_cast_2;  // sfix25_En21
  wire signed [23:0] tmp_51;  // sfix24_En21
  wire signed [24:0] tmp_52;  // sfix25_En21
  wire signed [48:0] tmp_53;  // sfix49_En34
  wire tmp_54;
  wire signed [74:0] c_28;  // sfix75_En34
  reg signed [74:0] c_29;  // sfix75_En34
  wire signed [74:0] c_30;  // sfix75_En34
  wire signed [74:0] c_31;  // sfix75_En34
  wire signed [61:0] p0c_div_temp;  // sfix62_En34
  wire signed [61:0] p0c_slice_cast;  // sfix62_En47
  wire signed [61:0] p0c_slice_cast_1;  // sfix62_En34
  wire signed [61:0] p0c_cast;  // sfix62_En47
  reg signed [74:0] c_32;  // sfix75_En34
  wire signed [74:0] tmp_55;  // sfix75_En34
  wire signed [74:0] tmp_56;  // sfix75_En34
  wire signed [23:0] tmp_57;  // sfix24_En21
  wire signed [25:0] tmp_58;  // sfix26_En13
  wire signed [25:0] tmp_59;  // sfix26_En13
  wire signed [26:0] p154tmp_add_cast;  // sfix27_En13
  wire signed [26:0] p154tmp_add_temp;  // sfix27_En13
  wire tmp_60;
  wire tmp_61;  // ufix1
  wire signed [23:0] multiplier_in0_3;  // sfix24_En21
  wire signed [24:0] multiplier_cast_3;  // sfix25_En21
  wire signed [23:0] tmp_62;  // sfix24_En21
  wire signed [24:0] tmp_63;  // sfix25_En21
  wire signed [49:0] tmp_64;  // sfix50_En34
  wire tmp_65;
  wire signed [75:0] c_36;  // sfix76_En34
  reg signed [75:0] c_37;  // sfix76_En34
  wire signed [75:0] c_38;  // sfix76_En34
  wire signed [75:0] c_39;  // sfix76_En34
  wire signed [62:0] p0c_div_temp_1;  // sfix63_En34
  wire signed [62:0] p0c_slice_cast_2;  // sfix63_En47
  wire signed [62:0] p0c_slice_cast_3;  // sfix63_En34
  wire signed [62:0] p0c_cast_1;  // sfix63_En47
  reg signed [75:0] c_40;  // sfix76_En34
  wire signed [75:0] tmp_66;  // sfix76_En34
  wire signed [75:0] tmp_67;  // sfix76_En34
  wire signed [23:0] tmp_68;  // sfix24_En21
  wire signed [23:0] tmp_69;  // sfix24_En21
  wire signed [23:0] tmp_70;  // sfix24_En21
  wire signed [23:0] tmp_71;  // sfix24_En21
  reg signed [23:0] supplymon_oup_1;  // sfix24_En21
  wire tmp_72;  // ufix1
  wire signed [23:0] multiplier_in0_4;  // sfix24_En21
  wire signed [24:0] multiplier_cast_4;  // sfix25_En21
  wire signed [23:0] tmp_73;  // sfix24_En21
  wire signed [24:0] tmp_74;  // sfix25_En21
  wire signed [23:0] tmp_75;  // sfix24_En21
  wire tmp_76;  // ufix1
  wire signed [23:0] multiplier_in0_5;  // sfix24_En21
  wire signed [24:0] multiplier_cast_5;  // sfix25_En21
  wire signed [23:0] tmp_77;  // sfix24_En21
  wire signed [24:0] tmp_78;  // sfix25_En21
  wire signed [23:0] tmp_79;  // sfix24_En21
  wire signed [23:0] tmp_80;  // sfix24_En21
  wire signed [23:0] tmp_81;  // sfix24_En21
  reg signed [23:0] tmp_82;  // sfix24_En21
  wire signed [25:0] tmp_83;  // sfix26_En13
  wire signed [25:0] tmp_84;  // sfix26_En13
  wire signed [26:0] p156tmp_add_cast;  // sfix27_En13
  wire signed [26:0] p156tmp_add_temp;  // sfix27_En13
  wire tmp_85;
  wire tmp_86;  // ufix1
  wire signed [23:0] multiplier_in0_6;  // sfix24_En21
  wire signed [24:0] multiplier_cast_6;  // sfix25_En21
  wire signed [23:0] tmp_87;  // sfix24_En21
  wire signed [24:0] tmp_88;  // sfix25_En21
  wire signed [49:0] tmp_89;  // sfix50_En34
  wire tmp_90;
  wire signed [75:0] c_48;  // sfix76_En34
  reg signed [75:0] c_49;  // sfix76_En34
  wire signed [75:0] c_50;  // sfix76_En34
  wire signed [75:0] c_51;  // sfix76_En34
  wire signed [62:0] p0c_div_temp_2;  // sfix63_En34
  wire signed [62:0] p0c_slice_cast_4;  // sfix63_En47
  wire signed [62:0] p0c_slice_cast_5;  // sfix63_En34
  wire signed [62:0] p0c_cast_2;  // sfix63_En47
  reg signed [75:0] c_52;  // sfix76_En34
  wire signed [75:0] tmp_91;  // sfix76_En34
  wire signed [75:0] tmp_92;  // sfix76_En34
  wire signed [23:0] tmp_93;  // sfix24_En21
  wire signed [25:0] tmp_94;  // sfix26_En13
  wire signed [25:0] tmp_95;  // sfix26_En13
  wire signed [26:0] p153tmp_add_cast;  // sfix27_En13
  wire signed [26:0] p153tmp_add_temp;  // sfix27_En13
  wire tmp_96;
  wire tmp_97;  // ufix1
  wire signed [23:0] multiplier_in0_7;  // sfix24_En21
  wire signed [24:0] multiplier_cast_7;  // sfix25_En21
  wire signed [23:0] tmp_98;  // sfix24_En21
  wire signed [24:0] tmp_99;  // sfix25_En21
  wire signed [48:0] tmp_100;  // sfix49_En34
  wire tmp_101;
  wire signed [74:0] c_56;  // sfix75_En34
  reg signed [74:0] c_57;  // sfix75_En34
  wire signed [74:0] c_58;  // sfix75_En34
  wire signed [74:0] c_59;  // sfix75_En34
  wire signed [61:0] p0c_div_temp_3;  // sfix62_En34
  wire signed [61:0] p0c_slice_cast_6;  // sfix62_En47
  wire signed [61:0] p0c_slice_cast_7;  // sfix62_En34
  wire signed [61:0] p0c_cast_3;  // sfix62_En47
  reg signed [74:0] c_60;  // sfix75_En34
  wire signed [74:0] tmp_102;  // sfix75_En34
  wire signed [74:0] tmp_103;  // sfix75_En34
  wire signed [23:0] tmp_104;  // sfix24_En21
  wire signed [23:0] tmp_105;  // sfix24_En21
  wire signed [23:0] tmp_106;  // sfix24_En21
  wire signed [23:0] tmp_107;  // sfix24_En21
  reg signed [23:0] supplymon_oun_1;  // sfix24_En21
  reg signed [23:0] p159_tmp;  // sfix24_En13
  reg signed [23:0] p157_tmp;  // sfix24_En21


  always @(posedge clk or negedge reset_n)
    begin : ctl_reg_process
      if (reset_n == 1'b0) begin
        ctl_1 <= 12'b000000000000;
      end
      else begin
        ctl_1 <= ctl;
      end
    end



  // oR40 = fi(40, 1, 24, 13, oFm);   % range: -1024..+1024 kOhm
  // 
  // oR30 = fi(30, 1, 24, 13, oFm);   % range: -1024..+1024 kOhm
  // 
  // range: -1024..+1024 kOhm
  // 
  // range: -1024..+1024 kOhm
  // 
  //               VDDA1V2RXLDO          VDDA1V2TXLDO        VDDRF1V2BBLDO       VDDRF1V2BBFILTLDO   VDDRF2V5LDO   
  //      VDD1V5LDO12in       VDD3V3LDO25i
  // 
  // oRxVec =  fi([  56                    56                  56                  56                  180         
  //        80                  260 ], 1, 24, 13, oFm)
  // 
  // oVddVec = fi([  1.26                  1.26                1.26                1.26                2.5         
  //        1.5                 3.3 ], 1, 24, 21, oFm)
  assign tmp = ctl_1[9] != 1'b0;



  assign tmp_1 =  ~ tmp;



  // calculate output
  assign bToggle = ctl_1[1] != 1'b0;



  always @(posedge clk or negedge reset_n)
    begin : VDD_reg_process
      if (reset_n == 1'b0) begin
        VDD_1 <= 1'b0;
      end
      else begin
        VDD_1 <= VDD;
      end
    end



  always @(posedge clk or negedge reset_n)
    begin : VSS_reg_process
      if (reset_n == 1'b0) begin
        VSS_1 <= 1'b0;
      end
      else begin
        VSS_1 <= VSS;
      end
    end



  assign tmp_2 =  ~ VSS_1;



  assign tmp_3 = VDD_1 & tmp_2;



  // HDL code generation from MATLAB function: supplymon_core_falseregionp149
  assign out = 1'b0;



  always @(posedge clk or negedge reset_n)
    begin : delayMatch_process
      if (reset_n == 1'b0) begin
        out_1 <= 1'b0;
      end
      else begin
        out_1 <= out;
      end
    end



  // HDL code generation from MATLAB function: supplymon_core_trueregionp149
  assign out_2 = 1'b1;



  always @(posedge clk or negedge reset_n)
    begin : ib_pc_const_25u_supplymon1_reg_process
      if (reset_n == 1'b0) begin
        ib_pc_const_25u_supplymon1_1 <= 1'b0;
      end
      else begin
        ib_pc_const_25u_supplymon1_1 <= ib_pc_const_25u_supplymon1;
      end
    end



  // VDDA1V2RXLDO
  // 
  // if no calibration
  // 
  // if calibration
  // 
  // %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  // 
  //                                                                          %
  // 
  //           Generated by MATLAB 9.3 and Fixed-Point Designer 6.0           %
  // 
  //                                                                          %
  // 
  // %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  // 
  // supplymon - Supply Monitor Behavioral Fix-Point Model for Matlab-to-Verilog Conversion
  // 
  // --- Authors -------------------------------------------------------------
  // 
  // Steffen Trautmann
  // 
  // -------------------------------------------------------------------------
  // 
  // --- Copyright -----------------------------------------------------------
  // 
  // Intel Austria GmbH, Connected Home Division, Villach
  // 
  // -------------------------------------------------------------------------
  // 
  // underlying fixed-point math rules
  // 
  // block enabled and active, all supplies connected?
  assign bEnable = ctl_1[0] != 1'b0;



  always @(posedge clk or negedge reset_n)
    begin : delayMatch_1_process
      if (reset_n == 1'b0) begin
        out_3 <= 1'b0;
      end
      else begin
        out_3 <= out_2;
      end
    end



  assign tmp_4 = (tmp_3 == 1'b0 ? out_1 :
              out_3);



  assign tmp_5 = bEnable & tmp_4;



  always @(posedge clk or negedge reset_n)
    begin : ib_pc_const_25u_supplymon2_reg_process
      if (reset_n == 1'b0) begin
        ib_pc_const_25u_supplymon2_1 <= 1'b0;
      end
      else begin
        ib_pc_const_25u_supplymon2_1 <= ib_pc_const_25u_supplymon2;
      end
    end



  assign bBias = ib_pc_const_25u_supplymon1_1 & ib_pc_const_25u_supplymon2_1;



  assign tmp_6 = tmp_5 & bBias;



  // HDL code generation from MATLAB function: supplymon_core_falseregionp146
  assign varargin_1 = 1'b0;



  always @(posedge clk or negedge reset_n)
    begin : delayMatch_2_process
      if (reset_n == 1'b0) begin
        varargin_1_1 <= 1'b0;
      end
      else begin
        varargin_1_1 <= varargin_1;
      end
    end



  // HDL code generation from MATLAB function: supplymon_core_trueregionp146
  assign varargin_1_2 = 1'b1;



  always @(posedge clk or negedge reset_n)
    begin : delayMatch_3_process
      if (reset_n == 1'b0) begin
        varargin_1_3 <= 1'b0;
      end
      else begin
        varargin_1_3 <= varargin_1_2;
      end
    end



  assign tmp_7 = (tmp_6 == 1'b0 ? varargin_1_1 :
              varargin_1_3);



  assign tmp_8 = tmp_7;



  always @(posedge clk or negedge reset_n)
    begin : TSSI_cal_sens_reg_process
      if (reset_n == 1'b0) begin
        TSSI_cal_sens_1 <= 24'sb000000000000000000000000;
      end
      else begin
        TSSI_cal_sens_1 <= TSSI_cal_sens;
      end
    end



  assign multiplier_in0 = (tmp_8 == 1'b1 ? TSSI_cal_sens_1 :
              24'sb000000000000000000000000);
  assign multiplier_cast = {multiplier_in0[23], multiplier_in0};
  assign tmp_9 = multiplier_cast[23:0];



  assign tmp_10 = {tmp_9[23], tmp_9};



  assign tmp_11 = ((tmp_10[24] == 1'b0) && (tmp_10[23] != 1'b0) ? 24'sb011111111111111111111111 :
              ((tmp_10[24] == 1'b1) && (tmp_10[23] != 1'b1) ? 24'sb100000000000000000000000 :
              $signed(tmp_10[23:0])));



  assign tmp_12 = tmp_7;



  always @(posedge clk or negedge reset_n)
    begin : VDD3V3FECTL_reg_process
      if (reset_n == 1'b0) begin
        VDD3V3FECTL_1 <= 1'b0;
      end
      else begin
        VDD3V3FECTL_1 <= VDD3V3FECTL;
      end
    end



  // HDL code generation from MATLAB function: supplymon_core_falseregionp123
  assign oVcal07 = 24'sb000000000000000000000000;



  always @(posedge clk or negedge reset_n)
    begin : delayMatch_4_process
      if (reset_n == 1'b0) begin
        oVcal07_1 <= 24'sb000000000000000000000000;
      end
      else begin
        oVcal07_1 <= oVcal07;
      end
    end



  // HDL code generation from MATLAB function: supplymon_core_trueregionp123
  assign oVcal07_2 = 24'sb000101100110011001100110;



  always @(posedge clk or negedge reset_n)
    begin : delayMatch_5_process
      if (reset_n == 1'b0) begin
        oVcal07_3 <= 24'sb000000000000000000000000;
      end
      else begin
        oVcal07_3 <= oVcal07_2;
      end
    end



  // reference voltage at Vdd3v3FECTL for gain calibration
  assign tmp_13 = (VDD3V3FECTL_1 == 1'b0 ? oVcal07_1 :
              oVcal07_3);



  assign multiplier_in0_1 = (tmp_12 == 1'b1 ? tmp_13 :
              24'sb000000000000000000000000);
  assign multiplier_cast_1 = {multiplier_in0_1[23], multiplier_in0_1};
  assign tmp_14 = multiplier_cast_1[23:0];



  assign tmp_15 = {tmp_14[23], tmp_14};



  assign tmp_16 = ((tmp_15[24] == 1'b0) && (tmp_15[23] != 1'b0) ? 24'sb011111111111111111111111 :
              ((tmp_15[24] == 1'b1) && (tmp_15[23] != 1'b1) ? 24'sb100000000000000000000000 :
              $signed(tmp_15[23:0])));



  assign tmp_17 = (bToggle == 1'b0 ? tmp_11 :
              tmp_16);



  assign tmp_18 = 24'sb000000000000000000000000;



  always @(posedge clk or negedge reset_n)
    begin : delayMatch_6_process
      if (reset_n == 1'b0) begin
        tmp_19 <= 24'sb000000000000000000000000;
      end
      else begin
        tmp_19 <= tmp_18;
      end
    end



  assign tmp_20 = ctl_1[11:2];



  assign tmp_21 = {22'b0, tmp_20};



  always @(tmp_21) begin
    case ( tmp_21)
      32'sd1 :
        begin
          p159_tmp = 24'sb000001101100000000000000;
        end
      32'sd2 :
        begin
          p159_tmp = 24'sb000001101110000000000000;
        end
      32'sd4 :
        begin
          p159_tmp = 24'sb000001110000000000000000;
        end
      32'sd8 :
        begin
          p159_tmp = 24'sb000001110010000000000000;
        end
      32'sd16 :
        begin
          p159_tmp = 24'sb000101101110000000000000;
        end
      32'sd288 :
        begin
          p159_tmp = 24'sb000010011010000000000000;
        end
      32'sd576 :
        begin
          p159_tmp = 24'sb000111111110000000000000;
        end
      default :
        begin
          p159_tmp = 24'sb000001110000000000000000;
        end
    endcase
    tmp_22 = p159_tmp;
  end



  assign tmp_23 = {{2{tmp_22[23]}}, tmp_22};



  assign p155tmp_add_cast = {tmp_23[25], tmp_23};
  assign p155tmp_add_temp = 27'sb000000010010010000000000000 + p155tmp_add_cast;
  assign tmp_24 = ((p155tmp_add_temp[26] == 1'b0) && (p155tmp_add_temp[25] != 1'b0) ? 26'sb01111111111111111111111111 :
              ((p155tmp_add_temp[26] == 1'b1) && (p155tmp_add_temp[25] != 1'b1) ? 26'sb10000000000000000000000000 :
              $signed(p155tmp_add_temp[25:0])));



  // HDL code generation from MATLAB function: supplymon_core_trueregionp115_falseregionp1
  assign tmp_25 = tmp_24 == 26'sb00000000000000000000000000;



  assign tmp_26 = tmp_7;



  assign tmp_27 = ctl_1[11:2];



  assign tmp_28 = {22'b0, tmp_27};



  always @(posedge clk or negedge reset_n)
    begin : VDDA1V2RXLDO_reg_process
      if (reset_n == 1'b0) begin
        VDDA1V2RXLDO_1 <= 1'b0;
      end
      else begin
        VDDA1V2RXLDO_1 <= VDDA1V2RXLDO;
      end
    end



  // VDDA1V2TXLDO
  assign tmp_29 = VDDA1V2RXLDO_1;



  assign p161tmp_1 = (tmp_29 == 1'b1 ? 24'sb001010001010001111010111 :
              24'sb000000000000000000000000);
  assign tmp_30 = {p161tmp_1[23], p161tmp_1};



  assign tmp_31 = ((tmp_30[24] == 1'b0) && (tmp_30[23] != 1'b0) ? 24'sb011111111111111111111111 :
              ((tmp_30[24] == 1'b1) && (tmp_30[23] != 1'b1) ? 24'sb100000000000000000000000 :
              $signed(tmp_30[23:0])));



  always @(posedge clk or negedge reset_n)
    begin : VDDA1V2TXLDO_reg_process
      if (reset_n == 1'b0) begin
        VDDA1V2TXLDO_1 <= 1'b0;
      end
      else begin
        VDDA1V2TXLDO_1 <= VDDA1V2TXLDO;
      end
    end



  // VDDRF1V2BBLDO
  assign tmp_32 = VDDA1V2TXLDO_1;



  assign p162tmp_1 = (tmp_32 == 1'b1 ? 24'sb001010000101000111101100 :
              24'sb000000000000000000000000);
  assign tmp_33 = {p162tmp_1[23], p162tmp_1};



  assign tmp_34 = ((tmp_33[24] == 1'b0) && (tmp_33[23] != 1'b0) ? 24'sb011111111111111111111111 :
              ((tmp_33[24] == 1'b1) && (tmp_33[23] != 1'b1) ? 24'sb100000000000000000000000 :
              $signed(tmp_33[23:0])));



  always @(posedge clk or negedge reset_n)
    begin : VDDRF1V2BBLDO_reg_process
      if (reset_n == 1'b0) begin
        VDDRF1V2BBLDO_1 <= 1'b0;
      end
      else begin
        VDDRF1V2BBLDO_1 <= VDDRF1V2BBLDO;
      end
    end



  // VDDRF1V2BBFILTLDO
  assign tmp_35 = VDDRF1V2BBLDO_1;



  assign p163tmp_1 = (tmp_35 == 1'b1 ? 24'sb001010000000000000000000 :
              24'sb000000000000000000000000);
  assign tmp_36 = {p163tmp_1[23], p163tmp_1};



  assign tmp_37 = ((tmp_36[24] == 1'b0) && (tmp_36[23] != 1'b0) ? 24'sb011111111111111111111111 :
              ((tmp_36[24] == 1'b1) && (tmp_36[23] != 1'b1) ? 24'sb100000000000000000000000 :
              $signed(tmp_36[23:0])));



  always @(posedge clk or negedge reset_n)
    begin : VDDRF1V2BBFILTLDO_reg_process
      if (reset_n == 1'b0) begin
        VDDRF1V2BBFILTLDO_1 <= 1'b0;
      end
      else begin
        VDDRF1V2BBFILTLDO_1 <= VDDRF1V2BBFILTLDO;
      end
    end



  // VDDRF2V5LDO
  assign tmp_38 = VDDRF1V2BBFILTLDO_1;



  assign p164tmp_1 = (tmp_38 == 1'b1 ? 24'sb001001111010111000010100 :
              24'sb000000000000000000000000);
  assign tmp_39 = {p164tmp_1[23], p164tmp_1};



  assign tmp_40 = ((tmp_39[24] == 1'b0) && (tmp_39[23] != 1'b0) ? 24'sb011111111111111111111111 :
              ((tmp_39[24] == 1'b1) && (tmp_39[23] != 1'b1) ? 24'sb100000000000000000000000 :
              $signed(tmp_39[23:0])));



  always @(posedge clk or negedge reset_n)
    begin : VDDRF2V5LDO_reg_process
      if (reset_n == 1'b0) begin
        VDDRF2V5LDO_1 <= 1'b0;
      end
      else begin
        VDDRF2V5LDO_1 <= VDDRF2V5LDO;
      end
    end



  // VDD1V5LDO12in (extra switch to limit leakage current)
  assign tmp_41 = VDDRF2V5LDO_1;



  assign p165tmp_1 = (tmp_41 == 1'b1 ? 24'sb010011100110011001100110 :
              24'sb000000000000000000000000);
  assign tmp_42 = {p165tmp_1[23], p165tmp_1};



  assign tmp_43 = ((tmp_42[24] == 1'b0) && (tmp_42[23] != 1'b0) ? 24'sb011111111111111111111111 :
              ((tmp_42[24] == 1'b1) && (tmp_42[23] != 1'b1) ? 24'sb100000000000000000000000 :
              $signed(tmp_42[23:0])));



  always @(posedge clk or negedge reset_n)
    begin : VDD1V5LDO12in_reg_process
      if (reset_n == 1'b0) begin
        VDD1V5LDO12in_1 <= 1'b0;
      end
      else begin
        VDD1V5LDO12in_1 <= VDD1V5LDO12in;
      end
    end



  // VDD3V3LDO25in (extra switch to limit leakage current)
  assign tmp_44 = VDD1V5LDO12in_1;



  assign p166tmp_1 = (tmp_44 == 1'b1 ? 24'sb001100001111010111000011 :
              24'sb000000000000000000000000);
  assign tmp_45 = {p166tmp_1[23], p166tmp_1};



  assign tmp_46 = ((tmp_45[24] == 1'b0) && (tmp_45[23] != 1'b0) ? 24'sb011111111111111111111111 :
              ((tmp_45[24] == 1'b1) && (tmp_45[23] != 1'b1) ? 24'sb100000000000000000000000 :
              $signed(tmp_45[23:0])));



  always @(posedge clk or negedge reset_n)
    begin : VDD3V3LDO25in_reg_process
      if (reset_n == 1'b0) begin
        VDD3V3LDO25in_1 <= 1'b0;
      end
      else begin
        VDD3V3LDO25in_1 <= VDD3V3LDO25in;
      end
    end



  assign tmp_47 = VDD3V3LDO25in_1;



  assign p167tmp_1 = (tmp_47 == 1'b1 ? 24'sb011010110011001100110011 :
              24'sb000000000000000000000000);
  assign tmp_48 = {p167tmp_1[23], p167tmp_1};



  assign tmp_49 = ((tmp_48[24] == 1'b0) && (tmp_48[23] != 1'b0) ? 24'sb011111111111111111111111 :
              ((tmp_48[24] == 1'b1) && (tmp_48[23] != 1'b1) ? 24'sb100000000000000000000000 :
              $signed(tmp_48[23:0])));



  always @(tmp_28, tmp_31, tmp_34, tmp_37, tmp_40, tmp_43, tmp_46, tmp_49) begin
    case ( tmp_28)
      32'sd1 :
        begin
          p157_tmp = tmp_31;
        end
      32'sd2 :
        begin
          p157_tmp = tmp_34;
        end
      32'sd4 :
        begin
          p157_tmp = tmp_37;
        end
      32'sd8 :
        begin
          p157_tmp = tmp_40;
        end
      32'sd16 :
        begin
          p157_tmp = tmp_43;
        end
      32'sd288 :
        begin
          p157_tmp = tmp_46;
        end
      32'sd576 :
        begin
          p157_tmp = tmp_49;
        end
      default :
        begin
          p157_tmp = 24'sb000000000000000000000000;
        end
    endcase
    tmp_50 = p157_tmp;
  end



  assign multiplier_in0_2 = (tmp_26 == 1'b1 ? tmp_50 :
              24'sb000000000000000000000000);
  assign multiplier_cast_2 = {multiplier_in0_2[23], multiplier_in0_2};
  assign tmp_51 = multiplier_cast_2[23:0];



  assign tmp_52 = {tmp_51[23], tmp_51};



  assign tmp_53 = tmp_52 * 24'sb000001010100000000000000;



  assign tmp_54 = tmp_53 < 49'sh0000000000000;



  // HDL code generation from MATLAB function: supplymon_core_falseregionp136
  assign c_28 = 75'sh3FFFFFFFFFFFFFFFFFF;



  always @(posedge clk or negedge reset_n)
    begin : delayMatch_7_process
      if (reset_n == 1'b0) begin
        c_29 <= 75'sh0000000000000000000;
      end
      else begin
        c_29 <= c_28;
      end
    end



  // HDL code generation from MATLAB function: supplymon_core_trueregionp136
  assign c_30 = 75'sh4000000000000000000;



  // HDL code generation from MATLAB function: supplymon_core_trueregionp115_falseregionp1_falseregionp5
  assign p0c_slice_cast = {tmp_53, 13'b0000000000000};
  assign p0c_slice_cast_1 = (p0c_slice_cast[61] == tmp_24[25] ? 62'sh1FFFFFFFFFFFFFFF :
              62'sh2000000000000000);
  assign p0c_cast = {tmp_53, 13'b0000000000000};
  assign p0c_div_temp = (tmp_24 == 31'sd0 ? p0c_slice_cast_1 :
              p0c_cast / tmp_24);
  assign c_31 = {{13{p0c_div_temp[61]}}, p0c_div_temp};



  always @(posedge clk or negedge reset_n)
    begin : delayMatch_8_process
      if (reset_n == 1'b0) begin
        c_32 <= 75'sh0000000000000000000;
      end
      else begin
        c_32 <= c_30;
      end
    end



  // HDL code generation from MATLAB function: supplymon_core_trueregionp115_falseregionp1_trueregionp5
  assign tmp_55 = (tmp_54 == 1'b0 ? c_29 :
              c_32);



  assign tmp_56 = (tmp_25 == 1'b0 ? c_31 :
              tmp_55);



  assign tmp_57 = (((tmp_56[74] == 1'b0) && (tmp_56[73:36] != 38'h0000000000)) || ((tmp_56[74] == 1'b0) && (tmp_56[36:13] == 24'sb011111111111111111111111)) ? 24'sb011111111111111111111111 :
              ((tmp_56[74] == 1'b1) && (tmp_56[73:36] != 38'h3FFFFFFFFF) ? 24'sb100000000000000000000000 :
              tmp_56[36:13] + $signed({1'b0, tmp_56[12]})));



  assign tmp_58 = {{2{tmp_22[23]}}, tmp_22};



  assign p154tmp_add_cast = {tmp_58[25], tmp_58};
  assign p154tmp_add_temp = 27'sb000000010010010000000000000 + p154tmp_add_cast;
  assign tmp_59 = ((p154tmp_add_temp[26] == 1'b0) && (p154tmp_add_temp[25] != 1'b0) ? 26'sb01111111111111111111111111 :
              ((p154tmp_add_temp[26] == 1'b1) && (p154tmp_add_temp[25] != 1'b1) ? 26'sb10000000000000000000000000 :
              $signed(p154tmp_add_temp[25:0])));



  // HDL code generation from MATLAB function: supplymon_core_trueregionp115_trueregionp1
  assign tmp_60 = tmp_59 == 26'sb00000000000000000000000000;



  assign tmp_61 = tmp_7;



  assign multiplier_in0_3 = (tmp_61 == 1'b1 ? tmp_50 :
              24'sb000000000000000000000000);
  assign multiplier_cast_3 = {multiplier_in0_3[23], multiplier_in0_3};
  assign tmp_62 = multiplier_cast_3[23:0];



  assign tmp_63 = {tmp_62[23], tmp_62};



  assign tmp_64 = tmp_63 * 25'sb0000010010010000000000000;



  assign tmp_65 = tmp_64 < 50'sh0000000000000;



  // HDL code generation from MATLAB function: supplymon_core_falseregionp131
  assign c_36 = 76'sh7FFFFFFFFFFFFFFFFFF;



  always @(posedge clk or negedge reset_n)
    begin : delayMatch_9_process
      if (reset_n == 1'b0) begin
        c_37 <= 76'sh0000000000000000000;
      end
      else begin
        c_37 <= c_36;
      end
    end



  // HDL code generation from MATLAB function: supplymon_core_trueregionp131
  assign c_38 = 76'sh8000000000000000000;



  // HDL code generation from MATLAB function: supplymon_core_trueregionp115_trueregionp1_falseregionp5
  assign p0c_slice_cast_2 = {tmp_64, 13'b0000000000000};
  assign p0c_slice_cast_3 = (p0c_slice_cast_2[62] == tmp_59[25] ? 63'sh3FFFFFFFFFFFFFFF :
              63'sh4000000000000000);
  assign p0c_cast_1 = {tmp_64, 13'b0000000000000};
  assign p0c_div_temp_1 = (tmp_59 == 31'sd0 ? p0c_slice_cast_3 :
              p0c_cast_1 / tmp_59);
  assign c_39 = {{13{p0c_div_temp_1[62]}}, p0c_div_temp_1};



  always @(posedge clk or negedge reset_n)
    begin : delayMatch_10_process
      if (reset_n == 1'b0) begin
        c_40 <= 76'sh0000000000000000000;
      end
      else begin
        c_40 <= c_38;
      end
    end



  // HDL code generation from MATLAB function: supplymon_core_trueregionp115_trueregionp1_trueregionp5
  assign tmp_66 = (tmp_65 == 1'b0 ? c_37 :
              c_40);



  assign tmp_67 = (tmp_60 == 1'b0 ? c_39 :
              tmp_66);



  assign tmp_68 = (((tmp_67[75] == 1'b0) && (tmp_67[74:36] != 39'h0000000000)) || ((tmp_67[75] == 1'b0) && (tmp_67[36:13] == 24'sb011111111111111111111111)) ? 24'sb011111111111111111111111 :
              ((tmp_67[75] == 1'b1) && (tmp_67[74:36] != 39'h7FFFFFFFFF) ? 24'sb100000000000000000000000 :
              tmp_67[36:13] + $signed({1'b0, tmp_67[12]})));



  // HDL code generation from MATLAB function: supplymon_core_trueregionp115
  assign tmp_69 = (bToggle == 1'b0 ? tmp_57 :
              tmp_68);



  assign tmp_70 = (tmp_1 == 1'b0 ? tmp_19 :
              tmp_69);



  assign tmp_71 = (tmp_1 == 1'b0 ? tmp_17 :
              tmp_70);



  always @(posedge clk or negedge reset_n)
    begin : supplymon_oup_reg_process
      if (reset_n == 1'b0) begin
        supplymon_oup_1 <= 24'sb000000000000000000000000;
      end
      else begin
        supplymon_oup_1 <= tmp_71;
      end
    end



  assign tmp_72 = tmp_7;



  assign multiplier_in0_4 = (tmp_72 == 1'b1 ? tmp_13 :
              24'sb000000000000000000000000);
  assign multiplier_cast_4 = {multiplier_in0_4[23], multiplier_in0_4};
  assign tmp_73 = multiplier_cast_4[23:0];



  assign tmp_74 = {tmp_73[23], tmp_73};



  assign tmp_75 = ((tmp_74[24] == 1'b0) && (tmp_74[23] != 1'b0) ? 24'sb011111111111111111111111 :
              ((tmp_74[24] == 1'b1) && (tmp_74[23] != 1'b1) ? 24'sb100000000000000000000000 :
              $signed(tmp_74[23:0])));



  assign tmp_76 = tmp_7;



  assign multiplier_in0_5 = (tmp_76 == 1'b1 ? TSSI_cal_sens_1 :
              24'sb000000000000000000000000);
  assign multiplier_cast_5 = {multiplier_in0_5[23], multiplier_in0_5};
  assign tmp_77 = multiplier_cast_5[23:0];



  assign tmp_78 = {tmp_77[23], tmp_77};



  assign tmp_79 = ((tmp_78[24] == 1'b0) && (tmp_78[23] != 1'b0) ? 24'sb011111111111111111111111 :
              ((tmp_78[24] == 1'b1) && (tmp_78[23] != 1'b1) ? 24'sb100000000000000000000000 :
              $signed(tmp_78[23:0])));



  assign tmp_80 = (bToggle == 1'b0 ? tmp_75 :
              tmp_79);



  // HDL code generation from MATLAB function: supplymon_core
  assign tmp_81 = 24'sb000000000000000000000000;



  always @(posedge clk or negedge reset_n)
    begin : delayMatch_11_process
      if (reset_n == 1'b0) begin
        tmp_82 <= 24'sb000000000000000000000000;
      end
      else begin
        tmp_82 <= tmp_81;
      end
    end



  assign tmp_83 = {{2{tmp_22[23]}}, tmp_22};



  assign p156tmp_add_cast = {tmp_83[25], tmp_83};
  assign p156tmp_add_temp = 27'sb000000010010010000000000000 + p156tmp_add_cast;
  assign tmp_84 = ((p156tmp_add_temp[26] == 1'b0) && (p156tmp_add_temp[25] != 1'b0) ? 26'sb01111111111111111111111111 :
              ((p156tmp_add_temp[26] == 1'b1) && (p156tmp_add_temp[25] != 1'b1) ? 26'sb10000000000000000000000000 :
              $signed(p156tmp_add_temp[25:0])));



  // HDL code generation from MATLAB function: supplymon_core_trueregionp117_falseregionp1
  assign tmp_85 = tmp_84 == 26'sb00000000000000000000000000;



  assign tmp_86 = tmp_7;



  assign multiplier_in0_6 = (tmp_86 == 1'b1 ? tmp_50 :
              24'sb000000000000000000000000);
  assign multiplier_cast_6 = {multiplier_in0_6[23], multiplier_in0_6};
  assign tmp_87 = multiplier_cast_6[23:0];



  assign tmp_88 = {tmp_87[23], tmp_87};



  assign tmp_89 = tmp_88 * 25'sb0000010010010000000000000;



  assign tmp_90 = tmp_89 < 50'sh0000000000000;



  // HDL code generation from MATLAB function: supplymon_core_falseregionp141
  assign c_48 = 76'sh7FFFFFFFFFFFFFFFFFF;



  always @(posedge clk or negedge reset_n)
    begin : delayMatch_12_process
      if (reset_n == 1'b0) begin
        c_49 <= 76'sh0000000000000000000;
      end
      else begin
        c_49 <= c_48;
      end
    end



  // HDL code generation from MATLAB function: supplymon_core_trueregionp141
  assign c_50 = 76'sh8000000000000000000;



  // HDL code generation from MATLAB function: supplymon_core_trueregionp117_falseregionp1_falseregionp5
  assign p0c_slice_cast_4 = {tmp_89, 13'b0000000000000};
  assign p0c_slice_cast_5 = (p0c_slice_cast_4[62] == tmp_84[25] ? 63'sh3FFFFFFFFFFFFFFF :
              63'sh4000000000000000);
  assign p0c_cast_2 = {tmp_89, 13'b0000000000000};
  assign p0c_div_temp_2 = (tmp_84 == 31'sd0 ? p0c_slice_cast_5 :
              p0c_cast_2 / tmp_84);
  assign c_51 = {{13{p0c_div_temp_2[62]}}, p0c_div_temp_2};



  always @(posedge clk or negedge reset_n)
    begin : delayMatch_13_process
      if (reset_n == 1'b0) begin
        c_52 <= 76'sh0000000000000000000;
      end
      else begin
        c_52 <= c_50;
      end
    end



  // HDL code generation from MATLAB function: supplymon_core_trueregionp117_falseregionp1_trueregionp5
  assign tmp_91 = (tmp_90 == 1'b0 ? c_49 :
              c_52);



  assign tmp_92 = (tmp_85 == 1'b0 ? c_51 :
              tmp_91);



  assign tmp_93 = (((tmp_92[75] == 1'b0) && (tmp_92[74:36] != 39'h0000000000)) || ((tmp_92[75] == 1'b0) && (tmp_92[36:13] == 24'sb011111111111111111111111)) ? 24'sb011111111111111111111111 :
              ((tmp_92[75] == 1'b1) && (tmp_92[74:36] != 39'h7FFFFFFFFF) ? 24'sb100000000000000000000000 :
              tmp_92[36:13] + $signed({1'b0, tmp_92[12]})));



  assign tmp_94 = {{2{tmp_22[23]}}, tmp_22};



  assign p153tmp_add_cast = {tmp_94[25], tmp_94};
  assign p153tmp_add_temp = 27'sb000000010010010000000000000 + p153tmp_add_cast;
  assign tmp_95 = ((p153tmp_add_temp[26] == 1'b0) && (p153tmp_add_temp[25] != 1'b0) ? 26'sb01111111111111111111111111 :
              ((p153tmp_add_temp[26] == 1'b1) && (p153tmp_add_temp[25] != 1'b1) ? 26'sb10000000000000000000000000 :
              $signed(p153tmp_add_temp[25:0])));



  // HDL code generation from MATLAB function: supplymon_core_trueregionp117_trueregionp1
  assign tmp_96 = tmp_95 == 26'sb00000000000000000000000000;



  assign tmp_97 = tmp_7;



  assign multiplier_in0_7 = (tmp_97 == 1'b1 ? tmp_50 :
              24'sb000000000000000000000000);
  assign multiplier_cast_7 = {multiplier_in0_7[23], multiplier_in0_7};
  assign tmp_98 = multiplier_cast_7[23:0];



  assign tmp_99 = {tmp_98[23], tmp_98};



  assign tmp_100 = tmp_99 * 24'sb000001010100000000000000;



  assign tmp_101 = tmp_100 < 49'sh0000000000000;



  // HDL code generation from MATLAB function: supplymon_core_falseregionp126
  assign c_56 = 75'sh3FFFFFFFFFFFFFFFFFF;



  always @(posedge clk or negedge reset_n)
    begin : delayMatch_14_process
      if (reset_n == 1'b0) begin
        c_57 <= 75'sh0000000000000000000;
      end
      else begin
        c_57 <= c_56;
      end
    end



  // HDL code generation from MATLAB function: supplymon_core_trueregionp126
  assign c_58 = 75'sh4000000000000000000;



  // HDL code generation from MATLAB function: supplymon_core_trueregionp117_trueregionp1_falseregionp5
  assign p0c_slice_cast_6 = {tmp_100, 13'b0000000000000};
  assign p0c_slice_cast_7 = (p0c_slice_cast_6[61] == tmp_95[25] ? 62'sh1FFFFFFFFFFFFFFF :
              62'sh2000000000000000);
  assign p0c_cast_3 = {tmp_100, 13'b0000000000000};
  assign p0c_div_temp_3 = (tmp_95 == 31'sd0 ? p0c_slice_cast_7 :
              p0c_cast_3 / tmp_95);
  assign c_59 = {{13{p0c_div_temp_3[61]}}, p0c_div_temp_3};



  always @(posedge clk or negedge reset_n)
    begin : delayMatch_15_process
      if (reset_n == 1'b0) begin
        c_60 <= 75'sh0000000000000000000;
      end
      else begin
        c_60 <= c_58;
      end
    end



  // HDL code generation from MATLAB function: supplymon_core_trueregionp117_trueregionp1_trueregionp5
  assign tmp_102 = (tmp_101 == 1'b0 ? c_57 :
              c_60);



  assign tmp_103 = (tmp_96 == 1'b0 ? c_59 :
              tmp_102);



  assign tmp_104 = (((tmp_103[74] == 1'b0) && (tmp_103[73:36] != 38'h0000000000)) || ((tmp_103[74] == 1'b0) && (tmp_103[36:13] == 24'sb011111111111111111111111)) ? 24'sb011111111111111111111111 :
              ((tmp_103[74] == 1'b1) && (tmp_103[73:36] != 38'h3FFFFFFFFF) ? 24'sb100000000000000000000000 :
              tmp_103[36:13] + $signed({1'b0, tmp_103[12]})));



  // HDL code generation from MATLAB function: supplymon_core_trueregionp117
  assign tmp_105 = (bToggle == 1'b0 ? tmp_93 :
              tmp_104);



  assign tmp_106 = (tmp_1 == 1'b0 ? tmp_82 :
              tmp_105);



  assign tmp_107 = (tmp_1 == 1'b0 ? tmp_80 :
              tmp_106);



  always @(posedge clk or negedge reset_n)
    begin : supplymon_oun_reg_process
      if (reset_n == 1'b0) begin
        supplymon_oun_1 <= 24'sb000000000000000000000000;
      end
      else begin
        supplymon_oun_1 <= tmp_107;
      end
    end



  assign supplymon_oup = supplymon_oup_1;

  assign supplymon_oun = supplymon_oun_1;

endmodule  // supplymon_core

