% DCOS_CANC_CMP_BLOCK - Testbench to check DC SM Comparator Behavioral Fix-Point Model
    
% --- Authors -------------------------------------------------------------
% Steffen Trautmann
% -------------------------------------------------------------------------
    
% --- Copyright -----------------------------------------------------------
% Intel Austria GmbH, Connected Home Division, Villach
% -------------------------------------------------------------------------
% sOffset = 0.005;
sOffset = 0.000;
sInI = [0.345 0.004 -0.003 -0.567];  

IN_P = fi(sInI(1)/2, 1, 24, 21);
IN_N = fi(-sInI(1)/2, 1, 24, 21);
P_nN = true;
ENABLE = true;
ib_pc_const_12u5 = true;
VDD1V2 = true;
VSS = false;

nCount = 0;
for iS = 1:length(sInI)
    IN_P = fi(sInI(iS)/2, 1, 24, 21);
    IN_N = fi(-sInI(iS)/2, 1, 24, 21);
    for i0 = 1:2
        P_nN(:) = i0-1;
        for i1 = 1:2
            ENABLE(:) = i1-1;
            
            DC_OS_CMP_OUT = DCOS_CANC_CMP_BLOCK(IN_P, IN_N, P_nN, ENABLE, ib_pc_const_12u5, VDD1V2, VSS);
            
            bActive = (ENABLE && ib_pc_const_12u5 && VDD1V2 && ~VSS);
            
            if P_nN
                bCompOut = logical((sInI(iS) >= sOffset) * bActive);
            else
                bCompOut = logical(~(-sInI(iS) >= sOffset) * bActive);
            end
            
            if (bCompOut ~= DC_OS_CMP_OUT)
                error('DC SM Comparator Output not correct - Expected: %d, Actual: %d',...
                    bCompOut, DC_OS_CMP_OUT);
            end
            nCount = nCount+1;
        end
    end
end
        
fprintf('\nAll %d test runs successfully finished!\n', nCount);
