function [rf_outp, rf_outn, rf_ct] = PassiveMixer2G4(bb_inp_i, bb_inn_i, bb_inp_q, bb_inn_q, lo_inp_i, lo_inn_i,...
                                    lo_inp_q, lo_inn_q, ctl_vcm_txmixer, vcm_0v5, VDD1V2, VDD1V2BBLDO, VSS1V2, VSSPSUB, imp_sqrt_gmm, imp_sqrt_gmmi, imp_cos_pmm2, imp_sin_pmm2)
% PassiveMixer2G4 - 2G Passive Mixer Behavioral Fix-Point Model for Matlab-to-Verilog Conversion
    
% --- Authors -------------------------------------------------------------
% Steffen Trautmann
% -------------------------------------------------------------------------
    
% --- Copyright -----------------------------------------------------------
% Intel Austria GmbH, Connected Home Division, Villach
% -------------------------------------------------------------------------
                            
                            
% underlying fixed-point math rules
oFm = fimath('RoundingMethod', 'Nearest', 'OverflowAction', 'Saturate', 'ProductMode', 'FullPrecision', 'SumMode', 'FullPrecision');

% Baseband Inputs
oBbInI = fi(bb_inp_i - bb_inn_i, 1, 24, 21, oFm);
oBbInQ = fi(bb_inp_q - bb_inn_q, 1, 24, 21, oFm);

% LO Inputs active?
% bLoInI = logical(lo_inp_i && ~lo_inn_i || ~lo_inp_i && lo_inn_i);
% bLoInQ = logical(lo_inp_q && ~lo_inn_q || ~lo_inp_q && lo_inn_q);
% one common LO active flag to allow correct complex baseband mixing with both PLL models, full-blown and static EMUL 
bLoIn = logical(lo_inp_i || lo_inn_i || lo_inp_q  ||  lo_inn_q); 

% block enabled and active, all supplies connected?
% bSupply = logical(VDD1V2 && VDD1V2BBLDO && ~VSS1V2 && ~VSSPSUB);
bSupply = logical(VDD1V2 && VDD1V2BBLDO && ~VSS1V2);
bActive = logical(~ctl_vcm_txmixer && vcm_0v5 && bSupply);

% IQMM Impairments
% oLn10d20 = fi(0.115129254649702, 1, 24, 23, oFm);   % K = ln(10)/20 = 0.115129..., range -1..+1
% oX = fi(oLn10d20 * imp_iq_gmm, 1, 24, 22, oFm);     % X = K * Gmm_dB, range -2..+2
% oGmmLin = fi(1 + oX + oX*oX/2, 1, 24, 22, oFm);     % Approx. linear gain: GmmLin = 1 + X + x^2/2 + ..., range -2..+2
% oSqrtGmm = fi(1+(oGmmLin-1)/2, 1, 24, 22, oFm);                                         % sqrt(gmm) equals approx. 1+(gmm-1)/2, range -2..+2
% oSqrtGmmI = fi(1-(oGmmLin-1)/2, 1, 24, 22, oFm);                                        % 1/sqrt(gmm) equals approx. 1-(gmm-1)/2, range -2..+2
% oPmm2Rad = fi(imp_iq_pmm/360*3.1416, 1, 24, 22, oFm);                                   % convert Phase mismatch form Grad to Rad, range -2..+2
% oCosPmm2 = fi((oPmm2Rad*oPmm2Rad/12 - 1) * oPmm2Rad*oPmm2Rad/2 + 1, 1, 24, 22, oFm);    % approx. for cos(x) = (x^2/12-1)*x^2/2+1, range -2..+2
% oSinPmm2 = fi(oPmm2Rad - oPmm2Rad*oPmm2Rad*oPmm2Rad/6, 1, 24, 22, oFm);                 % approx. for sin(x) = x-x^3/6, range -2..+2

% Phase Mismatch (symmetrically applied)
oBbInItmp = coder.hdl.pipeline(fi(imp_cos_pmm2*oBbInI + imp_sin_pmm2*oBbInQ, 1, 24, 21, oFm));  % range -4V..4V  
oBbInQtmp = coder.hdl.pipeline(fi(imp_cos_pmm2*oBbInQ + imp_sin_pmm2*oBbInI, 1, 24, 21, oFm));  % range -4V..4V  

% Gain Mismatch (symmetrically applied)
oBbInI = coder.hdl.pipeline(fi(oBbInItmp * imp_sqrt_gmm, 1, 24, 21, oFm));  % range -4V..4V
oBbInQ = coder.hdl.pipeline(fi(oBbInQtmp * imp_sqrt_gmmi, 1, 24, 21, oFm));  % range -4V..4V

% calculate Mixer gain
oMixerGain = fi(10^((-1 -3)/20), 0, 24, 19, oFm); % -1dB nominal and -3dB from BB to RF

% calculate output
% oOutPRe = fi(bActive * oMixerGain * oBbInI * bLoInI / 2, 1, 24, 21, oFm);
% oOutPIm = fi(bActive * oMixerGain * oBbInQ * bLoInQ / 2, 1, 24, 21, oFm);
oOutPRe = fi(bActive * oMixerGain * oBbInI * bLoIn / 2, 1, 24, 21, oFm);
oOutPIm = fi(bActive * oMixerGain * oBbInQ * bLoIn / 2, 1, 24, 21, oFm);
oOutNRe = fi(-oOutPRe, 1, 24, 21, oFm);
oOutNIm = fi(-oOutPIm, 1, 24, 21, oFm);
oOutCtRe = fi(oOutPRe+oOutNRe, 1, 24, 21, oFm);
oOutCtIm = fi(oOutPIm+oOutNIm, 1, 24, 21, oFm);

% construct 48bit outputs P and N from 24bit Re and Im parts
rf_outp = bitshift(fi(reinterpretcast(oOutPRe,numerictype(0, 24, 0)), 0, 48, 0, oFm),24);
rf_outp = fi(rf_outp + reinterpretcast(oOutPIm,numerictype(0, 24, 0)), 0, 48, 0, oFm);
rf_outn = bitshift(fi(reinterpretcast(oOutNRe,numerictype(0, 24, 0)), 0, 48, 0, oFm),24);
rf_outn = fi(rf_outn + reinterpretcast(oOutNIm,numerictype(0, 24, 0)), 0, 48, 0, oFm);
rf_ct = bitshift(fi(reinterpretcast(oOutCtRe,numerictype(0, 24, 0)), 0, 48, 0, oFm),24);
rf_ct = fi(rf_ct + reinterpretcast(oOutCtIm,numerictype(0, 24, 0)), 0, 48, 0, oFm);

end

