function out_se_rssi = RSSI(rf_inp_rssi, rf_inn_rssi, en_1v2_rssi, stby_1v2_rssi,...
        ib_nio_55uA, ib_nio_const_25uA, VDDA1V2, VDDRF2V5, VSSRF)
% RSSI - RSSI Behavioral Fix-Point Model for Matlab-to-Verilog Conversion
    
% --- Authors -------------------------------------------------------------
% Steffen Trautmann
% -------------------------------------------------------------------------
    
% --- Copyright -----------------------------------------------------------
% Intel Austria GmbH, Connected Home Division, Villach
% -------------------------------------------------------------------------


%% --------------------------------- Pin List ---------------------------------                            
% module RSSI ( out_se_rssi, VDDA1V2, VDDRF2V5, VSSRF, en_1v2_rssi, ib_nio_55uA,
% ib_nio_const_25uA, rf_inn_rssi, rf_inp_rssi, stby_1v2_rssi );
%   input stby_1v2_rssi;
%   input ib_nio_55uA;
%   input VSSRF;
%   input rf_inp_rssi;
%   input ib_nio_const_25uA;
%   input VDDRF2V5;
%   output out_se_rssi;
%   input rf_inn_rssi;
%   input VDDA1V2;
%   input en_1v2_rssi;

% underlying fixed-point math rules
oFm = fimath('RoundingMethod', 'Nearest', 'OverflowAction', 'Saturate', 'ProductMode', 'FullPrecision', 'SumMode', 'FullPrecision');

% extract 2 x 24bit Re and Im parts from 48bit input
% oRfInpRe = bitsliceget(rf_inp_rssi,48,25);
% oRfInpIm = bitsliceget(rf_inp_rssi,24,1);
% oRfInpRe = reinterpretcast(oRfInpRe,numerictype(1, 24, 21));
% oRfInpIm = reinterpretcast(oRfInpIm,numerictype(1, 24, 21));
oRfInpRe = bitsliceget(rf_inp_rssi,47,25);oRfInpReSign = logical(bitsliceget(rf_inp_rssi,48,48));
oRfInpIm = bitsliceget(rf_inp_rssi,23,1);oRfInpImSign = logical(bitsliceget(rf_inp_rssi,24,24));
oOffs = fi(-4, 1, 24, 21, oFm);
oRfInpRe = fi(reinterpretcast(oRfInpRe,numerictype(0, 23, 21)),1, 24, 21, oFm);
oRfInpIm = fi(reinterpretcast(oRfInpIm,numerictype(0, 23, 21)),1, 24, 21, oFm);
if oRfInpReSign 
    oRfInpRe = fi(oRfInpRe + oOffs, 1, 24, 21, oFm);
end
if oRfInpImSign
    oRfInpIm = fi(oRfInpIm + oOffs, 1, 24, 21, oFm);
end

% oRfInnRe = bitsliceget(rf_inn_rssi,48,25);
% oRfInnIm = bitsliceget(rf_inn_rssi,24,1);
% oRfInnRe = reinterpretcast(oRfInnRe,numerictype(1, 24, 21));
% oRfInnIm = reinterpretcast(oRfInnIm,numerictype(1, 24, 21));
oRfInnRe = bitsliceget(rf_inn_rssi,47,25);oRfInnReSign = logical(bitsliceget(rf_inn_rssi,48,48));
oRfInnIm = bitsliceget(rf_inn_rssi,23,1);oRfInnImSign = logical(bitsliceget(rf_inn_rssi,24,24));
oOffs = fi(-4, 1, 24, 21, oFm);
oRfInnRe = fi(reinterpretcast(oRfInnRe,numerictype(0, 23, 21)),1, 24, 21, oFm);
oRfInnIm = fi(reinterpretcast(oRfInnIm,numerictype(0, 23, 21)),1, 24, 21, oFm);
if oRfInnReSign 
    oRfInnRe = fi(oRfInnRe + oOffs, 1, 24, 21, oFm);
end
if oRfInnImSign
    oRfInnIm = fi(oRfInnIm + oOffs, 1, 24, 21, oFm);
end


oRfInRe = fi(oRfInpRe-oRfInnRe, 1, 24, 21, oFm);
oRfInIm = fi(oRfInpIm-oRfInnIm, 1, 24, 21, oFm);

% check supplies
bSupply = logical(VDDA1V2 && VDDRF2V5 && ~VSSRF);

% check biasing
bBias = logical(ib_nio_55uA && ib_nio_const_25uA);

% RSSI in active state and supplied?
bActive = logical(en_1v2_rssi && ~stby_1v2_rssi && bSupply && bBias);

% Reference resistor for V2I conversion (in kOhm!)
oRref = fi(5, 1, 24, 13, oFm);   % range: -1024..+1024 kOhm

% Nominal detector gain
oGain = fi(10^(27.3/20), 0, 24, 19, oFm);     % range: 0..32

% Nominal detector offset (in mA)
oOffset = fi(-0.001, 1, 24, 23, oFm);            % range: -1..+1mA

% Detector Output (for simplicity perfect squarer is assumed)
out_se_rssi = fi(((oRfInRe*oRfInRe+oRfInIm*oRfInIm)*oGain/oRref+oOffset) * bActive, 1, 32, 23, oFm);    % range: -1..+1mA

% Limiter to prevent wrapping  
sLimPos = fi(0.999, 1, 32, 23, oFm);
sLimNeg = fi(-0.999, 1, 32, 23, oFm);
out_se_rssi = fi(min(sLimPos,max(sLimNeg,out_se_rssi)), 1, 24, 23, oFm);    % range from -1..+1mA

% Inherent Filter not (yet) implemented (would require a-priori knowledge
% of simulation rate, and simulation sampling would have to be equidistant)

end

