function [ibp_const_75u, ibn_55u_out, Ib_const_25u_Vb1] = RSSI_bias(ctl_Outbias, ctl_bias_select, pd, pd_b, TC, TC_n,...
    ibp_const_25u, ibn_P2PR_25u, VDDRF2V5, VDDA1V2, VSS)

% RSSI_bias - RSSI Bias Behavioral Fix-Point Model for Matlab-to-Verilog Conversion
    
% --- Authors -------------------------------------------------------------
% Steffen Trautmann
% -------------------------------------------------------------------------
    
% --- Copyright -----------------------------------------------------------
% Intel Austria GmbH, Connected Home Division, Villach
% -------------------------------------------------------------------------
  
% underlying fixed-point math rules
oFm = fimath('RoundingMethod', 'Nearest', 'OverflowAction', 'Saturate', 'ProductMode', 'FullPrecision', 'SumMode', 'FullPrecision');

% block enabled and active, all supplies connected?
bSupply = logical(VDDRF2V5 && VDDA1V2 && ~VSS);
bBias = logical(ibp_const_25u && ibn_P2PR_25u);
bActive = logical(~pd && pd_b && bSupply && bBias);

% calculate output
Ib_const_25u_Vb1 = bActive;
ibn_55u_out = bActive;
% oIcoarseVec = fi([75/1000, 0, -100/1000, -200/1000], 1, 24, 23, oFm); 
% ibp_const_75u = fi(bActive * oIcoarseVec(ctl_Outbias+1), 1, 24, 23, oFm);    % range -1mA..+1mA
% @@@ workaround since ibp_const_75 cannot be a signed 24 output
bCtlOutb0 = logical(bitget(ctl_Outbias,1));
bCtlOutb1 = logical(bitget(ctl_Outbias,2));
ibp_const_75u = logical(bActive && ~(bCtlOutb0 && ~bCtlOutb1)); 
end

