% RSSI_bias_svgen - Script for Matlab-to-Verilog Conversion of RSSI Bias Behavioral Fix-Point Model
    
% --- Authors -------------------------------------------------------------
% Steffen Trautmann
% -------------------------------------------------------------------------
    
% --- Copyright -----------------------------------------------------------
% Intel Austria GmbH, Connected Home Division, Villach
% -------------------------------------------------------------------------

%% ####################### MODEL_SPECIFIC PARAMETERS #########################

%% -------------------------------- Model Name --------------------------------
tModelName = 'RSSI_bias';

%% ------------------------------ Model Arguments -----------------------------
% function [ibp_const_75u, ibn_55u_out, Ib_const_25u_Vb1] = RSSI_bias(ctl_Outbias, ctl_bias_select, pd, pd_b, TC, TC_n,...
%     ibp_const_25u, ibn_P2PR_25u, VDDRF2V5, VDDA1V2, VSS)
cModelArgs = cell(11,1);
cModelArgs{1} = coder.typeof(fi(0,numerictype(0,3,0)));     % [2:0] ctl_Outbias
cModelArgs{2} = coder.typeof(false);                        % ctl_bias_select
cModelArgs{3} = coder.typeof(false);                        % pd
cModelArgs{4} = coder.typeof(false);                        % pd_b (NOT buffered but inverted pd, i.e. == enable!!!)
cModelArgs{5} = coder.typeof(false);                        % TC
cModelArgs{6} = coder.typeof(false);                        % TC_n
cModelArgs{7} = coder.typeof(false);                        % ibp_const_25u
cModelArgs{8} = coder.typeof(false);                        % ibn_P2PR_25u
cModelArgs{9} = coder.typeof(false);                        % VDDRF2V5
cModelArgs{10} = coder.typeof(false);                       % VDDA1V2
cModelArgs{11} = coder.typeof(false);                       % VSS


%% call generic Matlab2SV conversion function
addpath ../matlab2sv
Matlab2SV(tModelName, cModelArgs)
rmpath ../matlab2sv
