% TPC_ana_top_svgen - Script for Matlab-to-Verilog Conversion of TPC (single I or Q) Behavioral Fix-Point Model
    
% --- Authors -------------------------------------------------------------
% Steffen Trautmann
% -------------------------------------------------------------------------
    
% --- Copyright -----------------------------------------------------------
% Intel Austria GmbH, Connected Home Division, Villach
% -------------------------------------------------------------------------
    

%% ####################### MODEL_SPECIFIC PARAMETERS #########################

%% -------------------------------- Model Name --------------------------------
tModelName = 'TPC_ana_top';

%% ------------------------------ Model Arguments -----------------------------

% function [TPC_DIFF_OUTP, TPC_DIFF_OUTN] = TPC_ana_top(TPC_DIFF_INP, TPC_DIFF_INN, CMFB_P, CMFB_N, TPC_GAIN_UN_SEL,...
%     TPC_FB_CSEL, TPC_OA_CTRL, TPC_OSDAC_CTRL, TPC_DAC_ENABLE, TPC_OA_ENABLE, IB_PC_CONST_25U, IB_NC_P2PR_50U,...
%     IB_PC_DAC, VDDA1V26, VSSA, imp_dc_i, imp_dc_q, imp_iq_gmm, imp_iq_pmm)
cModelArgs = cell(16,1);
cModelArgs{1} = coder.typeof(fi(0,numerictype(1,24,21)));   % TPC_DIFF_INP, BB Voltage Input, -4..+4 V range 
cModelArgs{2} = coder.typeof(fi(0,numerictype(1,24,21)));   % TPC_DIFF_INN, BB Voltage Input, -4..+4 V range
cModelArgs{3} = coder.typeof(fi(0,numerictype(1,24,21)));   % CMFB_P, BB Voltage Input, -4..+4 V range (ignored in the model)
cModelArgs{4} = coder.typeof(fi(0,numerictype(1,24,21)));   % CMFB_N, BB Voltage Input, -4..+4 V range (ignored in the model)
cModelArgs{5} = coder.typeof(fi(0,numerictype(0,7,0)));     % [6:0] TPC_GAIN_UN_SEL (Thermometer coded)
cModelArgs{6} = coder.typeof(fi(0,numerictype(0,7,0)));     % [6:0] TPC_FB_CSEL
cModelArgs{7} = coder.typeof(fi(0,numerictype(0,4,0)));     % [3:0] TPC_OA_CTRL
cModelArgs{8} = coder.typeof(fi(0,numerictype(1,4,0)));     % [3:0] TPC_OSDAC_CTRL (symmetric 2's complement)
cModelArgs{9} = coder.typeof(false);                        % TPC_OA_ENABLE
cModelArgs{10} = coder.typeof(false);                       % TPC_DAC_ENABLE
cModelArgs{11} = coder.typeof(fi(0,numerictype(0,2,0)));    % [1:0] IB_PC_CONST_25U
cModelArgs{12} = coder.typeof(false);                       % IB_PC_DAC
cModelArgs{13} = coder.typeof(false);                       % VCM_REF_0V5
cModelArgs{14} = coder.typeof(false);                       % VDDA1V26, 
cModelArgs{15} = coder.typeof(false);                       % VSSA
cModelArgs{16} = coder.typeof(fi(0,numerictype(1,24,21)));  % imp_dc (DC offset voltage)

%% call generic Matlab2SV conversion function
addpath ../matlab2sv
Matlab2SV(tModelName, cModelArgs)
rmpath ../matlab2sv
