% TSSI_svgen - Script for Matlab-to-Verilog Conversion of TSSI Behavioral Fix-Point Model
    
% --- Authors -------------------------------------------------------------
% Steffen Trautmann
% -------------------------------------------------------------------------
    
% --- Copyright -----------------------------------------------------------
% Intel Austria GmbH, Connected Home Division, Villach
% -------------------------------------------------------------------------
    

%% ####################### MODEL_SPECIFIC PARAMETERS #########################

%% -------------------------------- Model Name --------------------------------
tModelName = 'TSSI';

%% ------------------------------ Model Arguments -----------------------------
% function [TSSI_S2D_OUTP,TSSI_S2D_OUTN] = TSSI(TSSI_SENSE_5G, TSSI_SENSE_2G, TSSI_S2D_IN, TSSI_OFFSET_CTRL,...
%         TSSI_GAIN_CTRL, TSSI_VTAP_SELECT, HBLB, TSSI_ENABLE_V2I, TSSI_ENABLE_COS_CTRL, TSSI_ENABLE_S2D,...
%         IREF_P2R_25u_ODAC, IREF_P2R_25u_S2D, IB_PIO_CONST_25u, VDDA1V2, VDDRF2V5LDO, VDDD3V3FECTL, VSS, VSSA_LDO2V5, VSSDFECTL)
cModelArgs = cell(19,1);
cModelArgs{1} = coder.typeof(fi(0,numerictype(1,24,21)));   % TSSI_SENSE_5G, BB Voltage Input, -4..+4 V range 
cModelArgs{2} = coder.typeof(fi(0,numerictype(1,24,21)));   % TSSI_SENSE_2G, BB Voltage Input, -4..+4 V range
cModelArgs{3} = coder.typeof(fi(0,numerictype(1,24,23)));   % TSSI_S2D_IN, BB Current Input, -1..+1 mA range
cModelArgs{4} = coder.typeof(fi(0,numerictype(0,5,0)));     % [4:0] TSSI_OFFSET_CTRL
cModelArgs{5} = coder.typeof(fi(0,numerictype(0,4,0)));     % [3:0] TSSI_GAIN_CTRL
cModelArgs{6} = coder.typeof(false);                        % TSSI_VTAP_SELECT
cModelArgs{7} = coder.typeof(false);                        % HBLB
cModelArgs{8} = coder.typeof(false);                        % TSSI_ENABLE_V2I
cModelArgs{9} = coder.typeof(false);                        % TSSI_ENABLE_COS_CTRL
cModelArgs{10} = coder.typeof(false);                       % TSSI_ENABLE_S2D
cModelArgs{11} = coder.typeof(fi(0,numerictype(0,2,0)));    % [1:0] IREF_P2R_25u_ODAC, 
cModelArgs{12} = coder.typeof(false);                       % IREF_P2R_25u_S2D
cModelArgs{13} = coder.typeof(fi(0,numerictype(0,2,0)));    % [1:0] IB_PIO_CONST_25u
cModelArgs{14} = coder.typeof(false);                       % VDDA1V2
cModelArgs{15} = coder.typeof(false);                       % VDDRF2V5LDO
cModelArgs{16} = coder.typeof(false);                       % VDDD3V3FECTL
cModelArgs{17} = coder.typeof(false);                       % VSS
cModelArgs{18} = coder.typeof(false);                       % VSSA_LDO2V5
cModelArgs{19} = coder.typeof(false);                       % VSSDFECTL

%% call generic Matlab2SV conversion function
addpath ../matlab2sv
Matlab2SV(tModelName, cModelArgs)
rmpath ../matlab2sv
