% TSSI_tb - Testbench to check TSSI Behavioral Fix-Point Model
    
% --- Authors -------------------------------------------------------------
% Steffen Trautmann
% -------------------------------------------------------------------------
    
% --- Copyright -----------------------------------------------------------
% Intel Austria GmbH, Connected Home Division, Villach
% -------------------------------------------------------------------------
    
%% Default Inputs
TSSI_SENSE_5G = fi(0.05, 1, 24, 21);   % BB Voltage Input, -4..+4 V range 
TSSI_SENSE_2G = fi(0.024, 1, 24, 21);   % BB Voltage Input, -4..+4 V range
TSSI_S2D_IN = fi(0.345, 1, 24, 23);   % BB Current Input, -1..+1 mA range
TSSI_OFFSET_CTRL = fi(0, 0, 5, 0);     
TSSI_GAIN_CTRL = fi(0, 0, 4, 0);     
TSSI_VTAP_SELECT = true;
HBLB = true;
TSSI_ENABLE_V2I = true;
TSSI_ENABLE_COS_CTRL = true;
TSSI_ENABLE_S2D = true;
IREF_P2R_25u_ODAC = fi(3, 0, 2, 0);
IREF_P2R_25u_S2D = true;
IB_PIO_CONST_25u = fi(3, 0, 2, 0);
VDDA1V2 = true;
VDDRF2V5LDO = true;
VDDD3V3FECTL = true;
VSS = false;
VSSA_LDO2V5 = false;
VSSDFECTL = false;

%% Nested Loops to verify Output for different Inputs (VDD/VSS/Ibias pins not varied, always active!)
oGain = fi(10.^([-10:2:20]/20), 0, 24, 19); 
oOffset = fi([0:31]*(-5e-3), 1, 24, 23);
oResDiv = fi([0.6 0.9], 1, 24, 21);
oRref = fi(5, 1, 24, 13);

nCount = 0;
for i1 = 1:32
    TSSI_OFFSET_CTRL(:) = i1-1;
    for i2 = 1:11
        TSSI_GAIN_CTRL(:) = i2-1;
        for i3 = 1:2
            TSSI_VTAP_SELECT(:) = i3-1;
            for i4 = 1:2
                HBLB(:) = i4-1;
                for i5 = 1:2
                    TSSI_ENABLE_V2I(:) = i5-1;
                    for i6 = 1:2
                        TSSI_ENABLE_COS_CTRL(:) = i6-1;
                        for i7 = 1:2
                            TSSI_ENABLE_S2D(:) = i7-1;
                            oTssiOutRef = fi(1/2 * (oResDiv(i3) / oRref * (TSSI_SENSE_5G*HBLB + TSSI_SENSE_2G*~HBLB)...
                                *(TSSI_ENABLE_V2I && VDDA1V2 && VDDD3V3FECTL && ~VSSDFECTL && bitget(IB_PIO_CONST_25u,2))...
                                + TSSI_S2D_IN + oOffset(i1)*(TSSI_ENABLE_COS_CTRL && VDDA1V2 && VDDD3V3FECTL && ~VSS && IREF_P2R_25u_ODAC==3))...
                                * oGain(i2) * oRref * (TSSI_ENABLE_S2D && VDDA1V2 && VDDRF2V5LDO && VDDD3V3FECTL && ~VSS && bitget(IB_PIO_CONST_25u,1) && IREF_P2R_25u_S2D), 1, 24, 21);
                            [TSSI_S2D_OUTP,TSSI_S2D_OUTN] = TSSI(TSSI_SENSE_5G, TSSI_SENSE_2G, TSSI_S2D_IN, TSSI_OFFSET_CTRL,...
                                TSSI_GAIN_CTRL, TSSI_VTAP_SELECT, HBLB, TSSI_ENABLE_V2I, TSSI_ENABLE_COS_CTRL, TSSI_ENABLE_S2D,...
                                IREF_P2R_25u_ODAC, IREF_P2R_25u_S2D, IB_PIO_CONST_25u, VDDA1V2, VDDRF2V5LDO, VDDD3V3FECTL, VSS, VSSA_LDO2V5, VSSDFECTL);
                            if abs(TSSI_S2D_OUTN - oTssiOutRef) > 1e-3
                                error('Wrong Output at TSSI_S2D_OUTP: Expected: %6.4f, Actual: %6.4f!', oTssiOutRef, TSSI_S2D_OUTN);
                            end
                            if abs(TSSI_S2D_OUTP + oTssiOutRef) > 1e-3
                                error('Wrong Output at TSSI_S2D_OUTN: Expected: %6.4f, Actual: %6.4f!', -oTssiOutRef, TSSI_S2D_OUTP);
                            end
                            nCount = nCount+1;
                        end
                    end
                end
            end
        end
    end
end

fprintf('\nAll %d test runs successfully finished!\n', nCount);

    
    
    