% anamux_svgen - Script for Matlab-to-Verilog Conversion of AnaMux Behavioral Fix-Point Model
    
% --- Authors -------------------------------------------------------------
% Steffen Trautmann
% -------------------------------------------------------------------------
    
% --- Copyright -----------------------------------------------------------
% Intel Austria GmbH, Connected Home Division, Villach
% -------------------------------------------------------------------------
    

%% ####################### MODEL_SPECIFIC PARAMETERS #########################

%% -------------------------------- Model Name --------------------------------
tModelName = 'anamux';

%% ------------------------------ Model Arguments -----------------------------
% function [amux_outp, amux_outn] = anamux(amux_inp0, amux_inn0, amux_inp1, amux_inn1, amux_inp2_esd, amux_inn2_esd,...
%     en, en_in0, en_in1, en_in2, [1:0] prog_ib, ib_pc_25u, vcm_0v55, VDD, VSS)
cModelArgs = cell(15,1);
cModelArgs{1} = coder.typeof(fi(0,numerictype(1,24,21)));   % amux_inp0, BB Voltage Input, -4..+4 V range 
cModelArgs{2} = coder.typeof(fi(0,numerictype(1,24,21)));   % amux_inn0, BB Voltage Input, -4..+4 V range
cModelArgs{3} = coder.typeof(false);                        % amux_inp1, BB Voltage Input, logical since tied to GND
cModelArgs{4} = coder.typeof(false);                        % amux_inn1, BB Voltage Input, logical since tied to GND
cModelArgs{5} = coder.typeof(fi(0,numerictype(1,24,21)));   % amux_inp2_esd, BB Voltage Input, -4..+4 V range 
cModelArgs{6} = coder.typeof(fi(0,numerictype(1,24,21)));   % amux_inn2_esd, BB Voltage Input, -4..+4 V range
cModelArgs{7} = coder.typeof(false);                        % en
cModelArgs{8} = coder.typeof(false);                        % en_in0
cModelArgs{9} = coder.typeof(false);                        % en_in1
cModelArgs{10} = coder.typeof(false);                       % en_in2
cModelArgs{11} = coder.typeof(fi(0,numerictype(0,2,0)));    % [1:0] prog_ib
cModelArgs{12} = coder.typeof(false);                       % ib_pc_25u
cModelArgs{13} = coder.typeof(false);                       % vcm_0v55
cModelArgs{14} = coder.typeof(false);                       % VDD
cModelArgs{15} = coder.typeof(false);                       % VSS

%% call generic Matlab2SV conversion function
addpath ../matlab2sv
Matlab2SV(tModelName, cModelArgs)
rmpath ../matlab2sv
