function [bb_outp, bb_outn] = bbio_buffer_ff(bbio_inp0, bbio_inn0, bbio_inp1, bbio_inn1, fb_cap,...
    olgain, cmgain, vcm_in, psave, psave_cm, en, en_in0, en_in1, ib_pc_100u, vcm_0v5, VDDA1V2, VSS)
% bbio_buffer_ff - BBIO Buffer Behavioral Fix-Point Model for Matlab-to-Verilog Conversion
    
% --- Authors -------------------------------------------------------------
% Steffen Trautmann
% -------------------------------------------------------------------------
    
% --- Copyright -----------------------------------------------------------
% Intel Austria GmbH, Connected Home Division, Villach
% -------------------------------------------------------------------------
                            
                            
% underlying fixed-point math rules
oFm = fimath('RoundingMethod', 'Nearest', 'OverflowAction', 'Saturate', 'ProductMode', 'FullPrecision', 'SumMode', 'FullPrecision');

% block enabled and active, all supplies connected?
bSupply = logical(VDDA1V2 && ~VSS);
bBias = logical(ib_pc_100u && vcm_0v5);
bActive = logical(en && bSupply && bBias);

% calculate output
bb_outp = fi(bActive * ((bbio_inp0-bbio_inn0)*en_in0 + (bbio_inp1-bbio_inn1)*en_in1)/2, 1, 24, 21, oFm);  % range -4V..4V
bb_outn = fi(-bb_outp, 1, 24, 21, oFm);

end

