% bbio_buffer_ff_svgen - Script for Matlab-to-Verilog Conversion of BBIO Behavioral Fix-Point Model
    
% --- Authors -------------------------------------------------------------
% Steffen Trautmann
% -------------------------------------------------------------------------
    
% --- Copyright -----------------------------------------------------------
% Intel Austria GmbH, Connected Home Division, Villach
% -------------------------------------------------------------------------

%% ####################### MODEL_SPECIFIC PARAMETERS #########################

%% -------------------------------- Model Name --------------------------------
tModelName = 'bbio_buffer_ff';

%% ------------------------------ Model Arguments -----------------------------
% function [bb_outp, bb_outn] = bbio_buffer_ff(bbio_inp0, bbio_inn0, bbio_inp1, bbio_inn1, fb_cap,...
%     olgain, cmgain, vcm_in, psave, psave_cm, en, en_in0, en_in1, ib_pc_100u, vcm_0v5, VDDA1V2, VSS)
cModelArgs = cell(17,1);
cModelArgs{1} = coder.typeof(fi(0,numerictype(1,24,21)));   % bbio_inp0
cModelArgs{2} = coder.typeof(fi(0,numerictype(1,24,21)));   % bbio_inn0
cModelArgs{3} = coder.typeof(fi(0,numerictype(1,24,21)));   % bbio_inp1
cModelArgs{4} = coder.typeof(fi(0,numerictype(1,24,21)));   % bbio_inn1
cModelArgs{5} = coder.typeof(fi(0,numerictype(0,2,0)));     % [1:0] fb_cap
cModelArgs{6} = coder.typeof(fi(0,numerictype(0,3,0)));     % [2:0] olgain
cModelArgs{7} = coder.typeof(fi(0,numerictype(0,2,0)));     % [1:0] cmgain
cModelArgs{8} = coder.typeof(fi(0,numerictype(0,2,0)));     % [1:0] vcm_in
cModelArgs{9} = coder.typeof(fi(0,numerictype(0,3,0)));     % [2:0] psave
cModelArgs{10} = coder.typeof(false);                       % psave_cm
cModelArgs{11} = coder.typeof(false);                       % en
cModelArgs{12} = coder.typeof(false);                       % en_in0
cModelArgs{13} = coder.typeof(false);                       % en_in1
cModelArgs{14} = coder.typeof(false);                       % ib_pc_100u
cModelArgs{15} = coder.typeof(false);                       % vcm_0v5
cModelArgs{16} = coder.typeof(false);                       % VDDA1V2
cModelArgs{17} = coder.typeof(false);                       % VSS


%% call generic Matlab2SV conversion function
addpath ../matlab2sv
Matlab2SV(tModelName, cModelArgs)
rmpath ../matlab2sv
