% rx_bb_pga1 - Testbench to check PGC1 Behavioral Fix-Point Model
    
% --- Authors -------------------------------------------------------------
% Steffen Trautmann
% -------------------------------------------------------------------------
    
% --- Copyright -----------------------------------------------------------
% Intel Austria GmbH, Connected Home Division, Villach
% -------------------------------------------------------------------------

sIn0 = 0.0876;     % 2.345mA I input current
sIn1 = -0.1234;    % -1.987mA Q input current

% initial values
bbio_inp0 = fi(sIn0/2, 1, 24, 21);
bbio_inn0 = fi(-sIn0/2, 1, 24, 21);
bbio_inp1 = fi(sIn1/2, 1, 24, 21);
bbio_inn1 = fi(-sIn1/2, 1, 24, 21);
fb_cap = fi(0, 0, 2, 0);
olgain = fi(0, 0, 3, 0);
cmgain = fi(0, 0, 2, 0);
vcm_in = fi(0, 0, 2, 0);
psave = fi(0, 0, 3, 0);
psave_cm = false;
en = true;
en_in0 = true;
en_in1 = false;
ib_pc_100u = true;
vcm_0v5 = true;
VDDA1V2 = true;
VSS = false;

nCount = 0;
sErrMax = 1e-4;
for i0 = 1:2
    en(:) = i0-1;
    for i1 = 1:2
        en_in0(:) = i1-1;
        for i2 = 1:2
            en_in1(:) = i2-1;
            
            [bb_outp, bb_outn] = bbio_buffer_ff(bbio_inp0, bbio_inn0, bbio_inp1, bbio_inn1, fb_cap,...
                olgain, cmgain, vcm_in, psave, psave_cm, en, en_in0, en_in1, ib_pc_100u, vcm_0v5, VDDA1V2, VSS);
            
            sYpM = en * (sIn0*en_in0 + sIn1*en_in1)/2;
            sYnM = -sYpM;
            
            if (abs(bb_outp - sYpM) > sErrMax) || (abs(bb_outn - sYnM) > sErrMax)
                error('BBIO Buffer Differential Output not correct - Expected: p:%6.4f|n:%6.4f, Actual: p:%6.4f|n:%6.4f',...
                    sYpM, sYnM, bb_outp, bb_outn);
            end
            nCount = nCount+1;
        end
    end
end
        
fprintf('\nAll %d test runs successfully finished!\n', nCount);
