% inandout_splitting_small - Script for Matlab-to-Verilog Conversion of 2-to-1 Signal Adder Fix-Point Model
    
% --- Authors -------------------------------------------------------------
% Steffen Trautmann
% -------------------------------------------------------------------------
    
% --- Copyright -----------------------------------------------------------
% Intel Austria GmbH, Connected Home Division, Villach
% -------------------------------------------------------------------------

%% ####################### MODEL_SPECIFIC PARAMETERS #########################

%% -------------------------------- Model Name --------------------------------
tModelName = 'inandout_splitting_small';

%% ------------------------------ Model Arguments -----------------------------
% function sout = inandout_splitting_small(sin0, sin1)
cModelArgs = cell(2,1);
cModelArgs{1} = coder.typeof(fi(0,numerictype(1,24,23)));   % sin0 (generic 24-bit signed input - for currents and voltages)
cModelArgs{2} = coder.typeof(fi(0,numerictype(1,24,23)));   % sin1 (generic 24-bit signed input - for currents and voltages)


%% call generic Matlab2SV conversion function
addpath ../matlab2sv
Matlab2SV(tModelName, cModelArgs)
rmpath ../matlab2sv
