% inandout_splitting_small - Testbench to check 2-to-1 Signal Adder Fix-Point Model
    
% --- Authors -------------------------------------------------------------
% Steffen Trautmann
% -------------------------------------------------------------------------
    
% --- Copyright -----------------------------------------------------------
% Intel Austria GmbH, Connected Home Division, Villach
% -------------------------------------------------------------------------

vSin0 = [0.012 0.023 0.034 0.045 0.056 0.067 0.078 0.089];
vSin1 = -[0.098 0.087 0.076 0.065 0.054 0.043 0.032 0.021];

% initial settings
sin0 = fi(0, 1, 24, 23);
sin1 = fi(0, 1, 24, 23);

nCount = 0;
sErrMax = 1e-4;
for iS = 1:length(vSin0)
    
    sin0(:) = vSin0(iS);
    sin1(:) = vSin1(iS);
    
    sout = inandout_splitting_small(sin0, sin1);
    
    sout_model = vSin0(iS)+vSin1(iS);
    
    if abs(sout - sout_model) > sErrMax
        error('Adder Output not correct - Expected: p%7.4f, Actual: p%7.4f',...
            sout_model, sout);
    end
    nCount = nCount+1;
end
        
fprintf('\nAll %d test runs successfully finished!\n', nCount);
