function [sout, sout_reverse] = io2inandout_splitting_bbio(sinout, sin)
% io2inandout_splitting_bbio - BBIO Splitter Fix-Point Model for Matlab-to-Verilog Conversion
    
% --- Authors -------------------------------------------------------------
% Steffen Trautmann
% -------------------------------------------------------------------------
    
% --- Copyright -----------------------------------------------------------
% Intel Austria GmbH, Connected Home Division, Villach
% -------------------------------------------------------------------------
  
% underlying fixed-point math rules
oFm = fimath('RoundingMethod', 'Nearest', 'OverflowAction', 'Saturate', 'ProductMode', 'FullPrecision', 'SumMode', 'FullPrecision');

% regular output
sout = fi(sinout, 1, 24, 23, oFm);    % generic 24-bit signed output

% reverse output (to be catched by the wrapper function and handled differently, e.g. by using x-ray functionality)
sout_reverse = fi(sin, 1, 24, 23, oFm);    % generic 24-bit signed output

end

