% io3inandout_split_multdatatyp_svgen - Script for Matlab-to-Verilog
% Conversion of 3-to-1 Signal Adder Fix-Point Model (special version with
% one logical input for RSSI coarse tuning)
    
% --- Authors -------------------------------------------------------------
% Steffen Trautmann
% -------------------------------------------------------------------------
    
% --- Copyright -----------------------------------------------------------
% Intel Austria GmbH, Connected Home Division, Villach
% -------------------------------------------------------------------------

%% ####################### MODEL_SPECIFIC PARAMETERS #########################

%% -------------------------------- Model Name --------------------------------
tModelName = 'io3inandout_split_multdatatyp';

%% ------------------------------ Model Arguments -----------------------------
% function sout = io3inandout_splitting(sin0, sin1, sin2)
cModelArgs = cell(3,1);
cModelArgs{1} = coder.typeof(fi(0,numerictype(1,24,23)));   % sin0 (generic 24-bit signed input - for currents and voltages)
cModelArgs{2} = coder.typeof(false);                        % sin1 (logical input - "Sonderlocke" for coarse tuning current)
cModelArgs{3} = coder.typeof(fi(0,numerictype(1,24,23)));   % sin2 (generic 24-bit signed input - for currents and voltages)


%% call generic Matlab2SV conversion function
addpath ../matlab2sv
Matlab2SV(tModelName, cModelArgs)
rmpath ../matlab2sv
