% rx2_rf_lna_svgen - Script for Matlab-to-Verilog Conversion of 2G LNA Behavioral Fix-Point Model
    
% --- Authors -------------------------------------------------------------
% Steffen Trautmann
% -------------------------------------------------------------------------
    
% --- Copyright -----------------------------------------------------------
% Intel Austria GmbH, Connected Home Division, Villach
% -------------------------------------------------------------------------

%% ####################### MODEL_SPECIFIC PARAMETERS #########################

%% -------------------------------- Model Name --------------------------------
tModelName = 'rx2_rf_lna';

%% ------------------------------ Model Arguments -----------------------------
% function [rf_outp,rf_outn] = rx5_rf_lna(RFRX_ANTx, RFRXGND_ANTx, ctl_gain_lna0, ctl_freq_lna0, ctl_lna_bias0, en_lna0, stby_lna0,...
%                                 en_noise_lna0, en_clamp_lna0, en_noise_lna_addon, ib_pc_const_25u, VDDRF2V5LDO, VDDRF1V2RXLDO, VSSAANTx, VSSPSUB, VSSRF2V5)
cModelArgs = cell(16,1);
cModelArgs{1} = coder.typeof(fi(0,numerictype(0,48,0)));    % RFRX_ANTx
% cModelArgs{2} = coder.typeof(fi(0,numerictype(0,48,0)));    % RFRXGND_ANTx
cModelArgs{2} = coder.typeof(false);                        % RFRXGND_ANTx
cModelArgs{3} = coder.typeof(fi(0,numerictype(0,6,0)));     % [5:0] ctl_gain_lna0
cModelArgs{4} = coder.typeof(fi(0,numerictype(0,3,0)));     % [2:0] ctl_freq_lna0
cModelArgs{5} = coder.typeof(false);                        % ctl_lna_bias0
cModelArgs{6} = coder.typeof(false);                        % en_lna0
cModelArgs{7} = coder.typeof(false);                        % stby_lna0
cModelArgs{8} = coder.typeof(false);                        % en_noise_lna0
cModelArgs{9} = coder.typeof(false);                        % en_clamp_lna0
cModelArgs{10} = coder.typeof(false);                       % en_noise_lna_addon
cModelArgs{11} = coder.typeof(fi(0,numerictype(0,2,0)));    % ib_pc_const_25u
cModelArgs{12} = coder.typeof(false);                       % VDDRF2V5LDO
cModelArgs{13} = coder.typeof(false);                       % VDDRF1V2RXLDO
cModelArgs{14} = coder.typeof(false);                       % VSSAANTx
cModelArgs{15} = coder.typeof(false);                       % VSSPSUB
cModelArgs{16} = coder.typeof(false);                       % VSSRF2V5
%% call generic Matlab2SV conversion function
addpath ../matlab2sv
Matlab2SV(tModelName, cModelArgs)
rmpath ../matlab2sv
