% rx_bb_pga1_svgen - Script for Matlab-to-Verilog Conversion of PGC1 Behavioral Fix-Point Model
    
% --- Authors -------------------------------------------------------------
% Steffen Trautmann
% -------------------------------------------------------------------------
    
% --- Copyright -----------------------------------------------------------
% Intel Austria GmbH, Connected Home Division, Villach
% -------------------------------------------------------------------------

%% ####################### MODEL_SPECIFIC PARAMETERS #########################

%% -------------------------------- Model Name --------------------------------
tModelName = 'rx_bb_pga1';

%% ------------------------------ Model Arguments -----------------------------
% function [outp_i, outn_i, outp_q, outn_q] = rx_bb_pga1(inp_i, inn_i, inp_q, inn_q, inp_cal, inn_cal,...
%     cnt_gain0, cnt_fc0, cnt_pga1_tuning0, en0, en_cal0, stby0, sm0, Iref_25uA0, Vref_600mV0, VDDRF2V5LDO, VDDRF1V2RXLDO, VSSAANTx, imp_dc_i, imp_dc_q, imp_sqrt_gmm, imp_sqrt_gmmi, imp_cos_pmm2, imp_sin_pmm2, bFilter)
cModelArgs = cell(25,1);
cModelArgs{1} = coder.typeof(fi(0,numerictype(1,24,19)));   % inp_i (current inputs)
cModelArgs{2} = coder.typeof(fi(0,numerictype(1,24,19)));   % inn_i (current inputs)
cModelArgs{3} = coder.typeof(fi(0,numerictype(1,24,19)));   % inp_q (current inputs)
cModelArgs{4} = coder.typeof(fi(0,numerictype(1,24,19)));   % inn_q (current inputs)
cModelArgs{5} = coder.typeof(fi(0,numerictype(1,24,21)));   % inp_cal (voltage input)
cModelArgs{6} = coder.typeof(fi(0,numerictype(1,24,21)));   % inn_cal (voltage input)
cModelArgs{7} = coder.typeof(fi(0,numerictype(0,4,0)));     % [3:0] cnt_gain0
cModelArgs{8} = coder.typeof(fi(0,numerictype(0,6,0)));     % [5:0] cnt_fc0
cModelArgs{9} = coder.typeof(fi(0,numerictype(0,3,0)));     % [2:0] cnt_pga1_tuning0 
cModelArgs{10} = coder.typeof(false);                       % en0 (bActive = (en0 && ~stby0) || en_cal!)
cModelArgs{11} = coder.typeof(fi(0,numerictype(0,4,0)));    % [3:0] en_cal0 (Bit0|2 I-path 833|360, Bit1|3 Q-path 833|360)
cModelArgs{12} = coder.typeof(false);                       % stby0
cModelArgs{13} = coder.typeof(fi(0,numerictype(0,2,0)));    % [1:0] sm0 (Bit0 I-path, Bit1 Q-path)
cModelArgs{14} = coder.typeof(false);                       % Iref_25uA0
cModelArgs{15} = coder.typeof(false);                       % Vref_600mV0
cModelArgs{16} = coder.typeof(false);                       % VDDRF2V5LDO
cModelArgs{17} = coder.typeof(false);                       % VDDRF1V2RXLDO
cModelArgs{18} = coder.typeof(false);                       % VSSAANTx
cModelArgs{19} = coder.typeof(fi(0,numerictype(1,24,21)));  % imp_dc_i (DC offset voltage at I output)
cModelArgs{20} = coder.typeof(fi(0,numerictype(1,24,21)));  % imp_dc_q (DC offset voltage at Q output)
% cModelArgs{21} = coder.typeof(fi(0,numerictype(1,24,21)));  % imp_iq_gmm (IQ Gain Mismatch in dB, max. -4..+4dB )
% cModelArgs{22} = coder.typeof(fi(0,numerictype(1,24,19)));  % imp_iq_pmm (IQ Phase Mismatch in degree, max. -16..+16 degree)
cModelArgs{21} = coder.typeof(fi(0,numerictype(1,24,22)));  % imp_sqrt_gmm (pre-calculated IQMM Gain factor)
cModelArgs{22} = coder.typeof(fi(0,numerictype(1,24,22)));  % imp_sqrt_gmmi (pre-calculated inverse IQMM Gain factor)
cModelArgs{23} = coder.typeof(fi(0,numerictype(1,24,22)));  % imp_cos_pmm2 (pre-calculated IQMM Cos Phase factor)
cModelArgs{24} = coder.typeof(fi(0,numerictype(1,24,22)));  % imp_sin_pmm2 (pre-calculated IQMM Sin Phase factor)
cModelArgs{25} = coder.typeof(false);                       % bFilter (switching filter on/off)


%% call generic Matlab2SV conversion function
addpath ../matlab2sv
Matlab2SV(tModelName, cModelArgs)
rmpath ../matlab2sv
