% rx_mixer_bb_svgen - Script for Matlab-to-Verilog Conversion of RX Mixer Baseband Behavioral Fix-Point Model
    
% --- Authors -------------------------------------------------------------
% Steffen Trautmann
% -------------------------------------------------------------------------
    
% --- Copyright -----------------------------------------------------------
% Intel Austria GmbH, Connected Home Division, Villach
% -------------------------------------------------------------------------

%% ####################### MODEL_SPECIFIC PARAMETERS #########################

%% -------------------------------- Model Name --------------------------------
tModelName = 'rx_mixer_bb';

%% ------------------------------ Model Arguments -----------------------------

% function [outp_i, outn_i, outp_q, outn_q] = rx_mixer_bb(inp_i, inn_i, inp_q, inn_q, cnt_odac0, en0, en_ch0,...
%     en_cal0, stby0, Iref_25uA0, Vref_600mV0, VDDRF2V5LDO, VDDA1V2BBFILTLDO, VSSAANTx, VSSPSUB)
cModelArgs = cell(15,1);
cModelArgs{1} = coder.typeof(fi(0,numerictype(1,24,19)));   % inp_i (all current inputs!!!)
cModelArgs{2} = coder.typeof(fi(0,numerictype(1,24,19)));   % inn_i
cModelArgs{3} = coder.typeof(fi(0,numerictype(1,24,19)));   % inp_q
cModelArgs{4} = coder.typeof(fi(0,numerictype(1,24,19)));   % inn_q
cModelArgs{5} = coder.typeof(fi(0,numerictype(0,12,0)));    % [11:0] cnt_odac0 ([5:0] DacI, [11:6] DacQ
cModelArgs{6} = coder.typeof(false);                        % en0 (bActive = (en0 && ~stby0) || en_cal!)
cModelArgs{7} = coder.typeof(fi(0,numerictype(0,2,0)));     % [1:0] en_ch0 (Bit0 I-path, Bit1 Q-path)
cModelArgs{8} = coder.typeof(false);                        % en_cal0
cModelArgs{9} = coder.typeof(false);                        % stby0
cModelArgs{10} = coder.typeof(false);                       % Iref_25uA0
cModelArgs{11} = coder.typeof(false);                       % Vref_600mV0
cModelArgs{12} = coder.typeof(false);                       % VDDRF2V5LDO
cModelArgs{13} = coder.typeof(false);                       % VDDA1V2BBFILTLDO
cModelArgs{14} = coder.typeof(false);                       % VSSAANTx
cModelArgs{15} = coder.typeof(false);                       % VSSPSUB

%% call generic Matlab2SV conversion function
addpath ../matlab2sv
Matlab2SV(tModelName, cModelArgs)
rmpath ../matlab2sv
