% rx_mixer_bb - Testbench to check RX Mixer Baseband Behavioral Fix-Point Model
    
% --- Authors -------------------------------------------------------------
% Steffen Trautmann
% -------------------------------------------------------------------------
    
% --- Copyright -----------------------------------------------------------
% Intel Austria GmbH, Connected Home Division, Villach
% -------------------------------------------------------------------------

sInI = 2.345;     % 2.345mA I input current
sInQ = -1.987;    % -1.987mA Q input current

inp_i = fi(sInI/2, 1, 24, 19);
inn_i = fi(-sInI/2, 1, 24, 19);
inp_q = fi(sInQ/2, 1, 24, 19);
inn_q = fi(-sInQ/2, 1, 24, 19);
cnt_odac0 = fi(0, 0, 12, 0);
en0 = true;
en_ch0 = fi(3, 0, 2, 0);
en_cal0 = false;
stby0 = false;
Iref_25uA0 = true;
Vref_600mV0 = true;
VDDRF2V5LDO = true;
VDDA1V2BBFILTLDO = true;
VSSAANTx = false;
VSSPSUB = false;

nCount = 0;
sErrMax = 1e-3;

vDacSteps = [0:31 -31 -31:-1] * 0.0014516;

for iS = 1:64
    cnt_odac0(:) = iS-1+64*(64-iS);
    for i0 = 1:2
        en0(:) = i0-1;
        for i1 = 1:2
            for i2 = 1:2
                en_ch0(:) = i1-1 + 2*(i2-1);
                for i3 = 1:2
                    en_cal0(:) = i3-1;
                    for i4 = 1:2
                        stby0(:) = i4-1;
                
                        [outp_i, outn_i, outp_q, outn_q] = rx_mixer_bb(inp_i, inn_i, inp_q, inn_q, cnt_odac0, en0, en_ch0,...
                            en_cal0, stby0, Iref_25uA0, Vref_600mV0, VDDRF2V5LDO, VDDA1V2BBFILTLDO, VSSAANTx, VSSPSUB);
                        
                        bActiveI = ((en0 && ~stby0) || en_cal0) && (i1-1);
                        bActiveQ = ((en0 && ~stby0) || en_cal0) && (i2-1);
                        sYpM = (bActiveI*(sInI+vDacSteps(iS)) + 1i*bActiveQ*(sInQ+vDacSteps(64-iS+1)))/2;
                        sYnM = -sYpM;
                        
                        sYp = double(outp_i + 1i*outp_q);
                        sYn = double(outn_i + 1i*outn_q);
                        if (abs(sYp - sYpM) > sErrMax) || (abs(sYn - sYnM) > sErrMax)
                            error('RX Mixer Baseband Differential Output not correct - Expected: %6.4f%+6.4fj|%6.4f%+6.4fj, Actual: %6.4f%+6.4fj|%6.4f%+6.4fj',...
                                real(sYpM), imag(sYpM), real(sYnM), imag(sYnM), real(sYp), imag(sYp), real(sYn), imag(sYn));
                        end
                        nCount = nCount+1;
                    end
                end
            end
        end
    end
end
        
fprintf('\nAll %d test runs successfully finished!\n', nCount);
