% rx_mixer_rf_svgen - Script for Matlab-to-Verilog Conversion of RX Mixer Behavioral Fix-Point Model
    
% --- Authors -------------------------------------------------------------
% Steffen Trautmann
% -------------------------------------------------------------------------
    
% --- Copyright -----------------------------------------------------------
% Intel Austria GmbH, Connected Home Division, Villach
% -------------------------------------------------------------------------

%% ####################### MODEL_SPECIFIC PARAMETERS #########################

%% -------------------------------- Model Name --------------------------------
tModelName = 'rx_mixer_rf';

%% ------------------------------ Model Arguments -----------------------------
% function [outp_i, outn_i, outp_q, outn_q] = rx_mixer_rf(inrf_p, inrf_n, inlop_i, inlon_i, inlop_q, inlon_q,...
%     en_mixer0, stby_mixer0, en_ch_mixer0, en_Isink_mixer0, VDDRF1V2RXLDO, VSSAANTx, VSSPSUB)
cModelArgs = cell(13,1);
cModelArgs{1} = coder.typeof(fi(0,numerictype(0,48,0)));    % inrf_p
cModelArgs{2} = coder.typeof(fi(0,numerictype(0,48,0)));    % inrf_n
cModelArgs{3} = coder.typeof(false);                        % inlop_i
cModelArgs{4} = coder.typeof(false);                        % inlon_i
cModelArgs{5} = coder.typeof(false);                        % inlop_q
cModelArgs{6} = coder.typeof(false);                        % inlon_q
cModelArgs{7} = coder.typeof(false);                        % en_mixer0
cModelArgs{8} = coder.typeof(false);                        % stby_mixer0
cModelArgs{9} = coder.typeof(fi(0,numerictype(0,2,0)));     % [1:0] en_ch_mixer0 (Bit0: Switch I on/off, Bit0: Switch I on/off)
cModelArgs{10} = coder.typeof(false);                       % en_Isink_mixer0 (Debug Mode - must be switched off in regular operation)
cModelArgs{11} = coder.typeof(false);                       % VDDRF1V2RXLDO
cModelArgs{12} = coder.typeof(false);                       % VSSAANTx
cModelArgs{13} = coder.typeof(false);                       % VSSPSUB

%% call generic Matlab2SV conversion function
addpath ../matlab2sv
Matlab2SV(tModelName, cModelArgs)
rmpath ../matlab2sv
