% rx_mixer_rf - Testbench to check 2G/5G RX Mixer Behavioral Fix-Point Model
    
% --- Authors -------------------------------------------------------------
% Steffen Trautmann
% -------------------------------------------------------------------------
    
% --- Copyright -----------------------------------------------------------
% Intel Austria GmbH, Connected Home Division, Villach
% -------------------------------------------------------------------------
vLoInpI = repmat([1 1 0 0], 1, 64);
vLoInnI = repmat([0 0 1 1], 1, 64);
vLoInpQ = repmat([0 1 1 0], 1, 64);
vLoInnQ = repmat([1 0 0 1], 1, 64);

vInRe = repmat(sin(2*pi*[0:15]/16),1,16);
vInIm = repmat(-cos(2*pi*[0:15]/16),1,16);

inrf_p = bitshift(fi(reinterpretcast(fi(vInRe/2,1,24,21),numerictype(0, 24, 0)),0,48,0),24);
inrf_p = fi(inrf_p + reinterpretcast(fi(vInIm/2,1,24,21),numerictype(0, 24, 0)),0,48,0);
inrf_n = bitshift(fi(reinterpretcast(fi(-vInRe/2,1,24,21),numerictype(0, 24, 0)),0,48,0),24);
inrf_n = fi(inrf_n + reinterpretcast(fi(-vInIm/2,1,24,21),numerictype(0, 24, 0)),0,48,0);
inlop_i        = logical(vLoInpI);
inlon_i        = logical(vLoInnI);
inlop_q        = logical(vLoInpQ);
inlon_q        = logical(vLoInnQ);
en_mixer0 = true;
stby_mixer0 = false;
en_ch_mixer0 = fi(3, 0, 2, 0);
en_Isink_mixer0 = false;
VDDRF1V2RXLDO = true;
VSSAANTx = false;
VSSPSUB = false;

nSigLen = 256;
nCount = 0;
sErrMax = 1e-3;

sMixerGain = 0;
sRref = 0.25; % kOhm

for iS = 1:nSigLen
    for iI = 1:2
        for iQ = 1:2
            en_ch_mixer0(:) = iI-1 + 2*(iQ-1);

            [outp_i, outn_i, outp_q, outn_q] = rx_mixer_rf(inrf_p(iS), inrf_n(iS), inlop_i(iS), inlon_i(iS), inlop_q(iS), inlon_q(iS),...
                en_mixer0, stby_mixer0, en_ch_mixer0, en_Isink_mixer0, VDDRF1V2RXLDO, VSSAANTx, VSSPSUB);
            
            sYpM = 10^((sMixerGain+3)/20)/sRref * (vInRe(iS)*(iI-1) + 1i*vInIm(iS)*(iQ-1))/2;
            sYnM = -sYpM;
            
            sYp = double(outp_i + 1i*outp_q);
            sYn = double(outn_i + 1i*outn_q);
            if (abs(sYp - sYpM) > sErrMax) || (abs(sYn - sYnM) > sErrMax)
                error('RX Mixer Differential Output not correct - Expected: %6.4f%+6.4fj|%6.4f%+6.4fj, Actual: %6.4f%+6.4fj|%6.4f%+6.4fj',...
                    real(sYpM), imag(sYpM), real(sYnM), imag(sYnM), real(sYp), imag(sYp), real(sYn), imag(sYn));
            end
            nCount = nCount+1;
        end
    end
    
end

fprintf('\nAll %d test runs successfully finished!\n', nCount);
