function [out_i, out_q, out_ssi] = rx_rfic2dig(inp_i, inn_i, inp_q, inn_q, inp_rssi, inn_rssi)
% rx_rfic2dig - RFIC-to-Digital Interface Block Behavioral Fix-Point Model for Matlab-to-Verilog Conversion
    
% --- Authors -------------------------------------------------------------
% Steffen Trautmann
% -------------------------------------------------------------------------
    
% --- Copyright -----------------------------------------------------------
% Intel Austria GmbH, Connected Home Division, Villach
% -------------------------------------------------------------------------
                            
                            
% underlying fixed-point math rules
% oFm = hdlfimath();
oFm = fimath('RoundingMethod', 'Nearest', 'OverflowAction', 'Saturate', 'ProductMode', 'FullPrecision', 'SumMode', 'FullPrecision');

% ADC Gain
oAdcGain = fi(1/0.6, 1, 16, 13, oFm);   % (linear) gain range: -4..4

% SSI ADC Gain and Shift
oSsiAdcGain = fi(1/0.5*511.5, 0, 24, 13, oFm);   % (linear) gain range: 0..2047
oSsiAdcShift = fi(512, 0, 24, 14, oFm);   % (linear) range: 0..1023

% calculate digital 14-bit output
out_i = fi(oAdcGain * (inp_i-inn_i), 1, 16, 13, oFm); % range -4..+4  
out_q = fi(oAdcGain * (inp_q-inn_q), 1, 16, 13, oFm);

% Limiter
sLimPos = fi(0.99, 1, 14, 13, oFm);
sLimNeg = fi(-0.99, 1, 14, 13, oFm);
out_i = fi(min(sLimPos,max(sLimNeg,out_i)), 1, 14, 13, oFm); % range -1..+1
out_q = fi(min(sLimPos,max(sLimNeg,out_q)), 1, 14, 13, oFm); % range -1..+1

% calculate digital 10-bit xSSI output
out_ssi = fi(oSsiAdcGain * (inp_rssi-inn_rssi) + oSsiAdcShift, 1, 13, 0, oFm); 

% SSI Limiter
sLimPos = fi(1023, 0, 12, 0, oFm);
sLimNeg = fi(0, 0, 12, 0, oFm);
out_ssi = fi(min(sLimPos,max(sLimNeg,out_ssi)), 0, 10, 0, oFm);

end

