% rx_rfic2dig - Testbench to check RFIC-to-Digital Interface Block Behavioral Fix-Point Model
    
% --- Authors -------------------------------------------------------------
% Steffen Trautmann
% -------------------------------------------------------------------------
    
% --- Copyright -----------------------------------------------------------
% Intel Austria GmbH, Connected Home Division, Villach
% -------------------------------------------------------------------------

nS = 256;
sInI = min(0.7, max(-0.7, randn(nS,1)));
sInQ = min(0.7, max(-0.7, randn(nS,1)));

inp_i = fi(sInI/2, 1, 24, 21);
inn_i = fi(-sInI/2, 1, 24, 21);
inp_q = fi(sInQ/2, 1, 24, 21);
inn_q = fi(-sInQ/2, 1, 24, 21);

inp_ssi = fi(sInI/2, 1, 24, 21);
inn_ssi = fi(-sInI/2, 1, 24, 21);

nCount = 0;
sErrMax = 1e-3;

sAdcGain = 1/0.6;

sSsiAdcGain = 1023;
sSsiAdcShift = 512;

for iS = 1:nS
    
    [out_i, out_q, out_ssi] = rx_rfic2dig(inp_i(iS), inn_i(iS), inp_q(iS), inn_q(iS), inp_ssi(iS), inn_ssi(iS));
    
    sYMi(iS) = min(0.99, max(-0.99,sAdcGain * sInI(iS)));
    sYMq(iS) = min(0.99, max(-0.99,sAdcGain * sInQ(iS)));
    sYM(iS) = sYMi(iS) + 1i*sYMq(iS);
    
    sYMSsi(iS) = min(1023, max(0, floor(sSsiAdcGain * sInI(iS) + sSsiAdcShift)));
    
    sY(iS) = double(out_i + 1i*out_q); 
    sYSsi(iS) = double(out_ssi);
    if (abs(sYSsi(iS) - sYMSsi(iS)) > 1)
        error('SSI Output not correct - Expected: %4.0f, Actual: %4.0f',...
            sYMSsi(iS), sYSsi(iS));
    end
    if (abs(sY(iS) - sYM(iS)) > sErrMax)
        error('Output not correct - Expected: %6.4f%+6.4fj, Actual: %6.4f%+6.4fj',...
            real(sYM(iS)), imag(sYM(iS)), real(sY(iS)), imag(sY(iS)));
    end
    nCount = nCount+1;
end
% single check of the output format
if ~isequal(out_i.Signedness,'Signed') || out_i.WordLength~=14 || out_i.FractionLength~=13 ||...
        ~isequal(out_q.Signedness,'Signed') || out_q.WordLength~=14 || out_q.FractionLength~=13
    error('Wrong Output Format!!!');
end

fprintf('\nAll %d test runs successfully finished!\n', nCount);
