% ssbcal_svgen - Script for Matlab-to-Verilog Conversion of SSBCal Behavioral Fix-Point Model
    
% --- Authors -------------------------------------------------------------
% Steffen Trautmann
% -------------------------------------------------------------------------
    
% --- Copyright -----------------------------------------------------------
% Intel Austria GmbH, Connected Home Division, Villach
% -------------------------------------------------------------------------
    

%% ####################### MODEL_SPECIFIC PARAMETERS #########################

%% -------------------------------- Model Name --------------------------------
tModelName = 'ssbcal';

%% ------------------------------ Model Arguments -----------------------------
% function [bb_outp_ssbcal, bb_outn_ssbcal] = ssbcal(rf_inp_ssbcal, rf_inn_ssbcal, ctl_Iss_ssbcal,...
%     ctl_bias_select_ssbcal, en_1v2_ssbcal, ib_pc_const_25uA, vcm_0v6_ssbcal, VDDA3V3, VDDA2V5, VDDA1V2, VDDRF1V2, VSS, VSSA_LDO2V5);
cModelArgs = cell(13,1);
cModelArgs{1} = coder.typeof(fi(0,numerictype(0,48,0)));    % rf_inp_ssbcal, positive differential RF Input 
cModelArgs{2} = coder.typeof(fi(0,numerictype(0,48,0)));    % rf_inn_ssbcal, negative differential RF Input
cModelArgs{3} = coder.typeof(fi(0,numerictype(0,4,0)));     % [3:0] ctl_Iss_ssbcal
cModelArgs{4} = coder.typeof(false);                        % ctl_bias_select_ssbcal
cModelArgs{5} = coder.typeof(false);                        % en_1v2_ssbcal
cModelArgs{6} = coder.typeof(false);                        % ib_pc_const_25uA
cModelArgs{7} = coder.typeof(false);                        % vcm_0v6_ssbcal
cModelArgs{8} = coder.typeof(false);                        % VDDA3V3
cModelArgs{9} = coder.typeof(false);                        % VDDA2V5
cModelArgs{10} = coder.typeof(false);                       % VDDA1V2
cModelArgs{11} = coder.typeof(false);                       % VDDRF1V2
cModelArgs{12} = coder.typeof(false);                       % VSS
cModelArgs{13} = coder.typeof(false);                       % VSSA_LDO2V5

%% call generic Matlab2SV conversion function
addpath ../matlab2sv
Matlab2SV(tModelName, cModelArgs)
rmpath ../matlab2sv
