% SSB_tb - Testbench to check SSBCal Behavioral Fix-Point Model
    
% --- Authors -------------------------------------------------------------
% Steffen Trautmann
% -------------------------------------------------------------------------
    
% --- Copyright -----------------------------------------------------------
% Intel Austria GmbH, Connected Home Division, Villach
% -------------------------------------------------------------------------
    
sX      = 0.11234 + 1i*0.16789;
sXp     = sX/2;
sXn     = -sXp;

%% Default Inputs
rf_inp_ssbcal = bitshift(fi(reinterpretcast(fi(real(sXp),1,24,21),numerictype(0, 24, 0)),0,48,0),24);
rf_inp_ssbcal = fi(rf_inp_ssbcal + reinterpretcast(fi(imag(sXp),1,24,21),numerictype(0, 24, 0)),0,48,0);
rf_inn_ssbcal = bitshift(fi(reinterpretcast(fi(real(sXn),1,24,21),numerictype(0, 24, 0)),0,48,0),24);
rf_inn_ssbcal = fi(rf_inn_ssbcal + reinterpretcast(fi(imag(sXn),1,24,21),numerictype(0, 24, 0)),0,48,0);

ctl_Iss_ssbcal          = fi(1, 0, 4, 0);
ctl_bias_select_ssbcal  = true;
en_1v2_ssbcal           = true;
ib_pc_const_25uA        = true;
vcm_0v6_ssbcal          = true;
VDDA3V3                 = true;
VDDA2V5                 = true;
VDDA1V2                 = true;
VDDRF1V2                = true;
VSS                     = false;
VSSA_LDO2V5             = false;

%% Nested Loops to verify Output for different Inputs (VDD/VSS/Ibias pins not varied, always active!)
nCount = 1;
[bb_outp_ssbcal, bb_outn_ssbcal] = ssbcal(rf_inp_ssbcal, rf_inn_ssbcal, ctl_Iss_ssbcal,...
    ctl_bias_select_ssbcal, en_1v2_ssbcal, ib_pc_const_25uA, vcm_0v6_ssbcal, VDDA3V3, VDDA2V5, VDDA1V2, VDDRF1V2, VSS, VSSA_LDO2V5);

fprintf('\nAll %d test runs successfully finished!\n', nCount);

    
    
    