% supplymon_svgen - Script for Matlab-to-Verilog Conversion of Supply Monitor Behavioral Fix-Point Model
    
% --- Authors -------------------------------------------------------------
% Steffen Trautmann
% -------------------------------------------------------------------------
    
% --- Copyright -----------------------------------------------------------
% Intel Austria GmbH, Connected Home Division, Villach
% -------------------------------------------------------------------------

%% ####################### MODEL_SPECIFIC PARAMETERS #########################

%% -------------------------------- Model Name --------------------------------
tModelName = 'supplymon';

%% ------------------------------ Model Arguments -----------------------------
% function [supplymon_oup, supplymon_oun] = supplymon(VDDA1V2RXLDO, VDDA1V2TXLDO, VDDRF1V2BBLDO, VDDRF1V2BBFILTLDO,...
%     VDDRF2V5LDO, VDD1V5LDO12in, VDD3V3LDO25in, VDD3V3FECTL, TSSI_cal_sens, ctl,...
%     ib_pc_const_25u_supplymon1, ib_pc_const_25u_supplymon2, VDD, VSS)
cModelArgs = cell(14,1);
cModelArgs{1} = coder.typeof(false);                        % VDDA1V2RXLDO sense input
cModelArgs{2} = coder.typeof(false);                        % VDDA1V2TXLDO sense input
cModelArgs{3} = coder.typeof(false);                        % VDDRF1V2BBLDO sense input
cModelArgs{4} = coder.typeof(false);                        % VDDRF1V2BBFILTLDO sense input
cModelArgs{5} = coder.typeof(false);                        % VDDRF2V5LDO sense input
cModelArgs{6} = coder.typeof(false);                        % VDD1V5LDO12in sense input
cModelArgs{7} = coder.typeof(false);                        % VDD3V3LDO25in sense input
cModelArgs{8} = coder.typeof(false);                        % VDD3V3FECTL 0.7V input for calibration (only logic input)
cModelArgs{9} = coder.typeof(fi(0,numerictype(1,24,21)));   % TSSI_cal_sens 0.4V input for calibration (fixpoint voltage input)
cModelArgs{10} = coder.typeof(fi(0,numerictype(0,12,0)));    % ctl
cModelArgs{11} = coder.typeof(false);                        % ib_pc_const_25u_supplymon1
cModelArgs{12} = coder.typeof(false);                        % ib_pc_const_25u_supplymon2
cModelArgs{13} = coder.typeof(false);                        % VDD
cModelArgs{14} = coder.typeof(false);                        % VSS


%% call generic Matlab2SV conversion function
addpath ../matlab2sv
Matlab2SV(tModelName, cModelArgs)
rmpath ../matlab2sv
