% supplymon - Testbench to check Supply Monitor Behavioral Fix-Point Model
    
% --- Authors -------------------------------------------------------------
% Steffen Trautmann
% -------------------------------------------------------------------------
    
% --- Copyright -----------------------------------------------------------
% Intel Austria GmbH, Connected Home Division, Villach
% -------------------------------------------------------------------------

% allow some deviations to separate testcases
sR40 = 42;
sR30 = 31;
vRx =  [54      55      56      57      183     77      255     56      56];
vVdd = [1.27    1.26    1.25    1.24    2.45    1.53    3.35    0.0     0.0];
sVref04 = 0.40;
sVref07 = 0.70;
sVrefdelta = 0.01;

% initial settings
VDDA1V2RXLDO = false;
VDDA1V2TXLDO = false;
VDDRF1V2BBLDO = false;
VDDRF1V2BBFILTLDO = false;
VDDRF2V5LDO = false;
VDD1V5LDO12in = false;
VDD3V3LDO25in = false;
VDD3V3FECTL = false;

TSSI_cal_sens = fi(sVref04, 1, 24, 21);
ctl = fi(0, 0, 12, 0);
ib_pc_const_25u_supplymon1 = true;
ib_pc_const_25u_supplymon2 = true;
VDD = true;
VSS = false;

nCount = 0;
sErrMax = 1e-4;
for iS = 1:length(vRx)
    for i0 = 1:2
        VDDA1V2RXLDO = false;
        VDDA1V2TXLDO = false;
        VDDRF1V2BBLDO = false;
        VDDRF1V2BBFILTLDO = false;
        VDDRF2V5LDO = false;
        VDD1V5LDO12in = false;
        VDD3V3LDO25in = false; 
        VDD3V3FECTL = false;
        switch iS
            case 1
                sCtl = 4;
                VDDA1V2RXLDO(:) = i0-1;
            case 2
                sCtl = 8;
                VDDA1V2TXLDO(:) = i0-1;
            case 3
                sCtl = 16;
                VDDRF1V2BBLDO(:) = i0-1;
            case 4
                sCtl = 32;
                VDDRF1V2BBFILTLDO(:) = i0-1;
            case 5
                sCtl = 64;
                VDDRF2V5LDO(:) = i0-1;
            case 6
                sCtl = 128 + 1024;
                VDD1V5LDO12in(:) = i0-1;
            case 7
                sCtl = 256 + 2048;
                VDD3V3LDO25in(:) = i0-1;
            case 8
                sCtl = 512;
                VDD3V3FECTL(:) = i0-1;
                TSSI_cal_sens = fi(sVref04+sVrefdelta, 1, 24, 21);
            otherwise
                sCtl = 4 + 8;         % unallowed state
                VDDA1V2RXLDO(:) = i0-1;
                VDDA1V2TXLDO(:) = i0-1;
        end
        for i1 = 1:2
            bEnable = i1-1;
            for i2 = 1:2
                bToggle = i2-1;
                ctl(:) = sCtl + bEnable + 2*bToggle;
                
                [supplymon_oup, supplymon_oun] = supplymon(VDDA1V2RXLDO, VDDA1V2TXLDO, VDDRF1V2BBLDO, VDDRF1V2BBFILTLDO,...
                    VDDRF2V5LDO, VDD1V5LDO12in, VDD3V3LDO25in, VDD3V3FECTL, TSSI_cal_sens, ctl,...
                    ib_pc_const_25u_supplymon1, ib_pc_const_25u_supplymon2, VDD, VSS);
                
                bActive = (bEnable && ib_pc_const_25u_supplymon1 && ib_pc_const_25u_supplymon2 && VDD && ~VSS);
                
                if ~bitget(ctl,10)
                    if bToggle
                        sOutp = (sR40+sR30)/(sR40+sR30+vRx(iS))*vVdd(iS)*(i0-1)*bActive;
                        sOutn = sR40/(sR40+sR30+vRx(iS))*vVdd(iS)*(i0-1)*bActive;
                    else
                        sOutn = (sR40+sR30)/(sR40+sR30+vRx(iS))*vVdd(iS)*(i0-1)*bActive;
                        sOutp = sR40/(sR40+sR30+vRx(iS))*vVdd(iS)*(i0-1)*bActive;
                    end
                else
                    if bToggle
                        sOutp = (i0-1)*bActive*sVref07;
                        sOutn = bActive*(sVref04+sVrefdelta);
                    else
                        sOutn = (i0-1)*bActive*sVref07;
                        sOutp = bActive*(sVref04+sVrefdelta);
                    end
                end
                
                if (abs(sOutp-supplymon_oup) > sErrMax) || (abs(sOutn-supplymon_oun) > sErrMax)
                    error('SupplyMon Output not correct - Expected: p%7.4f n%7.4f, Actual: p%7.4f n%7.4f',...
                        sOutp, sOutn, supplymon_oup, supplymon_oun);
                end
                nCount = nCount+1;
            end
        end
    end
end
        
fprintf('\nAll %d test runs successfully finished!\n', nCount);
