function [outp_i, outn_i, outp_q, outn_q] = tx_dig2rfic(in_i, in_q)
% tx_dig2rfic - Digital-to-RFIC Interface Block Behavioral Fix-Point Model for Matlab-to-Verilog Conversion
    
% --- Authors -------------------------------------------------------------
% Steffen Trautmann
% -------------------------------------------------------------------------
    
% --- Copyright -----------------------------------------------------------
% Intel Austria GmbH, Connected Home Division, Villach
% -------------------------------------------------------------------------
                            
                            
% underlying fixed-point math rules
oFm = fimath('RoundingMethod', 'Nearest', 'OverflowAction', 'Saturate', 'ProductMode', 'FullPrecision', 'SumMode', 'FullPrecision');

% DAC Gain
oDacGain = fi(0.5, 0, 24, 22, oFm);   % (linear) gain range: 0..4

% calculate "analog" I/Q output in 24-bit fix-point format
outp_i = fi(oDacGain/2 * in_i, 1, 24, 21, oFm);  % range -4V..+4V
outn_i = fi(-outp_i, 1, 24, 21, oFm);
outp_q = fi(oDacGain/2 * in_q, 1, 24, 21, oFm);  % range -4V..+4V
outn_q = fi(-outp_q, 1, 24, 21, oFm);

end

