% tx_dig2rfic - Testbench to check Digital-to-RFIC Interface Block Behavioral Fix-Point Model
    
% --- Authors -------------------------------------------------------------
% Steffen Trautmann
% -------------------------------------------------------------------------
    
% --- Copyright -----------------------------------------------------------
% Intel Austria GmbH, Connected Home Division, Villach
% -------------------------------------------------------------------------

nS = 256;
sInI = randn(nS,1)/10;
sInQ = randn(nS,1)/10;

in_i = fi(sInI, 1, 14, 13);
in_q = fi(sInQ, 1, 14, 13);

nCount = 0;
sErrMax = 1e-3;

sDacGain = 0.5;

for iS = 1:nS
    
    [outp_i, outn_i, outp_q, outn_q] = tx_dig2rfic(in_i(iS), in_q(iS));
    
    sYpM = sDacGain/2 * (sInI(iS)+1i*sInQ(iS));
    sYnM = -sYpM;
    
    sYp = double(outp_i + 1i*outp_q);
    sYn = double(outn_i + 1i*outn_q);
    if (abs(sYp - sYpM) > sErrMax) || (abs(sYn - sYnM) > sErrMax)
        error('Differential Output not correct - Expected: %6.4f%+6.4fj|%6.4f%+6.4fj, Actual: %6.4f%+6.4fj|%6.4f%+6.4fj',...
            real(sYpM), imag(sYpM), real(sYnM), imag(sYnM), real(sYp), imag(sYp), real(sYn), imag(sYn));
    end
    nCount = nCount+1;
end
% single check of the output format
if ~isequal(outp_i.Signedness,'Signed') || outp_i.WordLength~=24 || outp_i.FractionLength~=21 ||...
        ~isequal(outn_i.Signedness,'Signed') || outn_i.WordLength~=24 || outn_i.FractionLength~=21 ||...
        ~isequal(outp_q.Signedness,'Signed') || outp_q.WordLength~=24 || outp_q.FractionLength~=21 ||...
        ~isequal(outn_q.Signedness,'Signed') || outn_q.WordLength~=24 || outn_q.FractionLength~=21
    error('Wrong Output Format!!!');
end

fprintf('\nAll %d test runs successfully finished!\n', nCount);
