function [rf_out_se_pad2g, rf_gnd_pad2g, rf_outp_pad2g, rf_outn_pad2g, OP_outp, OP_outn, vb_pad2g] = tx_pad2g_6bit(...
    rf_inp_pad2g, rf_inn_pad2g, ctl_gain_pad2g, ctl_band_pad2g, ctl_ibias_pad2g, ctl_vc_pad2g, ctl_vc_bias_pad2g,...
    en_pad2g, stby_pad2g, ib_pc_const_50uA, VDD2V5, VDDRF1V2, VSSRF1V2, VSSPSUB)

% underlying fixed-point math rules
oFm = fimath('RoundingMethod', 'Nearest', 'OverflowAction', 'Saturate', 'ProductMode', 'FullPrecision', 'SumMode', 'FullPrecision');

% extract 2 x 24bit Re and Im parts from 48bit input
% oInpRe = bitsliceget(rf_inp_pad2g,48,25);
% oInpIm = bitsliceget(rf_inp_pad2g,24,1);
% oInpRe = reinterpretcast(oInpRe,numerictype(1, 24, 21));
% oInpIm = reinterpretcast(oInpIm,numerictype(1, 24, 21));
oInpRe = bitsliceget(rf_inp_pad2g,47,25);oInpReSign = logical(bitsliceget(rf_inp_pad2g,48,48));
oInpIm = bitsliceget(rf_inp_pad2g,23,1);oInpImSign = logical(bitsliceget(rf_inp_pad2g,24,24));
oOffs = fi(-4, 1, 24, 21, oFm);
oInpRe = fi(reinterpretcast(oInpRe,numerictype(0, 23, 21)),1, 24, 21, oFm);
oInpIm = fi(reinterpretcast(oInpIm,numerictype(0, 23, 21)),1, 24, 21, oFm);
if oInpReSign 
    oInpRe = fi(oInpRe + oOffs, 1, 24, 21, oFm);
end
if oInpImSign
    oInpIm = fi(oInpIm + oOffs, 1, 24, 21, oFm);
end

% oInnRe = bitsliceget(rf_inn_pad2g,48,25);
% oInnIm = bitsliceget(rf_inn_pad2g,24,1);
% oInnRe = reinterpretcast(oInnRe,numerictype(1, 24, 21));
% oInnIm = reinterpretcast(oInnIm,numerictype(1, 24, 21));
oInnRe = bitsliceget(rf_inn_pad2g,47,25);oInnReSign = logical(bitsliceget(rf_inn_pad2g,48,48));
oInnIm = bitsliceget(rf_inn_pad2g,23,1);oInnImSign = logical(bitsliceget(rf_inn_pad2g,24,24));
oOffs = fi(-4, 1, 24, 21, oFm);
oInnRe = fi(reinterpretcast(oInnRe,numerictype(0, 23, 21)),1, 24, 21, oFm);
oInnIm = fi(reinterpretcast(oInnIm,numerictype(0, 23, 21)),1, 24, 21, oFm);
if oInnReSign 
    oInnRe = fi(oInnRe + oOffs, 1, 24, 21, oFm);
end
if oInnImSign
    oInnIm = fi(oInnIm + oOffs, 1, 24, 21, oFm);
end

%% check supplies and stby/enable flags
% check supplies
% bSupply = logical(VDD2V5 && VDDRF1V2 && ~VSSRF1V2 && ~VSSPSUB);
bSupply = logical(VDD2V5 && VDDRF1V2 && ~VSSRF1V2);

% check biasing
bBias = logical(ib_pc_const_50uA);

% RSSI in active state and supplied?
bActive = logical(en_pad2g && ~stby_pad2g && bSupply && bBias);

%% calculate actual gain
oGainMax = fi(10^(7.5/20), 0, 24, 19, oFm);                     % range: 0..32
oGainAct = fi(fi(ctl_gain_pad2g,0,24,18)/63 * oGainMax, 0, 24, 19, oFm);    % range: 0..32

%% TX band selection (currently not evaluated)
% oDummy = fi(ctl_band_pad2g, 0, 3, 0, oFm);

%% ibias programming (currently not evaluated)
% oDummy = fi(ctl_ibias_pad2g, 0, 3, 0, oFm);

%% vc programming (currently not evaluated)
% oDummy = fi(ctl_vc_pad2g, 0, 3, 0, oFm);

%% vc bias programming (currently not evaluated)
% oDummy = fi(ctl_vc_bias_pad2g, 0, 2, 0, oFm);

%% calculate outputs
% single-ended output
oOutSeRe = fi((oInpRe-oInnRe) * oGainAct * bActive, 1, 24, 21, oFm);
oOutSeIm = fi((oInpIm-oInnIm) * oGainAct * bActive, 1, 24, 21, oFm);
% oOutGndRe = fi(0, 1, 24, 21, oFm);
% oOutGndIm = fi(0, 1, 24, 21, oFm);
% construct 48bit outputs P and N from 24bit Re and Im parts
rf_out_se_pad2g = bitshift(fi(reinterpretcast(oOutSeRe,numerictype(0, 24, 0)),0,48,0,oFm),24);
rf_out_se_pad2g = fi(rf_out_se_pad2g + reinterpretcast(oOutSeIm,numerictype(0, 24, 0)),0,48,0,oFm);
% rf_gnd_pad2g = bitshift(fi(reinterpretcast(oOutGndRe,numerictype(0, 24, 0)),0,48,0,oFm),24);
% rf_gnd_pad2g = fi(rf_gnd_pad2g + reinterpretcast(oOutGndIm,numerictype(0, 24, 0)),0,48,0,oFm);
rf_gnd_pad2g = logical(false);

% differential output (für SSBCal)
oOutpRe = fi(oOutSeRe/2, 1, 24, 21, oFm);
oOutpIm = fi(oOutSeIm/2, 1, 24, 21, oFm);

% Limiter
sLimPos = fi(1.8, 1, 24, 21, oFm);      % 1.8Vp corresponds to ~15dBm for CW
sLimNeg = fi(-1.8, 1, 24, 21, oFm);
oOutpRe = fi(min(sLimPos,max(sLimNeg,oOutpRe)), 1, 24, 21, oFm);
oOutpIm = fi(min(sLimPos,max(sLimNeg,oOutpIm)), 1, 24, 21, oFm);

oOutnRe = fi(-oOutpRe, 1, 24, 21, oFm);
oOutnIm = fi(-oOutpIm, 1, 24, 21, oFm);
rf_outp_pad2g = bitshift(fi(reinterpretcast(oOutpRe,numerictype(0, 24, 0)),0,48,0,oFm),24);
rf_outp_pad2g = fi(rf_outp_pad2g + reinterpretcast(oOutpIm,numerictype(0, 24, 0)),0,48,0,oFm);
rf_outn_pad2g = bitshift(fi(reinterpretcast(oOutnRe,numerictype(0, 24, 0)),0,48,0,oFm),24);
rf_outn_pad2g = fi(rf_outn_pad2g + reinterpretcast(oOutnIm,numerictype(0, 24, 0)),0,48,0,oFm);

% other differential output (unused)
OP_outp = rf_outp_pad2g;
OP_outn = rf_outn_pad2g;

% place holder for biasing output
vb_pad2g = logical(true);

end

