/**
* @file        MODULE_rf_central_long.cpp
* @author      klatzer
* @copyright   INTEL
*
* @briefCentral Long Registers
*
* This is a Spectool2 file.
*/

#include "MODULE_rf_central_long.h"

#include "IndirectAccessPort.h"
#include "Register.h"
#include "RField.h"
#include "Attribute.h"
#include "Format.h"
#include "Utilities.h"
#include "python/str.h"

MODULE_rf_central_long::MODULE_rf_central_long()
{
  ///////////////////////////
  //// MODULE PROPERTIES ////
  setBaseName ("rf_central_long");
  setLongName ("Central Long Registers");
  setDescription ("CENTRAL LONG REGISTER");
  setContact ("klatzer");
  setFile (__FILE__);
  setGenerateGraphic(true);
  setIp(true);
  // addDocuLink("path to location", "description");
  // addDocuPicture("path to picture", "title");
  // addReference("module path to reference", "title");
  
  ////////////////////////////////////////////////////////////
  /// PORTS WHICH ARE CONTROLLED EXTERNALLY (INPUT PORTS) ////
  Port* p_FCSI = new Port (this);
  p_FCSI->setInstName ("FCSI");
  p_FCSI->setLongName ("Single Central FCSI Interface");
  p_FCSI->setDescription ("");
  p_FCSI->setAddrBase (16);
  p_FCSI->setDataWidth (16);
  p_FCSI->setAddrSpace (0x00000030);
  p_FCSI->setAccess (AddressableNode::RW);
  p_FCSI->setOffsetAsView(0x00000000);
  p_FCSI->setAllowAddrOverlap(false);
  p_FCSI->setAddrAlignCheck(AddressableNode::AAC_AUTO_OFF);
  p_FCSI->setBusProtocol (Bus::FCSI);
  p_FCSI->setCollapse (false);

  
  ///////////////////////////////////////////////////
  /// PORTS WHICH ARE CONTROLLING EXTERNAL PORTS (OUTPUT PORTS) ////
  
  /////////////////////
  //// SUB-MODULES ////
  
  ////////////////////////
  //// INTERNAL PORTS ////
  
  ////////////////////////
  //// INTERNAL BUSES ////
  
  //////////////////////////////
  //// REGISTERS AND FIELDS ////
  Register* r_FCSI_PLL0PUP0 = new Register;
  r_FCSI_PLL0PUP0->setInstName ("PLL0PUP0");
  r_FCSI_PLL0PUP0->setLongName ("PLL0 POWER UP CENTRAL");
  r_FCSI_PLL0PUP0->setDescription ("FCSI-LDO1V2");
  r_FCSI_PLL0PUP0->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_PLL0PUP0, 0x00000000);

  RField* f_FCSI_PLL0PUP0_shuntreg_override_fc = new RField;
  f_FCSI_PLL0PUP0_shuntreg_override_fc->setInstName ("shuntreg_override_fc");
  f_FCSI_PLL0PUP0_shuntreg_override_fc->setLongName ("SHUNTREG OVERRIDE FC");
  f_FCSI_PLL0PUP0_shuntreg_override_fc->setDescription ("Fast charge option in CP shunt-regulator (bypassed)");
  f_FCSI_PLL0PUP0_shuntreg_override_fc->setDataWidth (1);
  f_FCSI_PLL0PUP0_shuntreg_override_fc->setResetVal ("1'b0");
  f_FCSI_PLL0PUP0_shuntreg_override_fc->setAccProp (AccProp::RW);
  r_FCSI_PLL0PUP0->connectRField (f_FCSI_PLL0PUP0_shuntreg_override_fc, 1);

  Attribute* a_FCSI_PLL0PUP0_shuntreg_override_fc_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0PUP0_shuntreg_override_fc_0_0->setInstName ("0");
  a_FCSI_PLL0PUP0_shuntreg_override_fc_0_0->setLongName ("");
  a_FCSI_PLL0PUP0_shuntreg_override_fc_0_0->setDescription ("");
  a_FCSI_PLL0PUP0_shuntreg_override_fc_0_0->addItem("1", "1'b1", "disable");
  a_FCSI_PLL0PUP0_shuntreg_override_fc_0_0->addItem("0", "1'b0", "enable");
  f_FCSI_PLL0PUP0_shuntreg_override_fc->connectAttribute (a_FCSI_PLL0PUP0_shuntreg_override_fc_0_0);

  RField* f_FCSI_PLL0PUP0_vcoreg_override_fc = new RField;
  f_FCSI_PLL0PUP0_vcoreg_override_fc->setInstName ("vcoreg_override_fc");
  f_FCSI_PLL0PUP0_vcoreg_override_fc->setLongName ("VCOREG OVERRIDE FC");
  f_FCSI_PLL0PUP0_vcoreg_override_fc->setDescription ("Fast charge option in VCO (bypassed)");
  f_FCSI_PLL0PUP0_vcoreg_override_fc->setDataWidth (1);
  f_FCSI_PLL0PUP0_vcoreg_override_fc->setResetVal ("1'b0");
  f_FCSI_PLL0PUP0_vcoreg_override_fc->setAccProp (AccProp::RW);
  r_FCSI_PLL0PUP0->connectRField (f_FCSI_PLL0PUP0_vcoreg_override_fc, 2);

  Attribute* a_FCSI_PLL0PUP0_vcoreg_override_fc_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0PUP0_vcoreg_override_fc_0_0->setInstName ("0");
  a_FCSI_PLL0PUP0_vcoreg_override_fc_0_0->setLongName ("");
  a_FCSI_PLL0PUP0_vcoreg_override_fc_0_0->setDescription ("");
  a_FCSI_PLL0PUP0_vcoreg_override_fc_0_0->addItem("1", "1'b1", "disable");
  a_FCSI_PLL0PUP0_vcoreg_override_fc_0_0->addItem("0", "1'b0", "enable");
  f_FCSI_PLL0PUP0_vcoreg_override_fc->connectAttribute (a_FCSI_PLL0PUP0_vcoreg_override_fc_0_0);

  RField* f_FCSI_PLL0PUP0_vcoreg_bypass = new RField;
  f_FCSI_PLL0PUP0_vcoreg_bypass->setInstName ("vcoreg_bypass");
  f_FCSI_PLL0PUP0_vcoreg_bypass->setLongName ("VCOREG BYPASS");
  f_FCSI_PLL0PUP0_vcoreg_bypass->setDescription ("VCO register output bypassed (use external supply)");
  f_FCSI_PLL0PUP0_vcoreg_bypass->setDataWidth (1);
  f_FCSI_PLL0PUP0_vcoreg_bypass->setResetVal ("1'b0");
  f_FCSI_PLL0PUP0_vcoreg_bypass->setAccProp (AccProp::RW);
  r_FCSI_PLL0PUP0->connectRField (f_FCSI_PLL0PUP0_vcoreg_bypass, 3);

  Attribute* a_FCSI_PLL0PUP0_vcoreg_bypass_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0PUP0_vcoreg_bypass_0_0->setInstName ("0");
  a_FCSI_PLL0PUP0_vcoreg_bypass_0_0->setLongName ("");
  a_FCSI_PLL0PUP0_vcoreg_bypass_0_0->setDescription ("");
  a_FCSI_PLL0PUP0_vcoreg_bypass_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_PLL0PUP0_vcoreg_bypass_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL0PUP0_vcoreg_bypass->connectAttribute (a_FCSI_PLL0PUP0_vcoreg_bypass_0_0);

  RField* f_FCSI_PLL0PUP0_pup_reg_resync = new RField;
  f_FCSI_PLL0PUP0_pup_reg_resync->setInstName ("pup_reg_resync");
  f_FCSI_PLL0PUP0_pup_reg_resync->setLongName ("PUP REG RESYNC");
  f_FCSI_PLL0PUP0_pup_reg_resync->setDescription ("Power up for DIVN re-sync block regulator");
  f_FCSI_PLL0PUP0_pup_reg_resync->setDataWidth (1);
  f_FCSI_PLL0PUP0_pup_reg_resync->setResetVal ("1'b0");
  f_FCSI_PLL0PUP0_pup_reg_resync->setAccProp (AccProp::RW);
  r_FCSI_PLL0PUP0->connectRField (f_FCSI_PLL0PUP0_pup_reg_resync, 4);

  Attribute* a_FCSI_PLL0PUP0_pup_reg_resync_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0PUP0_pup_reg_resync_0_0->setInstName ("0");
  a_FCSI_PLL0PUP0_pup_reg_resync_0_0->setLongName ("");
  a_FCSI_PLL0PUP0_pup_reg_resync_0_0->setDescription ("");
  a_FCSI_PLL0PUP0_pup_reg_resync_0_0->addItem("1", "1'b1", "enable (default)");
  a_FCSI_PLL0PUP0_pup_reg_resync_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL0PUP0_pup_reg_resync->connectAttribute (a_FCSI_PLL0PUP0_pup_reg_resync_0_0);

  RField* f_FCSI_PLL0PUP0_pup_vvbgen_ppath = new RField;
  f_FCSI_PLL0PUP0_pup_vvbgen_ppath->setInstName ("pup_vvbgen_ppath");
  f_FCSI_PLL0PUP0_pup_vvbgen_ppath->setLongName ("PUP VVBGEN PPATH");
  f_FCSI_PLL0PUP0_pup_vvbgen_ppath->setDescription ("Power up for enabling the direct path in the LPF");
  f_FCSI_PLL0PUP0_pup_vvbgen_ppath->setDataWidth (1);
  f_FCSI_PLL0PUP0_pup_vvbgen_ppath->setResetVal ("1'b0");
  f_FCSI_PLL0PUP0_pup_vvbgen_ppath->setAccProp (AccProp::RW);
  r_FCSI_PLL0PUP0->connectRField (f_FCSI_PLL0PUP0_pup_vvbgen_ppath, 5);

  Attribute* a_FCSI_PLL0PUP0_pup_vvbgen_ppath_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0PUP0_pup_vvbgen_ppath_0_0->setInstName ("0");
  a_FCSI_PLL0PUP0_pup_vvbgen_ppath_0_0->setLongName ("");
  a_FCSI_PLL0PUP0_pup_vvbgen_ppath_0_0->setDescription ("");
  a_FCSI_PLL0PUP0_pup_vvbgen_ppath_0_0->addItem("1", "1'b1", "enable (default)");
  a_FCSI_PLL0PUP0_pup_vvbgen_ppath_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL0PUP0_pup_vvbgen_ppath->connectAttribute (a_FCSI_PLL0PUP0_pup_vvbgen_ppath_0_0);

  RField* f_FCSI_PLL0PUP0_pup_vvbgen_lpath = new RField;
  f_FCSI_PLL0PUP0_pup_vvbgen_lpath->setInstName ("pup_vvbgen_lpath");
  f_FCSI_PLL0PUP0_pup_vvbgen_lpath->setLongName ("PUP VVBGEN LPATH");
  f_FCSI_PLL0PUP0_pup_vvbgen_lpath->setDescription ("Power up for enabling the integrating path in the LPF");
  f_FCSI_PLL0PUP0_pup_vvbgen_lpath->setDataWidth (1);
  f_FCSI_PLL0PUP0_pup_vvbgen_lpath->setResetVal ("1'b0");
  f_FCSI_PLL0PUP0_pup_vvbgen_lpath->setAccProp (AccProp::RW);
  r_FCSI_PLL0PUP0->connectRField (f_FCSI_PLL0PUP0_pup_vvbgen_lpath, 6);

  Attribute* a_FCSI_PLL0PUP0_pup_vvbgen_lpath_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0PUP0_pup_vvbgen_lpath_0_0->setInstName ("0");
  a_FCSI_PLL0PUP0_pup_vvbgen_lpath_0_0->setLongName ("");
  a_FCSI_PLL0PUP0_pup_vvbgen_lpath_0_0->setDescription ("");
  a_FCSI_PLL0PUP0_pup_vvbgen_lpath_0_0->addItem("1", "1'b1", "enable (default)");
  a_FCSI_PLL0PUP0_pup_vvbgen_lpath_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL0PUP0_pup_vvbgen_lpath->connectAttribute (a_FCSI_PLL0PUP0_pup_vvbgen_lpath_0_0);

  RField* f_FCSI_PLL0PUP0_pup_opamp_lpath = new RField;
  f_FCSI_PLL0PUP0_pup_opamp_lpath->setInstName ("pup_opamp_lpath");
  f_FCSI_PLL0PUP0_pup_opamp_lpath->setLongName ("PUP OPAMP LPATH");
  f_FCSI_PLL0PUP0_pup_opamp_lpath->setDescription ("Power up for OpAmps in integrating path of LPF block");
  f_FCSI_PLL0PUP0_pup_opamp_lpath->setDataWidth (1);
  f_FCSI_PLL0PUP0_pup_opamp_lpath->setResetVal ("1'b0");
  f_FCSI_PLL0PUP0_pup_opamp_lpath->setAccProp (AccProp::RW);
  r_FCSI_PLL0PUP0->connectRField (f_FCSI_PLL0PUP0_pup_opamp_lpath, 7);

  Attribute* a_FCSI_PLL0PUP0_pup_opamp_lpath_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0PUP0_pup_opamp_lpath_0_0->setInstName ("0");
  a_FCSI_PLL0PUP0_pup_opamp_lpath_0_0->setLongName ("");
  a_FCSI_PLL0PUP0_pup_opamp_lpath_0_0->setDescription ("");
  a_FCSI_PLL0PUP0_pup_opamp_lpath_0_0->addItem("1", "1'b1", "enable (default)");
  a_FCSI_PLL0PUP0_pup_opamp_lpath_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL0PUP0_pup_opamp_lpath->connectAttribute (a_FCSI_PLL0PUP0_pup_opamp_lpath_0_0);

  RField* f_FCSI_PLL0PUP0_pup_cplp_fbias = new RField;
  f_FCSI_PLL0PUP0_pup_cplp_fbias->setInstName ("pup_cplp_fbias");
  f_FCSI_PLL0PUP0_pup_cplp_fbias->setLongName ("PUP CPLP FBIAS");
  f_FCSI_PLL0PUP0_pup_cplp_fbias->setDescription ("Power up for PDCPLPF Bias circuitry");
  f_FCSI_PLL0PUP0_pup_cplp_fbias->setDataWidth (1);
  f_FCSI_PLL0PUP0_pup_cplp_fbias->setResetVal ("1'b0");
  f_FCSI_PLL0PUP0_pup_cplp_fbias->setAccProp (AccProp::RW);
  r_FCSI_PLL0PUP0->connectRField (f_FCSI_PLL0PUP0_pup_cplp_fbias, 8);

  Attribute* a_FCSI_PLL0PUP0_pup_cplp_fbias_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0PUP0_pup_cplp_fbias_0_0->setInstName ("0");
  a_FCSI_PLL0PUP0_pup_cplp_fbias_0_0->setLongName ("");
  a_FCSI_PLL0PUP0_pup_cplp_fbias_0_0->setDescription ("");
  a_FCSI_PLL0PUP0_pup_cplp_fbias_0_0->addItem("1", "1'b1", "enable (default)");
  a_FCSI_PLL0PUP0_pup_cplp_fbias_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL0PUP0_pup_cplp_fbias->connectAttribute (a_FCSI_PLL0PUP0_pup_cplp_fbias_0_0);

  RField* f_FCSI_PLL0PUP0_bypass_bg_ok = new RField;
  f_FCSI_PLL0PUP0_bypass_bg_ok->setInstName ("bypass_bg_ok");
  f_FCSI_PLL0PUP0_bypass_bg_ok->setLongName ("BYPASS BANDGAPE-OK");
  f_FCSI_PLL0PUP0_bypass_bg_ok->setDescription ("Bypass internal bandgape-OK-signal (required for enabling the regulators)");
  f_FCSI_PLL0PUP0_bypass_bg_ok->setDataWidth (1);
  f_FCSI_PLL0PUP0_bypass_bg_ok->setResetVal ("1'b0");
  f_FCSI_PLL0PUP0_bypass_bg_ok->setAccProp (AccProp::RW);
  r_FCSI_PLL0PUP0->connectRField (f_FCSI_PLL0PUP0_bypass_bg_ok, 9);

  Attribute* a_FCSI_PLL0PUP0_bypass_bg_ok_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0PUP0_bypass_bg_ok_0_0->setInstName ("0");
  a_FCSI_PLL0PUP0_bypass_bg_ok_0_0->setLongName ("");
  a_FCSI_PLL0PUP0_bypass_bg_ok_0_0->setDescription ("");
  a_FCSI_PLL0PUP0_bypass_bg_ok_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_PLL0PUP0_bypass_bg_ok_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL0PUP0_bypass_bg_ok->connectAttribute (a_FCSI_PLL0PUP0_bypass_bg_ok_0_0);

  RField* f_FCSI_PLL0PUP0_fpup_rfpll = new RField;
  f_FCSI_PLL0PUP0_fpup_rfpll->setInstName ("fpup_rfpll");
  f_FCSI_PLL0PUP0_fpup_rfpll->setLongName ("FORCED PUP GLOBAL");
  f_FCSI_PLL0PUP0_fpup_rfpll->setDescription ("Global force power up for RFPLL blocks (higher priority over RFPLL digital power up sequence)");
  f_FCSI_PLL0PUP0_fpup_rfpll->setDataWidth (1);
  f_FCSI_PLL0PUP0_fpup_rfpll->setResetVal ("1'b0");
  f_FCSI_PLL0PUP0_fpup_rfpll->setAccProp (AccProp::RW);
  r_FCSI_PLL0PUP0->connectRField (f_FCSI_PLL0PUP0_fpup_rfpll, 10);

  Attribute* a_FCSI_PLL0PUP0_fpup_rfpll_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0PUP0_fpup_rfpll_0_0->setInstName ("0");
  a_FCSI_PLL0PUP0_fpup_rfpll_0_0->setLongName ("");
  a_FCSI_PLL0PUP0_fpup_rfpll_0_0->setDescription ("");
  a_FCSI_PLL0PUP0_fpup_rfpll_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_PLL0PUP0_fpup_rfpll_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL0PUP0_fpup_rfpll->connectAttribute (a_FCSI_PLL0PUP0_fpup_rfpll_0_0);

  RField* f_FCSI_PLL0PUP0_pup_ldo_ff = new RField;
  f_FCSI_PLL0PUP0_pup_ldo_ff->setInstName ("pup_ldo_ff");
  f_FCSI_PLL0PUP0_pup_ldo_ff->setLongName ("PUP LDO FF");
  f_FCSI_PLL0PUP0_pup_ldo_ff->setDescription ("Power up regulator for feed-forward path - PCCP, LPF");
  f_FCSI_PLL0PUP0_pup_ldo_ff->setDataWidth (1);
  f_FCSI_PLL0PUP0_pup_ldo_ff->setResetVal ("1'b0");
  f_FCSI_PLL0PUP0_pup_ldo_ff->setAccProp (AccProp::RW);
  r_FCSI_PLL0PUP0->connectRField (f_FCSI_PLL0PUP0_pup_ldo_ff, 11);

  Attribute* a_FCSI_PLL0PUP0_pup_ldo_ff_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0PUP0_pup_ldo_ff_0_0->setInstName ("0");
  a_FCSI_PLL0PUP0_pup_ldo_ff_0_0->setLongName ("");
  a_FCSI_PLL0PUP0_pup_ldo_ff_0_0->setDescription ("");
  a_FCSI_PLL0PUP0_pup_ldo_ff_0_0->addItem("1", "1'b1", "enable (default)");
  a_FCSI_PLL0PUP0_pup_ldo_ff_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL0PUP0_pup_ldo_ff->connectAttribute (a_FCSI_PLL0PUP0_pup_ldo_ff_0_0);

  RField* f_FCSI_PLL0PUP0_pup_ldo_fb = new RField;
  f_FCSI_PLL0PUP0_pup_ldo_fb->setInstName ("pup_ldo_fb");
  f_FCSI_PLL0PUP0_pup_ldo_fb->setLongName ("PUP LDO FB");
  f_FCSI_PLL0PUP0_pup_ldo_fb->setDescription ("Power up regulator for feed-back path - DIVN/FCAL");
  f_FCSI_PLL0PUP0_pup_ldo_fb->setDataWidth (1);
  f_FCSI_PLL0PUP0_pup_ldo_fb->setResetVal ("1'b0");
  f_FCSI_PLL0PUP0_pup_ldo_fb->setAccProp (AccProp::RW);
  r_FCSI_PLL0PUP0->connectRField (f_FCSI_PLL0PUP0_pup_ldo_fb, 12);

  Attribute* a_FCSI_PLL0PUP0_pup_ldo_fb_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0PUP0_pup_ldo_fb_0_0->setInstName ("0");
  a_FCSI_PLL0PUP0_pup_ldo_fb_0_0->setLongName ("");
  a_FCSI_PLL0PUP0_pup_ldo_fb_0_0->setDescription ("");
  a_FCSI_PLL0PUP0_pup_ldo_fb_0_0->addItem("1", "1'b1", "enable (default)");
  a_FCSI_PLL0PUP0_pup_ldo_fb_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL0PUP0_pup_ldo_fb->connectAttribute (a_FCSI_PLL0PUP0_pup_ldo_fb_0_0);

  RField* f_FCSI_PLL0PUP0_pup_ldo_xo = new RField;
  f_FCSI_PLL0PUP0_pup_ldo_xo->setInstName ("pup_ldo_xo");
  f_FCSI_PLL0PUP0_pup_ldo_xo->setLongName ("PUP LDO XO");
  f_FCSI_PLL0PUP0_pup_ldo_xo->setDescription ("Power up the clock path in reference block");
  f_FCSI_PLL0PUP0_pup_ldo_xo->setDataWidth (1);
  f_FCSI_PLL0PUP0_pup_ldo_xo->setResetVal ("1'b0");
  f_FCSI_PLL0PUP0_pup_ldo_xo->setAccProp (AccProp::RW);
  r_FCSI_PLL0PUP0->connectRField (f_FCSI_PLL0PUP0_pup_ldo_xo, 13);

  Attribute* a_FCSI_PLL0PUP0_pup_ldo_xo_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0PUP0_pup_ldo_xo_0_0->setInstName ("0");
  a_FCSI_PLL0PUP0_pup_ldo_xo_0_0->setLongName ("");
  a_FCSI_PLL0PUP0_pup_ldo_xo_0_0->setDescription ("");
  a_FCSI_PLL0PUP0_pup_ldo_xo_0_0->addItem("1", "1'b1", "enable (default)");
  a_FCSI_PLL0PUP0_pup_ldo_xo_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL0PUP0_pup_ldo_xo->connectAttribute (a_FCSI_PLL0PUP0_pup_ldo_xo_0_0);

  RField* f_FCSI_PLL0PUP0_pup_ldo_dig = new RField;
  f_FCSI_PLL0PUP0_pup_ldo_dig->setInstName ("pup_ldo_dig");
  f_FCSI_PLL0PUP0_pup_ldo_dig->setLongName ("PUP LDO DIG");
  f_FCSI_PLL0PUP0_pup_ldo_dig->setDescription ("Power up 1.2V LDOs of DIG");
  f_FCSI_PLL0PUP0_pup_ldo_dig->setDataWidth (1);
  f_FCSI_PLL0PUP0_pup_ldo_dig->setResetVal ("1'b0");
  f_FCSI_PLL0PUP0_pup_ldo_dig->setAccProp (AccProp::RW);
  r_FCSI_PLL0PUP0->connectRField (f_FCSI_PLL0PUP0_pup_ldo_dig, 14);

  Attribute* a_FCSI_PLL0PUP0_pup_ldo_dig_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0PUP0_pup_ldo_dig_0_0->setInstName ("0");
  a_FCSI_PLL0PUP0_pup_ldo_dig_0_0->setLongName ("");
  a_FCSI_PLL0PUP0_pup_ldo_dig_0_0->setDescription ("");
  a_FCSI_PLL0PUP0_pup_ldo_dig_0_0->addItem("1", "1'b1", "enable (default)");
  a_FCSI_PLL0PUP0_pup_ldo_dig_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL0PUP0_pup_ldo_dig->connectAttribute (a_FCSI_PLL0PUP0_pup_ldo_dig_0_0);

  RField* f_FCSI_PLL0PUP0_pup_ldo_vco = new RField;
  f_FCSI_PLL0PUP0_pup_ldo_vco->setInstName ("pup_ldo_vco");
  f_FCSI_PLL0PUP0_pup_ldo_vco->setLongName ("PUP LDO VCO");
  f_FCSI_PLL0PUP0_pup_ldo_vco->setDescription ("Power up VCO LDO");
  f_FCSI_PLL0PUP0_pup_ldo_vco->setDataWidth (1);
  f_FCSI_PLL0PUP0_pup_ldo_vco->setResetVal ("1'b0");
  f_FCSI_PLL0PUP0_pup_ldo_vco->setAccProp (AccProp::RW);
  r_FCSI_PLL0PUP0->connectRField (f_FCSI_PLL0PUP0_pup_ldo_vco, 15);

  Attribute* a_FCSI_PLL0PUP0_pup_ldo_vco_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0PUP0_pup_ldo_vco_0_0->setInstName ("0");
  a_FCSI_PLL0PUP0_pup_ldo_vco_0_0->setLongName ("");
  a_FCSI_PLL0PUP0_pup_ldo_vco_0_0->setDescription ("");
  a_FCSI_PLL0PUP0_pup_ldo_vco_0_0->addItem("1", "1'b1", "enable (default)");
  a_FCSI_PLL0PUP0_pup_ldo_vco_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL0PUP0_pup_ldo_vco->connectAttribute (a_FCSI_PLL0PUP0_pup_ldo_vco_0_0);

  Register* r_FCSI_PLL0PMU0 = new Register;
  r_FCSI_PLL0PMU0->setInstName ("PLL0PMU0");
  r_FCSI_PLL0PMU0->setLongName ("PLL0 PMU CENTRAL");
  r_FCSI_PLL0PMU0->setDescription ("FCSI-LDO1V2");
  r_FCSI_PLL0PMU0->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_PLL0PMU0, 0x00000001);

  RField* f_FCSI_PLL0PMU0_diag_disable = new RField;
  f_FCSI_PLL0PMU0_diag_disable->setInstName ("diag_disable");
  f_FCSI_PLL0PMU0_diag_disable->setLongName ("DIAG DISABLE");
  f_FCSI_PLL0PMU0_diag_disable->setDescription ("DIAG disable (diagnostic bus in PLL)");
  f_FCSI_PLL0PMU0_diag_disable->setDataWidth (1);
  f_FCSI_PLL0PMU0_diag_disable->setResetVal ("1'b1");
  f_FCSI_PLL0PMU0_diag_disable->setAccProp (AccProp::RW);
  r_FCSI_PLL0PMU0->connectRField (f_FCSI_PLL0PMU0_diag_disable, 0);

  Attribute* a_FCSI_PLL0PMU0_diag_disable_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0PMU0_diag_disable_0_0->setInstName ("0");
  a_FCSI_PLL0PMU0_diag_disable_0_0->setLongName ("");
  a_FCSI_PLL0PMU0_diag_disable_0_0->setDescription ("");
  a_FCSI_PLL0PMU0_diag_disable_0_0->addItem("1", "1'b1", "disable");
  a_FCSI_PLL0PMU0_diag_disable_0_0->addItem("0", "1'b0", "enable");
  f_FCSI_PLL0PMU0_diag_disable->connectAttribute (a_FCSI_PLL0PMU0_diag_disable_0_0);

  RField* f_FCSI_PLL0PMU0_vcoreg_intref_sel = new RField;
  f_FCSI_PLL0PMU0_vcoreg_intref_sel->setInstName ("vcoreg_intref_sel");
  f_FCSI_PLL0PMU0_vcoreg_intref_sel->setLongName ("VCOREG INTREF SEL");
  f_FCSI_PLL0PMU0_vcoreg_intref_sel->setDescription ("VCOREG internal reference voltage selection");
  f_FCSI_PLL0PMU0_vcoreg_intref_sel->setDataWidth (1);
  f_FCSI_PLL0PMU0_vcoreg_intref_sel->setResetVal ("1'b0");
  f_FCSI_PLL0PMU0_vcoreg_intref_sel->setAccProp (AccProp::RW);
  r_FCSI_PLL0PMU0->connectRField (f_FCSI_PLL0PMU0_vcoreg_intref_sel, 1);

  Attribute* a_FCSI_PLL0PMU0_vcoreg_intref_sel_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0PMU0_vcoreg_intref_sel_0_0->setInstName ("0");
  a_FCSI_PLL0PMU0_vcoreg_intref_sel_0_0->setLongName ("");
  a_FCSI_PLL0PMU0_vcoreg_intref_sel_0_0->setDescription ("");
  a_FCSI_PLL0PMU0_vcoreg_intref_sel_0_0->addItem("1", "1'b1", "Internal reference (default)");
  a_FCSI_PLL0PMU0_vcoreg_intref_sel_0_0->addItem("0", "1'b0", "BG reference");
  f_FCSI_PLL0PMU0_vcoreg_intref_sel->connectAttribute (a_FCSI_PLL0PMU0_vcoreg_intref_sel_0_0);

  RField* f_FCSI_PLL0PMU0_reg_lo_sel = new RField;
  f_FCSI_PLL0PMU0_reg_lo_sel->setInstName ("reg_lo_sel");
  f_FCSI_PLL0PMU0_reg_lo_sel->setLongName ("REG LO SEL");
  f_FCSI_PLL0PMU0_reg_lo_sel->setDescription ("Bump bits for LOPATH LDO");
  f_FCSI_PLL0PMU0_reg_lo_sel->setDataWidth (3);
  f_FCSI_PLL0PMU0_reg_lo_sel->setResetVal ("3'b000");
  f_FCSI_PLL0PMU0_reg_lo_sel->setAccProp (AccProp::RW);
  r_FCSI_PLL0PMU0->connectRField (f_FCSI_PLL0PMU0_reg_lo_sel, 2);

  Attribute* a_FCSI_PLL0PMU0_reg_lo_sel_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0PMU0_reg_lo_sel_0_0->setInstName ("0");
  a_FCSI_PLL0PMU0_reg_lo_sel_0_0->setLongName ("");
  a_FCSI_PLL0PMU0_reg_lo_sel_0_0->setDescription ("");
  a_FCSI_PLL0PMU0_reg_lo_sel_0_0->addItem("0", "3'b000", "1.193");
  a_FCSI_PLL0PMU0_reg_lo_sel_0_0->addItem("1", "3'b001", "1.225");
  a_FCSI_PLL0PMU0_reg_lo_sel_0_0->addItem("2", "3'b010", "1.258 (2G mode)");
  a_FCSI_PLL0PMU0_reg_lo_sel_0_0->addItem("3", "3'b011", "1.293");
  a_FCSI_PLL0PMU0_reg_lo_sel_0_0->addItem("4", "3'b100", "1.331");
  a_FCSI_PLL0PMU0_reg_lo_sel_0_0->addItem("5", "3'b101", "1.370 (HP/RP mode)");
  a_FCSI_PLL0PMU0_reg_lo_sel_0_0->addItem("6", "3'b110", "1.412");
  a_FCSI_PLL0PMU0_reg_lo_sel_0_0->addItem("7", "3'b111", "1.456");
  f_FCSI_PLL0PMU0_reg_lo_sel->connectAttribute (a_FCSI_PLL0PMU0_reg_lo_sel_0_0);

  RField* f_FCSI_PLL0PMU0_ldo_dig_sel = new RField;
  f_FCSI_PLL0PMU0_ldo_dig_sel->setInstName ("ldo_dig_sel");
  f_FCSI_PLL0PMU0_ldo_dig_sel->setLongName ("LDO DIG SEL");
  f_FCSI_PLL0PMU0_ldo_dig_sel->setDescription ("Bump bits for DIGREG and CPREG");
  f_FCSI_PLL0PMU0_ldo_dig_sel->setDataWidth (3);
  f_FCSI_PLL0PMU0_ldo_dig_sel->setResetVal ("3'b000");
  f_FCSI_PLL0PMU0_ldo_dig_sel->setAccProp (AccProp::RW);
  r_FCSI_PLL0PMU0->connectRField (f_FCSI_PLL0PMU0_ldo_dig_sel, 5);

  Attribute* a_FCSI_PLL0PMU0_ldo_dig_sel_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0PMU0_ldo_dig_sel_0_0->setInstName ("0");
  a_FCSI_PLL0PMU0_ldo_dig_sel_0_0->setLongName ("");
  a_FCSI_PLL0PMU0_ldo_dig_sel_0_0->setDescription ("");
  a_FCSI_PLL0PMU0_ldo_dig_sel_0_0->addItem("0", "3'b000", "1.193");
  a_FCSI_PLL0PMU0_ldo_dig_sel_0_0->addItem("1", "3'b001", "1.217");
  a_FCSI_PLL0PMU0_ldo_dig_sel_0_0->addItem("2", "3'b010", "1.241");
  a_FCSI_PLL0PMU0_ldo_dig_sel_0_0->addItem("3", "3'b011", "1.267");
  a_FCSI_PLL0PMU0_ldo_dig_sel_0_0->addItem("4", "3'b100", "1.293 (default)");
  a_FCSI_PLL0PMU0_ldo_dig_sel_0_0->addItem("5", "3'b101", "1.321");
  a_FCSI_PLL0PMU0_ldo_dig_sel_0_0->addItem("6", "3'b110", "1.350");
  a_FCSI_PLL0PMU0_ldo_dig_sel_0_0->addItem("7", "3'b111", "1.380");
  f_FCSI_PLL0PMU0_ldo_dig_sel->connectAttribute (a_FCSI_PLL0PMU0_ldo_dig_sel_0_0);

  RField* f_FCSI_PLL0PMU0_bump_ibias = new RField;
  f_FCSI_PLL0PMU0_bump_ibias->setInstName ("bump_ibias");
  f_FCSI_PLL0PMU0_bump_ibias->setLongName ("BUMP IBIAS");
  f_FCSI_PLL0PMU0_bump_ibias->setDescription ("Bump bits for central I-Bias block");
  f_FCSI_PLL0PMU0_bump_ibias->setDataWidth (2);
  f_FCSI_PLL0PMU0_bump_ibias->setResetVal ("2'b00");
  f_FCSI_PLL0PMU0_bump_ibias->setAccProp (AccProp::RW);
  r_FCSI_PLL0PMU0->connectRField (f_FCSI_PLL0PMU0_bump_ibias, 8);

  Attribute* a_FCSI_PLL0PMU0_bump_ibias_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0PMU0_bump_ibias_0_0->setInstName ("0");
  a_FCSI_PLL0PMU0_bump_ibias_0_0->setLongName ("");
  a_FCSI_PLL0PMU0_bump_ibias_0_0->setDescription ("");
  a_FCSI_PLL0PMU0_bump_ibias_0_0->addItem("0", "2'b00", "10u");
  a_FCSI_PLL0PMU0_bump_ibias_0_0->addItem("1", "2'b01", " 9u");
  a_FCSI_PLL0PMU0_bump_ibias_0_0->addItem("2", "2'b10", "11u");
  a_FCSI_PLL0PMU0_bump_ibias_0_0->addItem("3", "2'b11", "12u");
  f_FCSI_PLL0PMU0_bump_ibias->connectAttribute (a_FCSI_PLL0PMU0_bump_ibias_0_0);

  RField* f_FCSI_PLL0PMU0_ldo_vco_sel = new RField;
  f_FCSI_PLL0PMU0_ldo_vco_sel->setInstName ("ldo_vco_sel");
  f_FCSI_PLL0PMU0_ldo_vco_sel->setLongName ("LDO VCO SEL");
  f_FCSI_PLL0PMU0_ldo_vco_sel->setDescription ("Bump bits for VCO LDO");
  f_FCSI_PLL0PMU0_ldo_vco_sel->setDataWidth (3);
  f_FCSI_PLL0PMU0_ldo_vco_sel->setResetVal ("3'b000");
  f_FCSI_PLL0PMU0_ldo_vco_sel->setAccProp (AccProp::RW);
  r_FCSI_PLL0PMU0->connectRField (f_FCSI_PLL0PMU0_ldo_vco_sel, 10);

  Attribute* a_FCSI_PLL0PMU0_ldo_vco_sel_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0PMU0_ldo_vco_sel_0_0->setInstName ("0");
  a_FCSI_PLL0PMU0_ldo_vco_sel_0_0->setLongName ("");
  a_FCSI_PLL0PMU0_ldo_vco_sel_0_0->setDescription ("");
  a_FCSI_PLL0PMU0_ldo_vco_sel_0_0->addItem("0", "3'b000", "1.695 (HP mode)");
  a_FCSI_PLL0PMU0_ldo_vco_sel_0_0->addItem("1", "3'b001", "1.743");
  a_FCSI_PLL0PMU0_ldo_vco_sel_0_0->addItem("2", "3'b010", "1.850");
  a_FCSI_PLL0PMU0_ldo_vco_sel_0_0->addItem("3", "3'b011", "1.908");
  a_FCSI_PLL0PMU0_ldo_vco_sel_0_0->addItem("4", "3'b100", "1.417 (RP mode)");
  a_FCSI_PLL0PMU0_ldo_vco_sel_0_0->addItem("5", "3'b101", "1.487");
  a_FCSI_PLL0PMU0_ldo_vco_sel_0_0->addItem("6", "3'b110", "1.563");
  a_FCSI_PLL0PMU0_ldo_vco_sel_0_0->addItem("7", "3'b111", "1.648");
  f_FCSI_PLL0PMU0_ldo_vco_sel->connectAttribute (a_FCSI_PLL0PMU0_ldo_vco_sel_0_0);

  RField* f_FCSI_PLL0PMU0_bg_sel = new RField;
  f_FCSI_PLL0PMU0_bg_sel->setInstName ("bg_sel");
  f_FCSI_PLL0PMU0_bg_sel->setLongName ("BG SEL");
  f_FCSI_PLL0PMU0_bg_sel->setDescription ("Bump bits for Bandgape Voltage");
  f_FCSI_PLL0PMU0_bg_sel->setDataWidth (3);
  f_FCSI_PLL0PMU0_bg_sel->setResetVal ("3'b000");
  f_FCSI_PLL0PMU0_bg_sel->setAccProp (AccProp::RW);
  r_FCSI_PLL0PMU0->connectRField (f_FCSI_PLL0PMU0_bg_sel, 13);

  Attribute* a_FCSI_PLL0PMU0_bg_sel_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0PMU0_bg_sel_0_0->setInstName ("0");
  a_FCSI_PLL0PMU0_bg_sel_0_0->setLongName ("");
  a_FCSI_PLL0PMU0_bg_sel_0_0->setDescription ("");
  a_FCSI_PLL0PMU0_bg_sel_0_0->addItem("0", "3'b000", "1.193");
  a_FCSI_PLL0PMU0_bg_sel_0_0->addItem("1", "3'b001", "1.201");
  a_FCSI_PLL0PMU0_bg_sel_0_0->addItem("2", "3'b010", "1.210");
  a_FCSI_PLL0PMU0_bg_sel_0_0->addItem("3", "3'b011", "1.219");
  a_FCSI_PLL0PMU0_bg_sel_0_0->addItem("4", "3'b100", "1.227");
  a_FCSI_PLL0PMU0_bg_sel_0_0->addItem("5", "3'b101", "1.185");
  a_FCSI_PLL0PMU0_bg_sel_0_0->addItem("6", "3'b110", "1.176");
  a_FCSI_PLL0PMU0_bg_sel_0_0->addItem("7", "3'b111", "1.172");
  f_FCSI_PLL0PMU0_bg_sel->connectAttribute (a_FCSI_PLL0PMU0_bg_sel_0_0);

  Register* r_FCSI_PLL0PMU1 = new Register;
  r_FCSI_PLL0PMU1->setInstName ("PLL0PMU1");
  r_FCSI_PLL0PMU1->setLongName ("PLL0 PMU DIAG CONTROL");
  r_FCSI_PLL0PMU1->setDescription ("FCSI-LDO1V2");
  r_FCSI_PLL0PMU1->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_PLL0PMU1, 0x00000002);

  RField* f_FCSI_PLL0PMU1_diag_sel = new RField;
  f_FCSI_PLL0PMU1_diag_sel->setInstName ("diag_sel");
  f_FCSI_PLL0PMU1_diag_sel->setLongName ("DIAG SEL");
  f_FCSI_PLL0PMU1_diag_sel->setDescription ("Analog diagnostic module select");
  f_FCSI_PLL0PMU1_diag_sel->setDataWidth (4);
  f_FCSI_PLL0PMU1_diag_sel->setResetVal ("4'b0000");
  f_FCSI_PLL0PMU1_diag_sel->setAccProp (AccProp::RW);
  r_FCSI_PLL0PMU1->connectRField (f_FCSI_PLL0PMU1_diag_sel, 0);

  Attribute* a_FCSI_PLL0PMU1_diag_sel_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0PMU1_diag_sel_0_0->setInstName ("0");
  a_FCSI_PLL0PMU1_diag_sel_0_0->setLongName ("");
  a_FCSI_PLL0PMU1_diag_sel_0_0->setDescription ("");
  a_FCSI_PLL0PMU1_diag_sel_0_0->addItem("0", "4'b0000", "Not used");
  a_FCSI_PLL0PMU1_diag_sel_0_0->addItem("1", "4'b0001", "BG");
  a_FCSI_PLL0PMU1_diag_sel_0_0->addItem("2", "4'b0010", "DIG REG");
  a_FCSI_PLL0PMU1_diag_sel_0_0->addItem("3", "4'b0011", "LPF REG");
  a_FCSI_PLL0PMU1_diag_sel_0_0->addItem("4", "4'b0100", "XO REG");
  a_FCSI_PLL0PMU1_diag_sel_0_0->addItem("5", "4'b0101", "FB REG");
  a_FCSI_PLL0PMU1_diag_sel_0_0->addItem("6", "4'b0110", "CP REG");
  a_FCSI_PLL0PMU1_diag_sel_0_0->addItem("7", "4'b0111", "VCO REG");
  a_FCSI_PLL0PMU1_diag_sel_0_0->addItem("8", "4'b1000", "LOREG");
  a_FCSI_PLL0PMU1_diag_sel_0_0->addItem("9", "4'b1001", "LPF_IPATH");
  a_FCSI_PLL0PMU1_diag_sel_0_0->addItem("10", "4'b1010", "LPF_PPATH");
  a_FCSI_PLL0PMU1_diag_sel_0_0->addItem("11", "4'b1011", "SHUNT REG");
  a_FCSI_PLL0PMU1_diag_sel_0_0->addItem("12", "4'b1100", "---");
  a_FCSI_PLL0PMU1_diag_sel_0_0->addItem("13", "4'b1101", "PDREG");
  a_FCSI_PLL0PMU1_diag_sel_0_0->addItem("14", "4'b1110", "---");
  a_FCSI_PLL0PMU1_diag_sel_0_0->addItem("15", "4'b1111", "---");
  f_FCSI_PLL0PMU1_diag_sel->connectAttribute (a_FCSI_PLL0PMU1_diag_sel_0_0);

  RField* f_FCSI_PLL0PMU1_diag_code = new RField;
  f_FCSI_PLL0PMU1_diag_code->setInstName ("diag_code");
  f_FCSI_PLL0PMU1_diag_code->setLongName ("DIAG CODE");
  f_FCSI_PLL0PMU1_diag_code->setDescription ("Analog diagnostic code value");
  f_FCSI_PLL0PMU1_diag_code->setDataWidth (3);
  f_FCSI_PLL0PMU1_diag_code->setResetVal ("3'b000");
  f_FCSI_PLL0PMU1_diag_code->setAccProp (AccProp::RW);
  r_FCSI_PLL0PMU1->connectRField (f_FCSI_PLL0PMU1_diag_code, 4);

  RField* f_FCSI_PLL0PMU1_ldo_xo_sel = new RField;
  f_FCSI_PLL0PMU1_ldo_xo_sel->setInstName ("ldo_xo_sel");
  f_FCSI_PLL0PMU1_ldo_xo_sel->setLongName ("LDO XO SEL");
  f_FCSI_PLL0PMU1_ldo_xo_sel->setDescription ("Program output voltage for XOREG and PFDREG");
  f_FCSI_PLL0PMU1_ldo_xo_sel->setDataWidth (3);
  f_FCSI_PLL0PMU1_ldo_xo_sel->setResetVal ("3'b000");
  f_FCSI_PLL0PMU1_ldo_xo_sel->setAccProp (AccProp::RW);
  r_FCSI_PLL0PMU1->connectRField (f_FCSI_PLL0PMU1_ldo_xo_sel, 7);

  Attribute* a_FCSI_PLL0PMU1_ldo_xo_sel_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0PMU1_ldo_xo_sel_0_0->setInstName ("0");
  a_FCSI_PLL0PMU1_ldo_xo_sel_0_0->setLongName ("");
  a_FCSI_PLL0PMU1_ldo_xo_sel_0_0->setDescription ("");
  a_FCSI_PLL0PMU1_ldo_xo_sel_0_0->addItem("0", "3'b000", "1.193");
  a_FCSI_PLL0PMU1_ldo_xo_sel_0_0->addItem("1", "3'b001", "1.217");
  a_FCSI_PLL0PMU1_ldo_xo_sel_0_0->addItem("2", "3'b010", "1.241");
  a_FCSI_PLL0PMU1_ldo_xo_sel_0_0->addItem("3", "3'b011", "1.267");
  a_FCSI_PLL0PMU1_ldo_xo_sel_0_0->addItem("4", "3'b100", "1.293 (default)");
  a_FCSI_PLL0PMU1_ldo_xo_sel_0_0->addItem("5", "3'b101", "1.321");
  a_FCSI_PLL0PMU1_ldo_xo_sel_0_0->addItem("6", "3'b110", "1.350");
  a_FCSI_PLL0PMU1_ldo_xo_sel_0_0->addItem("7", "3'b111", "1.380");
  f_FCSI_PLL0PMU1_ldo_xo_sel->connectAttribute (a_FCSI_PLL0PMU1_ldo_xo_sel_0_0);

  RField* f_FCSI_PLL0PMU1_ldo_resync_sel = new RField;
  f_FCSI_PLL0PMU1_ldo_resync_sel->setInstName ("ldo_resync_sel");
  f_FCSI_PLL0PMU1_ldo_resync_sel->setLongName ("LDO RESYNC SEL");
  f_FCSI_PLL0PMU1_ldo_resync_sel->setDescription ("Program output voltage fo DIVN, FCAL and RESYNC");
  f_FCSI_PLL0PMU1_ldo_resync_sel->setDataWidth (3);
  f_FCSI_PLL0PMU1_ldo_resync_sel->setResetVal ("3'b000");
  f_FCSI_PLL0PMU1_ldo_resync_sel->setAccProp (AccProp::RW);
  r_FCSI_PLL0PMU1->connectRField (f_FCSI_PLL0PMU1_ldo_resync_sel, 10);

  Attribute* a_FCSI_PLL0PMU1_ldo_resync_sel_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0PMU1_ldo_resync_sel_0_0->setInstName ("0");
  a_FCSI_PLL0PMU1_ldo_resync_sel_0_0->setLongName ("");
  a_FCSI_PLL0PMU1_ldo_resync_sel_0_0->setDescription ("");
  a_FCSI_PLL0PMU1_ldo_resync_sel_0_0->addItem("0", "3'b000", "1.193");
  a_FCSI_PLL0PMU1_ldo_resync_sel_0_0->addItem("1", "3'b001", "1.217");
  a_FCSI_PLL0PMU1_ldo_resync_sel_0_0->addItem("2", "3'b010", "1.241");
  a_FCSI_PLL0PMU1_ldo_resync_sel_0_0->addItem("3", "3'b011", "1.267");
  a_FCSI_PLL0PMU1_ldo_resync_sel_0_0->addItem("4", "3'b100", "1.293 (default)");
  a_FCSI_PLL0PMU1_ldo_resync_sel_0_0->addItem("5", "3'b101", "1.321");
  a_FCSI_PLL0PMU1_ldo_resync_sel_0_0->addItem("6", "3'b110", "1.350");
  a_FCSI_PLL0PMU1_ldo_resync_sel_0_0->addItem("7", "3'b111", "1.380");
  f_FCSI_PLL0PMU1_ldo_resync_sel->connectAttribute (a_FCSI_PLL0PMU1_ldo_resync_sel_0_0);

  RField* f_FCSI_PLL0PMU1_ldo_ff_sel = new RField;
  f_FCSI_PLL0PMU1_ldo_ff_sel->setInstName ("ldo_ff_sel");
  f_FCSI_PLL0PMU1_ldo_ff_sel->setLongName ("LDO FF SEL");
  f_FCSI_PLL0PMU1_ldo_ff_sel->setDescription ("Program output voltage of LPFREG");
  f_FCSI_PLL0PMU1_ldo_ff_sel->setDataWidth (3);
  f_FCSI_PLL0PMU1_ldo_ff_sel->setResetVal ("3'b000");
  f_FCSI_PLL0PMU1_ldo_ff_sel->setAccProp (AccProp::RW);
  r_FCSI_PLL0PMU1->connectRField (f_FCSI_PLL0PMU1_ldo_ff_sel, 13);

  Attribute* a_FCSI_PLL0PMU1_ldo_ff_sel_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0PMU1_ldo_ff_sel_0_0->setInstName ("0");
  a_FCSI_PLL0PMU1_ldo_ff_sel_0_0->setLongName ("");
  a_FCSI_PLL0PMU1_ldo_ff_sel_0_0->setDescription ("");
  a_FCSI_PLL0PMU1_ldo_ff_sel_0_0->addItem("0", "3'b000", "1.572");
  a_FCSI_PLL0PMU1_ldo_ff_sel_0_0->addItem("1", "3'b001", "1.603");
  a_FCSI_PLL0PMU1_ldo_ff_sel_0_0->addItem("2", "3'b010", "1.636");
  a_FCSI_PLL0PMU1_ldo_ff_sel_0_0->addItem("3", "3'b011", "1.669");
  a_FCSI_PLL0PMU1_ldo_ff_sel_0_0->addItem("4", "3'b100", "1.704 (default)");
  a_FCSI_PLL0PMU1_ldo_ff_sel_0_0->addItem("5", "3'b101", "1.741");
  a_FCSI_PLL0PMU1_ldo_ff_sel_0_0->addItem("6", "3'b110", "1.779");
  a_FCSI_PLL0PMU1_ldo_ff_sel_0_0->addItem("7", "3'b111", "1.819");
  f_FCSI_PLL0PMU1_ldo_ff_sel->connectAttribute (a_FCSI_PLL0PMU1_ldo_ff_sel_0_0);

  Register* r_FCSI_PLL0PUP1 = new Register;
  r_FCSI_PLL0PUP1->setInstName ("PLL0PUP1");
  r_FCSI_PLL0PUP1->setLongName ("PLL0 POWER UP LOCAL");
  r_FCSI_PLL0PUP1->setDescription ("PLL0-LDO1V2");
  r_FCSI_PLL0PUP1->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_PLL0PUP1, 0x00000003);

  RField* f_FCSI_PLL0PUP1_rfpll_resetn = new RField;
  f_FCSI_PLL0PUP1_rfpll_resetn->setInstName ("rfpll_resetn");
  f_FCSI_PLL0PUP1_rfpll_resetn->setLongName ("RFPLL RESETN");
  f_FCSI_PLL0PUP1_rfpll_resetn->setDescription ("Reset release starts PLL operation (negative logic 0->1)");
  f_FCSI_PLL0PUP1_rfpll_resetn->setDataWidth (1);
  f_FCSI_PLL0PUP1_rfpll_resetn->setResetVal ("1'b0");
  f_FCSI_PLL0PUP1_rfpll_resetn->setAccProp (AccProp::RW);
  r_FCSI_PLL0PUP1->connectRField (f_FCSI_PLL0PUP1_rfpll_resetn, 2);

  Attribute* a_FCSI_PLL0PUP1_rfpll_resetn_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0PUP1_rfpll_resetn_0_0->setInstName ("0");
  a_FCSI_PLL0PUP1_rfpll_resetn_0_0->setLongName ("");
  a_FCSI_PLL0PUP1_rfpll_resetn_0_0->setDescription ("");
  a_FCSI_PLL0PUP1_rfpll_resetn_0_0->addItem("1", "1'b0", "RFPLL digital in reset state");
  a_FCSI_PLL0PUP1_rfpll_resetn_0_0->addItem("0", "1'b1", "Release RFPLL");
  f_FCSI_PLL0PUP1_rfpll_resetn->connectAttribute (a_FCSI_PLL0PUP1_rfpll_resetn_0_0);

  RField* f_FCSI_PLL0PUP1_fpd_lsbuff_op = new RField;
  f_FCSI_PLL0PUP1_fpd_lsbuff_op->setInstName ("fpd_lsbuff_op");
  f_FCSI_PLL0PUP1_fpd_lsbuff_op->setLongName ("FPD LSBUFF OP");
  f_FCSI_PLL0PUP1_fpd_lsbuff_op->setDescription ("Force Power Down the 3G buffer supplying the IQ outputs for 2.5G mode");
  f_FCSI_PLL0PUP1_fpd_lsbuff_op->setDataWidth (1);
  f_FCSI_PLL0PUP1_fpd_lsbuff_op->setResetVal ("1'b0");
  f_FCSI_PLL0PUP1_fpd_lsbuff_op->setAccProp (AccProp::RW);
  r_FCSI_PLL0PUP1->connectRField (f_FCSI_PLL0PUP1_fpd_lsbuff_op, 3);

  Attribute* a_FCSI_PLL0PUP1_fpd_lsbuff_op_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0PUP1_fpd_lsbuff_op_0_0->setInstName ("0");
  a_FCSI_PLL0PUP1_fpd_lsbuff_op_0_0->setLongName ("");
  a_FCSI_PLL0PUP1_fpd_lsbuff_op_0_0->setDescription ("");
  a_FCSI_PLL0PUP1_fpd_lsbuff_op_0_0->addItem("1", "1'b1", "enable (HP/RP mode)");
  a_FCSI_PLL0PUP1_fpd_lsbuff_op_0_0->addItem("0", "1'b0", "disable (2G mode)");
  f_FCSI_PLL0PUP1_fpd_lsbuff_op->connectAttribute (a_FCSI_PLL0PUP1_fpd_lsbuff_op_0_0);

  RField* f_FCSI_PLL0PUP1_fpd_hsbuff_op = new RField;
  f_FCSI_PLL0PUP1_fpd_hsbuff_op->setInstName ("fpd_hsbuff_op");
  f_FCSI_PLL0PUP1_fpd_hsbuff_op->setLongName ("FPD HSBUFF OP");
  f_FCSI_PLL0PUP1_fpd_hsbuff_op->setDescription ("Force power down the 12G buffer driving the 12G to 6G divider");
  f_FCSI_PLL0PUP1_fpd_hsbuff_op->setDataWidth (1);
  f_FCSI_PLL0PUP1_fpd_hsbuff_op->setResetVal ("1'b0");
  f_FCSI_PLL0PUP1_fpd_hsbuff_op->setAccProp (AccProp::RW);
  r_FCSI_PLL0PUP1->connectRField (f_FCSI_PLL0PUP1_fpd_hsbuff_op, 4);

  Attribute* a_FCSI_PLL0PUP1_fpd_hsbuff_op_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0PUP1_fpd_hsbuff_op_0_0->setInstName ("0");
  a_FCSI_PLL0PUP1_fpd_hsbuff_op_0_0->setLongName ("");
  a_FCSI_PLL0PUP1_fpd_hsbuff_op_0_0->setDescription ("");
  a_FCSI_PLL0PUP1_fpd_hsbuff_op_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_PLL0PUP1_fpd_hsbuff_op_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL0PUP1_fpd_hsbuff_op->connectAttribute (a_FCSI_PLL0PUP1_fpd_hsbuff_op_0_0);

  RField* f_FCSI_PLL0PUP1_fpd_fbbuff = new RField;
  f_FCSI_PLL0PUP1_fpd_fbbuff->setInstName ("fpd_fbbuff");
  f_FCSI_PLL0PUP1_fpd_fbbuff->setLongName ("FPD FBBUFF");
  f_FCSI_PLL0PUP1_fpd_fbbuff->setDescription ("Force Power Down the 6G to 3G dividers and the 3G buffer supplying FCAL");
  f_FCSI_PLL0PUP1_fpd_fbbuff->setDataWidth (1);
  f_FCSI_PLL0PUP1_fpd_fbbuff->setResetVal ("1'b0");
  f_FCSI_PLL0PUP1_fpd_fbbuff->setAccProp (AccProp::RW);
  r_FCSI_PLL0PUP1->connectRField (f_FCSI_PLL0PUP1_fpd_fbbuff, 5);

  Attribute* a_FCSI_PLL0PUP1_fpd_fbbuff_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0PUP1_fpd_fbbuff_0_0->setInstName ("0");
  a_FCSI_PLL0PUP1_fpd_fbbuff_0_0->setLongName ("");
  a_FCSI_PLL0PUP1_fpd_fbbuff_0_0->setDescription ("");
  a_FCSI_PLL0PUP1_fpd_fbbuff_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_PLL0PUP1_fpd_fbbuff_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL0PUP1_fpd_fbbuff->connectAttribute (a_FCSI_PLL0PUP1_fpd_fbbuff_0_0);

  RField* f_FCSI_PLL0PUP1_fpd_lsbuff_fb = new RField;
  f_FCSI_PLL0PUP1_fpd_lsbuff_fb->setInstName ("fpd_lsbuff_fb");
  f_FCSI_PLL0PUP1_fpd_lsbuff_fb->setLongName ("FPD LSBUFF FB");
  f_FCSI_PLL0PUP1_fpd_lsbuff_fb->setDescription ("Force power down the 6G output buffers, driving the 6G I/Q outputs");
  f_FCSI_PLL0PUP1_fpd_lsbuff_fb->setDataWidth (1);
  f_FCSI_PLL0PUP1_fpd_lsbuff_fb->setResetVal ("1'b0");
  f_FCSI_PLL0PUP1_fpd_lsbuff_fb->setAccProp (AccProp::RW);
  r_FCSI_PLL0PUP1->connectRField (f_FCSI_PLL0PUP1_fpd_lsbuff_fb, 6);

  Attribute* a_FCSI_PLL0PUP1_fpd_lsbuff_fb_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0PUP1_fpd_lsbuff_fb_0_0->setInstName ("0");
  a_FCSI_PLL0PUP1_fpd_lsbuff_fb_0_0->setLongName ("");
  a_FCSI_PLL0PUP1_fpd_lsbuff_fb_0_0->setDescription ("");
  a_FCSI_PLL0PUP1_fpd_lsbuff_fb_0_0->addItem("1", "1'b1", "enable (2G mode)");
  a_FCSI_PLL0PUP1_fpd_lsbuff_fb_0_0->addItem("0", "1'b0", "disable (HP/RP mode)");
  f_FCSI_PLL0PUP1_fpd_lsbuff_fb->connectAttribute (a_FCSI_PLL0PUP1_fpd_lsbuff_fb_0_0);

  RField* f_FCSI_PLL0PUP1_fpd_lsbuff = new RField;
  f_FCSI_PLL0PUP1_fpd_lsbuff->setInstName ("fpd_lsbuff");
  f_FCSI_PLL0PUP1_fpd_lsbuff->setLongName ("FPD LSBUFF");
  f_FCSI_PLL0PUP1_fpd_lsbuff->setDescription ("Force Power Down the 6G buffers after the 12Gto6G divider");
  f_FCSI_PLL0PUP1_fpd_lsbuff->setDataWidth (1);
  f_FCSI_PLL0PUP1_fpd_lsbuff->setResetVal ("1'b0");
  f_FCSI_PLL0PUP1_fpd_lsbuff->setAccProp (AccProp::RW);
  r_FCSI_PLL0PUP1->connectRField (f_FCSI_PLL0PUP1_fpd_lsbuff, 7);

  Attribute* a_FCSI_PLL0PUP1_fpd_lsbuff_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0PUP1_fpd_lsbuff_0_0->setInstName ("0");
  a_FCSI_PLL0PUP1_fpd_lsbuff_0_0->setLongName ("");
  a_FCSI_PLL0PUP1_fpd_lsbuff_0_0->setDescription ("");
  a_FCSI_PLL0PUP1_fpd_lsbuff_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_PLL0PUP1_fpd_lsbuff_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL0PUP1_fpd_lsbuff->connectAttribute (a_FCSI_PLL0PUP1_fpd_lsbuff_0_0);

  RField* f_FCSI_PLL0PUP1_fpd_hsdiv = new RField;
  f_FCSI_PLL0PUP1_fpd_hsdiv->setInstName ("fpd_hsdiv");
  f_FCSI_PLL0PUP1_fpd_hsdiv->setLongName ("FPD HSDIV");
  f_FCSI_PLL0PUP1_fpd_hsdiv->setDescription ("Force Power Down the 12G to 6G divider");
  f_FCSI_PLL0PUP1_fpd_hsdiv->setDataWidth (1);
  f_FCSI_PLL0PUP1_fpd_hsdiv->setResetVal ("1'b0");
  f_FCSI_PLL0PUP1_fpd_hsdiv->setAccProp (AccProp::RW);
  r_FCSI_PLL0PUP1->connectRField (f_FCSI_PLL0PUP1_fpd_hsdiv, 8);

  Attribute* a_FCSI_PLL0PUP1_fpd_hsdiv_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0PUP1_fpd_hsdiv_0_0->setInstName ("0");
  a_FCSI_PLL0PUP1_fpd_hsdiv_0_0->setLongName ("");
  a_FCSI_PLL0PUP1_fpd_hsdiv_0_0->setDescription ("");
  a_FCSI_PLL0PUP1_fpd_hsdiv_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_PLL0PUP1_fpd_hsdiv_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL0PUP1_fpd_hsdiv->connectAttribute (a_FCSI_PLL0PUP1_fpd_hsdiv_0_0);

  RField* f_FCSI_PLL0PUP1_fpd_hsbuff = new RField;
  f_FCSI_PLL0PUP1_fpd_hsbuff->setInstName ("fpd_hsbuff");
  f_FCSI_PLL0PUP1_fpd_hsbuff->setLongName ("FPD HSBUFF");
  f_FCSI_PLL0PUP1_fpd_hsbuff->setDescription ("Force Power Down the high speed 12G buffer connected to DivN. It controls the signal pup_12Gbuf_divn in lopath");
  f_FCSI_PLL0PUP1_fpd_hsbuff->setDataWidth (1);
  f_FCSI_PLL0PUP1_fpd_hsbuff->setResetVal ("1'b0");
  f_FCSI_PLL0PUP1_fpd_hsbuff->setAccProp (AccProp::RW);
  r_FCSI_PLL0PUP1->connectRField (f_FCSI_PLL0PUP1_fpd_hsbuff, 9);

  Attribute* a_FCSI_PLL0PUP1_fpd_hsbuff_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0PUP1_fpd_hsbuff_0_0->setInstName ("0");
  a_FCSI_PLL0PUP1_fpd_hsbuff_0_0->setLongName ("");
  a_FCSI_PLL0PUP1_fpd_hsbuff_0_0->setDescription ("");
  a_FCSI_PLL0PUP1_fpd_hsbuff_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_PLL0PUP1_fpd_hsbuff_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL0PUP1_fpd_hsbuff->connectAttribute (a_FCSI_PLL0PUP1_fpd_hsbuff_0_0);

  RField* f_FCSI_PLL0PUP1_fpd_fcal = new RField;
  f_FCSI_PLL0PUP1_fpd_fcal->setInstName ("fpd_fcal");
  f_FCSI_PLL0PUP1_fpd_fcal->setLongName ("FPD FCAL");
  f_FCSI_PLL0PUP1_fpd_fcal->setDescription ("Force Power Down the freq calibration block in analog domain (debug bit)");
  f_FCSI_PLL0PUP1_fpd_fcal->setDataWidth (1);
  f_FCSI_PLL0PUP1_fpd_fcal->setResetVal ("1'b0");
  f_FCSI_PLL0PUP1_fpd_fcal->setAccProp (AccProp::RW);
  r_FCSI_PLL0PUP1->connectRField (f_FCSI_PLL0PUP1_fpd_fcal, 10);

  Attribute* a_FCSI_PLL0PUP1_fpd_fcal_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0PUP1_fpd_fcal_0_0->setInstName ("0");
  a_FCSI_PLL0PUP1_fpd_fcal_0_0->setLongName ("");
  a_FCSI_PLL0PUP1_fpd_fcal_0_0->setDescription ("");
  a_FCSI_PLL0PUP1_fpd_fcal_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_PLL0PUP1_fpd_fcal_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL0PUP1_fpd_fcal->connectAttribute (a_FCSI_PLL0PUP1_fpd_fcal_0_0);

  RField* f_FCSI_PLL0PUP1_fpd_divn = new RField;
  f_FCSI_PLL0PUP1_fpd_divn->setInstName ("fpd_divn");
  f_FCSI_PLL0PUP1_fpd_divn->setLongName ("FPD DIVN");
  f_FCSI_PLL0PUP1_fpd_divn->setDescription ("Force Power Down the high speed feedback divider DivN (debug bit)");
  f_FCSI_PLL0PUP1_fpd_divn->setDataWidth (1);
  f_FCSI_PLL0PUP1_fpd_divn->setResetVal ("1'b0");
  f_FCSI_PLL0PUP1_fpd_divn->setAccProp (AccProp::RW);
  r_FCSI_PLL0PUP1->connectRField (f_FCSI_PLL0PUP1_fpd_divn, 11);

  Attribute* a_FCSI_PLL0PUP1_fpd_divn_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0PUP1_fpd_divn_0_0->setInstName ("0");
  a_FCSI_PLL0PUP1_fpd_divn_0_0->setLongName ("");
  a_FCSI_PLL0PUP1_fpd_divn_0_0->setDescription ("");
  a_FCSI_PLL0PUP1_fpd_divn_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_PLL0PUP1_fpd_divn_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL0PUP1_fpd_divn->connectAttribute (a_FCSI_PLL0PUP1_fpd_divn_0_0);

  RField* f_FCSI_PLL0PUP1_fpd_vco = new RField;
  f_FCSI_PLL0PUP1_fpd_vco->setInstName ("fpd_vco");
  f_FCSI_PLL0PUP1_fpd_vco->setLongName ("FPD VCO");
  f_FCSI_PLL0PUP1_fpd_vco->setDescription ("Force power down VCO (debug bit)");
  f_FCSI_PLL0PUP1_fpd_vco->setDataWidth (1);
  f_FCSI_PLL0PUP1_fpd_vco->setResetVal ("1'b0");
  f_FCSI_PLL0PUP1_fpd_vco->setAccProp (AccProp::RW);
  r_FCSI_PLL0PUP1->connectRField (f_FCSI_PLL0PUP1_fpd_vco, 12);

  Attribute* a_FCSI_PLL0PUP1_fpd_vco_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0PUP1_fpd_vco_0_0->setInstName ("0");
  a_FCSI_PLL0PUP1_fpd_vco_0_0->setLongName ("");
  a_FCSI_PLL0PUP1_fpd_vco_0_0->setDescription ("");
  a_FCSI_PLL0PUP1_fpd_vco_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_PLL0PUP1_fpd_vco_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL0PUP1_fpd_vco->connectAttribute (a_FCSI_PLL0PUP1_fpd_vco_0_0);

  RField* f_FCSI_PLL0PUP1_fpd_lf = new RField;
  f_FCSI_PLL0PUP1_fpd_lf->setInstName ("fpd_lf");
  f_FCSI_PLL0PUP1_fpd_lf->setLongName ("FPD LF");
  f_FCSI_PLL0PUP1_fpd_lf->setDescription ("Force power down LPF (debug bit)");
  f_FCSI_PLL0PUP1_fpd_lf->setDataWidth (1);
  f_FCSI_PLL0PUP1_fpd_lf->setResetVal ("1'b0");
  f_FCSI_PLL0PUP1_fpd_lf->setAccProp (AccProp::RW);
  r_FCSI_PLL0PUP1->connectRField (f_FCSI_PLL0PUP1_fpd_lf, 13);

  Attribute* a_FCSI_PLL0PUP1_fpd_lf_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0PUP1_fpd_lf_0_0->setInstName ("0");
  a_FCSI_PLL0PUP1_fpd_lf_0_0->setLongName ("");
  a_FCSI_PLL0PUP1_fpd_lf_0_0->setDescription ("");
  a_FCSI_PLL0PUP1_fpd_lf_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_PLL0PUP1_fpd_lf_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL0PUP1_fpd_lf->connectAttribute (a_FCSI_PLL0PUP1_fpd_lf_0_0);

  RField* f_FCSI_PLL0PUP1_fpd_cp = new RField;
  f_FCSI_PLL0PUP1_fpd_cp->setInstName ("fpd_cp");
  f_FCSI_PLL0PUP1_fpd_cp->setLongName ("FPD CP");
  f_FCSI_PLL0PUP1_fpd_cp->setDescription ("Force power down Charge Pump (debug bit)");
  f_FCSI_PLL0PUP1_fpd_cp->setDataWidth (1);
  f_FCSI_PLL0PUP1_fpd_cp->setResetVal ("1'b0");
  f_FCSI_PLL0PUP1_fpd_cp->setAccProp (AccProp::RW);
  r_FCSI_PLL0PUP1->connectRField (f_FCSI_PLL0PUP1_fpd_cp, 14);

  Attribute* a_FCSI_PLL0PUP1_fpd_cp_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0PUP1_fpd_cp_0_0->setInstName ("0");
  a_FCSI_PLL0PUP1_fpd_cp_0_0->setLongName ("");
  a_FCSI_PLL0PUP1_fpd_cp_0_0->setDescription ("");
  a_FCSI_PLL0PUP1_fpd_cp_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_PLL0PUP1_fpd_cp_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL0PUP1_fpd_cp->connectAttribute (a_FCSI_PLL0PUP1_fpd_cp_0_0);

  RField* f_FCSI_PLL0PUP1_fpd_pfd = new RField;
  f_FCSI_PLL0PUP1_fpd_pfd->setInstName ("fpd_pfd");
  f_FCSI_PLL0PUP1_fpd_pfd->setLongName ("FPD PFD");
  f_FCSI_PLL0PUP1_fpd_pfd->setDescription ("Force power down PFD (debug bit)");
  f_FCSI_PLL0PUP1_fpd_pfd->setDataWidth (1);
  f_FCSI_PLL0PUP1_fpd_pfd->setResetVal ("1'b0");
  f_FCSI_PLL0PUP1_fpd_pfd->setAccProp (AccProp::RW);
  r_FCSI_PLL0PUP1->connectRField (f_FCSI_PLL0PUP1_fpd_pfd, 15);

  Attribute* a_FCSI_PLL0PUP1_fpd_pfd_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0PUP1_fpd_pfd_0_0->setInstName ("0");
  a_FCSI_PLL0PUP1_fpd_pfd_0_0->setLongName ("");
  a_FCSI_PLL0PUP1_fpd_pfd_0_0->setDescription ("");
  a_FCSI_PLL0PUP1_fpd_pfd_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_PLL0PUP1_fpd_pfd_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL0PUP1_fpd_pfd->connectAttribute (a_FCSI_PLL0PUP1_fpd_pfd_0_0);

  Register* r_FCSI_PLL0VCO0 = new Register;
  r_FCSI_PLL0VCO0->setInstName ("PLL0VCO0");
  r_FCSI_PLL0VCO0->setLongName ("PLL0 VCO CONTROL 0");
  r_FCSI_PLL0VCO0->setDescription ("PLL0-LDO1V2");
  r_FCSI_PLL0VCO0->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_PLL0VCO0, 0x00000004);

  RField* f_FCSI_PLL0VCO0_ext_lpf_r2_prog = new RField;
  f_FCSI_PLL0VCO0_ext_lpf_r2_prog->setInstName ("ext_lpf_r2_prog");
  f_FCSI_PLL0VCO0_ext_lpf_r2_prog->setLongName ("EXT LPF R2 PROG");
  f_FCSI_PLL0VCO0_ext_lpf_r2_prog->setDescription ("External LPF programming values");
  f_FCSI_PLL0VCO0_ext_lpf_r2_prog->setDataWidth (2);
  f_FCSI_PLL0VCO0_ext_lpf_r2_prog->setResetVal ("2'b00");
  f_FCSI_PLL0VCO0_ext_lpf_r2_prog->setAccProp (AccProp::RW);
  r_FCSI_PLL0VCO0->connectRField (f_FCSI_PLL0VCO0_ext_lpf_r2_prog, 0);

  Attribute* a_FCSI_PLL0VCO0_ext_lpf_r2_prog_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0VCO0_ext_lpf_r2_prog_0_0->setInstName ("0");
  a_FCSI_PLL0VCO0_ext_lpf_r2_prog_0_0->setLongName ("");
  a_FCSI_PLL0VCO0_ext_lpf_r2_prog_0_0->setDescription ("");
  a_FCSI_PLL0VCO0_ext_lpf_r2_prog_0_0->addItem("0", "2'b00", "14k");
  a_FCSI_PLL0VCO0_ext_lpf_r2_prog_0_0->addItem("1", "2'b01", "17.5k");
  a_FCSI_PLL0VCO0_ext_lpf_r2_prog_0_0->addItem("2", "2'b10", "15.75");
  a_FCSI_PLL0VCO0_ext_lpf_r2_prog_0_0->addItem("3", "2'b11", "19.25");
  f_FCSI_PLL0VCO0_ext_lpf_r2_prog->connectAttribute (a_FCSI_PLL0VCO0_ext_lpf_r2_prog_0_0);

  RField* f_FCSI_PLL0VCO0_en_ext_lpf_r2_prog = new RField;
  f_FCSI_PLL0VCO0_en_ext_lpf_r2_prog->setInstName ("en_ext_lpf_r2_prog");
  f_FCSI_PLL0VCO0_en_ext_lpf_r2_prog->setLongName ("EN EXT LPF R2 PROG");
  f_FCSI_PLL0VCO0_en_ext_lpf_r2_prog->setDescription ("Enable external control of LPF R2 resistor");
  f_FCSI_PLL0VCO0_en_ext_lpf_r2_prog->setDataWidth (1);
  f_FCSI_PLL0VCO0_en_ext_lpf_r2_prog->setResetVal ("1'b0");
  f_FCSI_PLL0VCO0_en_ext_lpf_r2_prog->setAccProp (AccProp::RW);
  r_FCSI_PLL0VCO0->connectRField (f_FCSI_PLL0VCO0_en_ext_lpf_r2_prog, 2);

  Attribute* a_FCSI_PLL0VCO0_en_ext_lpf_r2_prog_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0VCO0_en_ext_lpf_r2_prog_0_0->setInstName ("0");
  a_FCSI_PLL0VCO0_en_ext_lpf_r2_prog_0_0->setLongName ("");
  a_FCSI_PLL0VCO0_en_ext_lpf_r2_prog_0_0->setDescription ("");
  a_FCSI_PLL0VCO0_en_ext_lpf_r2_prog_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_PLL0VCO0_en_ext_lpf_r2_prog_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL0VCO0_en_ext_lpf_r2_prog->connectAttribute (a_FCSI_PLL0VCO0_en_ext_lpf_r2_prog_0_0);

  RField* f_FCSI_PLL0VCO0_lpf_dly_prog = new RField;
  f_FCSI_PLL0VCO0_lpf_dly_prog->setInstName ("lpf_dly_prog");
  f_FCSI_PLL0VCO0_lpf_dly_prog->setLongName ("LPF DLY PROG");
  f_FCSI_PLL0VCO0_lpf_dly_prog->setDescription ("Deassert vlpf-mode, wait [us] after deasserting open loop signal");
  f_FCSI_PLL0VCO0_lpf_dly_prog->setDataWidth (2);
  f_FCSI_PLL0VCO0_lpf_dly_prog->setResetVal ("2'b00");
  f_FCSI_PLL0VCO0_lpf_dly_prog->setAccProp (AccProp::RW);
  r_FCSI_PLL0VCO0->connectRField (f_FCSI_PLL0VCO0_lpf_dly_prog, 3);

  Attribute* a_FCSI_PLL0VCO0_lpf_dly_prog_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0VCO0_lpf_dly_prog_0_0->setInstName ("0");
  a_FCSI_PLL0VCO0_lpf_dly_prog_0_0->setLongName ("");
  a_FCSI_PLL0VCO0_lpf_dly_prog_0_0->setDescription ("");
  a_FCSI_PLL0VCO0_lpf_dly_prog_0_0->addItem("0", "2'b00", "4us");
  a_FCSI_PLL0VCO0_lpf_dly_prog_0_0->addItem("1", "2'b01", "8us");
  a_FCSI_PLL0VCO0_lpf_dly_prog_0_0->addItem("2", "2'b10", "12us");
  a_FCSI_PLL0VCO0_lpf_dly_prog_0_0->addItem("3", "2'b11", "never (type-I)");
  f_FCSI_PLL0VCO0_lpf_dly_prog->connectAttribute (a_FCSI_PLL0VCO0_lpf_dly_prog_0_0);

  RField* f_FCSI_PLL0VCO0_integ_path_disable = new RField;
  f_FCSI_PLL0VCO0_integ_path_disable->setInstName ("integ_path_disable");
  f_FCSI_PLL0VCO0_integ_path_disable->setLongName ("INTEG PATH DISABLE");
  f_FCSI_PLL0VCO0_integ_path_disable->setDescription ("Disable low bandwidth temperature tracking integration path in LPF");
  f_FCSI_PLL0VCO0_integ_path_disable->setDataWidth (1);
  f_FCSI_PLL0VCO0_integ_path_disable->setResetVal ("1'b0");
  f_FCSI_PLL0VCO0_integ_path_disable->setAccProp (AccProp::RW);
  r_FCSI_PLL0VCO0->connectRField (f_FCSI_PLL0VCO0_integ_path_disable, 5);

  Attribute* a_FCSI_PLL0VCO0_integ_path_disable_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0VCO0_integ_path_disable_0_0->setInstName ("0");
  a_FCSI_PLL0VCO0_integ_path_disable_0_0->setLongName ("");
  a_FCSI_PLL0VCO0_integ_path_disable_0_0->setDescription ("");
  a_FCSI_PLL0VCO0_integ_path_disable_0_0->addItem("1", "1'b1", "disable");
  a_FCSI_PLL0VCO0_integ_path_disable_0_0->addItem("0", "1'b0", "enable");
  f_FCSI_PLL0VCO0_integ_path_disable->connectAttribute (a_FCSI_PLL0VCO0_integ_path_disable_0_0);

  RField* f_FCSI_PLL0VCO0_vlpf_mode_sel = new RField;
  f_FCSI_PLL0VCO0_vlpf_mode_sel->setInstName ("vlpf_mode_sel");
  f_FCSI_PLL0VCO0_vlpf_mode_sel->setLongName ("VLPF MODE SEL");
  f_FCSI_PLL0VCO0_vlpf_mode_sel->setDescription ("External vlpf mode selection to switch to OL/CL");
  f_FCSI_PLL0VCO0_vlpf_mode_sel->setDataWidth (1);
  f_FCSI_PLL0VCO0_vlpf_mode_sel->setResetVal ("1'b0");
  f_FCSI_PLL0VCO0_vlpf_mode_sel->setAccProp (AccProp::RW);
  r_FCSI_PLL0VCO0->connectRField (f_FCSI_PLL0VCO0_vlpf_mode_sel, 6);

  Attribute* a_FCSI_PLL0VCO0_vlpf_mode_sel_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0VCO0_vlpf_mode_sel_0_0->setInstName ("0");
  a_FCSI_PLL0VCO0_vlpf_mode_sel_0_0->setLongName ("");
  a_FCSI_PLL0VCO0_vlpf_mode_sel_0_0->setDescription ("");
  a_FCSI_PLL0VCO0_vlpf_mode_sel_0_0->addItem("1", "1'b1", "open loop");
  a_FCSI_PLL0VCO0_vlpf_mode_sel_0_0->addItem("0", "1'b0", "closed loop");
  f_FCSI_PLL0VCO0_vlpf_mode_sel->connectAttribute (a_FCSI_PLL0VCO0_vlpf_mode_sel_0_0);

  RField* f_FCSI_PLL0VCO0_en_ext_lpf_mode_sel = new RField;
  f_FCSI_PLL0VCO0_en_ext_lpf_mode_sel->setInstName ("en_ext_lpf_mode_sel");
  f_FCSI_PLL0VCO0_en_ext_lpf_mode_sel->setLongName ("EN EXT LPF MODE SEL");
  f_FCSI_PLL0VCO0_en_ext_lpf_mode_sel->setDescription ("Enable external control (override) of the Loop Filter mode select");
  f_FCSI_PLL0VCO0_en_ext_lpf_mode_sel->setDataWidth (1);
  f_FCSI_PLL0VCO0_en_ext_lpf_mode_sel->setResetVal ("1'b0");
  f_FCSI_PLL0VCO0_en_ext_lpf_mode_sel->setAccProp (AccProp::RW);
  r_FCSI_PLL0VCO0->connectRField (f_FCSI_PLL0VCO0_en_ext_lpf_mode_sel, 7);

  Attribute* a_FCSI_PLL0VCO0_en_ext_lpf_mode_sel_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0VCO0_en_ext_lpf_mode_sel_0_0->setInstName ("0");
  a_FCSI_PLL0VCO0_en_ext_lpf_mode_sel_0_0->setLongName ("");
  a_FCSI_PLL0VCO0_en_ext_lpf_mode_sel_0_0->setDescription ("");
  a_FCSI_PLL0VCO0_en_ext_lpf_mode_sel_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_PLL0VCO0_en_ext_lpf_mode_sel_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL0VCO0_en_ext_lpf_mode_sel->connectAttribute (a_FCSI_PLL0VCO0_en_ext_lpf_mode_sel_0_0);

  RField* f_FCSI_PLL0VCO0_lpf_acap_bias_sel = new RField;
  f_FCSI_PLL0VCO0_lpf_acap_bias_sel->setInstName ("lpf_acap_bias_sel");
  f_FCSI_PLL0VCO0_lpf_acap_bias_sel->setLongName ("LPF ACAP BIAS SEL");
  f_FCSI_PLL0VCO0_lpf_acap_bias_sel->setDescription ("Select the bias voltage for the VCO pside analog varactor");
  f_FCSI_PLL0VCO0_lpf_acap_bias_sel->setDataWidth (2);
  f_FCSI_PLL0VCO0_lpf_acap_bias_sel->setResetVal ("2'b00");
  f_FCSI_PLL0VCO0_lpf_acap_bias_sel->setAccProp (AccProp::RW);
  r_FCSI_PLL0VCO0->connectRField (f_FCSI_PLL0VCO0_lpf_acap_bias_sel, 8);

  Attribute* a_FCSI_PLL0VCO0_lpf_acap_bias_sel_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0VCO0_lpf_acap_bias_sel_0_0->setInstName ("0");
  a_FCSI_PLL0VCO0_lpf_acap_bias_sel_0_0->setLongName ("");
  a_FCSI_PLL0VCO0_lpf_acap_bias_sel_0_0->setDescription ("");
  a_FCSI_PLL0VCO0_lpf_acap_bias_sel_0_0->addItem("0", "2'b00", "0.7V");
  a_FCSI_PLL0VCO0_lpf_acap_bias_sel_0_0->addItem("1", "2'b01", "0.65V");
  a_FCSI_PLL0VCO0_lpf_acap_bias_sel_0_0->addItem("2", "2'b10", "0.80V");
  a_FCSI_PLL0VCO0_lpf_acap_bias_sel_0_0->addItem("3", "2'b11", "0.75V");
  f_FCSI_PLL0VCO0_lpf_acap_bias_sel->connectAttribute (a_FCSI_PLL0VCO0_lpf_acap_bias_sel_0_0);

  RField* f_FCSI_PLL0VCO0_lpf_acap2_bias_sel = new RField;
  f_FCSI_PLL0VCO0_lpf_acap2_bias_sel->setInstName ("lpf_acap2_bias_sel");
  f_FCSI_PLL0VCO0_lpf_acap2_bias_sel->setLongName ("LPF ACAP2 BIAS SEL");
  f_FCSI_PLL0VCO0_lpf_acap2_bias_sel->setDescription ("Select the bias voltage for the VCO nside analog varactor");
  f_FCSI_PLL0VCO0_lpf_acap2_bias_sel->setDataWidth (2);
  f_FCSI_PLL0VCO0_lpf_acap2_bias_sel->setResetVal ("2'b00");
  f_FCSI_PLL0VCO0_lpf_acap2_bias_sel->setAccProp (AccProp::RW);
  r_FCSI_PLL0VCO0->connectRField (f_FCSI_PLL0VCO0_lpf_acap2_bias_sel, 10);

  Attribute* a_FCSI_PLL0VCO0_lpf_acap2_bias_sel_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0VCO0_lpf_acap2_bias_sel_0_0->setInstName ("0");
  a_FCSI_PLL0VCO0_lpf_acap2_bias_sel_0_0->setLongName ("");
  a_FCSI_PLL0VCO0_lpf_acap2_bias_sel_0_0->setDescription ("");
  a_FCSI_PLL0VCO0_lpf_acap2_bias_sel_0_0->addItem("0", "2'b00", "0.90V");
  a_FCSI_PLL0VCO0_lpf_acap2_bias_sel_0_0->addItem("1", "2'b01", "0.95V");
  a_FCSI_PLL0VCO0_lpf_acap2_bias_sel_0_0->addItem("2", "2'b10", "0.80V");
  a_FCSI_PLL0VCO0_lpf_acap2_bias_sel_0_0->addItem("3", "2'b11", "0.85V");
  f_FCSI_PLL0VCO0_lpf_acap2_bias_sel->connectAttribute (a_FCSI_PLL0VCO0_lpf_acap2_bias_sel_0_0);

  RField* f_FCSI_PLL0VCO0_bump_dcap_on_ref = new RField;
  f_FCSI_PLL0VCO0_bump_dcap_on_ref->setInstName ("bump_dcap_on_ref");
  f_FCSI_PLL0VCO0_bump_dcap_on_ref->setLongName ("BUMP DCAP ON REF");
  f_FCSI_PLL0VCO0_bump_dcap_on_ref->setDescription ("Select the reference voltage for the coarse calibration ON capacitor");
  f_FCSI_PLL0VCO0_bump_dcap_on_ref->setDataWidth (2);
  f_FCSI_PLL0VCO0_bump_dcap_on_ref->setResetVal ("2'b00");
  f_FCSI_PLL0VCO0_bump_dcap_on_ref->setAccProp (AccProp::RW);
  r_FCSI_PLL0VCO0->connectRField (f_FCSI_PLL0VCO0_bump_dcap_on_ref, 12);

  Attribute* a_FCSI_PLL0VCO0_bump_dcap_on_ref_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0VCO0_bump_dcap_on_ref_0_0->setInstName ("0");
  a_FCSI_PLL0VCO0_bump_dcap_on_ref_0_0->setLongName ("");
  a_FCSI_PLL0VCO0_bump_dcap_on_ref_0_0->setDescription ("");
  a_FCSI_PLL0VCO0_bump_dcap_on_ref_0_0->addItem("0", "2'b00", "1.60V");
  a_FCSI_PLL0VCO0_bump_dcap_on_ref_0_0->addItem("1", "2'b01", "1.55V (default)");
  a_FCSI_PLL0VCO0_bump_dcap_on_ref_0_0->addItem("2", "2'b10", "1.50V");
  a_FCSI_PLL0VCO0_bump_dcap_on_ref_0_0->addItem("3", "2'b11", "1.46V");
  f_FCSI_PLL0VCO0_bump_dcap_on_ref->connectAttribute (a_FCSI_PLL0VCO0_bump_dcap_on_ref_0_0);

  RField* f_FCSI_PLL0VCO0_bump_dcap_off_ref = new RField;
  f_FCSI_PLL0VCO0_bump_dcap_off_ref->setInstName ("bump_dcap_off_ref");
  f_FCSI_PLL0VCO0_bump_dcap_off_ref->setLongName ("PLL BUMP DCAP OFF REF");
  f_FCSI_PLL0VCO0_bump_dcap_off_ref->setDescription ("Select the reference voltage for the coarse calibration OFF capacitor");
  f_FCSI_PLL0VCO0_bump_dcap_off_ref->setDataWidth (2);
  f_FCSI_PLL0VCO0_bump_dcap_off_ref->setResetVal ("2'b00");
  f_FCSI_PLL0VCO0_bump_dcap_off_ref->setAccProp (AccProp::RW);
  r_FCSI_PLL0VCO0->connectRField (f_FCSI_PLL0VCO0_bump_dcap_off_ref, 14);

  Attribute* a_FCSI_PLL0VCO0_bump_dcap_off_ref_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0VCO0_bump_dcap_off_ref_0_0->setInstName ("0");
  a_FCSI_PLL0VCO0_bump_dcap_off_ref_0_0->setLongName ("");
  a_FCSI_PLL0VCO0_bump_dcap_off_ref_0_0->setDescription ("");
  a_FCSI_PLL0VCO0_bump_dcap_off_ref_0_0->addItem("0", "2'b00", "1.1Vref");
  a_FCSI_PLL0VCO0_bump_dcap_off_ref_0_0->addItem("1", "2'b01", "1.0Vref (default)");
  a_FCSI_PLL0VCO0_bump_dcap_off_ref_0_0->addItem("2", "2'b10", "0.91Vref");
  a_FCSI_PLL0VCO0_bump_dcap_off_ref_0_0->addItem("3", "2'b11", "0.90Vref");
  f_FCSI_PLL0VCO0_bump_dcap_off_ref->connectAttribute (a_FCSI_PLL0VCO0_bump_dcap_off_ref_0_0);

  Register* r_FCSI_PLL0VCO1 = new Register;
  r_FCSI_PLL0VCO1->setInstName ("PLL0VCO1");
  r_FCSI_PLL0VCO1->setLongName ("PLL0 VCO CONTROL 1");
  r_FCSI_PLL0VCO1->setDescription ("PLL0-LDO1V2");
  r_FCSI_PLL0VCO1->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_PLL0VCO1, 0x00000005);

  RField* f_FCSI_PLL0VCO1_en_bump_kvco = new RField;
  f_FCSI_PLL0VCO1_en_bump_kvco->setInstName ("en_bump_kvco");
  f_FCSI_PLL0VCO1_en_bump_kvco->setLongName ("EN BUMP KVCO");
  f_FCSI_PLL0VCO1_en_bump_kvco->setDescription ("External KVCO control setting values");
  f_FCSI_PLL0VCO1_en_bump_kvco->setDataWidth (1);
  f_FCSI_PLL0VCO1_en_bump_kvco->setResetVal ("1'b0");
  f_FCSI_PLL0VCO1_en_bump_kvco->setAccProp (AccProp::RW);
  r_FCSI_PLL0VCO1->connectRField (f_FCSI_PLL0VCO1_en_bump_kvco, 1);

  Attribute* a_FCSI_PLL0VCO1_en_bump_kvco_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0VCO1_en_bump_kvco_0_0->setInstName ("0");
  a_FCSI_PLL0VCO1_en_bump_kvco_0_0->setLongName ("");
  a_FCSI_PLL0VCO1_en_bump_kvco_0_0->setDescription ("");
  a_FCSI_PLL0VCO1_en_bump_kvco_0_0->addItem("1", "1'b1", "Smaller ACAP bias R");
  a_FCSI_PLL0VCO1_en_bump_kvco_0_0->addItem("0", "1'b0", "Larger ACAP bias R");
  f_FCSI_PLL0VCO1_en_bump_kvco->connectAttribute (a_FCSI_PLL0VCO1_en_bump_kvco_0_0);

  RField* f_FCSI_PLL0VCO1_ext_dcap_fine = new RField;
  f_FCSI_PLL0VCO1_ext_dcap_fine->setInstName ("ext_dcap_fine");
  f_FCSI_PLL0VCO1_ext_dcap_fine->setLongName ("EXT DCAP FINE");
  f_FCSI_PLL0VCO1_ext_dcap_fine->setDescription ("External fine calibration values");
  f_FCSI_PLL0VCO1_ext_dcap_fine->setDataWidth (3);
  f_FCSI_PLL0VCO1_ext_dcap_fine->setResetVal ("3'b000");
  f_FCSI_PLL0VCO1_ext_dcap_fine->setAccProp (AccProp::RW);
  r_FCSI_PLL0VCO1->connectRField (f_FCSI_PLL0VCO1_ext_dcap_fine, 2);

  Attribute* a_FCSI_PLL0VCO1_ext_dcap_fine_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0VCO1_ext_dcap_fine_0_0->setInstName ("0");
  a_FCSI_PLL0VCO1_ext_dcap_fine_0_0->setLongName ("");
  a_FCSI_PLL0VCO1_ext_dcap_fine_0_0->setDescription ("");
  a_FCSI_PLL0VCO1_ext_dcap_fine_0_0->addItem("7", "3'b111", "Highest frequency");
  a_FCSI_PLL0VCO1_ext_dcap_fine_0_0->addItem("0", "3'b000", "Lowest frequency");
  f_FCSI_PLL0VCO1_ext_dcap_fine->connectAttribute (a_FCSI_PLL0VCO1_ext_dcap_fine_0_0);

  RField* f_FCSI_PLL0VCO1_ext_dcap_coarse = new RField;
  f_FCSI_PLL0VCO1_ext_dcap_coarse->setInstName ("ext_dcap_coarse");
  f_FCSI_PLL0VCO1_ext_dcap_coarse->setLongName ("EXT DCAP COARSE");
  f_FCSI_PLL0VCO1_ext_dcap_coarse->setDescription ("External coarse calibration values");
  f_FCSI_PLL0VCO1_ext_dcap_coarse->setDataWidth (10);
  f_FCSI_PLL0VCO1_ext_dcap_coarse->setResetVal ("10'b0000000000");
  f_FCSI_PLL0VCO1_ext_dcap_coarse->setAccProp (AccProp::RW);
  r_FCSI_PLL0VCO1->connectRField (f_FCSI_PLL0VCO1_ext_dcap_coarse, 5);

  Attribute* a_FCSI_PLL0VCO1_ext_dcap_coarse_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0VCO1_ext_dcap_coarse_0_0->setInstName ("0");
  a_FCSI_PLL0VCO1_ext_dcap_coarse_0_0->setLongName ("");
  a_FCSI_PLL0VCO1_ext_dcap_coarse_0_0->setDescription ("");
  a_FCSI_PLL0VCO1_ext_dcap_coarse_0_0->addItem("1", "10'b1111111111", "Highest frequency");
  a_FCSI_PLL0VCO1_ext_dcap_coarse_0_0->addItem("0", "10'b0000000000", "Lowest frequency");
  f_FCSI_PLL0VCO1_ext_dcap_coarse->connectAttribute (a_FCSI_PLL0VCO1_ext_dcap_coarse_0_0);

  RField* f_FCSI_PLL0VCO1_en_ext_dcap_override = new RField;
  f_FCSI_PLL0VCO1_en_ext_dcap_override->setInstName ("en_ext_dcap_override");
  f_FCSI_PLL0VCO1_en_ext_dcap_override->setLongName ("EN EXT DCAP OVERRIDE");
  f_FCSI_PLL0VCO1_en_ext_dcap_override->setDescription ("Enable writing the coarse and fine DCAP values externally");
  f_FCSI_PLL0VCO1_en_ext_dcap_override->setDataWidth (1);
  f_FCSI_PLL0VCO1_en_ext_dcap_override->setResetVal ("1'b0");
  f_FCSI_PLL0VCO1_en_ext_dcap_override->setAccProp (AccProp::RW);
  r_FCSI_PLL0VCO1->connectRField (f_FCSI_PLL0VCO1_en_ext_dcap_override, 15);

  Attribute* a_FCSI_PLL0VCO1_en_ext_dcap_override_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0VCO1_en_ext_dcap_override_0_0->setInstName ("0");
  a_FCSI_PLL0VCO1_en_ext_dcap_override_0_0->setLongName ("");
  a_FCSI_PLL0VCO1_en_ext_dcap_override_0_0->setDescription ("");
  a_FCSI_PLL0VCO1_en_ext_dcap_override_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_PLL0VCO1_en_ext_dcap_override_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL0VCO1_en_ext_dcap_override->connectAttribute (a_FCSI_PLL0VCO1_en_ext_dcap_override_0_0);

  Register* r_FCSI_PLL0SDM0 = new Register;
  r_FCSI_PLL0SDM0->setInstName ("PLL0SDM0");
  r_FCSI_PLL0SDM0->setLongName ("PLL0 SIGMA DELTA 0");
  r_FCSI_PLL0SDM0->setDescription ("PLL0-LDO1V2");
  r_FCSI_PLL0SDM0->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_PLL0SDM0, 0x00000006);

  RField* f_FCSI_PLL0SDM0_lock_o = new RField;
  f_FCSI_PLL0SDM0_lock_o->setInstName ("lock_o");
  f_FCSI_PLL0SDM0_lock_o->setLongName ("LOCK OUTPUT");
  f_FCSI_PLL0SDM0_lock_o->setDescription ("Lock output signal");
  f_FCSI_PLL0SDM0_lock_o->setDataWidth (1);
  f_FCSI_PLL0SDM0_lock_o->setResetVal ("1'b0");
  f_FCSI_PLL0SDM0_lock_o->setAccProp (AccProp::RW);
  r_FCSI_PLL0SDM0->connectRField (f_FCSI_PLL0SDM0_lock_o, 0);

  Attribute* a_FCSI_PLL0SDM0_lock_o_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0SDM0_lock_o_0_0->setInstName ("0");
  a_FCSI_PLL0SDM0_lock_o_0_0->setLongName ("");
  a_FCSI_PLL0SDM0_lock_o_0_0->setDescription ("");
  a_FCSI_PLL0SDM0_lock_o_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_PLL0SDM0_lock_o_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL0SDM0_lock_o->connectAttribute (a_FCSI_PLL0SDM0_lock_o_0_0);

  RField* f_FCSI_PLL0SDM0_seldig_tm = new RField;
  f_FCSI_PLL0SDM0_seldig_tm->setInstName ("seldig_tm");
  f_FCSI_PLL0SDM0_seldig_tm->setLongName ("SELDIG TM");
  f_FCSI_PLL0SDM0_seldig_tm->setDescription ("Select signal input for the digital monitor output");
  f_FCSI_PLL0SDM0_seldig_tm->setDataWidth (2);
  f_FCSI_PLL0SDM0_seldig_tm->setResetVal ("2'b00");
  f_FCSI_PLL0SDM0_seldig_tm->setAccProp (AccProp::RW);
  r_FCSI_PLL0SDM0->connectRField (f_FCSI_PLL0SDM0_seldig_tm, 1);

  Attribute* a_FCSI_PLL0SDM0_seldig_tm_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0SDM0_seldig_tm_0_0->setInstName ("0");
  a_FCSI_PLL0SDM0_seldig_tm_0_0->setLongName ("");
  a_FCSI_PLL0SDM0_seldig_tm_0_0->setDescription ("");
  a_FCSI_PLL0SDM0_seldig_tm_0_0->addItem("0", "2'b00", "0");
  a_FCSI_PLL0SDM0_seldig_tm_0_0->addItem("1", "2'b01", "lock_i");
  a_FCSI_PLL0SDM0_seldig_tm_0_0->addItem("2", "2'b10", "ref_clk_i");
  a_FCSI_PLL0SDM0_seldig_tm_0_0->addItem("3", "2'b11", "clk_nc");
  f_FCSI_PLL0SDM0_seldig_tm->connectAttribute (a_FCSI_PLL0SDM0_seldig_tm_0_0);

  RField* f_FCSI_PLL0SDM0_lock_override = new RField;
  f_FCSI_PLL0SDM0_lock_override->setInstName ("lock_override");
  f_FCSI_PLL0SDM0_lock_override->setLongName ("LOCK OVERRIDE");
  f_FCSI_PLL0SDM0_lock_override->setDescription ("External override enable for PLL lock signal");
  f_FCSI_PLL0SDM0_lock_override->setDataWidth (1);
  f_FCSI_PLL0SDM0_lock_override->setResetVal ("1'b0");
  f_FCSI_PLL0SDM0_lock_override->setAccProp (AccProp::RW);
  r_FCSI_PLL0SDM0->connectRField (f_FCSI_PLL0SDM0_lock_override, 3);

  Attribute* a_FCSI_PLL0SDM0_lock_override_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0SDM0_lock_override_0_0->setInstName ("0");
  a_FCSI_PLL0SDM0_lock_override_0_0->setLongName ("");
  a_FCSI_PLL0SDM0_lock_override_0_0->setDescription ("");
  a_FCSI_PLL0SDM0_lock_override_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_PLL0SDM0_lock_override_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL0SDM0_lock_override->connectAttribute (a_FCSI_PLL0SDM0_lock_override_0_0);

  RField* f_FCSI_PLL0SDM0_en_timer_lock_det = new RField;
  f_FCSI_PLL0SDM0_en_timer_lock_det->setInstName ("en_timer_lock_det");
  f_FCSI_PLL0SDM0_en_timer_lock_det->setLongName ("EN TIME LOCK DET");
  f_FCSI_PLL0SDM0_en_timer_lock_det->setDescription ("Enable timer based lock detection");
  f_FCSI_PLL0SDM0_en_timer_lock_det->setDataWidth (1);
  f_FCSI_PLL0SDM0_en_timer_lock_det->setResetVal ("1'b0");
  f_FCSI_PLL0SDM0_en_timer_lock_det->setAccProp (AccProp::RW);
  r_FCSI_PLL0SDM0->connectRField (f_FCSI_PLL0SDM0_en_timer_lock_det, 4);

  Attribute* a_FCSI_PLL0SDM0_en_timer_lock_det_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0SDM0_en_timer_lock_det_0_0->setInstName ("0");
  a_FCSI_PLL0SDM0_en_timer_lock_det_0_0->setLongName ("");
  a_FCSI_PLL0SDM0_en_timer_lock_det_0_0->setDescription ("");
  a_FCSI_PLL0SDM0_en_timer_lock_det_0_0->addItem("1", "1'b1", "Timer based lock detection");
  a_FCSI_PLL0SDM0_en_timer_lock_det_0_0->addItem("0", "1'b0", "Default lock detection");
  f_FCSI_PLL0SDM0_en_timer_lock_det->connectAttribute (a_FCSI_PLL0SDM0_en_timer_lock_det_0_0);

  RField* f_FCSI_PLL0SDM0_ext_sdm = new RField;
  f_FCSI_PLL0SDM0_ext_sdm->setInstName ("ext_sdm");
  f_FCSI_PLL0SDM0_ext_sdm->setLongName ("EXT SDM");
  f_FCSI_PLL0SDM0_ext_sdm->setDescription ("External delta sigma modulator control");
  f_FCSI_PLL0SDM0_ext_sdm->setDataWidth (3);
  f_FCSI_PLL0SDM0_ext_sdm->setResetVal ("3'b000");
  f_FCSI_PLL0SDM0_ext_sdm->setAccProp (AccProp::RW);
  r_FCSI_PLL0SDM0->connectRField (f_FCSI_PLL0SDM0_ext_sdm, 5);

  RField* f_FCSI_PLL0SDM0_en_ext_sdm = new RField;
  f_FCSI_PLL0SDM0_en_ext_sdm->setInstName ("en_ext_sdm");
  f_FCSI_PLL0SDM0_en_ext_sdm->setLongName ("EN EXT SDM");
  f_FCSI_PLL0SDM0_en_ext_sdm->setDescription ("Enable external override of the Delta Sigma Modulator");
  f_FCSI_PLL0SDM0_en_ext_sdm->setDataWidth (1);
  f_FCSI_PLL0SDM0_en_ext_sdm->setResetVal ("1'b0");
  f_FCSI_PLL0SDM0_en_ext_sdm->setAccProp (AccProp::RW);
  r_FCSI_PLL0SDM0->connectRField (f_FCSI_PLL0SDM0_en_ext_sdm, 8);

  Attribute* a_FCSI_PLL0SDM0_en_ext_sdm_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0SDM0_en_ext_sdm_0_0->setInstName ("0");
  a_FCSI_PLL0SDM0_en_ext_sdm_0_0->setLongName ("");
  a_FCSI_PLL0SDM0_en_ext_sdm_0_0->setDescription ("");
  a_FCSI_PLL0SDM0_en_ext_sdm_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_PLL0SDM0_en_ext_sdm_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL0SDM0_en_ext_sdm->connectAttribute (a_FCSI_PLL0SDM0_en_ext_sdm_0_0);

  RField* f_FCSI_PLL0SDM0_prbs_dither_en = new RField;
  f_FCSI_PLL0SDM0_prbs_dither_en->setInstName ("prbs_dither_en");
  f_FCSI_PLL0SDM0_prbs_dither_en->setLongName ("PRBS DITHER EN");
  f_FCSI_PLL0SDM0_prbs_dither_en->setDescription ("Enable prbs dither mode for DSM");
  f_FCSI_PLL0SDM0_prbs_dither_en->setDataWidth (1);
  f_FCSI_PLL0SDM0_prbs_dither_en->setResetVal ("1'b0");
  f_FCSI_PLL0SDM0_prbs_dither_en->setAccProp (AccProp::RW);
  r_FCSI_PLL0SDM0->connectRField (f_FCSI_PLL0SDM0_prbs_dither_en, 9);

  Attribute* a_FCSI_PLL0SDM0_prbs_dither_en_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0SDM0_prbs_dither_en_0_0->setInstName ("0");
  a_FCSI_PLL0SDM0_prbs_dither_en_0_0->setLongName ("");
  a_FCSI_PLL0SDM0_prbs_dither_en_0_0->setDescription ("");
  a_FCSI_PLL0SDM0_prbs_dither_en_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_PLL0SDM0_prbs_dither_en_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL0SDM0_prbs_dither_en->connectAttribute (a_FCSI_PLL0SDM0_prbs_dither_en_0_0);

  RField* f_FCSI_PLL0SDM0_sdm_en = new RField;
  f_FCSI_PLL0SDM0_sdm_en->setInstName ("sdm_en");
  f_FCSI_PLL0SDM0_sdm_en->setLongName ("SDM EN");
  f_FCSI_PLL0SDM0_sdm_en->setDescription ("Enable the delta sigma modulator");
  f_FCSI_PLL0SDM0_sdm_en->setDataWidth (1);
  f_FCSI_PLL0SDM0_sdm_en->setResetVal ("1'b0");
  f_FCSI_PLL0SDM0_sdm_en->setAccProp (AccProp::RW);
  r_FCSI_PLL0SDM0->connectRField (f_FCSI_PLL0SDM0_sdm_en, 10);

  Attribute* a_FCSI_PLL0SDM0_sdm_en_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0SDM0_sdm_en_0_0->setInstName ("0");
  a_FCSI_PLL0SDM0_sdm_en_0_0->setLongName ("");
  a_FCSI_PLL0SDM0_sdm_en_0_0->setDescription ("");
  a_FCSI_PLL0SDM0_sdm_en_0_0->addItem("1", "1'b1", "enable (2G mode)");
  a_FCSI_PLL0SDM0_sdm_en_0_0->addItem("0", "1'b0", "disable (HP/RP mode)");
  f_FCSI_PLL0SDM0_sdm_en->connectAttribute (a_FCSI_PLL0SDM0_sdm_en_0_0);

  RField* f_FCSI_PLL0SDM0_sel_fcal_cnt = new RField;
  f_FCSI_PLL0SDM0_sel_fcal_cnt->setInstName ("sel_fcal_cnt");
  f_FCSI_PLL0SDM0_sel_fcal_cnt->setLongName ("SEL FCAL CNT");
  f_FCSI_PLL0SDM0_sel_fcal_cnt->setDescription ("Select the FCAL counter value that needs to be read back on the FCAL_Counter Register");
  f_FCSI_PLL0SDM0_sel_fcal_cnt->setDataWidth (5);
  f_FCSI_PLL0SDM0_sel_fcal_cnt->setResetVal ("5'b00000");
  f_FCSI_PLL0SDM0_sel_fcal_cnt->setAccProp (AccProp::RW);
  r_FCSI_PLL0SDM0->connectRField (f_FCSI_PLL0SDM0_sel_fcal_cnt, 11);

  Attribute* a_FCSI_PLL0SDM0_sel_fcal_cnt_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0SDM0_sel_fcal_cnt_0_0->setInstName ("0");
  a_FCSI_PLL0SDM0_sel_fcal_cnt_0_0->setLongName ("");
  a_FCSI_PLL0SDM0_sel_fcal_cnt_0_0->setDescription ("");
  a_FCSI_PLL0SDM0_sel_fcal_cnt_0_0->addItem("0", "5'b00000", "Coarse Cal bit 9 Final Count Ch-0");
  a_FCSI_PLL0SDM0_sel_fcal_cnt_0_0->addItem("1", "5'b00001", "Coarse Cal bit 8 Final Count Ch-0");
  a_FCSI_PLL0SDM0_sel_fcal_cnt_0_0->addItem("2", "5'b00010", "Coarse Cal bit 7 Final Count Ch-0");
  a_FCSI_PLL0SDM0_sel_fcal_cnt_0_0->addItem("3", "5'b00011", "Coarse Cal bit 6 Final Count Ch-0");
  a_FCSI_PLL0SDM0_sel_fcal_cnt_0_0->addItem("4", "5'b00100", "Coarse Cal bit 5 Final Count Ch-0");
  a_FCSI_PLL0SDM0_sel_fcal_cnt_0_0->addItem("5", "5'b00101", "Coarse Cal bit 4 Final Count Ch-0");
  a_FCSI_PLL0SDM0_sel_fcal_cnt_0_0->addItem("6", "5'b00110", "Coarse Cal bit 3 Final Count Ch-0");
  a_FCSI_PLL0SDM0_sel_fcal_cnt_0_0->addItem("7", "5'b00111", "Coarse Cal bit 2 Final Count Ch-0");
  a_FCSI_PLL0SDM0_sel_fcal_cnt_0_0->addItem("8", "5'b01000", "Coarse Cal bit 1 Final Count Ch-0");
  a_FCSI_PLL0SDM0_sel_fcal_cnt_0_0->addItem("9", "5'b01001", "Coarse Cal bit 0 Final Count Ch-0");
  a_FCSI_PLL0SDM0_sel_fcal_cnt_0_0->addItem("10", "5'b01010", "Fine Cal bit 2 Final Count Ch-0");
  a_FCSI_PLL0SDM0_sel_fcal_cnt_0_0->addItem("11", "5'b01011", "Fine Cal bit 1 Final Count Ch-0");
  a_FCSI_PLL0SDM0_sel_fcal_cnt_0_0->addItem("12", "5'b01100", "Fine Cal bit 0 Final Count Ch-0");
  a_FCSI_PLL0SDM0_sel_fcal_cnt_0_0->addItem("13", "5'b01101", "Fine Cal bit 0 Final Count Ch-0 (FINAL FCAL COUNT)");
  a_FCSI_PLL0SDM0_sel_fcal_cnt_0_0->addItem("14", "5'b01110", "Channel 0 final calibration value (Bits in the following order 0,0,Coarse<9:0>,Fine<2:0>)");
  a_FCSI_PLL0SDM0_sel_fcal_cnt_0_0->addItem("15", "5'b01111", "Channel 0 final minimum count (FINAL FCAL COUNT)");
  a_FCSI_PLL0SDM0_sel_fcal_cnt_0_0->addItem("16", "5'b10000", "Channel 1 final calibration value");
  a_FCSI_PLL0SDM0_sel_fcal_cnt_0_0->addItem("17", "5'b10001", "Channel 1 final minimum count");
  a_FCSI_PLL0SDM0_sel_fcal_cnt_0_0->addItem("18", "5'b10010", "Channel 2 final calibration value");
  a_FCSI_PLL0SDM0_sel_fcal_cnt_0_0->addItem("19", "5'b10011", "Channel 2 final minimum count");
  a_FCSI_PLL0SDM0_sel_fcal_cnt_0_0->addItem("20", "5'b10100", "Channel 3 final calibration value");
  a_FCSI_PLL0SDM0_sel_fcal_cnt_0_0->addItem("21", "5'b10101", "Channel 3 final minimum count");
  a_FCSI_PLL0SDM0_sel_fcal_cnt_0_0->addItem("22", "5'b10110", "Channel 4 final calibration value");
  a_FCSI_PLL0SDM0_sel_fcal_cnt_0_0->addItem("23", "5'b10111", "Channel 4 final minimum count");
  a_FCSI_PLL0SDM0_sel_fcal_cnt_0_0->addItem("24", "5'b11000", "Channel 5 final calibration value");
  a_FCSI_PLL0SDM0_sel_fcal_cnt_0_0->addItem("25", "5'b11001", "Channel 5 final minimum count");
  a_FCSI_PLL0SDM0_sel_fcal_cnt_0_0->addItem("26", "5'b11010", "Current FCAL FSM state");
  a_FCSI_PLL0SDM0_sel_fcal_cnt_0_0->addItem("27", "5'b11011", "Current PUP FSM state");
  f_FCSI_PLL0SDM0_sel_fcal_cnt->connectAttribute (a_FCSI_PLL0SDM0_sel_fcal_cnt_0_0);

  Register* r_FCSI_PLL0SDM1 = new Register;
  r_FCSI_PLL0SDM1->setInstName ("PLL0SDM1");
  r_FCSI_PLL0SDM1->setLongName ("PLL0 SIGMA DELTA 1");
  r_FCSI_PLL0SDM1->setDescription ("PLL0-LDO1V2");
  r_FCSI_PLL0SDM1->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_PLL0SDM1, 0x00000007);

  RField* f_FCSI_PLL0SDM1_divn_frac_ch1 = new RField;
  f_FCSI_PLL0SDM1_divn_frac_ch1->setInstName ("divn_frac_ch1");
  f_FCSI_PLL0SDM1_divn_frac_ch1->setLongName ("DIVN FRAC CH1 [23:8]");
  f_FCSI_PLL0SDM1_divn_frac_ch1->setDescription ("MMD Fractional Value LSB's");
  f_FCSI_PLL0SDM1_divn_frac_ch1->setDataWidth (16);
  f_FCSI_PLL0SDM1_divn_frac_ch1->setResetVal ("16'b0000000000000000");
  f_FCSI_PLL0SDM1_divn_frac_ch1->setAccProp (AccProp::RW);
  r_FCSI_PLL0SDM1->connectRField (f_FCSI_PLL0SDM1_divn_frac_ch1, 0);

  Register* r_FCSI_PLL0SDM2 = new Register;
  r_FCSI_PLL0SDM2->setInstName ("PLL0SDM2");
  r_FCSI_PLL0SDM2->setLongName ("PLL0 SIGMA DELTA 2");
  r_FCSI_PLL0SDM2->setDescription ("PLL0-LDO1V2");
  r_FCSI_PLL0SDM2->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_PLL0SDM2, 0x00000008);

  RField* f_FCSI_PLL0SDM2_divn_int_ch1 = new RField;
  f_FCSI_PLL0SDM2_divn_int_ch1->setInstName ("divn_int_ch1");
  f_FCSI_PLL0SDM2_divn_int_ch1->setLongName ("DIVN INT CH1");
  f_FCSI_PLL0SDM2_divn_int_ch1->setDescription ("Integer values");
  f_FCSI_PLL0SDM2_divn_int_ch1->setDataWidth (8);
  f_FCSI_PLL0SDM2_divn_int_ch1->setResetVal ("8'b00000000");
  f_FCSI_PLL0SDM2_divn_int_ch1->setAccProp (AccProp::RW);
  r_FCSI_PLL0SDM2->connectRField (f_FCSI_PLL0SDM2_divn_int_ch1, 0);

  RField* f_FCSI_PLL0SDM2_div_int_ch1_shared_frac = new RField;
  f_FCSI_PLL0SDM2_div_int_ch1_shared_frac->setInstName ("div_int_ch1_shared_frac");
  f_FCSI_PLL0SDM2_div_int_ch1_shared_frac->setLongName ("DIV INT CH1 [10:8] / DIVN FRAC CH1 [2:0]");
  f_FCSI_PLL0SDM2_div_int_ch1_shared_frac->setDescription ("Integer values (or shared MMD Fractional Value MSB's)");
  f_FCSI_PLL0SDM2_div_int_ch1_shared_frac->setDataWidth (3);
  f_FCSI_PLL0SDM2_div_int_ch1_shared_frac->setResetVal ("3'b000");
  f_FCSI_PLL0SDM2_div_int_ch1_shared_frac->setAccProp (AccProp::RW);
  r_FCSI_PLL0SDM2->connectRField (f_FCSI_PLL0SDM2_div_int_ch1_shared_frac, 8);

  RField* f_FCSI_PLL0SDM2_divn_frac_ch1 = new RField;
  f_FCSI_PLL0SDM2_divn_frac_ch1->setInstName ("divn_frac_ch1");
  f_FCSI_PLL0SDM2_divn_frac_ch1->setLongName ("DIVN FRAC CH1 [7:3]");
  f_FCSI_PLL0SDM2_divn_frac_ch1->setDescription ("MMD Fractional Value MSB's");
  f_FCSI_PLL0SDM2_divn_frac_ch1->setDataWidth (5);
  f_FCSI_PLL0SDM2_divn_frac_ch1->setResetVal ("5'b00000");
  f_FCSI_PLL0SDM2_divn_frac_ch1->setAccProp (AccProp::RW);
  r_FCSI_PLL0SDM2->connectRField (f_FCSI_PLL0SDM2_divn_frac_ch1, 11);

  Register* r_FCSI_PLL0OUT = new Register;
  r_FCSI_PLL0OUT->setInstName ("PLL0OUT");
  r_FCSI_PLL0OUT->setLongName ("PLL0 OUTPUT CONTROL");
  r_FCSI_PLL0OUT->setDescription ("PLL0-LDO1V2");
  r_FCSI_PLL0OUT->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_PLL0OUT, 0x00000009);

  RField* f_FCSI_PLL0OUT_digtm_o = new RField;
  f_FCSI_PLL0OUT_digtm_o->setInstName ("digtm_o");
  f_FCSI_PLL0OUT_digtm_o->setLongName ("DIGTM OUT");
  f_FCSI_PLL0OUT_digtm_o->setDescription ("Digital monitor output");
  f_FCSI_PLL0OUT_digtm_o->setDataWidth (1);
  f_FCSI_PLL0OUT_digtm_o->setResetVal ("1'b0");
  f_FCSI_PLL0OUT_digtm_o->setAccProp (AccProp::RW);
  r_FCSI_PLL0OUT->connectRField (f_FCSI_PLL0OUT_digtm_o, 0);

  Attribute* a_FCSI_PLL0OUT_digtm_o_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0OUT_digtm_o_0_0->setInstName ("0");
  a_FCSI_PLL0OUT_digtm_o_0_0->setLongName ("");
  a_FCSI_PLL0OUT_digtm_o_0_0->setDescription ("");
  a_FCSI_PLL0OUT_digtm_o_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_PLL0OUT_digtm_o_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL0OUT_digtm_o->connectAttribute (a_FCSI_PLL0OUT_digtm_o_0_0);

  RField* f_FCSI_PLL0OUT_fcal_cnt_o = new RField;
  f_FCSI_PLL0OUT_fcal_cnt_o->setInstName ("fcal_cnt_o");
  f_FCSI_PLL0OUT_fcal_cnt_o->setLongName ("FCAL CNT OUT");
  f_FCSI_PLL0OUT_fcal_cnt_o->setDescription ("Read out the internal digital counter values");
  f_FCSI_PLL0OUT_fcal_cnt_o->setDataWidth (15);
  f_FCSI_PLL0OUT_fcal_cnt_o->setResetVal ("15'b000000000000000");
  f_FCSI_PLL0OUT_fcal_cnt_o->setAccProp (AccProp::RW);
  r_FCSI_PLL0OUT->connectRField (f_FCSI_PLL0OUT_fcal_cnt_o, 1);

  Register* r_FCSI_PLL0MISC = new Register;
  r_FCSI_PLL0MISC->setInstName ("PLL0MISC");
  r_FCSI_PLL0MISC->setLongName ("PLL0 MISCELLANEOUS");
  r_FCSI_PLL0MISC->setDescription ("PLL0-LDO1V2");
  r_FCSI_PLL0MISC->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_PLL0MISC, 0x0000000A);

  RField* f_FCSI_PLL0MISC_en_icp_override = new RField;
  f_FCSI_PLL0MISC_en_icp_override->setInstName ("en_icp_override");
  f_FCSI_PLL0MISC_en_icp_override->setLongName ("EN ICP OVERRIDE");
  f_FCSI_PLL0MISC_en_icp_override->setDescription ("Enable external ICP bin programming");
  f_FCSI_PLL0MISC_en_icp_override->setDataWidth (1);
  f_FCSI_PLL0MISC_en_icp_override->setResetVal ("1'b0");
  f_FCSI_PLL0MISC_en_icp_override->setAccProp (AccProp::RW);
  r_FCSI_PLL0MISC->connectRField (f_FCSI_PLL0MISC_en_icp_override, 0);

  Attribute* a_FCSI_PLL0MISC_en_icp_override_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0MISC_en_icp_override_0_0->setInstName ("0");
  a_FCSI_PLL0MISC_en_icp_override_0_0->setLongName ("");
  a_FCSI_PLL0MISC_en_icp_override_0_0->setDescription ("");
  a_FCSI_PLL0MISC_en_icp_override_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_PLL0MISC_en_icp_override_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL0MISC_en_icp_override->connectAttribute (a_FCSI_PLL0MISC_en_icp_override_0_0);

  RField* f_FCSI_PLL0MISC_sel_close_loop_hop_mode = new RField;
  f_FCSI_PLL0MISC_sel_close_loop_hop_mode->setInstName ("sel_close_loop_hop_mode");
  f_FCSI_PLL0MISC_sel_close_loop_hop_mode->setLongName ("SEL CLOSE LOOP HOP MODE");
  f_FCSI_PLL0MISC_sel_close_loop_hop_mode->setDescription ("Select closed loop channel hopping mode");
  f_FCSI_PLL0MISC_sel_close_loop_hop_mode->setDataWidth (2);
  f_FCSI_PLL0MISC_sel_close_loop_hop_mode->setResetVal ("2'b00");
  f_FCSI_PLL0MISC_sel_close_loop_hop_mode->setAccProp (AccProp::RW);
  r_FCSI_PLL0MISC->connectRField (f_FCSI_PLL0MISC_sel_close_loop_hop_mode, 1);

  Attribute* a_FCSI_PLL0MISC_sel_close_loop_hop_mode_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0MISC_sel_close_loop_hop_mode_0_0->setInstName ("0");
  a_FCSI_PLL0MISC_sel_close_loop_hop_mode_0_0->setLongName ("");
  a_FCSI_PLL0MISC_sel_close_loop_hop_mode_0_0->setDescription ("");
  a_FCSI_PLL0MISC_sel_close_loop_hop_mode_0_0->addItem("0", "2'b00", "Default");
  a_FCSI_PLL0MISC_sel_close_loop_hop_mode_0_0->addItem("1", "2'b01", "Test mode");
  a_FCSI_PLL0MISC_sel_close_loop_hop_mode_0_0->addItem("2", "2'b10", "---");
  a_FCSI_PLL0MISC_sel_close_loop_hop_mode_0_0->addItem("3", "2'b11", "---");
  f_FCSI_PLL0MISC_sel_close_loop_hop_mode->connectAttribute (a_FCSI_PLL0MISC_sel_close_loop_hop_mode_0_0);

  RField* f_FCSI_PLL0MISC_sel_clk = new RField;
  f_FCSI_PLL0MISC_sel_clk->setInstName ("sel_clk");
  f_FCSI_PLL0MISC_sel_clk->setLongName ("SEL CLK");
  f_FCSI_PLL0MISC_sel_clk->setDescription ("Select the input clock for the PLL");
  f_FCSI_PLL0MISC_sel_clk->setDataWidth (1);
  f_FCSI_PLL0MISC_sel_clk->setResetVal ("1'b0");
  f_FCSI_PLL0MISC_sel_clk->setAccProp (AccProp::RW);
  r_FCSI_PLL0MISC->connectRField (f_FCSI_PLL0MISC_sel_clk, 3);

  Attribute* a_FCSI_PLL0MISC_sel_clk_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0MISC_sel_clk_0_0->setInstName ("0");
  a_FCSI_PLL0MISC_sel_clk_0_0->setLongName ("");
  a_FCSI_PLL0MISC_sel_clk_0_0->setDescription ("");
  a_FCSI_PLL0MISC_sel_clk_0_0->addItem("ext", "1'b1", "External FSYS clock");
  a_FCSI_PLL0MISC_sel_clk_0_0->addItem("int", "1'b0", "DCXO clock or external single ended clk");
  f_FCSI_PLL0MISC_sel_clk->connectAttribute (a_FCSI_PLL0MISC_sel_clk_0_0);

  RField* f_FCSI_PLL0MISC_rfpll_fast_channel_hop_en = new RField;
  f_FCSI_PLL0MISC_rfpll_fast_channel_hop_en->setInstName ("rfpll_fast_channel_hop_en");
  f_FCSI_PLL0MISC_rfpll_fast_channel_hop_en->setLongName ("EN FAST CHANNEL HOP");
  f_FCSI_PLL0MISC_rfpll_fast_channel_hop_en->setDescription ("Enable fast channel hopping");
  f_FCSI_PLL0MISC_rfpll_fast_channel_hop_en->setDataWidth (1);
  f_FCSI_PLL0MISC_rfpll_fast_channel_hop_en->setResetVal ("1'b0");
  f_FCSI_PLL0MISC_rfpll_fast_channel_hop_en->setAccProp (AccProp::RW);
  r_FCSI_PLL0MISC->connectRField (f_FCSI_PLL0MISC_rfpll_fast_channel_hop_en, 4);

  Attribute* a_FCSI_PLL0MISC_rfpll_fast_channel_hop_en_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0MISC_rfpll_fast_channel_hop_en_0_0->setInstName ("0");
  a_FCSI_PLL0MISC_rfpll_fast_channel_hop_en_0_0->setLongName ("");
  a_FCSI_PLL0MISC_rfpll_fast_channel_hop_en_0_0->setDescription ("");
  a_FCSI_PLL0MISC_rfpll_fast_channel_hop_en_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_PLL0MISC_rfpll_fast_channel_hop_en_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL0MISC_rfpll_fast_channel_hop_en->connectAttribute (a_FCSI_PLL0MISC_rfpll_fast_channel_hop_en_0_0);

  RField* f_FCSI_PLL0MISC_rfpll_ref_sel_40M = new RField;
  f_FCSI_PLL0MISC_rfpll_ref_sel_40M->setInstName ("rfpll_ref_sel_40M");
  f_FCSI_PLL0MISC_rfpll_ref_sel_40M->setLongName ("REF SEL 40M");
  f_FCSI_PLL0MISC_rfpll_ref_sel_40M->setDescription ("Reference frequency selection");
  f_FCSI_PLL0MISC_rfpll_ref_sel_40M->setDataWidth (1);
  f_FCSI_PLL0MISC_rfpll_ref_sel_40M->setResetVal ("1'b0");
  f_FCSI_PLL0MISC_rfpll_ref_sel_40M->setAccProp (AccProp::RW);
  r_FCSI_PLL0MISC->connectRField (f_FCSI_PLL0MISC_rfpll_ref_sel_40M, 5);

  Attribute* a_FCSI_PLL0MISC_rfpll_ref_sel_40M_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0MISC_rfpll_ref_sel_40M_0_0->setInstName ("0");
  a_FCSI_PLL0MISC_rfpll_ref_sel_40M_0_0->setLongName ("");
  a_FCSI_PLL0MISC_rfpll_ref_sel_40M_0_0->setDescription ("");
  a_FCSI_PLL0MISC_rfpll_ref_sel_40M_0_0->addItem("1", "1'b1", "40MHz (HP-40MHz/RP-40MHz/2G mode)");
  a_FCSI_PLL0MISC_rfpll_ref_sel_40M_0_0->addItem("0", "1'b0", "10MHz/20MHz depending on rfpll_ref_sel_20M (bit9)");
  f_FCSI_PLL0MISC_rfpll_ref_sel_40M->connectAttribute (a_FCSI_PLL0MISC_rfpll_ref_sel_40M_0_0);

  RField* f_FCSI_PLL0MISC_sel_divn_ref_clk = new RField;
  f_FCSI_PLL0MISC_sel_divn_ref_clk->setInstName ("sel_divn_ref_clk");
  f_FCSI_PLL0MISC_sel_divn_ref_clk->setLongName ("SEL DIVN REF CLK");
  f_FCSI_PLL0MISC_sel_divn_ref_clk->setDescription ("Select clock used by DSM");
  f_FCSI_PLL0MISC_sel_divn_ref_clk->setDataWidth (1);
  f_FCSI_PLL0MISC_sel_divn_ref_clk->setResetVal ("1'b0");
  f_FCSI_PLL0MISC_sel_divn_ref_clk->setAccProp (AccProp::RW);
  r_FCSI_PLL0MISC->connectRField (f_FCSI_PLL0MISC_sel_divn_ref_clk, 6);

  Attribute* a_FCSI_PLL0MISC_sel_divn_ref_clk_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0MISC_sel_divn_ref_clk_0_0->setInstName ("0");
  a_FCSI_PLL0MISC_sel_divn_ref_clk_0_0->setLongName ("");
  a_FCSI_PLL0MISC_sel_divn_ref_clk_0_0->setDescription ("");
  a_FCSI_PLL0MISC_sel_divn_ref_clk_0_0->addItem("1", "1'b1", "Reference Clock");
  a_FCSI_PLL0MISC_sel_divn_ref_clk_0_0->addItem("0", "1'b0", "NC clock");
  f_FCSI_PLL0MISC_sel_divn_ref_clk->connectAttribute (a_FCSI_PLL0MISC_sel_divn_ref_clk_0_0);

  RField* f_FCSI_PLL0MISC_fcal_min_dcap_polarity_sel = new RField;
  f_FCSI_PLL0MISC_fcal_min_dcap_polarity_sel->setInstName ("fcal_min_dcap_polarity_sel");
  f_FCSI_PLL0MISC_fcal_min_dcap_polarity_sel->setLongName ("FCAL MIN DCAP POLARITY SEL");
  f_FCSI_PLL0MISC_fcal_min_dcap_polarity_sel->setDescription ("Select polarity of FCAL count");
  f_FCSI_PLL0MISC_fcal_min_dcap_polarity_sel->setDataWidth (1);
  f_FCSI_PLL0MISC_fcal_min_dcap_polarity_sel->setResetVal ("1'b0");
  f_FCSI_PLL0MISC_fcal_min_dcap_polarity_sel->setAccProp (AccProp::RW);
  r_FCSI_PLL0MISC->connectRField (f_FCSI_PLL0MISC_fcal_min_dcap_polarity_sel, 7);

  Attribute* a_FCSI_PLL0MISC_fcal_min_dcap_polarity_sel_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0MISC_fcal_min_dcap_polarity_sel_0_0->setInstName ("0");
  a_FCSI_PLL0MISC_fcal_min_dcap_polarity_sel_0_0->setLongName ("");
  a_FCSI_PLL0MISC_fcal_min_dcap_polarity_sel_0_0->setDescription ("");
  a_FCSI_PLL0MISC_fcal_min_dcap_polarity_sel_0_0->addItem("1", "1'b1", "FCAL value above the ideal count");
  a_FCSI_PLL0MISC_fcal_min_dcap_polarity_sel_0_0->addItem("0", "1'b0", "FCAL value below the ideal count");
  f_FCSI_PLL0MISC_fcal_min_dcap_polarity_sel->connectAttribute (a_FCSI_PLL0MISC_fcal_min_dcap_polarity_sel_0_0);

  RField* f_FCSI_PLL0MISC_fcal_en_min_dcap_polarity = new RField;
  f_FCSI_PLL0MISC_fcal_en_min_dcap_polarity->setInstName ("fcal_en_min_dcap_polarity");
  f_FCSI_PLL0MISC_fcal_en_min_dcap_polarity->setLongName ("FCAL EN MIN DCAP POLARITY");
  f_FCSI_PLL0MISC_fcal_en_min_dcap_polarity->setDescription ("Speed up settling during channel hopping");
  f_FCSI_PLL0MISC_fcal_en_min_dcap_polarity->setDataWidth (1);
  f_FCSI_PLL0MISC_fcal_en_min_dcap_polarity->setResetVal ("1'b0");
  f_FCSI_PLL0MISC_fcal_en_min_dcap_polarity->setAccProp (AccProp::RW);
  r_FCSI_PLL0MISC->connectRField (f_FCSI_PLL0MISC_fcal_en_min_dcap_polarity, 8);

  Attribute* a_FCSI_PLL0MISC_fcal_en_min_dcap_polarity_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0MISC_fcal_en_min_dcap_polarity_0_0->setInstName ("0");
  a_FCSI_PLL0MISC_fcal_en_min_dcap_polarity_0_0->setLongName ("");
  a_FCSI_PLL0MISC_fcal_en_min_dcap_polarity_0_0->setDescription ("");
  a_FCSI_PLL0MISC_fcal_en_min_dcap_polarity_0_0->addItem("1", "1'b1", "closest FCAL count (higher or lower the ideal count)");
  a_FCSI_PLL0MISC_fcal_en_min_dcap_polarity_0_0->addItem("0", "1'b0", "Least error");
  f_FCSI_PLL0MISC_fcal_en_min_dcap_polarity->connectAttribute (a_FCSI_PLL0MISC_fcal_en_min_dcap_polarity_0_0);

  RField* f_FCSI_PLL0MISC_rfpll_ref_sel_20M = new RField;
  f_FCSI_PLL0MISC_rfpll_ref_sel_20M->setInstName ("rfpll_ref_sel_20M");
  f_FCSI_PLL0MISC_rfpll_ref_sel_20M->setLongName ("RFPLL REF SEL 20M");
  f_FCSI_PLL0MISC_rfpll_ref_sel_20M->setDescription ("Select reference frequency used by PLL in 5G operation");
  f_FCSI_PLL0MISC_rfpll_ref_sel_20M->setDataWidth (1);
  f_FCSI_PLL0MISC_rfpll_ref_sel_20M->setResetVal ("1'b0");
  f_FCSI_PLL0MISC_rfpll_ref_sel_20M->setAccProp (AccProp::RW);
  r_FCSI_PLL0MISC->connectRField (f_FCSI_PLL0MISC_rfpll_ref_sel_20M, 9);

  Attribute* a_FCSI_PLL0MISC_rfpll_ref_sel_20M_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0MISC_rfpll_ref_sel_20M_0_0->setInstName ("0");
  a_FCSI_PLL0MISC_rfpll_ref_sel_20M_0_0->setLongName ("");
  a_FCSI_PLL0MISC_rfpll_ref_sel_20M_0_0->setDescription ("");
  a_FCSI_PLL0MISC_rfpll_ref_sel_20M_0_0->addItem("1", "1'b1", "20MHz if rfpll_ref_sel_40M (bit5) is 0");
  a_FCSI_PLL0MISC_rfpll_ref_sel_20M_0_0->addItem("0", "1'b0", "10MHz if rfpll_ref_sel_40M (bit5) is 0");
  f_FCSI_PLL0MISC_rfpll_ref_sel_20M->connectAttribute (a_FCSI_PLL0MISC_rfpll_ref_sel_20M_0_0);

  RField* f_FCSI_PLL0MISC_pfd_cdd_bump = new RField;
  f_FCSI_PLL0MISC_pfd_cdd_bump->setInstName ("pfd_cdd_bump");
  f_FCSI_PLL0MISC_pfd_cdd_bump->setLongName ("PFD VDD BUMP");
  f_FCSI_PLL0MISC_pfd_cdd_bump->setDescription ("No connect at ana core level");
  f_FCSI_PLL0MISC_pfd_cdd_bump->setDataWidth (1);
  f_FCSI_PLL0MISC_pfd_cdd_bump->setResetVal ("1'b0");
  f_FCSI_PLL0MISC_pfd_cdd_bump->setAccProp (AccProp::RW);
  r_FCSI_PLL0MISC->connectRField (f_FCSI_PLL0MISC_pfd_cdd_bump, 10);

  RField* f_FCSI_PLL0MISC_capboost_ppath = new RField;
  f_FCSI_PLL0MISC_capboost_ppath->setInstName ("capboost_ppath");
  f_FCSI_PLL0MISC_capboost_ppath->setLongName ("CAPBOOST PPATH");
  f_FCSI_PLL0MISC_capboost_ppath->setDescription ("External charge pump current control setting values (Cap boost for 40M modes)");
  f_FCSI_PLL0MISC_capboost_ppath->setDataWidth (3);
  f_FCSI_PLL0MISC_capboost_ppath->setResetVal ("3'b000");
  f_FCSI_PLL0MISC_capboost_ppath->setAccProp (AccProp::RW);
  r_FCSI_PLL0MISC->connectRField (f_FCSI_PLL0MISC_capboost_ppath, 11);

  RField* f_FCSI_PLL0MISC_pfd_rst_dly = new RField;
  f_FCSI_PLL0MISC_pfd_rst_dly->setInstName ("pfd_rst_dly");
  f_FCSI_PLL0MISC_pfd_rst_dly->setLongName ("PFD RST DLY");
  f_FCSI_PLL0MISC_pfd_rst_dly->setDescription ("Reset delay in the PFD");
  f_FCSI_PLL0MISC_pfd_rst_dly->setDataWidth (2);
  f_FCSI_PLL0MISC_pfd_rst_dly->setResetVal ("2'b00");
  f_FCSI_PLL0MISC_pfd_rst_dly->setAccProp (AccProp::RW);
  r_FCSI_PLL0MISC->connectRField (f_FCSI_PLL0MISC_pfd_rst_dly, 14);

  Attribute* a_FCSI_PLL0MISC_pfd_rst_dly_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL0MISC_pfd_rst_dly_0_0->setInstName ("0");
  a_FCSI_PLL0MISC_pfd_rst_dly_0_0->setLongName ("");
  a_FCSI_PLL0MISC_pfd_rst_dly_0_0->setDescription ("");
  a_FCSI_PLL0MISC_pfd_rst_dly_0_0->addItem("0", "2'b00", "120ps");
  a_FCSI_PLL0MISC_pfd_rst_dly_0_0->addItem("1", "2'b01", "240ps");
  a_FCSI_PLL0MISC_pfd_rst_dly_0_0->addItem("2", "2'b10", "330ps");
  a_FCSI_PLL0MISC_pfd_rst_dly_0_0->addItem("3", "2'b11", "400ps");
  f_FCSI_PLL0MISC_pfd_rst_dly->connectAttribute (a_FCSI_PLL0MISC_pfd_rst_dly_0_0);

  Register* r_FCSI_PLL0CH2 = new Register;
  r_FCSI_PLL0CH2->setInstName ("PLL0CH2");
  r_FCSI_PLL0CH2->setLongName ("PLL0 FAST CHANNEL HOP 2");
  r_FCSI_PLL0CH2->setDescription ("PLL0-LDO1V2");
  r_FCSI_PLL0CH2->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_PLL0CH2, 0x0000000B);

  RField* f_FCSI_PLL0CH2_div_int_ch2 = new RField;
  f_FCSI_PLL0CH2_div_int_ch2->setInstName ("div_int_ch2");
  f_FCSI_PLL0CH2_div_int_ch2->setLongName ("DIV INT CH2");
  f_FCSI_PLL0CH2_div_int_ch2->setDescription ("Integer value for channel2 (MMD integer input)");
  f_FCSI_PLL0CH2_div_int_ch2->setDataWidth (11);
  f_FCSI_PLL0CH2_div_int_ch2->setResetVal ("11'b00000000000");
  f_FCSI_PLL0CH2_div_int_ch2->setAccProp (AccProp::RW);
  r_FCSI_PLL0CH2->connectRField (f_FCSI_PLL0CH2_div_int_ch2, 0);

  RField* f_FCSI_PLL0CH2_icp_bin_override = new RField;
  f_FCSI_PLL0CH2_icp_bin_override->setInstName ("icp_bin_override");
  f_FCSI_PLL0CH2_icp_bin_override->setLongName ("ICP BIN OVERRIDE");
  f_FCSI_PLL0CH2_icp_bin_override->setDescription ("ICP bin override (external programming value for CP)");
  f_FCSI_PLL0CH2_icp_bin_override->setDataWidth (5);
  f_FCSI_PLL0CH2_icp_bin_override->setResetVal ("5'b00000");
  f_FCSI_PLL0CH2_icp_bin_override->setAccProp (AccProp::RW);
  r_FCSI_PLL0CH2->connectRField (f_FCSI_PLL0CH2_icp_bin_override, 11);

  Register* r_FCSI_PLL0CH3 = new Register;
  r_FCSI_PLL0CH3->setInstName ("PLL0CH3");
  r_FCSI_PLL0CH3->setLongName ("PLL0 FAST CHANNEL HOP 3");
  r_FCSI_PLL0CH3->setDescription ("PLL0-LDO1V2");
  r_FCSI_PLL0CH3->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_PLL0CH3, 0x0000000C);

  RField* f_FCSI_PLL0CH3_div_int_ch3 = new RField;
  f_FCSI_PLL0CH3_div_int_ch3->setInstName ("div_int_ch3");
  f_FCSI_PLL0CH3_div_int_ch3->setLongName ("DIV INT CH3");
  f_FCSI_PLL0CH3_div_int_ch3->setDescription ("Integer value for channel 3  (MMD integer input)");
  f_FCSI_PLL0CH3_div_int_ch3->setDataWidth (11);
  f_FCSI_PLL0CH3_div_int_ch3->setResetVal ("11'b00000000000");
  f_FCSI_PLL0CH3_div_int_ch3->setAccProp (AccProp::RW);
  r_FCSI_PLL0CH3->connectRField (f_FCSI_PLL0CH3_div_int_ch3, 0);

  Register* r_FCSI_PLL0CH4 = new Register;
  r_FCSI_PLL0CH4->setInstName ("PLL0CH4");
  r_FCSI_PLL0CH4->setLongName ("PLL0 FAST CHANNEL HOP 4");
  r_FCSI_PLL0CH4->setDescription ("PLL0-LDO1V2");
  r_FCSI_PLL0CH4->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_PLL0CH4, 0x0000000D);

  RField* f_FCSI_PLL0CH4_div_int_ch4 = new RField;
  f_FCSI_PLL0CH4_div_int_ch4->setInstName ("div_int_ch4");
  f_FCSI_PLL0CH4_div_int_ch4->setLongName ("DIV INT CH4");
  f_FCSI_PLL0CH4_div_int_ch4->setDescription ("Integer value for channel 4  (MMD integer input)");
  f_FCSI_PLL0CH4_div_int_ch4->setDataWidth (11);
  f_FCSI_PLL0CH4_div_int_ch4->setResetVal ("11'b00000000000");
  f_FCSI_PLL0CH4_div_int_ch4->setAccProp (AccProp::RW);
  r_FCSI_PLL0CH4->connectRField (f_FCSI_PLL0CH4_div_int_ch4, 0);

  Register* r_FCSI_PLL0CH5 = new Register;
  r_FCSI_PLL0CH5->setInstName ("PLL0CH5");
  r_FCSI_PLL0CH5->setLongName ("PLL0 FAST CHANNEL HOP 5");
  r_FCSI_PLL0CH5->setDescription ("PLL0-LDO1V2");
  r_FCSI_PLL0CH5->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_PLL0CH5, 0x0000000E);

  RField* f_FCSI_PLL0CH5_div_int_ch5 = new RField;
  f_FCSI_PLL0CH5_div_int_ch5->setInstName ("div_int_ch5");
  f_FCSI_PLL0CH5_div_int_ch5->setLongName ("DIV INT CH5");
  f_FCSI_PLL0CH5_div_int_ch5->setDescription ("Integer value for channel 5  (MMD integer input)");
  f_FCSI_PLL0CH5_div_int_ch5->setDataWidth (11);
  f_FCSI_PLL0CH5_div_int_ch5->setResetVal ("11'b00000000000");
  f_FCSI_PLL0CH5_div_int_ch5->setAccProp (AccProp::RW);
  r_FCSI_PLL0CH5->connectRField (f_FCSI_PLL0CH5_div_int_ch5, 0);

  Register* r_FCSI_PLL0CH6 = new Register;
  r_FCSI_PLL0CH6->setInstName ("PLL0CH6");
  r_FCSI_PLL0CH6->setLongName ("PLL0 FAST CHANNEL HOP 6");
  r_FCSI_PLL0CH6->setDescription ("PLL0-LDO1V2");
  r_FCSI_PLL0CH6->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_PLL0CH6, 0x0000000F);

  RField* f_FCSI_PLL0CH6_div_int_ch6 = new RField;
  f_FCSI_PLL0CH6_div_int_ch6->setInstName ("div_int_ch6");
  f_FCSI_PLL0CH6_div_int_ch6->setLongName ("DIV INT CH6");
  f_FCSI_PLL0CH6_div_int_ch6->setDescription ("Integer value for channel 6  (MMD integer input)");
  f_FCSI_PLL0CH6_div_int_ch6->setDataWidth (11);
  f_FCSI_PLL0CH6_div_int_ch6->setResetVal ("11'b00000000000");
  f_FCSI_PLL0CH6_div_int_ch6->setAccProp (AccProp::RW);
  r_FCSI_PLL0CH6->connectRField (f_FCSI_PLL0CH6_div_int_ch6, 0);

  Register* r_FCSI_PLL1PUP0 = new Register;
  r_FCSI_PLL1PUP0->setInstName ("PLL1PUP0");
  r_FCSI_PLL1PUP0->setLongName ("PLL1 POWER UP CENTRAL");
  r_FCSI_PLL1PUP0->setDescription ("FCSI-LDO1V2");
  r_FCSI_PLL1PUP0->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_PLL1PUP0, 0x00000010);

  RField* f_FCSI_PLL1PUP0_shuntreg_override_fc = new RField;
  f_FCSI_PLL1PUP0_shuntreg_override_fc->setInstName ("shuntreg_override_fc");
  f_FCSI_PLL1PUP0_shuntreg_override_fc->setLongName ("SHUNTREG OVERRIDE FC");
  f_FCSI_PLL1PUP0_shuntreg_override_fc->setDescription ("Fast charge option in CP shunt-regulator (bypassed)");
  f_FCSI_PLL1PUP0_shuntreg_override_fc->setDataWidth (1);
  f_FCSI_PLL1PUP0_shuntreg_override_fc->setResetVal ("1'b0");
  f_FCSI_PLL1PUP0_shuntreg_override_fc->setAccProp (AccProp::RW);
  r_FCSI_PLL1PUP0->connectRField (f_FCSI_PLL1PUP0_shuntreg_override_fc, 1);

  Attribute* a_FCSI_PLL1PUP0_shuntreg_override_fc_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1PUP0_shuntreg_override_fc_0_0->setInstName ("0");
  a_FCSI_PLL1PUP0_shuntreg_override_fc_0_0->setLongName ("");
  a_FCSI_PLL1PUP0_shuntreg_override_fc_0_0->setDescription ("");
  a_FCSI_PLL1PUP0_shuntreg_override_fc_0_0->addItem("0", "1'b1", "disable");
  a_FCSI_PLL1PUP0_shuntreg_override_fc_0_0->addItem("1", "1'b0", "enable");
  f_FCSI_PLL1PUP0_shuntreg_override_fc->connectAttribute (a_FCSI_PLL1PUP0_shuntreg_override_fc_0_0);

  RField* f_FCSI_PLL1PUP0_vcoreg_override_fc = new RField;
  f_FCSI_PLL1PUP0_vcoreg_override_fc->setInstName ("vcoreg_override_fc");
  f_FCSI_PLL1PUP0_vcoreg_override_fc->setLongName ("VCOREG OVERRIDE FC");
  f_FCSI_PLL1PUP0_vcoreg_override_fc->setDescription ("Fast charge option in VCO (bypassed)");
  f_FCSI_PLL1PUP0_vcoreg_override_fc->setDataWidth (1);
  f_FCSI_PLL1PUP0_vcoreg_override_fc->setResetVal ("1'b0");
  f_FCSI_PLL1PUP0_vcoreg_override_fc->setAccProp (AccProp::RW);
  r_FCSI_PLL1PUP0->connectRField (f_FCSI_PLL1PUP0_vcoreg_override_fc, 2);

  Attribute* a_FCSI_PLL1PUP0_vcoreg_override_fc_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1PUP0_vcoreg_override_fc_0_0->setInstName ("0");
  a_FCSI_PLL1PUP0_vcoreg_override_fc_0_0->setLongName ("");
  a_FCSI_PLL1PUP0_vcoreg_override_fc_0_0->setDescription ("");
  a_FCSI_PLL1PUP0_vcoreg_override_fc_0_0->addItem("0", "1'b1", "disable");
  a_FCSI_PLL1PUP0_vcoreg_override_fc_0_0->addItem("1", "1'b0", "enable");
  f_FCSI_PLL1PUP0_vcoreg_override_fc->connectAttribute (a_FCSI_PLL1PUP0_vcoreg_override_fc_0_0);

  RField* f_FCSI_PLL1PUP0_vcoreg_bypass = new RField;
  f_FCSI_PLL1PUP0_vcoreg_bypass->setInstName ("vcoreg_bypass");
  f_FCSI_PLL1PUP0_vcoreg_bypass->setLongName ("VCOREG BYPASS");
  f_FCSI_PLL1PUP0_vcoreg_bypass->setDescription ("VCO register output bypassed (use external supply)");
  f_FCSI_PLL1PUP0_vcoreg_bypass->setDataWidth (1);
  f_FCSI_PLL1PUP0_vcoreg_bypass->setResetVal ("1'b0");
  f_FCSI_PLL1PUP0_vcoreg_bypass->setAccProp (AccProp::RW);
  r_FCSI_PLL1PUP0->connectRField (f_FCSI_PLL1PUP0_vcoreg_bypass, 3);

  Attribute* a_FCSI_PLL1PUP0_vcoreg_bypass_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1PUP0_vcoreg_bypass_0_0->setInstName ("0");
  a_FCSI_PLL1PUP0_vcoreg_bypass_0_0->setLongName ("");
  a_FCSI_PLL1PUP0_vcoreg_bypass_0_0->setDescription ("");
  a_FCSI_PLL1PUP0_vcoreg_bypass_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_PLL1PUP0_vcoreg_bypass_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL1PUP0_vcoreg_bypass->connectAttribute (a_FCSI_PLL1PUP0_vcoreg_bypass_0_0);

  RField* f_FCSI_PLL1PUP0_pup_reg_resync = new RField;
  f_FCSI_PLL1PUP0_pup_reg_resync->setInstName ("pup_reg_resync");
  f_FCSI_PLL1PUP0_pup_reg_resync->setLongName ("PUP REG RESYNC");
  f_FCSI_PLL1PUP0_pup_reg_resync->setDescription ("Power up for DIVN re-sync block regulator");
  f_FCSI_PLL1PUP0_pup_reg_resync->setDataWidth (1);
  f_FCSI_PLL1PUP0_pup_reg_resync->setResetVal ("1'b0");
  f_FCSI_PLL1PUP0_pup_reg_resync->setAccProp (AccProp::RW);
  r_FCSI_PLL1PUP0->connectRField (f_FCSI_PLL1PUP0_pup_reg_resync, 4);

  Attribute* a_FCSI_PLL1PUP0_pup_reg_resync_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1PUP0_pup_reg_resync_0_0->setInstName ("0");
  a_FCSI_PLL1PUP0_pup_reg_resync_0_0->setLongName ("");
  a_FCSI_PLL1PUP0_pup_reg_resync_0_0->setDescription ("");
  a_FCSI_PLL1PUP0_pup_reg_resync_0_0->addItem("1", "1'b1", "enable (default)");
  a_FCSI_PLL1PUP0_pup_reg_resync_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL1PUP0_pup_reg_resync->connectAttribute (a_FCSI_PLL1PUP0_pup_reg_resync_0_0);

  RField* f_FCSI_PLL1PUP0_pup_vvbgen_ppath = new RField;
  f_FCSI_PLL1PUP0_pup_vvbgen_ppath->setInstName ("pup_vvbgen_ppath");
  f_FCSI_PLL1PUP0_pup_vvbgen_ppath->setLongName ("PUP VVBGEN PPATH");
  f_FCSI_PLL1PUP0_pup_vvbgen_ppath->setDescription ("Power up for enabling the direct path in the LPF");
  f_FCSI_PLL1PUP0_pup_vvbgen_ppath->setDataWidth (1);
  f_FCSI_PLL1PUP0_pup_vvbgen_ppath->setResetVal ("1'b0");
  f_FCSI_PLL1PUP0_pup_vvbgen_ppath->setAccProp (AccProp::RW);
  r_FCSI_PLL1PUP0->connectRField (f_FCSI_PLL1PUP0_pup_vvbgen_ppath, 5);

  Attribute* a_FCSI_PLL1PUP0_pup_vvbgen_ppath_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1PUP0_pup_vvbgen_ppath_0_0->setInstName ("0");
  a_FCSI_PLL1PUP0_pup_vvbgen_ppath_0_0->setLongName ("");
  a_FCSI_PLL1PUP0_pup_vvbgen_ppath_0_0->setDescription ("");
  a_FCSI_PLL1PUP0_pup_vvbgen_ppath_0_0->addItem("1", "1'b1", "enable (default)");
  a_FCSI_PLL1PUP0_pup_vvbgen_ppath_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL1PUP0_pup_vvbgen_ppath->connectAttribute (a_FCSI_PLL1PUP0_pup_vvbgen_ppath_0_0);

  RField* f_FCSI_PLL1PUP0_pup_vvbgen_lpath = new RField;
  f_FCSI_PLL1PUP0_pup_vvbgen_lpath->setInstName ("pup_vvbgen_lpath");
  f_FCSI_PLL1PUP0_pup_vvbgen_lpath->setLongName ("PUP VVBGEN LPATH");
  f_FCSI_PLL1PUP0_pup_vvbgen_lpath->setDescription ("Power up for enabling the integrating path in the LPF");
  f_FCSI_PLL1PUP0_pup_vvbgen_lpath->setDataWidth (1);
  f_FCSI_PLL1PUP0_pup_vvbgen_lpath->setResetVal ("1'b0");
  f_FCSI_PLL1PUP0_pup_vvbgen_lpath->setAccProp (AccProp::RW);
  r_FCSI_PLL1PUP0->connectRField (f_FCSI_PLL1PUP0_pup_vvbgen_lpath, 6);

  Attribute* a_FCSI_PLL1PUP0_pup_vvbgen_lpath_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1PUP0_pup_vvbgen_lpath_0_0->setInstName ("0");
  a_FCSI_PLL1PUP0_pup_vvbgen_lpath_0_0->setLongName ("");
  a_FCSI_PLL1PUP0_pup_vvbgen_lpath_0_0->setDescription ("");
  a_FCSI_PLL1PUP0_pup_vvbgen_lpath_0_0->addItem("1", "1'b1", "enable (default)");
  a_FCSI_PLL1PUP0_pup_vvbgen_lpath_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL1PUP0_pup_vvbgen_lpath->connectAttribute (a_FCSI_PLL1PUP0_pup_vvbgen_lpath_0_0);

  RField* f_FCSI_PLL1PUP0_pup_opamp_lpath = new RField;
  f_FCSI_PLL1PUP0_pup_opamp_lpath->setInstName ("pup_opamp_lpath");
  f_FCSI_PLL1PUP0_pup_opamp_lpath->setLongName ("PUP OPAMP LPATH");
  f_FCSI_PLL1PUP0_pup_opamp_lpath->setDescription ("Power up for OpAmps in integrating path of LPF block");
  f_FCSI_PLL1PUP0_pup_opamp_lpath->setDataWidth (1);
  f_FCSI_PLL1PUP0_pup_opamp_lpath->setResetVal ("1'b0");
  f_FCSI_PLL1PUP0_pup_opamp_lpath->setAccProp (AccProp::RW);
  r_FCSI_PLL1PUP0->connectRField (f_FCSI_PLL1PUP0_pup_opamp_lpath, 7);

  Attribute* a_FCSI_PLL1PUP0_pup_opamp_lpath_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1PUP0_pup_opamp_lpath_0_0->setInstName ("0");
  a_FCSI_PLL1PUP0_pup_opamp_lpath_0_0->setLongName ("");
  a_FCSI_PLL1PUP0_pup_opamp_lpath_0_0->setDescription ("");
  a_FCSI_PLL1PUP0_pup_opamp_lpath_0_0->addItem("1", "1'b1", "enable (default)");
  a_FCSI_PLL1PUP0_pup_opamp_lpath_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL1PUP0_pup_opamp_lpath->connectAttribute (a_FCSI_PLL1PUP0_pup_opamp_lpath_0_0);

  RField* f_FCSI_PLL1PUP0_pup_cplp_fbias = new RField;
  f_FCSI_PLL1PUP0_pup_cplp_fbias->setInstName ("pup_cplp_fbias");
  f_FCSI_PLL1PUP0_pup_cplp_fbias->setLongName ("PUP CPLP FBIAS");
  f_FCSI_PLL1PUP0_pup_cplp_fbias->setDescription ("Power up for PDCPLPF Bias circuitry");
  f_FCSI_PLL1PUP0_pup_cplp_fbias->setDataWidth (1);
  f_FCSI_PLL1PUP0_pup_cplp_fbias->setResetVal ("1'b0");
  f_FCSI_PLL1PUP0_pup_cplp_fbias->setAccProp (AccProp::RW);
  r_FCSI_PLL1PUP0->connectRField (f_FCSI_PLL1PUP0_pup_cplp_fbias, 8);

  Attribute* a_FCSI_PLL1PUP0_pup_cplp_fbias_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1PUP0_pup_cplp_fbias_0_0->setInstName ("0");
  a_FCSI_PLL1PUP0_pup_cplp_fbias_0_0->setLongName ("");
  a_FCSI_PLL1PUP0_pup_cplp_fbias_0_0->setDescription ("");
  a_FCSI_PLL1PUP0_pup_cplp_fbias_0_0->addItem("1", "1'b1", "enable (default)");
  a_FCSI_PLL1PUP0_pup_cplp_fbias_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL1PUP0_pup_cplp_fbias->connectAttribute (a_FCSI_PLL1PUP0_pup_cplp_fbias_0_0);

  RField* f_FCSI_PLL1PUP0_bypass_bg_ok = new RField;
  f_FCSI_PLL1PUP0_bypass_bg_ok->setInstName ("bypass_bg_ok");
  f_FCSI_PLL1PUP0_bypass_bg_ok->setLongName ("BYPASS BANDGAPE-OK");
  f_FCSI_PLL1PUP0_bypass_bg_ok->setDescription ("Bypass internal bandgape-OK-signal (required for enabling the regulators)");
  f_FCSI_PLL1PUP0_bypass_bg_ok->setDataWidth (1);
  f_FCSI_PLL1PUP0_bypass_bg_ok->setResetVal ("1'b0");
  f_FCSI_PLL1PUP0_bypass_bg_ok->setAccProp (AccProp::RW);
  r_FCSI_PLL1PUP0->connectRField (f_FCSI_PLL1PUP0_bypass_bg_ok, 9);

  Attribute* a_FCSI_PLL1PUP0_bypass_bg_ok_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1PUP0_bypass_bg_ok_0_0->setInstName ("0");
  a_FCSI_PLL1PUP0_bypass_bg_ok_0_0->setLongName ("");
  a_FCSI_PLL1PUP0_bypass_bg_ok_0_0->setDescription ("");
  a_FCSI_PLL1PUP0_bypass_bg_ok_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_PLL1PUP0_bypass_bg_ok_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL1PUP0_bypass_bg_ok->connectAttribute (a_FCSI_PLL1PUP0_bypass_bg_ok_0_0);

  RField* f_FCSI_PLL1PUP0_fpup_rfpll = new RField;
  f_FCSI_PLL1PUP0_fpup_rfpll->setInstName ("fpup_rfpll");
  f_FCSI_PLL1PUP0_fpup_rfpll->setLongName ("FORCED PUP GLOBAL");
  f_FCSI_PLL1PUP0_fpup_rfpll->setDescription ("Global force power up for RFPLL blocks (higher priority over RFPLL digital power up sequence)");
  f_FCSI_PLL1PUP0_fpup_rfpll->setDataWidth (1);
  f_FCSI_PLL1PUP0_fpup_rfpll->setResetVal ("1'b0");
  f_FCSI_PLL1PUP0_fpup_rfpll->setAccProp (AccProp::RW);
  r_FCSI_PLL1PUP0->connectRField (f_FCSI_PLL1PUP0_fpup_rfpll, 10);

  Attribute* a_FCSI_PLL1PUP0_fpup_rfpll_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1PUP0_fpup_rfpll_0_0->setInstName ("0");
  a_FCSI_PLL1PUP0_fpup_rfpll_0_0->setLongName ("");
  a_FCSI_PLL1PUP0_fpup_rfpll_0_0->setDescription ("");
  a_FCSI_PLL1PUP0_fpup_rfpll_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_PLL1PUP0_fpup_rfpll_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL1PUP0_fpup_rfpll->connectAttribute (a_FCSI_PLL1PUP0_fpup_rfpll_0_0);

  RField* f_FCSI_PLL1PUP0_pup_ldo_ff = new RField;
  f_FCSI_PLL1PUP0_pup_ldo_ff->setInstName ("pup_ldo_ff");
  f_FCSI_PLL1PUP0_pup_ldo_ff->setLongName ("PUP LDO FF");
  f_FCSI_PLL1PUP0_pup_ldo_ff->setDescription ("Power up regulator for feed-forward path - PCCP, LPF");
  f_FCSI_PLL1PUP0_pup_ldo_ff->setDataWidth (1);
  f_FCSI_PLL1PUP0_pup_ldo_ff->setResetVal ("1'b0");
  f_FCSI_PLL1PUP0_pup_ldo_ff->setAccProp (AccProp::RW);
  r_FCSI_PLL1PUP0->connectRField (f_FCSI_PLL1PUP0_pup_ldo_ff, 11);

  Attribute* a_FCSI_PLL1PUP0_pup_ldo_ff_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1PUP0_pup_ldo_ff_0_0->setInstName ("0");
  a_FCSI_PLL1PUP0_pup_ldo_ff_0_0->setLongName ("");
  a_FCSI_PLL1PUP0_pup_ldo_ff_0_0->setDescription ("");
  a_FCSI_PLL1PUP0_pup_ldo_ff_0_0->addItem("1", "1'b1", "enable (default)");
  a_FCSI_PLL1PUP0_pup_ldo_ff_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL1PUP0_pup_ldo_ff->connectAttribute (a_FCSI_PLL1PUP0_pup_ldo_ff_0_0);

  RField* f_FCSI_PLL1PUP0_pup_ldo_fb = new RField;
  f_FCSI_PLL1PUP0_pup_ldo_fb->setInstName ("pup_ldo_fb");
  f_FCSI_PLL1PUP0_pup_ldo_fb->setLongName ("PUP LDO FB");
  f_FCSI_PLL1PUP0_pup_ldo_fb->setDescription ("Power up regulator for feed-back path - DIVN/FCAL");
  f_FCSI_PLL1PUP0_pup_ldo_fb->setDataWidth (1);
  f_FCSI_PLL1PUP0_pup_ldo_fb->setResetVal ("1'b0");
  f_FCSI_PLL1PUP0_pup_ldo_fb->setAccProp (AccProp::RW);
  r_FCSI_PLL1PUP0->connectRField (f_FCSI_PLL1PUP0_pup_ldo_fb, 12);

  Attribute* a_FCSI_PLL1PUP0_pup_ldo_fb_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1PUP0_pup_ldo_fb_0_0->setInstName ("0");
  a_FCSI_PLL1PUP0_pup_ldo_fb_0_0->setLongName ("");
  a_FCSI_PLL1PUP0_pup_ldo_fb_0_0->setDescription ("");
  a_FCSI_PLL1PUP0_pup_ldo_fb_0_0->addItem("1", "1'b1", "enable (default)");
  a_FCSI_PLL1PUP0_pup_ldo_fb_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL1PUP0_pup_ldo_fb->connectAttribute (a_FCSI_PLL1PUP0_pup_ldo_fb_0_0);

  RField* f_FCSI_PLL1PUP0_pup_ldo_xo = new RField;
  f_FCSI_PLL1PUP0_pup_ldo_xo->setInstName ("pup_ldo_xo");
  f_FCSI_PLL1PUP0_pup_ldo_xo->setLongName ("PUP LDO XO");
  f_FCSI_PLL1PUP0_pup_ldo_xo->setDescription ("Power up the clock path in reference block");
  f_FCSI_PLL1PUP0_pup_ldo_xo->setDataWidth (1);
  f_FCSI_PLL1PUP0_pup_ldo_xo->setResetVal ("1'b0");
  f_FCSI_PLL1PUP0_pup_ldo_xo->setAccProp (AccProp::RW);
  r_FCSI_PLL1PUP0->connectRField (f_FCSI_PLL1PUP0_pup_ldo_xo, 13);

  Attribute* a_FCSI_PLL1PUP0_pup_ldo_xo_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1PUP0_pup_ldo_xo_0_0->setInstName ("0");
  a_FCSI_PLL1PUP0_pup_ldo_xo_0_0->setLongName ("");
  a_FCSI_PLL1PUP0_pup_ldo_xo_0_0->setDescription ("");
  a_FCSI_PLL1PUP0_pup_ldo_xo_0_0->addItem("1", "1'b1", "enable (default)");
  a_FCSI_PLL1PUP0_pup_ldo_xo_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL1PUP0_pup_ldo_xo->connectAttribute (a_FCSI_PLL1PUP0_pup_ldo_xo_0_0);

  RField* f_FCSI_PLL1PUP0_pup_ldo_dig = new RField;
  f_FCSI_PLL1PUP0_pup_ldo_dig->setInstName ("pup_ldo_dig");
  f_FCSI_PLL1PUP0_pup_ldo_dig->setLongName ("PUP LDO DIG");
  f_FCSI_PLL1PUP0_pup_ldo_dig->setDescription ("Power up 1.2V LDOs of DIG");
  f_FCSI_PLL1PUP0_pup_ldo_dig->setDataWidth (1);
  f_FCSI_PLL1PUP0_pup_ldo_dig->setResetVal ("1'b0");
  f_FCSI_PLL1PUP0_pup_ldo_dig->setAccProp (AccProp::RW);
  r_FCSI_PLL1PUP0->connectRField (f_FCSI_PLL1PUP0_pup_ldo_dig, 14);

  Attribute* a_FCSI_PLL1PUP0_pup_ldo_dig_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1PUP0_pup_ldo_dig_0_0->setInstName ("0");
  a_FCSI_PLL1PUP0_pup_ldo_dig_0_0->setLongName ("");
  a_FCSI_PLL1PUP0_pup_ldo_dig_0_0->setDescription ("");
  a_FCSI_PLL1PUP0_pup_ldo_dig_0_0->addItem("1", "1'b1", "enable (default)");
  a_FCSI_PLL1PUP0_pup_ldo_dig_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL1PUP0_pup_ldo_dig->connectAttribute (a_FCSI_PLL1PUP0_pup_ldo_dig_0_0);

  RField* f_FCSI_PLL1PUP0_pup_ldo_vco = new RField;
  f_FCSI_PLL1PUP0_pup_ldo_vco->setInstName ("pup_ldo_vco");
  f_FCSI_PLL1PUP0_pup_ldo_vco->setLongName ("PUP LDO VCO");
  f_FCSI_PLL1PUP0_pup_ldo_vco->setDescription ("Power up VCO LDO");
  f_FCSI_PLL1PUP0_pup_ldo_vco->setDataWidth (1);
  f_FCSI_PLL1PUP0_pup_ldo_vco->setResetVal ("1'b0");
  f_FCSI_PLL1PUP0_pup_ldo_vco->setAccProp (AccProp::RW);
  r_FCSI_PLL1PUP0->connectRField (f_FCSI_PLL1PUP0_pup_ldo_vco, 15);

  Attribute* a_FCSI_PLL1PUP0_pup_ldo_vco_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1PUP0_pup_ldo_vco_0_0->setInstName ("0");
  a_FCSI_PLL1PUP0_pup_ldo_vco_0_0->setLongName ("");
  a_FCSI_PLL1PUP0_pup_ldo_vco_0_0->setDescription ("");
  a_FCSI_PLL1PUP0_pup_ldo_vco_0_0->addItem("1", "1'b1", "enable (default)");
  a_FCSI_PLL1PUP0_pup_ldo_vco_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL1PUP0_pup_ldo_vco->connectAttribute (a_FCSI_PLL1PUP0_pup_ldo_vco_0_0);

  Register* r_FCSI_PLL1PMU0 = new Register;
  r_FCSI_PLL1PMU0->setInstName ("PLL1PMU0");
  r_FCSI_PLL1PMU0->setLongName ("PLL1 PMU CENTRAL");
  r_FCSI_PLL1PMU0->setDescription ("FCSI-LDO1V2");
  r_FCSI_PLL1PMU0->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_PLL1PMU0, 0x00000011);

  RField* f_FCSI_PLL1PMU0_diag_disable = new RField;
  f_FCSI_PLL1PMU0_diag_disable->setInstName ("diag_disable");
  f_FCSI_PLL1PMU0_diag_disable->setLongName ("DIAG DISABLE");
  f_FCSI_PLL1PMU0_diag_disable->setDescription ("DIAG disable (diagnostic bus in PLL)");
  f_FCSI_PLL1PMU0_diag_disable->setDataWidth (1);
  f_FCSI_PLL1PMU0_diag_disable->setResetVal ("1'b1");
  f_FCSI_PLL1PMU0_diag_disable->setAccProp (AccProp::RW);
  r_FCSI_PLL1PMU0->connectRField (f_FCSI_PLL1PMU0_diag_disable, 0);

  Attribute* a_FCSI_PLL1PMU0_diag_disable_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1PMU0_diag_disable_0_0->setInstName ("0");
  a_FCSI_PLL1PMU0_diag_disable_0_0->setLongName ("");
  a_FCSI_PLL1PMU0_diag_disable_0_0->setDescription ("");
  a_FCSI_PLL1PMU0_diag_disable_0_0->addItem("1", "1'b1", "disable");
  a_FCSI_PLL1PMU0_diag_disable_0_0->addItem("0", "1'b0", "enable");
  f_FCSI_PLL1PMU0_diag_disable->connectAttribute (a_FCSI_PLL1PMU0_diag_disable_0_0);

  RField* f_FCSI_PLL1PMU0_vcoreg_intref_sel = new RField;
  f_FCSI_PLL1PMU0_vcoreg_intref_sel->setInstName ("vcoreg_intref_sel");
  f_FCSI_PLL1PMU0_vcoreg_intref_sel->setLongName ("VCOREG INTREF SEL");
  f_FCSI_PLL1PMU0_vcoreg_intref_sel->setDescription ("VCOREG internal reference voltage selection");
  f_FCSI_PLL1PMU0_vcoreg_intref_sel->setDataWidth (1);
  f_FCSI_PLL1PMU0_vcoreg_intref_sel->setResetVal ("1'b0");
  f_FCSI_PLL1PMU0_vcoreg_intref_sel->setAccProp (AccProp::RW);
  r_FCSI_PLL1PMU0->connectRField (f_FCSI_PLL1PMU0_vcoreg_intref_sel, 1);

  Attribute* a_FCSI_PLL1PMU0_vcoreg_intref_sel_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1PMU0_vcoreg_intref_sel_0_0->setInstName ("0");
  a_FCSI_PLL1PMU0_vcoreg_intref_sel_0_0->setLongName ("");
  a_FCSI_PLL1PMU0_vcoreg_intref_sel_0_0->setDescription ("");
  a_FCSI_PLL1PMU0_vcoreg_intref_sel_0_0->addItem("1", "1'b1", "Internal reference (default)");
  a_FCSI_PLL1PMU0_vcoreg_intref_sel_0_0->addItem("0", "1'b0", "BG reference");
  f_FCSI_PLL1PMU0_vcoreg_intref_sel->connectAttribute (a_FCSI_PLL1PMU0_vcoreg_intref_sel_0_0);

  RField* f_FCSI_PLL1PMU0_reg_lo_sel = new RField;
  f_FCSI_PLL1PMU0_reg_lo_sel->setInstName ("reg_lo_sel");
  f_FCSI_PLL1PMU0_reg_lo_sel->setLongName ("REG LO SEL");
  f_FCSI_PLL1PMU0_reg_lo_sel->setDescription ("Bump bits for LOPATH LDO");
  f_FCSI_PLL1PMU0_reg_lo_sel->setDataWidth (3);
  f_FCSI_PLL1PMU0_reg_lo_sel->setResetVal ("3'b000");
  f_FCSI_PLL1PMU0_reg_lo_sel->setAccProp (AccProp::RW);
  r_FCSI_PLL1PMU0->connectRField (f_FCSI_PLL1PMU0_reg_lo_sel, 2);

  Attribute* a_FCSI_PLL1PMU0_reg_lo_sel_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1PMU0_reg_lo_sel_0_0->setInstName ("0");
  a_FCSI_PLL1PMU0_reg_lo_sel_0_0->setLongName ("");
  a_FCSI_PLL1PMU0_reg_lo_sel_0_0->setDescription ("");
  a_FCSI_PLL1PMU0_reg_lo_sel_0_0->addItem("0", "3'b000", "1.193");
  a_FCSI_PLL1PMU0_reg_lo_sel_0_0->addItem("1", "3'b001", "1.225");
  a_FCSI_PLL1PMU0_reg_lo_sel_0_0->addItem("2", "3'b010", "1.258 (2G mode)");
  a_FCSI_PLL1PMU0_reg_lo_sel_0_0->addItem("3", "3'b011", "1.293");
  a_FCSI_PLL1PMU0_reg_lo_sel_0_0->addItem("4", "3'b100", "1.331");
  a_FCSI_PLL1PMU0_reg_lo_sel_0_0->addItem("5", "3'b101", "1.370 (HP/RP mode)");
  a_FCSI_PLL1PMU0_reg_lo_sel_0_0->addItem("6", "3'b110", "1.412");
  a_FCSI_PLL1PMU0_reg_lo_sel_0_0->addItem("7", "3'b111", "1.456");
  f_FCSI_PLL1PMU0_reg_lo_sel->connectAttribute (a_FCSI_PLL1PMU0_reg_lo_sel_0_0);

  RField* f_FCSI_PLL1PMU0_ldo_dig_sel = new RField;
  f_FCSI_PLL1PMU0_ldo_dig_sel->setInstName ("ldo_dig_sel");
  f_FCSI_PLL1PMU0_ldo_dig_sel->setLongName ("LDO DIG SEL");
  f_FCSI_PLL1PMU0_ldo_dig_sel->setDescription ("Bump bits for DIGREG and CPREG");
  f_FCSI_PLL1PMU0_ldo_dig_sel->setDataWidth (3);
  f_FCSI_PLL1PMU0_ldo_dig_sel->setResetVal ("3'b000");
  f_FCSI_PLL1PMU0_ldo_dig_sel->setAccProp (AccProp::RW);
  r_FCSI_PLL1PMU0->connectRField (f_FCSI_PLL1PMU0_ldo_dig_sel, 5);

  Attribute* a_FCSI_PLL1PMU0_ldo_dig_sel_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1PMU0_ldo_dig_sel_0_0->setInstName ("0");
  a_FCSI_PLL1PMU0_ldo_dig_sel_0_0->setLongName ("");
  a_FCSI_PLL1PMU0_ldo_dig_sel_0_0->setDescription ("");
  a_FCSI_PLL1PMU0_ldo_dig_sel_0_0->addItem("0", "3'b000", "1.193");
  a_FCSI_PLL1PMU0_ldo_dig_sel_0_0->addItem("1", "3'b001", "1.217");
  a_FCSI_PLL1PMU0_ldo_dig_sel_0_0->addItem("2", "3'b010", "1.241");
  a_FCSI_PLL1PMU0_ldo_dig_sel_0_0->addItem("3", "3'b011", "1.267");
  a_FCSI_PLL1PMU0_ldo_dig_sel_0_0->addItem("4", "3'b100", "1.293 (default)");
  a_FCSI_PLL1PMU0_ldo_dig_sel_0_0->addItem("5", "3'b101", "1.321");
  a_FCSI_PLL1PMU0_ldo_dig_sel_0_0->addItem("6", "3'b110", "1.350");
  a_FCSI_PLL1PMU0_ldo_dig_sel_0_0->addItem("7", "3'b111", "1.380");
  f_FCSI_PLL1PMU0_ldo_dig_sel->connectAttribute (a_FCSI_PLL1PMU0_ldo_dig_sel_0_0);

  RField* f_FCSI_PLL1PMU0_bump_ibias = new RField;
  f_FCSI_PLL1PMU0_bump_ibias->setInstName ("bump_ibias");
  f_FCSI_PLL1PMU0_bump_ibias->setLongName ("BUMP IBIAS");
  f_FCSI_PLL1PMU0_bump_ibias->setDescription ("Bump bits for central I-Bias block");
  f_FCSI_PLL1PMU0_bump_ibias->setDataWidth (2);
  f_FCSI_PLL1PMU0_bump_ibias->setResetVal ("2'b00");
  f_FCSI_PLL1PMU0_bump_ibias->setAccProp (AccProp::RW);
  r_FCSI_PLL1PMU0->connectRField (f_FCSI_PLL1PMU0_bump_ibias, 8);

  Attribute* a_FCSI_PLL1PMU0_bump_ibias_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1PMU0_bump_ibias_0_0->setInstName ("0");
  a_FCSI_PLL1PMU0_bump_ibias_0_0->setLongName ("");
  a_FCSI_PLL1PMU0_bump_ibias_0_0->setDescription ("");
  a_FCSI_PLL1PMU0_bump_ibias_0_0->addItem("0", "2'b00", "10u");
  a_FCSI_PLL1PMU0_bump_ibias_0_0->addItem("1", "2'b01", " 9u");
  a_FCSI_PLL1PMU0_bump_ibias_0_0->addItem("2", "2'b10", "11u");
  a_FCSI_PLL1PMU0_bump_ibias_0_0->addItem("3", "2'b11", "12u");
  f_FCSI_PLL1PMU0_bump_ibias->connectAttribute (a_FCSI_PLL1PMU0_bump_ibias_0_0);

  RField* f_FCSI_PLL1PMU0_ldo_vco_sel = new RField;
  f_FCSI_PLL1PMU0_ldo_vco_sel->setInstName ("ldo_vco_sel");
  f_FCSI_PLL1PMU0_ldo_vco_sel->setLongName ("LDO VCO SEL");
  f_FCSI_PLL1PMU0_ldo_vco_sel->setDescription ("Bump bits for VCO LDO");
  f_FCSI_PLL1PMU0_ldo_vco_sel->setDataWidth (3);
  f_FCSI_PLL1PMU0_ldo_vco_sel->setResetVal ("3'b000");
  f_FCSI_PLL1PMU0_ldo_vco_sel->setAccProp (AccProp::RW);
  r_FCSI_PLL1PMU0->connectRField (f_FCSI_PLL1PMU0_ldo_vco_sel, 10);

  Attribute* a_FCSI_PLL1PMU0_ldo_vco_sel_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1PMU0_ldo_vco_sel_0_0->setInstName ("0");
  a_FCSI_PLL1PMU0_ldo_vco_sel_0_0->setLongName ("");
  a_FCSI_PLL1PMU0_ldo_vco_sel_0_0->setDescription ("");
  a_FCSI_PLL1PMU0_ldo_vco_sel_0_0->addItem("0", "3'b000", "1.695 (HP mode)");
  a_FCSI_PLL1PMU0_ldo_vco_sel_0_0->addItem("1", "3'b001", "1.743");
  a_FCSI_PLL1PMU0_ldo_vco_sel_0_0->addItem("2", "3'b010", "1.850");
  a_FCSI_PLL1PMU0_ldo_vco_sel_0_0->addItem("3", "3'b011", "1.908");
  a_FCSI_PLL1PMU0_ldo_vco_sel_0_0->addItem("4", "3'b100", "1.417 (RP mode)");
  a_FCSI_PLL1PMU0_ldo_vco_sel_0_0->addItem("5", "3'b101", "1.487");
  a_FCSI_PLL1PMU0_ldo_vco_sel_0_0->addItem("6", "3'b110", "1.563");
  a_FCSI_PLL1PMU0_ldo_vco_sel_0_0->addItem("7", "3'b111", "1.648");
  f_FCSI_PLL1PMU0_ldo_vco_sel->connectAttribute (a_FCSI_PLL1PMU0_ldo_vco_sel_0_0);

  RField* f_FCSI_PLL1PMU0_bg_sel = new RField;
  f_FCSI_PLL1PMU0_bg_sel->setInstName ("bg_sel");
  f_FCSI_PLL1PMU0_bg_sel->setLongName ("BG SEL");
  f_FCSI_PLL1PMU0_bg_sel->setDescription ("Bump bits for Bandgape Voltage");
  f_FCSI_PLL1PMU0_bg_sel->setDataWidth (3);
  f_FCSI_PLL1PMU0_bg_sel->setResetVal ("3'b000");
  f_FCSI_PLL1PMU0_bg_sel->setAccProp (AccProp::RW);
  r_FCSI_PLL1PMU0->connectRField (f_FCSI_PLL1PMU0_bg_sel, 13);

  Attribute* a_FCSI_PLL1PMU0_bg_sel_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1PMU0_bg_sel_0_0->setInstName ("0");
  a_FCSI_PLL1PMU0_bg_sel_0_0->setLongName ("");
  a_FCSI_PLL1PMU0_bg_sel_0_0->setDescription ("");
  a_FCSI_PLL1PMU0_bg_sel_0_0->addItem("0", "3'b000", "1.193");
  a_FCSI_PLL1PMU0_bg_sel_0_0->addItem("1", "3'b001", "1.201");
  a_FCSI_PLL1PMU0_bg_sel_0_0->addItem("2", "3'b010", "1.210");
  a_FCSI_PLL1PMU0_bg_sel_0_0->addItem("3", "3'b011", "1.219");
  a_FCSI_PLL1PMU0_bg_sel_0_0->addItem("4", "3'b100", "1.227");
  a_FCSI_PLL1PMU0_bg_sel_0_0->addItem("5", "3'b101", "1.185");
  a_FCSI_PLL1PMU0_bg_sel_0_0->addItem("6", "3'b110", "1.176");
  a_FCSI_PLL1PMU0_bg_sel_0_0->addItem("7", "3'b111", "1.172");
  f_FCSI_PLL1PMU0_bg_sel->connectAttribute (a_FCSI_PLL1PMU0_bg_sel_0_0);

  Register* r_FCSI_PLL1PMU1 = new Register;
  r_FCSI_PLL1PMU1->setInstName ("PLL1PMU1");
  r_FCSI_PLL1PMU1->setLongName ("PLL1 PMU DIAG CONTROL");
  r_FCSI_PLL1PMU1->setDescription ("FCSI-LDO1V2");
  r_FCSI_PLL1PMU1->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_PLL1PMU1, 0x00000012);

  RField* f_FCSI_PLL1PMU1_diag_sel = new RField;
  f_FCSI_PLL1PMU1_diag_sel->setInstName ("diag_sel");
  f_FCSI_PLL1PMU1_diag_sel->setLongName ("DIAG SEL");
  f_FCSI_PLL1PMU1_diag_sel->setDescription ("Analog diagnostic module select");
  f_FCSI_PLL1PMU1_diag_sel->setDataWidth (4);
  f_FCSI_PLL1PMU1_diag_sel->setResetVal ("4'b0000");
  f_FCSI_PLL1PMU1_diag_sel->setAccProp (AccProp::RW);
  r_FCSI_PLL1PMU1->connectRField (f_FCSI_PLL1PMU1_diag_sel, 0);

  Attribute* a_FCSI_PLL1PMU1_diag_sel_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1PMU1_diag_sel_0_0->setInstName ("0");
  a_FCSI_PLL1PMU1_diag_sel_0_0->setLongName ("");
  a_FCSI_PLL1PMU1_diag_sel_0_0->setDescription ("");
  a_FCSI_PLL1PMU1_diag_sel_0_0->addItem("0", "4'b0000", "Not used");
  a_FCSI_PLL1PMU1_diag_sel_0_0->addItem("1", "4'b0001", "BG");
  a_FCSI_PLL1PMU1_diag_sel_0_0->addItem("2", "4'b0010", "DIG REG");
  a_FCSI_PLL1PMU1_diag_sel_0_0->addItem("3", "4'b0011", "LPF REG");
  a_FCSI_PLL1PMU1_diag_sel_0_0->addItem("4", "4'b0100", "XO REG");
  a_FCSI_PLL1PMU1_diag_sel_0_0->addItem("5", "4'b0101", "FB REG");
  a_FCSI_PLL1PMU1_diag_sel_0_0->addItem("6", "4'b0110", "CP REG");
  a_FCSI_PLL1PMU1_diag_sel_0_0->addItem("7", "4'b0111", "VCO REG");
  a_FCSI_PLL1PMU1_diag_sel_0_0->addItem("8", "4'b1000", "LOREG");
  a_FCSI_PLL1PMU1_diag_sel_0_0->addItem("9", "4'b1001", "LPF_IPATH");
  a_FCSI_PLL1PMU1_diag_sel_0_0->addItem("10", "4'b1010", "LPF_PPATH");
  a_FCSI_PLL1PMU1_diag_sel_0_0->addItem("11", "4'b1011", "SHUNT REG");
  a_FCSI_PLL1PMU1_diag_sel_0_0->addItem("12", "4'b1100", "---");
  a_FCSI_PLL1PMU1_diag_sel_0_0->addItem("13", "4'b1101", "PDREG");
  a_FCSI_PLL1PMU1_diag_sel_0_0->addItem("14", "4'b1110", "---");
  a_FCSI_PLL1PMU1_diag_sel_0_0->addItem("15", "4'b1111", "---");
  f_FCSI_PLL1PMU1_diag_sel->connectAttribute (a_FCSI_PLL1PMU1_diag_sel_0_0);

  RField* f_FCSI_PLL1PMU1_diag_code = new RField;
  f_FCSI_PLL1PMU1_diag_code->setInstName ("diag_code");
  f_FCSI_PLL1PMU1_diag_code->setLongName ("DIAG CODE");
  f_FCSI_PLL1PMU1_diag_code->setDescription ("Analog diagnostic code value");
  f_FCSI_PLL1PMU1_diag_code->setDataWidth (3);
  f_FCSI_PLL1PMU1_diag_code->setResetVal ("3'b000");
  f_FCSI_PLL1PMU1_diag_code->setAccProp (AccProp::RW);
  r_FCSI_PLL1PMU1->connectRField (f_FCSI_PLL1PMU1_diag_code, 4);

  RField* f_FCSI_PLL1PMU1_ldo_xo_sel = new RField;
  f_FCSI_PLL1PMU1_ldo_xo_sel->setInstName ("ldo_xo_sel");
  f_FCSI_PLL1PMU1_ldo_xo_sel->setLongName ("LDO XO SEL");
  f_FCSI_PLL1PMU1_ldo_xo_sel->setDescription ("Program output voltage for XOREG and PFDREG");
  f_FCSI_PLL1PMU1_ldo_xo_sel->setDataWidth (3);
  f_FCSI_PLL1PMU1_ldo_xo_sel->setResetVal ("3'b000");
  f_FCSI_PLL1PMU1_ldo_xo_sel->setAccProp (AccProp::RW);
  r_FCSI_PLL1PMU1->connectRField (f_FCSI_PLL1PMU1_ldo_xo_sel, 7);

  Attribute* a_FCSI_PLL1PMU1_ldo_xo_sel_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1PMU1_ldo_xo_sel_0_0->setInstName ("0");
  a_FCSI_PLL1PMU1_ldo_xo_sel_0_0->setLongName ("");
  a_FCSI_PLL1PMU1_ldo_xo_sel_0_0->setDescription ("");
  a_FCSI_PLL1PMU1_ldo_xo_sel_0_0->addItem("0", "3'b000", "1.193");
  a_FCSI_PLL1PMU1_ldo_xo_sel_0_0->addItem("1", "3'b001", "1.217");
  a_FCSI_PLL1PMU1_ldo_xo_sel_0_0->addItem("2", "3'b010", "1.241");
  a_FCSI_PLL1PMU1_ldo_xo_sel_0_0->addItem("3", "3'b011", "1.267");
  a_FCSI_PLL1PMU1_ldo_xo_sel_0_0->addItem("4", "3'b100", "1.293 (default)");
  a_FCSI_PLL1PMU1_ldo_xo_sel_0_0->addItem("5", "3'b101", "1.321");
  a_FCSI_PLL1PMU1_ldo_xo_sel_0_0->addItem("6", "3'b110", "1.350");
  a_FCSI_PLL1PMU1_ldo_xo_sel_0_0->addItem("7", "3'b111", "1.380");
  f_FCSI_PLL1PMU1_ldo_xo_sel->connectAttribute (a_FCSI_PLL1PMU1_ldo_xo_sel_0_0);

  RField* f_FCSI_PLL1PMU1_ldo_resync_sel = new RField;
  f_FCSI_PLL1PMU1_ldo_resync_sel->setInstName ("ldo_resync_sel");
  f_FCSI_PLL1PMU1_ldo_resync_sel->setLongName ("LDO RESYNC SEL");
  f_FCSI_PLL1PMU1_ldo_resync_sel->setDescription ("Program output voltage fo DIVN, FCAL and RESYNC");
  f_FCSI_PLL1PMU1_ldo_resync_sel->setDataWidth (3);
  f_FCSI_PLL1PMU1_ldo_resync_sel->setResetVal ("3'b000");
  f_FCSI_PLL1PMU1_ldo_resync_sel->setAccProp (AccProp::RW);
  r_FCSI_PLL1PMU1->connectRField (f_FCSI_PLL1PMU1_ldo_resync_sel, 10);

  Attribute* a_FCSI_PLL1PMU1_ldo_resync_sel_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1PMU1_ldo_resync_sel_0_0->setInstName ("0");
  a_FCSI_PLL1PMU1_ldo_resync_sel_0_0->setLongName ("");
  a_FCSI_PLL1PMU1_ldo_resync_sel_0_0->setDescription ("");
  a_FCSI_PLL1PMU1_ldo_resync_sel_0_0->addItem("0", "3'b000", "1.193");
  a_FCSI_PLL1PMU1_ldo_resync_sel_0_0->addItem("1", "3'b001", "1.217");
  a_FCSI_PLL1PMU1_ldo_resync_sel_0_0->addItem("2", "3'b010", "1.241");
  a_FCSI_PLL1PMU1_ldo_resync_sel_0_0->addItem("3", "3'b011", "1.267");
  a_FCSI_PLL1PMU1_ldo_resync_sel_0_0->addItem("4", "3'b100", "1.293 (default)");
  a_FCSI_PLL1PMU1_ldo_resync_sel_0_0->addItem("5", "3'b101", "1.321");
  a_FCSI_PLL1PMU1_ldo_resync_sel_0_0->addItem("6", "3'b110", "1.350");
  a_FCSI_PLL1PMU1_ldo_resync_sel_0_0->addItem("7", "3'b111", "1.380");
  f_FCSI_PLL1PMU1_ldo_resync_sel->connectAttribute (a_FCSI_PLL1PMU1_ldo_resync_sel_0_0);

  RField* f_FCSI_PLL1PMU1_ldo_ff_sel = new RField;
  f_FCSI_PLL1PMU1_ldo_ff_sel->setInstName ("ldo_ff_sel");
  f_FCSI_PLL1PMU1_ldo_ff_sel->setLongName ("LDO FF SEL");
  f_FCSI_PLL1PMU1_ldo_ff_sel->setDescription ("Program output voltage of LPFREG");
  f_FCSI_PLL1PMU1_ldo_ff_sel->setDataWidth (3);
  f_FCSI_PLL1PMU1_ldo_ff_sel->setResetVal ("3'b000");
  f_FCSI_PLL1PMU1_ldo_ff_sel->setAccProp (AccProp::RW);
  r_FCSI_PLL1PMU1->connectRField (f_FCSI_PLL1PMU1_ldo_ff_sel, 13);

  Attribute* a_FCSI_PLL1PMU1_ldo_ff_sel_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1PMU1_ldo_ff_sel_0_0->setInstName ("0");
  a_FCSI_PLL1PMU1_ldo_ff_sel_0_0->setLongName ("");
  a_FCSI_PLL1PMU1_ldo_ff_sel_0_0->setDescription ("");
  a_FCSI_PLL1PMU1_ldo_ff_sel_0_0->addItem("0", "3'b000", "1.572");
  a_FCSI_PLL1PMU1_ldo_ff_sel_0_0->addItem("1", "3'b001", "1.603");
  a_FCSI_PLL1PMU1_ldo_ff_sel_0_0->addItem("2", "3'b010", "1.636");
  a_FCSI_PLL1PMU1_ldo_ff_sel_0_0->addItem("3", "3'b011", "1.669");
  a_FCSI_PLL1PMU1_ldo_ff_sel_0_0->addItem("4", "3'b100", "1.704 (default)");
  a_FCSI_PLL1PMU1_ldo_ff_sel_0_0->addItem("5", "3'b101", "1.741");
  a_FCSI_PLL1PMU1_ldo_ff_sel_0_0->addItem("6", "3'b110", "1.779");
  a_FCSI_PLL1PMU1_ldo_ff_sel_0_0->addItem("7", "3'b111", "1.819");
  f_FCSI_PLL1PMU1_ldo_ff_sel->connectAttribute (a_FCSI_PLL1PMU1_ldo_ff_sel_0_0);

  Register* r_FCSI_PLL1PUP1 = new Register;
  r_FCSI_PLL1PUP1->setInstName ("PLL1PUP1");
  r_FCSI_PLL1PUP1->setLongName ("PLL1 POWER UP LOCAL");
  r_FCSI_PLL1PUP1->setDescription ("PLL1-LDO1V2");
  r_FCSI_PLL1PUP1->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_PLL1PUP1, 0x00000013);

  RField* f_FCSI_PLL1PUP1_rfpll_resetn = new RField;
  f_FCSI_PLL1PUP1_rfpll_resetn->setInstName ("rfpll_resetn");
  f_FCSI_PLL1PUP1_rfpll_resetn->setLongName ("RFPLL RESETN");
  f_FCSI_PLL1PUP1_rfpll_resetn->setDescription ("Reset release starts PLL operation (negative logic 0->1)");
  f_FCSI_PLL1PUP1_rfpll_resetn->setDataWidth (1);
  f_FCSI_PLL1PUP1_rfpll_resetn->setResetVal ("1'b0");
  f_FCSI_PLL1PUP1_rfpll_resetn->setAccProp (AccProp::RW);
  r_FCSI_PLL1PUP1->connectRField (f_FCSI_PLL1PUP1_rfpll_resetn, 2);

  Attribute* a_FCSI_PLL1PUP1_rfpll_resetn_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1PUP1_rfpll_resetn_0_0->setInstName ("0");
  a_FCSI_PLL1PUP1_rfpll_resetn_0_0->setLongName ("");
  a_FCSI_PLL1PUP1_rfpll_resetn_0_0->setDescription ("");
  a_FCSI_PLL1PUP1_rfpll_resetn_0_0->addItem("1", "1'b0", "RFPLL digital in reset state");
  a_FCSI_PLL1PUP1_rfpll_resetn_0_0->addItem("0", "1'b1", "Release RFPLL");
  f_FCSI_PLL1PUP1_rfpll_resetn->connectAttribute (a_FCSI_PLL1PUP1_rfpll_resetn_0_0);

  RField* f_FCSI_PLL1PUP1_fpd_lsbuff_op = new RField;
  f_FCSI_PLL1PUP1_fpd_lsbuff_op->setInstName ("fpd_lsbuff_op");
  f_FCSI_PLL1PUP1_fpd_lsbuff_op->setLongName ("FPD LSBUFF OP");
  f_FCSI_PLL1PUP1_fpd_lsbuff_op->setDescription ("Force Power Down the 3G buffer supplying the IQ outputs for 2.5G mode");
  f_FCSI_PLL1PUP1_fpd_lsbuff_op->setDataWidth (1);
  f_FCSI_PLL1PUP1_fpd_lsbuff_op->setResetVal ("1'b0");
  f_FCSI_PLL1PUP1_fpd_lsbuff_op->setAccProp (AccProp::RW);
  r_FCSI_PLL1PUP1->connectRField (f_FCSI_PLL1PUP1_fpd_lsbuff_op, 3);

  Attribute* a_FCSI_PLL1PUP1_fpd_lsbuff_op_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1PUP1_fpd_lsbuff_op_0_0->setInstName ("0");
  a_FCSI_PLL1PUP1_fpd_lsbuff_op_0_0->setLongName ("");
  a_FCSI_PLL1PUP1_fpd_lsbuff_op_0_0->setDescription ("");
  a_FCSI_PLL1PUP1_fpd_lsbuff_op_0_0->addItem("1", "1'b1", "enable (HP/RP mode)");
  a_FCSI_PLL1PUP1_fpd_lsbuff_op_0_0->addItem("0", "1'b0", "disable (2G mode)");
  f_FCSI_PLL1PUP1_fpd_lsbuff_op->connectAttribute (a_FCSI_PLL1PUP1_fpd_lsbuff_op_0_0);

  RField* f_FCSI_PLL1PUP1_fpd_hsbuff_op = new RField;
  f_FCSI_PLL1PUP1_fpd_hsbuff_op->setInstName ("fpd_hsbuff_op");
  f_FCSI_PLL1PUP1_fpd_hsbuff_op->setLongName ("FPD HSBUFF OP");
  f_FCSI_PLL1PUP1_fpd_hsbuff_op->setDescription ("Force power down the 12G buffer driving the 12G to 6G divider");
  f_FCSI_PLL1PUP1_fpd_hsbuff_op->setDataWidth (1);
  f_FCSI_PLL1PUP1_fpd_hsbuff_op->setResetVal ("1'b0");
  f_FCSI_PLL1PUP1_fpd_hsbuff_op->setAccProp (AccProp::RW);
  r_FCSI_PLL1PUP1->connectRField (f_FCSI_PLL1PUP1_fpd_hsbuff_op, 4);

  Attribute* a_FCSI_PLL1PUP1_fpd_hsbuff_op_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1PUP1_fpd_hsbuff_op_0_0->setInstName ("0");
  a_FCSI_PLL1PUP1_fpd_hsbuff_op_0_0->setLongName ("");
  a_FCSI_PLL1PUP1_fpd_hsbuff_op_0_0->setDescription ("");
  a_FCSI_PLL1PUP1_fpd_hsbuff_op_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_PLL1PUP1_fpd_hsbuff_op_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL1PUP1_fpd_hsbuff_op->connectAttribute (a_FCSI_PLL1PUP1_fpd_hsbuff_op_0_0);

  RField* f_FCSI_PLL1PUP1_fpd_fbbuff = new RField;
  f_FCSI_PLL1PUP1_fpd_fbbuff->setInstName ("fpd_fbbuff");
  f_FCSI_PLL1PUP1_fpd_fbbuff->setLongName ("FPD FBBUFF");
  f_FCSI_PLL1PUP1_fpd_fbbuff->setDescription ("Force Power Down the 6G to 3G dividers and the 3G buffer supplying FCAL");
  f_FCSI_PLL1PUP1_fpd_fbbuff->setDataWidth (1);
  f_FCSI_PLL1PUP1_fpd_fbbuff->setResetVal ("1'b0");
  f_FCSI_PLL1PUP1_fpd_fbbuff->setAccProp (AccProp::RW);
  r_FCSI_PLL1PUP1->connectRField (f_FCSI_PLL1PUP1_fpd_fbbuff, 5);

  Attribute* a_FCSI_PLL1PUP1_fpd_fbbuff_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1PUP1_fpd_fbbuff_0_0->setInstName ("0");
  a_FCSI_PLL1PUP1_fpd_fbbuff_0_0->setLongName ("");
  a_FCSI_PLL1PUP1_fpd_fbbuff_0_0->setDescription ("");
  a_FCSI_PLL1PUP1_fpd_fbbuff_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_PLL1PUP1_fpd_fbbuff_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL1PUP1_fpd_fbbuff->connectAttribute (a_FCSI_PLL1PUP1_fpd_fbbuff_0_0);

  RField* f_FCSI_PLL1PUP1_fpd_lsbuff_fb = new RField;
  f_FCSI_PLL1PUP1_fpd_lsbuff_fb->setInstName ("fpd_lsbuff_fb");
  f_FCSI_PLL1PUP1_fpd_lsbuff_fb->setLongName ("FPD LSBUFF FB");
  f_FCSI_PLL1PUP1_fpd_lsbuff_fb->setDescription ("Force power down the 6G output buffers, driving the 6G I/Q outputs");
  f_FCSI_PLL1PUP1_fpd_lsbuff_fb->setDataWidth (1);
  f_FCSI_PLL1PUP1_fpd_lsbuff_fb->setResetVal ("1'b0");
  f_FCSI_PLL1PUP1_fpd_lsbuff_fb->setAccProp (AccProp::RW);
  r_FCSI_PLL1PUP1->connectRField (f_FCSI_PLL1PUP1_fpd_lsbuff_fb, 6);

  Attribute* a_FCSI_PLL1PUP1_fpd_lsbuff_fb_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1PUP1_fpd_lsbuff_fb_0_0->setInstName ("0");
  a_FCSI_PLL1PUP1_fpd_lsbuff_fb_0_0->setLongName ("");
  a_FCSI_PLL1PUP1_fpd_lsbuff_fb_0_0->setDescription ("");
  a_FCSI_PLL1PUP1_fpd_lsbuff_fb_0_0->addItem("1", "1'b1", "enable (2G mode)");
  a_FCSI_PLL1PUP1_fpd_lsbuff_fb_0_0->addItem("0", "1'b0", "disable (HP/RP mode)");
  f_FCSI_PLL1PUP1_fpd_lsbuff_fb->connectAttribute (a_FCSI_PLL1PUP1_fpd_lsbuff_fb_0_0);

  RField* f_FCSI_PLL1PUP1_fpd_lsbuff = new RField;
  f_FCSI_PLL1PUP1_fpd_lsbuff->setInstName ("fpd_lsbuff");
  f_FCSI_PLL1PUP1_fpd_lsbuff->setLongName ("FPD LSBUFF");
  f_FCSI_PLL1PUP1_fpd_lsbuff->setDescription ("Force Power Down the 6G buffers after the 12Gto6G divider");
  f_FCSI_PLL1PUP1_fpd_lsbuff->setDataWidth (1);
  f_FCSI_PLL1PUP1_fpd_lsbuff->setResetVal ("1'b0");
  f_FCSI_PLL1PUP1_fpd_lsbuff->setAccProp (AccProp::RW);
  r_FCSI_PLL1PUP1->connectRField (f_FCSI_PLL1PUP1_fpd_lsbuff, 7);

  Attribute* a_FCSI_PLL1PUP1_fpd_lsbuff_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1PUP1_fpd_lsbuff_0_0->setInstName ("0");
  a_FCSI_PLL1PUP1_fpd_lsbuff_0_0->setLongName ("");
  a_FCSI_PLL1PUP1_fpd_lsbuff_0_0->setDescription ("");
  a_FCSI_PLL1PUP1_fpd_lsbuff_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_PLL1PUP1_fpd_lsbuff_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL1PUP1_fpd_lsbuff->connectAttribute (a_FCSI_PLL1PUP1_fpd_lsbuff_0_0);

  RField* f_FCSI_PLL1PUP1_fpd_hsdiv = new RField;
  f_FCSI_PLL1PUP1_fpd_hsdiv->setInstName ("fpd_hsdiv");
  f_FCSI_PLL1PUP1_fpd_hsdiv->setLongName ("FPD HSDIV");
  f_FCSI_PLL1PUP1_fpd_hsdiv->setDescription ("Force Power Down the 12G to 6G divider");
  f_FCSI_PLL1PUP1_fpd_hsdiv->setDataWidth (1);
  f_FCSI_PLL1PUP1_fpd_hsdiv->setResetVal ("1'b0");
  f_FCSI_PLL1PUP1_fpd_hsdiv->setAccProp (AccProp::RW);
  r_FCSI_PLL1PUP1->connectRField (f_FCSI_PLL1PUP1_fpd_hsdiv, 8);

  Attribute* a_FCSI_PLL1PUP1_fpd_hsdiv_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1PUP1_fpd_hsdiv_0_0->setInstName ("0");
  a_FCSI_PLL1PUP1_fpd_hsdiv_0_0->setLongName ("");
  a_FCSI_PLL1PUP1_fpd_hsdiv_0_0->setDescription ("");
  a_FCSI_PLL1PUP1_fpd_hsdiv_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_PLL1PUP1_fpd_hsdiv_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL1PUP1_fpd_hsdiv->connectAttribute (a_FCSI_PLL1PUP1_fpd_hsdiv_0_0);

  RField* f_FCSI_PLL1PUP1_fpd_hsbuff = new RField;
  f_FCSI_PLL1PUP1_fpd_hsbuff->setInstName ("fpd_hsbuff");
  f_FCSI_PLL1PUP1_fpd_hsbuff->setLongName ("FPD HSBUFF");
  f_FCSI_PLL1PUP1_fpd_hsbuff->setDescription ("Force Power Down the high speed 12G buffer connected to DivN. It controls the signal pup_12Gbuf_divn in lopath");
  f_FCSI_PLL1PUP1_fpd_hsbuff->setDataWidth (1);
  f_FCSI_PLL1PUP1_fpd_hsbuff->setResetVal ("1'b0");
  f_FCSI_PLL1PUP1_fpd_hsbuff->setAccProp (AccProp::RW);
  r_FCSI_PLL1PUP1->connectRField (f_FCSI_PLL1PUP1_fpd_hsbuff, 9);

  Attribute* a_FCSI_PLL1PUP1_fpd_hsbuff_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1PUP1_fpd_hsbuff_0_0->setInstName ("0");
  a_FCSI_PLL1PUP1_fpd_hsbuff_0_0->setLongName ("");
  a_FCSI_PLL1PUP1_fpd_hsbuff_0_0->setDescription ("");
  a_FCSI_PLL1PUP1_fpd_hsbuff_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_PLL1PUP1_fpd_hsbuff_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL1PUP1_fpd_hsbuff->connectAttribute (a_FCSI_PLL1PUP1_fpd_hsbuff_0_0);

  RField* f_FCSI_PLL1PUP1_fpd_fcal = new RField;
  f_FCSI_PLL1PUP1_fpd_fcal->setInstName ("fpd_fcal");
  f_FCSI_PLL1PUP1_fpd_fcal->setLongName ("FPD FCAL");
  f_FCSI_PLL1PUP1_fpd_fcal->setDescription ("Force Power Down the freq calibration block in analog domain (debug bit)");
  f_FCSI_PLL1PUP1_fpd_fcal->setDataWidth (1);
  f_FCSI_PLL1PUP1_fpd_fcal->setResetVal ("1'b0");
  f_FCSI_PLL1PUP1_fpd_fcal->setAccProp (AccProp::RW);
  r_FCSI_PLL1PUP1->connectRField (f_FCSI_PLL1PUP1_fpd_fcal, 10);

  Attribute* a_FCSI_PLL1PUP1_fpd_fcal_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1PUP1_fpd_fcal_0_0->setInstName ("0");
  a_FCSI_PLL1PUP1_fpd_fcal_0_0->setLongName ("");
  a_FCSI_PLL1PUP1_fpd_fcal_0_0->setDescription ("");
  a_FCSI_PLL1PUP1_fpd_fcal_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_PLL1PUP1_fpd_fcal_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL1PUP1_fpd_fcal->connectAttribute (a_FCSI_PLL1PUP1_fpd_fcal_0_0);

  RField* f_FCSI_PLL1PUP1_fpd_divn = new RField;
  f_FCSI_PLL1PUP1_fpd_divn->setInstName ("fpd_divn");
  f_FCSI_PLL1PUP1_fpd_divn->setLongName ("FPD DIVN");
  f_FCSI_PLL1PUP1_fpd_divn->setDescription ("Force Power Down the high speed feedback divider DivN (debug bit)");
  f_FCSI_PLL1PUP1_fpd_divn->setDataWidth (1);
  f_FCSI_PLL1PUP1_fpd_divn->setResetVal ("1'b0");
  f_FCSI_PLL1PUP1_fpd_divn->setAccProp (AccProp::RW);
  r_FCSI_PLL1PUP1->connectRField (f_FCSI_PLL1PUP1_fpd_divn, 11);

  Attribute* a_FCSI_PLL1PUP1_fpd_divn_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1PUP1_fpd_divn_0_0->setInstName ("0");
  a_FCSI_PLL1PUP1_fpd_divn_0_0->setLongName ("");
  a_FCSI_PLL1PUP1_fpd_divn_0_0->setDescription ("");
  a_FCSI_PLL1PUP1_fpd_divn_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_PLL1PUP1_fpd_divn_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL1PUP1_fpd_divn->connectAttribute (a_FCSI_PLL1PUP1_fpd_divn_0_0);

  RField* f_FCSI_PLL1PUP1_fpd_vco = new RField;
  f_FCSI_PLL1PUP1_fpd_vco->setInstName ("fpd_vco");
  f_FCSI_PLL1PUP1_fpd_vco->setLongName ("FPD VCO");
  f_FCSI_PLL1PUP1_fpd_vco->setDescription ("Force power down VCO (debug bit)");
  f_FCSI_PLL1PUP1_fpd_vco->setDataWidth (1);
  f_FCSI_PLL1PUP1_fpd_vco->setResetVal ("1'b0");
  f_FCSI_PLL1PUP1_fpd_vco->setAccProp (AccProp::RW);
  r_FCSI_PLL1PUP1->connectRField (f_FCSI_PLL1PUP1_fpd_vco, 12);

  Attribute* a_FCSI_PLL1PUP1_fpd_vco_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1PUP1_fpd_vco_0_0->setInstName ("0");
  a_FCSI_PLL1PUP1_fpd_vco_0_0->setLongName ("");
  a_FCSI_PLL1PUP1_fpd_vco_0_0->setDescription ("");
  a_FCSI_PLL1PUP1_fpd_vco_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_PLL1PUP1_fpd_vco_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL1PUP1_fpd_vco->connectAttribute (a_FCSI_PLL1PUP1_fpd_vco_0_0);

  RField* f_FCSI_PLL1PUP1_fpd_lf = new RField;
  f_FCSI_PLL1PUP1_fpd_lf->setInstName ("fpd_lf");
  f_FCSI_PLL1PUP1_fpd_lf->setLongName ("FPD LF");
  f_FCSI_PLL1PUP1_fpd_lf->setDescription ("Force power down LPF (debug bit)");
  f_FCSI_PLL1PUP1_fpd_lf->setDataWidth (1);
  f_FCSI_PLL1PUP1_fpd_lf->setResetVal ("1'b0");
  f_FCSI_PLL1PUP1_fpd_lf->setAccProp (AccProp::RW);
  r_FCSI_PLL1PUP1->connectRField (f_FCSI_PLL1PUP1_fpd_lf, 13);

  Attribute* a_FCSI_PLL1PUP1_fpd_lf_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1PUP1_fpd_lf_0_0->setInstName ("0");
  a_FCSI_PLL1PUP1_fpd_lf_0_0->setLongName ("");
  a_FCSI_PLL1PUP1_fpd_lf_0_0->setDescription ("");
  a_FCSI_PLL1PUP1_fpd_lf_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_PLL1PUP1_fpd_lf_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL1PUP1_fpd_lf->connectAttribute (a_FCSI_PLL1PUP1_fpd_lf_0_0);

  RField* f_FCSI_PLL1PUP1_fpd_cp = new RField;
  f_FCSI_PLL1PUP1_fpd_cp->setInstName ("fpd_cp");
  f_FCSI_PLL1PUP1_fpd_cp->setLongName ("FPD CP");
  f_FCSI_PLL1PUP1_fpd_cp->setDescription ("Force power down Charge Pump (debug bit)");
  f_FCSI_PLL1PUP1_fpd_cp->setDataWidth (1);
  f_FCSI_PLL1PUP1_fpd_cp->setResetVal ("1'b0");
  f_FCSI_PLL1PUP1_fpd_cp->setAccProp (AccProp::RW);
  r_FCSI_PLL1PUP1->connectRField (f_FCSI_PLL1PUP1_fpd_cp, 14);

  Attribute* a_FCSI_PLL1PUP1_fpd_cp_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1PUP1_fpd_cp_0_0->setInstName ("0");
  a_FCSI_PLL1PUP1_fpd_cp_0_0->setLongName ("");
  a_FCSI_PLL1PUP1_fpd_cp_0_0->setDescription ("");
  a_FCSI_PLL1PUP1_fpd_cp_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_PLL1PUP1_fpd_cp_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL1PUP1_fpd_cp->connectAttribute (a_FCSI_PLL1PUP1_fpd_cp_0_0);

  RField* f_FCSI_PLL1PUP1_fpd_pfd = new RField;
  f_FCSI_PLL1PUP1_fpd_pfd->setInstName ("fpd_pfd");
  f_FCSI_PLL1PUP1_fpd_pfd->setLongName ("FPD PFD");
  f_FCSI_PLL1PUP1_fpd_pfd->setDescription ("Force power down PFD (debug bit)");
  f_FCSI_PLL1PUP1_fpd_pfd->setDataWidth (1);
  f_FCSI_PLL1PUP1_fpd_pfd->setResetVal ("1'b0");
  f_FCSI_PLL1PUP1_fpd_pfd->setAccProp (AccProp::RW);
  r_FCSI_PLL1PUP1->connectRField (f_FCSI_PLL1PUP1_fpd_pfd, 15);

  Attribute* a_FCSI_PLL1PUP1_fpd_pfd_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1PUP1_fpd_pfd_0_0->setInstName ("0");
  a_FCSI_PLL1PUP1_fpd_pfd_0_0->setLongName ("");
  a_FCSI_PLL1PUP1_fpd_pfd_0_0->setDescription ("");
  a_FCSI_PLL1PUP1_fpd_pfd_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_PLL1PUP1_fpd_pfd_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL1PUP1_fpd_pfd->connectAttribute (a_FCSI_PLL1PUP1_fpd_pfd_0_0);

  Register* r_FCSI_PLL1VCO0 = new Register;
  r_FCSI_PLL1VCO0->setInstName ("PLL1VCO0");
  r_FCSI_PLL1VCO0->setLongName ("PLL1 VCO CONTROL 0");
  r_FCSI_PLL1VCO0->setDescription ("PLL1-LDO1V2");
  r_FCSI_PLL1VCO0->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_PLL1VCO0, 0x00000014);

  RField* f_FCSI_PLL1VCO0_ext_lpf_r2_prog = new RField;
  f_FCSI_PLL1VCO0_ext_lpf_r2_prog->setInstName ("ext_lpf_r2_prog");
  f_FCSI_PLL1VCO0_ext_lpf_r2_prog->setLongName ("EXT LPF R2 PROG");
  f_FCSI_PLL1VCO0_ext_lpf_r2_prog->setDescription ("External LPF programming values");
  f_FCSI_PLL1VCO0_ext_lpf_r2_prog->setDataWidth (2);
  f_FCSI_PLL1VCO0_ext_lpf_r2_prog->setResetVal ("2'b00");
  f_FCSI_PLL1VCO0_ext_lpf_r2_prog->setAccProp (AccProp::RW);
  r_FCSI_PLL1VCO0->connectRField (f_FCSI_PLL1VCO0_ext_lpf_r2_prog, 0);

  Attribute* a_FCSI_PLL1VCO0_ext_lpf_r2_prog_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1VCO0_ext_lpf_r2_prog_0_0->setInstName ("0");
  a_FCSI_PLL1VCO0_ext_lpf_r2_prog_0_0->setLongName ("");
  a_FCSI_PLL1VCO0_ext_lpf_r2_prog_0_0->setDescription ("");
  a_FCSI_PLL1VCO0_ext_lpf_r2_prog_0_0->addItem("0", "2'b00", "14k");
  a_FCSI_PLL1VCO0_ext_lpf_r2_prog_0_0->addItem("1", "2'b01", "17.5k");
  a_FCSI_PLL1VCO0_ext_lpf_r2_prog_0_0->addItem("2", "2'b10", "15.75");
  a_FCSI_PLL1VCO0_ext_lpf_r2_prog_0_0->addItem("3", "2'b11", "19.25");
  f_FCSI_PLL1VCO0_ext_lpf_r2_prog->connectAttribute (a_FCSI_PLL1VCO0_ext_lpf_r2_prog_0_0);

  RField* f_FCSI_PLL1VCO0_en_ext_lpf_r2_prog = new RField;
  f_FCSI_PLL1VCO0_en_ext_lpf_r2_prog->setInstName ("en_ext_lpf_r2_prog");
  f_FCSI_PLL1VCO0_en_ext_lpf_r2_prog->setLongName ("EN EXT LPF R2 PROG");
  f_FCSI_PLL1VCO0_en_ext_lpf_r2_prog->setDescription ("Enable external control of LPF R2 resistor");
  f_FCSI_PLL1VCO0_en_ext_lpf_r2_prog->setDataWidth (1);
  f_FCSI_PLL1VCO0_en_ext_lpf_r2_prog->setResetVal ("1'b0");
  f_FCSI_PLL1VCO0_en_ext_lpf_r2_prog->setAccProp (AccProp::RW);
  r_FCSI_PLL1VCO0->connectRField (f_FCSI_PLL1VCO0_en_ext_lpf_r2_prog, 2);

  Attribute* a_FCSI_PLL1VCO0_en_ext_lpf_r2_prog_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1VCO0_en_ext_lpf_r2_prog_0_0->setInstName ("0");
  a_FCSI_PLL1VCO0_en_ext_lpf_r2_prog_0_0->setLongName ("");
  a_FCSI_PLL1VCO0_en_ext_lpf_r2_prog_0_0->setDescription ("");
  a_FCSI_PLL1VCO0_en_ext_lpf_r2_prog_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_PLL1VCO0_en_ext_lpf_r2_prog_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL1VCO0_en_ext_lpf_r2_prog->connectAttribute (a_FCSI_PLL1VCO0_en_ext_lpf_r2_prog_0_0);

  RField* f_FCSI_PLL1VCO0_lpf_dly_prog = new RField;
  f_FCSI_PLL1VCO0_lpf_dly_prog->setInstName ("lpf_dly_prog");
  f_FCSI_PLL1VCO0_lpf_dly_prog->setLongName ("LPF DLY PROG");
  f_FCSI_PLL1VCO0_lpf_dly_prog->setDescription ("Deassert vlpf-mode, wait [us] after deasserting open loop signal");
  f_FCSI_PLL1VCO0_lpf_dly_prog->setDataWidth (2);
  f_FCSI_PLL1VCO0_lpf_dly_prog->setResetVal ("2'b00");
  f_FCSI_PLL1VCO0_lpf_dly_prog->setAccProp (AccProp::RW);
  r_FCSI_PLL1VCO0->connectRField (f_FCSI_PLL1VCO0_lpf_dly_prog, 3);

  Attribute* a_FCSI_PLL1VCO0_lpf_dly_prog_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1VCO0_lpf_dly_prog_0_0->setInstName ("0");
  a_FCSI_PLL1VCO0_lpf_dly_prog_0_0->setLongName ("");
  a_FCSI_PLL1VCO0_lpf_dly_prog_0_0->setDescription ("");
  a_FCSI_PLL1VCO0_lpf_dly_prog_0_0->addItem("0", "2'b00", "4us");
  a_FCSI_PLL1VCO0_lpf_dly_prog_0_0->addItem("1", "2'b01", "8us");
  a_FCSI_PLL1VCO0_lpf_dly_prog_0_0->addItem("2", "2'b10", "12us");
  a_FCSI_PLL1VCO0_lpf_dly_prog_0_0->addItem("3", "2'b11", "never (type-I)");
  f_FCSI_PLL1VCO0_lpf_dly_prog->connectAttribute (a_FCSI_PLL1VCO0_lpf_dly_prog_0_0);

  RField* f_FCSI_PLL1VCO0_integ_path_disable = new RField;
  f_FCSI_PLL1VCO0_integ_path_disable->setInstName ("integ_path_disable");
  f_FCSI_PLL1VCO0_integ_path_disable->setLongName ("INTEG PATH DISABLE");
  f_FCSI_PLL1VCO0_integ_path_disable->setDescription ("Disable low bandwidth temperature tracking integration path in LPF");
  f_FCSI_PLL1VCO0_integ_path_disable->setDataWidth (1);
  f_FCSI_PLL1VCO0_integ_path_disable->setResetVal ("1'b0");
  f_FCSI_PLL1VCO0_integ_path_disable->setAccProp (AccProp::RW);
  r_FCSI_PLL1VCO0->connectRField (f_FCSI_PLL1VCO0_integ_path_disable, 5);

  Attribute* a_FCSI_PLL1VCO0_integ_path_disable_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1VCO0_integ_path_disable_0_0->setInstName ("0");
  a_FCSI_PLL1VCO0_integ_path_disable_0_0->setLongName ("");
  a_FCSI_PLL1VCO0_integ_path_disable_0_0->setDescription ("");
  a_FCSI_PLL1VCO0_integ_path_disable_0_0->addItem("1", "1'b1", "disable");
  a_FCSI_PLL1VCO0_integ_path_disable_0_0->addItem("0", "1'b0", "enable");
  f_FCSI_PLL1VCO0_integ_path_disable->connectAttribute (a_FCSI_PLL1VCO0_integ_path_disable_0_0);

  RField* f_FCSI_PLL1VCO0_vlpf_mode_sel = new RField;
  f_FCSI_PLL1VCO0_vlpf_mode_sel->setInstName ("vlpf_mode_sel");
  f_FCSI_PLL1VCO0_vlpf_mode_sel->setLongName ("VLPF MODE SEL");
  f_FCSI_PLL1VCO0_vlpf_mode_sel->setDescription ("External vlpf mode selection to switch to OL/CL");
  f_FCSI_PLL1VCO0_vlpf_mode_sel->setDataWidth (1);
  f_FCSI_PLL1VCO0_vlpf_mode_sel->setResetVal ("1'b0");
  f_FCSI_PLL1VCO0_vlpf_mode_sel->setAccProp (AccProp::RW);
  r_FCSI_PLL1VCO0->connectRField (f_FCSI_PLL1VCO0_vlpf_mode_sel, 6);

  Attribute* a_FCSI_PLL1VCO0_vlpf_mode_sel_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1VCO0_vlpf_mode_sel_0_0->setInstName ("0");
  a_FCSI_PLL1VCO0_vlpf_mode_sel_0_0->setLongName ("");
  a_FCSI_PLL1VCO0_vlpf_mode_sel_0_0->setDescription ("");
  a_FCSI_PLL1VCO0_vlpf_mode_sel_0_0->addItem("1", "1'b1", "open loop");
  a_FCSI_PLL1VCO0_vlpf_mode_sel_0_0->addItem("0", "1'b0", "closed loop");
  f_FCSI_PLL1VCO0_vlpf_mode_sel->connectAttribute (a_FCSI_PLL1VCO0_vlpf_mode_sel_0_0);

  RField* f_FCSI_PLL1VCO0_en_ext_lpf_mode_sel = new RField;
  f_FCSI_PLL1VCO0_en_ext_lpf_mode_sel->setInstName ("en_ext_lpf_mode_sel");
  f_FCSI_PLL1VCO0_en_ext_lpf_mode_sel->setLongName ("EN EXT LPF MODE SEL");
  f_FCSI_PLL1VCO0_en_ext_lpf_mode_sel->setDescription ("Enable external control (override) of the Loop Filter mode select");
  f_FCSI_PLL1VCO0_en_ext_lpf_mode_sel->setDataWidth (1);
  f_FCSI_PLL1VCO0_en_ext_lpf_mode_sel->setResetVal ("1'b0");
  f_FCSI_PLL1VCO0_en_ext_lpf_mode_sel->setAccProp (AccProp::RW);
  r_FCSI_PLL1VCO0->connectRField (f_FCSI_PLL1VCO0_en_ext_lpf_mode_sel, 7);

  Attribute* a_FCSI_PLL1VCO0_en_ext_lpf_mode_sel_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1VCO0_en_ext_lpf_mode_sel_0_0->setInstName ("0");
  a_FCSI_PLL1VCO0_en_ext_lpf_mode_sel_0_0->setLongName ("");
  a_FCSI_PLL1VCO0_en_ext_lpf_mode_sel_0_0->setDescription ("");
  a_FCSI_PLL1VCO0_en_ext_lpf_mode_sel_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_PLL1VCO0_en_ext_lpf_mode_sel_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL1VCO0_en_ext_lpf_mode_sel->connectAttribute (a_FCSI_PLL1VCO0_en_ext_lpf_mode_sel_0_0);

  RField* f_FCSI_PLL1VCO0_lpf_acap_bias_sel = new RField;
  f_FCSI_PLL1VCO0_lpf_acap_bias_sel->setInstName ("lpf_acap_bias_sel");
  f_FCSI_PLL1VCO0_lpf_acap_bias_sel->setLongName ("LPF ACAP BIAS SEL");
  f_FCSI_PLL1VCO0_lpf_acap_bias_sel->setDescription ("Select the bias voltage for the VCO pside analog varactor");
  f_FCSI_PLL1VCO0_lpf_acap_bias_sel->setDataWidth (2);
  f_FCSI_PLL1VCO0_lpf_acap_bias_sel->setResetVal ("2'b00");
  f_FCSI_PLL1VCO0_lpf_acap_bias_sel->setAccProp (AccProp::RW);
  r_FCSI_PLL1VCO0->connectRField (f_FCSI_PLL1VCO0_lpf_acap_bias_sel, 8);

  Attribute* a_FCSI_PLL1VCO0_lpf_acap_bias_sel_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1VCO0_lpf_acap_bias_sel_0_0->setInstName ("0");
  a_FCSI_PLL1VCO0_lpf_acap_bias_sel_0_0->setLongName ("");
  a_FCSI_PLL1VCO0_lpf_acap_bias_sel_0_0->setDescription ("");
  a_FCSI_PLL1VCO0_lpf_acap_bias_sel_0_0->addItem("0", "2'b00", "0.7V");
  a_FCSI_PLL1VCO0_lpf_acap_bias_sel_0_0->addItem("1", "2'b01", "0.65V");
  a_FCSI_PLL1VCO0_lpf_acap_bias_sel_0_0->addItem("2", "2'b10", "0.80V");
  a_FCSI_PLL1VCO0_lpf_acap_bias_sel_0_0->addItem("3", "2'b11", "0.75V");
  f_FCSI_PLL1VCO0_lpf_acap_bias_sel->connectAttribute (a_FCSI_PLL1VCO0_lpf_acap_bias_sel_0_0);

  RField* f_FCSI_PLL1VCO0_lpf_acap2_bias_sel = new RField;
  f_FCSI_PLL1VCO0_lpf_acap2_bias_sel->setInstName ("lpf_acap2_bias_sel");
  f_FCSI_PLL1VCO0_lpf_acap2_bias_sel->setLongName ("LPF ACAP2 BIAS SEL");
  f_FCSI_PLL1VCO0_lpf_acap2_bias_sel->setDescription ("Select the bias voltage for the VCO nside analog varactor");
  f_FCSI_PLL1VCO0_lpf_acap2_bias_sel->setDataWidth (2);
  f_FCSI_PLL1VCO0_lpf_acap2_bias_sel->setResetVal ("2'b00");
  f_FCSI_PLL1VCO0_lpf_acap2_bias_sel->setAccProp (AccProp::RW);
  r_FCSI_PLL1VCO0->connectRField (f_FCSI_PLL1VCO0_lpf_acap2_bias_sel, 10);

  Attribute* a_FCSI_PLL1VCO0_lpf_acap2_bias_sel_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1VCO0_lpf_acap2_bias_sel_0_0->setInstName ("0");
  a_FCSI_PLL1VCO0_lpf_acap2_bias_sel_0_0->setLongName ("");
  a_FCSI_PLL1VCO0_lpf_acap2_bias_sel_0_0->setDescription ("");
  a_FCSI_PLL1VCO0_lpf_acap2_bias_sel_0_0->addItem("0", "2'b00", "0.90V");
  a_FCSI_PLL1VCO0_lpf_acap2_bias_sel_0_0->addItem("1", "2'b01", "0.95V");
  a_FCSI_PLL1VCO0_lpf_acap2_bias_sel_0_0->addItem("2", "2'b10", "0.80V");
  a_FCSI_PLL1VCO0_lpf_acap2_bias_sel_0_0->addItem("3", "2'b11", "0.85V");
  f_FCSI_PLL1VCO0_lpf_acap2_bias_sel->connectAttribute (a_FCSI_PLL1VCO0_lpf_acap2_bias_sel_0_0);

  RField* f_FCSI_PLL1VCO0_bump_dcap_on_ref = new RField;
  f_FCSI_PLL1VCO0_bump_dcap_on_ref->setInstName ("bump_dcap_on_ref");
  f_FCSI_PLL1VCO0_bump_dcap_on_ref->setLongName ("BUMP DCAP ON REF");
  f_FCSI_PLL1VCO0_bump_dcap_on_ref->setDescription ("Select the reference voltage for the coarse calibration ON capacitor");
  f_FCSI_PLL1VCO0_bump_dcap_on_ref->setDataWidth (2);
  f_FCSI_PLL1VCO0_bump_dcap_on_ref->setResetVal ("2'b00");
  f_FCSI_PLL1VCO0_bump_dcap_on_ref->setAccProp (AccProp::RW);
  r_FCSI_PLL1VCO0->connectRField (f_FCSI_PLL1VCO0_bump_dcap_on_ref, 12);

  Attribute* a_FCSI_PLL1VCO0_bump_dcap_on_ref_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1VCO0_bump_dcap_on_ref_0_0->setInstName ("0");
  a_FCSI_PLL1VCO0_bump_dcap_on_ref_0_0->setLongName ("");
  a_FCSI_PLL1VCO0_bump_dcap_on_ref_0_0->setDescription ("");
  a_FCSI_PLL1VCO0_bump_dcap_on_ref_0_0->addItem("0", "2'b00", "1.60V");
  a_FCSI_PLL1VCO0_bump_dcap_on_ref_0_0->addItem("1", "2'b01", "1.55V (default)");
  a_FCSI_PLL1VCO0_bump_dcap_on_ref_0_0->addItem("2", "2'b10", "1.50V");
  a_FCSI_PLL1VCO0_bump_dcap_on_ref_0_0->addItem("3", "2'b11", "1.46V");
  f_FCSI_PLL1VCO0_bump_dcap_on_ref->connectAttribute (a_FCSI_PLL1VCO0_bump_dcap_on_ref_0_0);

  RField* f_FCSI_PLL1VCO0_bump_dcap_off_ref = new RField;
  f_FCSI_PLL1VCO0_bump_dcap_off_ref->setInstName ("bump_dcap_off_ref");
  f_FCSI_PLL1VCO0_bump_dcap_off_ref->setLongName ("PLL BUMP DCAP OFF REF");
  f_FCSI_PLL1VCO0_bump_dcap_off_ref->setDescription ("Select the reference voltage for the coarse calibration OFF capacitor");
  f_FCSI_PLL1VCO0_bump_dcap_off_ref->setDataWidth (2);
  f_FCSI_PLL1VCO0_bump_dcap_off_ref->setResetVal ("2'b00");
  f_FCSI_PLL1VCO0_bump_dcap_off_ref->setAccProp (AccProp::RW);
  r_FCSI_PLL1VCO0->connectRField (f_FCSI_PLL1VCO0_bump_dcap_off_ref, 14);

  Attribute* a_FCSI_PLL1VCO0_bump_dcap_off_ref_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1VCO0_bump_dcap_off_ref_0_0->setInstName ("0");
  a_FCSI_PLL1VCO0_bump_dcap_off_ref_0_0->setLongName ("");
  a_FCSI_PLL1VCO0_bump_dcap_off_ref_0_0->setDescription ("");
  a_FCSI_PLL1VCO0_bump_dcap_off_ref_0_0->addItem("0", "2'b00", "1.1Vref");
  a_FCSI_PLL1VCO0_bump_dcap_off_ref_0_0->addItem("1", "2'b01", "1.0Vref (default)");
  a_FCSI_PLL1VCO0_bump_dcap_off_ref_0_0->addItem("2", "2'b10", "0.91Vref");
  a_FCSI_PLL1VCO0_bump_dcap_off_ref_0_0->addItem("3", "2'b11", "0.90Vref");
  f_FCSI_PLL1VCO0_bump_dcap_off_ref->connectAttribute (a_FCSI_PLL1VCO0_bump_dcap_off_ref_0_0);

  Register* r_FCSI_PLL1VCO1 = new Register;
  r_FCSI_PLL1VCO1->setInstName ("PLL1VCO1");
  r_FCSI_PLL1VCO1->setLongName ("PLL1 VCO CONTROL 1");
  r_FCSI_PLL1VCO1->setDescription ("PLL1-LDO1V2");
  r_FCSI_PLL1VCO1->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_PLL1VCO1, 0x00000015);

  RField* f_FCSI_PLL1VCO1_en_bump_kvco = new RField;
  f_FCSI_PLL1VCO1_en_bump_kvco->setInstName ("en_bump_kvco");
  f_FCSI_PLL1VCO1_en_bump_kvco->setLongName ("EN BUMP KVCO");
  f_FCSI_PLL1VCO1_en_bump_kvco->setDescription ("External KVCO control setting values");
  f_FCSI_PLL1VCO1_en_bump_kvco->setDataWidth (1);
  f_FCSI_PLL1VCO1_en_bump_kvco->setResetVal ("1'b0");
  f_FCSI_PLL1VCO1_en_bump_kvco->setAccProp (AccProp::RW);
  r_FCSI_PLL1VCO1->connectRField (f_FCSI_PLL1VCO1_en_bump_kvco, 1);

  Attribute* a_FCSI_PLL1VCO1_en_bump_kvco_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1VCO1_en_bump_kvco_0_0->setInstName ("0");
  a_FCSI_PLL1VCO1_en_bump_kvco_0_0->setLongName ("");
  a_FCSI_PLL1VCO1_en_bump_kvco_0_0->setDescription ("");
  a_FCSI_PLL1VCO1_en_bump_kvco_0_0->addItem("1", "1'b1", "Smaller ACAP bias R");
  a_FCSI_PLL1VCO1_en_bump_kvco_0_0->addItem("0", "1'b0", "Larger ACAP bias R");
  f_FCSI_PLL1VCO1_en_bump_kvco->connectAttribute (a_FCSI_PLL1VCO1_en_bump_kvco_0_0);

  RField* f_FCSI_PLL1VCO1_ext_dcap_fine = new RField;
  f_FCSI_PLL1VCO1_ext_dcap_fine->setInstName ("ext_dcap_fine");
  f_FCSI_PLL1VCO1_ext_dcap_fine->setLongName ("EXT DCAP FINE");
  f_FCSI_PLL1VCO1_ext_dcap_fine->setDescription ("External fine calibration values");
  f_FCSI_PLL1VCO1_ext_dcap_fine->setDataWidth (3);
  f_FCSI_PLL1VCO1_ext_dcap_fine->setResetVal ("3'b000");
  f_FCSI_PLL1VCO1_ext_dcap_fine->setAccProp (AccProp::RW);
  r_FCSI_PLL1VCO1->connectRField (f_FCSI_PLL1VCO1_ext_dcap_fine, 2);

  Attribute* a_FCSI_PLL1VCO1_ext_dcap_fine_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1VCO1_ext_dcap_fine_0_0->setInstName ("0");
  a_FCSI_PLL1VCO1_ext_dcap_fine_0_0->setLongName ("");
  a_FCSI_PLL1VCO1_ext_dcap_fine_0_0->setDescription ("");
  a_FCSI_PLL1VCO1_ext_dcap_fine_0_0->addItem("7", "3'b111", "Highest frequency");
  a_FCSI_PLL1VCO1_ext_dcap_fine_0_0->addItem("0", "3'b000", "Lowest frequency");
  f_FCSI_PLL1VCO1_ext_dcap_fine->connectAttribute (a_FCSI_PLL1VCO1_ext_dcap_fine_0_0);

  RField* f_FCSI_PLL1VCO1_ext_dcap_coarse = new RField;
  f_FCSI_PLL1VCO1_ext_dcap_coarse->setInstName ("ext_dcap_coarse");
  f_FCSI_PLL1VCO1_ext_dcap_coarse->setLongName ("EXT DCAP COARSE");
  f_FCSI_PLL1VCO1_ext_dcap_coarse->setDescription ("External coarse calibration values");
  f_FCSI_PLL1VCO1_ext_dcap_coarse->setDataWidth (10);
  f_FCSI_PLL1VCO1_ext_dcap_coarse->setResetVal ("10'b0000000000");
  f_FCSI_PLL1VCO1_ext_dcap_coarse->setAccProp (AccProp::RW);
  r_FCSI_PLL1VCO1->connectRField (f_FCSI_PLL1VCO1_ext_dcap_coarse, 5);

  Attribute* a_FCSI_PLL1VCO1_ext_dcap_coarse_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1VCO1_ext_dcap_coarse_0_0->setInstName ("0");
  a_FCSI_PLL1VCO1_ext_dcap_coarse_0_0->setLongName ("");
  a_FCSI_PLL1VCO1_ext_dcap_coarse_0_0->setDescription ("");
  a_FCSI_PLL1VCO1_ext_dcap_coarse_0_0->addItem("1", "10'b1111111111", "Highest frequency");
  a_FCSI_PLL1VCO1_ext_dcap_coarse_0_0->addItem("0", "10'b0000000000", "Lowest frequency");
  f_FCSI_PLL1VCO1_ext_dcap_coarse->connectAttribute (a_FCSI_PLL1VCO1_ext_dcap_coarse_0_0);

  RField* f_FCSI_PLL1VCO1_en_ext_dcap_override = new RField;
  f_FCSI_PLL1VCO1_en_ext_dcap_override->setInstName ("en_ext_dcap_override");
  f_FCSI_PLL1VCO1_en_ext_dcap_override->setLongName ("EN EXT DCAP OVERRIDE");
  f_FCSI_PLL1VCO1_en_ext_dcap_override->setDescription ("Enable writing the coarse and fine DCAP values externally");
  f_FCSI_PLL1VCO1_en_ext_dcap_override->setDataWidth (1);
  f_FCSI_PLL1VCO1_en_ext_dcap_override->setResetVal ("1'b0");
  f_FCSI_PLL1VCO1_en_ext_dcap_override->setAccProp (AccProp::RW);
  r_FCSI_PLL1VCO1->connectRField (f_FCSI_PLL1VCO1_en_ext_dcap_override, 15);

  Attribute* a_FCSI_PLL1VCO1_en_ext_dcap_override_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1VCO1_en_ext_dcap_override_0_0->setInstName ("0");
  a_FCSI_PLL1VCO1_en_ext_dcap_override_0_0->setLongName ("");
  a_FCSI_PLL1VCO1_en_ext_dcap_override_0_0->setDescription ("");
  a_FCSI_PLL1VCO1_en_ext_dcap_override_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_PLL1VCO1_en_ext_dcap_override_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL1VCO1_en_ext_dcap_override->connectAttribute (a_FCSI_PLL1VCO1_en_ext_dcap_override_0_0);

  Register* r_FCSI_PLL1SDM0 = new Register;
  r_FCSI_PLL1SDM0->setInstName ("PLL1SDM0");
  r_FCSI_PLL1SDM0->setLongName ("PLL1 SIGMA DELTA 0");
  r_FCSI_PLL1SDM0->setDescription ("PLL1-LDO1V2");
  r_FCSI_PLL1SDM0->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_PLL1SDM0, 0x00000016);

  RField* f_FCSI_PLL1SDM0_lock_o = new RField;
  f_FCSI_PLL1SDM0_lock_o->setInstName ("lock_o");
  f_FCSI_PLL1SDM0_lock_o->setLongName ("LOCK OUTPUT");
  f_FCSI_PLL1SDM0_lock_o->setDescription ("Lock output signal");
  f_FCSI_PLL1SDM0_lock_o->setDataWidth (1);
  f_FCSI_PLL1SDM0_lock_o->setResetVal ("1'b0");
  f_FCSI_PLL1SDM0_lock_o->setAccProp (AccProp::RW);
  r_FCSI_PLL1SDM0->connectRField (f_FCSI_PLL1SDM0_lock_o, 0);

  Attribute* a_FCSI_PLL1SDM0_lock_o_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1SDM0_lock_o_0_0->setInstName ("0");
  a_FCSI_PLL1SDM0_lock_o_0_0->setLongName ("");
  a_FCSI_PLL1SDM0_lock_o_0_0->setDescription ("");
  a_FCSI_PLL1SDM0_lock_o_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_PLL1SDM0_lock_o_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL1SDM0_lock_o->connectAttribute (a_FCSI_PLL1SDM0_lock_o_0_0);

  RField* f_FCSI_PLL1SDM0_seldig_tm = new RField;
  f_FCSI_PLL1SDM0_seldig_tm->setInstName ("seldig_tm");
  f_FCSI_PLL1SDM0_seldig_tm->setLongName ("SELDIG TM");
  f_FCSI_PLL1SDM0_seldig_tm->setDescription ("Select signal input for the digital monitor output");
  f_FCSI_PLL1SDM0_seldig_tm->setDataWidth (2);
  f_FCSI_PLL1SDM0_seldig_tm->setResetVal ("2'b00");
  f_FCSI_PLL1SDM0_seldig_tm->setAccProp (AccProp::RW);
  r_FCSI_PLL1SDM0->connectRField (f_FCSI_PLL1SDM0_seldig_tm, 1);

  Attribute* a_FCSI_PLL1SDM0_seldig_tm_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1SDM0_seldig_tm_0_0->setInstName ("0");
  a_FCSI_PLL1SDM0_seldig_tm_0_0->setLongName ("");
  a_FCSI_PLL1SDM0_seldig_tm_0_0->setDescription ("");
  a_FCSI_PLL1SDM0_seldig_tm_0_0->addItem("0", "2'b00", "0");
  a_FCSI_PLL1SDM0_seldig_tm_0_0->addItem("1", "2'b01", "lock_i");
  a_FCSI_PLL1SDM0_seldig_tm_0_0->addItem("2", "2'b10", "ref_clk_i");
  a_FCSI_PLL1SDM0_seldig_tm_0_0->addItem("3", "2'b11", "clk_nc");
  f_FCSI_PLL1SDM0_seldig_tm->connectAttribute (a_FCSI_PLL1SDM0_seldig_tm_0_0);

  RField* f_FCSI_PLL1SDM0_lock_override = new RField;
  f_FCSI_PLL1SDM0_lock_override->setInstName ("lock_override");
  f_FCSI_PLL1SDM0_lock_override->setLongName ("LOCK OVERRIDE");
  f_FCSI_PLL1SDM0_lock_override->setDescription ("External override enable for PLL lock signal");
  f_FCSI_PLL1SDM0_lock_override->setDataWidth (1);
  f_FCSI_PLL1SDM0_lock_override->setResetVal ("1'b0");
  f_FCSI_PLL1SDM0_lock_override->setAccProp (AccProp::RW);
  r_FCSI_PLL1SDM0->connectRField (f_FCSI_PLL1SDM0_lock_override, 3);

  Attribute* a_FCSI_PLL1SDM0_lock_override_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1SDM0_lock_override_0_0->setInstName ("0");
  a_FCSI_PLL1SDM0_lock_override_0_0->setLongName ("");
  a_FCSI_PLL1SDM0_lock_override_0_0->setDescription ("");
  a_FCSI_PLL1SDM0_lock_override_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_PLL1SDM0_lock_override_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL1SDM0_lock_override->connectAttribute (a_FCSI_PLL1SDM0_lock_override_0_0);

  RField* f_FCSI_PLL1SDM0_en_timer_lock_det = new RField;
  f_FCSI_PLL1SDM0_en_timer_lock_det->setInstName ("en_timer_lock_det");
  f_FCSI_PLL1SDM0_en_timer_lock_det->setLongName ("EN TIME LOCK DET");
  f_FCSI_PLL1SDM0_en_timer_lock_det->setDescription ("Enable timer based lock detection");
  f_FCSI_PLL1SDM0_en_timer_lock_det->setDataWidth (1);
  f_FCSI_PLL1SDM0_en_timer_lock_det->setResetVal ("1'b0");
  f_FCSI_PLL1SDM0_en_timer_lock_det->setAccProp (AccProp::RW);
  r_FCSI_PLL1SDM0->connectRField (f_FCSI_PLL1SDM0_en_timer_lock_det, 4);

  Attribute* a_FCSI_PLL1SDM0_en_timer_lock_det_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1SDM0_en_timer_lock_det_0_0->setInstName ("0");
  a_FCSI_PLL1SDM0_en_timer_lock_det_0_0->setLongName ("");
  a_FCSI_PLL1SDM0_en_timer_lock_det_0_0->setDescription ("");
  a_FCSI_PLL1SDM0_en_timer_lock_det_0_0->addItem("1", "1'b1", "Timer based lock detection");
  a_FCSI_PLL1SDM0_en_timer_lock_det_0_0->addItem("0", "1'b0", "Default lock detection");
  f_FCSI_PLL1SDM0_en_timer_lock_det->connectAttribute (a_FCSI_PLL1SDM0_en_timer_lock_det_0_0);

  RField* f_FCSI_PLL1SDM0_ext_sdm = new RField;
  f_FCSI_PLL1SDM0_ext_sdm->setInstName ("ext_sdm");
  f_FCSI_PLL1SDM0_ext_sdm->setLongName ("EXT SDM");
  f_FCSI_PLL1SDM0_ext_sdm->setDescription ("External delta sigma modulator control");
  f_FCSI_PLL1SDM0_ext_sdm->setDataWidth (3);
  f_FCSI_PLL1SDM0_ext_sdm->setResetVal ("3'b000");
  f_FCSI_PLL1SDM0_ext_sdm->setAccProp (AccProp::RW);
  r_FCSI_PLL1SDM0->connectRField (f_FCSI_PLL1SDM0_ext_sdm, 5);

  RField* f_FCSI_PLL1SDM0_en_ext_sdm = new RField;
  f_FCSI_PLL1SDM0_en_ext_sdm->setInstName ("en_ext_sdm");
  f_FCSI_PLL1SDM0_en_ext_sdm->setLongName ("EN EXT SDM");
  f_FCSI_PLL1SDM0_en_ext_sdm->setDescription ("Enable external override of the Delta Sigma Modulator");
  f_FCSI_PLL1SDM0_en_ext_sdm->setDataWidth (1);
  f_FCSI_PLL1SDM0_en_ext_sdm->setResetVal ("1'b0");
  f_FCSI_PLL1SDM0_en_ext_sdm->setAccProp (AccProp::RW);
  r_FCSI_PLL1SDM0->connectRField (f_FCSI_PLL1SDM0_en_ext_sdm, 8);

  Attribute* a_FCSI_PLL1SDM0_en_ext_sdm_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1SDM0_en_ext_sdm_0_0->setInstName ("0");
  a_FCSI_PLL1SDM0_en_ext_sdm_0_0->setLongName ("");
  a_FCSI_PLL1SDM0_en_ext_sdm_0_0->setDescription ("");
  a_FCSI_PLL1SDM0_en_ext_sdm_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_PLL1SDM0_en_ext_sdm_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL1SDM0_en_ext_sdm->connectAttribute (a_FCSI_PLL1SDM0_en_ext_sdm_0_0);

  RField* f_FCSI_PLL1SDM0_prbs_dither_en = new RField;
  f_FCSI_PLL1SDM0_prbs_dither_en->setInstName ("prbs_dither_en");
  f_FCSI_PLL1SDM0_prbs_dither_en->setLongName ("PRBS DITHER EN");
  f_FCSI_PLL1SDM0_prbs_dither_en->setDescription ("Enable prbs dither mode for DSM");
  f_FCSI_PLL1SDM0_prbs_dither_en->setDataWidth (1);
  f_FCSI_PLL1SDM0_prbs_dither_en->setResetVal ("1'b0");
  f_FCSI_PLL1SDM0_prbs_dither_en->setAccProp (AccProp::RW);
  r_FCSI_PLL1SDM0->connectRField (f_FCSI_PLL1SDM0_prbs_dither_en, 9);

  Attribute* a_FCSI_PLL1SDM0_prbs_dither_en_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1SDM0_prbs_dither_en_0_0->setInstName ("0");
  a_FCSI_PLL1SDM0_prbs_dither_en_0_0->setLongName ("");
  a_FCSI_PLL1SDM0_prbs_dither_en_0_0->setDescription ("");
  a_FCSI_PLL1SDM0_prbs_dither_en_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_PLL1SDM0_prbs_dither_en_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL1SDM0_prbs_dither_en->connectAttribute (a_FCSI_PLL1SDM0_prbs_dither_en_0_0);

  RField* f_FCSI_PLL1SDM0_sdm_en = new RField;
  f_FCSI_PLL1SDM0_sdm_en->setInstName ("sdm_en");
  f_FCSI_PLL1SDM0_sdm_en->setLongName ("SDM EN");
  f_FCSI_PLL1SDM0_sdm_en->setDescription ("Enable the delta sigma modulator");
  f_FCSI_PLL1SDM0_sdm_en->setDataWidth (1);
  f_FCSI_PLL1SDM0_sdm_en->setResetVal ("1'b0");
  f_FCSI_PLL1SDM0_sdm_en->setAccProp (AccProp::RW);
  r_FCSI_PLL1SDM0->connectRField (f_FCSI_PLL1SDM0_sdm_en, 10);

  Attribute* a_FCSI_PLL1SDM0_sdm_en_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1SDM0_sdm_en_0_0->setInstName ("0");
  a_FCSI_PLL1SDM0_sdm_en_0_0->setLongName ("");
  a_FCSI_PLL1SDM0_sdm_en_0_0->setDescription ("");
  a_FCSI_PLL1SDM0_sdm_en_0_0->addItem("1", "1'b1", "enable (2G mode)");
  a_FCSI_PLL1SDM0_sdm_en_0_0->addItem("0", "1'b0", "disable (HP/RP mode)");
  f_FCSI_PLL1SDM0_sdm_en->connectAttribute (a_FCSI_PLL1SDM0_sdm_en_0_0);

  RField* f_FCSI_PLL1SDM0_sel_fcal_cnt = new RField;
  f_FCSI_PLL1SDM0_sel_fcal_cnt->setInstName ("sel_fcal_cnt");
  f_FCSI_PLL1SDM0_sel_fcal_cnt->setLongName ("SEL FCAL CNT");
  f_FCSI_PLL1SDM0_sel_fcal_cnt->setDescription ("Select the FCAL counter value that needs to be read back on the FCAL_Counter Register");
  f_FCSI_PLL1SDM0_sel_fcal_cnt->setDataWidth (5);
  f_FCSI_PLL1SDM0_sel_fcal_cnt->setResetVal ("5'b00000");
  f_FCSI_PLL1SDM0_sel_fcal_cnt->setAccProp (AccProp::RW);
  r_FCSI_PLL1SDM0->connectRField (f_FCSI_PLL1SDM0_sel_fcal_cnt, 11);

  Attribute* a_FCSI_PLL1SDM0_sel_fcal_cnt_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1SDM0_sel_fcal_cnt_0_0->setInstName ("0");
  a_FCSI_PLL1SDM0_sel_fcal_cnt_0_0->setLongName ("");
  a_FCSI_PLL1SDM0_sel_fcal_cnt_0_0->setDescription ("");
  a_FCSI_PLL1SDM0_sel_fcal_cnt_0_0->addItem("0", "5'b00000", "Coarse Cal bit 9 Final Count Ch-0");
  a_FCSI_PLL1SDM0_sel_fcal_cnt_0_0->addItem("1", "5'b00001", "Coarse Cal bit 8 Final Count Ch-0");
  a_FCSI_PLL1SDM0_sel_fcal_cnt_0_0->addItem("2", "5'b00010", "Coarse Cal bit 7 Final Count Ch-0");
  a_FCSI_PLL1SDM0_sel_fcal_cnt_0_0->addItem("3", "5'b00011", "Coarse Cal bit 6 Final Count Ch-0");
  a_FCSI_PLL1SDM0_sel_fcal_cnt_0_0->addItem("4", "5'b00100", "Coarse Cal bit 5 Final Count Ch-0");
  a_FCSI_PLL1SDM0_sel_fcal_cnt_0_0->addItem("5", "5'b00101", "Coarse Cal bit 4 Final Count Ch-0");
  a_FCSI_PLL1SDM0_sel_fcal_cnt_0_0->addItem("6", "5'b00110", "Coarse Cal bit 3 Final Count Ch-0");
  a_FCSI_PLL1SDM0_sel_fcal_cnt_0_0->addItem("7", "5'b00111", "Coarse Cal bit 2 Final Count Ch-0");
  a_FCSI_PLL1SDM0_sel_fcal_cnt_0_0->addItem("8", "5'b01000", "Coarse Cal bit 1 Final Count Ch-0");
  a_FCSI_PLL1SDM0_sel_fcal_cnt_0_0->addItem("9", "5'b01001", "Coarse Cal bit 0 Final Count Ch-0");
  a_FCSI_PLL1SDM0_sel_fcal_cnt_0_0->addItem("10", "5'b01010", "Fine Cal bit 2 Final Count Ch-0");
  a_FCSI_PLL1SDM0_sel_fcal_cnt_0_0->addItem("11", "5'b01011", "Fine Cal bit 1 Final Count Ch-0");
  a_FCSI_PLL1SDM0_sel_fcal_cnt_0_0->addItem("12", "5'b01100", "Fine Cal bit 0 Final Count Ch-0");
  a_FCSI_PLL1SDM0_sel_fcal_cnt_0_0->addItem("13", "5'b01101", "Fine Cal bit 0 Final Count Ch-0 (FINAL FCAL COUNT)");
  a_FCSI_PLL1SDM0_sel_fcal_cnt_0_0->addItem("14", "5'b01110", "Channel 0 final calibration value (Bits in the following order 0,0,Coarse<9:0>,Fine<2:0>)");
  a_FCSI_PLL1SDM0_sel_fcal_cnt_0_0->addItem("15", "5'b01111", "Channel 0 final minimum count (FINAL FCAL COUNT)");
  a_FCSI_PLL1SDM0_sel_fcal_cnt_0_0->addItem("16", "5'b10000", "Channel 1 final calibration value");
  a_FCSI_PLL1SDM0_sel_fcal_cnt_0_0->addItem("17", "5'b10001", "Channel 1 final minimum count");
  a_FCSI_PLL1SDM0_sel_fcal_cnt_0_0->addItem("18", "5'b10010", "Channel 2 final calibration value");
  a_FCSI_PLL1SDM0_sel_fcal_cnt_0_0->addItem("19", "5'b10011", "Channel 2 final minimum count");
  a_FCSI_PLL1SDM0_sel_fcal_cnt_0_0->addItem("20", "5'b10100", "Channel 3 final calibration value");
  a_FCSI_PLL1SDM0_sel_fcal_cnt_0_0->addItem("21", "5'b10101", "Channel 3 final minimum count");
  a_FCSI_PLL1SDM0_sel_fcal_cnt_0_0->addItem("22", "5'b10110", "Channel 4 final calibration value");
  a_FCSI_PLL1SDM0_sel_fcal_cnt_0_0->addItem("23", "5'b10111", "Channel 4 final minimum count");
  a_FCSI_PLL1SDM0_sel_fcal_cnt_0_0->addItem("24", "5'b11000", "Channel 5 final calibration value");
  a_FCSI_PLL1SDM0_sel_fcal_cnt_0_0->addItem("25", "5'b11001", "Channel 5 final minimum count");
  a_FCSI_PLL1SDM0_sel_fcal_cnt_0_0->addItem("26", "5'b11010", "Current FCAL FSM state");
  a_FCSI_PLL1SDM0_sel_fcal_cnt_0_0->addItem("27", "5'b11011", "Current PUP FSM state");
  f_FCSI_PLL1SDM0_sel_fcal_cnt->connectAttribute (a_FCSI_PLL1SDM0_sel_fcal_cnt_0_0);

  Register* r_FCSI_PLL1SDM1 = new Register;
  r_FCSI_PLL1SDM1->setInstName ("PLL1SDM1");
  r_FCSI_PLL1SDM1->setLongName ("PLL1 SIGMA DELTA 1");
  r_FCSI_PLL1SDM1->setDescription ("PLL1-LDO1V2");
  r_FCSI_PLL1SDM1->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_PLL1SDM1, 0x00000017);

  RField* f_FCSI_PLL1SDM1_divn_frac_ch1 = new RField;
  f_FCSI_PLL1SDM1_divn_frac_ch1->setInstName ("divn_frac_ch1");
  f_FCSI_PLL1SDM1_divn_frac_ch1->setLongName ("DIVN FRAC CH1 [23:8]");
  f_FCSI_PLL1SDM1_divn_frac_ch1->setDescription ("MMD Fractional Value LSB's");
  f_FCSI_PLL1SDM1_divn_frac_ch1->setDataWidth (16);
  f_FCSI_PLL1SDM1_divn_frac_ch1->setResetVal ("16'b0000000000000000");
  f_FCSI_PLL1SDM1_divn_frac_ch1->setAccProp (AccProp::RW);
  r_FCSI_PLL1SDM1->connectRField (f_FCSI_PLL1SDM1_divn_frac_ch1, 0);

  Register* r_FCSI_PLL1SDM2 = new Register;
  r_FCSI_PLL1SDM2->setInstName ("PLL1SDM2");
  r_FCSI_PLL1SDM2->setLongName ("PLL1 SIGMA DELTA 2");
  r_FCSI_PLL1SDM2->setDescription ("PLL1-LDO1V2");
  r_FCSI_PLL1SDM2->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_PLL1SDM2, 0x00000018);

  RField* f_FCSI_PLL1SDM2_divn_int_ch1 = new RField;
  f_FCSI_PLL1SDM2_divn_int_ch1->setInstName ("divn_int_ch1");
  f_FCSI_PLL1SDM2_divn_int_ch1->setLongName ("DIVN INT CH1");
  f_FCSI_PLL1SDM2_divn_int_ch1->setDescription ("Integer values");
  f_FCSI_PLL1SDM2_divn_int_ch1->setDataWidth (8);
  f_FCSI_PLL1SDM2_divn_int_ch1->setResetVal ("8'b00000000");
  f_FCSI_PLL1SDM2_divn_int_ch1->setAccProp (AccProp::RW);
  r_FCSI_PLL1SDM2->connectRField (f_FCSI_PLL1SDM2_divn_int_ch1, 0);

  RField* f_FCSI_PLL1SDM2_div_int_ch1_shared_frac = new RField;
  f_FCSI_PLL1SDM2_div_int_ch1_shared_frac->setInstName ("div_int_ch1_shared_frac");
  f_FCSI_PLL1SDM2_div_int_ch1_shared_frac->setLongName ("DIV INT CH1 [10:8] / DIVN FRAC CH1 [2:0]");
  f_FCSI_PLL1SDM2_div_int_ch1_shared_frac->setDescription ("Integer values (or shared MMD Fractional Value MSB's)");
  f_FCSI_PLL1SDM2_div_int_ch1_shared_frac->setDataWidth (3);
  f_FCSI_PLL1SDM2_div_int_ch1_shared_frac->setResetVal ("3'b000");
  f_FCSI_PLL1SDM2_div_int_ch1_shared_frac->setAccProp (AccProp::RW);
  r_FCSI_PLL1SDM2->connectRField (f_FCSI_PLL1SDM2_div_int_ch1_shared_frac, 8);

  RField* f_FCSI_PLL1SDM2_divn_frac_ch1 = new RField;
  f_FCSI_PLL1SDM2_divn_frac_ch1->setInstName ("divn_frac_ch1");
  f_FCSI_PLL1SDM2_divn_frac_ch1->setLongName ("DIVN FRAC CH1 [7:3]");
  f_FCSI_PLL1SDM2_divn_frac_ch1->setDescription ("MMD Fractional Value MSB's");
  f_FCSI_PLL1SDM2_divn_frac_ch1->setDataWidth (5);
  f_FCSI_PLL1SDM2_divn_frac_ch1->setResetVal ("5'b00000");
  f_FCSI_PLL1SDM2_divn_frac_ch1->setAccProp (AccProp::RW);
  r_FCSI_PLL1SDM2->connectRField (f_FCSI_PLL1SDM2_divn_frac_ch1, 11);

  Register* r_FCSI_PLL1OUT = new Register;
  r_FCSI_PLL1OUT->setInstName ("PLL1OUT");
  r_FCSI_PLL1OUT->setLongName ("PLL1 OUTPUT CONTROL");
  r_FCSI_PLL1OUT->setDescription ("PLL1-LDO1V2");
  r_FCSI_PLL1OUT->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_PLL1OUT, 0x00000019);

  RField* f_FCSI_PLL1OUT_digtm_o = new RField;
  f_FCSI_PLL1OUT_digtm_o->setInstName ("digtm_o");
  f_FCSI_PLL1OUT_digtm_o->setLongName ("DIGTM OUT");
  f_FCSI_PLL1OUT_digtm_o->setDescription ("Digital monitor output");
  f_FCSI_PLL1OUT_digtm_o->setDataWidth (1);
  f_FCSI_PLL1OUT_digtm_o->setResetVal ("1'b0");
  f_FCSI_PLL1OUT_digtm_o->setAccProp (AccProp::RW);
  r_FCSI_PLL1OUT->connectRField (f_FCSI_PLL1OUT_digtm_o, 0);

  Attribute* a_FCSI_PLL1OUT_digtm_o_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1OUT_digtm_o_0_0->setInstName ("0");
  a_FCSI_PLL1OUT_digtm_o_0_0->setLongName ("");
  a_FCSI_PLL1OUT_digtm_o_0_0->setDescription ("");
  a_FCSI_PLL1OUT_digtm_o_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_PLL1OUT_digtm_o_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL1OUT_digtm_o->connectAttribute (a_FCSI_PLL1OUT_digtm_o_0_0);

  RField* f_FCSI_PLL1OUT_fcal_cnt_o = new RField;
  f_FCSI_PLL1OUT_fcal_cnt_o->setInstName ("fcal_cnt_o");
  f_FCSI_PLL1OUT_fcal_cnt_o->setLongName ("FCAL CNT OUT");
  f_FCSI_PLL1OUT_fcal_cnt_o->setDescription ("Read out the internal digital counter values");
  f_FCSI_PLL1OUT_fcal_cnt_o->setDataWidth (15);
  f_FCSI_PLL1OUT_fcal_cnt_o->setResetVal ("15'b000000000000000");
  f_FCSI_PLL1OUT_fcal_cnt_o->setAccProp (AccProp::RW);
  r_FCSI_PLL1OUT->connectRField (f_FCSI_PLL1OUT_fcal_cnt_o, 1);

  Register* r_FCSI_PLL1MISC = new Register;
  r_FCSI_PLL1MISC->setInstName ("PLL1MISC");
  r_FCSI_PLL1MISC->setLongName ("PLL1 MISCELLANEOUS");
  r_FCSI_PLL1MISC->setDescription ("PLL1-LDO1V2");
  r_FCSI_PLL1MISC->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_PLL1MISC, 0x0000001A);

  RField* f_FCSI_PLL1MISC_en_icp_override = new RField;
  f_FCSI_PLL1MISC_en_icp_override->setInstName ("en_icp_override");
  f_FCSI_PLL1MISC_en_icp_override->setLongName ("EN ICP OVERRIDE");
  f_FCSI_PLL1MISC_en_icp_override->setDescription ("Enable external ICP bin programming");
  f_FCSI_PLL1MISC_en_icp_override->setDataWidth (1);
  f_FCSI_PLL1MISC_en_icp_override->setResetVal ("1'b0");
  f_FCSI_PLL1MISC_en_icp_override->setAccProp (AccProp::RW);
  r_FCSI_PLL1MISC->connectRField (f_FCSI_PLL1MISC_en_icp_override, 0);

  Attribute* a_FCSI_PLL1MISC_en_icp_override_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1MISC_en_icp_override_0_0->setInstName ("0");
  a_FCSI_PLL1MISC_en_icp_override_0_0->setLongName ("");
  a_FCSI_PLL1MISC_en_icp_override_0_0->setDescription ("");
  a_FCSI_PLL1MISC_en_icp_override_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_PLL1MISC_en_icp_override_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL1MISC_en_icp_override->connectAttribute (a_FCSI_PLL1MISC_en_icp_override_0_0);

  RField* f_FCSI_PLL1MISC_sel_close_loop_hop_mode = new RField;
  f_FCSI_PLL1MISC_sel_close_loop_hop_mode->setInstName ("sel_close_loop_hop_mode");
  f_FCSI_PLL1MISC_sel_close_loop_hop_mode->setLongName ("SEL CLOSE LOOP HOP MODE");
  f_FCSI_PLL1MISC_sel_close_loop_hop_mode->setDescription ("Select closed loop channel hopping mode");
  f_FCSI_PLL1MISC_sel_close_loop_hop_mode->setDataWidth (2);
  f_FCSI_PLL1MISC_sel_close_loop_hop_mode->setResetVal ("2'b00");
  f_FCSI_PLL1MISC_sel_close_loop_hop_mode->setAccProp (AccProp::RW);
  r_FCSI_PLL1MISC->connectRField (f_FCSI_PLL1MISC_sel_close_loop_hop_mode, 1);

  Attribute* a_FCSI_PLL1MISC_sel_close_loop_hop_mode_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1MISC_sel_close_loop_hop_mode_0_0->setInstName ("0");
  a_FCSI_PLL1MISC_sel_close_loop_hop_mode_0_0->setLongName ("");
  a_FCSI_PLL1MISC_sel_close_loop_hop_mode_0_0->setDescription ("");
  a_FCSI_PLL1MISC_sel_close_loop_hop_mode_0_0->addItem("0", "2'b00", "Default");
  a_FCSI_PLL1MISC_sel_close_loop_hop_mode_0_0->addItem("1", "2'b01", "Test mode");
  a_FCSI_PLL1MISC_sel_close_loop_hop_mode_0_0->addItem("2", "2'b10", "---");
  a_FCSI_PLL1MISC_sel_close_loop_hop_mode_0_0->addItem("3", "2'b11", "---");
  f_FCSI_PLL1MISC_sel_close_loop_hop_mode->connectAttribute (a_FCSI_PLL1MISC_sel_close_loop_hop_mode_0_0);

  RField* f_FCSI_PLL1MISC_sel_clk = new RField;
  f_FCSI_PLL1MISC_sel_clk->setInstName ("sel_clk");
  f_FCSI_PLL1MISC_sel_clk->setLongName ("SEL CLK");
  f_FCSI_PLL1MISC_sel_clk->setDescription ("Select the input clock for the PLL");
  f_FCSI_PLL1MISC_sel_clk->setDataWidth (1);
  f_FCSI_PLL1MISC_sel_clk->setResetVal ("1'b0");
  f_FCSI_PLL1MISC_sel_clk->setAccProp (AccProp::RW);
  r_FCSI_PLL1MISC->connectRField (f_FCSI_PLL1MISC_sel_clk, 3);

  Attribute* a_FCSI_PLL1MISC_sel_clk_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1MISC_sel_clk_0_0->setInstName ("0");
  a_FCSI_PLL1MISC_sel_clk_0_0->setLongName ("");
  a_FCSI_PLL1MISC_sel_clk_0_0->setDescription ("");
  a_FCSI_PLL1MISC_sel_clk_0_0->addItem("ext", "1'b1", "External FSYS clock");
  a_FCSI_PLL1MISC_sel_clk_0_0->addItem("int", "1'b0", "DCXO clock or external single ended clk");
  f_FCSI_PLL1MISC_sel_clk->connectAttribute (a_FCSI_PLL1MISC_sel_clk_0_0);

  RField* f_FCSI_PLL1MISC_rfpll_fast_channel_hop_en = new RField;
  f_FCSI_PLL1MISC_rfpll_fast_channel_hop_en->setInstName ("rfpll_fast_channel_hop_en");
  f_FCSI_PLL1MISC_rfpll_fast_channel_hop_en->setLongName ("EN FAST CHANNEL HOP");
  f_FCSI_PLL1MISC_rfpll_fast_channel_hop_en->setDescription ("Enable fast channel hopping");
  f_FCSI_PLL1MISC_rfpll_fast_channel_hop_en->setDataWidth (1);
  f_FCSI_PLL1MISC_rfpll_fast_channel_hop_en->setResetVal ("1'b0");
  f_FCSI_PLL1MISC_rfpll_fast_channel_hop_en->setAccProp (AccProp::RW);
  r_FCSI_PLL1MISC->connectRField (f_FCSI_PLL1MISC_rfpll_fast_channel_hop_en, 4);

  Attribute* a_FCSI_PLL1MISC_rfpll_fast_channel_hop_en_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1MISC_rfpll_fast_channel_hop_en_0_0->setInstName ("0");
  a_FCSI_PLL1MISC_rfpll_fast_channel_hop_en_0_0->setLongName ("");
  a_FCSI_PLL1MISC_rfpll_fast_channel_hop_en_0_0->setDescription ("");
  a_FCSI_PLL1MISC_rfpll_fast_channel_hop_en_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_PLL1MISC_rfpll_fast_channel_hop_en_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PLL1MISC_rfpll_fast_channel_hop_en->connectAttribute (a_FCSI_PLL1MISC_rfpll_fast_channel_hop_en_0_0);

  RField* f_FCSI_PLL1MISC_rfpll_ref_sel_40M = new RField;
  f_FCSI_PLL1MISC_rfpll_ref_sel_40M->setInstName ("rfpll_ref_sel_40M");
  f_FCSI_PLL1MISC_rfpll_ref_sel_40M->setLongName ("REF SEL 40M");
  f_FCSI_PLL1MISC_rfpll_ref_sel_40M->setDescription ("Reference frequency selection");
  f_FCSI_PLL1MISC_rfpll_ref_sel_40M->setDataWidth (1);
  f_FCSI_PLL1MISC_rfpll_ref_sel_40M->setResetVal ("1'b0");
  f_FCSI_PLL1MISC_rfpll_ref_sel_40M->setAccProp (AccProp::RW);
  r_FCSI_PLL1MISC->connectRField (f_FCSI_PLL1MISC_rfpll_ref_sel_40M, 5);

  Attribute* a_FCSI_PLL1MISC_rfpll_ref_sel_40M_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1MISC_rfpll_ref_sel_40M_0_0->setInstName ("0");
  a_FCSI_PLL1MISC_rfpll_ref_sel_40M_0_0->setLongName ("");
  a_FCSI_PLL1MISC_rfpll_ref_sel_40M_0_0->setDescription ("");
  a_FCSI_PLL1MISC_rfpll_ref_sel_40M_0_0->addItem("1", "1'b1", "40MHz (HP-40MHz/RP-40MHz/2G mode)");
  a_FCSI_PLL1MISC_rfpll_ref_sel_40M_0_0->addItem("0", "1'b0", "10MHz/20MHz depending on rfpll_ref_sel_20M (bit9)");
  f_FCSI_PLL1MISC_rfpll_ref_sel_40M->connectAttribute (a_FCSI_PLL1MISC_rfpll_ref_sel_40M_0_0);

  RField* f_FCSI_PLL1MISC_sel_divn_ref_clk = new RField;
  f_FCSI_PLL1MISC_sel_divn_ref_clk->setInstName ("sel_divn_ref_clk");
  f_FCSI_PLL1MISC_sel_divn_ref_clk->setLongName ("SEL DIVN REF CLK");
  f_FCSI_PLL1MISC_sel_divn_ref_clk->setDescription ("Select clock used by DSM");
  f_FCSI_PLL1MISC_sel_divn_ref_clk->setDataWidth (1);
  f_FCSI_PLL1MISC_sel_divn_ref_clk->setResetVal ("1'b0");
  f_FCSI_PLL1MISC_sel_divn_ref_clk->setAccProp (AccProp::RW);
  r_FCSI_PLL1MISC->connectRField (f_FCSI_PLL1MISC_sel_divn_ref_clk, 6);

  Attribute* a_FCSI_PLL1MISC_sel_divn_ref_clk_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1MISC_sel_divn_ref_clk_0_0->setInstName ("0");
  a_FCSI_PLL1MISC_sel_divn_ref_clk_0_0->setLongName ("");
  a_FCSI_PLL1MISC_sel_divn_ref_clk_0_0->setDescription ("");
  a_FCSI_PLL1MISC_sel_divn_ref_clk_0_0->addItem("1", "1'b1", "Reference Clock");
  a_FCSI_PLL1MISC_sel_divn_ref_clk_0_0->addItem("0", "1'b0", "NC clock");
  f_FCSI_PLL1MISC_sel_divn_ref_clk->connectAttribute (a_FCSI_PLL1MISC_sel_divn_ref_clk_0_0);

  RField* f_FCSI_PLL1MISC_fcal_min_dcap_polarity_sel = new RField;
  f_FCSI_PLL1MISC_fcal_min_dcap_polarity_sel->setInstName ("fcal_min_dcap_polarity_sel");
  f_FCSI_PLL1MISC_fcal_min_dcap_polarity_sel->setLongName ("FCAL MIN DCAP POLARITY SEL");
  f_FCSI_PLL1MISC_fcal_min_dcap_polarity_sel->setDescription ("Select polarity of FCAL count");
  f_FCSI_PLL1MISC_fcal_min_dcap_polarity_sel->setDataWidth (1);
  f_FCSI_PLL1MISC_fcal_min_dcap_polarity_sel->setResetVal ("1'b0");
  f_FCSI_PLL1MISC_fcal_min_dcap_polarity_sel->setAccProp (AccProp::RW);
  r_FCSI_PLL1MISC->connectRField (f_FCSI_PLL1MISC_fcal_min_dcap_polarity_sel, 7);

  Attribute* a_FCSI_PLL1MISC_fcal_min_dcap_polarity_sel_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1MISC_fcal_min_dcap_polarity_sel_0_0->setInstName ("0");
  a_FCSI_PLL1MISC_fcal_min_dcap_polarity_sel_0_0->setLongName ("");
  a_FCSI_PLL1MISC_fcal_min_dcap_polarity_sel_0_0->setDescription ("");
  a_FCSI_PLL1MISC_fcal_min_dcap_polarity_sel_0_0->addItem("1", "1'b1", "FCAL value above the ideal count");
  a_FCSI_PLL1MISC_fcal_min_dcap_polarity_sel_0_0->addItem("0", "1'b0", "FCAL value below the ideal count");
  f_FCSI_PLL1MISC_fcal_min_dcap_polarity_sel->connectAttribute (a_FCSI_PLL1MISC_fcal_min_dcap_polarity_sel_0_0);

  RField* f_FCSI_PLL1MISC_fcal_en_min_dcap_polarity = new RField;
  f_FCSI_PLL1MISC_fcal_en_min_dcap_polarity->setInstName ("fcal_en_min_dcap_polarity");
  f_FCSI_PLL1MISC_fcal_en_min_dcap_polarity->setLongName ("FCAL EN MIN DCAP POLARITY");
  f_FCSI_PLL1MISC_fcal_en_min_dcap_polarity->setDescription ("Speed up settling during channel hopping");
  f_FCSI_PLL1MISC_fcal_en_min_dcap_polarity->setDataWidth (1);
  f_FCSI_PLL1MISC_fcal_en_min_dcap_polarity->setResetVal ("1'b0");
  f_FCSI_PLL1MISC_fcal_en_min_dcap_polarity->setAccProp (AccProp::RW);
  r_FCSI_PLL1MISC->connectRField (f_FCSI_PLL1MISC_fcal_en_min_dcap_polarity, 8);

  Attribute* a_FCSI_PLL1MISC_fcal_en_min_dcap_polarity_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1MISC_fcal_en_min_dcap_polarity_0_0->setInstName ("0");
  a_FCSI_PLL1MISC_fcal_en_min_dcap_polarity_0_0->setLongName ("");
  a_FCSI_PLL1MISC_fcal_en_min_dcap_polarity_0_0->setDescription ("");
  a_FCSI_PLL1MISC_fcal_en_min_dcap_polarity_0_0->addItem("1", "1'b1", "closest FCAL count (higher or lower the ideal count)");
  a_FCSI_PLL1MISC_fcal_en_min_dcap_polarity_0_0->addItem("0", "1'b0", "Least error");
  f_FCSI_PLL1MISC_fcal_en_min_dcap_polarity->connectAttribute (a_FCSI_PLL1MISC_fcal_en_min_dcap_polarity_0_0);

  RField* f_FCSI_PLL1MISC_rfpll_ref_sel_20M = new RField;
  f_FCSI_PLL1MISC_rfpll_ref_sel_20M->setInstName ("rfpll_ref_sel_20M");
  f_FCSI_PLL1MISC_rfpll_ref_sel_20M->setLongName ("RFPLL REF SEL 20M");
  f_FCSI_PLL1MISC_rfpll_ref_sel_20M->setDescription ("Select reference frequency used by PLL in 5G operation");
  f_FCSI_PLL1MISC_rfpll_ref_sel_20M->setDataWidth (1);
  f_FCSI_PLL1MISC_rfpll_ref_sel_20M->setResetVal ("1'b0");
  f_FCSI_PLL1MISC_rfpll_ref_sel_20M->setAccProp (AccProp::RW);
  r_FCSI_PLL1MISC->connectRField (f_FCSI_PLL1MISC_rfpll_ref_sel_20M, 9);

  Attribute* a_FCSI_PLL1MISC_rfpll_ref_sel_20M_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1MISC_rfpll_ref_sel_20M_0_0->setInstName ("0");
  a_FCSI_PLL1MISC_rfpll_ref_sel_20M_0_0->setLongName ("");
  a_FCSI_PLL1MISC_rfpll_ref_sel_20M_0_0->setDescription ("");
  a_FCSI_PLL1MISC_rfpll_ref_sel_20M_0_0->addItem("1", "1'b1", "20MHz if rfpll_ref_sel_40M (bit5) is 0");
  a_FCSI_PLL1MISC_rfpll_ref_sel_20M_0_0->addItem("0", "1'b0", "10MHz if rfpll_ref_sel_40M (bit5) is 0");
  f_FCSI_PLL1MISC_rfpll_ref_sel_20M->connectAttribute (a_FCSI_PLL1MISC_rfpll_ref_sel_20M_0_0);

  RField* f_FCSI_PLL1MISC_pfd_cdd_bump = new RField;
  f_FCSI_PLL1MISC_pfd_cdd_bump->setInstName ("pfd_cdd_bump");
  f_FCSI_PLL1MISC_pfd_cdd_bump->setLongName ("PFD VDD BUMP");
  f_FCSI_PLL1MISC_pfd_cdd_bump->setDescription ("No connect at ana core level");
  f_FCSI_PLL1MISC_pfd_cdd_bump->setDataWidth (1);
  f_FCSI_PLL1MISC_pfd_cdd_bump->setResetVal ("1'b0");
  f_FCSI_PLL1MISC_pfd_cdd_bump->setAccProp (AccProp::RW);
  r_FCSI_PLL1MISC->connectRField (f_FCSI_PLL1MISC_pfd_cdd_bump, 10);

  RField* f_FCSI_PLL1MISC_capboost_ppath = new RField;
  f_FCSI_PLL1MISC_capboost_ppath->setInstName ("capboost_ppath");
  f_FCSI_PLL1MISC_capboost_ppath->setLongName ("CAPBOOST PPATH");
  f_FCSI_PLL1MISC_capboost_ppath->setDescription ("External charge pump current control setting values (Cap boost for 40M modes)");
  f_FCSI_PLL1MISC_capboost_ppath->setDataWidth (3);
  f_FCSI_PLL1MISC_capboost_ppath->setResetVal ("3'b000");
  f_FCSI_PLL1MISC_capboost_ppath->setAccProp (AccProp::RW);
  r_FCSI_PLL1MISC->connectRField (f_FCSI_PLL1MISC_capboost_ppath, 11);

  RField* f_FCSI_PLL1MISC_pfd_rst_dly = new RField;
  f_FCSI_PLL1MISC_pfd_rst_dly->setInstName ("pfd_rst_dly");
  f_FCSI_PLL1MISC_pfd_rst_dly->setLongName ("PFD RST DLY");
  f_FCSI_PLL1MISC_pfd_rst_dly->setDescription ("Reset delay in the PFD");
  f_FCSI_PLL1MISC_pfd_rst_dly->setDataWidth (2);
  f_FCSI_PLL1MISC_pfd_rst_dly->setResetVal ("2'b00");
  f_FCSI_PLL1MISC_pfd_rst_dly->setAccProp (AccProp::RW);
  r_FCSI_PLL1MISC->connectRField (f_FCSI_PLL1MISC_pfd_rst_dly, 14);

  Attribute* a_FCSI_PLL1MISC_pfd_rst_dly_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PLL1MISC_pfd_rst_dly_0_0->setInstName ("0");
  a_FCSI_PLL1MISC_pfd_rst_dly_0_0->setLongName ("");
  a_FCSI_PLL1MISC_pfd_rst_dly_0_0->setDescription ("");
  a_FCSI_PLL1MISC_pfd_rst_dly_0_0->addItem("0", "2'b00", "120ps");
  a_FCSI_PLL1MISC_pfd_rst_dly_0_0->addItem("1", "2'b01", "240ps");
  a_FCSI_PLL1MISC_pfd_rst_dly_0_0->addItem("2", "2'b10", "330ps");
  a_FCSI_PLL1MISC_pfd_rst_dly_0_0->addItem("3", "2'b11", "400ps");
  f_FCSI_PLL1MISC_pfd_rst_dly->connectAttribute (a_FCSI_PLL1MISC_pfd_rst_dly_0_0);

  Register* r_FCSI_PLL1CH2 = new Register;
  r_FCSI_PLL1CH2->setInstName ("PLL1CH2");
  r_FCSI_PLL1CH2->setLongName ("PLL1 FAST CHANNEL HOP 2");
  r_FCSI_PLL1CH2->setDescription ("PLL1-LDO1V2");
  r_FCSI_PLL1CH2->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_PLL1CH2, 0x0000001B);

  RField* f_FCSI_PLL1CH2_div_int_ch2 = new RField;
  f_FCSI_PLL1CH2_div_int_ch2->setInstName ("div_int_ch2");
  f_FCSI_PLL1CH2_div_int_ch2->setLongName ("DIV INT CH2");
  f_FCSI_PLL1CH2_div_int_ch2->setDescription ("Integer value for channel2 (MMD integer input)");
  f_FCSI_PLL1CH2_div_int_ch2->setDataWidth (11);
  f_FCSI_PLL1CH2_div_int_ch2->setResetVal ("11'b00000000000");
  f_FCSI_PLL1CH2_div_int_ch2->setAccProp (AccProp::RW);
  r_FCSI_PLL1CH2->connectRField (f_FCSI_PLL1CH2_div_int_ch2, 0);

  RField* f_FCSI_PLL1CH2_icp_bin_override = new RField;
  f_FCSI_PLL1CH2_icp_bin_override->setInstName ("icp_bin_override");
  f_FCSI_PLL1CH2_icp_bin_override->setLongName ("ICP BIN OVERRIDE");
  f_FCSI_PLL1CH2_icp_bin_override->setDescription ("ICP bin override (external programming value for CP)");
  f_FCSI_PLL1CH2_icp_bin_override->setDataWidth (5);
  f_FCSI_PLL1CH2_icp_bin_override->setResetVal ("5'b00000");
  f_FCSI_PLL1CH2_icp_bin_override->setAccProp (AccProp::RW);
  r_FCSI_PLL1CH2->connectRField (f_FCSI_PLL1CH2_icp_bin_override, 11);

  Register* r_FCSI_PLL1CH3 = new Register;
  r_FCSI_PLL1CH3->setInstName ("PLL1CH3");
  r_FCSI_PLL1CH3->setLongName ("PLL1 FAST CHANNEL HOP 3");
  r_FCSI_PLL1CH3->setDescription ("PLL1-LDO1V2");
  r_FCSI_PLL1CH3->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_PLL1CH3, 0x0000001C);

  RField* f_FCSI_PLL1CH3_div_int_ch3 = new RField;
  f_FCSI_PLL1CH3_div_int_ch3->setInstName ("div_int_ch3");
  f_FCSI_PLL1CH3_div_int_ch3->setLongName ("DIV INT CH3");
  f_FCSI_PLL1CH3_div_int_ch3->setDescription ("Integer value for channel 3  (MMD integer input)");
  f_FCSI_PLL1CH3_div_int_ch3->setDataWidth (11);
  f_FCSI_PLL1CH3_div_int_ch3->setResetVal ("11'b00000000000");
  f_FCSI_PLL1CH3_div_int_ch3->setAccProp (AccProp::RW);
  r_FCSI_PLL1CH3->connectRField (f_FCSI_PLL1CH3_div_int_ch3, 0);

  Register* r_FCSI_PLL1CH4 = new Register;
  r_FCSI_PLL1CH4->setInstName ("PLL1CH4");
  r_FCSI_PLL1CH4->setLongName ("PLL1 FAST CHANNEL HOP 4");
  r_FCSI_PLL1CH4->setDescription ("PLL1-LDO1V2");
  r_FCSI_PLL1CH4->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_PLL1CH4, 0x0000001D);

  RField* f_FCSI_PLL1CH4_div_int_ch4 = new RField;
  f_FCSI_PLL1CH4_div_int_ch4->setInstName ("div_int_ch4");
  f_FCSI_PLL1CH4_div_int_ch4->setLongName ("DIV INT CH4");
  f_FCSI_PLL1CH4_div_int_ch4->setDescription ("Integer value for channel 4  (MMD integer input)");
  f_FCSI_PLL1CH4_div_int_ch4->setDataWidth (11);
  f_FCSI_PLL1CH4_div_int_ch4->setResetVal ("11'b00000000000");
  f_FCSI_PLL1CH4_div_int_ch4->setAccProp (AccProp::RW);
  r_FCSI_PLL1CH4->connectRField (f_FCSI_PLL1CH4_div_int_ch4, 0);

  Register* r_FCSI_PLL1CH5 = new Register;
  r_FCSI_PLL1CH5->setInstName ("PLL1CH5");
  r_FCSI_PLL1CH5->setLongName ("PLL1 FAST CHANNEL HOP 5");
  r_FCSI_PLL1CH5->setDescription ("PLL1-LDO1V2");
  r_FCSI_PLL1CH5->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_PLL1CH5, 0x0000001E);

  RField* f_FCSI_PLL1CH5_div_int_ch5 = new RField;
  f_FCSI_PLL1CH5_div_int_ch5->setInstName ("div_int_ch5");
  f_FCSI_PLL1CH5_div_int_ch5->setLongName ("DIV INT CH5");
  f_FCSI_PLL1CH5_div_int_ch5->setDescription ("Integer value for channel 5  (MMD integer input)");
  f_FCSI_PLL1CH5_div_int_ch5->setDataWidth (11);
  f_FCSI_PLL1CH5_div_int_ch5->setResetVal ("11'b00000000000");
  f_FCSI_PLL1CH5_div_int_ch5->setAccProp (AccProp::RW);
  r_FCSI_PLL1CH5->connectRField (f_FCSI_PLL1CH5_div_int_ch5, 0);

  Register* r_FCSI_PLL1CH6 = new Register;
  r_FCSI_PLL1CH6->setInstName ("PLL1CH6");
  r_FCSI_PLL1CH6->setLongName ("PLL1 FAST CHANNEL HOP 6");
  r_FCSI_PLL1CH6->setDescription ("PLL1-LDO1V2");
  r_FCSI_PLL1CH6->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_PLL1CH6, 0x0000001F);

  RField* f_FCSI_PLL1CH6_div_int_ch6 = new RField;
  f_FCSI_PLL1CH6_div_int_ch6->setInstName ("div_int_ch6");
  f_FCSI_PLL1CH6_div_int_ch6->setLongName ("DIV INT CH6");
  f_FCSI_PLL1CH6_div_int_ch6->setDescription ("Integer value for channel 6  (MMD integer input)");
  f_FCSI_PLL1CH6_div_int_ch6->setDataWidth (11);
  f_FCSI_PLL1CH6_div_int_ch6->setResetVal ("11'b00000000000");
  f_FCSI_PLL1CH6_div_int_ch6->setAccProp (AccProp::RW);
  r_FCSI_PLL1CH6->connectRField (f_FCSI_PLL1CH6_div_int_ch6, 0);

  Register* r_FCSI_DCXO0 = new Register;
  r_FCSI_DCXO0->setInstName ("DCXO0");
  r_FCSI_DCXO0->setLongName ("DCXO 0");
  r_FCSI_DCXO0->setDescription ("FCSI-LDO1V2");
  r_FCSI_DCXO0->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_DCXO0, 0x00000020);

  RField* f_FCSI_DCXO0_cap_trim_x1 = new RField;
  f_FCSI_DCXO0_cap_trim_x1->setInstName ("cap_trim_x1");
  f_FCSI_DCXO0_cap_trim_x1->setLongName ("CAP TRIM X1");
  f_FCSI_DCXO0_cap_trim_x1->setDescription ("XO cap tuning bits");
  f_FCSI_DCXO0_cap_trim_x1->setDataWidth (8);
  f_FCSI_DCXO0_cap_trim_x1->setResetVal ("8'b10010110");
  f_FCSI_DCXO0_cap_trim_x1->setAccProp (AccProp::RW);
  r_FCSI_DCXO0->connectRField (f_FCSI_DCXO0_cap_trim_x1, 0);

  Attribute* a_FCSI_DCXO0_cap_trim_x1_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_DCXO0_cap_trim_x1_0_0->setInstName ("0");
  a_FCSI_DCXO0_cap_trim_x1_0_0->setLongName ("Enumerations for internal XO");
  a_FCSI_DCXO0_cap_trim_x1_0_0->setDescription ("");
  a_FCSI_DCXO0_cap_trim_x1_0_0->addItem("0", "8'b00000000", "147ppm");
  a_FCSI_DCXO0_cap_trim_x1_0_0->addItem("150", "8'b10010110", "0ppm");
  a_FCSI_DCXO0_cap_trim_x1_0_0->addItem("256", "8'b11111111", "-40ppm");
  f_FCSI_DCXO0_cap_trim_x1->connectAttribute (a_FCSI_DCXO0_cap_trim_x1_0_0);

  Attribute* a_FCSI_DCXO0_cap_trim_x1_1_1 = new Attribute(Attribute::ENUM);
  a_FCSI_DCXO0_cap_trim_x1_1_1->setInstName ("1");
  a_FCSI_DCXO0_cap_trim_x1_1_1->setLongName ("Enumerations for external XO");
  a_FCSI_DCXO0_cap_trim_x1_1_1->setDescription ("");
  a_FCSI_DCXO0_cap_trim_x1_1_1->addItem("0", "8'b00000000", "Lowest input capacitance");
  f_FCSI_DCXO0_cap_trim_x1->connectAttribute (a_FCSI_DCXO0_cap_trim_x1_1_1);

  Attribute* a_FCSI_DCXO0_cap_trim_x1_extfsys_x1_2 = new Attribute(Attribute::ENUM);
  a_FCSI_DCXO0_cap_trim_x1_extfsys_x1_2->setInstName ("extfsys_x1");
  a_FCSI_DCXO0_cap_trim_x1_extfsys_x1_2->setLongName ("Enumerations for external FSYS");
  a_FCSI_DCXO0_cap_trim_x1_extfsys_x1_2->setDescription ("");
  a_FCSI_DCXO0_cap_trim_x1_extfsys_x1_2->addItem("0", "8'b00000000", "Lowest input capacitance");
  f_FCSI_DCXO0_cap_trim_x1->connectAttribute (a_FCSI_DCXO0_cap_trim_x1_extfsys_x1_2);

  RField* f_FCSI_DCXO0_cap_trim_x2 = new RField;
  f_FCSI_DCXO0_cap_trim_x2->setInstName ("cap_trim_x2");
  f_FCSI_DCXO0_cap_trim_x2->setLongName ("CAP TRIM X2");
  f_FCSI_DCXO0_cap_trim_x2->setDescription ("XO cap tuning bits");
  f_FCSI_DCXO0_cap_trim_x2->setDataWidth (8);
  f_FCSI_DCXO0_cap_trim_x2->setResetVal ("8'b10010110");
  f_FCSI_DCXO0_cap_trim_x2->setAccProp (AccProp::RW);
  r_FCSI_DCXO0->connectRField (f_FCSI_DCXO0_cap_trim_x2, 8);

  Attribute* a_FCSI_DCXO0_cap_trim_x2_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_DCXO0_cap_trim_x2_0_0->setInstName ("0");
  a_FCSI_DCXO0_cap_trim_x2_0_0->setLongName ("Enumerations for internal XO");
  a_FCSI_DCXO0_cap_trim_x2_0_0->setDescription ("");
  a_FCSI_DCXO0_cap_trim_x2_0_0->addItem("0", "8'b00000000", "147ppm");
  a_FCSI_DCXO0_cap_trim_x2_0_0->addItem("150", "8'b10010110", "0ppm");
  a_FCSI_DCXO0_cap_trim_x2_0_0->addItem("256", "8'b11111111", "-40ppm");
  f_FCSI_DCXO0_cap_trim_x2->connectAttribute (a_FCSI_DCXO0_cap_trim_x2_0_0);

  Attribute* a_FCSI_DCXO0_cap_trim_x2_1_1 = new Attribute(Attribute::ENUM);
  a_FCSI_DCXO0_cap_trim_x2_1_1->setInstName ("1");
  a_FCSI_DCXO0_cap_trim_x2_1_1->setLongName ("Enumerations for external XO");
  a_FCSI_DCXO0_cap_trim_x2_1_1->setDescription ("");
  a_FCSI_DCXO0_cap_trim_x2_1_1->addItem("0", "8'b00000000", "Lowest input capacitance");
  f_FCSI_DCXO0_cap_trim_x2->connectAttribute (a_FCSI_DCXO0_cap_trim_x2_1_1);

  Attribute* a_FCSI_DCXO0_cap_trim_x2_extfsys_x2_2 = new Attribute(Attribute::ENUM);
  a_FCSI_DCXO0_cap_trim_x2_extfsys_x2_2->setInstName ("extfsys_x2");
  a_FCSI_DCXO0_cap_trim_x2_extfsys_x2_2->setLongName ("Enumerations for external FSYS");
  a_FCSI_DCXO0_cap_trim_x2_extfsys_x2_2->setDescription ("");
  a_FCSI_DCXO0_cap_trim_x2_extfsys_x2_2->addItem("0", "8'b00000000", "Lowest input capacitance");
  f_FCSI_DCXO0_cap_trim_x2->connectAttribute (a_FCSI_DCXO0_cap_trim_x2_extfsys_x2_2);

  Register* r_FCSI_DCXO1 = new Register;
  r_FCSI_DCXO1->setInstName ("DCXO1");
  r_FCSI_DCXO1->setLongName ("DCXO 1");
  r_FCSI_DCXO1->setDescription ("FCSI-LDO1V2");
  r_FCSI_DCXO1->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_DCXO1, 0x00000021);

  RField* f_FCSI_DCXO1_ctrl_rpref = new RField;
  f_FCSI_DCXO1_ctrl_rpref->setInstName ("ctrl_rpref");
  f_FCSI_DCXO1_ctrl_rpref->setLongName ("CTRL RPREF");
  f_FCSI_DCXO1_ctrl_rpref->setDescription ("Bump for regulator reference voltage (16uA*R)");
  f_FCSI_DCXO1_ctrl_rpref->setDataWidth (2);
  f_FCSI_DCXO1_ctrl_rpref->setResetVal ("2'b00");
  f_FCSI_DCXO1_ctrl_rpref->setAccProp (AccProp::RW);
  r_FCSI_DCXO1->connectRField (f_FCSI_DCXO1_ctrl_rpref, 0);

  Attribute* a_FCSI_DCXO1_ctrl_rpref_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_DCXO1_ctrl_rpref_0_0->setInstName ("0");
  a_FCSI_DCXO1_ctrl_rpref_0_0->setLongName ("");
  a_FCSI_DCXO1_ctrl_rpref_0_0->setDescription ("");
  a_FCSI_DCXO1_ctrl_rpref_0_0->addItem("0", "2'b00", " 4.5k");
  a_FCSI_DCXO1_ctrl_rpref_0_0->addItem("1", "2'b01", " 9.0k");
  a_FCSI_DCXO1_ctrl_rpref_0_0->addItem("2", "2'b10", "18.0k");
  a_FCSI_DCXO1_ctrl_rpref_0_0->addItem("3", "2'b11", " 2.25k");
  f_FCSI_DCXO1_ctrl_rpref->connectAttribute (a_FCSI_DCXO1_ctrl_rpref_0_0);

  RField* f_FCSI_DCXO1_ctrl_rcdd_xb = new RField;
  f_FCSI_DCXO1_ctrl_rcdd_xb->setInstName ("ctrl_rcdd_xb");
  f_FCSI_DCXO1_ctrl_rcdd_xb->setLongName ("CTRL RCDD XB");
  f_FCSI_DCXO1_ctrl_rcdd_xb->setDescription ("XO inverter chain supply resistor programmability");
  f_FCSI_DCXO1_ctrl_rcdd_xb->setDataWidth (3);
  f_FCSI_DCXO1_ctrl_rcdd_xb->setResetVal ("3'b000");
  f_FCSI_DCXO1_ctrl_rcdd_xb->setAccProp (AccProp::RW);
  r_FCSI_DCXO1->connectRField (f_FCSI_DCXO1_ctrl_rcdd_xb, 2);

  Attribute* a_FCSI_DCXO1_ctrl_rcdd_xb_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_DCXO1_ctrl_rcdd_xb_0_0->setInstName ("0");
  a_FCSI_DCXO1_ctrl_rcdd_xb_0_0->setLongName ("");
  a_FCSI_DCXO1_ctrl_rcdd_xb_0_0->setDescription ("");
  a_FCSI_DCXO1_ctrl_rcdd_xb_0_0->addItem("0", "3'b000", " 600 Ohm");
  a_FCSI_DCXO1_ctrl_rcdd_xb_0_0->addItem("1", "3'b001", " 720 Ohm");
  a_FCSI_DCXO1_ctrl_rcdd_xb_0_0->addItem("2", "3'b010", " 900 Ohm");
  a_FCSI_DCXO1_ctrl_rcdd_xb_0_0->addItem("3", "3'b011", "1200 Ohm");
  a_FCSI_DCXO1_ctrl_rcdd_xb_0_0->addItem("4", "3'b100", " 300 Ohm");
  a_FCSI_DCXO1_ctrl_rcdd_xb_0_0->addItem("5", "3'b101", " 360 Ohm");
  a_FCSI_DCXO1_ctrl_rcdd_xb_0_0->addItem("6", "3'b110", " 450 Ohm");
  a_FCSI_DCXO1_ctrl_rcdd_xb_0_0->addItem("7", "3'b111", " 515 Ohm");
  f_FCSI_DCXO1_ctrl_rcdd_xb->connectAttribute (a_FCSI_DCXO1_ctrl_rcdd_xb_0_0);

  RField* f_FCSI_DCXO1_ctrl_xoamp_rfb = new RField;
  f_FCSI_DCXO1_ctrl_xoamp_rfb->setInstName ("ctrl_xoamp_rfb");
  f_FCSI_DCXO1_ctrl_xoamp_rfb->setLongName ("CTRL XOAMP RFB");
  f_FCSI_DCXO1_ctrl_xoamp_rfb->setDescription ("XO amplifier feedback resistor programmability");
  f_FCSI_DCXO1_ctrl_xoamp_rfb->setDataWidth (2);
  f_FCSI_DCXO1_ctrl_xoamp_rfb->setResetVal ("2'b00");
  f_FCSI_DCXO1_ctrl_xoamp_rfb->setAccProp (AccProp::RW);
  r_FCSI_DCXO1->connectRField (f_FCSI_DCXO1_ctrl_xoamp_rfb, 5);

  Attribute* a_FCSI_DCXO1_ctrl_xoamp_rfb_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_DCXO1_ctrl_xoamp_rfb_0_0->setInstName ("0");
  a_FCSI_DCXO1_ctrl_xoamp_rfb_0_0->setLongName ("");
  a_FCSI_DCXO1_ctrl_xoamp_rfb_0_0->setDescription ("");
  a_FCSI_DCXO1_ctrl_xoamp_rfb_0_0->addItem("0", "2'b00", "36k");
  a_FCSI_DCXO1_ctrl_xoamp_rfb_0_0->addItem("1", "2'b01", "10k");
  a_FCSI_DCXO1_ctrl_xoamp_rfb_0_0->addItem("2", "2'b10", "7.5k");
  a_FCSI_DCXO1_ctrl_xoamp_rfb_0_0->addItem("3", "2'b11", "5k");
  f_FCSI_DCXO1_ctrl_xoamp_rfb->connectAttribute (a_FCSI_DCXO1_ctrl_xoamp_rfb_0_0);

  RField* f_FCSI_DCXO1_ctrl_ampdet_hyst = new RField;
  f_FCSI_DCXO1_ctrl_ampdet_hyst->setInstName ("ctrl_ampdet_hyst");
  f_FCSI_DCXO1_ctrl_ampdet_hyst->setLongName ("CTRL AMPDET HYST");
  f_FCSI_DCXO1_ctrl_ampdet_hyst->setDescription ("Hysteresis for amplitude detect block");
  f_FCSI_DCXO1_ctrl_ampdet_hyst->setDataWidth (2);
  f_FCSI_DCXO1_ctrl_ampdet_hyst->setResetVal ("2'b10");
  f_FCSI_DCXO1_ctrl_ampdet_hyst->setAccProp (AccProp::RW);
  r_FCSI_DCXO1->connectRField (f_FCSI_DCXO1_ctrl_ampdet_hyst, 8);

  Attribute* a_FCSI_DCXO1_ctrl_ampdet_hyst_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_DCXO1_ctrl_ampdet_hyst_0_0->setInstName ("0");
  a_FCSI_DCXO1_ctrl_ampdet_hyst_0_0->setLongName ("");
  a_FCSI_DCXO1_ctrl_ampdet_hyst_0_0->setDescription ("");
  a_FCSI_DCXO1_ctrl_ampdet_hyst_0_0->addItem("0", "2'b00", "0mV");
  a_FCSI_DCXO1_ctrl_ampdet_hyst_0_0->addItem("1", "2'b01", "75mV");
  a_FCSI_DCXO1_ctrl_ampdet_hyst_0_0->addItem("2", "2'b10", "150mV");
  a_FCSI_DCXO1_ctrl_ampdet_hyst_0_0->addItem("3", "2'b11", "225mV");
  f_FCSI_DCXO1_ctrl_ampdet_hyst->connectAttribute (a_FCSI_DCXO1_ctrl_ampdet_hyst_0_0);

  RField* f_FCSI_DCXO1_ctrl_ibias_bump = new RField;
  f_FCSI_DCXO1_ctrl_ibias_bump->setInstName ("ctrl_ibias_bump");
  f_FCSI_DCXO1_ctrl_ibias_bump->setLongName ("CTRL IBIAS BUMP");
  f_FCSI_DCXO1_ctrl_ibias_bump->setDescription ("Bumps for bias currents");
  f_FCSI_DCXO1_ctrl_ibias_bump->setDataWidth (2);
  f_FCSI_DCXO1_ctrl_ibias_bump->setResetVal ("2'b00");
  f_FCSI_DCXO1_ctrl_ibias_bump->setAccProp (AccProp::RW);
  r_FCSI_DCXO1->connectRField (f_FCSI_DCXO1_ctrl_ibias_bump, 10);

  Attribute* a_FCSI_DCXO1_ctrl_ibias_bump_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_DCXO1_ctrl_ibias_bump_0_0->setInstName ("0");
  a_FCSI_DCXO1_ctrl_ibias_bump_0_0->setLongName ("");
  a_FCSI_DCXO1_ctrl_ibias_bump_0_0->setDescription ("");
  a_FCSI_DCXO1_ctrl_ibias_bump_0_0->addItem("0", "2'b00", "64uA");
  a_FCSI_DCXO1_ctrl_ibias_bump_0_0->addItem("1", "2'b01", "68uA");
  a_FCSI_DCXO1_ctrl_ibias_bump_0_0->addItem("2", "2'b10", "72uA");
  a_FCSI_DCXO1_ctrl_ibias_bump_0_0->addItem("3", "2'b11", "76uA");
  f_FCSI_DCXO1_ctrl_ibias_bump->connectAttribute (a_FCSI_DCXO1_ctrl_ibias_bump_0_0);

  RField* f_FCSI_DCXO1_reg_override_faststart = new RField;
  f_FCSI_DCXO1_reg_override_faststart->setInstName ("reg_override_faststart");
  f_FCSI_DCXO1_reg_override_faststart->setLongName ("REG OVERRIDE FASTSTART");
  f_FCSI_DCXO1_reg_override_faststart->setDescription ("Overrides fast-start mode for slow settling bias nodes");
  f_FCSI_DCXO1_reg_override_faststart->setDataWidth (1);
  f_FCSI_DCXO1_reg_override_faststart->setResetVal ("1'b0");
  f_FCSI_DCXO1_reg_override_faststart->setAccProp (AccProp::RW);
  r_FCSI_DCXO1->connectRField (f_FCSI_DCXO1_reg_override_faststart, 12);

  Attribute* a_FCSI_DCXO1_reg_override_faststart_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_DCXO1_reg_override_faststart_0_0->setInstName ("0");
  a_FCSI_DCXO1_reg_override_faststart_0_0->setLongName ("");
  a_FCSI_DCXO1_reg_override_faststart_0_0->setDescription ("");
  a_FCSI_DCXO1_reg_override_faststart_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_DCXO1_reg_override_faststart_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_DCXO1_reg_override_faststart->connectAttribute (a_FCSI_DCXO1_reg_override_faststart_0_0);

  RField* f_FCSI_DCXO1_en_ampdet_curmeas = new RField;
  f_FCSI_DCXO1_en_ampdet_curmeas->setInstName ("en_ampdet_curmeas");
  f_FCSI_DCXO1_en_ampdet_curmeas->setLongName ("EN AMPDET CURMEAS");
  f_FCSI_DCXO1_en_ampdet_curmeas->setDescription ("Enable current measure in amplitude detect block");
  f_FCSI_DCXO1_en_ampdet_curmeas->setDataWidth (1);
  f_FCSI_DCXO1_en_ampdet_curmeas->setResetVal ("1'b0");
  f_FCSI_DCXO1_en_ampdet_curmeas->setAccProp (AccProp::RW);
  r_FCSI_DCXO1->connectRField (f_FCSI_DCXO1_en_ampdet_curmeas, 13);

  Attribute* a_FCSI_DCXO1_en_ampdet_curmeas_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_DCXO1_en_ampdet_curmeas_0_0->setInstName ("0");
  a_FCSI_DCXO1_en_ampdet_curmeas_0_0->setLongName ("");
  a_FCSI_DCXO1_en_ampdet_curmeas_0_0->setDescription ("");
  a_FCSI_DCXO1_en_ampdet_curmeas_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_DCXO1_en_ampdet_curmeas_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_DCXO1_en_ampdet_curmeas->connectAttribute (a_FCSI_DCXO1_en_ampdet_curmeas_0_0);

  RField* f_FCSI_DCXO1_en_curmeas = new RField;
  f_FCSI_DCXO1_en_curmeas->setInstName ("en_curmeas");
  f_FCSI_DCXO1_en_curmeas->setLongName ("EN CURMEAS");
  f_FCSI_DCXO1_en_curmeas->setDescription ("Enable current measure in bias generation block");
  f_FCSI_DCXO1_en_curmeas->setDataWidth (1);
  f_FCSI_DCXO1_en_curmeas->setResetVal ("1'b0");
  f_FCSI_DCXO1_en_curmeas->setAccProp (AccProp::RW);
  r_FCSI_DCXO1->connectRField (f_FCSI_DCXO1_en_curmeas, 14);

  Attribute* a_FCSI_DCXO1_en_curmeas_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_DCXO1_en_curmeas_0_0->setInstName ("0");
  a_FCSI_DCXO1_en_curmeas_0_0->setLongName ("");
  a_FCSI_DCXO1_en_curmeas_0_0->setDescription ("");
  a_FCSI_DCXO1_en_curmeas_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_DCXO1_en_curmeas_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_DCXO1_en_curmeas->connectAttribute (a_FCSI_DCXO1_en_curmeas_0_0);

  RField* f_FCSI_DCXO1_rc_fast_start = new RField;
  f_FCSI_DCXO1_rc_fast_start->setInstName ("rc_fast_start");
  f_FCSI_DCXO1_rc_fast_start->setLongName ("RC FAST START");
  f_FCSI_DCXO1_rc_fast_start->setDescription ("Enable RC fast-start of XO");
  f_FCSI_DCXO1_rc_fast_start->setDataWidth (1);
  f_FCSI_DCXO1_rc_fast_start->setResetVal ("1'b0");
  f_FCSI_DCXO1_rc_fast_start->setAccProp (AccProp::RW);
  r_FCSI_DCXO1->connectRField (f_FCSI_DCXO1_rc_fast_start, 15);

  Attribute* a_FCSI_DCXO1_rc_fast_start_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_DCXO1_rc_fast_start_0_0->setInstName ("0");
  a_FCSI_DCXO1_rc_fast_start_0_0->setLongName ("");
  a_FCSI_DCXO1_rc_fast_start_0_0->setDescription ("");
  a_FCSI_DCXO1_rc_fast_start_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_DCXO1_rc_fast_start_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_DCXO1_rc_fast_start->connectAttribute (a_FCSI_DCXO1_rc_fast_start_0_0);

  Register* r_FCSI_DCXO2 = new Register;
  r_FCSI_DCXO2->setInstName ("DCXO2");
  r_FCSI_DCXO2->setLongName ("DCXO 2");
  r_FCSI_DCXO2->setDescription ("FCSI-LDO1V2");
  r_FCSI_DCXO2->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_DCXO2, 0x00000022);

  RField* f_FCSI_DCXO2_disable_diag_xo_pll = new RField;
  f_FCSI_DCXO2_disable_diag_xo_pll->setInstName ("disable_diag_xo_pll");
  f_FCSI_DCXO2_disable_diag_xo_pll->setLongName ("DISABLE DIAG XO PLL");
  f_FCSI_DCXO2_disable_diag_xo_pll->setDescription ("Disable diag XO PLL (disconnect 50k)");
  f_FCSI_DCXO2_disable_diag_xo_pll->setDataWidth (1);
  f_FCSI_DCXO2_disable_diag_xo_pll->setResetVal ("1'b1");
  f_FCSI_DCXO2_disable_diag_xo_pll->setAccProp (AccProp::RW);
  r_FCSI_DCXO2->connectRField (f_FCSI_DCXO2_disable_diag_xo_pll, 0);

  Attribute* a_FCSI_DCXO2_disable_diag_xo_pll_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_DCXO2_disable_diag_xo_pll_0_0->setInstName ("0");
  a_FCSI_DCXO2_disable_diag_xo_pll_0_0->setLongName ("");
  a_FCSI_DCXO2_disable_diag_xo_pll_0_0->setDescription ("");
  a_FCSI_DCXO2_disable_diag_xo_pll_0_0->addItem("1", "1'b1", "disable");
  a_FCSI_DCXO2_disable_diag_xo_pll_0_0->addItem("0", "1'b0", "enable");
  f_FCSI_DCXO2_disable_diag_xo_pll->connectAttribute (a_FCSI_DCXO2_disable_diag_xo_pll_0_0);

  RField* f_FCSI_DCXO2_clamp_en = new RField;
  f_FCSI_DCXO2_clamp_en->setInstName ("clamp_en");
  f_FCSI_DCXO2_clamp_en->setLongName ("CLAMP EN");
  f_FCSI_DCXO2_clamp_en->setDescription ("Enable clamp");
  f_FCSI_DCXO2_clamp_en->setDataWidth (1);
  f_FCSI_DCXO2_clamp_en->setResetVal ("1'b0");
  f_FCSI_DCXO2_clamp_en->setAccProp (AccProp::RW);
  r_FCSI_DCXO2->connectRField (f_FCSI_DCXO2_clamp_en, 2);

  Attribute* a_FCSI_DCXO2_clamp_en_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_DCXO2_clamp_en_0_0->setInstName ("0");
  a_FCSI_DCXO2_clamp_en_0_0->setLongName ("");
  a_FCSI_DCXO2_clamp_en_0_0->setDescription ("");
  a_FCSI_DCXO2_clamp_en_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_DCXO2_clamp_en_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_DCXO2_clamp_en->connectAttribute (a_FCSI_DCXO2_clamp_en_0_0);

  RField* f_FCSI_DCXO2_force_det_high = new RField;
  f_FCSI_DCXO2_force_det_high->setInstName ("force_det_high");
  f_FCSI_DCXO2_force_det_high->setLongName ("FORCE DET HIGH");
  f_FCSI_DCXO2_force_det_high->setDescription ("Clock output pypasses amp detect block");
  f_FCSI_DCXO2_force_det_high->setDataWidth (1);
  f_FCSI_DCXO2_force_det_high->setResetVal ("1'b0");
  f_FCSI_DCXO2_force_det_high->setAccProp (AccProp::RW);
  r_FCSI_DCXO2->connectRField (f_FCSI_DCXO2_force_det_high, 3);

  Attribute* a_FCSI_DCXO2_force_det_high_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_DCXO2_force_det_high_0_0->setInstName ("0");
  a_FCSI_DCXO2_force_det_high_0_0->setLongName ("");
  a_FCSI_DCXO2_force_det_high_0_0->setDescription ("");
  a_FCSI_DCXO2_force_det_high_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_DCXO2_force_det_high_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_DCXO2_force_det_high->connectAttribute (a_FCSI_DCXO2_force_det_high_0_0);

  RField* f_FCSI_DCXO2_pup_pll1clk_drv_lv = new RField;
  f_FCSI_DCXO2_pup_pll1clk_drv_lv->setInstName ("pup_pll1clk_drv_lv");
  f_FCSI_DCXO2_pup_pll1clk_drv_lv->setLongName ("PUP PLL1CLK DRV LV");
  f_FCSI_DCXO2_pup_pll1clk_drv_lv->setDescription ("Power up control for PLL1 clock driver");
  f_FCSI_DCXO2_pup_pll1clk_drv_lv->setDataWidth (1);
  f_FCSI_DCXO2_pup_pll1clk_drv_lv->setResetVal ("1'b1");
  f_FCSI_DCXO2_pup_pll1clk_drv_lv->setAccProp (AccProp::RW);
  r_FCSI_DCXO2->connectRField (f_FCSI_DCXO2_pup_pll1clk_drv_lv, 4);

  Attribute* a_FCSI_DCXO2_pup_pll1clk_drv_lv_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_DCXO2_pup_pll1clk_drv_lv_0_0->setInstName ("0");
  a_FCSI_DCXO2_pup_pll1clk_drv_lv_0_0->setLongName ("");
  a_FCSI_DCXO2_pup_pll1clk_drv_lv_0_0->setDescription ("");
  a_FCSI_DCXO2_pup_pll1clk_drv_lv_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_DCXO2_pup_pll1clk_drv_lv_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_DCXO2_pup_pll1clk_drv_lv->connectAttribute (a_FCSI_DCXO2_pup_pll1clk_drv_lv_0_0);

  RField* f_FCSI_DCXO2_pup_fsysclc_drv_lv = new RField;
  f_FCSI_DCXO2_pup_fsysclc_drv_lv->setInstName ("pup_fsysclc_drv_lv");
  f_FCSI_DCXO2_pup_fsysclc_drv_lv->setLongName ("PUP FSYSCLC DRV LV");
  f_FCSI_DCXO2_pup_fsysclc_drv_lv->setDescription ("Power up control for FSYS clock driver");
  f_FCSI_DCXO2_pup_fsysclc_drv_lv->setDataWidth (1);
  f_FCSI_DCXO2_pup_fsysclc_drv_lv->setResetVal ("1'b1");
  f_FCSI_DCXO2_pup_fsysclc_drv_lv->setAccProp (AccProp::RW);
  r_FCSI_DCXO2->connectRField (f_FCSI_DCXO2_pup_fsysclc_drv_lv, 5);

  Attribute* a_FCSI_DCXO2_pup_fsysclc_drv_lv_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_DCXO2_pup_fsysclc_drv_lv_0_0->setInstName ("0");
  a_FCSI_DCXO2_pup_fsysclc_drv_lv_0_0->setLongName ("");
  a_FCSI_DCXO2_pup_fsysclc_drv_lv_0_0->setDescription ("");
  a_FCSI_DCXO2_pup_fsysclc_drv_lv_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_DCXO2_pup_fsysclc_drv_lv_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_DCXO2_pup_fsysclc_drv_lv->connectAttribute (a_FCSI_DCXO2_pup_fsysclc_drv_lv_0_0);

  RField* f_FCSI_DCXO2_pup_pllclk_drv_lv = new RField;
  f_FCSI_DCXO2_pup_pllclk_drv_lv->setInstName ("pup_pllclk_drv_lv");
  f_FCSI_DCXO2_pup_pllclk_drv_lv->setLongName ("PUP PLLCLK DRV LV");
  f_FCSI_DCXO2_pup_pllclk_drv_lv->setDescription ("Power up control for PLL clock driver");
  f_FCSI_DCXO2_pup_pllclk_drv_lv->setDataWidth (1);
  f_FCSI_DCXO2_pup_pllclk_drv_lv->setResetVal ("1'b1");
  f_FCSI_DCXO2_pup_pllclk_drv_lv->setAccProp (AccProp::RW);
  r_FCSI_DCXO2->connectRField (f_FCSI_DCXO2_pup_pllclk_drv_lv, 6);

  Attribute* a_FCSI_DCXO2_pup_pllclk_drv_lv_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_DCXO2_pup_pllclk_drv_lv_0_0->setInstName ("0");
  a_FCSI_DCXO2_pup_pllclk_drv_lv_0_0->setLongName ("");
  a_FCSI_DCXO2_pup_pllclk_drv_lv_0_0->setDescription ("");
  a_FCSI_DCXO2_pup_pllclk_drv_lv_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_DCXO2_pup_pllclk_drv_lv_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_DCXO2_pup_pllclk_drv_lv->connectAttribute (a_FCSI_DCXO2_pup_pllclk_drv_lv_0_0);

  RField* f_FCSI_DCXO2_ctrl_ampdet_threshold = new RField;
  f_FCSI_DCXO2_ctrl_ampdet_threshold->setInstName ("ctrl_ampdet_threshold");
  f_FCSI_DCXO2_ctrl_ampdet_threshold->setLongName ("CTRL AMPDET THRESHOLD");
  f_FCSI_DCXO2_ctrl_ampdet_threshold->setDescription ("Threshold for amplitude detect block");
  f_FCSI_DCXO2_ctrl_ampdet_threshold->setDataWidth (2);
  f_FCSI_DCXO2_ctrl_ampdet_threshold->setResetVal ("2'b00");
  f_FCSI_DCXO2_ctrl_ampdet_threshold->setAccProp (AccProp::RW);
  r_FCSI_DCXO2->connectRField (f_FCSI_DCXO2_ctrl_ampdet_threshold, 7);

  Attribute* a_FCSI_DCXO2_ctrl_ampdet_threshold_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_DCXO2_ctrl_ampdet_threshold_0_0->setInstName ("0");
  a_FCSI_DCXO2_ctrl_ampdet_threshold_0_0->setLongName ("");
  a_FCSI_DCXO2_ctrl_ampdet_threshold_0_0->setDescription ("");
  a_FCSI_DCXO2_ctrl_ampdet_threshold_0_0->addItem("0", "2'b00", "150mV");
  a_FCSI_DCXO2_ctrl_ampdet_threshold_0_0->addItem("1", "2'b01", "200mV");
  a_FCSI_DCXO2_ctrl_ampdet_threshold_0_0->addItem("2", "2'b10", "250mV");
  a_FCSI_DCXO2_ctrl_ampdet_threshold_0_0->addItem("3", "2'b11", "300mV");
  f_FCSI_DCXO2_ctrl_ampdet_threshold->connectAttribute (a_FCSI_DCXO2_ctrl_ampdet_threshold_0_0);

  RField* f_FCSI_DCXO2_ctrl_rc_faststart_res = new RField;
  f_FCSI_DCXO2_ctrl_rc_faststart_res->setInstName ("ctrl_rc_faststart_res");
  f_FCSI_DCXO2_ctrl_rc_faststart_res->setLongName ("CTRL RC FAST START RES");
  f_FCSI_DCXO2_ctrl_rc_faststart_res->setDescription ("RC fast start resistor programabilty");
  f_FCSI_DCXO2_ctrl_rc_faststart_res->setDataWidth (2);
  f_FCSI_DCXO2_ctrl_rc_faststart_res->setResetVal ("2'b00");
  f_FCSI_DCXO2_ctrl_rc_faststart_res->setAccProp (AccProp::RW);
  r_FCSI_DCXO2->connectRField (f_FCSI_DCXO2_ctrl_rc_faststart_res, 9);

  Attribute* a_FCSI_DCXO2_ctrl_rc_faststart_res_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_DCXO2_ctrl_rc_faststart_res_0_0->setInstName ("0");
  a_FCSI_DCXO2_ctrl_rc_faststart_res_0_0->setLongName ("");
  a_FCSI_DCXO2_ctrl_rc_faststart_res_0_0->setDescription ("");
  a_FCSI_DCXO2_ctrl_rc_faststart_res_0_0->addItem("0", "2'b00", "4*1.85MOhm");
  a_FCSI_DCXO2_ctrl_rc_faststart_res_0_0->addItem("1", "2'b01", "3*1.85MOhm");
  a_FCSI_DCXO2_ctrl_rc_faststart_res_0_0->addItem("2", "2'b10", "2*1.85MOhm");
  a_FCSI_DCXO2_ctrl_rc_faststart_res_0_0->addItem("3", "2'b11", "6*1.85MOhm");
  f_FCSI_DCXO2_ctrl_rc_faststart_res->connectAttribute (a_FCSI_DCXO2_ctrl_rc_faststart_res_0_0);

  RField* f_FCSI_DCXO2_diag_sel = new RField;
  f_FCSI_DCXO2_diag_sel->setInstName ("diag_sel");
  f_FCSI_DCXO2_diag_sel->setLongName ("DIAG SEL");
  f_FCSI_DCXO2_diag_sel->setDescription ("Diag select bit");
  f_FCSI_DCXO2_diag_sel->setDataWidth (1);
  f_FCSI_DCXO2_diag_sel->setResetVal ("1'b0");
  f_FCSI_DCXO2_diag_sel->setAccProp (AccProp::RW);
  r_FCSI_DCXO2->connectRField (f_FCSI_DCXO2_diag_sel, 11);

  Attribute* a_FCSI_DCXO2_diag_sel_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_DCXO2_diag_sel_0_0->setInstName ("0");
  a_FCSI_DCXO2_diag_sel_0_0->setLongName ("");
  a_FCSI_DCXO2_diag_sel_0_0->setDescription ("");
  a_FCSI_DCXO2_diag_sel_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_DCXO2_diag_sel_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_DCXO2_diag_sel->connectAttribute (a_FCSI_DCXO2_diag_sel_0_0);

  RField* f_FCSI_DCXO2_diag_code = new RField;
  f_FCSI_DCXO2_diag_code->setInstName ("diag_code");
  f_FCSI_DCXO2_diag_code->setLongName ("DIAG CODE");
  f_FCSI_DCXO2_diag_code->setDescription ("Diag code");
  f_FCSI_DCXO2_diag_code->setDataWidth (4);
  f_FCSI_DCXO2_diag_code->setResetVal ("4'b0000");
  f_FCSI_DCXO2_diag_code->setAccProp (AccProp::RW);
  r_FCSI_DCXO2->connectRField (f_FCSI_DCXO2_diag_code, 12);

  Attribute* a_FCSI_DCXO2_diag_code_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_DCXO2_diag_code_0_0->setInstName ("0");
  a_FCSI_DCXO2_diag_code_0_0->setLongName ("");
  a_FCSI_DCXO2_diag_code_0_0->setDescription ("");
  a_FCSI_DCXO2_diag_code_0_0->addItem("0", "4'b0000", "Default");
  f_FCSI_DCXO2_diag_code->connectAttribute (a_FCSI_DCXO2_diag_code_0_0);

  Register* r_FCSI_DCXO3 = new Register;
  r_FCSI_DCXO3->setInstName ("DCXO3");
  r_FCSI_DCXO3->setLongName ("DCXO 3");
  r_FCSI_DCXO3->setDescription ("FCSI-LDO1V2");
  r_FCSI_DCXO3->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_DCXO3, 0x00000023);

  RField* f_FCSI_DCXO3_ctrl_buffer_rfb = new RField;
  f_FCSI_DCXO3_ctrl_buffer_rfb->setInstName ("ctrl_buffer_rfb");
  f_FCSI_DCXO3_ctrl_buffer_rfb->setLongName ("CTRL BUFFER RFB");
  f_FCSI_DCXO3_ctrl_buffer_rfb->setDescription ("Ctrl buffer Rfb");
  f_FCSI_DCXO3_ctrl_buffer_rfb->setDataWidth (2);
  f_FCSI_DCXO3_ctrl_buffer_rfb->setResetVal ("2'b10");
  f_FCSI_DCXO3_ctrl_buffer_rfb->setAccProp (AccProp::RW);
  r_FCSI_DCXO3->connectRField (f_FCSI_DCXO3_ctrl_buffer_rfb, 1);

  Attribute* a_FCSI_DCXO3_ctrl_buffer_rfb_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_DCXO3_ctrl_buffer_rfb_0_0->setInstName ("0");
  a_FCSI_DCXO3_ctrl_buffer_rfb_0_0->setLongName ("");
  a_FCSI_DCXO3_ctrl_buffer_rfb_0_0->setDescription ("");
  a_FCSI_DCXO3_ctrl_buffer_rfb_0_0->addItem("0", "2'b00", "60k");
  a_FCSI_DCXO3_ctrl_buffer_rfb_0_0->addItem("1", "2'b01", "10k");
  a_FCSI_DCXO3_ctrl_buffer_rfb_0_0->addItem("2", "2'b10", "7.5k");
  a_FCSI_DCXO3_ctrl_buffer_rfb_0_0->addItem("3", "2'b11", "5k");
  f_FCSI_DCXO3_ctrl_buffer_rfb->connectAttribute (a_FCSI_DCXO3_ctrl_buffer_rfb_0_0);

  RField* f_FCSI_DCXO3_pup_pll0clk_inv_lv = new RField;
  f_FCSI_DCXO3_pup_pll0clk_inv_lv->setInstName ("pup_pll0clk_inv_lv");
  f_FCSI_DCXO3_pup_pll0clk_inv_lv->setLongName ("PUP PLL0 CLK INV LV");
  f_FCSI_DCXO3_pup_pll0clk_inv_lv->setDescription ("Clock inversion control for PLL0 clock driver");
  f_FCSI_DCXO3_pup_pll0clk_inv_lv->setDataWidth (1);
  f_FCSI_DCXO3_pup_pll0clk_inv_lv->setResetVal ("1'b0");
  f_FCSI_DCXO3_pup_pll0clk_inv_lv->setAccProp (AccProp::RW);
  r_FCSI_DCXO3->connectRField (f_FCSI_DCXO3_pup_pll0clk_inv_lv, 3);

  Attribute* a_FCSI_DCXO3_pup_pll0clk_inv_lv_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_DCXO3_pup_pll0clk_inv_lv_0_0->setInstName ("0");
  a_FCSI_DCXO3_pup_pll0clk_inv_lv_0_0->setLongName ("");
  a_FCSI_DCXO3_pup_pll0clk_inv_lv_0_0->setDescription ("");
  a_FCSI_DCXO3_pup_pll0clk_inv_lv_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_DCXO3_pup_pll0clk_inv_lv_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_DCXO3_pup_pll0clk_inv_lv->connectAttribute (a_FCSI_DCXO3_pup_pll0clk_inv_lv_0_0);

  RField* f_FCSI_DCXO3_pup_pll1clk_inv_lv = new RField;
  f_FCSI_DCXO3_pup_pll1clk_inv_lv->setInstName ("pup_pll1clk_inv_lv");
  f_FCSI_DCXO3_pup_pll1clk_inv_lv->setLongName ("PUP PLL1 CLK INV LV");
  f_FCSI_DCXO3_pup_pll1clk_inv_lv->setDescription ("Clock inversion control for PLL1 clock driver");
  f_FCSI_DCXO3_pup_pll1clk_inv_lv->setDataWidth (1);
  f_FCSI_DCXO3_pup_pll1clk_inv_lv->setResetVal ("1'b0");
  f_FCSI_DCXO3_pup_pll1clk_inv_lv->setAccProp (AccProp::RW);
  r_FCSI_DCXO3->connectRField (f_FCSI_DCXO3_pup_pll1clk_inv_lv, 4);

  Attribute* a_FCSI_DCXO3_pup_pll1clk_inv_lv_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_DCXO3_pup_pll1clk_inv_lv_0_0->setInstName ("0");
  a_FCSI_DCXO3_pup_pll1clk_inv_lv_0_0->setLongName ("");
  a_FCSI_DCXO3_pup_pll1clk_inv_lv_0_0->setDescription ("");
  a_FCSI_DCXO3_pup_pll1clk_inv_lv_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_DCXO3_pup_pll1clk_inv_lv_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_DCXO3_pup_pll1clk_inv_lv->connectAttribute (a_FCSI_DCXO3_pup_pll1clk_inv_lv_0_0);

  RField* f_FCSI_DCXO3_amp_slice_prog = new RField;
  f_FCSI_DCXO3_amp_slice_prog->setInstName ("amp_slice_prog");
  f_FCSI_DCXO3_amp_slice_prog->setLongName ("AMP SLICE PROG");
  f_FCSI_DCXO3_amp_slice_prog->setDescription ("Amplifier slice programmability (din*128uA, din=0:15");
  f_FCSI_DCXO3_amp_slice_prog->setDataWidth (4);
  f_FCSI_DCXO3_amp_slice_prog->setResetVal ("4'b0110");
  f_FCSI_DCXO3_amp_slice_prog->setAccProp (AccProp::RW);
  r_FCSI_DCXO3->connectRField (f_FCSI_DCXO3_amp_slice_prog, 10);

  Attribute* a_FCSI_DCXO3_amp_slice_prog_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_DCXO3_amp_slice_prog_0_0->setInstName ("0");
  a_FCSI_DCXO3_amp_slice_prog_0_0->setLongName ("");
  a_FCSI_DCXO3_amp_slice_prog_0_0->setDescription ("");
  a_FCSI_DCXO3_amp_slice_prog_0_0->addItem("0", "4'b0000", "0uA");
  a_FCSI_DCXO3_amp_slice_prog_0_0->addItem("1", "4'b0001", "128uA");
  a_FCSI_DCXO3_amp_slice_prog_0_0->addItem("2", "4'b0010", "256uA");
  a_FCSI_DCXO3_amp_slice_prog_0_0->addItem("3", "4'b0011", "384uA");
  a_FCSI_DCXO3_amp_slice_prog_0_0->addItem("4", "4'b0100", "512uA");
  a_FCSI_DCXO3_amp_slice_prog_0_0->addItem("5", "4'b0101", "640uA");
  a_FCSI_DCXO3_amp_slice_prog_0_0->addItem("6", "4'b0110", "768uA");
  a_FCSI_DCXO3_amp_slice_prog_0_0->addItem("7", "4'b0111", "896uA");
  a_FCSI_DCXO3_amp_slice_prog_0_0->addItem("8", "4'b1000", "1024uA");
  a_FCSI_DCXO3_amp_slice_prog_0_0->addItem("9", "4'b1001", "1152uA");
  a_FCSI_DCXO3_amp_slice_prog_0_0->addItem("10", "4'b1010", "1280uA");
  a_FCSI_DCXO3_amp_slice_prog_0_0->addItem("11", "4'b1011", "1408uA");
  a_FCSI_DCXO3_amp_slice_prog_0_0->addItem("12", "4'b1100", "1536uA");
  a_FCSI_DCXO3_amp_slice_prog_0_0->addItem("13", "4'b1101", "1664uA");
  a_FCSI_DCXO3_amp_slice_prog_0_0->addItem("14", "4'b1110", "1792uA");
  a_FCSI_DCXO3_amp_slice_prog_0_0->addItem("15", "4'b1111", "1920uA");
  f_FCSI_DCXO3_amp_slice_prog->connectAttribute (a_FCSI_DCXO3_amp_slice_prog_0_0);

  RField* f_FCSI_DCXO3_clamp_ctrl = new RField;
  f_FCSI_DCXO3_clamp_ctrl->setInstName ("clamp_ctrl");
  f_FCSI_DCXO3_clamp_ctrl->setLongName ("CLAMP CTRL");
  f_FCSI_DCXO3_clamp_ctrl->setDescription ("Clamp threshold voltage");
  f_FCSI_DCXO3_clamp_ctrl->setDataWidth (2);
  f_FCSI_DCXO3_clamp_ctrl->setResetVal ("2'b00");
  f_FCSI_DCXO3_clamp_ctrl->setAccProp (AccProp::RW);
  r_FCSI_DCXO3->connectRField (f_FCSI_DCXO3_clamp_ctrl, 14);

  Attribute* a_FCSI_DCXO3_clamp_ctrl_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_DCXO3_clamp_ctrl_0_0->setInstName ("0");
  a_FCSI_DCXO3_clamp_ctrl_0_0->setLongName ("");
  a_FCSI_DCXO3_clamp_ctrl_0_0->setDescription ("");
  a_FCSI_DCXO3_clamp_ctrl_0_0->addItem("0", "2'b00", "900mV");
  a_FCSI_DCXO3_clamp_ctrl_0_0->addItem("1", "2'b01", "975mV");
  a_FCSI_DCXO3_clamp_ctrl_0_0->addItem("2", "2'b10", "1050mV");
  a_FCSI_DCXO3_clamp_ctrl_0_0->addItem("3", "2'b11", "1125mV");
  f_FCSI_DCXO3_clamp_ctrl->connectAttribute (a_FCSI_DCXO3_clamp_ctrl_0_0);

  Register* r_FCSI_FSYS = new Register;
  r_FCSI_FSYS->setInstName ("FSYS");
  r_FCSI_FSYS->setLongName ("FSYS 1 + 2");
  r_FCSI_FSYS->setDescription ("FCSI-LDO1V2");
  r_FCSI_FSYS->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_FSYS, 0x00000024);

  RField* f_FCSI_FSYS_disable = new RField;
  f_FCSI_FSYS_disable->setInstName ("disable");
  f_FCSI_FSYS_disable->setLongName ("DISABLE");
  f_FCSI_FSYS_disable->setDescription ("Disable FSYS2");
  f_FCSI_FSYS_disable->setDataWidth (1);
  f_FCSI_FSYS_disable->setResetVal ("1'b0");
  f_FCSI_FSYS_disable->setAccProp (AccProp::RW);
  r_FCSI_FSYS->connectRField (f_FCSI_FSYS_disable, 0);

  Attribute* a_FCSI_FSYS_disable_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_FSYS_disable_0_0->setInstName ("0");
  a_FCSI_FSYS_disable_0_0->setLongName ("");
  a_FCSI_FSYS_disable_0_0->setDescription ("");
  a_FCSI_FSYS_disable_0_0->addItem("1", "1'b1", "disable");
  a_FCSI_FSYS_disable_0_0->addItem("0", "1'b0", "enable");
  f_FCSI_FSYS_disable->connectAttribute (a_FCSI_FSYS_disable_0_0);

  RField* f_FCSI_FSYS_ctl_fsys2_res = new RField;
  f_FCSI_FSYS_ctl_fsys2_res->setInstName ("ctl_fsys2_res");
  f_FCSI_FSYS_ctl_fsys2_res->setLongName ("CTL FSYS2 RES");
  f_FCSI_FSYS_ctl_fsys2_res->setDescription ("Control buffer load resistors (only PCB for FSYS2 - no mode selection)");
  f_FCSI_FSYS_ctl_fsys2_res->setDataWidth (3);
  f_FCSI_FSYS_ctl_fsys2_res->setResetVal ("3'b001");
  f_FCSI_FSYS_ctl_fsys2_res->setAccProp (AccProp::RW);
  r_FCSI_FSYS->connectRField (f_FCSI_FSYS_ctl_fsys2_res, 1);

  Attribute* a_FCSI_FSYS_ctl_fsys2_res_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_FSYS_ctl_fsys2_res_0_0->setInstName ("0");
  a_FCSI_FSYS_ctl_fsys2_res_0_0->setLongName ("");
  a_FCSI_FSYS_ctl_fsys2_res_0_0->setDescription ("");
  a_FCSI_FSYS_ctl_fsys2_res_0_0->addItem("3", "3'b011", "not used");
  a_FCSI_FSYS_ctl_fsys2_res_0_0->addItem("2", "3'b010", "125Ohm");
  a_FCSI_FSYS_ctl_fsys2_res_0_0->addItem("1", "3'b001", "105Ohm");
  a_FCSI_FSYS_ctl_fsys2_res_0_0->addItem("0", "3'b000", "83Ohm");
  a_FCSI_FSYS_ctl_fsys2_res_0_0->addItem("7", "3'b111", "63Ohm");
  a_FCSI_FSYS_ctl_fsys2_res_0_0->addItem("6", "3'b110", "not used");
  a_FCSI_FSYS_ctl_fsys2_res_0_0->addItem("5", "3'b101", "not used");
  a_FCSI_FSYS_ctl_fsys2_res_0_0->addItem("4", "3'b100", "not used");
  f_FCSI_FSYS_ctl_fsys2_res->connectAttribute (a_FCSI_FSYS_ctl_fsys2_res_0_0);

  RField* f_FCSI_FSYS_ctl_fsys2_cm = new RField;
  f_FCSI_FSYS_ctl_fsys2_cm->setInstName ("ctl_fsys2_cm");
  f_FCSI_FSYS_ctl_fsys2_cm->setLongName ("CTL FSYS2 CM");
  f_FCSI_FSYS_ctl_fsys2_cm->setDescription ("Control buffer current (only PCB for FSYS2 - no mode selection)");
  f_FCSI_FSYS_ctl_fsys2_cm->setDataWidth (3);
  f_FCSI_FSYS_ctl_fsys2_cm->setResetVal ("3'b111");
  f_FCSI_FSYS_ctl_fsys2_cm->setAccProp (AccProp::RW);
  r_FCSI_FSYS->connectRField (f_FCSI_FSYS_ctl_fsys2_cm, 4);

  Attribute* a_FCSI_FSYS_ctl_fsys2_cm_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_FSYS_ctl_fsys2_cm_0_0->setInstName ("0");
  a_FCSI_FSYS_ctl_fsys2_cm_0_0->setLongName ("");
  a_FCSI_FSYS_ctl_fsys2_cm_0_0->setDescription ("");
  a_FCSI_FSYS_ctl_fsys2_cm_0_0->addItem("3", "3'b011", "not used");
  a_FCSI_FSYS_ctl_fsys2_cm_0_0->addItem("2", "3'b010", "9mA");
  a_FCSI_FSYS_ctl_fsys2_cm_0_0->addItem("1", "3'b001", "7.5mA");
  a_FCSI_FSYS_ctl_fsys2_cm_0_0->addItem("0", "3'b000", "6mA");
  a_FCSI_FSYS_ctl_fsys2_cm_0_0->addItem("7", "3'b111", "4.5mA");
  a_FCSI_FSYS_ctl_fsys2_cm_0_0->addItem("6", "3'b110", "not used");
  a_FCSI_FSYS_ctl_fsys2_cm_0_0->addItem("5", "3'b101", "not used");
  a_FCSI_FSYS_ctl_fsys2_cm_0_0->addItem("4", "3'b100", "not used");
  f_FCSI_FSYS_ctl_fsys2_cm->connectAttribute (a_FCSI_FSYS_ctl_fsys2_cm_0_0);

  RField* f_FCSI_FSYS_ctl_fsys1_res = new RField;
  f_FCSI_FSYS_ctl_fsys1_res->setInstName ("ctl_fsys1_res");
  f_FCSI_FSYS_ctl_fsys1_res->setLongName ("CTL FSYS1 RES");
  f_FCSI_FSYS_ctl_fsys1_res->setDescription ("Control buffer load resistors (for PCB | MCM depending on the mode selection)");
  f_FCSI_FSYS_ctl_fsys1_res->setDataWidth (3);
  f_FCSI_FSYS_ctl_fsys1_res->setResetVal ("3'b000");
  f_FCSI_FSYS_ctl_fsys1_res->setAccProp (AccProp::RW);
  r_FCSI_FSYS->connectRField (f_FCSI_FSYS_ctl_fsys1_res, 7);

  Attribute* a_FCSI_FSYS_ctl_fsys1_res_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_FSYS_ctl_fsys1_res_0_0->setInstName ("0");
  a_FCSI_FSYS_ctl_fsys1_res_0_0->setLongName ("");
  a_FCSI_FSYS_ctl_fsys1_res_0_0->setDescription ("");
  a_FCSI_FSYS_ctl_fsys1_res_0_0->addItem("3", "3'b011", "not used");
  a_FCSI_FSYS_ctl_fsys1_res_0_0->addItem("2", "3'b010", "125Ohm | 750Ohm");
  a_FCSI_FSYS_ctl_fsys1_res_0_0->addItem("1", "3'b001", "105Ohm | 625Ohm");
  a_FCSI_FSYS_ctl_fsys1_res_0_0->addItem("0", "3'b000", "83Ohm | 500Ohm");
  a_FCSI_FSYS_ctl_fsys1_res_0_0->addItem("7", "3'b111", "63Ohm | 375Ohm");
  a_FCSI_FSYS_ctl_fsys1_res_0_0->addItem("6", "3'b110", "not used");
  a_FCSI_FSYS_ctl_fsys1_res_0_0->addItem("5", "3'b101", "not used");
  a_FCSI_FSYS_ctl_fsys1_res_0_0->addItem("4", "3'b100", "not used");
  f_FCSI_FSYS_ctl_fsys1_res->connectAttribute (a_FCSI_FSYS_ctl_fsys1_res_0_0);

  RField* f_FCSI_FSYS_ctl_fsys1_cm = new RField;
  f_FCSI_FSYS_ctl_fsys1_cm->setInstName ("ctl_fsys1_cm");
  f_FCSI_FSYS_ctl_fsys1_cm->setLongName ("CTL FSYS1 CM");
  f_FCSI_FSYS_ctl_fsys1_cm->setDescription ("Control buffer current (for PCB | MCM depending on the mode selection)");
  f_FCSI_FSYS_ctl_fsys1_cm->setDataWidth (3);
  f_FCSI_FSYS_ctl_fsys1_cm->setResetVal ("3'b000");
  f_FCSI_FSYS_ctl_fsys1_cm->setAccProp (AccProp::RW);
  r_FCSI_FSYS->connectRField (f_FCSI_FSYS_ctl_fsys1_cm, 10);

  Attribute* a_FCSI_FSYS_ctl_fsys1_cm_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_FSYS_ctl_fsys1_cm_0_0->setInstName ("0");
  a_FCSI_FSYS_ctl_fsys1_cm_0_0->setLongName ("");
  a_FCSI_FSYS_ctl_fsys1_cm_0_0->setDescription ("");
  a_FCSI_FSYS_ctl_fsys1_cm_0_0->addItem("3", "3'b011", "not used");
  a_FCSI_FSYS_ctl_fsys1_cm_0_0->addItem("2", "3'b010", "9mA");
  a_FCSI_FSYS_ctl_fsys1_cm_0_0->addItem("1", "3'b001", "7.5mA");
  a_FCSI_FSYS_ctl_fsys1_cm_0_0->addItem("0", "3'b000", "6mA");
  a_FCSI_FSYS_ctl_fsys1_cm_0_0->addItem("7", "3'b111", "4.5mA");
  a_FCSI_FSYS_ctl_fsys1_cm_0_0->addItem("6", "3'b110", "not used");
  a_FCSI_FSYS_ctl_fsys1_cm_0_0->addItem("5", "3'b101", "not used");
  a_FCSI_FSYS_ctl_fsys1_cm_0_0->addItem("4", "3'b100", "not used");
  f_FCSI_FSYS_ctl_fsys1_cm->connectAttribute (a_FCSI_FSYS_ctl_fsys1_cm_0_0);

  Register* r_FCSI_FSYSLDO2V5 = new Register;
  r_FCSI_FSYSLDO2V5->setInstName ("FSYSLDO2V5");
  r_FCSI_FSYSLDO2V5->setLongName ("FSYS LDO2V5");
  r_FCSI_FSYSLDO2V5->setDescription ("FCSI-LDO1V2");
  r_FCSI_FSYSLDO2V5->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_FSYSLDO2V5, 0x00000025);

  RField* f_FCSI_FSYSLDO2V5_disable_lc = new RField;
  f_FCSI_FSYSLDO2V5_disable_lc->setInstName ("disable_lc");
  f_FCSI_FSYSLDO2V5_disable_lc->setLongName ("DISABLE LC");
  f_FCSI_FSYSLDO2V5_disable_lc->setDescription ("Disable loop compensation");
  f_FCSI_FSYSLDO2V5_disable_lc->setDataWidth (1);
  f_FCSI_FSYSLDO2V5_disable_lc->setResetVal ("1'b0");
  f_FCSI_FSYSLDO2V5_disable_lc->setAccProp (AccProp::RW);
  r_FCSI_FSYSLDO2V5->connectRField (f_FCSI_FSYSLDO2V5_disable_lc, 0);

  Attribute* a_FCSI_FSYSLDO2V5_disable_lc_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_FSYSLDO2V5_disable_lc_0_0->setInstName ("0");
  a_FCSI_FSYSLDO2V5_disable_lc_0_0->setLongName ("");
  a_FCSI_FSYSLDO2V5_disable_lc_0_0->setDescription ("");
  a_FCSI_FSYSLDO2V5_disable_lc_0_0->addItem("1", "1'b1", "disable");
  a_FCSI_FSYSLDO2V5_disable_lc_0_0->addItem("0", "1'b0", "enable");
  f_FCSI_FSYSLDO2V5_disable_lc->connectAttribute (a_FCSI_FSYSLDO2V5_disable_lc_0_0);

  RField* f_FCSI_FSYSLDO2V5_en_rload = new RField;
  f_FCSI_FSYSLDO2V5_en_rload->setInstName ("en_rload");
  f_FCSI_FSYSLDO2V5_en_rload->setLongName ("EN RLOAD");
  f_FCSI_FSYSLDO2V5_en_rload->setDescription ("Enable resistive load");
  f_FCSI_FSYSLDO2V5_en_rload->setDataWidth (1);
  f_FCSI_FSYSLDO2V5_en_rload->setResetVal ("1'b0");
  f_FCSI_FSYSLDO2V5_en_rload->setAccProp (AccProp::RW);
  r_FCSI_FSYSLDO2V5->connectRField (f_FCSI_FSYSLDO2V5_en_rload, 1);

  Attribute* a_FCSI_FSYSLDO2V5_en_rload_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_FSYSLDO2V5_en_rload_0_0->setInstName ("0");
  a_FCSI_FSYSLDO2V5_en_rload_0_0->setLongName ("");
  a_FCSI_FSYSLDO2V5_en_rload_0_0->setDescription ("");
  a_FCSI_FSYSLDO2V5_en_rload_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_FSYSLDO2V5_en_rload_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_FSYSLDO2V5_en_rload->connectAttribute (a_FCSI_FSYSLDO2V5_en_rload_0_0);

  RField* f_FCSI_FSYSLDO2V5_ctl_lpgain = new RField;
  f_FCSI_FSYSLDO2V5_ctl_lpgain->setInstName ("ctl_lpgain");
  f_FCSI_FSYSLDO2V5_ctl_lpgain->setLongName ("CTL LPGAIN");
  f_FCSI_FSYSLDO2V5_ctl_lpgain->setDescription ("Control loop gain");
  f_FCSI_FSYSLDO2V5_ctl_lpgain->setDataWidth (1);
  f_FCSI_FSYSLDO2V5_ctl_lpgain->setResetVal ("1'b0");
  f_FCSI_FSYSLDO2V5_ctl_lpgain->setAccProp (AccProp::RW);
  r_FCSI_FSYSLDO2V5->connectRField (f_FCSI_FSYSLDO2V5_ctl_lpgain, 2);

  Attribute* a_FCSI_FSYSLDO2V5_ctl_lpgain_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_FSYSLDO2V5_ctl_lpgain_0_0->setInstName ("0");
  a_FCSI_FSYSLDO2V5_ctl_lpgain_0_0->setLongName ("");
  a_FCSI_FSYSLDO2V5_ctl_lpgain_0_0->setDescription ("");
  a_FCSI_FSYSLDO2V5_ctl_lpgain_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_FSYSLDO2V5_ctl_lpgain_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_FSYSLDO2V5_ctl_lpgain->connectAttribute (a_FCSI_FSYSLDO2V5_ctl_lpgain_0_0);

  RField* f_FCSI_FSYSLDO2V5_ctl_vout = new RField;
  f_FCSI_FSYSLDO2V5_ctl_vout->setInstName ("ctl_vout");
  f_FCSI_FSYSLDO2V5_ctl_vout->setLongName ("CTL VOUT");
  f_FCSI_FSYSLDO2V5_ctl_vout->setDescription ("Control output voltage");
  f_FCSI_FSYSLDO2V5_ctl_vout->setDataWidth (4);
  f_FCSI_FSYSLDO2V5_ctl_vout->setResetVal ("4'b0000");
  f_FCSI_FSYSLDO2V5_ctl_vout->setAccProp (AccProp::RW);
  r_FCSI_FSYSLDO2V5->connectRField (f_FCSI_FSYSLDO2V5_ctl_vout, 3);

  Attribute* a_FCSI_FSYSLDO2V5_ctl_vout_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_FSYSLDO2V5_ctl_vout_0_0->setInstName ("0");
  a_FCSI_FSYSLDO2V5_ctl_vout_0_0->setLongName ("");
  a_FCSI_FSYSLDO2V5_ctl_vout_0_0->setDescription ("");
  a_FCSI_FSYSLDO2V5_ctl_vout_0_0->addItem("7", "4'b0111", "2.65V");
  a_FCSI_FSYSLDO2V5_ctl_vout_0_0->addItem("6", "4'b0110", "2.63V");
  a_FCSI_FSYSLDO2V5_ctl_vout_0_0->addItem("5", "4'b0101", "2.61V");
  a_FCSI_FSYSLDO2V5_ctl_vout_0_0->addItem("4", "4'b0100", "2.59V");
  a_FCSI_FSYSLDO2V5_ctl_vout_0_0->addItem("3", "4'b0011", "2.57V");
  a_FCSI_FSYSLDO2V5_ctl_vout_0_0->addItem("2", "4'b0010", "2.55V");
  a_FCSI_FSYSLDO2V5_ctl_vout_0_0->addItem("1", "4'b0001", "2.53V");
  a_FCSI_FSYSLDO2V5_ctl_vout_0_0->addItem("0", "4'b0000", "2.51V");
  a_FCSI_FSYSLDO2V5_ctl_vout_0_0->addItem("15", "4'b1111", "2.49V");
  a_FCSI_FSYSLDO2V5_ctl_vout_0_0->addItem("14", "4'b1110", "2.47V");
  a_FCSI_FSYSLDO2V5_ctl_vout_0_0->addItem("13", "4'b1101", "2.45V");
  a_FCSI_FSYSLDO2V5_ctl_vout_0_0->addItem("12", "4'b1100", "2.43V");
  a_FCSI_FSYSLDO2V5_ctl_vout_0_0->addItem("11", "4'b1011", "2.41V");
  a_FCSI_FSYSLDO2V5_ctl_vout_0_0->addItem("10", "4'b1010", "2.39V");
  a_FCSI_FSYSLDO2V5_ctl_vout_0_0->addItem("9", "4'b1001", "2.37V");
  a_FCSI_FSYSLDO2V5_ctl_vout_0_0->addItem("8", "4'b1000", "2.35V");
  f_FCSI_FSYSLDO2V5_ctl_vout->connectAttribute (a_FCSI_FSYSLDO2V5_ctl_vout_0_0);

  RField* f_FCSI_FSYSLDO2V5_ctl_iref = new RField;
  f_FCSI_FSYSLDO2V5_ctl_iref->setInstName ("ctl_iref");
  f_FCSI_FSYSLDO2V5_ctl_iref->setLongName ("CTL IREF");
  f_FCSI_FSYSLDO2V5_ctl_iref->setDescription ("Control iref");
  f_FCSI_FSYSLDO2V5_ctl_iref->setDataWidth (2);
  f_FCSI_FSYSLDO2V5_ctl_iref->setResetVal ("2'b00");
  f_FCSI_FSYSLDO2V5_ctl_iref->setAccProp (AccProp::RW);
  r_FCSI_FSYSLDO2V5->connectRField (f_FCSI_FSYSLDO2V5_ctl_iref, 7);

  Attribute* a_FCSI_FSYSLDO2V5_ctl_iref_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_FSYSLDO2V5_ctl_iref_0_0->setInstName ("0");
  a_FCSI_FSYSLDO2V5_ctl_iref_0_0->setLongName ("");
  a_FCSI_FSYSLDO2V5_ctl_iref_0_0->setDescription ("");
  a_FCSI_FSYSLDO2V5_ctl_iref_0_0->addItem("1", "2'b01", "27.5uA");
  a_FCSI_FSYSLDO2V5_ctl_iref_0_0->addItem("0", "2'b00", "25uA");
  a_FCSI_FSYSLDO2V5_ctl_iref_0_0->addItem("3", "2'b11", "22.5uA");
  a_FCSI_FSYSLDO2V5_ctl_iref_0_0->addItem("2", "2'b10", "not used");
  f_FCSI_FSYSLDO2V5_ctl_iref->connectAttribute (a_FCSI_FSYSLDO2V5_ctl_iref_0_0);

  RField* f_FCSI_FSYSLDO2V5_en_test = new RField;
  f_FCSI_FSYSLDO2V5_en_test->setInstName ("en_test");
  f_FCSI_FSYSLDO2V5_en_test->setLongName ("EN TEST");
  f_FCSI_FSYSLDO2V5_en_test->setDescription ("Switch ldo output to ldo_test pad");
  f_FCSI_FSYSLDO2V5_en_test->setDataWidth (1);
  f_FCSI_FSYSLDO2V5_en_test->setResetVal ("1'b0");
  f_FCSI_FSYSLDO2V5_en_test->setAccProp (AccProp::RW);
  r_FCSI_FSYSLDO2V5->connectRField (f_FCSI_FSYSLDO2V5_en_test, 9);

  Attribute* a_FCSI_FSYSLDO2V5_en_test_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_FSYSLDO2V5_en_test_0_0->setInstName ("0");
  a_FCSI_FSYSLDO2V5_en_test_0_0->setLongName ("");
  a_FCSI_FSYSLDO2V5_en_test_0_0->setDescription ("");
  a_FCSI_FSYSLDO2V5_en_test_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_FSYSLDO2V5_en_test_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_FSYSLDO2V5_en_test->connectAttribute (a_FCSI_FSYSLDO2V5_en_test_0_0);

  Register* r_FCSI_FCSILDO1V2 = new Register;
  r_FCSI_FCSILDO1V2->setInstName ("FCSILDO1V2");
  r_FCSI_FCSILDO1V2->setLongName ("FCSI LDO1V2");
  r_FCSI_FCSILDO1V2->setDescription ("FCSI-LDO1V2");
  r_FCSI_FCSILDO1V2->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_FCSILDO1V2, 0x00000026);

  RField* f_FCSI_FCSILDO1V2_ctl_vout = new RField;
  f_FCSI_FCSILDO1V2_ctl_vout->setInstName ("ctl_vout");
  f_FCSI_FCSILDO1V2_ctl_vout->setLongName ("CTL VOUT");
  f_FCSI_FCSILDO1V2_ctl_vout->setDescription ("Control output voltage");
  f_FCSI_FCSILDO1V2_ctl_vout->setDataWidth (4);
  f_FCSI_FCSILDO1V2_ctl_vout->setResetVal ("4'b0000");
  f_FCSI_FCSILDO1V2_ctl_vout->setAccProp (AccProp::RW);
  r_FCSI_FCSILDO1V2->connectRField (f_FCSI_FCSILDO1V2_ctl_vout, 0);

  Attribute* a_FCSI_FCSILDO1V2_ctl_vout_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_FCSILDO1V2_ctl_vout_0_0->setInstName ("0");
  a_FCSI_FCSILDO1V2_ctl_vout_0_0->setLongName ("");
  a_FCSI_FCSILDO1V2_ctl_vout_0_0->setDescription ("");
  a_FCSI_FCSILDO1V2_ctl_vout_0_0->addItem("8", "4'b1000", "1.04V");
  a_FCSI_FCSILDO1V2_ctl_vout_0_0->addItem("9", "4'b1001", "1.06V");
  a_FCSI_FCSILDO1V2_ctl_vout_0_0->addItem("10", "4'b1010", "1.08V");
  a_FCSI_FCSILDO1V2_ctl_vout_0_0->addItem("11", "4'b1011", "1.10V");
  a_FCSI_FCSILDO1V2_ctl_vout_0_0->addItem("12", "4'b1100", "1.12V");
  a_FCSI_FCSILDO1V2_ctl_vout_0_0->addItem("13", "4'b1101", "1.14V");
  a_FCSI_FCSILDO1V2_ctl_vout_0_0->addItem("14", "4'b1110", "1.16V");
  a_FCSI_FCSILDO1V2_ctl_vout_0_0->addItem("15", "4'b1111", "1.18V");
  a_FCSI_FCSILDO1V2_ctl_vout_0_0->addItem("0", "4'b0000", "1.20V");
  a_FCSI_FCSILDO1V2_ctl_vout_0_0->addItem("1", "4'b0001", "1.22V");
  a_FCSI_FCSILDO1V2_ctl_vout_0_0->addItem("2", "4'b0010", "1.24V");
  a_FCSI_FCSILDO1V2_ctl_vout_0_0->addItem("3", "4'b0011", "1.26V");
  a_FCSI_FCSILDO1V2_ctl_vout_0_0->addItem("4", "4'b0100", "1.28V");
  a_FCSI_FCSILDO1V2_ctl_vout_0_0->addItem("5", "4'b0101", "1.30V");
  a_FCSI_FCSILDO1V2_ctl_vout_0_0->addItem("6", "4'b0110", "1.32V");
  a_FCSI_FCSILDO1V2_ctl_vout_0_0->addItem("7", "4'b0111", "1.34V");
  f_FCSI_FCSILDO1V2_ctl_vout->connectAttribute (a_FCSI_FCSILDO1V2_ctl_vout_0_0);

  RField* f_FCSI_FCSILDO1V2_en_test = new RField;
  f_FCSI_FCSILDO1V2_en_test->setInstName ("en_test");
  f_FCSI_FCSILDO1V2_en_test->setLongName ("EN TEST");
  f_FCSI_FCSILDO1V2_en_test->setDescription ("Switch ldo output to ldo_test pad");
  f_FCSI_FCSILDO1V2_en_test->setDataWidth (1);
  f_FCSI_FCSILDO1V2_en_test->setResetVal ("1'b0");
  f_FCSI_FCSILDO1V2_en_test->setAccProp (AccProp::RW);
  r_FCSI_FCSILDO1V2->connectRField (f_FCSI_FCSILDO1V2_en_test, 4);

  Attribute* a_FCSI_FCSILDO1V2_en_test_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_FCSILDO1V2_en_test_0_0->setInstName ("0");
  a_FCSI_FCSILDO1V2_en_test_0_0->setLongName ("");
  a_FCSI_FCSILDO1V2_en_test_0_0->setDescription ("");
  a_FCSI_FCSILDO1V2_en_test_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_FCSILDO1V2_en_test_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_FCSILDO1V2_en_test->connectAttribute (a_FCSI_FCSILDO1V2_en_test_0_0);

  RField* f_FCSI_FCSILDO1V2_ctl_pll0_rdy = new RField;
  f_FCSI_FCSILDO1V2_ctl_pll0_rdy->setInstName ("ctl_pll0_rdy");
  f_FCSI_FCSILDO1V2_ctl_pll0_rdy->setLongName ("CTL PLL0 RDY");
  f_FCSI_FCSILDO1V2_ctl_pll0_rdy->setDescription ("Control PLL0 ready manual");
  f_FCSI_FCSILDO1V2_ctl_pll0_rdy->setDataWidth (1);
  f_FCSI_FCSILDO1V2_ctl_pll0_rdy->setResetVal ("1'b0");
  f_FCSI_FCSILDO1V2_ctl_pll0_rdy->setAccProp (AccProp::RW);
  r_FCSI_FCSILDO1V2->connectRField (f_FCSI_FCSILDO1V2_ctl_pll0_rdy, 5);

  Attribute* a_FCSI_FCSILDO1V2_ctl_pll0_rdy_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_FCSILDO1V2_ctl_pll0_rdy_0_0->setInstName ("0");
  a_FCSI_FCSILDO1V2_ctl_pll0_rdy_0_0->setLongName ("");
  a_FCSI_FCSILDO1V2_ctl_pll0_rdy_0_0->setDescription ("");
  a_FCSI_FCSILDO1V2_ctl_pll0_rdy_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_FCSILDO1V2_ctl_pll0_rdy_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_FCSILDO1V2_ctl_pll0_rdy->connectAttribute (a_FCSI_FCSILDO1V2_ctl_pll0_rdy_0_0);

  RField* f_FCSI_FCSILDO1V2_en_pll0_rdy = new RField;
  f_FCSI_FCSILDO1V2_en_pll0_rdy->setInstName ("en_pll0_rdy");
  f_FCSI_FCSILDO1V2_en_pll0_rdy->setLongName ("EN PLL0 RDY");
  f_FCSI_FCSILDO1V2_en_pll0_rdy->setDescription ("Enable PLL0 ready manual");
  f_FCSI_FCSILDO1V2_en_pll0_rdy->setDataWidth (1);
  f_FCSI_FCSILDO1V2_en_pll0_rdy->setResetVal ("1'b0");
  f_FCSI_FCSILDO1V2_en_pll0_rdy->setAccProp (AccProp::RW);
  r_FCSI_FCSILDO1V2->connectRField (f_FCSI_FCSILDO1V2_en_pll0_rdy, 6);

  Attribute* a_FCSI_FCSILDO1V2_en_pll0_rdy_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_FCSILDO1V2_en_pll0_rdy_0_0->setInstName ("0");
  a_FCSI_FCSILDO1V2_en_pll0_rdy_0_0->setLongName ("");
  a_FCSI_FCSILDO1V2_en_pll0_rdy_0_0->setDescription ("");
  a_FCSI_FCSILDO1V2_en_pll0_rdy_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_FCSILDO1V2_en_pll0_rdy_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_FCSILDO1V2_en_pll0_rdy->connectAttribute (a_FCSI_FCSILDO1V2_en_pll0_rdy_0_0);

  RField* f_FCSI_FCSILDO1V2_ctl_pll1_rdy = new RField;
  f_FCSI_FCSILDO1V2_ctl_pll1_rdy->setInstName ("ctl_pll1_rdy");
  f_FCSI_FCSILDO1V2_ctl_pll1_rdy->setLongName ("CTL PLL1 RDY");
  f_FCSI_FCSILDO1V2_ctl_pll1_rdy->setDescription ("Control PLL1 ready manual");
  f_FCSI_FCSILDO1V2_ctl_pll1_rdy->setDataWidth (1);
  f_FCSI_FCSILDO1V2_ctl_pll1_rdy->setResetVal ("1'b0");
  f_FCSI_FCSILDO1V2_ctl_pll1_rdy->setAccProp (AccProp::RW);
  r_FCSI_FCSILDO1V2->connectRField (f_FCSI_FCSILDO1V2_ctl_pll1_rdy, 7);

  Attribute* a_FCSI_FCSILDO1V2_ctl_pll1_rdy_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_FCSILDO1V2_ctl_pll1_rdy_0_0->setInstName ("0");
  a_FCSI_FCSILDO1V2_ctl_pll1_rdy_0_0->setLongName ("");
  a_FCSI_FCSILDO1V2_ctl_pll1_rdy_0_0->setDescription ("");
  a_FCSI_FCSILDO1V2_ctl_pll1_rdy_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_FCSILDO1V2_ctl_pll1_rdy_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_FCSILDO1V2_ctl_pll1_rdy->connectAttribute (a_FCSI_FCSILDO1V2_ctl_pll1_rdy_0_0);

  RField* f_FCSI_FCSILDO1V2_en_pll1_rdy = new RField;
  f_FCSI_FCSILDO1V2_en_pll1_rdy->setInstName ("en_pll1_rdy");
  f_FCSI_FCSILDO1V2_en_pll1_rdy->setLongName ("EN PLL1 RDY");
  f_FCSI_FCSILDO1V2_en_pll1_rdy->setDescription ("Enable PLL1 ready manual");
  f_FCSI_FCSILDO1V2_en_pll1_rdy->setDataWidth (1);
  f_FCSI_FCSILDO1V2_en_pll1_rdy->setResetVal ("1'b0");
  f_FCSI_FCSILDO1V2_en_pll1_rdy->setAccProp (AccProp::RW);
  r_FCSI_FCSILDO1V2->connectRField (f_FCSI_FCSILDO1V2_en_pll1_rdy, 8);

  Attribute* a_FCSI_FCSILDO1V2_en_pll1_rdy_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_FCSILDO1V2_en_pll1_rdy_0_0->setInstName ("0");
  a_FCSI_FCSILDO1V2_en_pll1_rdy_0_0->setLongName ("");
  a_FCSI_FCSILDO1V2_en_pll1_rdy_0_0->setDescription ("");
  a_FCSI_FCSILDO1V2_en_pll1_rdy_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_FCSILDO1V2_en_pll1_rdy_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_FCSILDO1V2_en_pll1_rdy->connectAttribute (a_FCSI_FCSILDO1V2_en_pll1_rdy_0_0);

  RField* f_FCSI_FCSILDO1V2_ctl_rload_dis = new RField;
  f_FCSI_FCSILDO1V2_ctl_rload_dis->setInstName ("ctl_rload_dis");
  f_FCSI_FCSILDO1V2_ctl_rload_dis->setLongName ("CTL RLOAD DISABLE");
  f_FCSI_FCSILDO1V2_ctl_rload_dis->setDescription ("Disable ABB LDO output resistor");
  f_FCSI_FCSILDO1V2_ctl_rload_dis->setDataWidth (1);
  f_FCSI_FCSILDO1V2_ctl_rload_dis->setResetVal ("1'b0");
  f_FCSI_FCSILDO1V2_ctl_rload_dis->setAccProp (AccProp::RW);
  r_FCSI_FCSILDO1V2->connectRField (f_FCSI_FCSILDO1V2_ctl_rload_dis, 9);

  Attribute* a_FCSI_FCSILDO1V2_ctl_rload_dis_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_FCSILDO1V2_ctl_rload_dis_0_0->setInstName ("0");
  a_FCSI_FCSILDO1V2_ctl_rload_dis_0_0->setLongName ("");
  a_FCSI_FCSILDO1V2_ctl_rload_dis_0_0->setDescription ("");
  a_FCSI_FCSILDO1V2_ctl_rload_dis_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_FCSILDO1V2_ctl_rload_dis_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_FCSILDO1V2_ctl_rload_dis->connectAttribute (a_FCSI_FCSILDO1V2_ctl_rload_dis_0_0);

  RField* f_FCSI_FCSILDO1V2_ctl_rdg_prog = new RField;
  f_FCSI_FCSILDO1V2_ctl_rdg_prog->setInstName ("ctl_rdg_prog");
  f_FCSI_FCSILDO1V2_ctl_rdg_prog->setLongName ("CTL RDG PROG");
  f_FCSI_FCSILDO1V2_ctl_rdg_prog->setDescription ("Control ABB LDO opamp degeneration resitance");
  f_FCSI_FCSILDO1V2_ctl_rdg_prog->setDataWidth (4);
  f_FCSI_FCSILDO1V2_ctl_rdg_prog->setResetVal ("4'b0010");
  f_FCSI_FCSILDO1V2_ctl_rdg_prog->setAccProp (AccProp::RW);
  r_FCSI_FCSILDO1V2->connectRField (f_FCSI_FCSILDO1V2_ctl_rdg_prog, 10);

  Attribute* a_FCSI_FCSILDO1V2_ctl_rdg_prog_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_FCSILDO1V2_ctl_rdg_prog_0_0->setInstName ("0");
  a_FCSI_FCSILDO1V2_ctl_rdg_prog_0_0->setLongName ("");
  a_FCSI_FCSILDO1V2_ctl_rdg_prog_0_0->setDescription ("");
  a_FCSI_FCSILDO1V2_ctl_rdg_prog_0_0->addItem("0", "4'b0000", "n.a.");
  f_FCSI_FCSILDO1V2_ctl_rdg_prog->connectAttribute (a_FCSI_FCSILDO1V2_ctl_rdg_prog_0_0);

  Register* r_FCSI_CMOSCLKTREE = new Register;
  r_FCSI_CMOSCLKTREE->setInstName ("CMOSCLKTREE");
  r_FCSI_CMOSCLKTREE->setLongName ("CMOSCLKTREE + ABBLDO");
  r_FCSI_CMOSCLKTREE->setDescription ("FCSI-LDO1V2");
  r_FCSI_CMOSCLKTREE->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_CMOSCLKTREE, 0x00000027);

  RField* f_FCSI_CMOSCLKTREE_en_tempsensor_clk = new RField;
  f_FCSI_CMOSCLKTREE_en_tempsensor_clk->setInstName ("en_tempsensor_clk");
  f_FCSI_CMOSCLKTREE_en_tempsensor_clk->setLongName ("EN TEMPSENSOR CLK");
  f_FCSI_CMOSCLKTREE_en_tempsensor_clk->setDescription ("Enable temperature sensor clk");
  f_FCSI_CMOSCLKTREE_en_tempsensor_clk->setDataWidth (1);
  f_FCSI_CMOSCLKTREE_en_tempsensor_clk->setResetVal ("1'b0");
  f_FCSI_CMOSCLKTREE_en_tempsensor_clk->setAccProp (AccProp::RW);
  r_FCSI_CMOSCLKTREE->connectRField (f_FCSI_CMOSCLKTREE_en_tempsensor_clk, 0);

  Attribute* a_FCSI_CMOSCLKTREE_en_tempsensor_clk_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_CMOSCLKTREE_en_tempsensor_clk_0_0->setInstName ("0");
  a_FCSI_CMOSCLKTREE_en_tempsensor_clk_0_0->setLongName ("");
  a_FCSI_CMOSCLKTREE_en_tempsensor_clk_0_0->setDescription ("");
  a_FCSI_CMOSCLKTREE_en_tempsensor_clk_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_CMOSCLKTREE_en_tempsensor_clk_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_CMOSCLKTREE_en_tempsensor_clk->connectAttribute (a_FCSI_CMOSCLKTREE_en_tempsensor_clk_0_0);

  RField* f_FCSI_CMOSCLKTREE_en_dco_clk_ant0 = new RField;
  f_FCSI_CMOSCLKTREE_en_dco_clk_ant0->setInstName ("en_dco_clk_ant0");
  f_FCSI_CMOSCLKTREE_en_dco_clk_ant0->setLongName ("EN DCO CLK ANT0");
  f_FCSI_CMOSCLKTREE_en_dco_clk_ant0->setDescription ("Enable DC offset clock for antenna 0");
  f_FCSI_CMOSCLKTREE_en_dco_clk_ant0->setDataWidth (1);
  f_FCSI_CMOSCLKTREE_en_dco_clk_ant0->setResetVal ("1'b0");
  f_FCSI_CMOSCLKTREE_en_dco_clk_ant0->setAccProp (AccProp::RW);
  r_FCSI_CMOSCLKTREE->connectRField (f_FCSI_CMOSCLKTREE_en_dco_clk_ant0, 1);

  Attribute* a_FCSI_CMOSCLKTREE_en_dco_clk_ant0_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_CMOSCLKTREE_en_dco_clk_ant0_0_0->setInstName ("0");
  a_FCSI_CMOSCLKTREE_en_dco_clk_ant0_0_0->setLongName ("");
  a_FCSI_CMOSCLKTREE_en_dco_clk_ant0_0_0->setDescription ("");
  a_FCSI_CMOSCLKTREE_en_dco_clk_ant0_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_CMOSCLKTREE_en_dco_clk_ant0_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_CMOSCLKTREE_en_dco_clk_ant0->connectAttribute (a_FCSI_CMOSCLKTREE_en_dco_clk_ant0_0_0);

  RField* f_FCSI_CMOSCLKTREE_en_dco_clk_ant1 = new RField;
  f_FCSI_CMOSCLKTREE_en_dco_clk_ant1->setInstName ("en_dco_clk_ant1");
  f_FCSI_CMOSCLKTREE_en_dco_clk_ant1->setLongName ("EN DCO CLK ANT1");
  f_FCSI_CMOSCLKTREE_en_dco_clk_ant1->setDescription ("Enable DC offset clock for antenna 1");
  f_FCSI_CMOSCLKTREE_en_dco_clk_ant1->setDataWidth (1);
  f_FCSI_CMOSCLKTREE_en_dco_clk_ant1->setResetVal ("1'b0");
  f_FCSI_CMOSCLKTREE_en_dco_clk_ant1->setAccProp (AccProp::RW);
  r_FCSI_CMOSCLKTREE->connectRField (f_FCSI_CMOSCLKTREE_en_dco_clk_ant1, 2);

  Attribute* a_FCSI_CMOSCLKTREE_en_dco_clk_ant1_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_CMOSCLKTREE_en_dco_clk_ant1_0_0->setInstName ("0");
  a_FCSI_CMOSCLKTREE_en_dco_clk_ant1_0_0->setLongName ("");
  a_FCSI_CMOSCLKTREE_en_dco_clk_ant1_0_0->setDescription ("");
  a_FCSI_CMOSCLKTREE_en_dco_clk_ant1_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_CMOSCLKTREE_en_dco_clk_ant1_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_CMOSCLKTREE_en_dco_clk_ant1->connectAttribute (a_FCSI_CMOSCLKTREE_en_dco_clk_ant1_0_0);

  RField* f_FCSI_CMOSCLKTREE_en_dco_clk_ant2 = new RField;
  f_FCSI_CMOSCLKTREE_en_dco_clk_ant2->setInstName ("en_dco_clk_ant2");
  f_FCSI_CMOSCLKTREE_en_dco_clk_ant2->setLongName ("EN DCO CLK ANT2");
  f_FCSI_CMOSCLKTREE_en_dco_clk_ant2->setDescription ("Enable DC offset clock for antenna 2");
  f_FCSI_CMOSCLKTREE_en_dco_clk_ant2->setDataWidth (1);
  f_FCSI_CMOSCLKTREE_en_dco_clk_ant2->setResetVal ("1'b0");
  f_FCSI_CMOSCLKTREE_en_dco_clk_ant2->setAccProp (AccProp::RW);
  r_FCSI_CMOSCLKTREE->connectRField (f_FCSI_CMOSCLKTREE_en_dco_clk_ant2, 3);

  Attribute* a_FCSI_CMOSCLKTREE_en_dco_clk_ant2_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_CMOSCLKTREE_en_dco_clk_ant2_0_0->setInstName ("0");
  a_FCSI_CMOSCLKTREE_en_dco_clk_ant2_0_0->setLongName ("");
  a_FCSI_CMOSCLKTREE_en_dco_clk_ant2_0_0->setDescription ("");
  a_FCSI_CMOSCLKTREE_en_dco_clk_ant2_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_CMOSCLKTREE_en_dco_clk_ant2_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_CMOSCLKTREE_en_dco_clk_ant2->connectAttribute (a_FCSI_CMOSCLKTREE_en_dco_clk_ant2_0_0);

  RField* f_FCSI_CMOSCLKTREE_en_dco_clk_ant3 = new RField;
  f_FCSI_CMOSCLKTREE_en_dco_clk_ant3->setInstName ("en_dco_clk_ant3");
  f_FCSI_CMOSCLKTREE_en_dco_clk_ant3->setLongName ("EN DCO CLK ANT3");
  f_FCSI_CMOSCLKTREE_en_dco_clk_ant3->setDescription ("Enable DC offset clock for antenna 3");
  f_FCSI_CMOSCLKTREE_en_dco_clk_ant3->setDataWidth (1);
  f_FCSI_CMOSCLKTREE_en_dco_clk_ant3->setResetVal ("1'b0");
  f_FCSI_CMOSCLKTREE_en_dco_clk_ant3->setAccProp (AccProp::RW);
  r_FCSI_CMOSCLKTREE->connectRField (f_FCSI_CMOSCLKTREE_en_dco_clk_ant3, 4);

  Attribute* a_FCSI_CMOSCLKTREE_en_dco_clk_ant3_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_CMOSCLKTREE_en_dco_clk_ant3_0_0->setInstName ("0");
  a_FCSI_CMOSCLKTREE_en_dco_clk_ant3_0_0->setLongName ("");
  a_FCSI_CMOSCLKTREE_en_dco_clk_ant3_0_0->setDescription ("");
  a_FCSI_CMOSCLKTREE_en_dco_clk_ant3_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_CMOSCLKTREE_en_dco_clk_ant3_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_CMOSCLKTREE_en_dco_clk_ant3->connectAttribute (a_FCSI_CMOSCLKTREE_en_dco_clk_ant3_0_0);

  RField* f_FCSI_CMOSCLKTREE_ctl_gmff_prog = new RField;
  f_FCSI_CMOSCLKTREE_ctl_gmff_prog->setInstName ("ctl_gmff_prog");
  f_FCSI_CMOSCLKTREE_ctl_gmff_prog->setLongName ("CTL GMFF PROG");
  f_FCSI_CMOSCLKTREE_ctl_gmff_prog->setDescription ("Control ABB LDO FF gain");
  f_FCSI_CMOSCLKTREE_ctl_gmff_prog->setDataWidth (3);
  f_FCSI_CMOSCLKTREE_ctl_gmff_prog->setResetVal ("3'b110");
  f_FCSI_CMOSCLKTREE_ctl_gmff_prog->setAccProp (AccProp::RW);
  r_FCSI_CMOSCLKTREE->connectRField (f_FCSI_CMOSCLKTREE_ctl_gmff_prog, 5);

  Attribute* a_FCSI_CMOSCLKTREE_ctl_gmff_prog_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_CMOSCLKTREE_ctl_gmff_prog_0_0->setInstName ("0");
  a_FCSI_CMOSCLKTREE_ctl_gmff_prog_0_0->setLongName ("");
  a_FCSI_CMOSCLKTREE_ctl_gmff_prog_0_0->setDescription ("");
  a_FCSI_CMOSCLKTREE_ctl_gmff_prog_0_0->addItem("0", "3'b000", "n.a.");
  f_FCSI_CMOSCLKTREE_ctl_gmff_prog->connectAttribute (a_FCSI_CMOSCLKTREE_ctl_gmff_prog_0_0);

  RField* f_FCSI_CMOSCLKTREE_ctl_ibias_prog = new RField;
  f_FCSI_CMOSCLKTREE_ctl_ibias_prog->setInstName ("ctl_ibias_prog");
  f_FCSI_CMOSCLKTREE_ctl_ibias_prog->setLongName ("CTL IBIAS PROG");
  f_FCSI_CMOSCLKTREE_ctl_ibias_prog->setDescription ("Control ABB LDO bias current");
  f_FCSI_CMOSCLKTREE_ctl_ibias_prog->setDataWidth (2);
  f_FCSI_CMOSCLKTREE_ctl_ibias_prog->setResetVal ("2'b00");
  f_FCSI_CMOSCLKTREE_ctl_ibias_prog->setAccProp (AccProp::RW);
  r_FCSI_CMOSCLKTREE->connectRField (f_FCSI_CMOSCLKTREE_ctl_ibias_prog, 8);

  Attribute* a_FCSI_CMOSCLKTREE_ctl_ibias_prog_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_CMOSCLKTREE_ctl_ibias_prog_0_0->setInstName ("0");
  a_FCSI_CMOSCLKTREE_ctl_ibias_prog_0_0->setLongName ("");
  a_FCSI_CMOSCLKTREE_ctl_ibias_prog_0_0->setDescription ("");
  a_FCSI_CMOSCLKTREE_ctl_ibias_prog_0_0->addItem("0", "2'b00", "100%");
  a_FCSI_CMOSCLKTREE_ctl_ibias_prog_0_0->addItem("1", "2'b01", "133%");
  a_FCSI_CMOSCLKTREE_ctl_ibias_prog_0_0->addItem("2", "2'b10", "133");
  a_FCSI_CMOSCLKTREE_ctl_ibias_prog_0_0->addItem("3", "2'b11", "200%");
  f_FCSI_CMOSCLKTREE_ctl_ibias_prog->connectAttribute (a_FCSI_CMOSCLKTREE_ctl_ibias_prog_0_0);

  RField* f_FCSI_CMOSCLKTREE_ctl_oval_trim = new RField;
  f_FCSI_CMOSCLKTREE_ctl_oval_trim->setInstName ("ctl_oval_trim");
  f_FCSI_CMOSCLKTREE_ctl_oval_trim->setLongName ("CTL OVAL TRIM");
  f_FCSI_CMOSCLKTREE_ctl_oval_trim->setDescription ("Control ABB LDO output voltage");
  f_FCSI_CMOSCLKTREE_ctl_oval_trim->setDataWidth (3);
  f_FCSI_CMOSCLKTREE_ctl_oval_trim->setResetVal ("3'b100");
  f_FCSI_CMOSCLKTREE_ctl_oval_trim->setAccProp (AccProp::RW);
  r_FCSI_CMOSCLKTREE->connectRField (f_FCSI_CMOSCLKTREE_ctl_oval_trim, 10);

  Attribute* a_FCSI_CMOSCLKTREE_ctl_oval_trim_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_CMOSCLKTREE_ctl_oval_trim_0_0->setInstName ("0");
  a_FCSI_CMOSCLKTREE_ctl_oval_trim_0_0->setLongName ("");
  a_FCSI_CMOSCLKTREE_ctl_oval_trim_0_0->setDescription ("");
  a_FCSI_CMOSCLKTREE_ctl_oval_trim_0_0->addItem("0", "3'b000", "1.73V");
  a_FCSI_CMOSCLKTREE_ctl_oval_trim_0_0->addItem("1", "3'b001", "1.76V");
  a_FCSI_CMOSCLKTREE_ctl_oval_trim_0_0->addItem("2", "3'b010", "1.79V");
  a_FCSI_CMOSCLKTREE_ctl_oval_trim_0_0->addItem("3", "3'b011", "1.82V");
  a_FCSI_CMOSCLKTREE_ctl_oval_trim_0_0->addItem("4", "3'b100", "1.85V");
  a_FCSI_CMOSCLKTREE_ctl_oval_trim_0_0->addItem("5", "3'b101", "1.88V");
  a_FCSI_CMOSCLKTREE_ctl_oval_trim_0_0->addItem("6", "3'b110", "1.91V");
  a_FCSI_CMOSCLKTREE_ctl_oval_trim_0_0->addItem("7", "3'b111", "1.94V");
  f_FCSI_CMOSCLKTREE_ctl_oval_trim->connectAttribute (a_FCSI_CMOSCLKTREE_ctl_oval_trim_0_0);

  Register* r_FCSI_BIASCENT = new Register;
  r_FCSI_BIASCENT->setInstName ("BIASCENT");
  r_FCSI_BIASCENT->setLongName ("CENTRAL BIAS");
  r_FCSI_BIASCENT->setDescription ("FCSI-LDO1V2");
  r_FCSI_BIASCENT->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_BIASCENT, 0x00000028);

  RField* f_FCSI_BIASCENT_en_bgp = new RField;
  f_FCSI_BIASCENT_en_bgp->setInstName ("en_bgp");
  f_FCSI_BIASCENT_en_bgp->setLongName ("EN BGP");
  f_FCSI_BIASCENT_en_bgp->setDescription ("Enable bandgap");
  f_FCSI_BIASCENT_en_bgp->setDataWidth (1);
  f_FCSI_BIASCENT_en_bgp->setResetVal ("1'b0");
  f_FCSI_BIASCENT_en_bgp->setAccProp (AccProp::RW);
  r_FCSI_BIASCENT->connectRField (f_FCSI_BIASCENT_en_bgp, 0);

  Attribute* a_FCSI_BIASCENT_en_bgp_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_BIASCENT_en_bgp_0_0->setInstName ("0");
  a_FCSI_BIASCENT_en_bgp_0_0->setLongName ("");
  a_FCSI_BIASCENT_en_bgp_0_0->setDescription ("");
  a_FCSI_BIASCENT_en_bgp_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_BIASCENT_en_bgp_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_BIASCENT_en_bgp->connectAttribute (a_FCSI_BIASCENT_en_bgp_0_0);

  RField* f_FCSI_BIASCENT_en_u2i_const = new RField;
  f_FCSI_BIASCENT_en_u2i_const->setInstName ("en_u2i_const");
  f_FCSI_BIASCENT_en_u2i_const->setLongName ("EN U2I CONST");
  f_FCSI_BIASCENT_en_u2i_const->setDescription ("Enable u2i const");
  f_FCSI_BIASCENT_en_u2i_const->setDataWidth (1);
  f_FCSI_BIASCENT_en_u2i_const->setResetVal ("1'b0");
  f_FCSI_BIASCENT_en_u2i_const->setAccProp (AccProp::RW);
  r_FCSI_BIASCENT->connectRField (f_FCSI_BIASCENT_en_u2i_const, 1);

  Attribute* a_FCSI_BIASCENT_en_u2i_const_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_BIASCENT_en_u2i_const_0_0->setInstName ("0");
  a_FCSI_BIASCENT_en_u2i_const_0_0->setLongName ("");
  a_FCSI_BIASCENT_en_u2i_const_0_0->setDescription ("");
  a_FCSI_BIASCENT_en_u2i_const_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_BIASCENT_en_u2i_const_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_BIASCENT_en_u2i_const->connectAttribute (a_FCSI_BIASCENT_en_u2i_const_0_0);

  RField* f_FCSI_BIASCENT_en_u2i_p2pr = new RField;
  f_FCSI_BIASCENT_en_u2i_p2pr->setInstName ("en_u2i_p2pr");
  f_FCSI_BIASCENT_en_u2i_p2pr->setLongName ("EN U2I P2PR");
  f_FCSI_BIASCENT_en_u2i_p2pr->setDescription ("Enable u2i p2pr");
  f_FCSI_BIASCENT_en_u2i_p2pr->setDataWidth (1);
  f_FCSI_BIASCENT_en_u2i_p2pr->setResetVal ("1'b0");
  f_FCSI_BIASCENT_en_u2i_p2pr->setAccProp (AccProp::RW);
  r_FCSI_BIASCENT->connectRField (f_FCSI_BIASCENT_en_u2i_p2pr, 2);

  Attribute* a_FCSI_BIASCENT_en_u2i_p2pr_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_BIASCENT_en_u2i_p2pr_0_0->setInstName ("0");
  a_FCSI_BIASCENT_en_u2i_p2pr_0_0->setLongName ("");
  a_FCSI_BIASCENT_en_u2i_p2pr_0_0->setDescription ("");
  a_FCSI_BIASCENT_en_u2i_p2pr_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_BIASCENT_en_u2i_p2pr_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_BIASCENT_en_u2i_p2pr->connectAttribute (a_FCSI_BIASCENT_en_u2i_p2pr_0_0);

  RField* f_FCSI_BIASCENT_ctl_trim_bgp = new RField;
  f_FCSI_BIASCENT_ctl_trim_bgp->setInstName ("ctl_trim_bgp");
  f_FCSI_BIASCENT_ctl_trim_bgp->setLongName ("CTL TRIM BGP");
  f_FCSI_BIASCENT_ctl_trim_bgp->setDescription ("Trimming bandgap");
  f_FCSI_BIASCENT_ctl_trim_bgp->setDataWidth (4);
  f_FCSI_BIASCENT_ctl_trim_bgp->setResetVal ("4'b0000");
  f_FCSI_BIASCENT_ctl_trim_bgp->setAccProp (AccProp::RW);
  r_FCSI_BIASCENT->connectRField (f_FCSI_BIASCENT_ctl_trim_bgp, 3);

  Attribute* a_FCSI_BIASCENT_ctl_trim_bgp_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_BIASCENT_ctl_trim_bgp_0_0->setInstName ("0");
  a_FCSI_BIASCENT_ctl_trim_bgp_0_0->setLongName ("");
  a_FCSI_BIASCENT_ctl_trim_bgp_0_0->setDescription ("");
  a_FCSI_BIASCENT_ctl_trim_bgp_0_0->addItem("0", "4'b0111", "+7%");
  a_FCSI_BIASCENT_ctl_trim_bgp_0_0->addItem("1", "4'b0110", "+6%");
  a_FCSI_BIASCENT_ctl_trim_bgp_0_0->addItem("2", "4'b0101", "+5%");
  a_FCSI_BIASCENT_ctl_trim_bgp_0_0->addItem("3", "4'b0100", "+4%");
  a_FCSI_BIASCENT_ctl_trim_bgp_0_0->addItem("4", "4'b0011", "+3%");
  a_FCSI_BIASCENT_ctl_trim_bgp_0_0->addItem("5", "4'b0010", "+2%");
  a_FCSI_BIASCENT_ctl_trim_bgp_0_0->addItem("6", "4'b0001", "+1%");
  a_FCSI_BIASCENT_ctl_trim_bgp_0_0->addItem("7", "4'b0000", "1.22V");
  a_FCSI_BIASCENT_ctl_trim_bgp_0_0->addItem("8", "4'b1111", "-1%");
  a_FCSI_BIASCENT_ctl_trim_bgp_0_0->addItem("9", "4'b1110", "-2%");
  a_FCSI_BIASCENT_ctl_trim_bgp_0_0->addItem("10", "4'b1101", "-3%");
  a_FCSI_BIASCENT_ctl_trim_bgp_0_0->addItem("11", "4'b1100", "-4%");
  a_FCSI_BIASCENT_ctl_trim_bgp_0_0->addItem("12", "4'b1011", "-5%");
  a_FCSI_BIASCENT_ctl_trim_bgp_0_0->addItem("13", "4'b1010", "-6%");
  a_FCSI_BIASCENT_ctl_trim_bgp_0_0->addItem("14", "4'b1001", "-7%");
  a_FCSI_BIASCENT_ctl_trim_bgp_0_0->addItem("15", "4'b1000", "-8.0%");
  f_FCSI_BIASCENT_ctl_trim_bgp->connectAttribute (a_FCSI_BIASCENT_ctl_trim_bgp_0_0);

  RField* f_FCSI_BIASCENT_ctl_temcoeff_bgp = new RField;
  f_FCSI_BIASCENT_ctl_temcoeff_bgp->setInstName ("ctl_temcoeff_bgp");
  f_FCSI_BIASCENT_ctl_temcoeff_bgp->setLongName ("CTL TEMP COEFF BGP");
  f_FCSI_BIASCENT_ctl_temcoeff_bgp->setDescription ("Temperature coefficient bandgap");
  f_FCSI_BIASCENT_ctl_temcoeff_bgp->setDataWidth (2);
  f_FCSI_BIASCENT_ctl_temcoeff_bgp->setResetVal ("2'b00");
  f_FCSI_BIASCENT_ctl_temcoeff_bgp->setAccProp (AccProp::RW);
  r_FCSI_BIASCENT->connectRField (f_FCSI_BIASCENT_ctl_temcoeff_bgp, 7);

  RField* f_FCSI_BIASCENT_ctl_cal_iconst = new RField;
  f_FCSI_BIASCENT_ctl_cal_iconst->setInstName ("ctl_cal_iconst");
  f_FCSI_BIASCENT_ctl_cal_iconst->setLongName ("CTL CAL ICONST");
  f_FCSI_BIASCENT_ctl_cal_iconst->setDescription ("Calibration Iconst");
  f_FCSI_BIASCENT_ctl_cal_iconst->setDataWidth (5);
  f_FCSI_BIASCENT_ctl_cal_iconst->setResetVal ("5'b00000");
  f_FCSI_BIASCENT_ctl_cal_iconst->setAccProp (AccProp::RW);
  r_FCSI_BIASCENT->connectRField (f_FCSI_BIASCENT_ctl_cal_iconst, 9);

  Attribute* a_FCSI_BIASCENT_ctl_cal_iconst_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_BIASCENT_ctl_cal_iconst_0_0->setInstName ("0");
  a_FCSI_BIASCENT_ctl_cal_iconst_0_0->setLongName ("");
  a_FCSI_BIASCENT_ctl_cal_iconst_0_0->setDescription ("");
  a_FCSI_BIASCENT_ctl_cal_iconst_0_0->addItem("0", "5'b00000", "230uA");
  a_FCSI_BIASCENT_ctl_cal_iconst_0_0->addItem("1", "5'b00001", "228uA");
  a_FCSI_BIASCENT_ctl_cal_iconst_0_0->addItem("2", "5'b00010", "226uA");
  a_FCSI_BIASCENT_ctl_cal_iconst_0_0->addItem("3", "5'b00011", "224uA");
  a_FCSI_BIASCENT_ctl_cal_iconst_0_0->addItem("4", "5'b00100", "222uA");
  a_FCSI_BIASCENT_ctl_cal_iconst_0_0->addItem("5", "5'b00101", "220uA");
  a_FCSI_BIASCENT_ctl_cal_iconst_0_0->addItem("6", "5'b00110", "218uA");
  a_FCSI_BIASCENT_ctl_cal_iconst_0_0->addItem("7", "5'b00111", "216uA");
  a_FCSI_BIASCENT_ctl_cal_iconst_0_0->addItem("8", "5'b01000", "214uA");
  a_FCSI_BIASCENT_ctl_cal_iconst_0_0->addItem("9", "5'b01001", "212uA");
  a_FCSI_BIASCENT_ctl_cal_iconst_0_0->addItem("10", "5'b01010", "210uA");
  a_FCSI_BIASCENT_ctl_cal_iconst_0_0->addItem("11", "5'b01011", "208uA");
  a_FCSI_BIASCENT_ctl_cal_iconst_0_0->addItem("12", "5'b01100", "206uA");
  a_FCSI_BIASCENT_ctl_cal_iconst_0_0->addItem("13", "5'b01101", "204uA");
  a_FCSI_BIASCENT_ctl_cal_iconst_0_0->addItem("14", "5'b01110", "202uA");
  a_FCSI_BIASCENT_ctl_cal_iconst_0_0->addItem("15", "5'b01111", "200uA");
  a_FCSI_BIASCENT_ctl_cal_iconst_0_0->addItem("16", "5'b10000", "198uA");
  a_FCSI_BIASCENT_ctl_cal_iconst_0_0->addItem("17", "5'b10001", "196uA");
  a_FCSI_BIASCENT_ctl_cal_iconst_0_0->addItem("18", "5'b10010", "194uA");
  a_FCSI_BIASCENT_ctl_cal_iconst_0_0->addItem("19", "5'b10011", "192uA");
  a_FCSI_BIASCENT_ctl_cal_iconst_0_0->addItem("20", "5'b10100", "190uA");
  a_FCSI_BIASCENT_ctl_cal_iconst_0_0->addItem("21", "5'b10101", "188uA");
  a_FCSI_BIASCENT_ctl_cal_iconst_0_0->addItem("22", "5'b10110", "186uA");
  a_FCSI_BIASCENT_ctl_cal_iconst_0_0->addItem("23", "5'b10111", "184uA");
  a_FCSI_BIASCENT_ctl_cal_iconst_0_0->addItem("24", "5'b11000", "182uA");
  a_FCSI_BIASCENT_ctl_cal_iconst_0_0->addItem("25", "5'b11001", "180uA");
  a_FCSI_BIASCENT_ctl_cal_iconst_0_0->addItem("26", "5'b11010", "178uA");
  a_FCSI_BIASCENT_ctl_cal_iconst_0_0->addItem("27", "5'b11011", "176uA");
  a_FCSI_BIASCENT_ctl_cal_iconst_0_0->addItem("28", "5'b11100", "174uA");
  a_FCSI_BIASCENT_ctl_cal_iconst_0_0->addItem("29", "5'b11101", "172uA");
  a_FCSI_BIASCENT_ctl_cal_iconst_0_0->addItem("30", "5'b11110", "170uA");
  a_FCSI_BIASCENT_ctl_cal_iconst_0_0->addItem("31", "5'b11111", "168uA");
  f_FCSI_BIASCENT_ctl_cal_iconst->connectAttribute (a_FCSI_BIASCENT_ctl_cal_iconst_0_0);

  RField* f_FCSI_BIASCENT_bgp_ready = new RField;
  f_FCSI_BIASCENT_bgp_ready->setInstName ("bgp_ready");
  f_FCSI_BIASCENT_bgp_ready->setLongName ("BGP READY");
  f_FCSI_BIASCENT_bgp_ready->setDescription ("Bandgap ready");
  f_FCSI_BIASCENT_bgp_ready->setDataWidth (1);
  f_FCSI_BIASCENT_bgp_ready->setResetVal ("1'b0");
  f_FCSI_BIASCENT_bgp_ready->setAccProp (AccProp::R);
  r_FCSI_BIASCENT->connectRField (f_FCSI_BIASCENT_bgp_ready, 14);

  Attribute* a_FCSI_BIASCENT_bgp_ready_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_BIASCENT_bgp_ready_0_0->setInstName ("0");
  a_FCSI_BIASCENT_bgp_ready_0_0->setLongName ("");
  a_FCSI_BIASCENT_bgp_ready_0_0->setDescription ("");
  a_FCSI_BIASCENT_bgp_ready_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_BIASCENT_bgp_ready_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_BIASCENT_bgp_ready->connectAttribute (a_FCSI_BIASCENT_bgp_ready_0_0);

  Register* r_FCSI_CONFIG0 = new Register;
  r_FCSI_CONFIG0->setInstName ("CONFIG0");
  r_FCSI_CONFIG0->setLongName ("CONFIG0");
  r_FCSI_CONFIG0->setDescription ("FCSI-LDO1V2");
  r_FCSI_CONFIG0->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_CONFIG0, 0x00000029);

  RField* f_FCSI_CONFIG0_en_ldomon = new RField;
  f_FCSI_CONFIG0_en_ldomon->setInstName ("en_ldomon");
  f_FCSI_CONFIG0_en_ldomon->setLongName ("EN LDOMON");
  f_FCSI_CONFIG0_en_ldomon->setDescription ("Enable the toplevel LDO monitor");
  f_FCSI_CONFIG0_en_ldomon->setDataWidth (1);
  f_FCSI_CONFIG0_en_ldomon->setResetVal ("1'b0");
  f_FCSI_CONFIG0_en_ldomon->setAccProp (AccProp::RW);
  r_FCSI_CONFIG0->connectRField (f_FCSI_CONFIG0_en_ldomon, 0);

  Attribute* a_FCSI_CONFIG0_en_ldomon_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_CONFIG0_en_ldomon_0_0->setInstName ("0");
  a_FCSI_CONFIG0_en_ldomon_0_0->setLongName ("");
  a_FCSI_CONFIG0_en_ldomon_0_0->setDescription ("");
  a_FCSI_CONFIG0_en_ldomon_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_CONFIG0_en_ldomon_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_CONFIG0_en_ldomon->connectAttribute (a_FCSI_CONFIG0_en_ldomon_0_0);

  RField* f_FCSI_CONFIG0_fectl_C0 = new RField;
  f_FCSI_CONFIG0_fectl_C0->setInstName ("fectl_C0");
  f_FCSI_CONFIG0_fectl_C0->setLongName ("FECTL C0");
  f_FCSI_CONFIG0_fectl_C0->setDescription ("Front end control C0");
  f_FCSI_CONFIG0_fectl_C0->setDataWidth (1);
  f_FCSI_CONFIG0_fectl_C0->setResetVal ("1'b0");
  f_FCSI_CONFIG0_fectl_C0->setAccProp (AccProp::RW);
  r_FCSI_CONFIG0->connectRField (f_FCSI_CONFIG0_fectl_C0, 1);

  Attribute* a_FCSI_CONFIG0_fectl_C0_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_CONFIG0_fectl_C0_0_0->setInstName ("0");
  a_FCSI_CONFIG0_fectl_C0_0_0->setLongName ("");
  a_FCSI_CONFIG0_fectl_C0_0_0->setDescription ("");
  a_FCSI_CONFIG0_fectl_C0_0_0->addItem("0", "1'b0", "disable");
  a_FCSI_CONFIG0_fectl_C0_0_0->addItem("1", "1'b1", "enable");
  f_FCSI_CONFIG0_fectl_C0->connectAttribute (a_FCSI_CONFIG0_fectl_C0_0_0);

  RField* f_FCSI_CONFIG0_fectl_C1 = new RField;
  f_FCSI_CONFIG0_fectl_C1->setInstName ("fectl_C1");
  f_FCSI_CONFIG0_fectl_C1->setLongName ("FECTL C1");
  f_FCSI_CONFIG0_fectl_C1->setDescription ("Front end control C1");
  f_FCSI_CONFIG0_fectl_C1->setDataWidth (1);
  f_FCSI_CONFIG0_fectl_C1->setResetVal ("1'b0");
  f_FCSI_CONFIG0_fectl_C1->setAccProp (AccProp::RW);
  r_FCSI_CONFIG0->connectRField (f_FCSI_CONFIG0_fectl_C1, 2);

  Attribute* a_FCSI_CONFIG0_fectl_C1_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_CONFIG0_fectl_C1_0_0->setInstName ("0");
  a_FCSI_CONFIG0_fectl_C1_0_0->setLongName ("");
  a_FCSI_CONFIG0_fectl_C1_0_0->setDescription ("");
  a_FCSI_CONFIG0_fectl_C1_0_0->addItem("0", "1'b0", "disable");
  a_FCSI_CONFIG0_fectl_C1_0_0->addItem("1", "1'b1", "enable");
  f_FCSI_CONFIG0_fectl_C1->connectAttribute (a_FCSI_CONFIG0_fectl_C1_0_0);

  RField* f_FCSI_CONFIG0_fectl_C2 = new RField;
  f_FCSI_CONFIG0_fectl_C2->setInstName ("fectl_C2");
  f_FCSI_CONFIG0_fectl_C2->setLongName ("FECTL C2");
  f_FCSI_CONFIG0_fectl_C2->setDescription ("Front end control C2");
  f_FCSI_CONFIG0_fectl_C2->setDataWidth (1);
  f_FCSI_CONFIG0_fectl_C2->setResetVal ("1'b0");
  f_FCSI_CONFIG0_fectl_C2->setAccProp (AccProp::RW);
  r_FCSI_CONFIG0->connectRField (f_FCSI_CONFIG0_fectl_C2, 3);

  Attribute* a_FCSI_CONFIG0_fectl_C2_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_CONFIG0_fectl_C2_0_0->setInstName ("0");
  a_FCSI_CONFIG0_fectl_C2_0_0->setLongName ("");
  a_FCSI_CONFIG0_fectl_C2_0_0->setDescription ("");
  a_FCSI_CONFIG0_fectl_C2_0_0->addItem("0", "1'b0", "disable");
  a_FCSI_CONFIG0_fectl_C2_0_0->addItem("1", "1'b1", "enable");
  f_FCSI_CONFIG0_fectl_C2->connectAttribute (a_FCSI_CONFIG0_fectl_C2_0_0);

  RField* f_FCSI_CONFIG0_fectl_C3 = new RField;
  f_FCSI_CONFIG0_fectl_C3->setInstName ("fectl_C3");
  f_FCSI_CONFIG0_fectl_C3->setLongName ("FECTL C3");
  f_FCSI_CONFIG0_fectl_C3->setDescription ("Front end control C3");
  f_FCSI_CONFIG0_fectl_C3->setDataWidth (1);
  f_FCSI_CONFIG0_fectl_C3->setResetVal ("1'b0");
  f_FCSI_CONFIG0_fectl_C3->setAccProp (AccProp::RW);
  r_FCSI_CONFIG0->connectRField (f_FCSI_CONFIG0_fectl_C3, 4);

  Attribute* a_FCSI_CONFIG0_fectl_C3_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_CONFIG0_fectl_C3_0_0->setInstName ("0");
  a_FCSI_CONFIG0_fectl_C3_0_0->setLongName ("");
  a_FCSI_CONFIG0_fectl_C3_0_0->setDescription ("");
  a_FCSI_CONFIG0_fectl_C3_0_0->addItem("0", "1'b0", "disable");
  a_FCSI_CONFIG0_fectl_C3_0_0->addItem("1", "1'b1", "enable");
  f_FCSI_CONFIG0_fectl_C3->connectAttribute (a_FCSI_CONFIG0_fectl_C3_0_0);

  RField* f_FCSI_CONFIG0_fectl_C4 = new RField;
  f_FCSI_CONFIG0_fectl_C4->setInstName ("fectl_C4");
  f_FCSI_CONFIG0_fectl_C4->setLongName ("FECTL C4");
  f_FCSI_CONFIG0_fectl_C4->setDescription ("Front end control C4");
  f_FCSI_CONFIG0_fectl_C4->setDataWidth (1);
  f_FCSI_CONFIG0_fectl_C4->setResetVal ("1'b0");
  f_FCSI_CONFIG0_fectl_C4->setAccProp (AccProp::RW);
  r_FCSI_CONFIG0->connectRField (f_FCSI_CONFIG0_fectl_C4, 5);

  Attribute* a_FCSI_CONFIG0_fectl_C4_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_CONFIG0_fectl_C4_0_0->setInstName ("0");
  a_FCSI_CONFIG0_fectl_C4_0_0->setLongName ("");
  a_FCSI_CONFIG0_fectl_C4_0_0->setDescription ("");
  a_FCSI_CONFIG0_fectl_C4_0_0->addItem("0", "1'b0", "disable");
  a_FCSI_CONFIG0_fectl_C4_0_0->addItem("1", "1'b1", "enable");
  f_FCSI_CONFIG0_fectl_C4->connectAttribute (a_FCSI_CONFIG0_fectl_C4_0_0);

  RField* f_FCSI_CONFIG0_fectl_C5 = new RField;
  f_FCSI_CONFIG0_fectl_C5->setInstName ("fectl_C5");
  f_FCSI_CONFIG0_fectl_C5->setLongName ("FECTL C5");
  f_FCSI_CONFIG0_fectl_C5->setDescription ("Front end control C5");
  f_FCSI_CONFIG0_fectl_C5->setDataWidth (1);
  f_FCSI_CONFIG0_fectl_C5->setResetVal ("1'b0");
  f_FCSI_CONFIG0_fectl_C5->setAccProp (AccProp::RW);
  r_FCSI_CONFIG0->connectRField (f_FCSI_CONFIG0_fectl_C5, 6);

  Attribute* a_FCSI_CONFIG0_fectl_C5_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_CONFIG0_fectl_C5_0_0->setInstName ("0");
  a_FCSI_CONFIG0_fectl_C5_0_0->setLongName ("");
  a_FCSI_CONFIG0_fectl_C5_0_0->setDescription ("");
  a_FCSI_CONFIG0_fectl_C5_0_0->addItem("0", "1'b0", "disable");
  a_FCSI_CONFIG0_fectl_C5_0_0->addItem("1", "1'b1", "enable");
  f_FCSI_CONFIG0_fectl_C5->connectAttribute (a_FCSI_CONFIG0_fectl_C5_0_0);

  RField* f_FCSI_CONFIG0_fectl_C6 = new RField;
  f_FCSI_CONFIG0_fectl_C6->setInstName ("fectl_C6");
  f_FCSI_CONFIG0_fectl_C6->setLongName ("FECTL C6");
  f_FCSI_CONFIG0_fectl_C6->setDescription ("Front end control C6");
  f_FCSI_CONFIG0_fectl_C6->setDataWidth (1);
  f_FCSI_CONFIG0_fectl_C6->setResetVal ("1'b0");
  f_FCSI_CONFIG0_fectl_C6->setAccProp (AccProp::RW);
  r_FCSI_CONFIG0->connectRField (f_FCSI_CONFIG0_fectl_C6, 7);

  Attribute* a_FCSI_CONFIG0_fectl_C6_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_CONFIG0_fectl_C6_0_0->setInstName ("0");
  a_FCSI_CONFIG0_fectl_C6_0_0->setLongName ("");
  a_FCSI_CONFIG0_fectl_C6_0_0->setDescription ("");
  a_FCSI_CONFIG0_fectl_C6_0_0->addItem("0", "1'b0", "disable");
  a_FCSI_CONFIG0_fectl_C6_0_0->addItem("1", "1'b1", "enable");
  f_FCSI_CONFIG0_fectl_C6->connectAttribute (a_FCSI_CONFIG0_fectl_C6_0_0);

  RField* f_FCSI_CONFIG0_fectl_C7 = new RField;
  f_FCSI_CONFIG0_fectl_C7->setInstName ("fectl_C7");
  f_FCSI_CONFIG0_fectl_C7->setLongName ("FECTL C7");
  f_FCSI_CONFIG0_fectl_C7->setDescription ("Front end control C7");
  f_FCSI_CONFIG0_fectl_C7->setDataWidth (1);
  f_FCSI_CONFIG0_fectl_C7->setResetVal ("1'b0");
  f_FCSI_CONFIG0_fectl_C7->setAccProp (AccProp::RW);
  r_FCSI_CONFIG0->connectRField (f_FCSI_CONFIG0_fectl_C7, 8);

  Attribute* a_FCSI_CONFIG0_fectl_C7_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_CONFIG0_fectl_C7_0_0->setInstName ("0");
  a_FCSI_CONFIG0_fectl_C7_0_0->setLongName ("");
  a_FCSI_CONFIG0_fectl_C7_0_0->setDescription ("");
  a_FCSI_CONFIG0_fectl_C7_0_0->addItem("0", "1'b0", "disable");
  a_FCSI_CONFIG0_fectl_C7_0_0->addItem("1", "1'b1", "enable");
  f_FCSI_CONFIG0_fectl_C7->connectAttribute (a_FCSI_CONFIG0_fectl_C7_0_0);

  RField* f_FCSI_CONFIG0_ctl_fectl = new RField;
  f_FCSI_CONFIG0_ctl_fectl->setInstName ("ctl_fectl");
  f_FCSI_CONFIG0_ctl_fectl->setLongName ("CTL_FECTL");
  f_FCSI_CONFIG0_ctl_fectl->setDescription ("Control Front end control input");
  f_FCSI_CONFIG0_ctl_fectl->setDataWidth (1);
  f_FCSI_CONFIG0_ctl_fectl->setResetVal ("1'b0");
  f_FCSI_CONFIG0_ctl_fectl->setAccProp (AccProp::RW);
  r_FCSI_CONFIG0->connectRField (f_FCSI_CONFIG0_ctl_fectl, 9);

  Attribute* a_FCSI_CONFIG0_ctl_fectl_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_CONFIG0_ctl_fectl_0_0->setInstName ("0");
  a_FCSI_CONFIG0_ctl_fectl_0_0->setLongName ("");
  a_FCSI_CONFIG0_ctl_fectl_0_0->setDescription ("");
  a_FCSI_CONFIG0_ctl_fectl_0_0->addItem("0", "1'b0", "from SR");
  a_FCSI_CONFIG0_ctl_fectl_0_0->addItem("1", "1'b1", "from LR");
  f_FCSI_CONFIG0_ctl_fectl->connectAttribute (a_FCSI_CONFIG0_ctl_fectl_0_0);

  RField* f_FCSI_CONFIG0_fectl_io_sel = new RField;
  f_FCSI_CONFIG0_fectl_io_sel->setInstName ("fectl_io_sel");
  f_FCSI_CONFIG0_fectl_io_sel->setLongName ("FECTL IO SEL");
  f_FCSI_CONFIG0_fectl_io_sel->setDescription ("Front end control I/O selection (enable PULL down resistor)");
  f_FCSI_CONFIG0_fectl_io_sel->setDataWidth (1);
  f_FCSI_CONFIG0_fectl_io_sel->setResetVal ("1'b0");
  f_FCSI_CONFIG0_fectl_io_sel->setAccProp (AccProp::RW);
  r_FCSI_CONFIG0->connectRField (f_FCSI_CONFIG0_fectl_io_sel, 10);

  Attribute* a_FCSI_CONFIG0_fectl_io_sel_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_CONFIG0_fectl_io_sel_0_0->setInstName ("0");
  a_FCSI_CONFIG0_fectl_io_sel_0_0->setLongName ("");
  a_FCSI_CONFIG0_fectl_io_sel_0_0->setDescription ("");
  a_FCSI_CONFIG0_fectl_io_sel_0_0->addItem("0", "1'b0", "disable");
  a_FCSI_CONFIG0_fectl_io_sel_0_0->addItem("1", "1'b1", "enable");
  f_FCSI_CONFIG0_fectl_io_sel->connectAttribute (a_FCSI_CONFIG0_fectl_io_sel_0_0);

  Register* r_FCSI_CONFIG1 = new Register;
  r_FCSI_CONFIG1->setInstName ("CONFIG1");
  r_FCSI_CONFIG1->setLongName ("CONFIG1");
  r_FCSI_CONFIG1->setDescription ("FCSI-LDO1V2");
  r_FCSI_CONFIG1->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_CONFIG1, 0x0000002A);

  RField* f_FCSI_CONFIG1_soft_reset = new RField;
  f_FCSI_CONFIG1_soft_reset->setInstName ("soft_reset");
  f_FCSI_CONFIG1_soft_reset->setLongName ("SOFT RESET");
  f_FCSI_CONFIG1_soft_reset->setDescription ("Soft reset");
  f_FCSI_CONFIG1_soft_reset->setDataWidth (1);
  f_FCSI_CONFIG1_soft_reset->setResetVal ("1'b0");
  f_FCSI_CONFIG1_soft_reset->setAccProp (AccProp::RW);
  r_FCSI_CONFIG1->connectRField (f_FCSI_CONFIG1_soft_reset, 0);

  Attribute* a_FCSI_CONFIG1_soft_reset_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_CONFIG1_soft_reset_0_0->setInstName ("0");
  a_FCSI_CONFIG1_soft_reset_0_0->setLongName ("");
  a_FCSI_CONFIG1_soft_reset_0_0->setDescription ("");
  a_FCSI_CONFIG1_soft_reset_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_CONFIG1_soft_reset_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_CONFIG1_soft_reset->connectAttribute (a_FCSI_CONFIG1_soft_reset_0_0);

  RField* f_FCSI_CONFIG1_byp_rest_spike_filter = new RField;
  f_FCSI_CONFIG1_byp_rest_spike_filter->setInstName ("byp_rest_spike_filter");
  f_FCSI_CONFIG1_byp_rest_spike_filter->setLongName ("BYP REST SPIKE FILTER");
  f_FCSI_CONFIG1_byp_rest_spike_filter->setDescription ("Bypass rest spike filter");
  f_FCSI_CONFIG1_byp_rest_spike_filter->setDataWidth (1);
  f_FCSI_CONFIG1_byp_rest_spike_filter->setResetVal ("1'b0");
  f_FCSI_CONFIG1_byp_rest_spike_filter->setAccProp (AccProp::RW);
  r_FCSI_CONFIG1->connectRField (f_FCSI_CONFIG1_byp_rest_spike_filter, 1);

  Attribute* a_FCSI_CONFIG1_byp_rest_spike_filter_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_CONFIG1_byp_rest_spike_filter_0_0->setInstName ("0");
  a_FCSI_CONFIG1_byp_rest_spike_filter_0_0->setLongName ("");
  a_FCSI_CONFIG1_byp_rest_spike_filter_0_0->setDescription ("");
  a_FCSI_CONFIG1_byp_rest_spike_filter_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_CONFIG1_byp_rest_spike_filter_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_CONFIG1_byp_rest_spike_filter->connectAttribute (a_FCSI_CONFIG1_byp_rest_spike_filter_0_0);

  RField* f_FCSI_CONFIG1_data_io_ds = new RField;
  f_FCSI_CONFIG1_data_io_ds->setInstName ("data_io_ds");
  f_FCSI_CONFIG1_data_io_ds->setLongName ("DATA IO DS");
  f_FCSI_CONFIG1_data_io_ds->setDescription ("FCSI data io driver strength control");
  f_FCSI_CONFIG1_data_io_ds->setDataWidth (1);
  f_FCSI_CONFIG1_data_io_ds->setResetVal ("1'b0");
  f_FCSI_CONFIG1_data_io_ds->setAccProp (AccProp::RW);
  r_FCSI_CONFIG1->connectRField (f_FCSI_CONFIG1_data_io_ds, 2);

  Attribute* a_FCSI_CONFIG1_data_io_ds_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_CONFIG1_data_io_ds_0_0->setInstName ("0");
  a_FCSI_CONFIG1_data_io_ds_0_0->setLongName ("");
  a_FCSI_CONFIG1_data_io_ds_0_0->setDescription ("");
  a_FCSI_CONFIG1_data_io_ds_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_CONFIG1_data_io_ds_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_CONFIG1_data_io_ds->connectAttribute (a_FCSI_CONFIG1_data_io_ds_0_0);

  RField* f_FCSI_CONFIG1_soft_reset_efuse = new RField;
  f_FCSI_CONFIG1_soft_reset_efuse->setInstName ("soft_reset_efuse");
  f_FCSI_CONFIG1_soft_reset_efuse->setLongName ("SOFT RESET EFUSE");
  f_FCSI_CONFIG1_soft_reset_efuse->setDescription ("Soft reset of efuse (high active)");
  f_FCSI_CONFIG1_soft_reset_efuse->setDataWidth (1);
  f_FCSI_CONFIG1_soft_reset_efuse->setResetVal ("1'b0");
  f_FCSI_CONFIG1_soft_reset_efuse->setAccProp (AccProp::RW);
  r_FCSI_CONFIG1->connectRField (f_FCSI_CONFIG1_soft_reset_efuse, 3);

  Attribute* a_FCSI_CONFIG1_soft_reset_efuse_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_CONFIG1_soft_reset_efuse_0_0->setInstName ("0");
  a_FCSI_CONFIG1_soft_reset_efuse_0_0->setLongName ("");
  a_FCSI_CONFIG1_soft_reset_efuse_0_0->setDescription ("");
  a_FCSI_CONFIG1_soft_reset_efuse_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_CONFIG1_soft_reset_efuse_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_CONFIG1_soft_reset_efuse->connectAttribute (a_FCSI_CONFIG1_soft_reset_efuse_0_0);

  RField* f_FCSI_CONFIG1_en_clk_write = new RField;
  f_FCSI_CONFIG1_en_clk_write->setInstName ("en_clk_write");
  f_FCSI_CONFIG1_en_clk_write->setLongName ("EN_CLK_WRITE");
  f_FCSI_CONFIG1_en_clk_write->setDescription ("Enable clock coming from pad FECTL_0");
  f_FCSI_CONFIG1_en_clk_write->setDataWidth (1);
  f_FCSI_CONFIG1_en_clk_write->setResetVal ("1'b0");
  f_FCSI_CONFIG1_en_clk_write->setAccProp (AccProp::RW);
  r_FCSI_CONFIG1->connectRField (f_FCSI_CONFIG1_en_clk_write, 4);

  Attribute* a_FCSI_CONFIG1_en_clk_write_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_CONFIG1_en_clk_write_0_0->setInstName ("0");
  a_FCSI_CONFIG1_en_clk_write_0_0->setLongName ("");
  a_FCSI_CONFIG1_en_clk_write_0_0->setDescription ("");
  a_FCSI_CONFIG1_en_clk_write_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_CONFIG1_en_clk_write_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_CONFIG1_en_clk_write->connectAttribute (a_FCSI_CONFIG1_en_clk_write_0_0);

  RField* f_FCSI_CONFIG1_en_res_n = new RField;
  f_FCSI_CONFIG1_en_res_n->setInstName ("en_res_n");
  f_FCSI_CONFIG1_en_res_n->setLongName ("EN_RES_N");
  f_FCSI_CONFIG1_en_res_n->setDescription ("Enable reset_n coming from pad FECTL_1");
  f_FCSI_CONFIG1_en_res_n->setDataWidth (1);
  f_FCSI_CONFIG1_en_res_n->setResetVal ("1'b0");
  f_FCSI_CONFIG1_en_res_n->setAccProp (AccProp::RW);
  r_FCSI_CONFIG1->connectRField (f_FCSI_CONFIG1_en_res_n, 5);

  Attribute* a_FCSI_CONFIG1_en_res_n_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_CONFIG1_en_res_n_0_0->setInstName ("0");
  a_FCSI_CONFIG1_en_res_n_0_0->setLongName ("");
  a_FCSI_CONFIG1_en_res_n_0_0->setDescription ("");
  a_FCSI_CONFIG1_en_res_n_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_CONFIG1_en_res_n_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_CONFIG1_en_res_n->connectAttribute (a_FCSI_CONFIG1_en_res_n_0_0);

  RField* f_FCSI_CONFIG1_en_input_fectl_C01 = new RField;
  f_FCSI_CONFIG1_en_input_fectl_C01->setInstName ("en_input_fectl_C01");
  f_FCSI_CONFIG1_en_input_fectl_C01->setLongName ("EN_INPUT_FECTL_C01");
  f_FCSI_CONFIG1_en_input_fectl_C01->setDescription ("Enable FECTL_C0 and FECTL_C1 as input pad to drive CLK and RES_N from outside");
  f_FCSI_CONFIG1_en_input_fectl_C01->setDataWidth (1);
  f_FCSI_CONFIG1_en_input_fectl_C01->setResetVal ("1'b0");
  f_FCSI_CONFIG1_en_input_fectl_C01->setAccProp (AccProp::RW);
  r_FCSI_CONFIG1->connectRField (f_FCSI_CONFIG1_en_input_fectl_C01, 6);

  Attribute* a_FCSI_CONFIG1_en_input_fectl_C01_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_CONFIG1_en_input_fectl_C01_0_0->setInstName ("0");
  a_FCSI_CONFIG1_en_input_fectl_C01_0_0->setLongName ("");
  a_FCSI_CONFIG1_en_input_fectl_C01_0_0->setDescription ("");
  a_FCSI_CONFIG1_en_input_fectl_C01_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_CONFIG1_en_input_fectl_C01_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_CONFIG1_en_input_fectl_C01->connectAttribute (a_FCSI_CONFIG1_en_input_fectl_C01_0_0);

  RField* f_FCSI_CONFIG1_ctl_vcm_in = new RField;
  f_FCSI_CONFIG1_ctl_vcm_in->setInstName ("ctl_vcm_in");
  f_FCSI_CONFIG1_ctl_vcm_in->setLongName ("CTL_VCM_IN");
  f_FCSI_CONFIG1_ctl_vcm_in->setDescription ("Control vcm input source for BBO buffer's (B0 and higher)");
  f_FCSI_CONFIG1_ctl_vcm_in->setDataWidth (1);
  f_FCSI_CONFIG1_ctl_vcm_in->setResetVal ("1'b0");
  f_FCSI_CONFIG1_ctl_vcm_in->setAccProp (AccProp::RW);
  r_FCSI_CONFIG1->connectRField (f_FCSI_CONFIG1_ctl_vcm_in, 7);

  Attribute* a_FCSI_CONFIG1_ctl_vcm_in_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_CONFIG1_ctl_vcm_in_0_0->setInstName ("0");
  a_FCSI_CONFIG1_ctl_vcm_in_0_0->setLongName ("");
  a_FCSI_CONFIG1_ctl_vcm_in_0_0->setDescription ("");
  a_FCSI_CONFIG1_ctl_vcm_in_0_0->addItem("1", "1'b1", "VCM buffer");
  a_FCSI_CONFIG1_ctl_vcm_in_0_0->addItem("0", "1'b0", "P2PR restistor");
  f_FCSI_CONFIG1_ctl_vcm_in->connectAttribute (a_FCSI_CONFIG1_ctl_vcm_in_0_0);

  RField* f_FCSI_CONFIG1_reserved = new RField;
  f_FCSI_CONFIG1_reserved->setInstName ("reserved");
  f_FCSI_CONFIG1_reserved->setLongName ("RESERVED");
  f_FCSI_CONFIG1_reserved->setDescription ("RESERVED BITs (PGC calibration)");
  f_FCSI_CONFIG1_reserved->setDataWidth (6);
  f_FCSI_CONFIG1_reserved->setResetVal ("6'b000000");
  f_FCSI_CONFIG1_reserved->setAccProp (AccProp::R);
  r_FCSI_CONFIG1->connectRField (f_FCSI_CONFIG1_reserved, 9);

  Attribute* a_FCSI_CONFIG1_reserved_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_CONFIG1_reserved_0_0->setInstName ("0");
  a_FCSI_CONFIG1_reserved_0_0->setLongName ("");
  a_FCSI_CONFIG1_reserved_0_0->setDescription ("");
  a_FCSI_CONFIG1_reserved_0_0->addItem("5", "6'b000101", "efuse13<15>");
  a_FCSI_CONFIG1_reserved_0_0->addItem("4", "6'b000100", "efuse13<14>");
  a_FCSI_CONFIG1_reserved_0_0->addItem("3", "6'b000011", "efuse15<15>");
  a_FCSI_CONFIG1_reserved_0_0->addItem("2", "6'b000010", "efuse15<13>");
  a_FCSI_CONFIG1_reserved_0_0->addItem("1", "6'b000001", "efuse15<12>");
  a_FCSI_CONFIG1_reserved_0_0->addItem("0", "6'b000000", "efuse15<11>");
  f_FCSI_CONFIG1_reserved->connectAttribute (a_FCSI_CONFIG1_reserved_0_0);

  RField* f_FCSI_CONFIG1_efuse_rdy = new RField;
  f_FCSI_CONFIG1_efuse_rdy->setInstName ("efuse_rdy");
  f_FCSI_CONFIG1_efuse_rdy->setLongName ("EFUSE_RDY");
  f_FCSI_CONFIG1_efuse_rdy->setDescription ("Efuse ready bit");
  f_FCSI_CONFIG1_efuse_rdy->setDataWidth (1);
  f_FCSI_CONFIG1_efuse_rdy->setResetVal ("1'b0");
  f_FCSI_CONFIG1_efuse_rdy->setAccProp (AccProp::R);
  r_FCSI_CONFIG1->connectRField (f_FCSI_CONFIG1_efuse_rdy, 15);

  Attribute* a_FCSI_CONFIG1_efuse_rdy_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_CONFIG1_efuse_rdy_0_0->setInstName ("0");
  a_FCSI_CONFIG1_efuse_rdy_0_0->setLongName ("");
  a_FCSI_CONFIG1_efuse_rdy_0_0->setDescription ("");
  a_FCSI_CONFIG1_efuse_rdy_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_CONFIG1_efuse_rdy_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_CONFIG1_efuse_rdy->connectAttribute (a_FCSI_CONFIG1_efuse_rdy_0_0);

  Register* r_FCSI_BBIOLDO1V2 = new Register;
  r_FCSI_BBIOLDO1V2->setInstName ("BBIOLDO1V2");
  r_FCSI_BBIOLDO1V2->setLongName ("BBIO LDO1V2 + BIAS");
  r_FCSI_BBIOLDO1V2->setDescription ("FCSI-LDO1V2");
  r_FCSI_BBIOLDO1V2->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_BBIOLDO1V2, 0x0000002B);

  RField* f_FCSI_BBIOLDO1V2_en_ldo = new RField;
  f_FCSI_BBIOLDO1V2_en_ldo->setInstName ("en_ldo");
  f_FCSI_BBIOLDO1V2_en_ldo->setLongName ("EN LDO");
  f_FCSI_BBIOLDO1V2_en_ldo->setDescription ("Enable BBIO LDO");
  f_FCSI_BBIOLDO1V2_en_ldo->setDataWidth (1);
  f_FCSI_BBIOLDO1V2_en_ldo->setResetVal ("1'b0");
  f_FCSI_BBIOLDO1V2_en_ldo->setAccProp (AccProp::RW);
  r_FCSI_BBIOLDO1V2->connectRField (f_FCSI_BBIOLDO1V2_en_ldo, 0);

  Attribute* a_FCSI_BBIOLDO1V2_en_ldo_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_BBIOLDO1V2_en_ldo_0_0->setInstName ("0");
  a_FCSI_BBIOLDO1V2_en_ldo_0_0->setLongName ("");
  a_FCSI_BBIOLDO1V2_en_ldo_0_0->setDescription ("");
  a_FCSI_BBIOLDO1V2_en_ldo_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_BBIOLDO1V2_en_ldo_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_BBIOLDO1V2_en_ldo->connectAttribute (a_FCSI_BBIOLDO1V2_en_ldo_0_0);

  RField* f_FCSI_BBIOLDO1V2_en_rload = new RField;
  f_FCSI_BBIOLDO1V2_en_rload->setInstName ("en_rload");
  f_FCSI_BBIOLDO1V2_en_rload->setLongName ("EN RLOAD");
  f_FCSI_BBIOLDO1V2_en_rload->setDescription ("Enable resistive load of LDO");
  f_FCSI_BBIOLDO1V2_en_rload->setDataWidth (1);
  f_FCSI_BBIOLDO1V2_en_rload->setResetVal ("1'b0");
  f_FCSI_BBIOLDO1V2_en_rload->setAccProp (AccProp::RW);
  r_FCSI_BBIOLDO1V2->connectRField (f_FCSI_BBIOLDO1V2_en_rload, 1);

  Attribute* a_FCSI_BBIOLDO1V2_en_rload_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_BBIOLDO1V2_en_rload_0_0->setInstName ("0");
  a_FCSI_BBIOLDO1V2_en_rload_0_0->setLongName ("");
  a_FCSI_BBIOLDO1V2_en_rload_0_0->setDescription ("");
  a_FCSI_BBIOLDO1V2_en_rload_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_BBIOLDO1V2_en_rload_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_BBIOLDO1V2_en_rload->connectAttribute (a_FCSI_BBIOLDO1V2_en_rload_0_0);

  RField* f_FCSI_BBIOLDO1V2_en_bypass = new RField;
  f_FCSI_BBIOLDO1V2_en_bypass->setInstName ("en_bypass");
  f_FCSI_BBIOLDO1V2_en_bypass->setLongName ("EN BYPASS");
  f_FCSI_BBIOLDO1V2_en_bypass->setDescription ("Enable bypass mode of LDO");
  f_FCSI_BBIOLDO1V2_en_bypass->setDataWidth (1);
  f_FCSI_BBIOLDO1V2_en_bypass->setResetVal ("1'b0");
  f_FCSI_BBIOLDO1V2_en_bypass->setAccProp (AccProp::RW);
  r_FCSI_BBIOLDO1V2->connectRField (f_FCSI_BBIOLDO1V2_en_bypass, 2);

  Attribute* a_FCSI_BBIOLDO1V2_en_bypass_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_BBIOLDO1V2_en_bypass_0_0->setInstName ("0");
  a_FCSI_BBIOLDO1V2_en_bypass_0_0->setLongName ("");
  a_FCSI_BBIOLDO1V2_en_bypass_0_0->setDescription ("");
  a_FCSI_BBIOLDO1V2_en_bypass_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_BBIOLDO1V2_en_bypass_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_BBIOLDO1V2_en_bypass->connectAttribute (a_FCSI_BBIOLDO1V2_en_bypass_0_0);

  RField* f_FCSI_BBIOLDO1V2_ctl_vout = new RField;
  f_FCSI_BBIOLDO1V2_ctl_vout->setInstName ("ctl_vout");
  f_FCSI_BBIOLDO1V2_ctl_vout->setLongName ("CTL VOUT");
  f_FCSI_BBIOLDO1V2_ctl_vout->setDescription ("Control output voltage");
  f_FCSI_BBIOLDO1V2_ctl_vout->setDataWidth (4);
  f_FCSI_BBIOLDO1V2_ctl_vout->setResetVal ("4'b0000");
  f_FCSI_BBIOLDO1V2_ctl_vout->setAccProp (AccProp::RW);
  r_FCSI_BBIOLDO1V2->connectRField (f_FCSI_BBIOLDO1V2_ctl_vout, 3);

  Attribute* a_FCSI_BBIOLDO1V2_ctl_vout_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_BBIOLDO1V2_ctl_vout_0_0->setInstName ("0");
  a_FCSI_BBIOLDO1V2_ctl_vout_0_0->setLongName ("");
  a_FCSI_BBIOLDO1V2_ctl_vout_0_0->setDescription ("");
  a_FCSI_BBIOLDO1V2_ctl_vout_0_0->addItem("15", "4'b1111", "1.37V");
  a_FCSI_BBIOLDO1V2_ctl_vout_0_0->addItem("14", "4'b1110", "1.36V");
  a_FCSI_BBIOLDO1V2_ctl_vout_0_0->addItem("13", "4'b1101", "1.35V");
  a_FCSI_BBIOLDO1V2_ctl_vout_0_0->addItem("12", "4'b1100", "1.34V");
  a_FCSI_BBIOLDO1V2_ctl_vout_0_0->addItem("11", "4'b1011", "1.33V");
  a_FCSI_BBIOLDO1V2_ctl_vout_0_0->addItem("10", "4'b1010", "1.32V");
  a_FCSI_BBIOLDO1V2_ctl_vout_0_0->addItem("9", "4'b1001", "1.31V");
  a_FCSI_BBIOLDO1V2_ctl_vout_0_0->addItem("8", "4'b1000", "1.30V");
  a_FCSI_BBIOLDO1V2_ctl_vout_0_0->addItem("7", "4'b0111", "1.29V");
  a_FCSI_BBIOLDO1V2_ctl_vout_0_0->addItem("6", "4'b0110", "1.28V");
  a_FCSI_BBIOLDO1V2_ctl_vout_0_0->addItem("5", "4'b0101", "1.27V");
  a_FCSI_BBIOLDO1V2_ctl_vout_0_0->addItem("4", "4'b0100", "1.26V (default)");
  a_FCSI_BBIOLDO1V2_ctl_vout_0_0->addItem("3", "4'b0011", "1.25V");
  a_FCSI_BBIOLDO1V2_ctl_vout_0_0->addItem("2", "4'b0010", "1.24V");
  a_FCSI_BBIOLDO1V2_ctl_vout_0_0->addItem("1", "4'b0001", "1.23V");
  a_FCSI_BBIOLDO1V2_ctl_vout_0_0->addItem("0", "4'b0000", "1.22V");
  f_FCSI_BBIOLDO1V2_ctl_vout->connectAttribute (a_FCSI_BBIOLDO1V2_ctl_vout_0_0);

  RField* f_FCSI_BBIOLDO1V2_ctl_comp = new RField;
  f_FCSI_BBIOLDO1V2_ctl_comp->setInstName ("ctl_comp");
  f_FCSI_BBIOLDO1V2_ctl_comp->setLongName ("CTL COMP");
  f_FCSI_BBIOLDO1V2_ctl_comp->setDescription ("Control compensation capacitor");
  f_FCSI_BBIOLDO1V2_ctl_comp->setDataWidth (2);
  f_FCSI_BBIOLDO1V2_ctl_comp->setResetVal ("2'b00");
  f_FCSI_BBIOLDO1V2_ctl_comp->setAccProp (AccProp::RW);
  r_FCSI_BBIOLDO1V2->connectRField (f_FCSI_BBIOLDO1V2_ctl_comp, 7);

  Attribute* a_FCSI_BBIOLDO1V2_ctl_comp_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_BBIOLDO1V2_ctl_comp_0_0->setInstName ("0");
  a_FCSI_BBIOLDO1V2_ctl_comp_0_0->setLongName ("");
  a_FCSI_BBIOLDO1V2_ctl_comp_0_0->setDescription ("");
  a_FCSI_BBIOLDO1V2_ctl_comp_0_0->addItem("3", "2'b11", "5pF");
  a_FCSI_BBIOLDO1V2_ctl_comp_0_0->addItem("2", "2'b10", "4pF");
  a_FCSI_BBIOLDO1V2_ctl_comp_0_0->addItem("1", "2'b01", "4.5pF (default)");
  a_FCSI_BBIOLDO1V2_ctl_comp_0_0->addItem("0", "2'b00", "3.5pF");
  f_FCSI_BBIOLDO1V2_ctl_comp->connectAttribute (a_FCSI_BBIOLDO1V2_ctl_comp_0_0);

  RField* f_FCSI_BBIOLDO1V2_ctl_buf = new RField;
  f_FCSI_BBIOLDO1V2_ctl_buf->setInstName ("ctl_buf");
  f_FCSI_BBIOLDO1V2_ctl_buf->setLongName ("CTL BUF");
  f_FCSI_BBIOLDO1V2_ctl_buf->setDescription ("Control buffer current");
  f_FCSI_BBIOLDO1V2_ctl_buf->setDataWidth (1);
  f_FCSI_BBIOLDO1V2_ctl_buf->setResetVal ("1'b0");
  f_FCSI_BBIOLDO1V2_ctl_buf->setAccProp (AccProp::RW);
  r_FCSI_BBIOLDO1V2->connectRField (f_FCSI_BBIOLDO1V2_ctl_buf, 9);

  Attribute* a_FCSI_BBIOLDO1V2_ctl_buf_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_BBIOLDO1V2_ctl_buf_0_0->setInstName ("0");
  a_FCSI_BBIOLDO1V2_ctl_buf_0_0->setLongName ("");
  a_FCSI_BBIOLDO1V2_ctl_buf_0_0->setDescription ("");
  a_FCSI_BBIOLDO1V2_ctl_buf_0_0->addItem("1", "1'b1", "1mA");
  a_FCSI_BBIOLDO1V2_ctl_buf_0_0->addItem("0", "1'b0", "0.5mA (default)");
  f_FCSI_BBIOLDO1V2_ctl_buf->connectAttribute (a_FCSI_BBIOLDO1V2_ctl_buf_0_0);

  RField* f_FCSI_BBIOLDO1V2_en_test = new RField;
  f_FCSI_BBIOLDO1V2_en_test->setInstName ("en_test");
  f_FCSI_BBIOLDO1V2_en_test->setLongName ("EN TEST");
  f_FCSI_BBIOLDO1V2_en_test->setDescription ("Enable ldo output to ldo_test pad");
  f_FCSI_BBIOLDO1V2_en_test->setDataWidth (1);
  f_FCSI_BBIOLDO1V2_en_test->setResetVal ("1'b0");
  f_FCSI_BBIOLDO1V2_en_test->setAccProp (AccProp::RW);
  r_FCSI_BBIOLDO1V2->connectRField (f_FCSI_BBIOLDO1V2_en_test, 10);

  Attribute* a_FCSI_BBIOLDO1V2_en_test_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_BBIOLDO1V2_en_test_0_0->setInstName ("0");
  a_FCSI_BBIOLDO1V2_en_test_0_0->setLongName ("");
  a_FCSI_BBIOLDO1V2_en_test_0_0->setDescription ("");
  a_FCSI_BBIOLDO1V2_en_test_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_BBIOLDO1V2_en_test_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_BBIOLDO1V2_en_test->connectAttribute (a_FCSI_BBIOLDO1V2_en_test_0_0);

  RField* f_FCSI_BBIOLDO1V2_en_bias = new RField;
  f_FCSI_BBIOLDO1V2_en_bias->setInstName ("en_bias");
  f_FCSI_BBIOLDO1V2_en_bias->setLongName ("EN BIAS");
  f_FCSI_BBIOLDO1V2_en_bias->setDescription ("Enable BBIO biasing");
  f_FCSI_BBIOLDO1V2_en_bias->setDataWidth (1);
  f_FCSI_BBIOLDO1V2_en_bias->setResetVal ("1'b0");
  f_FCSI_BBIOLDO1V2_en_bias->setAccProp (AccProp::RW);
  r_FCSI_BBIOLDO1V2->connectRField (f_FCSI_BBIOLDO1V2_en_bias, 11);

  Attribute* a_FCSI_BBIOLDO1V2_en_bias_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_BBIOLDO1V2_en_bias_0_0->setInstName ("0");
  a_FCSI_BBIOLDO1V2_en_bias_0_0->setLongName ("");
  a_FCSI_BBIOLDO1V2_en_bias_0_0->setDescription ("");
  a_FCSI_BBIOLDO1V2_en_bias_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_BBIOLDO1V2_en_bias_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_BBIOLDO1V2_en_bias->connectAttribute (a_FCSI_BBIOLDO1V2_en_bias_0_0);

  RField* f_FCSI_BBIOLDO1V2_en_vcmbuffer = new RField;
  f_FCSI_BBIOLDO1V2_en_vcmbuffer->setInstName ("en_vcmbuffer");
  f_FCSI_BBIOLDO1V2_en_vcmbuffer->setLongName ("EN VCM BUFFER");
  f_FCSI_BBIOLDO1V2_en_vcmbuffer->setDescription ("Enable VCM buffer");
  f_FCSI_BBIOLDO1V2_en_vcmbuffer->setDataWidth (1);
  f_FCSI_BBIOLDO1V2_en_vcmbuffer->setResetVal ("1'b0");
  f_FCSI_BBIOLDO1V2_en_vcmbuffer->setAccProp (AccProp::RW);
  r_FCSI_BBIOLDO1V2->connectRField (f_FCSI_BBIOLDO1V2_en_vcmbuffer, 12);

  Attribute* a_FCSI_BBIOLDO1V2_en_vcmbuffer_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_BBIOLDO1V2_en_vcmbuffer_0_0->setInstName ("0");
  a_FCSI_BBIOLDO1V2_en_vcmbuffer_0_0->setLongName ("");
  a_FCSI_BBIOLDO1V2_en_vcmbuffer_0_0->setDescription ("");
  a_FCSI_BBIOLDO1V2_en_vcmbuffer_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_BBIOLDO1V2_en_vcmbuffer_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_BBIOLDO1V2_en_vcmbuffer->connectAttribute (a_FCSI_BBIOLDO1V2_en_vcmbuffer_0_0);

  RField* f_FCSI_BBIOLDO1V2_en_i_h_vcmbuffer = new RField;
  f_FCSI_BBIOLDO1V2_en_i_h_vcmbuffer->setInstName ("en_i_h_vcmbuffer");
  f_FCSI_BBIOLDO1V2_en_i_h_vcmbuffer->setLongName ("EN I H VCM BUFFER");
  f_FCSI_BBIOLDO1V2_en_i_h_vcmbuffer->setDescription ("Double current in output stage of VCM OpAmp");
  f_FCSI_BBIOLDO1V2_en_i_h_vcmbuffer->setDataWidth (1);
  f_FCSI_BBIOLDO1V2_en_i_h_vcmbuffer->setResetVal ("1'b0");
  f_FCSI_BBIOLDO1V2_en_i_h_vcmbuffer->setAccProp (AccProp::RW);
  r_FCSI_BBIOLDO1V2->connectRField (f_FCSI_BBIOLDO1V2_en_i_h_vcmbuffer, 13);

  Attribute* a_FCSI_BBIOLDO1V2_en_i_h_vcmbuffer_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_BBIOLDO1V2_en_i_h_vcmbuffer_0_0->setInstName ("0");
  a_FCSI_BBIOLDO1V2_en_i_h_vcmbuffer_0_0->setLongName ("");
  a_FCSI_BBIOLDO1V2_en_i_h_vcmbuffer_0_0->setDescription ("");
  a_FCSI_BBIOLDO1V2_en_i_h_vcmbuffer_0_0->addItem("1", "1'b1", "enable (default)");
  a_FCSI_BBIOLDO1V2_en_i_h_vcmbuffer_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_BBIOLDO1V2_en_i_h_vcmbuffer->connectAttribute (a_FCSI_BBIOLDO1V2_en_i_h_vcmbuffer_0_0);

  RField* f_FCSI_BBIOLDO1V2_ctl_vout_vcmbuffer = new RField;
  f_FCSI_BBIOLDO1V2_ctl_vout_vcmbuffer->setInstName ("ctl_vout_vcmbuffer");
  f_FCSI_BBIOLDO1V2_ctl_vout_vcmbuffer->setLongName ("CTL VOUT VCM BUFFER");
  f_FCSI_BBIOLDO1V2_ctl_vout_vcmbuffer->setDescription ("Control voltage output of VCM buffer");
  f_FCSI_BBIOLDO1V2_ctl_vout_vcmbuffer->setDataWidth (2);
  f_FCSI_BBIOLDO1V2_ctl_vout_vcmbuffer->setResetVal ("2'b00");
  f_FCSI_BBIOLDO1V2_ctl_vout_vcmbuffer->setAccProp (AccProp::RW);
  r_FCSI_BBIOLDO1V2->connectRField (f_FCSI_BBIOLDO1V2_ctl_vout_vcmbuffer, 14);

  Attribute* a_FCSI_BBIOLDO1V2_ctl_vout_vcmbuffer_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_BBIOLDO1V2_ctl_vout_vcmbuffer_0_0->setInstName ("0");
  a_FCSI_BBIOLDO1V2_ctl_vout_vcmbuffer_0_0->setLongName ("");
  a_FCSI_BBIOLDO1V2_ctl_vout_vcmbuffer_0_0->setDescription ("");
  a_FCSI_BBIOLDO1V2_ctl_vout_vcmbuffer_0_0->addItem("0", "2'b00", "0.55V");
  a_FCSI_BBIOLDO1V2_ctl_vout_vcmbuffer_0_0->addItem("1", "2'b01", "0.6V");
  a_FCSI_BBIOLDO1V2_ctl_vout_vcmbuffer_0_0->addItem("2", "2'b10", "0.45V");
  a_FCSI_BBIOLDO1V2_ctl_vout_vcmbuffer_0_0->addItem("3", "2'b11", "0.5V (default)");
  f_FCSI_BBIOLDO1V2_ctl_vout_vcmbuffer->connectAttribute (a_FCSI_BBIOLDO1V2_ctl_vout_vcmbuffer_0_0);

  Register* r_FCSI_TEMPSENS0 = new Register;
  r_FCSI_TEMPSENS0->setInstName ("TEMPSENS0");
  r_FCSI_TEMPSENS0->setLongName ("TEMP SENSOR 0");
  r_FCSI_TEMPSENS0->setDescription ("FCSI-LDO1V2");
  r_FCSI_TEMPSENS0->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_TEMPSENS0, 0x0000002C);

  RField* f_FCSI_TEMPSENS0_result = new RField;
  f_FCSI_TEMPSENS0_result->setInstName ("result");
  f_FCSI_TEMPSENS0_result->setLongName ("RESULT");
  f_FCSI_TEMPSENS0_result->setDescription ("Result of temperature sensor");
  f_FCSI_TEMPSENS0_result->setDataWidth (11);
  f_FCSI_TEMPSENS0_result->setResetVal ("11'b00000000000");
  f_FCSI_TEMPSENS0_result->setAccProp (AccProp::R);
  r_FCSI_TEMPSENS0->connectRField (f_FCSI_TEMPSENS0_result, 0);

  RField* f_FCSI_TEMPSENS0_vcal_rslt = new RField;
  f_FCSI_TEMPSENS0_vcal_rslt->setInstName ("vcal_rslt");
  f_FCSI_TEMPSENS0_vcal_rslt->setLongName ("VCAL RSLT");
  f_FCSI_TEMPSENS0_vcal_rslt->setDescription ("Result of voltage calibration");
  f_FCSI_TEMPSENS0_vcal_rslt->setDataWidth (5);
  f_FCSI_TEMPSENS0_vcal_rslt->setResetVal ("5'b00000");
  f_FCSI_TEMPSENS0_vcal_rslt->setAccProp (AccProp::R);
  r_FCSI_TEMPSENS0->connectRField (f_FCSI_TEMPSENS0_vcal_rslt, 11);

  Register* r_FCSI_TEMPSENS1 = new Register;
  r_FCSI_TEMPSENS1->setInstName ("TEMPSENS1");
  r_FCSI_TEMPSENS1->setLongName ("TEMP SENSOR 1");
  r_FCSI_TEMPSENS1->setDescription ("FCSI-LDO1V2");
  r_FCSI_TEMPSENS1->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_TEMPSENS1, 0x0000002D);

  RField* f_FCSI_TEMPSENS1_start = new RField;
  f_FCSI_TEMPSENS1_start->setInstName ("start");
  f_FCSI_TEMPSENS1_start->setLongName ("START");
  f_FCSI_TEMPSENS1_start->setDescription ("Start temperature sensor");
  f_FCSI_TEMPSENS1_start->setDataWidth (1);
  f_FCSI_TEMPSENS1_start->setResetVal ("1'b0");
  f_FCSI_TEMPSENS1_start->setAccProp (AccProp::RW);
  r_FCSI_TEMPSENS1->connectRField (f_FCSI_TEMPSENS1_start, 0);

  Attribute* a_FCSI_TEMPSENS1_start_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_TEMPSENS1_start_0_0->setInstName ("0");
  a_FCSI_TEMPSENS1_start_0_0->setLongName ("");
  a_FCSI_TEMPSENS1_start_0_0->setDescription ("");
  a_FCSI_TEMPSENS1_start_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_TEMPSENS1_start_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_TEMPSENS1_start->connectAttribute (a_FCSI_TEMPSENS1_start_0_0);

  RField* f_FCSI_TEMPSENS1_en_dts = new RField;
  f_FCSI_TEMPSENS1_en_dts->setInstName ("en_dts");
  f_FCSI_TEMPSENS1_en_dts->setLongName ("EN DTS");
  f_FCSI_TEMPSENS1_en_dts->setDescription ("Enable temperature sensor");
  f_FCSI_TEMPSENS1_en_dts->setDataWidth (1);
  f_FCSI_TEMPSENS1_en_dts->setResetVal ("1'b0");
  f_FCSI_TEMPSENS1_en_dts->setAccProp (AccProp::RW);
  r_FCSI_TEMPSENS1->connectRField (f_FCSI_TEMPSENS1_en_dts, 1);

  Attribute* a_FCSI_TEMPSENS1_en_dts_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_TEMPSENS1_en_dts_0_0->setInstName ("0");
  a_FCSI_TEMPSENS1_en_dts_0_0->setLongName ("");
  a_FCSI_TEMPSENS1_en_dts_0_0->setDescription ("");
  a_FCSI_TEMPSENS1_en_dts_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_TEMPSENS1_en_dts_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_TEMPSENS1_en_dts->connectAttribute (a_FCSI_TEMPSENS1_en_dts_0_0);

  RField* f_FCSI_TEMPSENS1_ready = new RField;
  f_FCSI_TEMPSENS1_ready->setInstName ("ready");
  f_FCSI_TEMPSENS1_ready->setLongName ("READY");
  f_FCSI_TEMPSENS1_ready->setDescription ("Result is ready");
  f_FCSI_TEMPSENS1_ready->setDataWidth (1);
  f_FCSI_TEMPSENS1_ready->setResetVal ("1'b0");
  f_FCSI_TEMPSENS1_ready->setAccProp (AccProp::R);
  r_FCSI_TEMPSENS1->connectRField (f_FCSI_TEMPSENS1_ready, 2);

  Attribute* a_FCSI_TEMPSENS1_ready_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_TEMPSENS1_ready_0_0->setInstName ("0");
  a_FCSI_TEMPSENS1_ready_0_0->setLongName ("");
  a_FCSI_TEMPSENS1_ready_0_0->setDescription ("");
  a_FCSI_TEMPSENS1_ready_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_TEMPSENS1_ready_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_TEMPSENS1_ready->connectAttribute (a_FCSI_TEMPSENS1_ready_0_0);

  RField* f_FCSI_TEMPSENS1_en_vcal = new RField;
  f_FCSI_TEMPSENS1_en_vcal->setInstName ("en_vcal");
  f_FCSI_TEMPSENS1_en_vcal->setLongName ("EN VCAL");
  f_FCSI_TEMPSENS1_en_vcal->setDescription ("Enable voltage calibration");
  f_FCSI_TEMPSENS1_en_vcal->setDataWidth (1);
  f_FCSI_TEMPSENS1_en_vcal->setResetVal ("1'b0");
  f_FCSI_TEMPSENS1_en_vcal->setAccProp (AccProp::RW);
  r_FCSI_TEMPSENS1->connectRField (f_FCSI_TEMPSENS1_en_vcal, 3);

  Attribute* a_FCSI_TEMPSENS1_en_vcal_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_TEMPSENS1_en_vcal_0_0->setInstName ("0");
  a_FCSI_TEMPSENS1_en_vcal_0_0->setLongName ("");
  a_FCSI_TEMPSENS1_en_vcal_0_0->setDescription ("");
  a_FCSI_TEMPSENS1_en_vcal_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_TEMPSENS1_en_vcal_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_TEMPSENS1_en_vcal->connectAttribute (a_FCSI_TEMPSENS1_en_vcal_0_0);

  RField* f_FCSI_TEMPSENS1_vcal_val = new RField;
  f_FCSI_TEMPSENS1_vcal_val->setInstName ("vcal_val");
  f_FCSI_TEMPSENS1_vcal_val->setLongName ("VCAL VAL");
  f_FCSI_TEMPSENS1_vcal_val->setDescription ("Data from result of voltage calibration output");
  f_FCSI_TEMPSENS1_vcal_val->setDataWidth (5);
  f_FCSI_TEMPSENS1_vcal_val->setResetVal ("5'b00000");
  f_FCSI_TEMPSENS1_vcal_val->setAccProp (AccProp::RW);
  r_FCSI_TEMPSENS1->connectRField (f_FCSI_TEMPSENS1_vcal_val, 4);

  Attribute* a_FCSI_TEMPSENS1_vcal_val_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_TEMPSENS1_vcal_val_0_0->setInstName ("0");
  a_FCSI_TEMPSENS1_vcal_val_0_0->setLongName ("");
  a_FCSI_TEMPSENS1_vcal_val_0_0->setDescription ("");
  a_FCSI_TEMPSENS1_vcal_val_0_0->addItem("1", "5'b00001", "enable");
  a_FCSI_TEMPSENS1_vcal_val_0_0->addItem("0", "5'b00000", "disable");
  f_FCSI_TEMPSENS1_vcal_val->connectAttribute (a_FCSI_TEMPSENS1_vcal_val_0_0);

  RField* f_FCSI_TEMPSENS1_vcal_rdy = new RField;
  f_FCSI_TEMPSENS1_vcal_rdy->setInstName ("vcal_rdy");
  f_FCSI_TEMPSENS1_vcal_rdy->setLongName ("VCAL RDY");
  f_FCSI_TEMPSENS1_vcal_rdy->setDescription ("Voltage calibration ready");
  f_FCSI_TEMPSENS1_vcal_rdy->setDataWidth (1);
  f_FCSI_TEMPSENS1_vcal_rdy->setResetVal ("1'b0");
  f_FCSI_TEMPSENS1_vcal_rdy->setAccProp (AccProp::R);
  r_FCSI_TEMPSENS1->connectRField (f_FCSI_TEMPSENS1_vcal_rdy, 9);

  Attribute* a_FCSI_TEMPSENS1_vcal_rdy_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_TEMPSENS1_vcal_rdy_0_0->setInstName ("0");
  a_FCSI_TEMPSENS1_vcal_rdy_0_0->setLongName ("");
  a_FCSI_TEMPSENS1_vcal_rdy_0_0->setDescription ("");
  a_FCSI_TEMPSENS1_vcal_rdy_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_TEMPSENS1_vcal_rdy_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_TEMPSENS1_vcal_rdy->connectAttribute (a_FCSI_TEMPSENS1_vcal_rdy_0_0);

  RField* f_FCSI_TEMPSENS1_flp_bgpcor = new RField;
  f_FCSI_TEMPSENS1_flp_bgpcor->setInstName ("flp_bgpcor");
  f_FCSI_TEMPSENS1_flp_bgpcor->setLongName ("FLP BGPCOR");
  f_FCSI_TEMPSENS1_flp_bgpcor->setDescription ("Flip bandgap xx");
  f_FCSI_TEMPSENS1_flp_bgpcor->setDataWidth (1);
  f_FCSI_TEMPSENS1_flp_bgpcor->setResetVal ("1'b0");
  f_FCSI_TEMPSENS1_flp_bgpcor->setAccProp (AccProp::RW);
  r_FCSI_TEMPSENS1->connectRField (f_FCSI_TEMPSENS1_flp_bgpcor, 10);

  Attribute* a_FCSI_TEMPSENS1_flp_bgpcor_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_TEMPSENS1_flp_bgpcor_0_0->setInstName ("0");
  a_FCSI_TEMPSENS1_flp_bgpcor_0_0->setLongName ("");
  a_FCSI_TEMPSENS1_flp_bgpcor_0_0->setDescription ("");
  a_FCSI_TEMPSENS1_flp_bgpcor_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_TEMPSENS1_flp_bgpcor_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_TEMPSENS1_flp_bgpcor->connectAttribute (a_FCSI_TEMPSENS1_flp_bgpcor_0_0);

  RField* f_FCSI_TEMPSENS1_flp_cmp_swap = new RField;
  f_FCSI_TEMPSENS1_flp_cmp_swap->setInstName ("flp_cmp_swap");
  f_FCSI_TEMPSENS1_flp_cmp_swap->setLongName ("FLP CMP SWAP");
  f_FCSI_TEMPSENS1_flp_cmp_swap->setDescription ("Flip comparator swapping");
  f_FCSI_TEMPSENS1_flp_cmp_swap->setDataWidth (1);
  f_FCSI_TEMPSENS1_flp_cmp_swap->setResetVal ("1'b0");
  f_FCSI_TEMPSENS1_flp_cmp_swap->setAccProp (AccProp::RW);
  r_FCSI_TEMPSENS1->connectRField (f_FCSI_TEMPSENS1_flp_cmp_swap, 11);

  Attribute* a_FCSI_TEMPSENS1_flp_cmp_swap_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_TEMPSENS1_flp_cmp_swap_0_0->setInstName ("0");
  a_FCSI_TEMPSENS1_flp_cmp_swap_0_0->setLongName ("");
  a_FCSI_TEMPSENS1_flp_cmp_swap_0_0->setDescription ("");
  a_FCSI_TEMPSENS1_flp_cmp_swap_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_TEMPSENS1_flp_cmp_swap_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_TEMPSENS1_flp_cmp_swap->connectAttribute (a_FCSI_TEMPSENS1_flp_cmp_swap_0_0);

  RField* f_FCSI_TEMPSENS1_flp_delcmp = new RField;
  f_FCSI_TEMPSENS1_flp_delcmp->setInstName ("flp_delcmp");
  f_FCSI_TEMPSENS1_flp_delcmp->setLongName ("FLP DELCMP");
  f_FCSI_TEMPSENS1_flp_delcmp->setDescription ("Flip delay comparator");
  f_FCSI_TEMPSENS1_flp_delcmp->setDataWidth (1);
  f_FCSI_TEMPSENS1_flp_delcmp->setResetVal ("1'b0");
  f_FCSI_TEMPSENS1_flp_delcmp->setAccProp (AccProp::RW);
  r_FCSI_TEMPSENS1->connectRField (f_FCSI_TEMPSENS1_flp_delcmp, 12);

  Attribute* a_FCSI_TEMPSENS1_flp_delcmp_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_TEMPSENS1_flp_delcmp_0_0->setInstName ("0");
  a_FCSI_TEMPSENS1_flp_delcmp_0_0->setLongName ("");
  a_FCSI_TEMPSENS1_flp_delcmp_0_0->setDescription ("");
  a_FCSI_TEMPSENS1_flp_delcmp_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_TEMPSENS1_flp_delcmp_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_TEMPSENS1_flp_delcmp->connectAttribute (a_FCSI_TEMPSENS1_flp_delcmp_0_0);

  RField* f_FCSI_TEMPSENS1_dis_swap = new RField;
  f_FCSI_TEMPSENS1_dis_swap->setInstName ("dis_swap");
  f_FCSI_TEMPSENS1_dis_swap->setLongName ("DIS SWAP");
  f_FCSI_TEMPSENS1_dis_swap->setDescription ("Disable Swapping");
  f_FCSI_TEMPSENS1_dis_swap->setDataWidth (1);
  f_FCSI_TEMPSENS1_dis_swap->setResetVal ("1'b0");
  f_FCSI_TEMPSENS1_dis_swap->setAccProp (AccProp::RW);
  r_FCSI_TEMPSENS1->connectRField (f_FCSI_TEMPSENS1_dis_swap, 13);

  Attribute* a_FCSI_TEMPSENS1_dis_swap_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_TEMPSENS1_dis_swap_0_0->setInstName ("0");
  a_FCSI_TEMPSENS1_dis_swap_0_0->setLongName ("");
  a_FCSI_TEMPSENS1_dis_swap_0_0->setDescription ("");
  a_FCSI_TEMPSENS1_dis_swap_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_TEMPSENS1_dis_swap_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_TEMPSENS1_dis_swap->connectAttribute (a_FCSI_TEMPSENS1_dis_swap_0_0);

  RField* f_FCSI_TEMPSENS1_des_ext = new RField;
  f_FCSI_TEMPSENS1_des_ext->setInstName ("des_ext");
  f_FCSI_TEMPSENS1_des_ext->setLongName ("DES EXT");
  f_FCSI_TEMPSENS1_des_ext->setDescription ("Design extension (spare)");
  f_FCSI_TEMPSENS1_des_ext->setDataWidth (1);
  f_FCSI_TEMPSENS1_des_ext->setResetVal ("1'b0");
  f_FCSI_TEMPSENS1_des_ext->setAccProp (AccProp::RW);
  r_FCSI_TEMPSENS1->connectRField (f_FCSI_TEMPSENS1_des_ext, 14);

  Attribute* a_FCSI_TEMPSENS1_des_ext_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_TEMPSENS1_des_ext_0_0->setInstName ("0");
  a_FCSI_TEMPSENS1_des_ext_0_0->setLongName ("");
  a_FCSI_TEMPSENS1_des_ext_0_0->setDescription ("");
  a_FCSI_TEMPSENS1_des_ext_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_TEMPSENS1_des_ext_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_TEMPSENS1_des_ext->connectAttribute (a_FCSI_TEMPSENS1_des_ext_0_0);

  Register* r_FCSI_TEMPSENS2 = new Register;
  r_FCSI_TEMPSENS2->setInstName ("TEMPSENS2");
  r_FCSI_TEMPSENS2->setLongName ("TEMP SENSOR 2");
  r_FCSI_TEMPSENS2->setDescription ("FCSI-LDO1V2");
  r_FCSI_TEMPSENS2->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_TEMPSENS2, 0x0000002E);

  RField* f_FCSI_TEMPSENS2_en_test_mod = new RField;
  f_FCSI_TEMPSENS2_en_test_mod->setInstName ("en_test_mod");
  f_FCSI_TEMPSENS2_en_test_mod->setLongName ("EN TEST MOD");
  f_FCSI_TEMPSENS2_en_test_mod->setDescription ("Enable test mode");
  f_FCSI_TEMPSENS2_en_test_mod->setDataWidth (1);
  f_FCSI_TEMPSENS2_en_test_mod->setResetVal ("1'b0");
  f_FCSI_TEMPSENS2_en_test_mod->setAccProp (AccProp::RW);
  r_FCSI_TEMPSENS2->connectRField (f_FCSI_TEMPSENS2_en_test_mod, 0);

  Attribute* a_FCSI_TEMPSENS2_en_test_mod_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_TEMPSENS2_en_test_mod_0_0->setInstName ("0");
  a_FCSI_TEMPSENS2_en_test_mod_0_0->setLongName ("");
  a_FCSI_TEMPSENS2_en_test_mod_0_0->setDescription ("");
  a_FCSI_TEMPSENS2_en_test_mod_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_TEMPSENS2_en_test_mod_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_TEMPSENS2_en_test_mod->connectAttribute (a_FCSI_TEMPSENS2_en_test_mod_0_0);

  RField* f_FCSI_TEMPSENS2_test_sel = new RField;
  f_FCSI_TEMPSENS2_test_sel->setInstName ("test_sel");
  f_FCSI_TEMPSENS2_test_sel->setLongName ("TEST SEL");
  f_FCSI_TEMPSENS2_test_sel->setDescription ("Test selection");
  f_FCSI_TEMPSENS2_test_sel->setDataWidth (14);
  f_FCSI_TEMPSENS2_test_sel->setResetVal ("14'b00000000000000");
  f_FCSI_TEMPSENS2_test_sel->setAccProp (AccProp::RW);
  r_FCSI_TEMPSENS2->connectRField (f_FCSI_TEMPSENS2_test_sel, 1);

  RField* f_FCSI_TEMPSENS2_test_dts = new RField;
  f_FCSI_TEMPSENS2_test_dts->setInstName ("test_dts");
  f_FCSI_TEMPSENS2_test_dts->setLongName ("TEST DTS");
  f_FCSI_TEMPSENS2_test_dts->setDescription ("Test output of the temperature sensor");
  f_FCSI_TEMPSENS2_test_dts->setDataWidth (1);
  f_FCSI_TEMPSENS2_test_dts->setResetVal ("1'b0");
  f_FCSI_TEMPSENS2_test_dts->setAccProp (AccProp::R);
  r_FCSI_TEMPSENS2->connectRField (f_FCSI_TEMPSENS2_test_dts, 15);

  Attribute* a_FCSI_TEMPSENS2_test_dts_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_TEMPSENS2_test_dts_0_0->setInstName ("0");
  a_FCSI_TEMPSENS2_test_dts_0_0->setLongName ("");
  a_FCSI_TEMPSENS2_test_dts_0_0->setDescription ("");
  a_FCSI_TEMPSENS2_test_dts_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_TEMPSENS2_test_dts_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_TEMPSENS2_test_dts->connectAttribute (a_FCSI_TEMPSENS2_test_dts_0_0);

  Register* r_FCSI_VERSION = new Register;
  r_FCSI_VERSION->setInstName ("VERSION");
  r_FCSI_VERSION->setLongName ("DESIGN STEP");
  r_FCSI_VERSION->setDescription ("FCSI-LDO1V2");
  r_FCSI_VERSION->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_VERSION, 0x0000002F);

  RField* f_FCSI_VERSION_Design_Step = new RField;
  f_FCSI_VERSION_Design_Step->setInstName ("Design_Step");
  f_FCSI_VERSION_Design_Step->setLongName ("DESIGN STEP");
  f_FCSI_VERSION_Design_Step->setDescription ("Design Step (e.g. A0 --> 0100000)");
  f_FCSI_VERSION_Design_Step->setDataWidth (7);
  f_FCSI_VERSION_Design_Step->setResetVal ("7'b0100000");
  f_FCSI_VERSION_Design_Step->setAccProp (AccProp::RW);
  r_FCSI_VERSION->connectRField (f_FCSI_VERSION_Design_Step, 0);

  Attribute* a_FCSI_VERSION_Design_Step_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_VERSION_Design_Step_0_0->setInstName ("0");
  a_FCSI_VERSION_Design_Step_0_0->setLongName ("");
  a_FCSI_VERSION_Design_Step_0_0->setDescription ("");
  a_FCSI_VERSION_Design_Step_0_0->addItem("0", "7'b0011111", "5 bits for number 0123");
  a_FCSI_VERSION_Design_Step_0_0->addItem("1", "7'b1100000", "2 bits for letter ABC");
  f_FCSI_VERSION_Design_Step->connectAttribute (a_FCSI_VERSION_Design_Step_0_0);

  Register* r_FCSI_EFUSE0 = new Register;
  r_FCSI_EFUSE0->setInstName ("EFUSE0");
  r_FCSI_EFUSE0->setLongName ("EFUSE0 CHIP ID0");
  r_FCSI_EFUSE0->setDescription ("UNIX time from the tester");
  r_FCSI_EFUSE0->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_EFUSE0, 0x00000030);

  RField* f_FCSI_EFUSE0_efuse0 = new RField;
  f_FCSI_EFUSE0_efuse0->setInstName ("efuse0");
  f_FCSI_EFUSE0_efuse0->setLongName ("EFUSE0 CHIP ID0");
  f_FCSI_EFUSE0_efuse0->setDescription ("UNIX time from the tester");
  f_FCSI_EFUSE0_efuse0->setDataWidth (16);
  f_FCSI_EFUSE0_efuse0->setResetVal ("16'b0000000000000000");
  f_FCSI_EFUSE0_efuse0->setAccProp (AccProp::R);
  r_FCSI_EFUSE0->connectRField (f_FCSI_EFUSE0_efuse0, 0);

  Register* r_FCSI_EFUSE1 = new Register;
  r_FCSI_EFUSE1->setInstName ("EFUSE1");
  r_FCSI_EFUSE1->setLongName ("EFUSE1 TESTER, HANDLER TEMP., BGP ");
  r_FCSI_EFUSE1->setDescription ("EFUSE TESTER SITE + PROGRAMM version + LIMIT version + HANDLER TEMP + BGP ");
  r_FCSI_EFUSE1->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_EFUSE1, 0x00000031);

  RField* f_FCSI_EFUSE1_testersite = new RField;
  f_FCSI_EFUSE1_testersite->setInstName ("testersite");
  f_FCSI_EFUSE1_testersite->setLongName ("TESTERSITE");
  f_FCSI_EFUSE1_testersite->setDescription ("Tester site");
  f_FCSI_EFUSE1_testersite->setDataWidth (1);
  f_FCSI_EFUSE1_testersite->setResetVal ("1'b0");
  f_FCSI_EFUSE1_testersite->setAccProp (AccProp::R);
  r_FCSI_EFUSE1->connectRField (f_FCSI_EFUSE1_testersite, 0);

  Attribute* a_FCSI_EFUSE1_testersite_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_EFUSE1_testersite_0_0->setInstName ("0");
  a_FCSI_EFUSE1_testersite_0_0->setLongName ("");
  a_FCSI_EFUSE1_testersite_0_0->setDescription ("");
  a_FCSI_EFUSE1_testersite_0_0->addItem("0", "1'b0", "Socket 1");
  a_FCSI_EFUSE1_testersite_0_0->addItem("1", "1'b1", "Socket 2");
  f_FCSI_EFUSE1_testersite->connectAttribute (a_FCSI_EFUSE1_testersite_0_0);

  RField* f_FCSI_EFUSE1_limitversion = new RField;
  f_FCSI_EFUSE1_limitversion->setInstName ("limitversion");
  f_FCSI_EFUSE1_limitversion->setLongName ("LIMIT VERSION");
  f_FCSI_EFUSE1_limitversion->setDescription ("Limit Version");
  f_FCSI_EFUSE1_limitversion->setDataWidth (3);
  f_FCSI_EFUSE1_limitversion->setResetVal ("3'b000");
  f_FCSI_EFUSE1_limitversion->setAccProp (AccProp::R);
  r_FCSI_EFUSE1->connectRField (f_FCSI_EFUSE1_limitversion, 1);

  Attribute* a_FCSI_EFUSE1_limitversion_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_EFUSE1_limitversion_0_0->setInstName ("0");
  a_FCSI_EFUSE1_limitversion_0_0->setLongName ("");
  a_FCSI_EFUSE1_limitversion_0_0->setDescription ("");
  a_FCSI_EFUSE1_limitversion_0_0->addItem("0", "3'b000", "Version 1");
  a_FCSI_EFUSE1_limitversion_0_0->addItem("1", "3'b001", "Version 2");
  a_FCSI_EFUSE1_limitversion_0_0->addItem("2", "3'b010", "Version 3");
  a_FCSI_EFUSE1_limitversion_0_0->addItem("3", "3'b011", "Version 4");
  a_FCSI_EFUSE1_limitversion_0_0->addItem("4", "3'b100", "Version 5");
  a_FCSI_EFUSE1_limitversion_0_0->addItem("5", "3'b101", "Version 6");
  a_FCSI_EFUSE1_limitversion_0_0->addItem("6", "3'b110", "Version 7");
  a_FCSI_EFUSE1_limitversion_0_0->addItem("7", "3'b111", "Version 8");
  f_FCSI_EFUSE1_limitversion->connectAttribute (a_FCSI_EFUSE1_limitversion_0_0);

  RField* f_FCSI_EFUSE1_programmversion = new RField;
  f_FCSI_EFUSE1_programmversion->setInstName ("programmversion");
  f_FCSI_EFUSE1_programmversion->setLongName ("PROGRAMM VERSION");
  f_FCSI_EFUSE1_programmversion->setDescription ("Programm Version");
  f_FCSI_EFUSE1_programmversion->setDataWidth (3);
  f_FCSI_EFUSE1_programmversion->setResetVal ("3'b000");
  f_FCSI_EFUSE1_programmversion->setAccProp (AccProp::R);
  r_FCSI_EFUSE1->connectRField (f_FCSI_EFUSE1_programmversion, 4);

  Attribute* a_FCSI_EFUSE1_programmversion_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_EFUSE1_programmversion_0_0->setInstName ("0");
  a_FCSI_EFUSE1_programmversion_0_0->setLongName ("");
  a_FCSI_EFUSE1_programmversion_0_0->setDescription ("");
  a_FCSI_EFUSE1_programmversion_0_0->addItem("0", "3'b000", "Version 1");
  a_FCSI_EFUSE1_programmversion_0_0->addItem("1", "3'b001", "Version 2");
  a_FCSI_EFUSE1_programmversion_0_0->addItem("2", "3'b010", "Version 3");
  a_FCSI_EFUSE1_programmversion_0_0->addItem("3", "3'b011", "Version 4");
  a_FCSI_EFUSE1_programmversion_0_0->addItem("4", "3'b100", "Version 5");
  a_FCSI_EFUSE1_programmversion_0_0->addItem("5", "3'b101", "Version 6");
  a_FCSI_EFUSE1_programmversion_0_0->addItem("6", "3'b110", "Version 7");
  a_FCSI_EFUSE1_programmversion_0_0->addItem("7", "3'b111", "Version 8");
  f_FCSI_EFUSE1_programmversion->connectAttribute (a_FCSI_EFUSE1_programmversion_0_0);

  RField* f_FCSI_EFUSE1_handlertemp = new RField;
  f_FCSI_EFUSE1_handlertemp->setInstName ("handlertemp");
  f_FCSI_EFUSE1_handlertemp->setLongName ("HANDLER TEMPERATURE");
  f_FCSI_EFUSE1_handlertemp->setDescription ("Handler Temperature");
  f_FCSI_EFUSE1_handlertemp->setDataWidth (5);
  f_FCSI_EFUSE1_handlertemp->setResetVal ("5'b00000");
  f_FCSI_EFUSE1_handlertemp->setAccProp (AccProp::R);
  r_FCSI_EFUSE1->connectRField (f_FCSI_EFUSE1_handlertemp, 7);

  Attribute* a_FCSI_EFUSE1_handlertemp_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_EFUSE1_handlertemp_0_0->setInstName ("0");
  a_FCSI_EFUSE1_handlertemp_0_0->setLongName ("");
  a_FCSI_EFUSE1_handlertemp_0_0->setDescription ("");
  a_FCSI_EFUSE1_handlertemp_0_0->addItem("0", "5'b00000", "Temperature 1");
  a_FCSI_EFUSE1_handlertemp_0_0->addItem("1", "5'b00001", "Temperature 2");
  a_FCSI_EFUSE1_handlertemp_0_0->addItem("2", "5'b00010", "Temperature 3");
  a_FCSI_EFUSE1_handlertemp_0_0->addItem("3", "5'b00011", "Temperature 4");
  a_FCSI_EFUSE1_handlertemp_0_0->addItem("4", "5'b00100", "Temperature 5");
  a_FCSI_EFUSE1_handlertemp_0_0->addItem("5", "5'b00101", "Temperature 6");
  a_FCSI_EFUSE1_handlertemp_0_0->addItem("6", "5'b00110", "Temperature 7");
  a_FCSI_EFUSE1_handlertemp_0_0->addItem("7", "5'b00111", "Temperature 8");
  a_FCSI_EFUSE1_handlertemp_0_0->addItem("8", "5'b01000", "Temperature 1");
  a_FCSI_EFUSE1_handlertemp_0_0->addItem("9", "5'b01001", "Temperature 2");
  a_FCSI_EFUSE1_handlertemp_0_0->addItem("10", "5'b01010", "Temperature 3");
  a_FCSI_EFUSE1_handlertemp_0_0->addItem("11", "5'b01011", "Temperature 4");
  a_FCSI_EFUSE1_handlertemp_0_0->addItem("12", "5'b01100", "Temperature 5");
  a_FCSI_EFUSE1_handlertemp_0_0->addItem("13", "5'b01101", "Temperature 6");
  a_FCSI_EFUSE1_handlertemp_0_0->addItem("14", "5'b01110", "Temperature 7");
  a_FCSI_EFUSE1_handlertemp_0_0->addItem("15", "5'b01111", "Temperature 8");
  a_FCSI_EFUSE1_handlertemp_0_0->addItem("16", "5'b10000", "Temperature 1");
  a_FCSI_EFUSE1_handlertemp_0_0->addItem("17", "5'b10001", "Temperature 2");
  a_FCSI_EFUSE1_handlertemp_0_0->addItem("18", "5'b10010", "Temperature 3");
  a_FCSI_EFUSE1_handlertemp_0_0->addItem("19", "5'b10011", "Temperature 4");
  a_FCSI_EFUSE1_handlertemp_0_0->addItem("20", "5'b10100", "Temperature 5");
  a_FCSI_EFUSE1_handlertemp_0_0->addItem("21", "5'b10101", "Temperature 6");
  a_FCSI_EFUSE1_handlertemp_0_0->addItem("22", "5'b10110", "Temperature 7");
  a_FCSI_EFUSE1_handlertemp_0_0->addItem("23", "5'b10111", "Temperature 8");
  a_FCSI_EFUSE1_handlertemp_0_0->addItem("24", "5'b11000", "Temperature 1");
  a_FCSI_EFUSE1_handlertemp_0_0->addItem("25", "5'b11001", "Temperature 2");
  a_FCSI_EFUSE1_handlertemp_0_0->addItem("26", "5'b11010", "Temperature 3");
  a_FCSI_EFUSE1_handlertemp_0_0->addItem("27", "5'b11011", "Temperature 4");
  a_FCSI_EFUSE1_handlertemp_0_0->addItem("28", "5'b11100", "Temperature 5");
  a_FCSI_EFUSE1_handlertemp_0_0->addItem("29", "5'b11101", "Temperature 6");
  a_FCSI_EFUSE1_handlertemp_0_0->addItem("30", "5'b11110", "Temperature 7");
  a_FCSI_EFUSE1_handlertemp_0_0->addItem("31", "5'b11111", "Temperature 8");
  f_FCSI_EFUSE1_handlertemp->connectAttribute (a_FCSI_EFUSE1_handlertemp_0_0);

  RField* f_FCSI_EFUSE1_ctl_trim_bgp = new RField;
  f_FCSI_EFUSE1_ctl_trim_bgp->setInstName ("ctl_trim_bgp");
  f_FCSI_EFUSE1_ctl_trim_bgp->setLongName ("CTL TRIM BGP");
  f_FCSI_EFUSE1_ctl_trim_bgp->setDescription ("Trimming bandgap");
  f_FCSI_EFUSE1_ctl_trim_bgp->setDataWidth (4);
  f_FCSI_EFUSE1_ctl_trim_bgp->setResetVal ("4'b0000");
  f_FCSI_EFUSE1_ctl_trim_bgp->setAccProp (AccProp::R);
  r_FCSI_EFUSE1->connectRField (f_FCSI_EFUSE1_ctl_trim_bgp, 12);

  Attribute* a_FCSI_EFUSE1_ctl_trim_bgp_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_EFUSE1_ctl_trim_bgp_0_0->setInstName ("0");
  a_FCSI_EFUSE1_ctl_trim_bgp_0_0->setLongName ("");
  a_FCSI_EFUSE1_ctl_trim_bgp_0_0->setDescription ("");
  a_FCSI_EFUSE1_ctl_trim_bgp_0_0->addItem("0", "4'b0111", "+7%");
  a_FCSI_EFUSE1_ctl_trim_bgp_0_0->addItem("1", "4'b0110", "+6%");
  a_FCSI_EFUSE1_ctl_trim_bgp_0_0->addItem("2", "4'b0101", "+5%");
  a_FCSI_EFUSE1_ctl_trim_bgp_0_0->addItem("3", "4'b0100", "+4%");
  a_FCSI_EFUSE1_ctl_trim_bgp_0_0->addItem("4", "4'b0011", "+3%");
  a_FCSI_EFUSE1_ctl_trim_bgp_0_0->addItem("5", "4'b0010", "+2%");
  a_FCSI_EFUSE1_ctl_trim_bgp_0_0->addItem("6", "4'b0001", "+1%");
  a_FCSI_EFUSE1_ctl_trim_bgp_0_0->addItem("7", "4'b0000", "1.22V");
  a_FCSI_EFUSE1_ctl_trim_bgp_0_0->addItem("8", "4'b1111", "-1%");
  a_FCSI_EFUSE1_ctl_trim_bgp_0_0->addItem("9", "4'b1110", "-2%");
  a_FCSI_EFUSE1_ctl_trim_bgp_0_0->addItem("10", "4'b1101", "-3%");
  a_FCSI_EFUSE1_ctl_trim_bgp_0_0->addItem("11", "4'b1100", "-4%");
  a_FCSI_EFUSE1_ctl_trim_bgp_0_0->addItem("12", "4'b1011", "-5%");
  a_FCSI_EFUSE1_ctl_trim_bgp_0_0->addItem("13", "4'b1010", "-6%");
  a_FCSI_EFUSE1_ctl_trim_bgp_0_0->addItem("14", "4'b1001", "-7%");
  a_FCSI_EFUSE1_ctl_trim_bgp_0_0->addItem("15", "4'b1000", "-8%");
  f_FCSI_EFUSE1_ctl_trim_bgp->connectAttribute (a_FCSI_EFUSE1_ctl_trim_bgp_0_0);

  Register* r_FCSI_EFUSE2 = new Register;
  r_FCSI_EFUSE2->setInstName ("EFUSE2");
  r_FCSI_EFUSE2->setLongName ("EFUSE2 1V2LDOs ANT0");
  r_FCSI_EFUSE2->setDescription ("1V2LDOs of ANTENNA0");
  r_FCSI_EFUSE2->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_EFUSE2, 0x00000032);

  RField* f_FCSI_EFUSE2_hbldo1v2 = new RField;
  f_FCSI_EFUSE2_hbldo1v2->setInstName ("hbldo1v2");
  f_FCSI_EFUSE2_hbldo1v2->setLongName ("HBLDO1V2");
  f_FCSI_EFUSE2_hbldo1v2->setDescription ("Output voltage of 1V2HBLDO of ANTENNA0");
  f_FCSI_EFUSE2_hbldo1v2->setDataWidth (4);
  f_FCSI_EFUSE2_hbldo1v2->setResetVal ("4'b0000");
  f_FCSI_EFUSE2_hbldo1v2->setAccProp (AccProp::R);
  r_FCSI_EFUSE2->connectRField (f_FCSI_EFUSE2_hbldo1v2, 0);

  Attribute* a_FCSI_EFUSE2_hbldo1v2_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_EFUSE2_hbldo1v2_0_0->setInstName ("0");
  a_FCSI_EFUSE2_hbldo1v2_0_0->setLongName ("");
  a_FCSI_EFUSE2_hbldo1v2_0_0->setDescription ("");
  a_FCSI_EFUSE2_hbldo1v2_0_0->addItem("15", "4'b1111", "1.37V");
  a_FCSI_EFUSE2_hbldo1v2_0_0->addItem("14", "4'b1110", "1.36V");
  a_FCSI_EFUSE2_hbldo1v2_0_0->addItem("13", "4'b1101", "1.35V");
  a_FCSI_EFUSE2_hbldo1v2_0_0->addItem("12", "4'b1100", "1.34V");
  a_FCSI_EFUSE2_hbldo1v2_0_0->addItem("11", "4'b1011", "1.33V");
  a_FCSI_EFUSE2_hbldo1v2_0_0->addItem("10", "4'b1010", "1.32V");
  a_FCSI_EFUSE2_hbldo1v2_0_0->addItem("9", "4'b1001", "1.31V");
  a_FCSI_EFUSE2_hbldo1v2_0_0->addItem("8", "4'b1000", "1.30V");
  a_FCSI_EFUSE2_hbldo1v2_0_0->addItem("7", "4'b0111", "1.29V");
  a_FCSI_EFUSE2_hbldo1v2_0_0->addItem("6", "4'b0110", "1.28V");
  a_FCSI_EFUSE2_hbldo1v2_0_0->addItem("5", "4'b0101", "1.27V");
  a_FCSI_EFUSE2_hbldo1v2_0_0->addItem("4", "4'b0100", "1.26V");
  a_FCSI_EFUSE2_hbldo1v2_0_0->addItem("3", "4'b0011", "1.25V");
  a_FCSI_EFUSE2_hbldo1v2_0_0->addItem("2", "4'b0010", "1.24V");
  a_FCSI_EFUSE2_hbldo1v2_0_0->addItem("1", "4'b0001", "1.23V");
  a_FCSI_EFUSE2_hbldo1v2_0_0->addItem("0", "4'b0000", "1.22V");
  f_FCSI_EFUSE2_hbldo1v2->connectAttribute (a_FCSI_EFUSE2_hbldo1v2_0_0);

  RField* f_FCSI_EFUSE2_lbldo1v2 = new RField;
  f_FCSI_EFUSE2_lbldo1v2->setInstName ("lbldo1v2");
  f_FCSI_EFUSE2_lbldo1v2->setLongName ("LBLDO1V2");
  f_FCSI_EFUSE2_lbldo1v2->setDescription ("Output voltage of 1V2LBLDO of ANTENNA0");
  f_FCSI_EFUSE2_lbldo1v2->setDataWidth (4);
  f_FCSI_EFUSE2_lbldo1v2->setResetVal ("4'b0000");
  f_FCSI_EFUSE2_lbldo1v2->setAccProp (AccProp::R);
  r_FCSI_EFUSE2->connectRField (f_FCSI_EFUSE2_lbldo1v2, 4);

  Attribute* a_FCSI_EFUSE2_lbldo1v2_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_EFUSE2_lbldo1v2_0_0->setInstName ("0");
  a_FCSI_EFUSE2_lbldo1v2_0_0->setLongName ("");
  a_FCSI_EFUSE2_lbldo1v2_0_0->setDescription ("");
  a_FCSI_EFUSE2_lbldo1v2_0_0->addItem("15", "4'b1111", "1.37V");
  a_FCSI_EFUSE2_lbldo1v2_0_0->addItem("14", "4'b1110", "1.36V");
  a_FCSI_EFUSE2_lbldo1v2_0_0->addItem("13", "4'b1101", "1.35V");
  a_FCSI_EFUSE2_lbldo1v2_0_0->addItem("12", "4'b1100", "1.34V");
  a_FCSI_EFUSE2_lbldo1v2_0_0->addItem("11", "4'b1011", "1.33V");
  a_FCSI_EFUSE2_lbldo1v2_0_0->addItem("10", "4'b1010", "1.32V");
  a_FCSI_EFUSE2_lbldo1v2_0_0->addItem("9", "4'b1001", "1.31V");
  a_FCSI_EFUSE2_lbldo1v2_0_0->addItem("8", "4'b1000", "1.30V");
  a_FCSI_EFUSE2_lbldo1v2_0_0->addItem("7", "4'b0111", "1.29V");
  a_FCSI_EFUSE2_lbldo1v2_0_0->addItem("6", "4'b0110", "1.28V");
  a_FCSI_EFUSE2_lbldo1v2_0_0->addItem("5", "4'b0101", "1.27V");
  a_FCSI_EFUSE2_lbldo1v2_0_0->addItem("4", "4'b0100", "1.26V");
  a_FCSI_EFUSE2_lbldo1v2_0_0->addItem("3", "4'b0011", "1.25V");
  a_FCSI_EFUSE2_lbldo1v2_0_0->addItem("2", "4'b0010", "1.24V");
  a_FCSI_EFUSE2_lbldo1v2_0_0->addItem("1", "4'b0001", "1.23V");
  a_FCSI_EFUSE2_lbldo1v2_0_0->addItem("0", "4'b0000", "1.22V");
  f_FCSI_EFUSE2_lbldo1v2->connectAttribute (a_FCSI_EFUSE2_lbldo1v2_0_0);

  RField* f_FCSI_EFUSE2_rxldo1v2 = new RField;
  f_FCSI_EFUSE2_rxldo1v2->setInstName ("rxldo1v2");
  f_FCSI_EFUSE2_rxldo1v2->setLongName ("RXLDO1V2");
  f_FCSI_EFUSE2_rxldo1v2->setDescription ("Output voltage of 1V2RXLDO of ANTENNA0");
  f_FCSI_EFUSE2_rxldo1v2->setDataWidth (4);
  f_FCSI_EFUSE2_rxldo1v2->setResetVal ("4'b0000");
  f_FCSI_EFUSE2_rxldo1v2->setAccProp (AccProp::R);
  r_FCSI_EFUSE2->connectRField (f_FCSI_EFUSE2_rxldo1v2, 8);

  Attribute* a_FCSI_EFUSE2_rxldo1v2_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_EFUSE2_rxldo1v2_0_0->setInstName ("0");
  a_FCSI_EFUSE2_rxldo1v2_0_0->setLongName ("");
  a_FCSI_EFUSE2_rxldo1v2_0_0->setDescription ("");
  a_FCSI_EFUSE2_rxldo1v2_0_0->addItem("15", "4'b1111", "1.37V");
  a_FCSI_EFUSE2_rxldo1v2_0_0->addItem("14", "4'b1110", "1.36V");
  a_FCSI_EFUSE2_rxldo1v2_0_0->addItem("13", "4'b1101", "1.35V");
  a_FCSI_EFUSE2_rxldo1v2_0_0->addItem("12", "4'b1100", "1.34V");
  a_FCSI_EFUSE2_rxldo1v2_0_0->addItem("11", "4'b1011", "1.33V");
  a_FCSI_EFUSE2_rxldo1v2_0_0->addItem("10", "4'b1010", "1.32V");
  a_FCSI_EFUSE2_rxldo1v2_0_0->addItem("9", "4'b1001", "1.31V");
  a_FCSI_EFUSE2_rxldo1v2_0_0->addItem("8", "4'b1000", "1.30V");
  a_FCSI_EFUSE2_rxldo1v2_0_0->addItem("7", "4'b0111", "1.29V");
  a_FCSI_EFUSE2_rxldo1v2_0_0->addItem("6", "4'b0110", "1.28V");
  a_FCSI_EFUSE2_rxldo1v2_0_0->addItem("5", "4'b0101", "1.27V");
  a_FCSI_EFUSE2_rxldo1v2_0_0->addItem("4", "4'b0100", "1.26V");
  a_FCSI_EFUSE2_rxldo1v2_0_0->addItem("3", "4'b0011", "1.25V");
  a_FCSI_EFUSE2_rxldo1v2_0_0->addItem("2", "4'b0010", "1.24V");
  a_FCSI_EFUSE2_rxldo1v2_0_0->addItem("1", "4'b0001", "1.23V");
  a_FCSI_EFUSE2_rxldo1v2_0_0->addItem("0", "4'b0000", "1.22V");
  f_FCSI_EFUSE2_rxldo1v2->connectAttribute (a_FCSI_EFUSE2_rxldo1v2_0_0);

  RField* f_FCSI_EFUSE2_bbldo1v2 = new RField;
  f_FCSI_EFUSE2_bbldo1v2->setInstName ("bbldo1v2");
  f_FCSI_EFUSE2_bbldo1v2->setLongName ("BBLDO1V2");
  f_FCSI_EFUSE2_bbldo1v2->setDescription ("Output voltage of 1V2BBLDO of ANTENNA0");
  f_FCSI_EFUSE2_bbldo1v2->setDataWidth (4);
  f_FCSI_EFUSE2_bbldo1v2->setResetVal ("4'b0000");
  f_FCSI_EFUSE2_bbldo1v2->setAccProp (AccProp::R);
  r_FCSI_EFUSE2->connectRField (f_FCSI_EFUSE2_bbldo1v2, 12);

  Attribute* a_FCSI_EFUSE2_bbldo1v2_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_EFUSE2_bbldo1v2_0_0->setInstName ("0");
  a_FCSI_EFUSE2_bbldo1v2_0_0->setLongName ("");
  a_FCSI_EFUSE2_bbldo1v2_0_0->setDescription ("");
  a_FCSI_EFUSE2_bbldo1v2_0_0->addItem("15", "4'b1111", "1.37V");
  a_FCSI_EFUSE2_bbldo1v2_0_0->addItem("14", "4'b1110", "1.36V");
  a_FCSI_EFUSE2_bbldo1v2_0_0->addItem("13", "4'b1101", "1.35V");
  a_FCSI_EFUSE2_bbldo1v2_0_0->addItem("12", "4'b1100", "1.34V");
  a_FCSI_EFUSE2_bbldo1v2_0_0->addItem("11", "4'b1011", "1.33V");
  a_FCSI_EFUSE2_bbldo1v2_0_0->addItem("10", "4'b1010", "1.32V");
  a_FCSI_EFUSE2_bbldo1v2_0_0->addItem("9", "4'b1001", "1.31V");
  a_FCSI_EFUSE2_bbldo1v2_0_0->addItem("8", "4'b1000", "1.30V");
  a_FCSI_EFUSE2_bbldo1v2_0_0->addItem("7", "4'b0111", "1.29V");
  a_FCSI_EFUSE2_bbldo1v2_0_0->addItem("6", "4'b0110", "1.28V");
  a_FCSI_EFUSE2_bbldo1v2_0_0->addItem("5", "4'b0101", "1.27V");
  a_FCSI_EFUSE2_bbldo1v2_0_0->addItem("4", "4'b0100", "1.26V");
  a_FCSI_EFUSE2_bbldo1v2_0_0->addItem("3", "4'b0011", "1.25V");
  a_FCSI_EFUSE2_bbldo1v2_0_0->addItem("2", "4'b0010", "1.24V");
  a_FCSI_EFUSE2_bbldo1v2_0_0->addItem("1", "4'b0001", "1.23V");
  a_FCSI_EFUSE2_bbldo1v2_0_0->addItem("0", "4'b0000", "1.22V");
  f_FCSI_EFUSE2_bbldo1v2->connectAttribute (a_FCSI_EFUSE2_bbldo1v2_0_0);

  Register* r_FCSI_EFUSE3 = new Register;
  r_FCSI_EFUSE3->setInstName ("EFUSE3");
  r_FCSI_EFUSE3->setLongName ("EFUSE3 1V2LDOs ANT1");
  r_FCSI_EFUSE3->setDescription ("1V2LDOs of ANTENNA1");
  r_FCSI_EFUSE3->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_EFUSE3, 0x00000033);

  RField* f_FCSI_EFUSE3_hbldo1v2 = new RField;
  f_FCSI_EFUSE3_hbldo1v2->setInstName ("hbldo1v2");
  f_FCSI_EFUSE3_hbldo1v2->setLongName ("HBLDO1V2");
  f_FCSI_EFUSE3_hbldo1v2->setDescription ("Output voltage of 1V2HBLDO of ANTENNA1");
  f_FCSI_EFUSE3_hbldo1v2->setDataWidth (4);
  f_FCSI_EFUSE3_hbldo1v2->setResetVal ("4'b0000");
  f_FCSI_EFUSE3_hbldo1v2->setAccProp (AccProp::R);
  r_FCSI_EFUSE3->connectRField (f_FCSI_EFUSE3_hbldo1v2, 0);

  Attribute* a_FCSI_EFUSE3_hbldo1v2_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_EFUSE3_hbldo1v2_0_0->setInstName ("0");
  a_FCSI_EFUSE3_hbldo1v2_0_0->setLongName ("");
  a_FCSI_EFUSE3_hbldo1v2_0_0->setDescription ("");
  a_FCSI_EFUSE3_hbldo1v2_0_0->addItem("15", "4'b1111", "1.37V");
  a_FCSI_EFUSE3_hbldo1v2_0_0->addItem("14", "4'b1110", "1.36V");
  a_FCSI_EFUSE3_hbldo1v2_0_0->addItem("13", "4'b1101", "1.35V");
  a_FCSI_EFUSE3_hbldo1v2_0_0->addItem("12", "4'b1100", "1.34V");
  a_FCSI_EFUSE3_hbldo1v2_0_0->addItem("11", "4'b1011", "1.33V");
  a_FCSI_EFUSE3_hbldo1v2_0_0->addItem("10", "4'b1010", "1.32V");
  a_FCSI_EFUSE3_hbldo1v2_0_0->addItem("9", "4'b1001", "1.31V");
  a_FCSI_EFUSE3_hbldo1v2_0_0->addItem("8", "4'b1000", "1.30V");
  a_FCSI_EFUSE3_hbldo1v2_0_0->addItem("7", "4'b0111", "1.29V");
  a_FCSI_EFUSE3_hbldo1v2_0_0->addItem("6", "4'b0110", "1.28V");
  a_FCSI_EFUSE3_hbldo1v2_0_0->addItem("5", "4'b0101", "1.27V");
  a_FCSI_EFUSE3_hbldo1v2_0_0->addItem("4", "4'b0100", "1.26V");
  a_FCSI_EFUSE3_hbldo1v2_0_0->addItem("3", "4'b0011", "1.25V");
  a_FCSI_EFUSE3_hbldo1v2_0_0->addItem("2", "4'b0010", "1.24V");
  a_FCSI_EFUSE3_hbldo1v2_0_0->addItem("1", "4'b0001", "1.23V");
  a_FCSI_EFUSE3_hbldo1v2_0_0->addItem("0", "4'b0000", "1.22V");
  f_FCSI_EFUSE3_hbldo1v2->connectAttribute (a_FCSI_EFUSE3_hbldo1v2_0_0);

  RField* f_FCSI_EFUSE3_lbldo1v2 = new RField;
  f_FCSI_EFUSE3_lbldo1v2->setInstName ("lbldo1v2");
  f_FCSI_EFUSE3_lbldo1v2->setLongName ("LBLDO1V2");
  f_FCSI_EFUSE3_lbldo1v2->setDescription ("Output voltage of 1V2LBLDO of ANTENNA1");
  f_FCSI_EFUSE3_lbldo1v2->setDataWidth (4);
  f_FCSI_EFUSE3_lbldo1v2->setResetVal ("4'b0000");
  f_FCSI_EFUSE3_lbldo1v2->setAccProp (AccProp::R);
  r_FCSI_EFUSE3->connectRField (f_FCSI_EFUSE3_lbldo1v2, 4);

  Attribute* a_FCSI_EFUSE3_lbldo1v2_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_EFUSE3_lbldo1v2_0_0->setInstName ("0");
  a_FCSI_EFUSE3_lbldo1v2_0_0->setLongName ("");
  a_FCSI_EFUSE3_lbldo1v2_0_0->setDescription ("");
  a_FCSI_EFUSE3_lbldo1v2_0_0->addItem("15", "4'b1111", "1.37V");
  a_FCSI_EFUSE3_lbldo1v2_0_0->addItem("14", "4'b1110", "1.36V");
  a_FCSI_EFUSE3_lbldo1v2_0_0->addItem("13", "4'b1101", "1.35V");
  a_FCSI_EFUSE3_lbldo1v2_0_0->addItem("12", "4'b1100", "1.34V");
  a_FCSI_EFUSE3_lbldo1v2_0_0->addItem("11", "4'b1011", "1.33V");
  a_FCSI_EFUSE3_lbldo1v2_0_0->addItem("10", "4'b1010", "1.32V");
  a_FCSI_EFUSE3_lbldo1v2_0_0->addItem("9", "4'b1001", "1.31V");
  a_FCSI_EFUSE3_lbldo1v2_0_0->addItem("8", "4'b1000", "1.30V");
  a_FCSI_EFUSE3_lbldo1v2_0_0->addItem("7", "4'b0111", "1.29V");
  a_FCSI_EFUSE3_lbldo1v2_0_0->addItem("6", "4'b0110", "1.28V");
  a_FCSI_EFUSE3_lbldo1v2_0_0->addItem("5", "4'b0101", "1.27V");
  a_FCSI_EFUSE3_lbldo1v2_0_0->addItem("4", "4'b0100", "1.26V");
  a_FCSI_EFUSE3_lbldo1v2_0_0->addItem("3", "4'b0011", "1.25V");
  a_FCSI_EFUSE3_lbldo1v2_0_0->addItem("2", "4'b0010", "1.24V");
  a_FCSI_EFUSE3_lbldo1v2_0_0->addItem("1", "4'b0001", "1.23V");
  a_FCSI_EFUSE3_lbldo1v2_0_0->addItem("0", "4'b0000", "1.22V");
  f_FCSI_EFUSE3_lbldo1v2->connectAttribute (a_FCSI_EFUSE3_lbldo1v2_0_0);

  RField* f_FCSI_EFUSE3_rxldo1v2 = new RField;
  f_FCSI_EFUSE3_rxldo1v2->setInstName ("rxldo1v2");
  f_FCSI_EFUSE3_rxldo1v2->setLongName ("RXLDO1V2");
  f_FCSI_EFUSE3_rxldo1v2->setDescription ("Output voltage of 1V2RXLDO of ANTENNA1");
  f_FCSI_EFUSE3_rxldo1v2->setDataWidth (4);
  f_FCSI_EFUSE3_rxldo1v2->setResetVal ("4'b0000");
  f_FCSI_EFUSE3_rxldo1v2->setAccProp (AccProp::R);
  r_FCSI_EFUSE3->connectRField (f_FCSI_EFUSE3_rxldo1v2, 8);

  Attribute* a_FCSI_EFUSE3_rxldo1v2_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_EFUSE3_rxldo1v2_0_0->setInstName ("0");
  a_FCSI_EFUSE3_rxldo1v2_0_0->setLongName ("");
  a_FCSI_EFUSE3_rxldo1v2_0_0->setDescription ("");
  a_FCSI_EFUSE3_rxldo1v2_0_0->addItem("15", "4'b1111", "1.37V");
  a_FCSI_EFUSE3_rxldo1v2_0_0->addItem("14", "4'b1110", "1.36V");
  a_FCSI_EFUSE3_rxldo1v2_0_0->addItem("13", "4'b1101", "1.35V");
  a_FCSI_EFUSE3_rxldo1v2_0_0->addItem("12", "4'b1100", "1.34V");
  a_FCSI_EFUSE3_rxldo1v2_0_0->addItem("11", "4'b1011", "1.33V");
  a_FCSI_EFUSE3_rxldo1v2_0_0->addItem("10", "4'b1010", "1.32V");
  a_FCSI_EFUSE3_rxldo1v2_0_0->addItem("9", "4'b1001", "1.31V");
  a_FCSI_EFUSE3_rxldo1v2_0_0->addItem("8", "4'b1000", "1.30V");
  a_FCSI_EFUSE3_rxldo1v2_0_0->addItem("7", "4'b0111", "1.29V");
  a_FCSI_EFUSE3_rxldo1v2_0_0->addItem("6", "4'b0110", "1.28V");
  a_FCSI_EFUSE3_rxldo1v2_0_0->addItem("5", "4'b0101", "1.27V");
  a_FCSI_EFUSE3_rxldo1v2_0_0->addItem("4", "4'b0100", "1.26V");
  a_FCSI_EFUSE3_rxldo1v2_0_0->addItem("3", "4'b0011", "1.25V");
  a_FCSI_EFUSE3_rxldo1v2_0_0->addItem("2", "4'b0010", "1.24V");
  a_FCSI_EFUSE3_rxldo1v2_0_0->addItem("1", "4'b0001", "1.23V");
  a_FCSI_EFUSE3_rxldo1v2_0_0->addItem("0", "4'b0000", "1.22V");
  f_FCSI_EFUSE3_rxldo1v2->connectAttribute (a_FCSI_EFUSE3_rxldo1v2_0_0);

  RField* f_FCSI_EFUSE3_bbldo1v2 = new RField;
  f_FCSI_EFUSE3_bbldo1v2->setInstName ("bbldo1v2");
  f_FCSI_EFUSE3_bbldo1v2->setLongName ("BBLDO1V2");
  f_FCSI_EFUSE3_bbldo1v2->setDescription ("Output voltage of 1V2BBLDO of ANTENNA1");
  f_FCSI_EFUSE3_bbldo1v2->setDataWidth (4);
  f_FCSI_EFUSE3_bbldo1v2->setResetVal ("4'b0000");
  f_FCSI_EFUSE3_bbldo1v2->setAccProp (AccProp::R);
  r_FCSI_EFUSE3->connectRField (f_FCSI_EFUSE3_bbldo1v2, 12);

  Attribute* a_FCSI_EFUSE3_bbldo1v2_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_EFUSE3_bbldo1v2_0_0->setInstName ("0");
  a_FCSI_EFUSE3_bbldo1v2_0_0->setLongName ("");
  a_FCSI_EFUSE3_bbldo1v2_0_0->setDescription ("");
  a_FCSI_EFUSE3_bbldo1v2_0_0->addItem("15", "4'b1111", "1.37V");
  a_FCSI_EFUSE3_bbldo1v2_0_0->addItem("14", "4'b1110", "1.36V");
  a_FCSI_EFUSE3_bbldo1v2_0_0->addItem("13", "4'b1101", "1.35V");
  a_FCSI_EFUSE3_bbldo1v2_0_0->addItem("12", "4'b1100", "1.34V");
  a_FCSI_EFUSE3_bbldo1v2_0_0->addItem("11", "4'b1011", "1.33V");
  a_FCSI_EFUSE3_bbldo1v2_0_0->addItem("10", "4'b1010", "1.32V");
  a_FCSI_EFUSE3_bbldo1v2_0_0->addItem("9", "4'b1001", "1.31V");
  a_FCSI_EFUSE3_bbldo1v2_0_0->addItem("8", "4'b1000", "1.30V");
  a_FCSI_EFUSE3_bbldo1v2_0_0->addItem("7", "4'b0111", "1.29V");
  a_FCSI_EFUSE3_bbldo1v2_0_0->addItem("6", "4'b0110", "1.28V");
  a_FCSI_EFUSE3_bbldo1v2_0_0->addItem("5", "4'b0101", "1.27V");
  a_FCSI_EFUSE3_bbldo1v2_0_0->addItem("4", "4'b0100", "1.26V");
  a_FCSI_EFUSE3_bbldo1v2_0_0->addItem("3", "4'b0011", "1.25V");
  a_FCSI_EFUSE3_bbldo1v2_0_0->addItem("2", "4'b0010", "1.24V");
  a_FCSI_EFUSE3_bbldo1v2_0_0->addItem("1", "4'b0001", "1.23V");
  a_FCSI_EFUSE3_bbldo1v2_0_0->addItem("0", "4'b0000", "1.22V");
  f_FCSI_EFUSE3_bbldo1v2->connectAttribute (a_FCSI_EFUSE3_bbldo1v2_0_0);

  Register* r_FCSI_EFUSE4 = new Register;
  r_FCSI_EFUSE4->setInstName ("EFUSE4");
  r_FCSI_EFUSE4->setLongName ("EFUSE4 1V2LDOs ANT2");
  r_FCSI_EFUSE4->setDescription ("1V2LDOs of ANTENNA2");
  r_FCSI_EFUSE4->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_EFUSE4, 0x00000034);

  RField* f_FCSI_EFUSE4_hbldo1v2 = new RField;
  f_FCSI_EFUSE4_hbldo1v2->setInstName ("hbldo1v2");
  f_FCSI_EFUSE4_hbldo1v2->setLongName ("HBLDO1V2");
  f_FCSI_EFUSE4_hbldo1v2->setDescription ("Output voltage of 1V2HBLDO of ANTENNA2");
  f_FCSI_EFUSE4_hbldo1v2->setDataWidth (4);
  f_FCSI_EFUSE4_hbldo1v2->setResetVal ("4'b0000");
  f_FCSI_EFUSE4_hbldo1v2->setAccProp (AccProp::R);
  r_FCSI_EFUSE4->connectRField (f_FCSI_EFUSE4_hbldo1v2, 0);

  Attribute* a_FCSI_EFUSE4_hbldo1v2_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_EFUSE4_hbldo1v2_0_0->setInstName ("0");
  a_FCSI_EFUSE4_hbldo1v2_0_0->setLongName ("");
  a_FCSI_EFUSE4_hbldo1v2_0_0->setDescription ("");
  a_FCSI_EFUSE4_hbldo1v2_0_0->addItem("15", "4'b1111", "1.37V");
  a_FCSI_EFUSE4_hbldo1v2_0_0->addItem("14", "4'b1110", "1.36V");
  a_FCSI_EFUSE4_hbldo1v2_0_0->addItem("13", "4'b1101", "1.35V");
  a_FCSI_EFUSE4_hbldo1v2_0_0->addItem("12", "4'b1100", "1.34V");
  a_FCSI_EFUSE4_hbldo1v2_0_0->addItem("11", "4'b1011", "1.33V");
  a_FCSI_EFUSE4_hbldo1v2_0_0->addItem("10", "4'b1010", "1.32V");
  a_FCSI_EFUSE4_hbldo1v2_0_0->addItem("9", "4'b1001", "1.31V");
  a_FCSI_EFUSE4_hbldo1v2_0_0->addItem("8", "4'b1000", "1.30V");
  a_FCSI_EFUSE4_hbldo1v2_0_0->addItem("7", "4'b0111", "1.29V");
  a_FCSI_EFUSE4_hbldo1v2_0_0->addItem("6", "4'b0110", "1.28V");
  a_FCSI_EFUSE4_hbldo1v2_0_0->addItem("5", "4'b0101", "1.27V");
  a_FCSI_EFUSE4_hbldo1v2_0_0->addItem("4", "4'b0100", "1.26V");
  a_FCSI_EFUSE4_hbldo1v2_0_0->addItem("3", "4'b0011", "1.25V");
  a_FCSI_EFUSE4_hbldo1v2_0_0->addItem("2", "4'b0010", "1.24V");
  a_FCSI_EFUSE4_hbldo1v2_0_0->addItem("1", "4'b0001", "1.23V");
  a_FCSI_EFUSE4_hbldo1v2_0_0->addItem("0", "4'b0000", "1.22V");
  f_FCSI_EFUSE4_hbldo1v2->connectAttribute (a_FCSI_EFUSE4_hbldo1v2_0_0);

  RField* f_FCSI_EFUSE4_lbldo1v2 = new RField;
  f_FCSI_EFUSE4_lbldo1v2->setInstName ("lbldo1v2");
  f_FCSI_EFUSE4_lbldo1v2->setLongName ("LBLDO1V2");
  f_FCSI_EFUSE4_lbldo1v2->setDescription ("Output voltage of 1V2LBLDO of ANTENNA2");
  f_FCSI_EFUSE4_lbldo1v2->setDataWidth (4);
  f_FCSI_EFUSE4_lbldo1v2->setResetVal ("4'b0000");
  f_FCSI_EFUSE4_lbldo1v2->setAccProp (AccProp::R);
  r_FCSI_EFUSE4->connectRField (f_FCSI_EFUSE4_lbldo1v2, 4);

  Attribute* a_FCSI_EFUSE4_lbldo1v2_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_EFUSE4_lbldo1v2_0_0->setInstName ("0");
  a_FCSI_EFUSE4_lbldo1v2_0_0->setLongName ("");
  a_FCSI_EFUSE4_lbldo1v2_0_0->setDescription ("");
  a_FCSI_EFUSE4_lbldo1v2_0_0->addItem("15", "4'b1111", "1.37V");
  a_FCSI_EFUSE4_lbldo1v2_0_0->addItem("14", "4'b1110", "1.36V");
  a_FCSI_EFUSE4_lbldo1v2_0_0->addItem("13", "4'b1101", "1.35V");
  a_FCSI_EFUSE4_lbldo1v2_0_0->addItem("12", "4'b1100", "1.34V");
  a_FCSI_EFUSE4_lbldo1v2_0_0->addItem("11", "4'b1011", "1.33V");
  a_FCSI_EFUSE4_lbldo1v2_0_0->addItem("10", "4'b1010", "1.32V");
  a_FCSI_EFUSE4_lbldo1v2_0_0->addItem("9", "4'b1001", "1.31V");
  a_FCSI_EFUSE4_lbldo1v2_0_0->addItem("8", "4'b1000", "1.30V");
  a_FCSI_EFUSE4_lbldo1v2_0_0->addItem("7", "4'b0111", "1.29V");
  a_FCSI_EFUSE4_lbldo1v2_0_0->addItem("6", "4'b0110", "1.28V");
  a_FCSI_EFUSE4_lbldo1v2_0_0->addItem("5", "4'b0101", "1.27V");
  a_FCSI_EFUSE4_lbldo1v2_0_0->addItem("4", "4'b0100", "1.26V");
  a_FCSI_EFUSE4_lbldo1v2_0_0->addItem("3", "4'b0011", "1.25V");
  a_FCSI_EFUSE4_lbldo1v2_0_0->addItem("2", "4'b0010", "1.24V");
  a_FCSI_EFUSE4_lbldo1v2_0_0->addItem("1", "4'b0001", "1.23V");
  a_FCSI_EFUSE4_lbldo1v2_0_0->addItem("0", "4'b0000", "1.22V");
  f_FCSI_EFUSE4_lbldo1v2->connectAttribute (a_FCSI_EFUSE4_lbldo1v2_0_0);

  RField* f_FCSI_EFUSE4_rxldo1v2 = new RField;
  f_FCSI_EFUSE4_rxldo1v2->setInstName ("rxldo1v2");
  f_FCSI_EFUSE4_rxldo1v2->setLongName ("RXLDO1V2");
  f_FCSI_EFUSE4_rxldo1v2->setDescription ("Output voltage of 1V2RXLDO of ANTENNA2");
  f_FCSI_EFUSE4_rxldo1v2->setDataWidth (4);
  f_FCSI_EFUSE4_rxldo1v2->setResetVal ("4'b0000");
  f_FCSI_EFUSE4_rxldo1v2->setAccProp (AccProp::R);
  r_FCSI_EFUSE4->connectRField (f_FCSI_EFUSE4_rxldo1v2, 8);

  Attribute* a_FCSI_EFUSE4_rxldo1v2_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_EFUSE4_rxldo1v2_0_0->setInstName ("0");
  a_FCSI_EFUSE4_rxldo1v2_0_0->setLongName ("");
  a_FCSI_EFUSE4_rxldo1v2_0_0->setDescription ("");
  a_FCSI_EFUSE4_rxldo1v2_0_0->addItem("15", "4'b1111", "1.37V");
  a_FCSI_EFUSE4_rxldo1v2_0_0->addItem("14", "4'b1110", "1.36V");
  a_FCSI_EFUSE4_rxldo1v2_0_0->addItem("13", "4'b1101", "1.35V");
  a_FCSI_EFUSE4_rxldo1v2_0_0->addItem("12", "4'b1100", "1.34V");
  a_FCSI_EFUSE4_rxldo1v2_0_0->addItem("11", "4'b1011", "1.33V");
  a_FCSI_EFUSE4_rxldo1v2_0_0->addItem("10", "4'b1010", "1.32V");
  a_FCSI_EFUSE4_rxldo1v2_0_0->addItem("9", "4'b1001", "1.31V");
  a_FCSI_EFUSE4_rxldo1v2_0_0->addItem("8", "4'b1000", "1.30V");
  a_FCSI_EFUSE4_rxldo1v2_0_0->addItem("7", "4'b0111", "1.29V");
  a_FCSI_EFUSE4_rxldo1v2_0_0->addItem("6", "4'b0110", "1.28V");
  a_FCSI_EFUSE4_rxldo1v2_0_0->addItem("5", "4'b0101", "1.27V");
  a_FCSI_EFUSE4_rxldo1v2_0_0->addItem("4", "4'b0100", "1.26V");
  a_FCSI_EFUSE4_rxldo1v2_0_0->addItem("3", "4'b0011", "1.25V");
  a_FCSI_EFUSE4_rxldo1v2_0_0->addItem("2", "4'b0010", "1.24V");
  a_FCSI_EFUSE4_rxldo1v2_0_0->addItem("1", "4'b0001", "1.23V");
  a_FCSI_EFUSE4_rxldo1v2_0_0->addItem("0", "4'b0000", "1.22V");
  f_FCSI_EFUSE4_rxldo1v2->connectAttribute (a_FCSI_EFUSE4_rxldo1v2_0_0);

  RField* f_FCSI_EFUSE4_bbldo1v2 = new RField;
  f_FCSI_EFUSE4_bbldo1v2->setInstName ("bbldo1v2");
  f_FCSI_EFUSE4_bbldo1v2->setLongName ("BBLDO1V2");
  f_FCSI_EFUSE4_bbldo1v2->setDescription ("Output voltage of 1V2BBLDO of ANTENNA2");
  f_FCSI_EFUSE4_bbldo1v2->setDataWidth (4);
  f_FCSI_EFUSE4_bbldo1v2->setResetVal ("4'b0000");
  f_FCSI_EFUSE4_bbldo1v2->setAccProp (AccProp::R);
  r_FCSI_EFUSE4->connectRField (f_FCSI_EFUSE4_bbldo1v2, 12);

  Attribute* a_FCSI_EFUSE4_bbldo1v2_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_EFUSE4_bbldo1v2_0_0->setInstName ("0");
  a_FCSI_EFUSE4_bbldo1v2_0_0->setLongName ("");
  a_FCSI_EFUSE4_bbldo1v2_0_0->setDescription ("");
  a_FCSI_EFUSE4_bbldo1v2_0_0->addItem("15", "4'b1111", "1.37V");
  a_FCSI_EFUSE4_bbldo1v2_0_0->addItem("14", "4'b1110", "1.36V");
  a_FCSI_EFUSE4_bbldo1v2_0_0->addItem("13", "4'b1101", "1.35V");
  a_FCSI_EFUSE4_bbldo1v2_0_0->addItem("12", "4'b1100", "1.34V");
  a_FCSI_EFUSE4_bbldo1v2_0_0->addItem("11", "4'b1011", "1.33V");
  a_FCSI_EFUSE4_bbldo1v2_0_0->addItem("10", "4'b1010", "1.32V");
  a_FCSI_EFUSE4_bbldo1v2_0_0->addItem("9", "4'b1001", "1.31V");
  a_FCSI_EFUSE4_bbldo1v2_0_0->addItem("8", "4'b1000", "1.30V");
  a_FCSI_EFUSE4_bbldo1v2_0_0->addItem("7", "4'b0111", "1.29V");
  a_FCSI_EFUSE4_bbldo1v2_0_0->addItem("6", "4'b0110", "1.28V");
  a_FCSI_EFUSE4_bbldo1v2_0_0->addItem("5", "4'b0101", "1.27V");
  a_FCSI_EFUSE4_bbldo1v2_0_0->addItem("4", "4'b0100", "1.26V");
  a_FCSI_EFUSE4_bbldo1v2_0_0->addItem("3", "4'b0011", "1.25V");
  a_FCSI_EFUSE4_bbldo1v2_0_0->addItem("2", "4'b0010", "1.24V");
  a_FCSI_EFUSE4_bbldo1v2_0_0->addItem("1", "4'b0001", "1.23V");
  a_FCSI_EFUSE4_bbldo1v2_0_0->addItem("0", "4'b0000", "1.22V");
  f_FCSI_EFUSE4_bbldo1v2->connectAttribute (a_FCSI_EFUSE4_bbldo1v2_0_0);

  Register* r_FCSI_EFUSE5 = new Register;
  r_FCSI_EFUSE5->setInstName ("EFUSE5");
  r_FCSI_EFUSE5->setLongName ("EFUSE5 1V2LDOs ANT3");
  r_FCSI_EFUSE5->setDescription ("1V2LDOs of ANTENNA3");
  r_FCSI_EFUSE5->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_EFUSE5, 0x00000035);

  RField* f_FCSI_EFUSE5_hbldo1v2 = new RField;
  f_FCSI_EFUSE5_hbldo1v2->setInstName ("hbldo1v2");
  f_FCSI_EFUSE5_hbldo1v2->setLongName ("HBLDO1V2");
  f_FCSI_EFUSE5_hbldo1v2->setDescription ("Output voltage of 1V2HBLDO of ANTENNA3");
  f_FCSI_EFUSE5_hbldo1v2->setDataWidth (4);
  f_FCSI_EFUSE5_hbldo1v2->setResetVal ("4'b0000");
  f_FCSI_EFUSE5_hbldo1v2->setAccProp (AccProp::R);
  r_FCSI_EFUSE5->connectRField (f_FCSI_EFUSE5_hbldo1v2, 0);

  Attribute* a_FCSI_EFUSE5_hbldo1v2_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_EFUSE5_hbldo1v2_0_0->setInstName ("0");
  a_FCSI_EFUSE5_hbldo1v2_0_0->setLongName ("");
  a_FCSI_EFUSE5_hbldo1v2_0_0->setDescription ("");
  a_FCSI_EFUSE5_hbldo1v2_0_0->addItem("15", "4'b1111", "1.37V");
  a_FCSI_EFUSE5_hbldo1v2_0_0->addItem("14", "4'b1110", "1.36V");
  a_FCSI_EFUSE5_hbldo1v2_0_0->addItem("13", "4'b1101", "1.35V");
  a_FCSI_EFUSE5_hbldo1v2_0_0->addItem("12", "4'b1100", "1.34V");
  a_FCSI_EFUSE5_hbldo1v2_0_0->addItem("11", "4'b1011", "1.33V");
  a_FCSI_EFUSE5_hbldo1v2_0_0->addItem("10", "4'b1010", "1.32V");
  a_FCSI_EFUSE5_hbldo1v2_0_0->addItem("9", "4'b1001", "1.31V");
  a_FCSI_EFUSE5_hbldo1v2_0_0->addItem("8", "4'b1000", "1.30V");
  a_FCSI_EFUSE5_hbldo1v2_0_0->addItem("7", "4'b0111", "1.29V");
  a_FCSI_EFUSE5_hbldo1v2_0_0->addItem("6", "4'b0110", "1.28V");
  a_FCSI_EFUSE5_hbldo1v2_0_0->addItem("5", "4'b0101", "1.27V");
  a_FCSI_EFUSE5_hbldo1v2_0_0->addItem("4", "4'b0100", "1.26V");
  a_FCSI_EFUSE5_hbldo1v2_0_0->addItem("3", "4'b0011", "1.25V");
  a_FCSI_EFUSE5_hbldo1v2_0_0->addItem("2", "4'b0010", "1.24V");
  a_FCSI_EFUSE5_hbldo1v2_0_0->addItem("1", "4'b0001", "1.23V");
  a_FCSI_EFUSE5_hbldo1v2_0_0->addItem("0", "4'b0000", "1.22V");
  f_FCSI_EFUSE5_hbldo1v2->connectAttribute (a_FCSI_EFUSE5_hbldo1v2_0_0);

  RField* f_FCSI_EFUSE5_lbldo1v2 = new RField;
  f_FCSI_EFUSE5_lbldo1v2->setInstName ("lbldo1v2");
  f_FCSI_EFUSE5_lbldo1v2->setLongName ("LBLDO1V2");
  f_FCSI_EFUSE5_lbldo1v2->setDescription ("Output voltage of 1V2LBLDO of ANTENNA3");
  f_FCSI_EFUSE5_lbldo1v2->setDataWidth (4);
  f_FCSI_EFUSE5_lbldo1v2->setResetVal ("4'b0000");
  f_FCSI_EFUSE5_lbldo1v2->setAccProp (AccProp::R);
  r_FCSI_EFUSE5->connectRField (f_FCSI_EFUSE5_lbldo1v2, 4);

  Attribute* a_FCSI_EFUSE5_lbldo1v2_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_EFUSE5_lbldo1v2_0_0->setInstName ("0");
  a_FCSI_EFUSE5_lbldo1v2_0_0->setLongName ("");
  a_FCSI_EFUSE5_lbldo1v2_0_0->setDescription ("");
  a_FCSI_EFUSE5_lbldo1v2_0_0->addItem("15", "4'b1111", "1.37V");
  a_FCSI_EFUSE5_lbldo1v2_0_0->addItem("14", "4'b1110", "1.36V");
  a_FCSI_EFUSE5_lbldo1v2_0_0->addItem("13", "4'b1101", "1.35V");
  a_FCSI_EFUSE5_lbldo1v2_0_0->addItem("12", "4'b1100", "1.34V");
  a_FCSI_EFUSE5_lbldo1v2_0_0->addItem("11", "4'b1011", "1.33V");
  a_FCSI_EFUSE5_lbldo1v2_0_0->addItem("10", "4'b1010", "1.32V");
  a_FCSI_EFUSE5_lbldo1v2_0_0->addItem("9", "4'b1001", "1.31V");
  a_FCSI_EFUSE5_lbldo1v2_0_0->addItem("8", "4'b1000", "1.30V");
  a_FCSI_EFUSE5_lbldo1v2_0_0->addItem("7", "4'b0111", "1.29V");
  a_FCSI_EFUSE5_lbldo1v2_0_0->addItem("6", "4'b0110", "1.28V");
  a_FCSI_EFUSE5_lbldo1v2_0_0->addItem("5", "4'b0101", "1.27V");
  a_FCSI_EFUSE5_lbldo1v2_0_0->addItem("4", "4'b0100", "1.26V");
  a_FCSI_EFUSE5_lbldo1v2_0_0->addItem("3", "4'b0011", "1.25V");
  a_FCSI_EFUSE5_lbldo1v2_0_0->addItem("2", "4'b0010", "1.24V");
  a_FCSI_EFUSE5_lbldo1v2_0_0->addItem("1", "4'b0001", "1.23V");
  a_FCSI_EFUSE5_lbldo1v2_0_0->addItem("0", "4'b0000", "1.22V");
  f_FCSI_EFUSE5_lbldo1v2->connectAttribute (a_FCSI_EFUSE5_lbldo1v2_0_0);

  RField* f_FCSI_EFUSE5_rxldo1v2 = new RField;
  f_FCSI_EFUSE5_rxldo1v2->setInstName ("rxldo1v2");
  f_FCSI_EFUSE5_rxldo1v2->setLongName ("RXLDO1V2");
  f_FCSI_EFUSE5_rxldo1v2->setDescription ("Output voltage of 1V2RXLDO of ANTENNA3");
  f_FCSI_EFUSE5_rxldo1v2->setDataWidth (4);
  f_FCSI_EFUSE5_rxldo1v2->setResetVal ("4'b0000");
  f_FCSI_EFUSE5_rxldo1v2->setAccProp (AccProp::R);
  r_FCSI_EFUSE5->connectRField (f_FCSI_EFUSE5_rxldo1v2, 8);

  Attribute* a_FCSI_EFUSE5_rxldo1v2_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_EFUSE5_rxldo1v2_0_0->setInstName ("0");
  a_FCSI_EFUSE5_rxldo1v2_0_0->setLongName ("");
  a_FCSI_EFUSE5_rxldo1v2_0_0->setDescription ("");
  a_FCSI_EFUSE5_rxldo1v2_0_0->addItem("15", "4'b1111", "1.37V");
  a_FCSI_EFUSE5_rxldo1v2_0_0->addItem("14", "4'b1110", "1.36V");
  a_FCSI_EFUSE5_rxldo1v2_0_0->addItem("13", "4'b1101", "1.35V");
  a_FCSI_EFUSE5_rxldo1v2_0_0->addItem("12", "4'b1100", "1.34V");
  a_FCSI_EFUSE5_rxldo1v2_0_0->addItem("11", "4'b1011", "1.33V");
  a_FCSI_EFUSE5_rxldo1v2_0_0->addItem("10", "4'b1010", "1.32V");
  a_FCSI_EFUSE5_rxldo1v2_0_0->addItem("9", "4'b1001", "1.31V");
  a_FCSI_EFUSE5_rxldo1v2_0_0->addItem("8", "4'b1000", "1.30V");
  a_FCSI_EFUSE5_rxldo1v2_0_0->addItem("7", "4'b0111", "1.29V");
  a_FCSI_EFUSE5_rxldo1v2_0_0->addItem("6", "4'b0110", "1.28V");
  a_FCSI_EFUSE5_rxldo1v2_0_0->addItem("5", "4'b0101", "1.27V");
  a_FCSI_EFUSE5_rxldo1v2_0_0->addItem("4", "4'b0100", "1.26V");
  a_FCSI_EFUSE5_rxldo1v2_0_0->addItem("3", "4'b0011", "1.25V");
  a_FCSI_EFUSE5_rxldo1v2_0_0->addItem("2", "4'b0010", "1.24V");
  a_FCSI_EFUSE5_rxldo1v2_0_0->addItem("1", "4'b0001", "1.23V");
  a_FCSI_EFUSE5_rxldo1v2_0_0->addItem("0", "4'b0000", "1.22V");
  f_FCSI_EFUSE5_rxldo1v2->connectAttribute (a_FCSI_EFUSE5_rxldo1v2_0_0);

  RField* f_FCSI_EFUSE5_bbldo1v2 = new RField;
  f_FCSI_EFUSE5_bbldo1v2->setInstName ("bbldo1v2");
  f_FCSI_EFUSE5_bbldo1v2->setLongName ("BBLDO1V2");
  f_FCSI_EFUSE5_bbldo1v2->setDescription ("Output voltage of 1V2BBLDO of ANTENNA3");
  f_FCSI_EFUSE5_bbldo1v2->setDataWidth (4);
  f_FCSI_EFUSE5_bbldo1v2->setResetVal ("4'b0000");
  f_FCSI_EFUSE5_bbldo1v2->setAccProp (AccProp::R);
  r_FCSI_EFUSE5->connectRField (f_FCSI_EFUSE5_bbldo1v2, 12);

  Attribute* a_FCSI_EFUSE5_bbldo1v2_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_EFUSE5_bbldo1v2_0_0->setInstName ("0");
  a_FCSI_EFUSE5_bbldo1v2_0_0->setLongName ("");
  a_FCSI_EFUSE5_bbldo1v2_0_0->setDescription ("");
  a_FCSI_EFUSE5_bbldo1v2_0_0->addItem("15", "4'b1111", "1.37V");
  a_FCSI_EFUSE5_bbldo1v2_0_0->addItem("14", "4'b1110", "1.36V");
  a_FCSI_EFUSE5_bbldo1v2_0_0->addItem("13", "4'b1101", "1.35V");
  a_FCSI_EFUSE5_bbldo1v2_0_0->addItem("12", "4'b1100", "1.34V");
  a_FCSI_EFUSE5_bbldo1v2_0_0->addItem("11", "4'b1011", "1.33V");
  a_FCSI_EFUSE5_bbldo1v2_0_0->addItem("10", "4'b1010", "1.32V");
  a_FCSI_EFUSE5_bbldo1v2_0_0->addItem("9", "4'b1001", "1.31V");
  a_FCSI_EFUSE5_bbldo1v2_0_0->addItem("8", "4'b1000", "1.30V");
  a_FCSI_EFUSE5_bbldo1v2_0_0->addItem("7", "4'b0111", "1.29V");
  a_FCSI_EFUSE5_bbldo1v2_0_0->addItem("6", "4'b0110", "1.28V");
  a_FCSI_EFUSE5_bbldo1v2_0_0->addItem("5", "4'b0101", "1.27V");
  a_FCSI_EFUSE5_bbldo1v2_0_0->addItem("4", "4'b0100", "1.26V");
  a_FCSI_EFUSE5_bbldo1v2_0_0->addItem("3", "4'b0011", "1.25V");
  a_FCSI_EFUSE5_bbldo1v2_0_0->addItem("2", "4'b0010", "1.24V");
  a_FCSI_EFUSE5_bbldo1v2_0_0->addItem("1", "4'b0001", "1.23V");
  a_FCSI_EFUSE5_bbldo1v2_0_0->addItem("0", "4'b0000", "1.22V");
  f_FCSI_EFUSE5_bbldo1v2->connectAttribute (a_FCSI_EFUSE5_bbldo1v2_0_0);

  Register* r_FCSI_EFUSE6 = new Register;
  r_FCSI_EFUSE6->setInstName ("EFUSE6");
  r_FCSI_EFUSE6->setLongName ("EFUSE6 2V5LDOs ANT0123");
  r_FCSI_EFUSE6->setDescription ("2V5LDOs of ANTENNA0123");
  r_FCSI_EFUSE6->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_EFUSE6, 0x00000036);

  RField* f_FCSI_EFUSE6_ldo2v5ant0 = new RField;
  f_FCSI_EFUSE6_ldo2v5ant0->setInstName ("ldo2v5ant0");
  f_FCSI_EFUSE6_ldo2v5ant0->setLongName ("LDO2V5 ANT0");
  f_FCSI_EFUSE6_ldo2v5ant0->setDescription ("Output voltage of 2V5LDO of ANTENNA0");
  f_FCSI_EFUSE6_ldo2v5ant0->setDataWidth (4);
  f_FCSI_EFUSE6_ldo2v5ant0->setResetVal ("4'b0000");
  f_FCSI_EFUSE6_ldo2v5ant0->setAccProp (AccProp::R);
  r_FCSI_EFUSE6->connectRField (f_FCSI_EFUSE6_ldo2v5ant0, 0);

  Attribute* a_FCSI_EFUSE6_ldo2v5ant0_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_EFUSE6_ldo2v5ant0_0_0->setInstName ("0");
  a_FCSI_EFUSE6_ldo2v5ant0_0_0->setLongName ("");
  a_FCSI_EFUSE6_ldo2v5ant0_0_0->setDescription ("");
  a_FCSI_EFUSE6_ldo2v5ant0_0_0->addItem("0", "4'b0111", "2.65V");
  a_FCSI_EFUSE6_ldo2v5ant0_0_0->addItem("1", "4'b0110", "2.63V");
  a_FCSI_EFUSE6_ldo2v5ant0_0_0->addItem("2", "4'b0101", "2.61V");
  a_FCSI_EFUSE6_ldo2v5ant0_0_0->addItem("3", "4'b0100", "2.59V");
  a_FCSI_EFUSE6_ldo2v5ant0_0_0->addItem("4", "4'b0011", "2.57V");
  a_FCSI_EFUSE6_ldo2v5ant0_0_0->addItem("5", "4'b0010", "2.55V");
  a_FCSI_EFUSE6_ldo2v5ant0_0_0->addItem("6", "4'b0001", "2.53V");
  a_FCSI_EFUSE6_ldo2v5ant0_0_0->addItem("7", "4'b0000", "2.51V");
  a_FCSI_EFUSE6_ldo2v5ant0_0_0->addItem("8", "4'b1111", "2.49V");
  a_FCSI_EFUSE6_ldo2v5ant0_0_0->addItem("9", "4'b1110", "2.47V");
  a_FCSI_EFUSE6_ldo2v5ant0_0_0->addItem("10", "4'b1101", "2.45V");
  a_FCSI_EFUSE6_ldo2v5ant0_0_0->addItem("11", "4'b1100", "2.43V");
  a_FCSI_EFUSE6_ldo2v5ant0_0_0->addItem("12", "4'b1011", "2.41V");
  a_FCSI_EFUSE6_ldo2v5ant0_0_0->addItem("13", "4'b1010", "2.39V");
  a_FCSI_EFUSE6_ldo2v5ant0_0_0->addItem("14", "4'b1001", "2.37V");
  a_FCSI_EFUSE6_ldo2v5ant0_0_0->addItem("15", "4'b1000", "2.35V");
  f_FCSI_EFUSE6_ldo2v5ant0->connectAttribute (a_FCSI_EFUSE6_ldo2v5ant0_0_0);

  RField* f_FCSI_EFUSE6_ldo2v5ant1 = new RField;
  f_FCSI_EFUSE6_ldo2v5ant1->setInstName ("ldo2v5ant1");
  f_FCSI_EFUSE6_ldo2v5ant1->setLongName ("LDO2V5 ANT1");
  f_FCSI_EFUSE6_ldo2v5ant1->setDescription ("Output voltage of 2V5LDO of ANTENNA1");
  f_FCSI_EFUSE6_ldo2v5ant1->setDataWidth (4);
  f_FCSI_EFUSE6_ldo2v5ant1->setResetVal ("4'b0000");
  f_FCSI_EFUSE6_ldo2v5ant1->setAccProp (AccProp::R);
  r_FCSI_EFUSE6->connectRField (f_FCSI_EFUSE6_ldo2v5ant1, 4);

  Attribute* a_FCSI_EFUSE6_ldo2v5ant1_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_EFUSE6_ldo2v5ant1_0_0->setInstName ("0");
  a_FCSI_EFUSE6_ldo2v5ant1_0_0->setLongName ("");
  a_FCSI_EFUSE6_ldo2v5ant1_0_0->setDescription ("");
  a_FCSI_EFUSE6_ldo2v5ant1_0_0->addItem("0", "4'b0111", "2.65V");
  a_FCSI_EFUSE6_ldo2v5ant1_0_0->addItem("1", "4'b0110", "2.63V");
  a_FCSI_EFUSE6_ldo2v5ant1_0_0->addItem("2", "4'b0101", "2.61V");
  a_FCSI_EFUSE6_ldo2v5ant1_0_0->addItem("3", "4'b0100", "2.59V");
  a_FCSI_EFUSE6_ldo2v5ant1_0_0->addItem("4", "4'b0011", "2.57V");
  a_FCSI_EFUSE6_ldo2v5ant1_0_0->addItem("5", "4'b0010", "2.55V");
  a_FCSI_EFUSE6_ldo2v5ant1_0_0->addItem("6", "4'b0001", "2.53V");
  a_FCSI_EFUSE6_ldo2v5ant1_0_0->addItem("7", "4'b0000", "2.51V");
  a_FCSI_EFUSE6_ldo2v5ant1_0_0->addItem("8", "4'b1111", "2.49V");
  a_FCSI_EFUSE6_ldo2v5ant1_0_0->addItem("9", "4'b1110", "2.47V");
  a_FCSI_EFUSE6_ldo2v5ant1_0_0->addItem("10", "4'b1101", "2.45V");
  a_FCSI_EFUSE6_ldo2v5ant1_0_0->addItem("11", "4'b1100", "2.43V");
  a_FCSI_EFUSE6_ldo2v5ant1_0_0->addItem("12", "4'b1011", "2.41V");
  a_FCSI_EFUSE6_ldo2v5ant1_0_0->addItem("13", "4'b1010", "2.39V");
  a_FCSI_EFUSE6_ldo2v5ant1_0_0->addItem("14", "4'b1001", "2.37V");
  a_FCSI_EFUSE6_ldo2v5ant1_0_0->addItem("15", "4'b1000", "2.35V");
  f_FCSI_EFUSE6_ldo2v5ant1->connectAttribute (a_FCSI_EFUSE6_ldo2v5ant1_0_0);

  RField* f_FCSI_EFUSE6_ldo2v5ant2 = new RField;
  f_FCSI_EFUSE6_ldo2v5ant2->setInstName ("ldo2v5ant2");
  f_FCSI_EFUSE6_ldo2v5ant2->setLongName ("LDO2V5 ANT2");
  f_FCSI_EFUSE6_ldo2v5ant2->setDescription ("Output voltage of 2V5LDO of ANTENNA2");
  f_FCSI_EFUSE6_ldo2v5ant2->setDataWidth (4);
  f_FCSI_EFUSE6_ldo2v5ant2->setResetVal ("4'b0000");
  f_FCSI_EFUSE6_ldo2v5ant2->setAccProp (AccProp::R);
  r_FCSI_EFUSE6->connectRField (f_FCSI_EFUSE6_ldo2v5ant2, 8);

  Attribute* a_FCSI_EFUSE6_ldo2v5ant2_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_EFUSE6_ldo2v5ant2_0_0->setInstName ("0");
  a_FCSI_EFUSE6_ldo2v5ant2_0_0->setLongName ("");
  a_FCSI_EFUSE6_ldo2v5ant2_0_0->setDescription ("");
  a_FCSI_EFUSE6_ldo2v5ant2_0_0->addItem("0", "4'b0111", "2.65V");
  a_FCSI_EFUSE6_ldo2v5ant2_0_0->addItem("1", "4'b0110", "2.63V");
  a_FCSI_EFUSE6_ldo2v5ant2_0_0->addItem("2", "4'b0101", "2.61V");
  a_FCSI_EFUSE6_ldo2v5ant2_0_0->addItem("3", "4'b0100", "2.59V");
  a_FCSI_EFUSE6_ldo2v5ant2_0_0->addItem("4", "4'b0011", "2.57V");
  a_FCSI_EFUSE6_ldo2v5ant2_0_0->addItem("5", "4'b0010", "2.55V");
  a_FCSI_EFUSE6_ldo2v5ant2_0_0->addItem("6", "4'b0001", "2.53V");
  a_FCSI_EFUSE6_ldo2v5ant2_0_0->addItem("7", "4'b0000", "2.51V");
  a_FCSI_EFUSE6_ldo2v5ant2_0_0->addItem("8", "4'b1111", "2.49V");
  a_FCSI_EFUSE6_ldo2v5ant2_0_0->addItem("9", "4'b1110", "2.47V");
  a_FCSI_EFUSE6_ldo2v5ant2_0_0->addItem("10", "4'b1101", "2.45V");
  a_FCSI_EFUSE6_ldo2v5ant2_0_0->addItem("11", "4'b1100", "2.43V");
  a_FCSI_EFUSE6_ldo2v5ant2_0_0->addItem("12", "4'b1011", "2.41V");
  a_FCSI_EFUSE6_ldo2v5ant2_0_0->addItem("13", "4'b1010", "2.39V");
  a_FCSI_EFUSE6_ldo2v5ant2_0_0->addItem("14", "4'b1001", "2.37V");
  a_FCSI_EFUSE6_ldo2v5ant2_0_0->addItem("15", "4'b1000", "2.35V");
  f_FCSI_EFUSE6_ldo2v5ant2->connectAttribute (a_FCSI_EFUSE6_ldo2v5ant2_0_0);

  RField* f_FCSI_EFUSE6_ldo2v5ant3 = new RField;
  f_FCSI_EFUSE6_ldo2v5ant3->setInstName ("ldo2v5ant3");
  f_FCSI_EFUSE6_ldo2v5ant3->setLongName ("LDO2V5 ANT3");
  f_FCSI_EFUSE6_ldo2v5ant3->setDescription ("Output voltage of 2V5LDO of ANTENNA3");
  f_FCSI_EFUSE6_ldo2v5ant3->setDataWidth (4);
  f_FCSI_EFUSE6_ldo2v5ant3->setResetVal ("4'b0000");
  f_FCSI_EFUSE6_ldo2v5ant3->setAccProp (AccProp::R);
  r_FCSI_EFUSE6->connectRField (f_FCSI_EFUSE6_ldo2v5ant3, 12);

  Attribute* a_FCSI_EFUSE6_ldo2v5ant3_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_EFUSE6_ldo2v5ant3_0_0->setInstName ("0");
  a_FCSI_EFUSE6_ldo2v5ant3_0_0->setLongName ("");
  a_FCSI_EFUSE6_ldo2v5ant3_0_0->setDescription ("");
  a_FCSI_EFUSE6_ldo2v5ant3_0_0->addItem("0", "4'b0111", "2.65V");
  a_FCSI_EFUSE6_ldo2v5ant3_0_0->addItem("1", "4'b0110", "2.63V");
  a_FCSI_EFUSE6_ldo2v5ant3_0_0->addItem("2", "4'b0101", "2.61V");
  a_FCSI_EFUSE6_ldo2v5ant3_0_0->addItem("3", "4'b0100", "2.59V");
  a_FCSI_EFUSE6_ldo2v5ant3_0_0->addItem("4", "4'b0011", "2.57V");
  a_FCSI_EFUSE6_ldo2v5ant3_0_0->addItem("5", "4'b0010", "2.55V");
  a_FCSI_EFUSE6_ldo2v5ant3_0_0->addItem("6", "4'b0001", "2.53V");
  a_FCSI_EFUSE6_ldo2v5ant3_0_0->addItem("7", "4'b0000", "2.51V");
  a_FCSI_EFUSE6_ldo2v5ant3_0_0->addItem("8", "4'b1111", "2.49V");
  a_FCSI_EFUSE6_ldo2v5ant3_0_0->addItem("9", "4'b1110", "2.47V");
  a_FCSI_EFUSE6_ldo2v5ant3_0_0->addItem("10", "4'b1101", "2.45V");
  a_FCSI_EFUSE6_ldo2v5ant3_0_0->addItem("11", "4'b1100", "2.43V");
  a_FCSI_EFUSE6_ldo2v5ant3_0_0->addItem("12", "4'b1011", "2.41V");
  a_FCSI_EFUSE6_ldo2v5ant3_0_0->addItem("13", "4'b1010", "2.39V");
  a_FCSI_EFUSE6_ldo2v5ant3_0_0->addItem("14", "4'b1001", "2.37V");
  a_FCSI_EFUSE6_ldo2v5ant3_0_0->addItem("15", "4'b1000", "2.35V");
  f_FCSI_EFUSE6_ldo2v5ant3->connectAttribute (a_FCSI_EFUSE6_ldo2v5ant3_0_0);

  Register* r_FCSI_EFUSE7 = new Register;
  r_FCSI_EFUSE7->setInstName ("EFUSE7");
  r_FCSI_EFUSE7->setLongName ("EFUSE7 1V2HBLOTREELDOs ANT0123");
  r_FCSI_EFUSE7->setDescription ("1V2HBLOTREELDOs of ANTENNA0123");
  r_FCSI_EFUSE7->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_EFUSE7, 0x00000037);

  RField* f_FCSI_EFUSE7_lotreeldoant0 = new RField;
  f_FCSI_EFUSE7_lotreeldoant0->setInstName ("lotreeldoant0");
  f_FCSI_EFUSE7_lotreeldoant0->setLongName ("LOTREELDOANT0");
  f_FCSI_EFUSE7_lotreeldoant0->setDescription ("Control output voltage of LOTREELDOANT0");
  f_FCSI_EFUSE7_lotreeldoant0->setDataWidth (4);
  f_FCSI_EFUSE7_lotreeldoant0->setResetVal ("4'b0000");
  f_FCSI_EFUSE7_lotreeldoant0->setAccProp (AccProp::R);
  r_FCSI_EFUSE7->connectRField (f_FCSI_EFUSE7_lotreeldoant0, 0);

  Attribute* a_FCSI_EFUSE7_lotreeldoant0_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_EFUSE7_lotreeldoant0_0_0->setInstName ("0");
  a_FCSI_EFUSE7_lotreeldoant0_0_0->setLongName ("");
  a_FCSI_EFUSE7_lotreeldoant0_0_0->setDescription ("");
  a_FCSI_EFUSE7_lotreeldoant0_0_0->addItem("7", "4'b0111", "1.283V");
  a_FCSI_EFUSE7_lotreeldoant0_0_0->addItem("6", "4'b0110", "1.273V");
  a_FCSI_EFUSE7_lotreeldoant0_0_0->addItem("5", "4'b0101", "1.263V");
  a_FCSI_EFUSE7_lotreeldoant0_0_0->addItem("4", "4'b0100", "1.254V");
  a_FCSI_EFUSE7_lotreeldoant0_0_0->addItem("3", "4'b0011", "1.244V");
  a_FCSI_EFUSE7_lotreeldoant0_0_0->addItem("2", "4'b0010", "1.234V");
  a_FCSI_EFUSE7_lotreeldoant0_0_0->addItem("1", "4'b0001", "1.225V");
  a_FCSI_EFUSE7_lotreeldoant0_0_0->addItem("0", "4'b0000", "1.215V");
  a_FCSI_EFUSE7_lotreeldoant0_0_0->addItem("15", "4'b1111", "1.205V");
  a_FCSI_EFUSE7_lotreeldoant0_0_0->addItem("14", "4'b1110", "1.195V");
  a_FCSI_EFUSE7_lotreeldoant0_0_0->addItem("13", "4'b1101", "1.186V");
  a_FCSI_EFUSE7_lotreeldoant0_0_0->addItem("12", "4'b1100", "1.176V");
  a_FCSI_EFUSE7_lotreeldoant0_0_0->addItem("11", "4'b1011", "1.166V");
  a_FCSI_EFUSE7_lotreeldoant0_0_0->addItem("10", "4'b1010", "1.157V");
  a_FCSI_EFUSE7_lotreeldoant0_0_0->addItem("9", "4'b1001", "1.147V");
  a_FCSI_EFUSE7_lotreeldoant0_0_0->addItem("8", "4'b1000", "1.137V");
  f_FCSI_EFUSE7_lotreeldoant0->connectAttribute (a_FCSI_EFUSE7_lotreeldoant0_0_0);

  RField* f_FCSI_EFUSE7_lotreeldoant1 = new RField;
  f_FCSI_EFUSE7_lotreeldoant1->setInstName ("lotreeldoant1");
  f_FCSI_EFUSE7_lotreeldoant1->setLongName ("LOTREELDOANT1");
  f_FCSI_EFUSE7_lotreeldoant1->setDescription ("Control output voltage of LOTREELDOANT1");
  f_FCSI_EFUSE7_lotreeldoant1->setDataWidth (4);
  f_FCSI_EFUSE7_lotreeldoant1->setResetVal ("4'b0000");
  f_FCSI_EFUSE7_lotreeldoant1->setAccProp (AccProp::R);
  r_FCSI_EFUSE7->connectRField (f_FCSI_EFUSE7_lotreeldoant1, 4);

  Attribute* a_FCSI_EFUSE7_lotreeldoant1_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_EFUSE7_lotreeldoant1_0_0->setInstName ("0");
  a_FCSI_EFUSE7_lotreeldoant1_0_0->setLongName ("");
  a_FCSI_EFUSE7_lotreeldoant1_0_0->setDescription ("");
  a_FCSI_EFUSE7_lotreeldoant1_0_0->addItem("7", "4'b0111", "1.283V");
  a_FCSI_EFUSE7_lotreeldoant1_0_0->addItem("6", "4'b0110", "1.273V");
  a_FCSI_EFUSE7_lotreeldoant1_0_0->addItem("5", "4'b0101", "1.263V");
  a_FCSI_EFUSE7_lotreeldoant1_0_0->addItem("4", "4'b0100", "1.254V");
  a_FCSI_EFUSE7_lotreeldoant1_0_0->addItem("3", "4'b0011", "1.244V");
  a_FCSI_EFUSE7_lotreeldoant1_0_0->addItem("2", "4'b0010", "1.234V");
  a_FCSI_EFUSE7_lotreeldoant1_0_0->addItem("1", "4'b0001", "1.225V");
  a_FCSI_EFUSE7_lotreeldoant1_0_0->addItem("0", "4'b0000", "1.215V");
  a_FCSI_EFUSE7_lotreeldoant1_0_0->addItem("15", "4'b1111", "1.205V");
  a_FCSI_EFUSE7_lotreeldoant1_0_0->addItem("14", "4'b1110", "1.195V");
  a_FCSI_EFUSE7_lotreeldoant1_0_0->addItem("13", "4'b1101", "1.186V");
  a_FCSI_EFUSE7_lotreeldoant1_0_0->addItem("12", "4'b1100", "1.176V");
  a_FCSI_EFUSE7_lotreeldoant1_0_0->addItem("11", "4'b1011", "1.166V");
  a_FCSI_EFUSE7_lotreeldoant1_0_0->addItem("10", "4'b1010", "1.157V");
  a_FCSI_EFUSE7_lotreeldoant1_0_0->addItem("9", "4'b1001", "1.147V");
  a_FCSI_EFUSE7_lotreeldoant1_0_0->addItem("8", "4'b1000", "1.137V");
  f_FCSI_EFUSE7_lotreeldoant1->connectAttribute (a_FCSI_EFUSE7_lotreeldoant1_0_0);

  RField* f_FCSI_EFUSE7_lotreeldoant2 = new RField;
  f_FCSI_EFUSE7_lotreeldoant2->setInstName ("lotreeldoant2");
  f_FCSI_EFUSE7_lotreeldoant2->setLongName ("LOTREELDOANT2");
  f_FCSI_EFUSE7_lotreeldoant2->setDescription ("Control output voltage of LOTREELDOANT2");
  f_FCSI_EFUSE7_lotreeldoant2->setDataWidth (4);
  f_FCSI_EFUSE7_lotreeldoant2->setResetVal ("4'b0000");
  f_FCSI_EFUSE7_lotreeldoant2->setAccProp (AccProp::R);
  r_FCSI_EFUSE7->connectRField (f_FCSI_EFUSE7_lotreeldoant2, 8);

  Attribute* a_FCSI_EFUSE7_lotreeldoant2_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_EFUSE7_lotreeldoant2_0_0->setInstName ("0");
  a_FCSI_EFUSE7_lotreeldoant2_0_0->setLongName ("");
  a_FCSI_EFUSE7_lotreeldoant2_0_0->setDescription ("");
  a_FCSI_EFUSE7_lotreeldoant2_0_0->addItem("7", "4'b0111", "1.283V");
  a_FCSI_EFUSE7_lotreeldoant2_0_0->addItem("6", "4'b0110", "1.273V");
  a_FCSI_EFUSE7_lotreeldoant2_0_0->addItem("5", "4'b0101", "1.263V");
  a_FCSI_EFUSE7_lotreeldoant2_0_0->addItem("4", "4'b0100", "1.254V");
  a_FCSI_EFUSE7_lotreeldoant2_0_0->addItem("3", "4'b0011", "1.244V");
  a_FCSI_EFUSE7_lotreeldoant2_0_0->addItem("2", "4'b0010", "1.234V");
  a_FCSI_EFUSE7_lotreeldoant2_0_0->addItem("1", "4'b0001", "1.225V");
  a_FCSI_EFUSE7_lotreeldoant2_0_0->addItem("0", "4'b0000", "1.215V");
  a_FCSI_EFUSE7_lotreeldoant2_0_0->addItem("15", "4'b1111", "1.205V");
  a_FCSI_EFUSE7_lotreeldoant2_0_0->addItem("14", "4'b1110", "1.195V");
  a_FCSI_EFUSE7_lotreeldoant2_0_0->addItem("13", "4'b1101", "1.186V");
  a_FCSI_EFUSE7_lotreeldoant2_0_0->addItem("12", "4'b1100", "1.176V");
  a_FCSI_EFUSE7_lotreeldoant2_0_0->addItem("11", "4'b1011", "1.166V");
  a_FCSI_EFUSE7_lotreeldoant2_0_0->addItem("10", "4'b1010", "1.157V");
  a_FCSI_EFUSE7_lotreeldoant2_0_0->addItem("9", "4'b1001", "1.147V");
  a_FCSI_EFUSE7_lotreeldoant2_0_0->addItem("8", "4'b1000", "1.137V");
  f_FCSI_EFUSE7_lotreeldoant2->connectAttribute (a_FCSI_EFUSE7_lotreeldoant2_0_0);

  RField* f_FCSI_EFUSE7_lotreeldoant3 = new RField;
  f_FCSI_EFUSE7_lotreeldoant3->setInstName ("lotreeldoant3");
  f_FCSI_EFUSE7_lotreeldoant3->setLongName ("LOTREELDOANT3");
  f_FCSI_EFUSE7_lotreeldoant3->setDescription ("Control output voltage of LOTREELDOANT3");
  f_FCSI_EFUSE7_lotreeldoant3->setDataWidth (4);
  f_FCSI_EFUSE7_lotreeldoant3->setResetVal ("4'b0000");
  f_FCSI_EFUSE7_lotreeldoant3->setAccProp (AccProp::R);
  r_FCSI_EFUSE7->connectRField (f_FCSI_EFUSE7_lotreeldoant3, 12);

  Attribute* a_FCSI_EFUSE7_lotreeldoant3_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_EFUSE7_lotreeldoant3_0_0->setInstName ("0");
  a_FCSI_EFUSE7_lotreeldoant3_0_0->setLongName ("");
  a_FCSI_EFUSE7_lotreeldoant3_0_0->setDescription ("");
  a_FCSI_EFUSE7_lotreeldoant3_0_0->addItem("7", "4'b0111", "1.283V");
  a_FCSI_EFUSE7_lotreeldoant3_0_0->addItem("6", "4'b0110", "1.273V");
  a_FCSI_EFUSE7_lotreeldoant3_0_0->addItem("5", "4'b0101", "1.263V");
  a_FCSI_EFUSE7_lotreeldoant3_0_0->addItem("4", "4'b0100", "1.254V");
  a_FCSI_EFUSE7_lotreeldoant3_0_0->addItem("3", "4'b0011", "1.244V");
  a_FCSI_EFUSE7_lotreeldoant3_0_0->addItem("2", "4'b0010", "1.234V");
  a_FCSI_EFUSE7_lotreeldoant3_0_0->addItem("1", "4'b0001", "1.225V");
  a_FCSI_EFUSE7_lotreeldoant3_0_0->addItem("0", "4'b0000", "1.215V");
  a_FCSI_EFUSE7_lotreeldoant3_0_0->addItem("15", "4'b1111", "1.205V");
  a_FCSI_EFUSE7_lotreeldoant3_0_0->addItem("14", "4'b1110", "1.195V");
  a_FCSI_EFUSE7_lotreeldoant3_0_0->addItem("13", "4'b1101", "1.186V");
  a_FCSI_EFUSE7_lotreeldoant3_0_0->addItem("12", "4'b1100", "1.176V");
  a_FCSI_EFUSE7_lotreeldoant3_0_0->addItem("11", "4'b1011", "1.166V");
  a_FCSI_EFUSE7_lotreeldoant3_0_0->addItem("10", "4'b1010", "1.157V");
  a_FCSI_EFUSE7_lotreeldoant3_0_0->addItem("9", "4'b1001", "1.147V");
  a_FCSI_EFUSE7_lotreeldoant3_0_0->addItem("8", "4'b1000", "1.137V");
  f_FCSI_EFUSE7_lotreeldoant3->connectAttribute (a_FCSI_EFUSE7_lotreeldoant3_0_0);

  Register* r_FCSI_EFUSE8 = new Register;
  r_FCSI_EFUSE8->setInstName ("EFUSE8");
  r_FCSI_EFUSE8->setLongName ("EFUSE8 1V2LBLOTREELDOs ANT0123");
  r_FCSI_EFUSE8->setDescription ("1V2LBLOTREELDOs of ANTENNA0123");
  r_FCSI_EFUSE8->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_EFUSE8, 0x00000038);

  RField* f_FCSI_EFUSE8_lotreeldoant0 = new RField;
  f_FCSI_EFUSE8_lotreeldoant0->setInstName ("lotreeldoant0");
  f_FCSI_EFUSE8_lotreeldoant0->setLongName ("LOTREELDOANT0");
  f_FCSI_EFUSE8_lotreeldoant0->setDescription ("Control output voltage of LOTREELDOANT0");
  f_FCSI_EFUSE8_lotreeldoant0->setDataWidth (4);
  f_FCSI_EFUSE8_lotreeldoant0->setResetVal ("4'b0000");
  f_FCSI_EFUSE8_lotreeldoant0->setAccProp (AccProp::R);
  r_FCSI_EFUSE8->connectRField (f_FCSI_EFUSE8_lotreeldoant0, 0);

  Attribute* a_FCSI_EFUSE8_lotreeldoant0_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_EFUSE8_lotreeldoant0_0_0->setInstName ("0");
  a_FCSI_EFUSE8_lotreeldoant0_0_0->setLongName ("");
  a_FCSI_EFUSE8_lotreeldoant0_0_0->setDescription ("");
  a_FCSI_EFUSE8_lotreeldoant0_0_0->addItem("7", "4'b0111", "1.283V");
  a_FCSI_EFUSE8_lotreeldoant0_0_0->addItem("6", "4'b0110", "1.273V");
  a_FCSI_EFUSE8_lotreeldoant0_0_0->addItem("5", "4'b0101", "1.263V");
  a_FCSI_EFUSE8_lotreeldoant0_0_0->addItem("4", "4'b0100", "1.254V");
  a_FCSI_EFUSE8_lotreeldoant0_0_0->addItem("3", "4'b0011", "1.244V");
  a_FCSI_EFUSE8_lotreeldoant0_0_0->addItem("2", "4'b0010", "1.234V");
  a_FCSI_EFUSE8_lotreeldoant0_0_0->addItem("1", "4'b0001", "1.225V");
  a_FCSI_EFUSE8_lotreeldoant0_0_0->addItem("0", "4'b0000", "1.215V");
  a_FCSI_EFUSE8_lotreeldoant0_0_0->addItem("15", "4'b1111", "1.205V");
  a_FCSI_EFUSE8_lotreeldoant0_0_0->addItem("14", "4'b1110", "1.195V");
  a_FCSI_EFUSE8_lotreeldoant0_0_0->addItem("13", "4'b1101", "1.186V");
  a_FCSI_EFUSE8_lotreeldoant0_0_0->addItem("12", "4'b1100", "1.176V");
  a_FCSI_EFUSE8_lotreeldoant0_0_0->addItem("11", "4'b1011", "1.166V");
  a_FCSI_EFUSE8_lotreeldoant0_0_0->addItem("10", "4'b1010", "1.157V");
  a_FCSI_EFUSE8_lotreeldoant0_0_0->addItem("9", "4'b1001", "1.147V");
  a_FCSI_EFUSE8_lotreeldoant0_0_0->addItem("8", "4'b1000", "1.137V");
  f_FCSI_EFUSE8_lotreeldoant0->connectAttribute (a_FCSI_EFUSE8_lotreeldoant0_0_0);

  RField* f_FCSI_EFUSE8_lotreeldoant1 = new RField;
  f_FCSI_EFUSE8_lotreeldoant1->setInstName ("lotreeldoant1");
  f_FCSI_EFUSE8_lotreeldoant1->setLongName ("LOTREELDOANT1");
  f_FCSI_EFUSE8_lotreeldoant1->setDescription ("Control output voltage of LOTREELDOANT1");
  f_FCSI_EFUSE8_lotreeldoant1->setDataWidth (4);
  f_FCSI_EFUSE8_lotreeldoant1->setResetVal ("4'b0000");
  f_FCSI_EFUSE8_lotreeldoant1->setAccProp (AccProp::R);
  r_FCSI_EFUSE8->connectRField (f_FCSI_EFUSE8_lotreeldoant1, 4);

  Attribute* a_FCSI_EFUSE8_lotreeldoant1_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_EFUSE8_lotreeldoant1_0_0->setInstName ("0");
  a_FCSI_EFUSE8_lotreeldoant1_0_0->setLongName ("");
  a_FCSI_EFUSE8_lotreeldoant1_0_0->setDescription ("");
  a_FCSI_EFUSE8_lotreeldoant1_0_0->addItem("7", "4'b0111", "1.283V");
  a_FCSI_EFUSE8_lotreeldoant1_0_0->addItem("6", "4'b0110", "1.273V");
  a_FCSI_EFUSE8_lotreeldoant1_0_0->addItem("5", "4'b0101", "1.263V");
  a_FCSI_EFUSE8_lotreeldoant1_0_0->addItem("4", "4'b0100", "1.254V");
  a_FCSI_EFUSE8_lotreeldoant1_0_0->addItem("3", "4'b0011", "1.244V");
  a_FCSI_EFUSE8_lotreeldoant1_0_0->addItem("2", "4'b0010", "1.234V");
  a_FCSI_EFUSE8_lotreeldoant1_0_0->addItem("1", "4'b0001", "1.225V");
  a_FCSI_EFUSE8_lotreeldoant1_0_0->addItem("0", "4'b0000", "1.215V");
  a_FCSI_EFUSE8_lotreeldoant1_0_0->addItem("15", "4'b1111", "1.205V");
  a_FCSI_EFUSE8_lotreeldoant1_0_0->addItem("14", "4'b1110", "1.195V");
  a_FCSI_EFUSE8_lotreeldoant1_0_0->addItem("13", "4'b1101", "1.186V");
  a_FCSI_EFUSE8_lotreeldoant1_0_0->addItem("12", "4'b1100", "1.176V");
  a_FCSI_EFUSE8_lotreeldoant1_0_0->addItem("11", "4'b1011", "1.166V");
  a_FCSI_EFUSE8_lotreeldoant1_0_0->addItem("10", "4'b1010", "1.157V");
  a_FCSI_EFUSE8_lotreeldoant1_0_0->addItem("9", "4'b1001", "1.147V");
  a_FCSI_EFUSE8_lotreeldoant1_0_0->addItem("8", "4'b1000", "1.137V");
  f_FCSI_EFUSE8_lotreeldoant1->connectAttribute (a_FCSI_EFUSE8_lotreeldoant1_0_0);

  RField* f_FCSI_EFUSE8_lotreeldoant2 = new RField;
  f_FCSI_EFUSE8_lotreeldoant2->setInstName ("lotreeldoant2");
  f_FCSI_EFUSE8_lotreeldoant2->setLongName ("LOTREELDOANT2");
  f_FCSI_EFUSE8_lotreeldoant2->setDescription ("Control output voltage of LOTREELDOANT2");
  f_FCSI_EFUSE8_lotreeldoant2->setDataWidth (4);
  f_FCSI_EFUSE8_lotreeldoant2->setResetVal ("4'b0000");
  f_FCSI_EFUSE8_lotreeldoant2->setAccProp (AccProp::R);
  r_FCSI_EFUSE8->connectRField (f_FCSI_EFUSE8_lotreeldoant2, 8);

  Attribute* a_FCSI_EFUSE8_lotreeldoant2_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_EFUSE8_lotreeldoant2_0_0->setInstName ("0");
  a_FCSI_EFUSE8_lotreeldoant2_0_0->setLongName ("");
  a_FCSI_EFUSE8_lotreeldoant2_0_0->setDescription ("");
  a_FCSI_EFUSE8_lotreeldoant2_0_0->addItem("7", "4'b0111", "1.283V");
  a_FCSI_EFUSE8_lotreeldoant2_0_0->addItem("6", "4'b0110", "1.273V");
  a_FCSI_EFUSE8_lotreeldoant2_0_0->addItem("5", "4'b0101", "1.263V");
  a_FCSI_EFUSE8_lotreeldoant2_0_0->addItem("4", "4'b0100", "1.254V");
  a_FCSI_EFUSE8_lotreeldoant2_0_0->addItem("3", "4'b0011", "1.244V");
  a_FCSI_EFUSE8_lotreeldoant2_0_0->addItem("2", "4'b0010", "1.234V");
  a_FCSI_EFUSE8_lotreeldoant2_0_0->addItem("1", "4'b0001", "1.225V");
  a_FCSI_EFUSE8_lotreeldoant2_0_0->addItem("0", "4'b0000", "1.215V");
  a_FCSI_EFUSE8_lotreeldoant2_0_0->addItem("15", "4'b1111", "1.205V");
  a_FCSI_EFUSE8_lotreeldoant2_0_0->addItem("14", "4'b1110", "1.195V");
  a_FCSI_EFUSE8_lotreeldoant2_0_0->addItem("13", "4'b1101", "1.186V");
  a_FCSI_EFUSE8_lotreeldoant2_0_0->addItem("12", "4'b1100", "1.176V");
  a_FCSI_EFUSE8_lotreeldoant2_0_0->addItem("11", "4'b1011", "1.166V");
  a_FCSI_EFUSE8_lotreeldoant2_0_0->addItem("10", "4'b1010", "1.157V");
  a_FCSI_EFUSE8_lotreeldoant2_0_0->addItem("9", "4'b1001", "1.147V");
  a_FCSI_EFUSE8_lotreeldoant2_0_0->addItem("8", "4'b1000", "1.137V");
  f_FCSI_EFUSE8_lotreeldoant2->connectAttribute (a_FCSI_EFUSE8_lotreeldoant2_0_0);

  RField* f_FCSI_EFUSE8_lotreeldoant3 = new RField;
  f_FCSI_EFUSE8_lotreeldoant3->setInstName ("lotreeldoant3");
  f_FCSI_EFUSE8_lotreeldoant3->setLongName ("LOTREELDOANT3");
  f_FCSI_EFUSE8_lotreeldoant3->setDescription ("Control output voltage of LOTREELDOANT3");
  f_FCSI_EFUSE8_lotreeldoant3->setDataWidth (4);
  f_FCSI_EFUSE8_lotreeldoant3->setResetVal ("4'b0000");
  f_FCSI_EFUSE8_lotreeldoant3->setAccProp (AccProp::R);
  r_FCSI_EFUSE8->connectRField (f_FCSI_EFUSE8_lotreeldoant3, 12);

  Attribute* a_FCSI_EFUSE8_lotreeldoant3_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_EFUSE8_lotreeldoant3_0_0->setInstName ("0");
  a_FCSI_EFUSE8_lotreeldoant3_0_0->setLongName ("");
  a_FCSI_EFUSE8_lotreeldoant3_0_0->setDescription ("");
  a_FCSI_EFUSE8_lotreeldoant3_0_0->addItem("7", "4'b0111", "1.283V");
  a_FCSI_EFUSE8_lotreeldoant3_0_0->addItem("6", "4'b0110", "1.273V");
  a_FCSI_EFUSE8_lotreeldoant3_0_0->addItem("5", "4'b0101", "1.263V");
  a_FCSI_EFUSE8_lotreeldoant3_0_0->addItem("4", "4'b0100", "1.254V");
  a_FCSI_EFUSE8_lotreeldoant3_0_0->addItem("3", "4'b0011", "1.244V");
  a_FCSI_EFUSE8_lotreeldoant3_0_0->addItem("2", "4'b0010", "1.234V");
  a_FCSI_EFUSE8_lotreeldoant3_0_0->addItem("1", "4'b0001", "1.225V");
  a_FCSI_EFUSE8_lotreeldoant3_0_0->addItem("0", "4'b0000", "1.215V");
  a_FCSI_EFUSE8_lotreeldoant3_0_0->addItem("15", "4'b1111", "1.205V");
  a_FCSI_EFUSE8_lotreeldoant3_0_0->addItem("14", "4'b1110", "1.195V");
  a_FCSI_EFUSE8_lotreeldoant3_0_0->addItem("13", "4'b1101", "1.186V");
  a_FCSI_EFUSE8_lotreeldoant3_0_0->addItem("12", "4'b1100", "1.176V");
  a_FCSI_EFUSE8_lotreeldoant3_0_0->addItem("11", "4'b1011", "1.166V");
  a_FCSI_EFUSE8_lotreeldoant3_0_0->addItem("10", "4'b1010", "1.157V");
  a_FCSI_EFUSE8_lotreeldoant3_0_0->addItem("9", "4'b1001", "1.147V");
  a_FCSI_EFUSE8_lotreeldoant3_0_0->addItem("8", "4'b1000", "1.137V");
  f_FCSI_EFUSE8_lotreeldoant3->connectAttribute (a_FCSI_EFUSE8_lotreeldoant3_0_0);

  Register* r_FCSI_EFUSE9 = new Register;
  r_FCSI_EFUSE9->setInstName ("EFUSE9");
  r_FCSI_EFUSE9->setLongName ("EFUSE9 1V2BBOLDO, 2V5FSYSLDO, 1V2FCSILDO, LB LNA MID2HIGH FOR 2 ANT");
  r_FCSI_EFUSE9->setDescription ("BBOLDO + FSYSLDO + FCSILDO + LB LNA MID2HIGH");
  r_FCSI_EFUSE9->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_EFUSE9, 0x00000039);

  RField* f_FCSI_EFUSE9_ctl_vout_bboldo = new RField;
  f_FCSI_EFUSE9_ctl_vout_bboldo->setInstName ("ctl_vout_bboldo");
  f_FCSI_EFUSE9_ctl_vout_bboldo->setLongName ("CTL VOUT BBO LDO");
  f_FCSI_EFUSE9_ctl_vout_bboldo->setDescription ("Control output voltage of BBO LDO");
  f_FCSI_EFUSE9_ctl_vout_bboldo->setDataWidth (4);
  f_FCSI_EFUSE9_ctl_vout_bboldo->setResetVal ("4'b0000");
  f_FCSI_EFUSE9_ctl_vout_bboldo->setAccProp (AccProp::RW);
  r_FCSI_EFUSE9->connectRField (f_FCSI_EFUSE9_ctl_vout_bboldo, 0);

  Attribute* a_FCSI_EFUSE9_ctl_vout_bboldo_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_EFUSE9_ctl_vout_bboldo_0_0->setInstName ("0");
  a_FCSI_EFUSE9_ctl_vout_bboldo_0_0->setLongName ("");
  a_FCSI_EFUSE9_ctl_vout_bboldo_0_0->setDescription ("");
  a_FCSI_EFUSE9_ctl_vout_bboldo_0_0->addItem("15", "4'b1111", "1.37V");
  a_FCSI_EFUSE9_ctl_vout_bboldo_0_0->addItem("14", "4'b1110", "1.36V");
  a_FCSI_EFUSE9_ctl_vout_bboldo_0_0->addItem("13", "4'b1101", "1.35V");
  a_FCSI_EFUSE9_ctl_vout_bboldo_0_0->addItem("12", "4'b1100", "1.34V");
  a_FCSI_EFUSE9_ctl_vout_bboldo_0_0->addItem("11", "4'b1011", "1.33V");
  a_FCSI_EFUSE9_ctl_vout_bboldo_0_0->addItem("10", "4'b1010", "1.32V");
  a_FCSI_EFUSE9_ctl_vout_bboldo_0_0->addItem("9", "4'b1001", "1.31V");
  a_FCSI_EFUSE9_ctl_vout_bboldo_0_0->addItem("8", "4'b1000", "1.30V");
  a_FCSI_EFUSE9_ctl_vout_bboldo_0_0->addItem("7", "4'b0111", "1.29V");
  a_FCSI_EFUSE9_ctl_vout_bboldo_0_0->addItem("6", "4'b0110", "1.28V");
  a_FCSI_EFUSE9_ctl_vout_bboldo_0_0->addItem("5", "4'b0101", "1.27V");
  a_FCSI_EFUSE9_ctl_vout_bboldo_0_0->addItem("4", "4'b0100", "1.26V");
  a_FCSI_EFUSE9_ctl_vout_bboldo_0_0->addItem("3", "4'b0011", "1.25V");
  a_FCSI_EFUSE9_ctl_vout_bboldo_0_0->addItem("2", "4'b0010", "1.24V");
  a_FCSI_EFUSE9_ctl_vout_bboldo_0_0->addItem("1", "4'b0001", "1.23V");
  a_FCSI_EFUSE9_ctl_vout_bboldo_0_0->addItem("0", "4'b0000", "1.22V");
  f_FCSI_EFUSE9_ctl_vout_bboldo->connectAttribute (a_FCSI_EFUSE9_ctl_vout_bboldo_0_0);

  RField* f_FCSI_EFUSE9_ctl_vout_fsysldo = new RField;
  f_FCSI_EFUSE9_ctl_vout_fsysldo->setInstName ("ctl_vout_fsysldo");
  f_FCSI_EFUSE9_ctl_vout_fsysldo->setLongName ("CTL VOUT FSYS LDO");
  f_FCSI_EFUSE9_ctl_vout_fsysldo->setDescription ("Control output voltage of FSYS LDO");
  f_FCSI_EFUSE9_ctl_vout_fsysldo->setDataWidth (4);
  f_FCSI_EFUSE9_ctl_vout_fsysldo->setResetVal ("4'b0000");
  f_FCSI_EFUSE9_ctl_vout_fsysldo->setAccProp (AccProp::RW);
  r_FCSI_EFUSE9->connectRField (f_FCSI_EFUSE9_ctl_vout_fsysldo, 4);

  Attribute* a_FCSI_EFUSE9_ctl_vout_fsysldo_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_EFUSE9_ctl_vout_fsysldo_0_0->setInstName ("0");
  a_FCSI_EFUSE9_ctl_vout_fsysldo_0_0->setLongName ("");
  a_FCSI_EFUSE9_ctl_vout_fsysldo_0_0->setDescription ("");
  a_FCSI_EFUSE9_ctl_vout_fsysldo_0_0->addItem("7", "4'b0111", "2.65V");
  a_FCSI_EFUSE9_ctl_vout_fsysldo_0_0->addItem("6", "4'b0110", "2.63V");
  a_FCSI_EFUSE9_ctl_vout_fsysldo_0_0->addItem("5", "4'b0101", "2.61V");
  a_FCSI_EFUSE9_ctl_vout_fsysldo_0_0->addItem("4", "4'b0100", "2.59V");
  a_FCSI_EFUSE9_ctl_vout_fsysldo_0_0->addItem("3", "4'b0011", "2.57V");
  a_FCSI_EFUSE9_ctl_vout_fsysldo_0_0->addItem("2", "4'b0010", "2.55V");
  a_FCSI_EFUSE9_ctl_vout_fsysldo_0_0->addItem("1", "4'b0001", "2.53V");
  a_FCSI_EFUSE9_ctl_vout_fsysldo_0_0->addItem("0", "4'b0000", "2.51V");
  a_FCSI_EFUSE9_ctl_vout_fsysldo_0_0->addItem("15", "4'b1111", "2.49V");
  a_FCSI_EFUSE9_ctl_vout_fsysldo_0_0->addItem("14", "4'b1110", "2.47V");
  a_FCSI_EFUSE9_ctl_vout_fsysldo_0_0->addItem("13", "4'b1101", "2.45V");
  a_FCSI_EFUSE9_ctl_vout_fsysldo_0_0->addItem("12", "4'b1100", "2.43V");
  a_FCSI_EFUSE9_ctl_vout_fsysldo_0_0->addItem("11", "4'b1011", "2.41V");
  a_FCSI_EFUSE9_ctl_vout_fsysldo_0_0->addItem("10", "4'b1010", "2.39V");
  a_FCSI_EFUSE9_ctl_vout_fsysldo_0_0->addItem("9", "4'b1001", "2.37V");
  a_FCSI_EFUSE9_ctl_vout_fsysldo_0_0->addItem("8", "4'b1000", "2.35V");
  f_FCSI_EFUSE9_ctl_vout_fsysldo->connectAttribute (a_FCSI_EFUSE9_ctl_vout_fsysldo_0_0);

  RField* f_FCSI_EFUSE9_ctl_vout_fcsildo = new RField;
  f_FCSI_EFUSE9_ctl_vout_fcsildo->setInstName ("ctl_vout_fcsildo");
  f_FCSI_EFUSE9_ctl_vout_fcsildo->setLongName ("CTL VOUT FCSI LDO");
  f_FCSI_EFUSE9_ctl_vout_fcsildo->setDescription ("Control output voltage of FCSI LDO");
  f_FCSI_EFUSE9_ctl_vout_fcsildo->setDataWidth (4);
  f_FCSI_EFUSE9_ctl_vout_fcsildo->setResetVal ("4'b0000");
  f_FCSI_EFUSE9_ctl_vout_fcsildo->setAccProp (AccProp::RW);
  r_FCSI_EFUSE9->connectRField (f_FCSI_EFUSE9_ctl_vout_fcsildo, 8);

  Attribute* a_FCSI_EFUSE9_ctl_vout_fcsildo_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_EFUSE9_ctl_vout_fcsildo_0_0->setInstName ("0");
  a_FCSI_EFUSE9_ctl_vout_fcsildo_0_0->setLongName ("");
  a_FCSI_EFUSE9_ctl_vout_fcsildo_0_0->setDescription ("");
  a_FCSI_EFUSE9_ctl_vout_fcsildo_0_0->addItem("8", "4'b1000", "1.04V");
  a_FCSI_EFUSE9_ctl_vout_fcsildo_0_0->addItem("9", "4'b1001", "1.06V");
  a_FCSI_EFUSE9_ctl_vout_fcsildo_0_0->addItem("10", "4'b1010", "1.08V");
  a_FCSI_EFUSE9_ctl_vout_fcsildo_0_0->addItem("11", "4'b1011", "1.10V");
  a_FCSI_EFUSE9_ctl_vout_fcsildo_0_0->addItem("12", "4'b1100", "1.12V");
  a_FCSI_EFUSE9_ctl_vout_fcsildo_0_0->addItem("13", "4'b1101", "1.14V");
  a_FCSI_EFUSE9_ctl_vout_fcsildo_0_0->addItem("14", "4'b1110", "1.16V");
  a_FCSI_EFUSE9_ctl_vout_fcsildo_0_0->addItem("15", "4'b1111", "1.18V");
  a_FCSI_EFUSE9_ctl_vout_fcsildo_0_0->addItem("0", "4'b0000", "1.20V");
  a_FCSI_EFUSE9_ctl_vout_fcsildo_0_0->addItem("1", "4'b0001", "1.22V");
  a_FCSI_EFUSE9_ctl_vout_fcsildo_0_0->addItem("2", "4'b0010", "1.24V");
  a_FCSI_EFUSE9_ctl_vout_fcsildo_0_0->addItem("3", "4'b0011", "1.26V");
  a_FCSI_EFUSE9_ctl_vout_fcsildo_0_0->addItem("4", "4'b0100", "1.28V");
  a_FCSI_EFUSE9_ctl_vout_fcsildo_0_0->addItem("5", "4'b0101", "1.30V");
  a_FCSI_EFUSE9_ctl_vout_fcsildo_0_0->addItem("6", "4'b0110", "1.32V");
  a_FCSI_EFUSE9_ctl_vout_fcsildo_0_0->addItem("7", "4'b0111", "1.34V");
  f_FCSI_EFUSE9_ctl_vout_fcsildo->connectAttribute (a_FCSI_EFUSE9_ctl_vout_fcsildo_0_0);

  RField* f_FCSI_EFUSE9_lb_lna_mid2high_ant01 = new RField;
  f_FCSI_EFUSE9_lb_lna_mid2high_ant01->setInstName ("lb_lna_mid2high_ant01");
  f_FCSI_EFUSE9_lb_lna_mid2high_ant01->setLongName ("LB LNA MID2HIGH ANT01");
  f_FCSI_EFUSE9_lb_lna_mid2high_ant01->setDescription ("LB LNA MID2HIGH ANT01");
  f_FCSI_EFUSE9_lb_lna_mid2high_ant01->setDataWidth (2);
  f_FCSI_EFUSE9_lb_lna_mid2high_ant01->setResetVal ("2'b00");
  f_FCSI_EFUSE9_lb_lna_mid2high_ant01->setAccProp (AccProp::RW);
  r_FCSI_EFUSE9->connectRField (f_FCSI_EFUSE9_lb_lna_mid2high_ant01, 12);

  Attribute* a_FCSI_EFUSE9_lb_lna_mid2high_ant01_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_EFUSE9_lb_lna_mid2high_ant01_0_0->setInstName ("0");
  a_FCSI_EFUSE9_lb_lna_mid2high_ant01_0_0->setLongName ("");
  a_FCSI_EFUSE9_lb_lna_mid2high_ant01_0_0->setDescription ("");
  a_FCSI_EFUSE9_lb_lna_mid2high_ant01_0_0->addItem("0", "2'b00", "xx");
  a_FCSI_EFUSE9_lb_lna_mid2high_ant01_0_0->addItem("1", "2'b01", "xx");
  a_FCSI_EFUSE9_lb_lna_mid2high_ant01_0_0->addItem("2", "2'b10", "xx");
  a_FCSI_EFUSE9_lb_lna_mid2high_ant01_0_0->addItem("3", "2'b11", "xx");
  f_FCSI_EFUSE9_lb_lna_mid2high_ant01->connectAttribute (a_FCSI_EFUSE9_lb_lna_mid2high_ant01_0_0);

  RField* f_FCSI_EFUSE9_lb_lna_mid2high_ant23 = new RField;
  f_FCSI_EFUSE9_lb_lna_mid2high_ant23->setInstName ("lb_lna_mid2high_ant23");
  f_FCSI_EFUSE9_lb_lna_mid2high_ant23->setLongName ("LB LNA MID2HIGH ANT23");
  f_FCSI_EFUSE9_lb_lna_mid2high_ant23->setDescription ("LB LNA MID2HIGH ANT23");
  f_FCSI_EFUSE9_lb_lna_mid2high_ant23->setDataWidth (2);
  f_FCSI_EFUSE9_lb_lna_mid2high_ant23->setResetVal ("2'b00");
  f_FCSI_EFUSE9_lb_lna_mid2high_ant23->setAccProp (AccProp::RW);
  r_FCSI_EFUSE9->connectRField (f_FCSI_EFUSE9_lb_lna_mid2high_ant23, 14);

  Attribute* a_FCSI_EFUSE9_lb_lna_mid2high_ant23_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_EFUSE9_lb_lna_mid2high_ant23_0_0->setInstName ("0");
  a_FCSI_EFUSE9_lb_lna_mid2high_ant23_0_0->setLongName ("");
  a_FCSI_EFUSE9_lb_lna_mid2high_ant23_0_0->setDescription ("");
  a_FCSI_EFUSE9_lb_lna_mid2high_ant23_0_0->addItem("0", "2'b00", "xx");
  a_FCSI_EFUSE9_lb_lna_mid2high_ant23_0_0->addItem("1", "2'b01", "xx");
  a_FCSI_EFUSE9_lb_lna_mid2high_ant23_0_0->addItem("2", "2'b10", "xx");
  a_FCSI_EFUSE9_lb_lna_mid2high_ant23_0_0->addItem("3", "2'b11", "xx");
  f_FCSI_EFUSE9_lb_lna_mid2high_ant23->connectAttribute (a_FCSI_EFUSE9_lb_lna_mid2high_ant23_0_0);

  Register* r_FCSI_EFUSE10 = new Register;
  r_FCSI_EFUSE10->setInstName ("EFUSE10");
  r_FCSI_EFUSE10->setLongName ("EFUSE10 HB LNA DELTA MID2HIGH FOR 2 ANT, FILTER TPC40, BGP BIAS TRIM");
  r_FCSI_EFUSE10->setDescription ("HB LNA MID + FILTER TPC40 + BGP BIAS TRIM");
  r_FCSI_EFUSE10->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_EFUSE10, 0x0000003A);

  RField* f_FCSI_EFUSE10_hb_lna_mid2high_ant01 = new RField;
  f_FCSI_EFUSE10_hb_lna_mid2high_ant01->setInstName ("hb_lna_mid2high_ant01");
  f_FCSI_EFUSE10_hb_lna_mid2high_ant01->setLongName ("HB LNA MID2HIGH ANT01");
  f_FCSI_EFUSE10_hb_lna_mid2high_ant01->setDescription ("HB LNA MID2HIGH ANT01");
  f_FCSI_EFUSE10_hb_lna_mid2high_ant01->setDataWidth (2);
  f_FCSI_EFUSE10_hb_lna_mid2high_ant01->setResetVal ("2'b00");
  f_FCSI_EFUSE10_hb_lna_mid2high_ant01->setAccProp (AccProp::RW);
  r_FCSI_EFUSE10->connectRField (f_FCSI_EFUSE10_hb_lna_mid2high_ant01, 0);

  Attribute* a_FCSI_EFUSE10_hb_lna_mid2high_ant01_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_EFUSE10_hb_lna_mid2high_ant01_0_0->setInstName ("0");
  a_FCSI_EFUSE10_hb_lna_mid2high_ant01_0_0->setLongName ("");
  a_FCSI_EFUSE10_hb_lna_mid2high_ant01_0_0->setDescription ("");
  a_FCSI_EFUSE10_hb_lna_mid2high_ant01_0_0->addItem("0", "2'b00", "xx");
  a_FCSI_EFUSE10_hb_lna_mid2high_ant01_0_0->addItem("1", "2'b01", "xx");
  a_FCSI_EFUSE10_hb_lna_mid2high_ant01_0_0->addItem("2", "2'b10", "xx");
  a_FCSI_EFUSE10_hb_lna_mid2high_ant01_0_0->addItem("3", "2'b11", "xx");
  f_FCSI_EFUSE10_hb_lna_mid2high_ant01->connectAttribute (a_FCSI_EFUSE10_hb_lna_mid2high_ant01_0_0);

  RField* f_FCSI_EFUSE10_hb_lna_mid2high_ant23 = new RField;
  f_FCSI_EFUSE10_hb_lna_mid2high_ant23->setInstName ("hb_lna_mid2high_ant23");
  f_FCSI_EFUSE10_hb_lna_mid2high_ant23->setLongName ("HB LNA MID2HIGH ANT23");
  f_FCSI_EFUSE10_hb_lna_mid2high_ant23->setDescription ("HB LNA MID2HIGH ANT23");
  f_FCSI_EFUSE10_hb_lna_mid2high_ant23->setDataWidth (2);
  f_FCSI_EFUSE10_hb_lna_mid2high_ant23->setResetVal ("2'b00");
  f_FCSI_EFUSE10_hb_lna_mid2high_ant23->setAccProp (AccProp::RW);
  r_FCSI_EFUSE10->connectRField (f_FCSI_EFUSE10_hb_lna_mid2high_ant23, 2);

  Attribute* a_FCSI_EFUSE10_hb_lna_mid2high_ant23_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_EFUSE10_hb_lna_mid2high_ant23_0_0->setInstName ("0");
  a_FCSI_EFUSE10_hb_lna_mid2high_ant23_0_0->setLongName ("");
  a_FCSI_EFUSE10_hb_lna_mid2high_ant23_0_0->setDescription ("");
  a_FCSI_EFUSE10_hb_lna_mid2high_ant23_0_0->addItem("0", "2'b00", "xx");
  a_FCSI_EFUSE10_hb_lna_mid2high_ant23_0_0->addItem("1", "2'b01", "xx");
  a_FCSI_EFUSE10_hb_lna_mid2high_ant23_0_0->addItem("2", "2'b10", "xx");
  a_FCSI_EFUSE10_hb_lna_mid2high_ant23_0_0->addItem("3", "2'b11", "xx");
  f_FCSI_EFUSE10_hb_lna_mid2high_ant23->connectAttribute (a_FCSI_EFUSE10_hb_lna_mid2high_ant23_0_0);

  RField* f_FCSI_EFUSE10_ctl_tpc_fb_csel_40MHz = new RField;
  f_FCSI_EFUSE10_ctl_tpc_fb_csel_40MHz->setInstName ("ctl_tpc_fb_csel_40MHz");
  f_FCSI_EFUSE10_ctl_tpc_fb_csel_40MHz->setLongName ("CTL TPC FB CSEL 40MHz");
  f_FCSI_EFUSE10_ctl_tpc_fb_csel_40MHz->setDescription ("Control TPC feedback capacitor (binary coded) 40MHz BW");
  f_FCSI_EFUSE10_ctl_tpc_fb_csel_40MHz->setDataWidth (7);
  f_FCSI_EFUSE10_ctl_tpc_fb_csel_40MHz->setResetVal ("7'b0000000");
  f_FCSI_EFUSE10_ctl_tpc_fb_csel_40MHz->setAccProp (AccProp::RW);
  r_FCSI_EFUSE10->connectRField (f_FCSI_EFUSE10_ctl_tpc_fb_csel_40MHz, 4);

  Attribute* a_FCSI_EFUSE10_ctl_tpc_fb_csel_40MHz_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_EFUSE10_ctl_tpc_fb_csel_40MHz_0_0->setInstName ("0");
  a_FCSI_EFUSE10_ctl_tpc_fb_csel_40MHz_0_0->setLongName ("");
  a_FCSI_EFUSE10_ctl_tpc_fb_csel_40MHz_0_0->setDescription ("");
  a_FCSI_EFUSE10_ctl_tpc_fb_csel_40MHz_0_0->addItem("0", "7'b0000000", " 0pF");
  a_FCSI_EFUSE10_ctl_tpc_fb_csel_40MHz_0_0->addItem("1", "7'b0000001", "25fF");
  a_FCSI_EFUSE10_ctl_tpc_fb_csel_40MHz_0_0->addItem("15", "7'b0010000", "400fF (default)");
  a_FCSI_EFUSE10_ctl_tpc_fb_csel_40MHz_0_0->addItem("127", "7'b1111111", "3.175pF");
  f_FCSI_EFUSE10_ctl_tpc_fb_csel_40MHz->connectAttribute (a_FCSI_EFUSE10_ctl_tpc_fb_csel_40MHz_0_0);

  RField* f_FCSI_EFUSE10_ctl_cal_iconst = new RField;
  f_FCSI_EFUSE10_ctl_cal_iconst->setInstName ("ctl_cal_iconst");
  f_FCSI_EFUSE10_ctl_cal_iconst->setLongName ("CTL CAL ICONST");
  f_FCSI_EFUSE10_ctl_cal_iconst->setDescription ("Calibration Iconst");
  f_FCSI_EFUSE10_ctl_cal_iconst->setDataWidth (5);
  f_FCSI_EFUSE10_ctl_cal_iconst->setResetVal ("5'b00000");
  f_FCSI_EFUSE10_ctl_cal_iconst->setAccProp (AccProp::R);
  r_FCSI_EFUSE10->connectRField (f_FCSI_EFUSE10_ctl_cal_iconst, 11);

  Attribute* a_FCSI_EFUSE10_ctl_cal_iconst_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_EFUSE10_ctl_cal_iconst_0_0->setInstName ("0");
  a_FCSI_EFUSE10_ctl_cal_iconst_0_0->setLongName ("");
  a_FCSI_EFUSE10_ctl_cal_iconst_0_0->setDescription ("");
  a_FCSI_EFUSE10_ctl_cal_iconst_0_0->addItem("0", "5'b00000", "230uA");
  a_FCSI_EFUSE10_ctl_cal_iconst_0_0->addItem("1", "5'b00001", "228uA");
  a_FCSI_EFUSE10_ctl_cal_iconst_0_0->addItem("2", "5'b00010", "226uA");
  a_FCSI_EFUSE10_ctl_cal_iconst_0_0->addItem("3", "5'b00011", "224uA");
  a_FCSI_EFUSE10_ctl_cal_iconst_0_0->addItem("4", "5'b00100", "222uA");
  a_FCSI_EFUSE10_ctl_cal_iconst_0_0->addItem("5", "5'b00101", "220uA");
  a_FCSI_EFUSE10_ctl_cal_iconst_0_0->addItem("6", "5'b00110", "218uA");
  a_FCSI_EFUSE10_ctl_cal_iconst_0_0->addItem("7", "5'b00111", "216uA");
  a_FCSI_EFUSE10_ctl_cal_iconst_0_0->addItem("8", "5'b01000", "214uA");
  a_FCSI_EFUSE10_ctl_cal_iconst_0_0->addItem("9", "5'b01001", "212uA");
  a_FCSI_EFUSE10_ctl_cal_iconst_0_0->addItem("10", "5'b01010", "210uA");
  a_FCSI_EFUSE10_ctl_cal_iconst_0_0->addItem("11", "5'b01011", "208uA");
  a_FCSI_EFUSE10_ctl_cal_iconst_0_0->addItem("12", "5'b01100", "206uA");
  a_FCSI_EFUSE10_ctl_cal_iconst_0_0->addItem("13", "5'b01101", "204uA");
  a_FCSI_EFUSE10_ctl_cal_iconst_0_0->addItem("14", "5'b01110", "202uA");
  a_FCSI_EFUSE10_ctl_cal_iconst_0_0->addItem("15", "5'b01111", "200uA");
  a_FCSI_EFUSE10_ctl_cal_iconst_0_0->addItem("16", "5'b10000", "198uA");
  a_FCSI_EFUSE10_ctl_cal_iconst_0_0->addItem("17", "5'b10001", "196uA");
  a_FCSI_EFUSE10_ctl_cal_iconst_0_0->addItem("18", "5'b10010", "194uA");
  a_FCSI_EFUSE10_ctl_cal_iconst_0_0->addItem("19", "5'b10011", "192uA");
  a_FCSI_EFUSE10_ctl_cal_iconst_0_0->addItem("20", "5'b10100", "190uA");
  a_FCSI_EFUSE10_ctl_cal_iconst_0_0->addItem("21", "5'b10101", "188uA");
  a_FCSI_EFUSE10_ctl_cal_iconst_0_0->addItem("22", "5'b10110", "186uA");
  a_FCSI_EFUSE10_ctl_cal_iconst_0_0->addItem("23", "5'b10111", "184uA");
  a_FCSI_EFUSE10_ctl_cal_iconst_0_0->addItem("24", "5'b11000", "182uA");
  a_FCSI_EFUSE10_ctl_cal_iconst_0_0->addItem("25", "5'b11001", "180uA");
  a_FCSI_EFUSE10_ctl_cal_iconst_0_0->addItem("26", "5'b11010", "178uA");
  a_FCSI_EFUSE10_ctl_cal_iconst_0_0->addItem("27", "5'b11011", "176uA");
  a_FCSI_EFUSE10_ctl_cal_iconst_0_0->addItem("28", "5'b11100", "174uA");
  a_FCSI_EFUSE10_ctl_cal_iconst_0_0->addItem("29", "5'b11101", "172uA");
  a_FCSI_EFUSE10_ctl_cal_iconst_0_0->addItem("30", "5'b11110", "170uA");
  a_FCSI_EFUSE10_ctl_cal_iconst_0_0->addItem("31", "5'b11111", "168uA");
  f_FCSI_EFUSE10_ctl_cal_iconst->connectAttribute (a_FCSI_EFUSE10_ctl_cal_iconst_0_0);

  Register* r_FCSI_EFUSE11 = new Register;
  r_FCSI_EFUSE11->setInstName ("EFUSE11");
  r_FCSI_EFUSE11->setLongName ("EFUSE11 TMP SENSOR RESULT, PROCESS CAL WORD");
  r_FCSI_EFUSE11->setDescription ("TEMPERATURE SENSOR result and PROCESS CALIBRATION word");
  r_FCSI_EFUSE11->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_EFUSE11, 0x0000003B);

  RField* f_FCSI_EFUSE11_tempsensorresult = new RField;
  f_FCSI_EFUSE11_tempsensorresult->setInstName ("tempsensorresult");
  f_FCSI_EFUSE11_tempsensorresult->setLongName ("TEMP SENSOR RESULT");
  f_FCSI_EFUSE11_tempsensorresult->setDescription ("Temperature sensor result");
  f_FCSI_EFUSE11_tempsensorresult->setDataWidth (11);
  f_FCSI_EFUSE11_tempsensorresult->setResetVal ("11'b00000000000");
  f_FCSI_EFUSE11_tempsensorresult->setAccProp (AccProp::R);
  r_FCSI_EFUSE11->connectRField (f_FCSI_EFUSE11_tempsensorresult, 0);

  RField* f_FCSI_EFUSE11_processcal = new RField;
  f_FCSI_EFUSE11_processcal->setInstName ("processcal");
  f_FCSI_EFUSE11_processcal->setLongName ("PROCESS CALIBRATION");
  f_FCSI_EFUSE11_processcal->setDescription ("Process calibration word");
  f_FCSI_EFUSE11_processcal->setDataWidth (5);
  f_FCSI_EFUSE11_processcal->setResetVal ("5'b00000");
  f_FCSI_EFUSE11_processcal->setAccProp (AccProp::R);
  r_FCSI_EFUSE11->connectRField (f_FCSI_EFUSE11_processcal, 11);

  Register* r_FCSI_EFUSE12 = new Register;
  r_FCSI_EFUSE12->setInstName ("EFUSE12");
  r_FCSI_EFUSE12->setLongName ("EFUSE12 BAND SELECTION");
  r_FCSI_EFUSE12->setDescription ("EFUSE BAND selection");
  r_FCSI_EFUSE12->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_EFUSE12, 0x0000003C);

  RField* f_FCSI_EFUSE12_rxhbbandselection_ch0 = new RField;
  f_FCSI_EFUSE12_rxhbbandselection_ch0->setInstName ("rxhbbandselection_ch0");
  f_FCSI_EFUSE12_rxhbbandselection_ch0->setLongName ("RX HB BAND SELECTION CH0");
  f_FCSI_EFUSE12_rxhbbandselection_ch0->setDescription ("RX HB Band selection for channel 0 (2's complement)");
  f_FCSI_EFUSE12_rxhbbandselection_ch0->setDataWidth (2);
  f_FCSI_EFUSE12_rxhbbandselection_ch0->setResetVal ("2'b00");
  f_FCSI_EFUSE12_rxhbbandselection_ch0->setAccProp (AccProp::R);
  r_FCSI_EFUSE12->connectRField (f_FCSI_EFUSE12_rxhbbandselection_ch0, 0);

  Attribute* a_FCSI_EFUSE12_rxhbbandselection_ch0_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_EFUSE12_rxhbbandselection_ch0_0_0->setInstName ("0");
  a_FCSI_EFUSE12_rxhbbandselection_ch0_0_0->setLongName ("");
  a_FCSI_EFUSE12_rxhbbandselection_ch0_0_0->setDescription ("");
  a_FCSI_EFUSE12_rxhbbandselection_ch0_0_0->addItem("0", "2'b00", "0");
  a_FCSI_EFUSE12_rxhbbandselection_ch0_0_0->addItem("1", "2'b01", "+1");
  a_FCSI_EFUSE12_rxhbbandselection_ch0_0_0->addItem("2", "2'b11", "-1");
  a_FCSI_EFUSE12_rxhbbandselection_ch0_0_0->addItem("3", "2'b10", "-2");
  f_FCSI_EFUSE12_rxhbbandselection_ch0->connectAttribute (a_FCSI_EFUSE12_rxhbbandselection_ch0_0_0);

  RField* f_FCSI_EFUSE12_rxhbbandselection_ch1 = new RField;
  f_FCSI_EFUSE12_rxhbbandselection_ch1->setInstName ("rxhbbandselection_ch1");
  f_FCSI_EFUSE12_rxhbbandselection_ch1->setLongName ("RX HB BAND SELECTION CH1");
  f_FCSI_EFUSE12_rxhbbandselection_ch1->setDescription ("RX HB Band selection for channel 1 (2's complement)");
  f_FCSI_EFUSE12_rxhbbandselection_ch1->setDataWidth (2);
  f_FCSI_EFUSE12_rxhbbandselection_ch1->setResetVal ("2'b00");
  f_FCSI_EFUSE12_rxhbbandselection_ch1->setAccProp (AccProp::R);
  r_FCSI_EFUSE12->connectRField (f_FCSI_EFUSE12_rxhbbandselection_ch1, 2);

  Attribute* a_FCSI_EFUSE12_rxhbbandselection_ch1_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_EFUSE12_rxhbbandselection_ch1_0_0->setInstName ("0");
  a_FCSI_EFUSE12_rxhbbandselection_ch1_0_0->setLongName ("");
  a_FCSI_EFUSE12_rxhbbandselection_ch1_0_0->setDescription ("");
  a_FCSI_EFUSE12_rxhbbandselection_ch1_0_0->addItem("0", "2'b00", "0");
  a_FCSI_EFUSE12_rxhbbandselection_ch1_0_0->addItem("1", "2'b01", "+1");
  a_FCSI_EFUSE12_rxhbbandselection_ch1_0_0->addItem("2", "2'b11", "-1");
  a_FCSI_EFUSE12_rxhbbandselection_ch1_0_0->addItem("3", "2'b10", "-2");
  f_FCSI_EFUSE12_rxhbbandselection_ch1->connectAttribute (a_FCSI_EFUSE12_rxhbbandselection_ch1_0_0);

  RField* f_FCSI_EFUSE12_rxhbbandselection_ch2 = new RField;
  f_FCSI_EFUSE12_rxhbbandselection_ch2->setInstName ("rxhbbandselection_ch2");
  f_FCSI_EFUSE12_rxhbbandselection_ch2->setLongName ("RX HB BAND SELECTION CH2");
  f_FCSI_EFUSE12_rxhbbandselection_ch2->setDescription ("RX HB Band selection for channel 2 (2's complement)");
  f_FCSI_EFUSE12_rxhbbandselection_ch2->setDataWidth (2);
  f_FCSI_EFUSE12_rxhbbandselection_ch2->setResetVal ("2'b00");
  f_FCSI_EFUSE12_rxhbbandselection_ch2->setAccProp (AccProp::R);
  r_FCSI_EFUSE12->connectRField (f_FCSI_EFUSE12_rxhbbandselection_ch2, 4);

  Attribute* a_FCSI_EFUSE12_rxhbbandselection_ch2_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_EFUSE12_rxhbbandselection_ch2_0_0->setInstName ("0");
  a_FCSI_EFUSE12_rxhbbandselection_ch2_0_0->setLongName ("");
  a_FCSI_EFUSE12_rxhbbandselection_ch2_0_0->setDescription ("");
  a_FCSI_EFUSE12_rxhbbandselection_ch2_0_0->addItem("0", "2'b00", "0");
  a_FCSI_EFUSE12_rxhbbandselection_ch2_0_0->addItem("1", "2'b01", "+1");
  a_FCSI_EFUSE12_rxhbbandselection_ch2_0_0->addItem("2", "2'b11", "-1");
  a_FCSI_EFUSE12_rxhbbandselection_ch2_0_0->addItem("3", "2'b10", "-2");
  f_FCSI_EFUSE12_rxhbbandselection_ch2->connectAttribute (a_FCSI_EFUSE12_rxhbbandselection_ch2_0_0);

  RField* f_FCSI_EFUSE12_txhbbandselection_ch0 = new RField;
  f_FCSI_EFUSE12_txhbbandselection_ch0->setInstName ("txhbbandselection_ch0");
  f_FCSI_EFUSE12_txhbbandselection_ch0->setLongName ("TX HB BAND SELECTION CH0");
  f_FCSI_EFUSE12_txhbbandselection_ch0->setDescription ("TX HB Band selection for channel 0 (2's complement)");
  f_FCSI_EFUSE12_txhbbandselection_ch0->setDataWidth (2);
  f_FCSI_EFUSE12_txhbbandselection_ch0->setResetVal ("2'b00");
  f_FCSI_EFUSE12_txhbbandselection_ch0->setAccProp (AccProp::R);
  r_FCSI_EFUSE12->connectRField (f_FCSI_EFUSE12_txhbbandselection_ch0, 6);

  Attribute* a_FCSI_EFUSE12_txhbbandselection_ch0_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_EFUSE12_txhbbandselection_ch0_0_0->setInstName ("0");
  a_FCSI_EFUSE12_txhbbandselection_ch0_0_0->setLongName ("");
  a_FCSI_EFUSE12_txhbbandselection_ch0_0_0->setDescription ("");
  a_FCSI_EFUSE12_txhbbandselection_ch0_0_0->addItem("0", "2'b00", "0");
  a_FCSI_EFUSE12_txhbbandselection_ch0_0_0->addItem("1", "2'b01", "+1");
  a_FCSI_EFUSE12_txhbbandselection_ch0_0_0->addItem("2", "2'b11", "-1");
  a_FCSI_EFUSE12_txhbbandselection_ch0_0_0->addItem("3", "2'b10", "-2");
  f_FCSI_EFUSE12_txhbbandselection_ch0->connectAttribute (a_FCSI_EFUSE12_txhbbandselection_ch0_0_0);

  RField* f_FCSI_EFUSE12_txhbbandselection_ch1 = new RField;
  f_FCSI_EFUSE12_txhbbandselection_ch1->setInstName ("txhbbandselection_ch1");
  f_FCSI_EFUSE12_txhbbandselection_ch1->setLongName ("TX HB BAND SELECTION CH1");
  f_FCSI_EFUSE12_txhbbandselection_ch1->setDescription ("TX HB Band selection for channel 1 (2's complement)");
  f_FCSI_EFUSE12_txhbbandselection_ch1->setDataWidth (2);
  f_FCSI_EFUSE12_txhbbandselection_ch1->setResetVal ("2'b00");
  f_FCSI_EFUSE12_txhbbandselection_ch1->setAccProp (AccProp::R);
  r_FCSI_EFUSE12->connectRField (f_FCSI_EFUSE12_txhbbandselection_ch1, 8);

  Attribute* a_FCSI_EFUSE12_txhbbandselection_ch1_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_EFUSE12_txhbbandselection_ch1_0_0->setInstName ("0");
  a_FCSI_EFUSE12_txhbbandselection_ch1_0_0->setLongName ("");
  a_FCSI_EFUSE12_txhbbandselection_ch1_0_0->setDescription ("");
  a_FCSI_EFUSE12_txhbbandselection_ch1_0_0->addItem("0", "2'b00", "0");
  a_FCSI_EFUSE12_txhbbandselection_ch1_0_0->addItem("1", "2'b01", "+1");
  a_FCSI_EFUSE12_txhbbandselection_ch1_0_0->addItem("2", "2'b11", "-1");
  a_FCSI_EFUSE12_txhbbandselection_ch1_0_0->addItem("3", "2'b10", "-2");
  f_FCSI_EFUSE12_txhbbandselection_ch1->connectAttribute (a_FCSI_EFUSE12_txhbbandselection_ch1_0_0);

  RField* f_FCSI_EFUSE12_txhbbandselection_ch2 = new RField;
  f_FCSI_EFUSE12_txhbbandselection_ch2->setInstName ("txhbbandselection_ch2");
  f_FCSI_EFUSE12_txhbbandselection_ch2->setLongName ("TX HB BAND SELECTION CH2");
  f_FCSI_EFUSE12_txhbbandselection_ch2->setDescription ("TX HB Band selection for channel 2 (2's complement)");
  f_FCSI_EFUSE12_txhbbandselection_ch2->setDataWidth (2);
  f_FCSI_EFUSE12_txhbbandselection_ch2->setResetVal ("2'b00");
  f_FCSI_EFUSE12_txhbbandselection_ch2->setAccProp (AccProp::R);
  r_FCSI_EFUSE12->connectRField (f_FCSI_EFUSE12_txhbbandselection_ch2, 10);

  Attribute* a_FCSI_EFUSE12_txhbbandselection_ch2_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_EFUSE12_txhbbandselection_ch2_0_0->setInstName ("0");
  a_FCSI_EFUSE12_txhbbandselection_ch2_0_0->setLongName ("");
  a_FCSI_EFUSE12_txhbbandselection_ch2_0_0->setDescription ("");
  a_FCSI_EFUSE12_txhbbandselection_ch2_0_0->addItem("0", "2'b00", "0");
  a_FCSI_EFUSE12_txhbbandselection_ch2_0_0->addItem("1", "2'b01", "+1");
  a_FCSI_EFUSE12_txhbbandselection_ch2_0_0->addItem("2", "2'b11", "-1");
  a_FCSI_EFUSE12_txhbbandselection_ch2_0_0->addItem("3", "2'b10", "-2");
  f_FCSI_EFUSE12_txhbbandselection_ch2->connectAttribute (a_FCSI_EFUSE12_txhbbandselection_ch2_0_0);

  RField* f_FCSI_EFUSE12_rxlbbandselection = new RField;
  f_FCSI_EFUSE12_rxlbbandselection->setInstName ("rxlbbandselection");
  f_FCSI_EFUSE12_rxlbbandselection->setLongName ("RX LB BAND SELECTION");
  f_FCSI_EFUSE12_rxlbbandselection->setDescription ("RX LB Band selection (2's complement)");
  f_FCSI_EFUSE12_rxlbbandselection->setDataWidth (2);
  f_FCSI_EFUSE12_rxlbbandselection->setResetVal ("2'b00");
  f_FCSI_EFUSE12_rxlbbandselection->setAccProp (AccProp::R);
  r_FCSI_EFUSE12->connectRField (f_FCSI_EFUSE12_rxlbbandselection, 12);

  Attribute* a_FCSI_EFUSE12_rxlbbandselection_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_EFUSE12_rxlbbandselection_0_0->setInstName ("0");
  a_FCSI_EFUSE12_rxlbbandselection_0_0->setLongName ("");
  a_FCSI_EFUSE12_rxlbbandselection_0_0->setDescription ("");
  a_FCSI_EFUSE12_rxlbbandselection_0_0->addItem("0", "2'b00", "0");
  a_FCSI_EFUSE12_rxlbbandselection_0_0->addItem("1", "2'b01", "+1");
  a_FCSI_EFUSE12_rxlbbandselection_0_0->addItem("2", "2'b11", "-1");
  a_FCSI_EFUSE12_rxlbbandselection_0_0->addItem("3", "2'b10", "-2");
  f_FCSI_EFUSE12_rxlbbandselection->connectAttribute (a_FCSI_EFUSE12_rxlbbandselection_0_0);

  RField* f_FCSI_EFUSE12_txlbbandselection = new RField;
  f_FCSI_EFUSE12_txlbbandselection->setInstName ("txlbbandselection");
  f_FCSI_EFUSE12_txlbbandselection->setLongName ("TX LB BAND SELECTION");
  f_FCSI_EFUSE12_txlbbandselection->setDescription ("TX LB Band selection (2's complement)");
  f_FCSI_EFUSE12_txlbbandselection->setDataWidth (2);
  f_FCSI_EFUSE12_txlbbandselection->setResetVal ("2'b00");
  f_FCSI_EFUSE12_txlbbandselection->setAccProp (AccProp::R);
  r_FCSI_EFUSE12->connectRField (f_FCSI_EFUSE12_txlbbandselection, 14);

  Attribute* a_FCSI_EFUSE12_txlbbandselection_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_EFUSE12_txlbbandselection_0_0->setInstName ("0");
  a_FCSI_EFUSE12_txlbbandselection_0_0->setLongName ("");
  a_FCSI_EFUSE12_txlbbandselection_0_0->setDescription ("");
  a_FCSI_EFUSE12_txlbbandselection_0_0->addItem("0", "2'b00", "0");
  a_FCSI_EFUSE12_txlbbandselection_0_0->addItem("1", "2'b01", "+1");
  a_FCSI_EFUSE12_txlbbandselection_0_0->addItem("2", "2'b11", "-1");
  a_FCSI_EFUSE12_txlbbandselection_0_0->addItem("3", "2'b10", "-2");
  f_FCSI_EFUSE12_txlbbandselection->connectAttribute (a_FCSI_EFUSE12_txlbbandselection_0_0);

  Register* r_FCSI_EFUSE13 = new Register;
  r_FCSI_EFUSE13->setInstName ("EFUSE13");
  r_FCSI_EFUSE13->setLongName ("EFUSE13 FILTER TPC");
  r_FCSI_EFUSE13->setDescription ("EFUSE FILTER TPC");
  r_FCSI_EFUSE13->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_EFUSE13, 0x0000003D);

  RField* f_FCSI_EFUSE13_ctl_tpc_fb_csel_80MHz = new RField;
  f_FCSI_EFUSE13_ctl_tpc_fb_csel_80MHz->setInstName ("ctl_tpc_fb_csel_80MHz");
  f_FCSI_EFUSE13_ctl_tpc_fb_csel_80MHz->setLongName ("CTL TPC FB CSEL 80MHz");
  f_FCSI_EFUSE13_ctl_tpc_fb_csel_80MHz->setDescription ("Control TPC feedback capacitor (binary coded) 80MHz BW");
  f_FCSI_EFUSE13_ctl_tpc_fb_csel_80MHz->setDataWidth (7);
  f_FCSI_EFUSE13_ctl_tpc_fb_csel_80MHz->setResetVal ("7'b0000000");
  f_FCSI_EFUSE13_ctl_tpc_fb_csel_80MHz->setAccProp (AccProp::RW);
  r_FCSI_EFUSE13->connectRField (f_FCSI_EFUSE13_ctl_tpc_fb_csel_80MHz, 0);

  Attribute* a_FCSI_EFUSE13_ctl_tpc_fb_csel_80MHz_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_EFUSE13_ctl_tpc_fb_csel_80MHz_0_0->setInstName ("0");
  a_FCSI_EFUSE13_ctl_tpc_fb_csel_80MHz_0_0->setLongName ("");
  a_FCSI_EFUSE13_ctl_tpc_fb_csel_80MHz_0_0->setDescription ("");
  a_FCSI_EFUSE13_ctl_tpc_fb_csel_80MHz_0_0->addItem("0", "7'b0000000", " 0pF");
  a_FCSI_EFUSE13_ctl_tpc_fb_csel_80MHz_0_0->addItem("1", "7'b0000001", "25fF");
  a_FCSI_EFUSE13_ctl_tpc_fb_csel_80MHz_0_0->addItem("15", "7'b0010000", "400fF (default)");
  a_FCSI_EFUSE13_ctl_tpc_fb_csel_80MHz_0_0->addItem("127", "7'b1111111", "3.175pF");
  f_FCSI_EFUSE13_ctl_tpc_fb_csel_80MHz->connectAttribute (a_FCSI_EFUSE13_ctl_tpc_fb_csel_80MHz_0_0);

  RField* f_FCSI_EFUSE13_ctl_tpc_fb_csel_160MHz = new RField;
  f_FCSI_EFUSE13_ctl_tpc_fb_csel_160MHz->setInstName ("ctl_tpc_fb_csel_160MHz");
  f_FCSI_EFUSE13_ctl_tpc_fb_csel_160MHz->setLongName ("CTL TPC FB CSEL 160MHz");
  f_FCSI_EFUSE13_ctl_tpc_fb_csel_160MHz->setDescription ("Control TPC feedback capacitor (binary coded) 160MHz BW");
  f_FCSI_EFUSE13_ctl_tpc_fb_csel_160MHz->setDataWidth (7);
  f_FCSI_EFUSE13_ctl_tpc_fb_csel_160MHz->setResetVal ("7'b0000000");
  f_FCSI_EFUSE13_ctl_tpc_fb_csel_160MHz->setAccProp (AccProp::RW);
  r_FCSI_EFUSE13->connectRField (f_FCSI_EFUSE13_ctl_tpc_fb_csel_160MHz, 7);

  Attribute* a_FCSI_EFUSE13_ctl_tpc_fb_csel_160MHz_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_EFUSE13_ctl_tpc_fb_csel_160MHz_0_0->setInstName ("0");
  a_FCSI_EFUSE13_ctl_tpc_fb_csel_160MHz_0_0->setLongName ("");
  a_FCSI_EFUSE13_ctl_tpc_fb_csel_160MHz_0_0->setDescription ("");
  a_FCSI_EFUSE13_ctl_tpc_fb_csel_160MHz_0_0->addItem("0", "7'b0000000", " 0pF");
  a_FCSI_EFUSE13_ctl_tpc_fb_csel_160MHz_0_0->addItem("1", "7'b0000001", "25fF");
  a_FCSI_EFUSE13_ctl_tpc_fb_csel_160MHz_0_0->addItem("15", "7'b0010000", "400fF (default)");
  a_FCSI_EFUSE13_ctl_tpc_fb_csel_160MHz_0_0->addItem("127", "7'b1111111", "3.175pF");
  f_FCSI_EFUSE13_ctl_tpc_fb_csel_160MHz->connectAttribute (a_FCSI_EFUSE13_ctl_tpc_fb_csel_160MHz_0_0);

  Register* r_FCSI_EFUSE14 = new Register;
  r_FCSI_EFUSE14->setInstName ("EFUSE14");
  r_FCSI_EFUSE14->setLongName ("EFUSE14 FILTER PGC");
  r_FCSI_EFUSE14->setDescription ("EFUSE FILTER PGC RC TIMERCONSTANST'S");
  r_FCSI_EFUSE14->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_EFUSE14, 0x0000003E);

  RField* f_FCSI_EFUSE14_Factor_kA = new RField;
  f_FCSI_EFUSE14_Factor_kA->setInstName ("Factor_kA");
  f_FCSI_EFUSE14_Factor_kA->setLongName ("Factor kA");
  f_FCSI_EFUSE14_Factor_kA->setDescription ("Factor kA 0..255 (sA=5000+kA*8)");
  f_FCSI_EFUSE14_Factor_kA->setDataWidth (8);
  f_FCSI_EFUSE14_Factor_kA->setResetVal ("8'b00000000");
  f_FCSI_EFUSE14_Factor_kA->setAccProp (AccProp::R);
  r_FCSI_EFUSE14->connectRField (f_FCSI_EFUSE14_Factor_kA, 0);

  RField* f_FCSI_EFUSE14_Factor_kB = new RField;
  f_FCSI_EFUSE14_Factor_kB->setInstName ("Factor_kB");
  f_FCSI_EFUSE14_Factor_kB->setLongName ("Factor kB");
  f_FCSI_EFUSE14_Factor_kB->setDescription ("Factor kB 0..63 (sB=-kB*1/32)");
  f_FCSI_EFUSE14_Factor_kB->setDataWidth (6);
  f_FCSI_EFUSE14_Factor_kB->setResetVal ("6'b000000");
  f_FCSI_EFUSE14_Factor_kB->setAccProp (AccProp::R);
  r_FCSI_EFUSE14->connectRField (f_FCSI_EFUSE14_Factor_kB, 8);

  RField* f_FCSI_EFUSE14_Method = new RField;
  f_FCSI_EFUSE14_Method->setInstName ("Method");
  f_FCSI_EFUSE14_Method->setLongName ("Method");
  f_FCSI_EFUSE14_Method->setDescription ("Method of the coding");
  f_FCSI_EFUSE14_Method->setDataWidth (2);
  f_FCSI_EFUSE14_Method->setResetVal ("2'b00");
  f_FCSI_EFUSE14_Method->setAccProp (AccProp::R);
  r_FCSI_EFUSE14->connectRField (f_FCSI_EFUSE14_Method, 14);

  Register* r_FCSI_EFUSE15 = new Register;
  r_FCSI_EFUSE15->setInstName ("EFUSE15");
  r_FCSI_EFUSE15->setLongName ("EFUSE15 VERSION NUMBER, PRODUCT CODE, MCM");
  r_FCSI_EFUSE15->setDescription ("EFUSE version number + product code + MCM");
  r_FCSI_EFUSE15->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_EFUSE15, 0x0000003F);

  RField* f_FCSI_EFUSE15_versionnumber = new RField;
  f_FCSI_EFUSE15_versionnumber->setInstName ("versionnumber");
  f_FCSI_EFUSE15_versionnumber->setLongName ("Version number");
  f_FCSI_EFUSE15_versionnumber->setDescription ("Version number (e.g.:1011b(11d) = V1.1)");
  f_FCSI_EFUSE15_versionnumber->setDataWidth (5);
  f_FCSI_EFUSE15_versionnumber->setResetVal ("5'b00000");
  f_FCSI_EFUSE15_versionnumber->setAccProp (AccProp::R);
  r_FCSI_EFUSE15->connectRField (f_FCSI_EFUSE15_versionnumber, 0);

  RField* f_FCSI_EFUSE15_productcode = new RField;
  f_FCSI_EFUSE15_productcode->setInstName ("productcode");
  f_FCSI_EFUSE15_productcode->setLongName ("Product code");
  f_FCSI_EFUSE15_productcode->setDescription ("Product code (WRXxyz x=13:11,y=10:8,z=7:5 e.g.:WRX654=110101100), x hard wired to 6 for generation 6, y is 5 for dual band and z is 4 for 4 antennas");
  f_FCSI_EFUSE15_productcode->setDataWidth (9);
  f_FCSI_EFUSE15_productcode->setResetVal ("9'b110101100");
  f_FCSI_EFUSE15_productcode->setAccProp (AccProp::R);
  r_FCSI_EFUSE15->connectRField (f_FCSI_EFUSE15_productcode, 5);

  Attribute* a_FCSI_EFUSE15_productcode_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_EFUSE15_productcode_0_0->setInstName ("0");
  a_FCSI_EFUSE15_productcode_0_0->setLongName ("");
  a_FCSI_EFUSE15_productcode_0_0->setDescription ("");
  a_FCSI_EFUSE15_productcode_0_0->addItem("0", "9'b110101ABC", "WRX6yabc (abc=number of antennas)");
  f_FCSI_EFUSE15_productcode->connectAttribute (a_FCSI_EFUSE15_productcode_0_0);

  RField* f_FCSI_EFUSE15_mcm = new RField;
  f_FCSI_EFUSE15_mcm->setInstName ("mcm");
  f_FCSI_EFUSE15_mcm->setLongName ("MCM");
  f_FCSI_EFUSE15_mcm->setDescription ("MCM");
  f_FCSI_EFUSE15_mcm->setDataWidth (1);
  f_FCSI_EFUSE15_mcm->setResetVal ("1'b0");
  f_FCSI_EFUSE15_mcm->setAccProp (AccProp::R);
  r_FCSI_EFUSE15->connectRField (f_FCSI_EFUSE15_mcm, 14);

  
}

