#include <stdint.h>
//#include "target.h"

#include "interface_rf_4x4.h"
#include "lib_rf_4x4_api.h"

/* register packages */
#include "wrx514_fcsi0_addrmap.h"
#include "rf_antenna0_fcsi_fieldpkg.h"
#include "rf_antenna0_fcsi_regpkg.h"
#include "wrx514_fcsi1_addrmap.h"
#include "rf_antenna1_fcsi_fieldpkg.h"
#include "rf_antenna1_fcsi_regpkg.h"
#include "wrx514_fcsi2_addrmap.h"
#include "rf_antenna2_fcsi_fieldpkg.h"
#include "rf_antenna2_fcsi_regpkg.h"
#include "wrx514_fcsi3_addrmap.h"
#include "rf_antenna3_fcsi_fieldpkg.h"
#include "rf_antenna3_fcsi_regpkg.h"

void rfic_init_1 (void)
{
	//-------------------------------------------------------------------------
	// Register BIASCENT	CENTRAL BIAS	Ant2	0x48
	//-------------------------------------------------------------------------
	RFIC_FCSI_Write(4, RF_ANTENNA2_FCSI_BIASCENT,
			RF_ANTENNA2_FCSI_BIASCENT_EN_U2I_P2PR_1__SVAL
			| RF_ANTENNA2_FCSI_BIASCENT_EN_U2I_CONST_1__SVAL
			| RF_ANTENNA2_FCSI_BIASCENT_EN_BGP_1__SVAL
			| 14<<RF_ANTENNA2_FCSI_BIASCENT_CTL_TRIM_BGP__POS);

	//--------------------------------------------------------------------------
	// Register PLLPUP0		PLL POWER UP CENTRAL	Ant0	0x40
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(1, RF_ANTENNA0_FCSI_PLLPUP0,
			RF_ANTENNA0_FCSI_PLLPUP0_PUP_LDO_VCO_1__SVAL
			| RF_ANTENNA0_FCSI_PLLPUP0_PUP_LDO_DIG_1__SVAL
			| RF_ANTENNA0_FCSI_PLLPUP0_PUP_LDO_XO_1__SVAL
			| RF_ANTENNA0_FCSI_PLLPUP0_PUP_LDO_FB_1__SVAL
			| RF_ANTENNA0_FCSI_PLLPUP0_PUP_LDO_FF_1__SVAL
			| RF_ANTENNA0_FCSI_PLLPUP0_PUP_CPLP_FBIAS_1__SVAL
			| RF_ANTENNA0_FCSI_PLLPUP0_PUP_OPAMP_LPATH_1__SVAL
			| RF_ANTENNA0_FCSI_PLLPUP0_PUP_VVBGEN_LPATH_1__SVAL
			| RF_ANTENNA0_FCSI_PLLPUP0_PUP_VVBGEN_PPATH_1__SVAL
			| RF_ANTENNA0_FCSI_PLLPUP0_PUP_REG_RESYNC_1__SVAL);
}

void rfic_init_2 (void)
{
	//--------------------------------------------------------------------------
	// Register BBLDO1V2	RF LDO1V2 BB		Antx	0x52
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(15, RF_ANTENNA0_FCSI_BBLDO1V2,
			RF_ANTENNA0_FCSI_BBLDO1V2_ENABLE_1__SVAL
			| RF_ANTENNA0_FCSI_BBLDO1V2_EN_ANTBIAS_CURRENT_MIRROR_1__SVAL);
}

void rfic_init_3 (void)
{
	//--------------------------------------------------------------------------
		// Register BBIOLDO1V2	BBIO LDO1V2 + BIAS		Ant2	0x44
		//--------------------------------------------------------------------------
		RFIC_FCSI_Write(4, RF_ANTENNA2_FCSI_BBIOLDO1V2,
				RF_ANTENNA2_FCSI_BBIOLDO1V2_EN_BIAS_1__SVAL
				| RF_ANTENNA2_FCSI_BBIOLDO1V2_EN_LDO_1__SVAL);

		//--------------------------------------------------------------------------
		// Register BBFILTLDO1V2	RF LDO1V2 BB FILTER		Antx	0x53
		//--------------------------------------------------------------------------
		RFIC_FCSI_Write(15, RF_ANTENNA0_FCSI_BBFILTLDO1V2,
				RF_ANTENNA0_FCSI_BBFILTLDO1V2_ENABLE_1__SVAL);

		//--------------------------------------------------------------------------
		// Register PLLPMU0		PLL PMU CENTRAL			Ant0	0x41
		//--------------------------------------------------------------------------
		RFIC_FCSI_Write(1, RF_ANTENNA0_FCSI_PLLPMU0,
				RF_ANTENNA0_FCSI_PLLPMU0_LDO_DIG_SEL_4__SVAL
				| RF_ANTENNA0_FCSI_PLLPMU0_LDO_VCO_SEL_4__SVAL // VCO LDO to 1.417V --> change for WRX514
				| RF_ANTENNA0_FCSI_PLLPMU0_REG_LO_SEL_2__SVAL  // IQDIV LDO to 1.258V --> change for WRX514
				| RF_ANTENNA0_FCSI_PLLPMU0_VCOREG_INTREF_SEL_1__SVAL
				| RF_ANTENNA0_FCSI_PLLPMU0_DIAG_DISABLE_1__SVAL);

		//--------------------------------------------------------------------------
		// Register PLLPMU1		PLL PMU DIAG CONTROL	Ant0	0x42
		//--------------------------------------------------------------------------
		RFIC_FCSI_Write(1, RF_ANTENNA0_FCSI_PLLPMU1,
				RF_ANTENNA0_FCSI_PLLPMU1_LDO_FF_SEL_4__SVAL
				| RF_ANTENNA0_FCSI_PLLPMU1_LDO_RESYNC_SEL_4__SVAL
				| RF_ANTENNA0_FCSI_PLLPMU1_LDO_XO_SEL_4__SVAL);

		//--------------------------------------------------------------------------
		// Register PLLPUP1		PLL POWER UP LOCAL		Ant0	0x43
		//--------------------------------------------------------------------------
		RFIC_FCSI_Write(1, RF_ANTENNA0_FCSI_PLLPUP1,
				RF_ANTENNA0_FCSI_PLLPUP1_FPD_LSBUFF_FB_1__SVAL); // 2G mode --> changed for WRX514

		//--------------------------------------------------------------------------
		// Register PLLVCO0		PLL VCO CONTROL 0		Ant0	0x44
		//--------------------------------------------------------------------------
		RFIC_FCSI_Write(1, RF_ANTENNA0_FCSI_PLLVCO0,
				RF_ANTENNA0_FCSI_PLLVCO0_BUMP_DCAP_OFF_REF_1__SVAL
				| RF_ANTENNA0_FCSI_PLLVCO0_BUMP_DCAP_ON_REF_1__SVAL);

		//--------------------------------------------------------------------------
		// Register PLLSDM0		PLL SIGMA DELTA 0 		Ant0	0x46
		//--------------------------------------------------------------------------
		RFIC_FCSI_Write(1, RF_ANTENNA0_FCSI_PLLSDM0,
				RF_ANTENNA0_FCSI_PLLSDM0_SDM_EN_1__SVAL); // enable DSM --> added for WRX514

		//--------------------------------------------------------------------------
		// Register PLLMISC		PLL MISCELLANEOUS		Ant0	0x4A
		//--------------------------------------------------------------------------
		RFIC_FCSI_Write(1, RF_ANTENNA0_FCSI_PLLMISC,
				RF_ANTENNA0_FCSI_PLLMISC_RFPLL_FAST_CHANNEL_HOP_EN_1__SVAL
				| TESTER << RF_ANTENNA0_FCSI_PLLMISC_SEL_CLK__POS		// select internal clock for Lab, or external for Tester
				| RF_ANTENNA0_FCSI_PLLMISC_RFPLL_REF_SEL_40M_1__SVAL);  // set ref clock to 40MHz --> added for WRX514

		//--------------------------------------------------------------------------
		// Register BBIOLDO1V2	BBIO LDO1V2 + BIAS		Ant2	0x44
		//--------------------------------------------------------------------------
		RFIC_FCSI_Write(4, RF_ANTENNA2_FCSI_BBIOLDO1V2,
				RF_ANTENNA2_FCSI_BBIOLDO1V2_EN_VCMBUFFER_1__SVAL // enable VCM buffer
				| RF_ANTENNA2_FCSI_BBIOLDO1V2_EN_BIAS_1__SVAL   // keep LDO ON
				| RF_ANTENNA2_FCSI_BBIOLDO1V2_EN_LDO_1__SVAL);  // keep LDO ON


}

void rfic_init_4 (void)
{
	// work-around for BB Filter LDO RDY weakness to prevent unwanted resetting of Registers 0x60-0x7f
	//--------------------------------------------------------------------------
	// Register BBFILTLDO1V2	RF LDO1V2 BB FILTER		Antx	0x53
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(15, RF_ANTENNA0_FCSI_BBFILTLDO1V2,
            RF_ANTENNA0_FCSI_BBFILTLDO1V2_CTL_LDO_RDY_1__SVAL		// set to manual LDO RDY control
            | RF_ANTENNA0_FCSI_BBFILTLDO1V2_FORCE_LDO_RDY_1__SVAL	// force LDO RDY = 1
			| RF_ANTENNA0_FCSI_BBFILTLDO1V2_ENABLE_1__SVAL);		// keep LDO enabled (was already enabled in init3)


	//--------------------------------------------------------------------------
	// Register VCMCTL		VCM CONTROL ANTENNA BIASING		Antx	0x67
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(15, RF_ANTENNA0_FCSI_VCMCTL,
			RF_ANTENNA0_FCSI_VCMCTL_EN_VCMBUFFER_1__SVAL
			| RF_ANTENNA0_FCSI_VCMCTL_EN_VCMBUFFER_PGC2_1__SVAL);

	//--------------------------------------------------------------------------
	// Register RFLDO2V5	RF LDO2V5		Antx	0x54
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(15, RF_ANTENNA0_FCSI_RFLDO2V5,
			RF_ANTENNA0_FCSI_RFLDO2V5_EN_LC_1__SVAL
			| RF_ANTENNA0_FCSI_RFLDO2V5_ENABLE_1__SVAL);

	//--------------------------------------------------------------------------
	// Register TXLDO1V2	RF LDO1V2 TX	Antx	0x50
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(15, RF_ANTENNA0_FCSI_TXLDO1V2,
			RF_ANTENNA0_FCSI_TXLDO1V2_ENABLE_1__SVAL
			| RF_ANTENNA0_FCSI_TXLDO1V2_CTL_VOUT_9__SVAL);	// 1.28V --> change for WRX514

	//--------------------------------------------------------------------------
	// Register RXLDO1V2	RF LDO1V2 RX	Antx	0x51
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(15, RF_ANTENNA0_FCSI_RXLDO1V2,
			RF_ANTENNA0_FCSI_RXLDO1V2_ENABLE_1__SVAL);

	//--------------------------------------------------------------------------
	// Register LNA - LNA GENERAL	Antx	0x6A
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(15, RF_ANTENNA0_FCSI_LNA,
			10<<RF_ANTENNA0_FCSI_LNA_CTL_FINE_GAIN__POS);

	//--------------------------------------------------------------------------
	// Register MIXERPGC1	RX MIXER + PGC1 CONTROL		Antx	0x6C
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(15, RF_ANTENNA0_FCSI_MIXERPGC1,
			RF_ANTENNA0_FCSI_MIXERPGC1_EN_MIXER_I_PATH_1__SVAL
			| RF_ANTENNA0_FCSI_MIXERPGC1_EN_MIXER_Q_PATH_1__SVAL
			| RF_ANTENNA0_FCSI_MIXERPGC1_EN_MIXER_1__SVAL
			| RF_ANTENNA0_FCSI_MIXERPGC1_CTL_PGC1_BIAS_LP_5__SVAL	// 66.7% (101b)
			| RF_ANTENNA0_FCSI_MIXERPGC1_CTL_PGC1_BIAS_RP_3__SVAL	// 83.3% (111b)
			| RF_ANTENNA0_FCSI_MIXERPGC1_CTL_PGC1_BIAS_AC_2__SVAL); // 100% (000b)

	//--------------------------------------------------------------------------
	// Register FILTER	BB FILTER GENERAL	Antx	0x66
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(15, RF_ANTENNA0_FCSI_FILTER,
			RF_ANTENNA0_FCSI_FILTER_EN_1__SVAL
			| RF_ANTENNA0_FCSI_FILTER_CTL_FILTER_BIAS_LP_0__SVAL	// 12.5uA (100b)
			| RF_ANTENNA0_FCSI_FILTER_CTL_FILTER_BIAS_RP_2__SVAL	// 25uA (110b)
			| RF_ANTENNA0_FCSI_FILTER_CTL_FILTER_BIAS_AC_6__SVAL);	// 50uA (010b) set to final value

	//--------------------------------------------------------------------------
	// Register FILTRX - BB FILTER TUNING RX	Antx	0x64
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(15, RF_ANTENNA0_FCSI_FILTRX,
			RF_ANTENNA0_FCSI_FILTRX_CTL_TRIMFILTER_RX_10MHZ_1__SVAL
			| RF_ANTENNA0_FCSI_FILTRX_CTL_TRIMFILTER_RX_20MHZ_1__SVAL
			| RF_ANTENNA0_FCSI_FILTRX_CTL_TRIMFILTER_RX_40MHZ_1__SVAL);

	//--------------------------------------------------------------------------
	// Register FILTTX - BB FILTER TUNING TX	Antx	0x65
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(15, RF_ANTENNA0_FCSI_FILTTX,
			RF_ANTENNA0_FCSI_FILTTX_CTL_TRIMFILTER_TX_10MHZ_1__SVAL
			| RF_ANTENNA0_FCSI_FILTTX_CTL_TRIMFILTER_TX_20MHZ_1__SVAL
			| RF_ANTENNA0_FCSI_FILTTX_CTL_TRIMFILTER_TX_40MHZ_1__SVAL);

	//--------------------------------------------------------------------------
	// Register PGC20	PGC2 BIAS			Antx	0x58
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(15, RF_ANTENNA0_FCSI_PGC20,
			RF_ANTENNA0_FCSI_PGC20_CTL_PGC2_BIAS_RP_TX_4__SVAL		// TX RP mode 75u (000b)
			| RF_ANTENNA0_FCSI_PGC20_CTL_PGC2_BIAS_AC_TX_4__SVAL	// TX AC mode 75u (000b)
			| RF_ANTENNA0_FCSI_PGC20_CTL_PGC2_BIAS_AC_RX_4__SVAL	// RX AC mode 74u (000b)
			| RF_ANTENNA0_FCSI_PGC20_CTL_PGC2_BIAS_RP_RX_2__SVAL	// RX RP mode 50u (110b)
			| RF_ANTENNA0_FCSI_PGC20_CTL_PGC2_BIAS_LP_RX_0__SVAL);	// RX LP mode 25u (100b)

	//--------------------------------------------------------------------------
	// Register PGC21	PGC2 CTRL + GAIN (SREG TX CONTROL)	Antx	0x59
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(15, RF_ANTENNA0_FCSI_PGC21,
			RF_ANTENNA0_FCSI_PGC21_EN_OFFSET_DAC_1__SVAL
			| RF_ANTENNA0_FCSI_PGC21_EN_PGC2_1__SVAL);

	//--------------------------efuse_mcm------------------------------------------------
	// Register ANAMUX	ANAMUX	Antx	0x62
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(15, RF_ANTENNA0_FCSI_ANAMUX,
			RF_ANTENNA0_FCSI_ANAMUX_SEL_SSI_1__SVAL
			| RF_ANTENNA0_FCSI_ANAMUX_EN_1__SVAL);

	//--------------------------------------------------------------------------
	// Register	SSI		SSI CONTROL 	Antx	0x60
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(15, RF_ANTENNA0_FCSI_SSI,
			RF_ANTENNA0_FCSI_SSI_EN_RSSI_1__SVAL
			| RF_ANTENNA0_FCSI_SSI_CTL_TSSI_RANGE_0__SVAL // TSSI input divider ratio 0.6
			| RF_ANTENNA0_FCSI_SSI_EN_ODAC_1__SVAL); // work-around: TSSI ODAC always on

	//--------------------------------------------------------------------------
	// Register PADRIVER	PA DRIVER GENERAL	Antx	0x5D
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(15, RF_ANTENNA0_FCSI_PADRIVER,
			RF_ANTENNA0_FCSI_PADRIVER_EN_PAD_1__SVAL);

	//--------------------------------------------------------------------------
	// Register RXMIXERDCOCTL	RX MIXER DC OFFSET CONTROL	Antx	0x70
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(15, RF_ANTENNA0_FCSI_RXMIXERDCOCTL,
			RF_ANTENNA0_FCSI_RXMIXERDCOCTL_RSTN_DCO_I_1__SVAL
			| RF_ANTENNA0_FCSI_RXMIXERDCOCTL_TOGGLE_EN_DCO_I_1__SVAL
			| RF_ANTENNA0_FCSI_RXMIXERDCOCTL_RSTN_DCO_Q_1__SVAL
			| RF_ANTENNA0_FCSI_RXMIXERDCOCTL_TOGGLE_EN_DCO_Q_1__SVAL);

	//--------------------------------------------------------------------------
	// Register PGC2DCOCTL	PGC2 DC OFFSET CONTROL	Antx	0x5F
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(15, RF_ANTENNA0_FCSI_PGC2DCOCTL,
			RF_ANTENNA0_FCSI_PGC2DCOCTL_RSTN_DCO_I_1__SVAL
			| RF_ANTENNA0_FCSI_PGC2DCOCTL_TOGGLE_EN_DCO_I_1__SVAL
			| RF_ANTENNA0_FCSI_PGC2DCOCTL_RSTN_DCO_Q_1__SVAL
			| RF_ANTENNA0_FCSI_PGC2DCOCTL_TOGGLE_EN_DCO_Q_1__SVAL);

	//--------------------------------------------------------------------------
	// Register BBIO - BBO + BBIO CONFIG		Ant2	0x41
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(4, RF_ANTENNA2_FCSI_BBIO,
			RF_ANTENNA2_FCSI_BBIO_EN_BBO_ANT3_1__SVAL
			| RF_ANTENNA2_FCSI_BBIO_EN_BBO_ANT2_1__SVAL
			| RF_ANTENNA2_FCSI_BBIO_EN_BBO_ANT1_1__SVAL
			| RF_ANTENNA2_FCSI_BBIO_EN_BBO_ANT0_1__SVAL
			| MCM << RF_ANTENNA2_FCSI_BBIO_EN_MCM_MODE__POS);	// write MCM bit if DUT is MCM

	//--------------------------------------------------------------------------
	// Register BBOLOOP		BBO LOOPS		Ant2	0x43
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(4, RF_ANTENNA2_FCSI_BBOLOOP,
			RF_ANTENNA2_FCSI_BBOLOOP_EN_IN0_ANT3_1__SVAL
			| RF_ANTENNA2_FCSI_BBOLOOP_EN_IN0_ANT2_1__SVAL
			| RF_ANTENNA2_FCSI_BBOLOOP_EN_IN0_ANT1_1__SVAL
			| RF_ANTENNA2_FCSI_BBOLOOP_EN_IN0_ANT0_1__SVAL);

	//--------------------------------------------------------------------------
	// Register LOCENTRAL	LO CENTRAL		Ant1	0x48
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(2, RF_ANTENNA1_FCSI_LOCENTRAL,
			RF_ANTENNA1_FCSI_LOCENTRAL_EN_TML_DRV_ANT3_1__SVAL
			| RF_ANTENNA1_FCSI_LOCENTRAL_EN_FOB_ANT3_1__SVAL
			| RF_ANTENNA1_FCSI_LOCENTRAL_EN_TML_DRV_ANT2_1__SVAL
			| RF_ANTENNA1_FCSI_LOCENTRAL_EN_FOB_ANT2_1__SVAL
			| RF_ANTENNA1_FCSI_LOCENTRAL_EN_TML_DRV_ANT1_1__SVAL
			| RF_ANTENNA1_FCSI_LOCENTRAL_EN_FOB_ANT1_1__SVAL
			| RF_ANTENNA1_FCSI_LOCENTRAL_EN_TML_DRV_ANT0_1__SVAL
			| RF_ANTENNA1_FCSI_LOCENTRAL_EN_FOB_ANT0_1__SVAL);

	//--------------------------------------------------------------------------
	// Register	TEMPSENS1 - TEMP SENSOR 1	Ant2	0x4D
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(4, RF_ANTENNA2_FCSI_TEMPSENS1,
			RF_ANTENNA2_FCSI_TEMPSENS1_FLP_CMP_SWAP_1__SVAL
			|RF_ANTENNA2_FCSI_TEMPSENS1_EN_DTS_1__SVAL);

	//--------------------------------------------------------------------------
	// Short Register SR0
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(15, RF_ANTENNA0_FCSI_SR0,
			RF_ANTENNA0_FCSI_SR0_SEL_RXDC_0__SVAL	// DC offset for channel 0
			| RF_ANTENNA0_FCSI_SR0_SEL_CH_0__SVAL	// PLL channel 0
			| RF_ANTENNA0_FCSI_SR0_SEL_BW_2__SVAL	// 20MHz BW --> change for WRX514
			| RF_ANTENNA0_FCSI_SR0_MODE_1__SVAL		// Reduced Power --> change for WRX514
			| RF_ANTENNA0_FCSI_SR0_TX_BAND_3__SVAL	// TX band selection 3d --> change for WRX514
			| RF_ANTENNA0_FCSI_SR0_RX_BAND_4__SVAL);// RX band selection 4d --> change for WRX514

	//--------------------------------------------------------------------------
	// Short Register SR1
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(15, RF_ANTENNA0_FCSI_SR1,
			RF_ANTENNA0_FCSI_SR1_PGC2_RXGAIN_10__SVAL			// PGC2 12dB
			| RF_ANTENNA0_FCSI_SR1_PGC1_GAIN_18__SVAL			// PGC1 18dB
			| RF_ANTENNA0_FCSI_SR1_LNA_GAIN_COARSE_3__SVAL);	// LNA High gain
}


void rfic_rxon (uint8_t AntMsk)
{
	RFIC_FCSI_RMW(AntMsk, RF_ANTENNA0_FCSI_SR0,
			RF_ANTENNA0_FCSI_SR0_RXON__ISMSK,
			RF_ANTENNA0_FCSI_SR0_RXON_1__SVAL);
}

void rfic_rxoff (uint8_t AntMsk)
{
	RFIC_FCSI_RMW(AntMsk, RF_ANTENNA0_FCSI_SR0,
			RF_ANTENNA0_FCSI_SR0_RXON__ISMSK,
			RF_ANTENNA0_FCSI_SR0_RXON_0__SVAL);
}

void rfic_txon (uint8_t AntMsk)
{
	RFIC_FCSI_RMW(AntMsk, RF_ANTENNA0_FCSI_SR2,
			RF_ANTENNA0_FCSI_SR2_TXON__ISMSK,
			RF_ANTENNA0_FCSI_SR2_TXON_1__SVAL);
}

void rfic_txoff (uint8_t AntMsk)
{
	RFIC_FCSI_RMW(AntMsk, RF_ANTENNA0_FCSI_SR2,
			RF_ANTENNA0_FCSI_SR2_TXON__ISMSK,
			RF_ANTENNA0_FCSI_SR2_TXON_0__SVAL);
}

void rfic_disable_fsys2 (void)
{
	//--------------------------------------------------------------------------
	// Register FSYS - FSYS 1 + 2	Ant1	0x44
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(2, RF_ANTENNA1_FCSI_FSYS,
			RF_ANTENNA1_FCSI_FSYS_DISABLE__ISMSK,
			RF_ANTENNA1_FCSI_FSYS_DISABLE_1__SVAL);
}

void rfic_enable_fsys2 (void)
{
	//--------------------------------------------------------------------------
	// Register FSYS - FSYS 1 + 2	Ant1	0x44
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(2, RF_ANTENNA1_FCSI_FSYS,
			RF_ANTENNA1_FCSI_FSYS_DISABLE__ISMSK,
			RF_ANTENNA1_FCSI_FSYS_DISABLE_0__SVAL);
}

void rfic_start_dc_clock (void)
{
	//--------------------------------------------------------------------------
	// Register CMOSCLKTREE - LO CENTRAL	Ant1	0x47
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(2, RF_ANTENNA1_FCSI_CMOSCLKTREE,
			RF_ANTENNA1_FCSI_CMOSCLKTREE_EN_DCO_CLK_ANT0__ISMSK
			& RF_ANTENNA1_FCSI_CMOSCLKTREE_EN_DCO_CLK_ANT1__ISMSK
			& RF_ANTENNA1_FCSI_CMOSCLKTREE_EN_DCO_CLK_ANT2__ISMSK
			& RF_ANTENNA1_FCSI_CMOSCLKTREE_EN_DCO_CLK_ANT3__ISMSK,
			RF_ANTENNA1_FCSI_CMOSCLKTREE_EN_DCO_CLK_ANT0_1__SVAL
			| RF_ANTENNA1_FCSI_CMOSCLKTREE_EN_DCO_CLK_ANT1_1__SVAL
			| RF_ANTENNA1_FCSI_CMOSCLKTREE_EN_DCO_CLK_ANT2_1__SVAL
			| RF_ANTENNA1_FCSI_CMOSCLKTREE_EN_DCO_CLK_ANT3_1__SVAL);
}

void rfic_stop_dc_clock (void)
{
	//--------------------------------------------------------------------------
	// Register CMOSCLKTREE - LO CENTRAL	Ant1	0x47
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(2, RF_ANTENNA1_FCSI_CMOSCLKTREE,
			RF_ANTENNA1_FCSI_CMOSCLKTREE_EN_DCO_CLK_ANT0__ISMSK
			& RF_ANTENNA1_FCSI_CMOSCLKTREE_EN_DCO_CLK_ANT1__ISMSK
			& RF_ANTENNA1_FCSI_CMOSCLKTREE_EN_DCO_CLK_ANT2__ISMSK
			& RF_ANTENNA1_FCSI_CMOSCLKTREE_EN_DCO_CLK_ANT3__ISMSK,
			RF_ANTENNA1_FCSI_CMOSCLKTREE_EN_DCO_CLK_ANT0_0__SVAL
			| RF_ANTENNA1_FCSI_CMOSCLKTREE_EN_DCO_CLK_ANT1_0__SVAL
			| RF_ANTENNA1_FCSI_CMOSCLKTREE_EN_DCO_CLK_ANT2_0__SVAL
			| RF_ANTENNA1_FCSI_CMOSCLKTREE_EN_DCO_CLK_ANT3_0__SVAL);
}

void rfic_start_dcramp0 (void)
{
	//--------------------------------------------------------------------------
	// Register RXMIXERDCOCTL	RX MIXER DC OFFSET CONTROL	Antx	0x70
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(15, RF_ANTENNA0_FCSI_RXMIXERDCOCTL,
			RF_ANTENNA1_FCSI_RXMIXERDCOCTL_EN_DCO_I__ISMSK
			& RF_ANTENNA1_FCSI_RXMIXERDCOCTL_TEST_DCO_I__ISMSK
			& RF_ANTENNA1_FCSI_RXMIXERDCOCTL_EN_DCO_Q__ISMSK
			& RF_ANTENNA1_FCSI_RXMIXERDCOCTL_TEST_DCO_Q__ISMSK,
			RF_ANTENNA1_FCSI_RXMIXERDCOCTL_EN_DCO_I_1__SVAL
			| RF_ANTENNA1_FCSI_RXMIXERDCOCTL_TEST_DCO_I_1__SVAL
			| RF_ANTENNA1_FCSI_RXMIXERDCOCTL_EN_DCO_Q_1__SVAL
			| RF_ANTENNA1_FCSI_RXMIXERDCOCTL_TEST_DCO_Q_1__SVAL);
}

void rfic_stop_dcramp0 (void)
{
	//--------------------------------------------------------------------------
	// Register RXMIXERDCOCTL	RX MIXER DC OFFSET CONTROL	Antx	0x70
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(15, RF_ANTENNA0_FCSI_RXMIXERDCOCTL,
			RF_ANTENNA1_FCSI_RXMIXERDCOCTL_EN_DCO_I__ISMSK
			& RF_ANTENNA1_FCSI_RXMIXERDCOCTL_TEST_DCO_I__ISMSK
			& RF_ANTENNA1_FCSI_RXMIXERDCOCTL_EN_DCO_Q__ISMSK
			& RF_ANTENNA1_FCSI_RXMIXERDCOCTL_TEST_DCO_Q__ISMSK,
			RF_ANTENNA1_FCSI_RXMIXERDCOCTL_EN_DCO_I_0__SVAL
			| RF_ANTENNA1_FCSI_RXMIXERDCOCTL_TEST_DCO_I_0__SVAL
			| RF_ANTENNA1_FCSI_RXMIXERDCOCTL_EN_DCO_Q_0__SVAL
			| RF_ANTENNA1_FCSI_RXMIXERDCOCTL_TEST_DCO_Q_0__SVAL);
}

void rfic_start_dcramp2 (void)
{
	//--------------------------------------------------------------------------
	// Register FILTER - BB FILTER GENERAL	Antx	0x66
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(15, RF_ANTENNA0_FCSI_FILTER,
			RF_ANTENNA1_FCSI_FILTER_EN_OFFSET_CAL__ISMSK,
			RF_ANTENNA1_FCSI_FILTER_EN_OFFSET_CAL_1__SVAL);

	//--------------------------------------------------------------------------
	// Register PGC2DCOCTL - PGC2 DC OFFSET CONTROL	Antx	0x5F
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(15, RF_ANTENNA0_FCSI_PGC2DCOCTL,
			RF_ANTENNA1_FCSI_PGC2DCOCTL_EN_DCO_I__ISMSK
			& RF_ANTENNA1_FCSI_PGC2DCOCTL_TEST_DCO_I__ISMSK
			& RF_ANTENNA1_FCSI_PGC2DCOCTL_EN_DCO_Q__ISMSK
			& RF_ANTENNA1_FCSI_PGC2DCOCTL_TEST_DCO_Q__ISMSK,
			RF_ANTENNA1_FCSI_PGC2DCOCTL_EN_DCO_I_1__SVAL
			| RF_ANTENNA1_FCSI_PGC2DCOCTL_TEST_DCO_I_1__SVAL
			| RF_ANTENNA1_FCSI_PGC2DCOCTL_EN_DCO_Q_1__SVAL
			| RF_ANTENNA1_FCSI_PGC2DCOCTL_TEST_DCO_Q_1__SVAL);
}

void rfic_stop_dcramp2 (void)
{
	//--------------------------------------------------------------------------
	// Register PGC2DCOCTL - PGC2 DC OFFSET CONTROL	Antx	0x5F
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(15, RF_ANTENNA0_FCSI_PGC2DCOCTL,
			RF_ANTENNA1_FCSI_PGC2DCOCTL_EN_DCO_I__ISMSK
			& RF_ANTENNA1_FCSI_PGC2DCOCTL_TEST_DCO_I__ISMSK
			& RF_ANTENNA1_FCSI_PGC2DCOCTL_EN_DCO_Q__ISMSK
			& RF_ANTENNA1_FCSI_PGC2DCOCTL_TEST_DCO_Q__ISMSK,
			RF_ANTENNA1_FCSI_PGC2DCOCTL_EN_DCO_I_0__SVAL
			| RF_ANTENNA1_FCSI_PGC2DCOCTL_TEST_DCO_I_0__SVAL
			| RF_ANTENNA1_FCSI_PGC2DCOCTL_EN_DCO_Q_0__SVAL
			| RF_ANTENNA1_FCSI_PGC2DCOCTL_TEST_DCO_Q_0__SVAL);

	//--------------------------------------------------------------------------
	// Register FILTER - BB FILTER GENERAL	Antx	0x66
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(15, RF_ANTENNA0_FCSI_FILTER,
			RF_ANTENNA1_FCSI_FILTER_EN_OFFSET_CAL__ISMSK,
			RF_ANTENNA1_FCSI_FILTER_EN_OFFSET_CAL_0__SVAL);
}

void rfic_enable_dac0_man (void)
{
	//--------------------------------------------------------------------------
	// Short Register SR3
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(15,  RF_ANTENNA0_FCSI_SR3,
			RF_ANTENNA0_FCSI_SR3_FORCE_DAC0__ISMSK,
			RF_ANTENNA0_FCSI_SR3_FORCE_DAC0_1__SVAL);
}

void rfic_disable_dac0_man (void)
{
	//--------------------------------------------------------------------------
	// Short Register SR3
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(15,  RF_ANTENNA0_FCSI_SR3,
			RF_ANTENNA0_FCSI_SR3_FORCE_DAC0__ISMSK,
			RF_ANTENNA0_FCSI_SR3_FORCE_DAC0_0__SVAL);
}

void rfic_enable_dac2_man (void)
{
	//--------------------------------------------------------------------------
	// Short Register SR3
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(15,  RF_ANTENNA0_FCSI_SR3,
			RF_ANTENNA0_FCSI_SR3_FORCE_DAC2__ISMSK,
			RF_ANTENNA0_FCSI_SR3_FORCE_DAC2_1__SVAL);

	//--------------------------------------------------------------------------
	// Register FILTER - BB FILTER GENERAL	Antx	0x66
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(15, RF_ANTENNA0_FCSI_FILTER,
			RF_ANTENNA1_FCSI_FILTER_EN_OFFSET_CAL__ISMSK,
			RF_ANTENNA1_FCSI_FILTER_EN_OFFSET_CAL_1__SVAL);
}

void rfic_disable_dac2_man (void)
{
	//--------------------------------------------------------------------------
	// Short Register SR3
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(15,  RF_ANTENNA0_FCSI_SR3,
			RF_ANTENNA0_FCSI_SR3_FORCE_DAC2__ISMSK,
			RF_ANTENNA0_FCSI_SR3_FORCE_DAC2_0__SVAL);

	//--------------------------------------------------------------------------
	// Register FILTER - BB FILTER GENERAL	Antx	0x66
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(15, RF_ANTENNA0_FCSI_FILTER,
			RF_ANTENNA1_FCSI_FILTER_EN_OFFSET_CAL__ISMSK,
			RF_ANTENNA1_FCSI_FILTER_EN_OFFSET_CAL_0__SVAL);
}

void rfic_set_dcintegrator(uint16_t IntBW0, uint16_t IntBW2)
{
	//--------------------------------------------------------------------------
	// Register RXMIXERDCOCTL	RX MIXER DC OFFSET CONTROL	Antx	0x70
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(15, RF_ANTENNA0_FCSI_RXMIXERDCOCTL,
			RF_ANTENNA0_FCSI_RXMIXERDCOCTL_INT_BWIDTH_DCO_I__ISMSK
			& RF_ANTENNA0_FCSI_RXMIXERDCOCTL_INT_BWIDTH_DCO_Q__ISMSK,
			(IntBW0-10) << RF_ANTENNA0_FCSI_RXMIXERDCOCTL_INT_BWIDTH_DCO_I__POS
			| (IntBW0-10) << RF_ANTENNA0_FCSI_RXMIXERDCOCTL_INT_BWIDTH_DCO_Q__POS);

	//--------------------------------------------------------------------------
	// Register PGC2DCOCTL - PGC2 DC OFFSET CONTROL	Antx	0x5F
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(15, RF_ANTENNA0_FCSI_PGC2DCOCTL,
			RF_ANTENNA0_FCSI_PGC2DCOCTL_INT_BWIDTH_DCO_I__ISMSK
			& RF_ANTENNA0_FCSI_PGC2DCOCTL_INT_BWIDTH_DCO_Q__ISMSK,
			(IntBW2-10) << RF_ANTENNA0_FCSI_PGC2DCOCTL_INT_BWIDTH_DCO_I__POS
			| (IntBW2-10) << RF_ANTENNA0_FCSI_PGC2DCOCTL_INT_BWIDTH_DCO_Q__POS);
}

void rfic_start_dccancel0 (void)
{
	//--------------------------------------------------------------------------
	// Register RXMIXERDCOCTL	RX MIXER DC OFFSET CONTROL	Antx	0x70
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(15, RF_ANTENNA0_FCSI_RXMIXERDCOCTL,
			RF_ANTENNA0_FCSI_RXMIXERDCOCTL_EN_DCO_I__ISMSK
			& RF_ANTENNA0_FCSI_RXMIXERDCOCTL_EN_DCO_Q__ISMSK,
			RF_ANTENNA0_FCSI_RXMIXERDCOCTL_EN_DCO_I_1__SVAL
			| RF_ANTENNA0_FCSI_RXMIXERDCOCTL_EN_DCO_Q_1__SVAL);
}

void rfic_stop_dccancel0 (void)
{
	//--------------------------------------------------------------------------
	// Register RXMIXERDCOCTL	RX MIXER DC OFFSET CONTROL	Antx	0x70
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(15, RF_ANTENNA0_FCSI_RXMIXERDCOCTL,
			RF_ANTENNA0_FCSI_RXMIXERDCOCTL_EN_DCO_I__ISMSK
			& RF_ANTENNA0_FCSI_RXMIXERDCOCTL_EN_DCO_Q__ISMSK,
			RF_ANTENNA0_FCSI_RXMIXERDCOCTL_EN_DCO_I_0__SVAL
			| RF_ANTENNA0_FCSI_RXMIXERDCOCTL_EN_DCO_Q_0__SVAL);
}

void rfic_start_dccancel2 (void)
{
	//--------------------------------------------------------------------------
	// Register FILTER - BB FILTER GENERAL	Antx	0x66
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(15, RF_ANTENNA0_FCSI_FILTER,
			RF_ANTENNA1_FCSI_FILTER_EN_OFFSET_CAL__ISMSK,
			RF_ANTENNA1_FCSI_FILTER_EN_OFFSET_CAL_1__SVAL);

	//--------------------------------------------------------------------------
	// Register PGC2DCOCTL - PGC2 DC OFFSET CONTROL	Antx	0x5F
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(15, RF_ANTENNA0_FCSI_PGC2DCOCTL,
			RF_ANTENNA1_FCSI_PGC2DCOCTL_EN_DCO_I__ISMSK
			& RF_ANTENNA1_FCSI_PGC2DCOCTL_EN_DCO_Q__ISMSK,
			RF_ANTENNA1_FCSI_PGC2DCOCTL_EN_DCO_I_1__SVAL
			| RF_ANTENNA1_FCSI_PGC2DCOCTL_EN_DCO_Q_1__SVAL);
}

void rfic_stop_dccancel2 (void)
{
	//--------------------------------------------------------------------------
	// Register PGC2DCOCTL - PGC2 DC OFFSET CONTROL	Antx	0x5F
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(15, RF_ANTENNA0_FCSI_PGC2DCOCTL,
			RF_ANTENNA1_FCSI_PGC2DCOCTL_EN_DCO_I__ISMSK
			& RF_ANTENNA1_FCSI_PGC2DCOCTL_EN_DCO_Q__ISMSK,
			RF_ANTENNA1_FCSI_PGC2DCOCTL_EN_DCO_I_0__SVAL
			| RF_ANTENNA1_FCSI_PGC2DCOCTL_EN_DCO_Q_0__SVAL);

	//--------------------------------------------------------------------------
	// Register FILTER - BB FILTER GENERAL	Antx	0x66
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(15, RF_ANTENNA0_FCSI_FILTER,
			RF_ANTENNA1_FCSI_FILTER_EN_OFFSET_CAL__ISMSK,
			RF_ANTENNA1_FCSI_FILTER_EN_OFFSET_CAL_0__SVAL);
}

void rfic_enable_filter_dccal (void)
{
	//--------------------------------------------------------------------------
	// Register FILTER - BB FILTER GENERAL	Antx	0x66
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(15, RF_ANTENNA0_FCSI_FILTER,
			RF_ANTENNA1_FCSI_FILTER_EN_OFFSET_CAL__ISMSK,
			RF_ANTENNA1_FCSI_FILTER_EN_OFFSET_CAL_1__SVAL);
}

void rfic_disable_filter_dccal (void)
{
	//--------------------------------------------------------------------------
	// Register FILTER - BB FILTER GENERAL	Antx	0x66
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(15, RF_ANTENNA0_FCSI_FILTER,
			RF_ANTENNA1_FCSI_FILTER_EN_OFFSET_CAL__ISMSK,
			RF_ANTENNA1_FCSI_FILTER_EN_OFFSET_CAL_0__SVAL);
}

void rfic_set_pllreset (void)
{
	//--------------------------------------------------------------------------
	// Register PLLPUP1 - PLL POWER UP LOCAL	Ant0	0x43
	//-------------------------------------------------------------------------
	RFIC_FCSI_RMW(1, RF_ANTENNA0_FCSI_PLLPUP1,
			RF_ANTENNA0_FCSI_PLLPUP1_RFPLL_RESETN__ISMSK,
			RF_ANTENNA0_FCSI_PLLPUP1_RFPLL_RESETN_1__SVAL);
}

void rfic_release_pllreset (void)
{
	//--------------------------------------------------------------------------
	// Register PLLPUP1 - PLL POWER UP LOCAL	Ant0	0x43
	//-------------------------------------------------------------------------
	RFIC_FCSI_RMW(1, RF_ANTENNA0_FCSI_PLLPUP1,
			RF_ANTENNA0_FCSI_PLLPUP1_RFPLL_RESETN__ISMSK,
			RF_ANTENNA0_FCSI_PLLPUP1_RFPLL_RESETN_0__SVAL);
}

void rfic_enable_lotree (void)
{
	//--------------------------------------------------------------------------
	// Register LOLDO0	LOTREE LDO ANT0		Ant1	0x49
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(2, RF_ANTENNA1_FCSI_LOLDO0,
			RF_ANTENNA1_FCSI_LOLDO0_ENABLE__ISMSK,
			RF_ANTENNA1_FCSI_LOLDO0_ENABLE_1__SVAL);
	//--------------------------------------------------------------------------
	// Register LOLDO1	LOTREE LDO ANT1		Ant1	0x4A
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(2, RF_ANTENNA1_FCSI_LOLDO1,
			RF_ANTENNA1_FCSI_LOLDO1_ENABLE__ISMSK,
			RF_ANTENNA1_FCSI_LOLDO1_ENABLE_1__SVAL);
	//--------------------------------------------------------------------------
	// Register LOLDO2	LOTREE LDO ANT2		Ant1	0x4B
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(2, RF_ANTENNA1_FCSI_LOLDO2,
			RF_ANTENNA1_FCSI_LOLDO2_ENABLE__ISMSK,
			RF_ANTENNA1_FCSI_LOLDO2_ENABLE_1__SVAL);
	//--------------------------------------------------------------------------
	// Register LOLDO3	LOTREE LDO ANT3		Ant1	0x4C
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(2, RF_ANTENNA1_FCSI_LOLDO3,
			RF_ANTENNA1_FCSI_LOLDO3_ENABLE__ISMSK,
			RF_ANTENNA1_FCSI_LOLDO3_ENABLE_1__SVAL);
}

void rfic_disable_lotree (void)
{
	//--------------------------------------------------------------------------
	// Register LOLDO0	LOTREE LDO ANT0		Ant1	0x49
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(2, RF_ANTENNA1_FCSI_LOLDO0,
			RF_ANTENNA1_FCSI_LOLDO0_ENABLE__ISMSK,
			RF_ANTENNA1_FCSI_LOLDO0_ENABLE_0__SVAL);
	//--------------------------------------------------------------------------
	// Register LOLDO1	LOTREE LDO ANT1		Ant1	0x4A
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(2, RF_ANTENNA1_FCSI_LOLDO1,
			RF_ANTENNA1_FCSI_LOLDO1_ENABLE__ISMSK,
			RF_ANTENNA1_FCSI_LOLDO1_ENABLE_0__SVAL);
	//--------------------------------------------------------------------------
	// Register LOLDO2	LOTREE LDO ANT2		Ant1	0x4B
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(2, RF_ANTENNA1_FCSI_LOLDO2,
			RF_ANTENNA1_FCSI_LOLDO2_ENABLE__ISMSK,
			RF_ANTENNA1_FCSI_LOLDO2_ENABLE_0__SVAL);
	//--------------------------------------------------------------------------
	// Register LOLDO3	LOTREE LDO ANT3		Ant1	0x4B
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(2, RF_ANTENNA1_FCSI_LOLDO3,
			RF_ANTENNA1_FCSI_LOLDO3_ENABLE__ISMSK,
			RF_ANTENNA1_FCSI_LOLDO3_ENABLE_0__SVAL);
}

void rfic_enable_filtercal_12_30 (void)
{
	// --> Antenna1 to Antenna2
	// --> Antenna3 to Antenna0
	//--------------------------------------------------------------------------
	// Register FILTER	BB FILTER GENERAL	Antx	0x66
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(10, RF_ANTENNA0_FCSI_FILTER,
			RF_ANTENNA0_FCSI_FILTER_TX_ON__ISMSK,
			RF_ANTENNA0_FCSI_FILTER_TX_ON_1__SVAL);

	//--------------------------------------------------------------------------
	// Register PGC21	PGC2 CTRL + GAIN (SREG TX CONTROL)	Antx	0x59
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(10, RF_ANTENNA0_FCSI_PGC21,
			RF_ANTENNA0_FCSI_PGC21_EN_RX_ON__ISMSK,
			RF_ANTENNA0_FCSI_PGC21_EN_RX_ON_1__SVAL);

	//--------------------------------------------------------------------------
	// Register BBIO - BBO + BBIO CONFIG		Ant2	0x41
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(4, RF_ANTENNA2_FCSI_BBIO,
			RF_ANTENNA2_FCSI_BBIO_EN_BBIO_ANT2__ISMSK
			& RF_ANTENNA2_FCSI_BBIO_EN_BBIO_ANT0__ISMSK,
			RF_ANTENNA2_FCSI_BBIO_EN_BBIO_ANT2_1__SVAL
			| RF_ANTENNA2_FCSI_BBIO_EN_BBIO_ANT0_1__SVAL);

	//--------------------------------------------------------------------------
	// Register BBIOLOOP - BBIO LOOPS	Ant2	0x42
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(4, RF_ANTENNA2_FCSI_BBIOLOOP,
			RF_ANTENNA2_FCSI_BBIOLOOP_EN_IN1_ANT2__ISMSK
			& RF_ANTENNA2_FCSI_BBIOLOOP_EN_IN1_ANT0__ISMSK,
			RF_ANTENNA2_FCSI_BBIOLOOP_EN_IN1_ANT2_1__SVAL
			| RF_ANTENNA2_FCSI_BBIOLOOP_EN_IN1_ANT0_1__SVAL);
}

void rfic_disable_filtercal_12_30 (void)
{
	// --> Antenna1 to Antenna2
	// --> Antenna3 to Antenna0
	//--------------------------------------------------------------------------
	// Register FILTER	BB FILTER GENERAL	Antx	0x66
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(10, RF_ANTENNA0_FCSI_FILTER,
			RF_ANTENNA0_FCSI_FILTER_TX_ON__ISMSK,
			RF_ANTENNA0_FCSI_FILTER_TX_ON_0__SVAL);

	//--------------------------------------------------------------------------
	// Register PGC21	PGC2 CTRL + GAIN (SREG TX CONTROL)	Antx	0x59
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(10, RF_ANTENNA0_FCSI_PGC21,
			RF_ANTENNA0_FCSI_PGC21_EN_RX_ON__ISMSK,
			RF_ANTENNA0_FCSI_PGC21_EN_RX_ON_0__SVAL);

	//--------------------------------------------------------------------------
	// Register BBIO - BBO + BBIO CONFIG		Ant2	0x41
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(4, RF_ANTENNA2_FCSI_BBIO,
			RF_ANTENNA2_FCSI_BBIO_EN_BBIO_ANT2__ISMSK
			& RF_ANTENNA2_FCSI_BBIO_EN_BBIO_ANT0__ISMSK,
			RF_ANTENNA2_FCSI_BBIO_EN_BBIO_ANT2_0__SVAL
			| RF_ANTENNA2_FCSI_BBIO_EN_BBIO_ANT0_0__SVAL);

	//--------------------------------------------------------------------------
	// Register BBIOLOOP - BBIO LOOPS	Ant2	0x42
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(4, RF_ANTENNA2_FCSI_BBIOLOOP,
			RF_ANTENNA2_FCSI_BBIOLOOP_EN_IN1_ANT2__ISMSK
			& RF_ANTENNA2_FCSI_BBIOLOOP_EN_IN1_ANT0__ISMSK,
			RF_ANTENNA2_FCSI_BBIOLOOP_EN_IN1_ANT2_0__SVAL
			| RF_ANTENNA2_FCSI_BBIOLOOP_EN_IN1_ANT0_0__SVAL);
}

void rfic_enable_filtercal_03_21 (void)
{
	// --> Antenna0 to Antenna3
	// --> Antenna2 to Antenna1
	//--------------------------------------------------------------------------
	// Register FILTER	BB FILTER GENERAL	Antx	0x66
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(5, RF_ANTENNA0_FCSI_FILTER,
			RF_ANTENNA0_FCSI_FILTER_TX_ON__ISMSK,
			RF_ANTENNA0_FCSI_FILTER_TX_ON_1__SVAL);

	//--------------------------------------------------------------------------
	// Register PGC21	PGC2 CTRL + GAIN (SREG TX CONTROL)	Antx	0x59
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(5, RF_ANTENNA0_FCSI_PGC21,
			RF_ANTENNA0_FCSI_PGC21_EN_RX_ON__ISMSK,
			RF_ANTENNA0_FCSI_PGC21_EN_RX_ON_1__SVAL);

	//--------------------------------------------------------------------------
	// Register BBIO - BBO + BBIO CONFIG		Ant2	0x41
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(4, RF_ANTENNA2_FCSI_BBIO,
			RF_ANTENNA2_FCSI_BBIO_EN_BBIO_ANT1__ISMSK
			& RF_ANTENNA2_FCSI_BBIO_EN_BBIO_ANT3__ISMSK,
			RF_ANTENNA2_FCSI_BBIO_EN_BBIO_ANT1_1__SVAL
			| RF_ANTENNA2_FCSI_BBIO_EN_BBIO_ANT3_1__SVAL);

	//--------------------------------------------------------------------------
	// Register BBIOLOOP - BBIO LOOPS	Ant2	0x42
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(4, RF_ANTENNA2_FCSI_BBIOLOOP,
			RF_ANTENNA2_FCSI_BBIOLOOP_EN_IN3_ANT1__ISMSK
			& RF_ANTENNA2_FCSI_BBIOLOOP_EN_IN3_ANT3__ISMSK,
			RF_ANTENNA2_FCSI_BBIOLOOP_EN_IN3_ANT1_1__SVAL
			| RF_ANTENNA2_FCSI_BBIOLOOP_EN_IN3_ANT3_1__SVAL);
}

void rfic_disable_filtercal_03_21 (void)
{
	// --> Antenna0 to Antenna3
	// --> Antenna2 to Antenna1
	//--------------------------------------------------------------------------
	// Register FILTER	BB FILTER GENERAL	Antx	0x66
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(5, RF_ANTENNA0_FCSI_FILTER,
			RF_ANTENNA0_FCSI_FILTER_TX_ON__ISMSK,
			RF_ANTENNA0_FCSI_FILTER_TX_ON_0__SVAL);

	//--------------------------------------------------------------------------
	// Register PGC21	PGC2 CTRL + GAIN (SREG TX CONTROL)	Antx	0x59
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(5, RF_ANTENNA0_FCSI_PGC21,
			RF_ANTENNA0_FCSI_PGC21_EN_RX_ON__ISMSK,
			RF_ANTENNA0_FCSI_PGC21_EN_RX_ON_0__SVAL);

	//--------------------------------------------------------------------------
	// Register BBIO - BBO + BBIO CONFIG		Ant2	0x41
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(4, RF_ANTENNA2_FCSI_BBIO,
			RF_ANTENNA2_FCSI_BBIO_EN_BBIO_ANT1__ISMSK
			& RF_ANTENNA2_FCSI_BBIO_EN_BBIO_ANT3__ISMSK,
			RF_ANTENNA2_FCSI_BBIO_EN_BBIO_ANT1_0__SVAL
			| RF_ANTENNA2_FCSI_BBIO_EN_BBIO_ANT3_0__SVAL);

	//--------------------------------------------------------------------------
	// Register BBIOLOOP - BBIO LOOPS	Ant2	0x42
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(4, RF_ANTENNA2_FCSI_BBIOLOOP,
			RF_ANTENNA2_FCSI_BBIOLOOP_EN_IN3_ANT1__ISMSK
			& RF_ANTENNA2_FCSI_BBIOLOOP_EN_IN3_ANT3__ISMSK,
			RF_ANTENNA2_FCSI_BBIOLOOP_EN_IN3_ANT1_0__SVAL
			| RF_ANTENNA2_FCSI_BBIOLOOP_EN_IN3_ANT3_0__SVAL);
}

void rfic_enable_iqbbcal_0_2 (void)
{
	// --> Antenna1 I-path to Antenna0
	// --> Antenna1 Q-path to Antenna2
	//--------------------------------------------------------------------------
	// Register BBIOCAL - BBIO CALIBRATION LOOPS	Ant2	0x40
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(4, RF_ANTENNA2_FCSI_BBIOCAL,
			RF_ANTENNA2_FCSI_BBIOCAL_EN_IQMM_ANT0__ISMSK
			& RF_ANTENNA2_FCSI_BBIOCAL_EN_IQMM_ANT2__ISMSK,
			RF_ANTENNA2_FCSI_BBIOCAL_EN_IQMM_ANT0_1__SVAL
			| RF_ANTENNA2_FCSI_BBIOCAL_EN_IQMM_ANT2_1__SVAL);

	//--------------------------------------------------------------------------
	// Register MIXERPGC1	RX MIXER + PGC1 CONTROL		Ant0+Ant2	0x6C
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(5, RF_ANTENNA0_FCSI_MIXERPGC1,
			RF_ANTENNA0_FCSI_MIXERPGC1_EN_IQMM_CAL__ISMSK,
			RF_ANTENNA0_FCSI_MIXERPGC1_EN_IQMM_CAL_1__SVAL);
}

void rfic_disable_iqbbcal_0_2 (void)
{
	// --> Antenna1 I-path to Antenna0
	// --> Antenna1 Q-path to Antenna2
	//--------------------------------------------------------------------------
	// Register BBIOCAL - BBIO CALIBRATION LOOPS	Ant2	0x40
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(4, RF_ANTENNA2_FCSI_BBIOCAL,
			RF_ANTENNA2_FCSI_BBIOCAL_EN_IQMM_ANT0__ISMSK
			& RF_ANTENNA2_FCSI_BBIOCAL_EN_IQMM_ANT2__ISMSK,
			RF_ANTENNA2_FCSI_BBIOCAL_EN_IQMM_ANT0_0__SVAL
			| RF_ANTENNA2_FCSI_BBIOCAL_EN_IQMM_ANT2_0__SVAL);

	//--------------------------------------------------------------------------
	// Register MIXERPGC1	RX MIXER + PGC1 CONTROL		Ant0+Ant2	0x6C
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(5, RF_ANTENNA0_FCSI_MIXERPGC1,
			RF_ANTENNA0_FCSI_MIXERPGC1_EN_IQMM_CAL__ISMSK,
			RF_ANTENNA0_FCSI_MIXERPGC1_EN_IQMM_CAL_0__SVAL);
}

void rfic_enable_iqbbcal_1_3 (void)
{
	// --> Antenna0 Q-path to Antenna1
	// --> Antenna0 I-path to Antenna3
	//--------------------------------------------------------------------------
	// Register BBIOCAL - BBIO CALIBRATION LOOPS	Ant2	0x40
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(4, RF_ANTENNA2_FCSI_BBIOCAL,
			RF_ANTENNA2_FCSI_BBIOCAL_EN_IQMM_ANT1__ISMSK
			& RF_ANTENNA2_FCSI_BBIOCAL_EN_IQMM_ANT3__ISMSK,
			RF_ANTENNA2_FCSI_BBIOCAL_EN_IQMM_ANT1_1__SVAL
			| RF_ANTENNA2_FCSI_BBIOCAL_EN_IQMM_ANT3_1__SVAL);

	//--------------------------------------------------------------------------
	// Register MIXERPGC1	RX MIXER + PGC1 CONTROL		Ant1+Ant3	0x6C
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(10, RF_ANTENNA0_FCSI_MIXERPGC1,
			RF_ANTENNA0_FCSI_MIXERPGC1_EN_IQMM_CAL__ISMSK,
			RF_ANTENNA0_FCSI_MIXERPGC1_EN_IQMM_CAL_1__SVAL);
}

void rfic_disable_iqbbcal_1_3 (void)
{
	// --> Antenna0 Q-path to Antenna1
	// --> Antenna0 I-path to Antenna3
	//--------------------------------------------------------------------------
	// Register BBIOCAL - BBIO CALIBRATION LOOPS	Ant2	0x40
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(4, RF_ANTENNA2_FCSI_BBIOCAL,
			RF_ANTENNA2_FCSI_BBIOCAL_EN_IQMM_ANT1__ISMSK
			& RF_ANTENNA2_FCSI_BBIOCAL_EN_IQMM_ANT3__ISMSK,
			RF_ANTENNA2_FCSI_BBIOCAL_EN_IQMM_ANT1_0__SVAL
			| RF_ANTENNA2_FCSI_BBIOCAL_EN_IQMM_ANT3_0__SVAL);

	//--------------------------------------------------------------------------
	// Register MIXERPGC1	RX MIXER + PGC1 CONTROL		Ant1+Ant3	0x6C
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(10, RF_ANTENNA0_FCSI_MIXERPGC1,
			RF_ANTENNA0_FCSI_MIXERPGC1_EN_IQMM_CAL__ISMSK,
			RF_ANTENNA0_FCSI_MIXERPGC1_EN_IQMM_CAL_0__SVAL);
}

void rfic_enable_tioloop_0 (void)
{
	//--------------------------------------------------------------------------
	// Register BBIOCAL - BBIO CALIBRATION LOOPS	Ant2	0x40
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(4, RF_ANTENNA2_FCSI_BBIOCAL,
			RF_ANTENNA2_FCSI_BBIOCAL_EN_TIO_ANT0__ISMSK,
			RF_ANTENNA2_FCSI_BBIOCAL_EN_TIO_ANT0_1__SVAL);
}

void rfic_disable_tioloop_0 (void)
{
	//--------------------------------------------------------------------------
	// Register BBIOCAL - BBIO CALIBRATION LOOPS	Ant2	0x40
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(4, RF_ANTENNA2_FCSI_BBIOCAL,
			RF_ANTENNA2_FCSI_BBIOCAL_EN_TIO_ANT0__ISMSK,
			RF_ANTENNA2_FCSI_BBIOCAL_EN_TIO_ANT0_0__SVAL);
}

void rfic_enable_tioloop_1 (void)
{
	//--------------------------------------------------------------------------
	// Register BBIOCAL - BBIO CALIBRATION LOOPS	Ant2	0x40
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(4, RF_ANTENNA2_FCSI_BBIOCAL,
			RF_ANTENNA2_FCSI_BBIOCAL_EN_TIO_ANT1__ISMSK,
			RF_ANTENNA2_FCSI_BBIOCAL_EN_TIO_ANT1_1__SVAL);
}

void rfic_disable_tioloop_1 (void)
{
	//--------------------------------------------------------------------------
	// Register BBIOCAL - BBIO CALIBRATION LOOPS	Ant2	0x40
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(4, RF_ANTENNA2_FCSI_BBIOCAL,
			RF_ANTENNA2_FCSI_BBIOCAL_EN_TIO_ANT1__ISMSK,
			RF_ANTENNA2_FCSI_BBIOCAL_EN_TIO_ANT1_0__SVAL);
}

void rfic_enable_toloop (void)
{
	//--------------------------------------------------------------------------
	// Register BBIOCAL - BBIO CALIBRATION LOOPS	Ant2	0x40
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(4, RF_ANTENNA2_FCSI_BBIOCAL,
			RF_ANTENNA2_FCSI_BBIOCAL_EN_TO_ANT0__ISMSK,
			RF_ANTENNA2_FCSI_BBIOCAL_EN_TO_ANT0_1__SVAL);
}

void rfic_disable_toloop (void)
{
	//--------------------------------------------------------------------------
	// Register BBIOCAL - BBIO CALIBRATION LOOPS	Ant2	0x40
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(4, RF_ANTENNA2_FCSI_BBIOCAL,
			RF_ANTENNA2_FCSI_BBIOCAL_EN_TO_ANT0__ISMSK,
			RF_ANTENNA2_FCSI_BBIOCAL_EN_TO_ANT0_0__SVAL);
}

void rfic_enable_ssbcal (uint8_t AntMsk)
{
	//--------------------------------------------------------------------------
	// Register SSB0 - SSB CAL GENERAL	Antx	0x5E
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(AntMsk, RF_ANTENNA0_FCSI_SSB0,
			RF_ANTENNA0_FCSI_SSB0_CTL_SSBCAL_GAIN1_2__SVAL		// Gain1 12dB
			| RF_ANTENNA0_FCSI_SSB0_CTL_SSBCAL_GAIN2_1__SVAL	// Gain2 6dB
			| RF_ANTENNA0_FCSI_SSB0_EN_OFFSET_DAC_1__SVAL
			| RF_ANTENNA0_FCSI_SSB0_EN_SSBCAL_1__SVAL);
}

void rfic_disable_ssbcal (uint8_t AntMsk)
{
	//--------------------------------------------------------------------------
	// Register SSB0 - SSB CAL GENERAL	Antx	0x5E
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(AntMsk, RF_ANTENNA0_FCSI_SSB0,
			RF_ANTENNA0_FCSI_SSB0_CTL_SSBCAL_GAIN1_0__SVAL
			| RF_ANTENNA0_FCSI_SSB0_CTL_SSBCAL_GAIN2_0__SVAL
			| RF_ANTENNA0_FCSI_SSB0_EN_OFFSET_DAC_0__SVAL
			| RF_ANTENNA0_FCSI_SSB0_EN_SSBCAL_0__SVAL);
}

void rfic_enable_bbio_0_1 (void)
{
	//--------------------------------------------------------------------------
	// Register BBIO - BBO + BBIO CONFIG		Ant2	0x41
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(4, RF_ANTENNA2_FCSI_BBIO,
			RF_ANTENNA2_FCSI_BBIO_EN_BBIO_ANT1__ISMSK,
			RF_ANTENNA2_FCSI_BBIO_EN_BBIO_ANT1_1__SVAL);

	//--------------------------------------------------------------------------
	// Register BBIOLOOP - BBIO LOOPS	Ant2	0x42
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(4, RF_ANTENNA2_FCSI_BBIOLOOP,
			RF_ANTENNA2_FCSI_BBIOLOOP_EN_IN1_ANT1__ISMSK,
			RF_ANTENNA2_FCSI_BBIOLOOP_EN_IN1_ANT1_1__SVAL);
}


void rfic_disable_bbio_0_1 (void)
{
	//--------------------------------------------------------------------------
	// Register BBIO - BBO + BBIO CONFIG		Ant2	0x41
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(4, RF_ANTENNA2_FCSI_BBIO,
			RF_ANTENNA2_FCSI_BBIO_EN_BBIO_ANT1__ISMSK,
			RF_ANTENNA2_FCSI_BBIO_EN_BBIO_ANT1_0__SVAL);

	//--------------------------------------------------------------------------
	// Register BBIOLOOP - BBIO LOOPS	Ant2	0x42
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(4, RF_ANTENNA2_FCSI_BBIOLOOP,
			RF_ANTENNA2_FCSI_BBIOLOOP_EN_IN1_ANT1__ISMSK,
			RF_ANTENNA2_FCSI_BBIOLOOP_EN_IN1_ANT1_0__SVAL);
}

void rfic_enable_bbio_1_0 (void)
{
	//--------------------------------------------------------------------------
	// Register BBIO - BBO + BBIO CONFIG		Ant2	0x41
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(4, RF_ANTENNA2_FCSI_BBIO,
			RF_ANTENNA2_FCSI_BBIO_EN_BBIO_ANT0__ISMSK,
			RF_ANTENNA2_FCSI_BBIO_EN_BBIO_ANT0_1__SVAL);

	//--------------------------------------------------------------------------
	// Register BBIOLOOP - BBIO LOOPS	Ant2	0x42
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(4, RF_ANTENNA2_FCSI_BBIOLOOP,
			RF_ANTENNA2_FCSI_BBIOLOOP_EN_IN3_ANT0__ISMSK,
			RF_ANTENNA2_FCSI_BBIOLOOP_EN_IN3_ANT0_1__SVAL);
}

void rfic_disable_bbio_1_0 (void)
{
	//--------------------------------------------------------------------------
	// Register BBIO - BBO + BBIO CONFIG		Ant2	0x41
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(4, RF_ANTENNA2_FCSI_BBIO,
			RF_ANTENNA2_FCSI_BBIO_EN_BBIO_ANT0__ISMSK,
			RF_ANTENNA2_FCSI_BBIO_EN_BBIO_ANT0_0__SVAL);

	//--------------------------------------------------------------------------
	// Register BBIOLOOP - BBIO LOOPS	Ant2	0x42
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(4, RF_ANTENNA2_FCSI_BBIOLOOP,
			RF_ANTENNA2_FCSI_BBIOLOOP_EN_IN3_ANT0__ISMSK,
			RF_ANTENNA2_FCSI_BBIOLOOP_EN_IN3_ANT0_0__SVAL);
}

void rfic_enable_bbio_2_0 (void)
{
	//--------------------------------------------------------------------------
	// Register BBIO - BBO + BBIO CONFIG		Ant2	0x41
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(4, RF_ANTENNA2_FCSI_BBIO,
			RF_ANTENNA2_FCSI_BBIO_EN_BBIO_ANT0__ISMSK,
			RF_ANTENNA2_FCSI_BBIO_EN_BBIO_ANT0_1__SVAL);

	//--------------------------------------------------------------------------
	// Register BBIOLOOP - BBIO LOOPS	Ant2	0x42
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(4, RF_ANTENNA2_FCSI_BBIOLOOP,
			RF_ANTENNA2_FCSI_BBIOLOOP_EN_IN2_ANT0__ISMSK,
			RF_ANTENNA2_FCSI_BBIOLOOP_EN_IN2_ANT0_1__SVAL);
}
void rfic_disable_bbio_2_0 (void)
{
	//--------------------------------------------------------------------------
	// Register BBIO - BBO + BBIO CONFIG		Ant2	0x41
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(4, RF_ANTENNA2_FCSI_BBIO,
			RF_ANTENNA2_FCSI_BBIO_EN_BBIO_ANT0__ISMSK,
			RF_ANTENNA2_FCSI_BBIO_EN_BBIO_ANT0_0__SVAL);

	//--------------------------------------------------------------------------
	// Register BBIOLOOP - BBIO LOOPS	Ant2	0x42
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(4, RF_ANTENNA2_FCSI_BBIOLOOP,
			RF_ANTENNA2_FCSI_BBIOLOOP_EN_IN2_ANT0__ISMSK,
			RF_ANTENNA2_FCSI_BBIOLOOP_EN_IN2_ANT0_0__SVAL);
}

void rfic_enable_bbio_3_0 (void)
{
	//--------------------------------------------------------------------------
	// Register BBIO - BBO + BBIO CONFIG		Ant2	0x41
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(4, RF_ANTENNA2_FCSI_BBIO,
			RF_ANTENNA2_FCSI_BBIO_EN_BBIO_ANT0__ISMSK,
			RF_ANTENNA2_FCSI_BBIO_EN_BBIO_ANT0_1__SVAL);

	//--------------------------------------------------------------------------
	// Register BBIOLOOP - BBIO LOOPS	Ant2	0x42
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(4, RF_ANTENNA2_FCSI_BBIOLOOP,
			RF_ANTENNA2_FCSI_BBIOLOOP_EN_IN1_ANT0__ISMSK,
			RF_ANTENNA2_FCSI_BBIOLOOP_EN_IN1_ANT0_1__SVAL);
}
void rfic_disable_bbio_3_0 (void)
{
	//--------------------------------------------------------------------------
	// Register BBIO - BBO + BBIO CONFIG		Ant2	0x41
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(4, RF_ANTENNA2_FCSI_BBIO,
			RF_ANTENNA2_FCSI_BBIO_EN_BBIO_ANT0__ISMSK,
			RF_ANTENNA2_FCSI_BBIO_EN_BBIO_ANT0_0__SVAL);

	//--------------------------------------------------------------------------
	// Register BBIOLOOP - BBIO LOOPS	Ant2	0x42
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(4, RF_ANTENNA2_FCSI_BBIOLOOP,
			RF_ANTENNA2_FCSI_BBIOLOOP_EN_IN1_ANT0__ISMSK,
			RF_ANTENNA2_FCSI_BBIOLOOP_EN_IN1_ANT0_0__SVAL);
}


void rfic_enable_bbo_0_0 (void)
{
	//--------------------------------------------------------------------------
	// Register BBOLOOP		BBO LOOPS		Ant2	0x43
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(4, RF_ANTENNA2_FCSI_BBOLOOP,
			RF_ANTENNA2_FCSI_BBOLOOP_EN_IN0_ANT3_1__SVAL
			| RF_ANTENNA2_FCSI_BBOLOOP_EN_IN0_ANT2_1__SVAL
			| RF_ANTENNA2_FCSI_BBOLOOP_EN_IN0_ANT1_1__SVAL
			| RF_ANTENNA2_FCSI_BBOLOOP_EN_IN0_ANT0_1__SVAL);
}

void rfic_enable_bbo_1_0 (void)
{
	//--------------------------------------------------------------------------
	// Register BBOLOOP		BBO LOOPS		Ant2	0x43
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(4, RF_ANTENNA2_FCSI_BBOLOOP,
			RF_ANTENNA2_FCSI_BBOLOOP_EN_IN3_ANT0_1__SVAL);
}

void rfic_enable_bbo_2_0 (void)
{
	//--------------------------------------------------------------------------
	// Register BBOLOOP		BBO LOOPS		Ant2	0x43
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(4, RF_ANTENNA2_FCSI_BBOLOOP,
			RF_ANTENNA2_FCSI_BBOLOOP_EN_IN2_ANT0_1__SVAL);
}

void rfic_enable_bbo_3_0 (void)
{
	//--------------------------------------------------------------------------
	// Register BBOLOOP		BBO LOOPS		Ant2	0x43
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(4, RF_ANTENNA2_FCSI_BBOLOOP,
			RF_ANTENNA2_FCSI_BBOLOOP_EN_IN1_ANT0_1__SVAL);
}

void rfic_set_lo_frequency (uint16_t LoFreq)
{
	uint16_t	F0_int, X;
	uint32_t	F0_frac, XY;
	int32_t		Y;

	//--------------------------------------------------------------------------
	// Register PLLMISC		PLL MISCELLANEOUS		Ant0	0x4A
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(1, RF_ANTENNA0_FCSI_PLLMISC,
			RF_ANTENNA0_FCSI_PLLMISC_RFPLL_FAST_CHANNEL_HOP_EN__ISMSK,
			RF_ANTENNA0_FCSI_PLLMISC_RFPLL_FAST_CHANNEL_HOP_EN_0__SVAL); // should already be active, could be removed

    XY = (uint32_t) (LoFreq << 20)/5 - (8 << 21);;
    X = (uint16_t) (XY >> 22);
    Y = (int32_t) XY - (int32_t)(X << 22);

    if (Y-((Y >> 21) << 21) >= (1 << 20))
    {
    	X++;
    	Y -= (2 << 21);
    }

    F0_int = X;
    if (Y < 0)
    	F0_frac = (Y + (8 << 21));
    else
    	F0_frac = Y;

	//--------------------------------------------------------------------------
	// Register PLLSDM2 - PLL SIGMA DELTA 2		Ant0	0x47
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(1, RF_ANTENNA0_FCSI_PLLSDM1,
			F0_frac >> 8);

	//--------------------------------------------------------------------------
	// Register PLLSDM2 - PLL SIGMA DELTA 2		Ant0	0x48
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(1, RF_ANTENNA0_FCSI_PLLSDM2,
			F0_int + ((F0_frac & 255) << 8));

}

void rfic_set_lo_frequency_int (uint16_t LoFreq)
{
	//--------------------------------------------------------------------------
	// Register PLLMISC		PLL MISCELLANEOUS		Ant0	0x4A
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(1, RF_ANTENNA0_FCSI_PLLMISC,
			RF_ANTENNA0_FCSI_PLLMISC_RFPLL_FAST_CHANNEL_HOP_EN__ISMSK
			& RF_ANTENNA0_FCSI_PLLMISC_RFPLL_REF_SEL_40M__ISMSK,
			RF_ANTENNA0_FCSI_PLLMISC_RFPLL_FAST_CHANNEL_HOP_EN_0__SVAL
			| RF_ANTENNA0_FCSI_PLLMISC_RFPLL_REF_SEL_40M_1__SVAL);

	//--------------------------------------------------------------------------
	// Register PLLSDM2 - PLL SIGMA DELTA 2		Ant0	0x48
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(1, RF_ANTENNA0_FCSI_PLLSDM2,
			LoFreq*4/40 << RF_ANTENNA0_FCSI_PLLSDM2_DIVN_INT_CH1__POS);

}


// not needed for WRX514
//void rfic_set_lo_frequency_40M (uint16_t LoFreq)
//{
//	//--------------------------------------------------------------------------
//	// Register PLLMISC		PLL MISCELLANEOUS		Ant0	0x4A
//	//--------------------------------------------------------------------------
//	RFIC_FCSI_RMW(1, RF_ANTENNA0_FCSI_PLLMISC,
//			RF_ANTENNA0_FCSI_PLLMISC_RFPLL_FAST_CHANNEL_HOP_EN__ISMSK
//			& RF_ANTENNA0_FCSI_PLLMISC_RFPLL_REF_SEL_40M__ISMSK,
//			RF_ANTENNA0_FCSI_PLLMISC_RFPLL_FAST_CHANNEL_HOP_EN_0__SVAL
//			| RF_ANTENNA0_FCSI_PLLMISC_RFPLL_REF_SEL_40M_1__SVAL);
//
//	//--------------------------------------------------------------------------
//	// Register PLLSDM2 - PLL SIGMA DELTA 2		Ant0	0x48
//	//--------------------------------------------------------------------------
//	RFIC_FCSI_Write(1, RF_ANTENNA0_FCSI_PLLSDM2,
//			LoFreq*2/40 << RF_ANTENNA0_FCSI_PLLSDM2_DIVN_INT_CH1__POS);
//}


void rfic_set_lo_frequencies (uint16_t LoFreq0,uint16_t LoFreq1,uint16_t LoFreq2,uint16_t LoFreq3,uint16_t LoFreq4,uint16_t LoFreq5)
{
	uint16_t	k, F0_int, X[6], F_lo_MHz[6], Ftmp, Fp, F_preset[5];
	uint32_t	F0_frac, XY;
	int16_t		Yint;
	int32_t		Y[6], Yfrac;

	// copy input freqs to internal array
	F_lo_MHz[0] = LoFreq0;
	F_lo_MHz[1] = LoFreq1;
	F_lo_MHz[2] = LoFreq2;
	F_lo_MHz[3] = LoFreq3;
	F_lo_MHz[4] = LoFreq4;
	F_lo_MHz[5] = LoFreq5;

	//--------------------------------------------------------------------------
	// Register PLLMISC		PLL MISCELLANEOUS		Ant0	0x4A
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(1, RF_ANTENNA0_FCSI_PLLMISC,
			RF_ANTENNA0_FCSI_PLLMISC_RFPLL_FAST_CHANNEL_HOP_EN__ISMSK,
			RF_ANTENNA0_FCSI_PLLMISC_RFPLL_FAST_CHANNEL_HOP_EN_1__SVAL); // should already be active, could be removed

    for (k=0;k<6;k++)
    {
        if (F_lo_MHz[k] > 0)
        {
            XY = (uint32_t) (F_lo_MHz[k] << 20)/5 - (8 << 21);
            X[k] = (uint16_t) (XY >> 22);
            Y[k] = (int32_t) XY - (int32_t)(X[k] << 22);

            if (Y[k]-((Y[k] >> 21) << 21) >= (1 << 20))
            {
                X[k]++;
                Y[k] -= (2 << 21);
            }
        }
        else
        {
            X[k] = 0; Y[k] = 0.0;
        }
    }

    F0_int = X[0];
    if (Y[0] < 0)
    	F0_frac = (Y[0] + (8 << 21));
    else
    	F0_frac = Y[0];

    for (k=1;k<6;k++)
    {
        Yint = (int16_t) (Y[k] >> 21);
        Yfrac = Y[k] - (Yint << 21);
        Fp = (X[k]-(16+32+64)) << 7;
        if (Yint < 0)
            Ftmp = (8 + Yint) << 4;
        else
            Ftmp = Yint << 4;
        Fp += Ftmp;
        if (Yfrac >= (1 << 20))
        {
             Fp += 8;
             Fp += (uint16_t) ((10*(Yfrac - (1 << 20)) + (1 << 20)) >> 21); // add 0.5 for correct rounding
        }
        else
        {
             Fp += (uint16_t) ((10*Yfrac + (1 << 20)) >> 21); // add 0.5 for correct rounding
        }
        F_preset[k-1] = Fp;
    }

	//--------------------------------------------------------------------------
	// Register PLLSDM2 - PLL SIGMA DELTA 2		Ant0	0x47
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(1, RF_ANTENNA0_FCSI_PLLSDM1,
			F0_frac >> 8);

	//--------------------------------------------------------------------------
	// Register PLLSDM2 - PLL SIGMA DELTA 2		Ant0	0x48
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(1, RF_ANTENNA0_FCSI_PLLSDM2,
			F0_int + ((F0_frac & 255) << 8));

	//--------------------------------------------------------------------------
	// Register PLLCH2 - PLL FAST CHANNEL HOP 2		Ant0	0x4B
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(1, RF_ANTENNA0_FCSI_PLLCH2,
			F_preset[0] << RF_ANTENNA0_FCSI_PLLCH2_DIV_INT_CH2__POS);

	//--------------------------------------------------------------------------
	// Register PLLCH3 - PLL FAST CHANNEL HOP 3		Ant0	0x4C
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(1, RF_ANTENNA0_FCSI_PLLCH3,
			F_preset[1] << RF_ANTENNA0_FCSI_PLLCH3_DIV_INT_CH3__POS);

	//--------------------------------------------------------------------------
	// Register PLLCH4 - PLL FAST CHANNEL HOP 4		Ant0	0x4D
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(1, RF_ANTENNA0_FCSI_PLLCH4,
			F_preset[2] << RF_ANTENNA0_FCSI_PLLCH4_DIV_INT_CH4__POS);

	//--------------------------------------------------------------------------
	// Register PLLCH5 - PLL FAST CHANNEL HOP 5		Ant0	0x4E
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(1, RF_ANTENNA0_FCSI_PLLCH5,
			F_preset[3] << RF_ANTENNA0_FCSI_PLLCH5_DIV_INT_CH5__POS);

	//--------------------------------------------------------------------------
	// Register PLLCH6 - PLL FAST CHANNEL HOP 6		Ant0	0x4F
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(1, RF_ANTENNA0_FCSI_PLLCH6,
			F_preset[4] << RF_ANTENNA0_FCSI_PLLCH6_DIV_INT_CH6__POS);

}

void rfic_set_lo_frequencies_alt (uint16_t LoFreq0,uint16_t LoFreq1,uint16_t LoFreq2,uint16_t LoFreq3,uint16_t LoFreq4,uint16_t LoFreq5,uint8_t *sel)
{
	uint16_t	k, F0_int, X[6], F_lo_MHz[6], Ftmp, Fp, F_preset[5];
	uint32_t	F0_frac, XY;
	int16_t		Yint, Offs[4], Xh;
	int32_t		Y[6], Yfrac, Yh, R;

	// copy input freqs to internal array
	F_lo_MHz[0] = LoFreq0;
	F_lo_MHz[1] = LoFreq1;
	F_lo_MHz[2] = LoFreq2;
	F_lo_MHz[3] = LoFreq3;
	F_lo_MHz[4] = LoFreq4;
	F_lo_MHz[5] = LoFreq5;

	//--------------------------------------------------------------------------
	// Register PLLMISC		PLL MISCELLANEOUS		Ant0	0x4A
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(1, RF_ANTENNA0_FCSI_PLLMISC,
			RF_ANTENNA0_FCSI_PLLMISC_RFPLL_FAST_CHANNEL_HOP_EN__ISMSK,
			RF_ANTENNA0_FCSI_PLLMISC_RFPLL_FAST_CHANNEL_HOP_EN_1__SVAL); // should already be active, could be removed


    for (k=0;k<6;k++)
    {
        if (F_lo_MHz[k] > 0)
        {
            XY = (uint32_t) (F_lo_MHz[k] << 20)/5 - (8 << 21);
            Xh = (uint16_t) (XY >> 22);
            Yh = (int32_t) XY - (int32_t)(Xh << 22);

            R = Yh-((Yh >> 21) << 21);

            if (R == 0)
            {
            	Offs[0] = 0; Offs[1] = -1; Offs[2] = 1; Offs[3] = 2;
            }
            else if (R >= (1 << 20))
            {
            	Offs[0] = 1; Offs[1] = 2; Offs[2] = 2; Offs[3] = 2;
            }
            else
            {
            	Offs[0] = 0; Offs[1] = -1; Offs[2] = -1; Offs[3] = -1;
            }
            Xh += Offs[sel[k]];
            Yh -= ((int32_t) Offs[sel[k]]) << 22;
        }
        else
        {
            Xh = 0; Yh = 0;
        }
        X[k] = Xh;
        Y[k] = Yh;
    }

    F0_int = X[0];
    if (Y[0] < 0)
    	F0_frac = (Y[0] + (8 << 21));
    else
    	F0_frac = Y[0];

    for (k=1;k<6;k++)
    {
        Yint = (int16_t) (Y[k] >> 21);
        Yfrac = Y[k] - (Yint << 21);
        Fp = (X[k]-(16+32+64)) << 7;
        if (Yint < 0)
            Ftmp = (8 + Yint) << 4;
        else
            Ftmp = Yint << 4;
        Fp += Ftmp;
        if (Yfrac >= (1 << 20))
        {
             Fp += 8;
             Fp += (uint16_t) ((10*(Yfrac - (1 << 20)) + (1 << 20)) >> 21); // add 0.5 for correct rounding
        }
        else
        {
             Fp += (uint16_t) ((10*Yfrac + (1 << 20)) >> 21); // add 0.5 for correct rounding
        }
        F_preset[k-1] = Fp;
    }

	//--------------------------------------------------------------------------
	// Register PLLSDM2 - PLL SIGMA DELTA 2		Ant0	0x47
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(1, RF_ANTENNA0_FCSI_PLLSDM1,
			F0_frac >> 8);

	//--------------------------------------------------------------------------
	// Register PLLSDM2 - PLL SIGMA DELTA 2		Ant0	0x48
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(1, RF_ANTENNA0_FCSI_PLLSDM2,
			F0_int + ((F0_frac & 255) << 8));

	//--------------------------------------------------------------------------
	// Register PLLCH2 - PLL FAST CHANNEL HOP 2		Ant0	0x4B
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(1, RF_ANTENNA0_FCSI_PLLCH2,
			F_preset[0] << RF_ANTENNA0_FCSI_PLLCH2_DIV_INT_CH2__POS);

	//--------------------------------------------------------------------------
	// Register PLLCH3 - PLL FAST CHANNEL HOP 3		Ant0	0x4C
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(1, RF_ANTENNA0_FCSI_PLLCH3,
			F_preset[1] << RF_ANTENNA0_FCSI_PLLCH3_DIV_INT_CH3__POS);

	//--------------------------------------------------------------------------
	// Register PLLCH4 - PLL FAST CHANNEL HOP 4		Ant0	0x4D
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(1, RF_ANTENNA0_FCSI_PLLCH4,
			F_preset[2] << RF_ANTENNA0_FCSI_PLLCH4_DIV_INT_CH4__POS);

	//--------------------------------------------------------------------------
	// Register PLLCH5 - PLL FAST CHANNEL HOP 5		Ant0	0x4E
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(1, RF_ANTENNA0_FCSI_PLLCH5,
			F_preset[3] << RF_ANTENNA0_FCSI_PLLCH5_DIV_INT_CH5__POS);

	//--------------------------------------------------------------------------
	// Register PLLCH6 - PLL FAST CHANNEL HOP 6		Ant0	0x4F
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(1, RF_ANTENNA0_FCSI_PLLCH6,
			F_preset[4] << RF_ANTENNA0_FCSI_PLLCH6_DIV_INT_CH6__POS);

}

void rfic_set_lo_frequencies_int (uint16_t LoFreq0,uint16_t LoFreq1,uint16_t LoFreq2,uint16_t LoFreq3,uint16_t LoFreq4,uint16_t LoFreq5)
{
	//--------------------------------------------------------------------------
	// Register PLLMISC		PLL MISCELLANEOUS		Ant0	0x4A
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(1, RF_ANTENNA0_FCSI_PLLMISC,
			RF_ANTENNA0_FCSI_PLLMISC_RFPLL_FAST_CHANNEL_HOP_EN__ISMSK
			& RF_ANTENNA0_FCSI_PLLMISC_RFPLL_REF_SEL_40M__ISMSK,
			RF_ANTENNA0_FCSI_PLLMISC_RFPLL_FAST_CHANNEL_HOP_EN_1__SVAL
			| RF_ANTENNA0_FCSI_PLLMISC_RFPLL_REF_SEL_40M_1__SVAL);


	//--------------------------------------------------------------------------
	// Register PLLSDM2 - PLL SIGMA DELTA 2		Ant0	0x48
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(1, RF_ANTENNA0_FCSI_PLLSDM2,
			LoFreq0*4/40 << RF_ANTENNA0_FCSI_PLLSDM2_DIVN_INT_CH1__POS);

	//--------------------------------------------------------------------------
	// Register PLLCH2 - PLL FAST CHANNEL HOP 2		Ant0	0x4B
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(1, RF_ANTENNA0_FCSI_PLLCH2,
			LoFreq1*4/40 << RF_ANTENNA0_FCSI_PLLCH2_DIV_INT_CH2__POS);

	//--------------------------------------------------------------------------
	// Register PLLCH3 - PLL FAST CHANNEL HOP 3		Ant0	0x4C
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(1, RF_ANTENNA0_FCSI_PLLCH3,
			LoFreq2*4/40 << RF_ANTENNA0_FCSI_PLLCH3_DIV_INT_CH3__POS);

	//--------------------------------------------------------------------------
	// Register PLLCH4 - PLL FAST CHANNEL HOP 4		Ant0	0x4D
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(1, RF_ANTENNA0_FCSI_PLLCH4,
			LoFreq3*4/40 << RF_ANTENNA0_FCSI_PLLCH4_DIV_INT_CH4__POS);

	//--------------------------------------------------------------------------
	// Register PLLCH5 - PLL FAST CHANNEL HOP 5		Ant0	0x4E
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(1, RF_ANTENNA0_FCSI_PLLCH5,
			LoFreq4*4/40 << RF_ANTENNA0_FCSI_PLLCH5_DIV_INT_CH5__POS);

	//--------------------------------------------------------------------------
	// Register PLLCH6 - PLL FAST CHANNEL HOP 6		Ant0	0x4F
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(1, RF_ANTENNA0_FCSI_PLLCH6,
			LoFreq5*4/40 << RF_ANTENNA0_FCSI_PLLCH6_DIV_INT_CH6__POS);

}

void rfic_set_pll_intmode (void)
{
	//--------------------------------------------------------------------------
	// Register PLLSDM0		PLL SIGMA DELTA 0 		Ant0	0x46
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(1, RF_ANTENNA0_FCSI_PLLSDM0,
			RF_ANTENNA0_FCSI_PLLSDM0_SDM_EN_0__SVAL);
}

void rfic_set_pll_fracnmode (void)
{
	//--------------------------------------------------------------------------
	// Register PLLSDM0		PLL SIGMA DELTA 0 		Ant0	0x46
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(1, RF_ANTENNA0_FCSI_PLLSDM0,
			RF_ANTENNA0_FCSI_PLLSDM0_SDM_EN_1__SVAL);
}

void rfic_trim_dcxo (uint8_t CapTrimX1,uint8_t CapTrimX2)
{
	//--------------------------------------------------------------------------
	// Register DCXO0		DCXO0 Trimming		Ant1	0x40
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(2, RF_ANTENNA1_FCSI_DCXO0,
			RF_ANTENNA1_FCSI_DCXO0_CAP_TRIM_X1__ISMSK
			& RF_ANTENNA1_FCSI_DCXO0_CAP_TRIM_X2__ISMSK,
			CapTrimX1 << RF_ANTENNA1_FCSI_DCXO0_CAP_TRIM_X1__POS
			| CapTrimX2 << RF_ANTENNA1_FCSI_DCXO0_CAP_TRIM_X2__POS);
}

void rfic_start_tempsensor_clock (void)
{
	//--------------------------------------------------------------------------
	// Register CMOSCLKTREE - LO CENTRAL	Ant1	0x41
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(2, RF_ANTENNA1_FCSI_CMOSCLKTREE,
			RF_ANTENNA1_FCSI_CMOSCLKTREE_EN_TEMPSENSOR_CLK__ISMSK,
			RF_ANTENNA1_FCSI_CMOSCLKTREE_EN_TEMPSENSOR_CLK_1__SVAL);
}

void rfic_stop_tempsensor_clock (void)
{
	//--------------------------------------------------------------------------
	// Register CMOSCLKTREE - LO CENTRAL	Ant1	0x41
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(2, RF_ANTENNA1_FCSI_CMOSCLKTREE,
			RF_ANTENNA1_FCSI_CMOSCLKTREE_EN_TEMPSENSOR_CLK__ISMSK,
			RF_ANTENNA1_FCSI_CMOSCLKTREE_EN_TEMPSENSOR_CLK_0__SVAL);
}

void rfic_enable_tempsensor (void)
{
	//--------------------------------------------------------------------------
	// Register	TEMPSENS1 - TEMP SENSOR 1	Ant2	0x4D
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(4, RF_ANTENNA2_FCSI_TEMPSENS1,
			RF_ANTENNA2_FCSI_TEMPSENS1_EN_DTS__ISMSK,
			RF_ANTENNA2_FCSI_TEMPSENS1_EN_DTS_1__SVAL);
}

void rfic_disable_tempsensor (void)
{
	//--------------------------------------------------------------------------
	// Register	TEMPSENS1 - TEMP SENSOR 1	Ant2	0x4D
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(4, RF_ANTENNA2_FCSI_TEMPSENS1,
			RF_ANTENNA2_FCSI_TEMPSENS1_EN_DTS__ISMSK,
			RF_ANTENNA2_FCSI_TEMPSENS1_EN_DTS_0__SVAL);
}

void rfic_start_tempsensor_cal (void)
{
	//--------------------------------------------------------------------------
	// Register	TEMPSENS1 - TEMP SENSOR 1	Ant2	0x4D
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(4, RF_ANTENNA2_FCSI_TEMPSENS1,
			RF_ANTENNA2_FCSI_TEMPSENS1_EN_VCAL__ISMSK,
			RF_ANTENNA2_FCSI_TEMPSENS1_EN_VCAL_1__SVAL);
}

void rfic_stop_tempsensor_cal (void)
{
	//--------------------------------------------------------------------------
	// Register	TEMPSENS1 - TEMP SENSOR 1	Ant2	0x4D
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(4, RF_ANTENNA2_FCSI_TEMPSENS1,
			RF_ANTENNA2_FCSI_TEMPSENS1_EN_VCAL__ISMSK,
			RF_ANTENNA2_FCSI_TEMPSENS1_EN_VCAL_0__SVAL);
}

void rfic_start_tempsensor (void)
{
	//--------------------------------------------------------------------------
	// Register	TEMPSENS1 - TEMP SENSOR 1	Ant2	0x4D
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(4, RF_ANTENNA2_FCSI_TEMPSENS1,
			RF_ANTENNA2_FCSI_TEMPSENS1_START__ISMSK,
			RF_ANTENNA2_FCSI_TEMPSENS1_START_0__SVAL);

	RFIC_FCSI_RMW(4, RF_ANTENNA2_FCSI_TEMPSENS1,
			RF_ANTENNA2_FCSI_TEMPSENS1_START__ISMSK,
			RF_ANTENNA2_FCSI_TEMPSENS1_START_1__SVAL);
}

uint16_t rfic_read_tempsensor (void)
{
	uint16_t	data[4];
	RFIC_FCSI_Read(15, RF_ANTENNA2_FCSI_TEMPSENS0, data);

	return (data[2] & RF_ANTENNA2_FCSI_TEMPSENS0_RESULT__MSK);
}

void rfic_antenna_off (uint8_t AntMsk, uint16_t Twait_us)
{
	uint16_t	data[4];
	uint8_t		AntMskAct, AntSel, ant, Wait_needed;
	//--------------------------------------------------------------------------
	// Register CONFIG0 - CONFIG0	Ant2	0x4A
	//-------------------------------------------------------------------------
	RFIC_FCSI_Read(15, RF_ANTENNA2_FCSI_CONFIG0, data);
	AntMskAct = data[2];

	Wait_needed = 0;
	for (ant=0; ant < 4; ant++)
	{
		AntSel = 1 << ant;
		if ((AntMsk & AntSel) != (AntMskAct & AntSel))
		{
			if (Wait_needed)
				RFIC_Wait(Twait_us); // only add a wait if needed
			AntMskAct = ((AntMskAct & (15-AntSel)) + (AntMsk & AntSel));
			RFIC_FCSI_Write(4, RF_ANTENNA2_FCSI_CONFIG0,
					AntMskAct << RF_ANTENNA2_FCSI_CONFIG0_LO_OFF_ANT0__POS
					| AntMskAct << RF_ANTENNA2_FCSI_CONFIG0_BBIO_OFF_ANT0__POS
					| AntMskAct << RF_ANTENNA2_FCSI_CONFIG0_ANT0_OFF__POS);
			Wait_needed = 1;
		}
	}
}

void rfic_enable_pll_lowpower (void)
{
	//--------------------------------------------------------------------------
	// Register PLLPMU0 - PLL PMU CENTRAL	Ant0	0x41
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(1, RF_ANTENNA0_FCSI_PLLPMU0,
			RF_ANTENNA0_FCSI_PLLPMU0_LDO_VCO_SEL__ISMSK,
			RF_ANTENNA0_FCSI_PLLPMU0_LDO_VCO_SEL_4__SVAL);
}

void rfic_disable_pll_lowpower (void)
{
	//--------------------------------------------------------------------------
	// Register PLLPMU0 - PLL PMU CENTRAL	Ant0	0x41
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(1, RF_ANTENNA0_FCSI_PLLPMU0,
			RF_ANTENNA0_FCSI_PLLPMU0_LDO_VCO_SEL__ISMSK,
			RF_ANTENNA0_FCSI_PLLPMU0_LDO_VCO_SEL_0__SVAL);
}

void rfic_set_anamux2vddmon (void)
{
	//--------------------------------------------------------------------------
	// Register ANAMUX	ANAMUX	Antx	0x62
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(15, RF_ANTENNA0_FCSI_ANAMUX,
			RF_ANTENNA0_FCSI_ANAMUX_SEL_SSI__ISMSK
			& RF_ANTENNA0_FCSI_ANAMUX_SEL_COMP_TESTMODE__ISMSK
			& RF_ANTENNA0_FCSI_ANAMUX_SEL_SUPPLYMON__ISMSK,
			RF_ANTENNA0_FCSI_ANAMUX_SEL_SSI_0__SVAL
			| RF_ANTENNA0_FCSI_ANAMUX_SEL_COMP_TESTMODE_0__SVAL
			| RF_ANTENNA0_FCSI_ANAMUX_SEL_SUPPLYMON_1__SVAL);
}

void rfic_set_anamux2ssi (void)
{
	//--------------------------------------------------------------------------
	// Register ANAMUX	ANAMUX	Antx	0x62
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(15, RF_ANTENNA0_FCSI_ANAMUX,
			RF_ANTENNA0_FCSI_ANAMUX_SEL_SSI__ISMSK
			& RF_ANTENNA0_FCSI_ANAMUX_SEL_COMP_TESTMODE__ISMSK
			& RF_ANTENNA0_FCSI_ANAMUX_SEL_SUPPLYMON__ISMSK,
			RF_ANTENNA0_FCSI_ANAMUX_SEL_SSI_1__SVAL
			| RF_ANTENNA0_FCSI_ANAMUX_SEL_COMP_TESTMODE_0__SVAL
			| RF_ANTENNA0_FCSI_ANAMUX_SEL_SUPPLYMON_0__SVAL);
}

void rfic_enable_vddmon_cal (void)
{
	//--------------------------------------------------------------------------
	// Register VDDMON - VDD MONITOR	Antx	0x63
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(15, RF_ANTENNA0_FCSI_VDDMON,
			RF_ANTENNA0_FCSI_VDDMON_EN_OPAMPS_1__SVAL
			| RF_ANTENNA0_FCSI_VDDMON_CTL_TSSI_IN_1__SVAL);
}

void rfic_enable_vddmon_1V2rxldo (void)
{
	//--------------------------------------------------------------------------
	// Register VDDMON - VDD MONITOR	Antx	0x63
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(15, RF_ANTENNA0_FCSI_VDDMON,
			RF_ANTENNA0_FCSI_VDDMON_EN_OPAMPS_1__SVAL
			| RF_ANTENNA0_FCSI_VDDMON_CTL_RXLDO_1__SVAL);
}

void rfic_enable_vddmon_1V2txldo (void)
{
	//--------------------------------------------------------------------------
	// Register VDDMON - VDD MONITOR	Antx	0x63
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(15, RF_ANTENNA0_FCSI_VDDMON,
			RF_ANTENNA0_FCSI_VDDMON_EN_OPAMPS_1__SVAL
			| RF_ANTENNA0_FCSI_VDDMON_CTL_TXLDO_1__SVAL);
}

void rfic_enable_vddmon_1V2bbldo (void)
{
	//--------------------------------------------------------------------------
	// Register VDDMON - VDD MONITOR	Antx	0x63
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(15, RF_ANTENNA0_FCSI_VDDMON,
			RF_ANTENNA0_FCSI_VDDMON_EN_OPAMPS_1__SVAL
			| RF_ANTENNA0_FCSI_VDDMON_CTL_BBLDO_1__SVAL);
}

void rfic_enable_vddmon_1V2bbfilterldo (void)
{
	//--------------------------------------------------------------------------
	// Register VDDMON - VDD MONITOR	Antx	0x63
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(15, RF_ANTENNA0_FCSI_VDDMON,
			RF_ANTENNA0_FCSI_VDDMON_EN_OPAMPS_1__SVAL
			| RF_ANTENNA0_FCSI_VDDMON_CTL_BBFILTLDO_1__SVAL);
}

void rfic_enable_vddmon_2V5ldo (void)
{
	//--------------------------------------------------------------------------
	// Register VDDMON - VDD MONITOR	Antx	0x63
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(15, RF_ANTENNA0_FCSI_VDDMON,
			RF_ANTENNA0_FCSI_VDDMON_EN_OPAMPS_1__SVAL
			| RF_ANTENNA0_FCSI_VDDMON_CTL_2V5LDO_1__SVAL);
}

void rfic_enable_vddmon_1V5ldoin (void)
{
	//--------------------------------------------------------------------------
	// Register VDDMON - VDD MONITOR	Antx	0x63
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(15, RF_ANTENNA0_FCSI_VDDMON,
			RF_ANTENNA0_FCSI_VDDMON_EN_OPAMPS_1__SVAL
			| RF_ANTENNA0_FCSI_VDDMON_CTL_1V5LDO_IN_1__SVAL
			| RF_ANTENNA0_FCSI_VDDMON_CTL_1V5LDO_CURRENT_1__SVAL);
}

void rfic_enable_vddmon_3V3ldoin (void)
{
	//--------------------------------------------------------------------------
	// Register VDDMON - VDD MONITOR	Antx	0x63
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(15, RF_ANTENNA0_FCSI_VDDMON,
			RF_ANTENNA0_FCSI_VDDMON_EN_OPAMPS_1__SVAL
			| RF_ANTENNA0_FCSI_VDDMON_CTL_3V3LDO_IN_1__SVAL
			| RF_ANTENNA0_FCSI_VDDMON_CTL_3V3LDO_CURRENT_1__SVAL);
}

void rfic_disable_vddmon (void)
{
	//--------------------------------------------------------------------------
	// Register VDDMON - VDD MONITOR	Antx	0x63
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(15, RF_ANTENNA0_FCSI_VDDMON,
			0x0000);
}

void rfic_toggle_vddmon_1 (void)
{
	//--------------------------------------------------------------------------
	// Register VDDMON - VDD MONITOR	Antx	0x63
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(15, RF_ANTENNA0_FCSI_VDDMON,
			RF_ANTENNA0_FCSI_VDDMON_EN_CHOPPING__ISMSK,
			RF_ANTENNA0_FCSI_VDDMON_EN_CHOPPING_1__SVAL);
}

void rfic_toggle_vddmon_0 (void)
{
	//--------------------------------------------------------------------------
	// Register VDDMON - VDD MONITOR	Antx	0x63
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(15, RF_ANTENNA0_FCSI_VDDMON,
			RF_ANTENNA0_FCSI_VDDMON_EN_CHOPPING__ISMSK,
			RF_ANTENNA0_FCSI_VDDMON_EN_CHOPPING_0__SVAL);
}

void rfic_enable_vddmon_central (void)
{
	//--------------------------------------------------------------------------
	// Register LDOMON - LDO MONITOR		Ant2	0x4F
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(4, RF_ANTENNA2_FCSI_LDOMON,
			RF_ANTENNA2_FCSI_LDOMON_EN_LDOMON_1__SVAL);
}

void rfic_disable_vddmon_central (void)
{
	//--------------------------------------------------------------------------
	// Register LDOMON - LDO MONITOR		Ant2	0x4F
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(4, RF_ANTENNA2_FCSI_LDOMON,
			RF_ANTENNA2_FCSI_LDOMON_EN_LDOMON_0__SVAL);
}

void rfic_enable_vddmon_bbioldo (void)
{
	//--------------------------------------------------------------------------
	// Register BBIOLDO1V2	BBIO LDO1V2 + BIAS		Ant2	0x44
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(4, RF_ANTENNA2_FCSI_BBIOLDO1V2,
			RF_ANTENNA2_FCSI_BBIOLDO1V2_EN_TEST__ISMSK,
			RF_ANTENNA2_FCSI_BBIOLDO1V2_EN_TEST_1__SVAL);
}

void rfic_disable_vddmon_bbioldo (void)
{
	//--------------------------------------------------------------------------
	// Register BBIOLDO1V2	BBIO LDO1V2 + BIAS		Ant2	0x44
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(4, RF_ANTENNA2_FCSI_BBIOLDO1V2,
			RF_ANTENNA2_FCSI_BBIOLDO1V2_EN_TEST__ISMSK,
			RF_ANTENNA2_FCSI_BBIOLDO1V2_EN_TEST_0__SVAL);
}

void rfic_enable_vddmon_lotreeldo0 (void)
{
	//--------------------------------------------------------------------------
	// Register LOLDO0	LOTREE LDO ANT0		Ant1	0x49
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(2, RF_ANTENNA1_FCSI_LOLDO0,
			RF_ANTENNA1_FCSI_LOLDO0_EN_TEST__ISMSK,
			RF_ANTENNA1_FCSI_LOLDO0_EN_TEST_1__SVAL);
}
void rfic_disable_vddmon_lotreeldo0 (void)
{
	//--------------------------------------------------------------------------
	// Register LOLDO0	LOTREE LDO ANT0		Ant1	0x49
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(2, RF_ANTENNA1_FCSI_LOLDO0,
			RF_ANTENNA1_FCSI_LOLDO0_EN_TEST__ISMSK,
			RF_ANTENNA1_FCSI_LOLDO0_EN_TEST_0__SVAL);
}

void rfic_enable_vddmon_lotreeldo1 (void)
{
	//--------------------------------------------------------------------------
	// Register LOLDO1	LOTREE LDO ANT1		Ant1	0x4A
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(2, RF_ANTENNA1_FCSI_LOLDO1,
			RF_ANTENNA1_FCSI_LOLDO1_EN_TEST__ISMSK,
			RF_ANTENNA1_FCSI_LOLDO1_EN_TEST_1__SVAL);
}
void rfic_disable_vddmon_lotreeldo1 (void)
{
	//--------------------------------------------------------------------------
	// Register LOLDO1	LOTREE LDO ANT1		Ant1	0x4A
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(2, RF_ANTENNA1_FCSI_LOLDO1,
			RF_ANTENNA1_FCSI_LOLDO1_EN_TEST__ISMSK,
			RF_ANTENNA1_FCSI_LOLDO1_EN_TEST_0__SVAL);
}

void rfic_enable_vddmon_lotreeldo2 (void)
{
	//--------------------------------------------------------------------------
	// Register LOLDO2	LOTREE LDO ANT2		Ant1	0x4B
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(2, RF_ANTENNA1_FCSI_LOLDO2,
			RF_ANTENNA1_FCSI_LOLDO2_EN_TEST__ISMSK,
			RF_ANTENNA1_FCSI_LOLDO2_EN_TEST_1__SVAL);
}
void rfic_disable_vddmon_lotreeldo2 (void)
{
	//--------------------------------------------------------------------------
	// Register LOLDO2	LOTREE LDO ANT2		Ant1	0x4B
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(2, RF_ANTENNA1_FCSI_LOLDO2,
			RF_ANTENNA1_FCSI_LOLDO2_EN_TEST__ISMSK,
			RF_ANTENNA1_FCSI_LOLDO2_EN_TEST_0__SVAL);
}

void rfic_enable_vddmon_lotreeldo3 (void)
{
	//--------------------------------------------------------------------------
	// Register LOLDO3	LOTREE LDO ANT3		Ant1	0x4C
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(2, RF_ANTENNA1_FCSI_LOLDO3,
			RF_ANTENNA1_FCSI_LOLDO3_EN_TEST__ISMSK,
			RF_ANTENNA1_FCSI_LOLDO3_EN_TEST_1__SVAL);
}
void rfic_disable_vddmon_lotreeldo3 (void)
{
	//--------------------------------------------------------------------------
	// Register LOLDO3	LOTREE LDO ANT3		Ant1	0x4C
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(2, RF_ANTENNA1_FCSI_LOLDO3,
			RF_ANTENNA1_FCSI_LOLDO3_EN_TEST__ISMSK,
			RF_ANTENNA1_FCSI_LOLDO3_EN_TEST_0__SVAL);
}

void rfic_enable_vddmon_fcsildo (void)
{
	//--------------------------------------------------------------------------
	// Register FCSILDO1V2 - FCSI LDO1V2		Ant1	0x46
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(2, RF_ANTENNA1_FCSI_FCSILDO1V2,
			RF_ANTENNA1_FCSI_FCSILDO1V2_EN_TEST__ISMSK,
			RF_ANTENNA1_FCSI_FCSILDO1V2_EN_TEST_1__SVAL);
}
void rfic_disable_vddmon_fcsildo (void)
{
	//--------------------------------------------------------------------------
	// Register FCSILDO1V2 - FCSI LDO1V2		Ant1	0x46
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(2, RF_ANTENNA1_FCSI_FCSILDO1V2,
			RF_ANTENNA1_FCSI_FCSILDO1V2_EN_TEST__ISMSK,
			RF_ANTENNA1_FCSI_FCSILDO1V2_EN_TEST_0__SVAL);
}

void rfic_enable_vddmon_fsysldo (void)
{
	//--------------------------------------------------------------------------
	// Register FSYSLDO2V5 - FSYS LDO2V5		Ant1	0x45
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(2, RF_ANTENNA1_FCSI_FSYSLDO2V5,
			RF_ANTENNA1_FCSI_FSYSLDO2V5_EN_TEST__ISMSK,
			RF_ANTENNA1_FCSI_FSYSLDO2V5_EN_TEST_1__SVAL);
}
void rfic_disable_vddmon_fsysldo (void)
{
	//--------------------------------------------------------------------------
	// Register FSYSLDO2V5 - FSYS LDO2V5		Ant1	0x45
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(2, RF_ANTENNA1_FCSI_FSYSLDO2V5,
			RF_ANTENNA1_FCSI_FSYSLDO2V5_EN_TEST__ISMSK,
			RF_ANTENNA1_FCSI_FSYSLDO2V5_EN_TEST_0__SVAL);
}

void rfic_config_txgain (uint8_t AntMsk, int gain0dB, int gain1dB, int gain2dB)
{
	//--------------------------------------------------------------------------
	// Register PGC21	PGC2 CTRL + GAIN (SREG TX CONTROL)	Antx	0x59
	//--------------------------------------------------------------------------
	if (gain0dB==18)
	{
		gain0dB = 14;
	}

	if (gain1dB==18)
	{
		gain1dB = 14;
	}

	if (gain2dB==18)
	{
		gain2dB = 14;
	}

	RFIC_FCSI_RMW(AntMsk, RF_ANTENNA0_FCSI_PGC21,
			RF_ANTENNA0_FCSI_PGC21_PGC2_TXGAIN0__ISMSK
			& RF_ANTENNA0_FCSI_PGC21_PGC2_TXGAIN1__ISMSK
			& RF_ANTENNA0_FCSI_PGC21_PGC2_TXGAIN2__ISMSK,
			(gain0dB+8)/2 << RF_ANTENNA0_FCSI_PGC21_PGC2_TXGAIN0__POS
			| (gain1dB+8)/2 << RF_ANTENNA0_FCSI_PGC21_PGC2_TXGAIN1__POS
			| (gain2dB+8)/2 << RF_ANTENNA0_FCSI_PGC21_PGC2_TXGAIN2__POS);
}

void rfic_config_lnagain (uint8_t AntMsk, int gain0idx, int gain1idx, int gain2idx, int gain3idx, int gain4idx, int gain5idx)
{
	//--------------------------------------------------------------------------
	// Register FECTL01		FECTL CONFIG RX GAIN01	Antx	0x6D
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(AntMsk, RF_ANTENNA0_FCSI_FECTL01,
			RF_ANTENNA0_FCSI_FECTL01_LNA_GAIN0__ISMSK
			& RF_ANTENNA0_FCSI_FECTL01_LNA_GAIN1__ISMSK,
			gain0idx << RF_ANTENNA0_FCSI_FECTL01_LNA_GAIN0__POS
			| gain1idx << RF_ANTENNA0_FCSI_FECTL01_LNA_GAIN1__POS);

	//--------------------------------------------------------------------------
	// Register FECTL23		FECTL CONFIG RX GAIN23	Antx	0x6E
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(AntMsk, RF_ANTENNA0_FCSI_FECTL23,
			RF_ANTENNA0_FCSI_FECTL23_LNA_GAIN2__ISMSK
			& RF_ANTENNA0_FCSI_FECTL23_LNA_GAIN3__ISMSK,
			gain2idx << RF_ANTENNA0_FCSI_FECTL23_LNA_GAIN2__POS
			| gain3idx << RF_ANTENNA0_FCSI_FECTL23_LNA_GAIN3__POS);

	//--------------------------------------------------------------------------
	// Register FECTL45		FECTL CONFIG RX GAIN45	Antx	0x6F
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(AntMsk, RF_ANTENNA0_FCSI_FECTL45,
			RF_ANTENNA0_FCSI_FECTL45_LNA_GAIN4__ISMSK
			& RF_ANTENNA0_FCSI_FECTL45_LNA_GAIN5__ISMSK,
			gain4idx << RF_ANTENNA0_FCSI_FECTL45_LNA_GAIN4__POS
			| gain5idx << RF_ANTENNA0_FCSI_FECTL45_LNA_GAIN5__POS);
}

void rfic_config_s2dgain (uint8_t AntMsk, uint8_t gain0, uint8_t gain1, uint8_t gain2, uint8_t gain3, uint8_t gain4, uint8_t gain5)
{
	//--------------------------------------------------------------------------
	// Register FECTL01		FECTL CONFIG RX GAIN01	Antx	0x6D
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(AntMsk, RF_ANTENNA0_FCSI_FECTL01,
			RF_ANTENNA0_FCSI_FECTL01_S2D_GAIN0__ISMSK
			& RF_ANTENNA0_FCSI_FECTL01_S2D_GAIN1__ISMSK,
			gain0 << RF_ANTENNA0_FCSI_FECTL01_S2D_GAIN0__POS
			| gain1 << RF_ANTENNA0_FCSI_FECTL01_S2D_GAIN1__POS);

	//--------------------------------------------------------------------------
	// Register FECTL23		FECTL CONFIG RX GAIN23	Antx	0x6E
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(AntMsk, RF_ANTENNA0_FCSI_FECTL23,
			RF_ANTENNA0_FCSI_FECTL23_S2D_GAIN2__ISMSK
			& RF_ANTENNA0_FCSI_FECTL23_S2D_GAIN3__ISMSK,
			gain2 << RF_ANTENNA0_FCSI_FECTL23_S2D_GAIN2__POS
			| gain3 << RF_ANTENNA0_FCSI_FECTL23_S2D_GAIN3__POS);

	//--------------------------------------------------------------------------
	// Register FECTL45		FECTL CONFIG RX GAIN45	Antx	0x6F
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(AntMsk, RF_ANTENNA0_FCSI_FECTL45,
			RF_ANTENNA0_FCSI_FECTL45_S2D_GAIN4__ISMSK
			& RF_ANTENNA0_FCSI_FECTL45_S2D_GAIN5__ISMSK,
			gain4 << RF_ANTENNA0_FCSI_FECTL45_S2D_GAIN4__POS
			| gain5 << RF_ANTENNA0_FCSI_FECTL45_S2D_GAIN5__POS);

}

void rfic_config_fectl (uint8_t AntMsk, uint8_t fectl0, uint8_t fectl1, uint8_t fectl2, uint8_t fectl3, uint8_t fectl4, uint8_t fectl5)
{
	//--------------------------------------------------------------------------
	// Register FECTL01		FECTL CONFIG RX GAIN01	Antx	0x6D
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(AntMsk, RF_ANTENNA0_FCSI_FECTL01,
			RF_ANTENNA0_FCSI_FECTL01_FECTL_GAIN0__ISMSK
			& RF_ANTENNA0_FCSI_FECTL01_FECTL_GAIN1__ISMSK,
			fectl0 << RF_ANTENNA0_FCSI_FECTL01_FECTL_GAIN0__POS
			| fectl1 << RF_ANTENNA0_FCSI_FECTL01_FECTL_GAIN1__POS);

	//--------------------------------------------------------------------------
	// Register FECTL23		FECTL CONFIG RX GAIN23	Antx	0x6E
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(AntMsk, RF_ANTENNA0_FCSI_FECTL23,
			RF_ANTENNA0_FCSI_FECTL23_FECTL_GAIN2__ISMSK
			& RF_ANTENNA0_FCSI_FECTL23_FECTL_GAIN3__ISMSK,
			fectl2 << RF_ANTENNA0_FCSI_FECTL23_FECTL_GAIN2__POS
			| fectl3 << RF_ANTENNA0_FCSI_FECTL23_FECTL_GAIN3__POS);

	//--------------------------------------------------------------------------
	// Register FECTL45		FECTL CONFIG RX GAIN45	Antx	0x6F
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(AntMsk, RF_ANTENNA0_FCSI_FECTL45,
			RF_ANTENNA0_FCSI_FECTL45_FECTL_GAIN4__ISMSK
			& RF_ANTENNA0_FCSI_FECTL45_FECTL_GAIN5__ISMSK,
			fectl4 << RF_ANTENNA0_FCSI_FECTL45_FECTL_GAIN4__POS
			| fectl5 << RF_ANTENNA0_FCSI_FECTL45_FECTL_GAIN5__POS);

}

void rfic_config_rssi_high(uint8_t AntMsk, int gaindB, uint8_t offsetidx)
{
	//--------------------------------------------------------------------------
	// Register	RSSI0 - RSSI0 	Antx	0x68
	//--------------------------------------------------------------------------
	// RSSI High Gain
	RFIC_FCSI_Write(AntMsk, RF_ANTENNA0_FCSI_RSSI0,
			offsetidx << RF_ANTENNA0_FCSI_RSSI0_S2D_OFFSET__POS
			| (gaindB+10)/2 << RF_ANTENNA0_FCSI_RSSI0_S2D_GAIN__POS);
}

void rfic_config_rssi_low(uint8_t AntMsk, int gaindB, uint8_t offsetidx)
{
	//--------------------------------------------------------------------------
	// Register	RSSI1 - RSSI1 	Antx	0x69
	//--------------------------------------------------------------------------
	// RSSI Low Gain
	RFIC_FCSI_Write(AntMsk, RF_ANTENNA0_FCSI_RSSI1,
			offsetidx << RF_ANTENNA0_FCSI_RSSI1_S2D_OFFSET__POS
			| (gaindB+10)/2 << RF_ANTENNA0_FCSI_RSSI0_S2D_GAIN__POS);
}

void rfic_set_rxgain (uint8_t AntMsk, uint8_t lnagainidx, int pgc1gaindB, int pgc2gaindB)
{
	//--------------------------------------------------------------------------
	// Short Register SR1
	//--------------------------------------------------------------------------
	if (pgc1gaindB==24)
	{
		pgc1gaindB = 19;
	}

	if (pgc2gaindB==18)
	{
		pgc2gaindB = 14;
	}

	RFIC_FCSI_Write(AntMsk, RF_ANTENNA0_FCSI_SR1,
			lnagainidx << RF_ANTENNA0_FCSI_SR1_LNA_GAIN_COARSE__POS
			| pgc1gaindB << RF_ANTENNA0_FCSI_SR1_PGC1_GAIN__POS
			| (pgc2gaindB+8)/2 << RF_ANTENNA0_FCSI_SR1_PGC2_RXGAIN__POS);
}

void rfic_set_txgain(uint8_t AntMsk, int pgc2gainidx, int prdattdB)
{
	//--------------------------------------------------------------------------
	// Short Register SR2
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(AntMsk, RF_ANTENNA0_FCSI_SR2,
			RF_ANTENNA0_FCSI_SR2_PGC2_TXGAIN_CONF__ISMSK
			& RF_ANTENNA0_FCSI_SR2_PA_DRV_GAIN__ISMSK,
			pgc2gainidx << RF_ANTENNA0_FCSI_SR2_PGC2_TXGAIN_CONF__POS
			| prdattdB/2 << RF_ANTENNA0_FCSI_SR2_PA_DRV_GAIN__POS);
}

void rfic_set_tssi_gain_offset (uint8_t AntMsk, int gaindB, uint8_t offsetidx)
{
	//--------------------------------------------------------------------------
	// Short Register SR2
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(AntMsk, RF_ANTENNA0_FCSI_SR2,
			RF_ANTENNA0_FCSI_SR2_S2D_GAIN_TSSI__ISMSK
			& RF_ANTENNA0_FCSI_SR2_S2D_OFFSET_TSSI__ISMSK,
			(gaindB+10)/2 << RF_ANTENNA0_FCSI_SR2_S2D_GAIN_TSSI__POS
			| offsetidx << RF_ANTENNA0_FCSI_SR2_S2D_OFFSET_TSSI__POS);
}


void rfic_set_tssi_rdiv (uint8_t rdiv)
{
	//--------------------------------------------------------------------------
	// Register SSI - SSI CONTROL	Antx	0x60
	//--------------------------------------------------------------------------
	// rdiv=6 --> 0.6
	// rfiv=9 --> 0.9
	if (rdiv == 9)
	{
		RFIC_FCSI_RMW(15, RF_ANTENNA0_FCSI_SSI,
				RF_ANTENNA0_FCSI_SSI_CTL_TSSI_RANGE__ISMSK,
				1 << RF_ANTENNA0_FCSI_SSI_CTL_TSSI_RANGE__POS);
	}
	else
	{
		RFIC_FCSI_RMW(15, RF_ANTENNA0_FCSI_SSI,
				RF_ANTENNA0_FCSI_SSI_CTL_TSSI_RANGE__ISMSK,
				0 << RF_ANTENNA0_FCSI_SSI_CTL_TSSI_RANGE__POS);
	}
}


void rfic_set_ssb_gain (uint8_t AntMsk, int gain1dB, int gain2dB)
{
	//--------------------------------------------------------------------------
	// Register SSB0 - SSB CAL GENERAL	Antx	0x5E
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(AntMsk, RF_ANTENNA0_FCSI_SSB0,
			RF_ANTENNA0_FCSI_SSB0_CTL_SSBCAL_GAIN1__ISMSK
			& RF_ANTENNA0_FCSI_SSB0_CTL_SSBCAL_GAIN2__ISMSK,
			gain1dB/6 << RF_ANTENNA0_FCSI_SSB0_CTL_SSBCAL_GAIN1__POS
			| gain2dB/6 << RF_ANTENNA0_FCSI_SSB0_CTL_SSBCAL_GAIN2__POS);
}

void rfic_set_txband(uint8_t AntMsk, uint8_t bandsel)
{
	RFIC_FCSI_RMW(AntMsk, RF_ANTENNA0_FCSI_SR0,
			RF_ANTENNA0_FCSI_SR0_TX_BAND__ISMSK,
			bandsel << RF_ANTENNA0_FCSI_SR0_TX_BAND__POS);
}

void rfic_set_rxband(uint8_t AntMsk, uint8_t bandsel)
{
	RFIC_FCSI_RMW(AntMsk, RF_ANTENNA0_FCSI_SR0,
			RF_ANTENNA0_FCSI_SR0_RX_BAND__ISMSK,
			bandsel << RF_ANTENNA0_FCSI_SR0_RX_BAND__POS);
}

void rfic_set_lnaMidGain(uint8_t AntMsk,uint8_t lnaMidGAin)
{
	//--------------------------------------------------------------------------
	// Register LNA - LNA GENERAL Antx      0x6A
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(AntMsk, RF_ANTENNA0_FCSI_LNA,
			RF_ANTENNA0_FCSI_LNA_CTL_FINE_GAIN__ISMSK,
			lnaMidGAin << RF_ANTENNA0_FCSI_LNA_CTL_FINE_GAIN__POS);
}

void rfic_set_rfbandwidth(uint8_t AntMsk, uint8_t rf_bw)
{
	uint8_t bw_bit;
	if (rf_bw == 80)
		bw_bit = 0;
	else if (rf_bw == 40)
		bw_bit = 2;
	else if (rf_bw == 20)
		bw_bit = 3;
	else
		bw_bit = rf_bw;

	RFIC_FCSI_RMW(AntMsk, RF_ANTENNA0_FCSI_SR0,
			RF_ANTENNA0_FCSI_SR0_SEL_BW__ISMSK,
			bw_bit << RF_ANTENNA0_FCSI_SR0_SEL_BW__POS);
}

void rfic_set_rfch_dc_bw(uint8_t AntMsk, uint8_t rf_ch, uint8_t rx_dc, uint8_t rf_bw)
{
	if (rf_ch > 5)
		rf_ch = 0;	// any channel above 5 will default to 0

	if (rx_dc > 2)
		rx_dc = 0;	// any RX DC setup above 2 will be set to 0

	uint8_t bw_bit;
	if (rf_bw == 80)
		bw_bit = 0;
	else if (rf_bw == 40)
		bw_bit = 2;
	else if (rf_bw == 20)
		bw_bit = 3;
	else
		bw_bit = rf_bw;
	if (bw_bit > 3)
		bw_bit = 0;	// any RF BW above 3 will be set to 0

	RFIC_FCSI_RMW(AntMsk, RF_ANTENNA0_FCSI_SR0,
			RF_ANTENNA0_FCSI_SR0_SEL_RXDC__ISMSK
			& RF_ANTENNA0_FCSI_SR0_SEL_CH__ISMSK
			& RF_ANTENNA0_FCSI_SR0_SEL_BW__ISMSK,
			rx_dc << RF_ANTENNA0_FCSI_SR0_SEL_RXDC__POS
			| rf_ch << RF_ANTENNA0_FCSI_SR0_SEL_CH__POS
			| bw_bit << RF_ANTENNA0_FCSI_SR0_SEL_BW__POS);
}

void rfic_enable_lnanoise(uint8_t AntMsk)
{
	//--------------------------------------------------------------------------
	// Register LNA - LNA GENERAL	Antx	0x6A
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(AntMsk, RF_ANTENNA0_FCSI_LNA,
			RF_ANTENNA0_FCSI_LNA_CTL_EN__ISMSK
			& RF_ANTENNA0_FCSI_LNA_EN__ISMSK
			& RF_ANTENNA0_FCSI_LNA_EN_NOISE__ISMSK,
			RF_ANTENNA0_FCSI_LNA_CTL_EN_1__SVAL
			| RF_ANTENNA0_FCSI_LNA_EN_0__SVAL
			| RF_ANTENNA0_FCSI_LNA_EN_NOISE_1__SVAL);
}

void rfic_disable_lnanoise(uint8_t AntMsk)
{
	//--------------------------------------------------------------------------
	// Register LNA - LNA GENERAL	Antx	0x6A
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(AntMsk, RF_ANTENNA0_FCSI_LNA,
			RF_ANTENNA0_FCSI_LNA_CTL_EN__ISMSK
			& RF_ANTENNA0_FCSI_LNA_EN__ISMSK
			& RF_ANTENNA0_FCSI_LNA_EN_NOISE__ISMSK,
			RF_ANTENNA0_FCSI_LNA_CTL_EN_0__SVAL
			| RF_ANTENNA0_FCSI_LNA_EN_0__SVAL
			| RF_ANTENNA0_FCSI_LNA_EN_NOISE_0__SVAL);
}

void rfic_enable_lna(uint8_t AntMsk)
{
	//--------------------------------------------------------------------------
	// Register LNA - LNA GENERAL	Antx	0x6A
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(AntMsk, RF_ANTENNA0_FCSI_LNA,
			RF_ANTENNA0_FCSI_LNA_CTL_EN__ISMSK
			& RF_ANTENNA0_FCSI_LNA_EN__ISMSK,
			RF_ANTENNA0_FCSI_LNA_CTL_EN_0__SVAL
			| RF_ANTENNA0_FCSI_LNA_EN_1__SVAL);
}

void rfic_disable_lna(uint8_t AntMsk)
{
	//--------------------------------------------------------------------------
	// Register LNA - LNA GENERAL	Antx	0x6A
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(AntMsk, RF_ANTENNA0_FCSI_LNA,
			RF_ANTENNA0_FCSI_LNA_CTL_EN__ISMSK
			& RF_ANTENNA0_FCSI_LNA_EN__ISMSK,
			RF_ANTENNA0_FCSI_LNA_CTL_EN_1__SVAL
			| RF_ANTENNA0_FCSI_LNA_EN_0__SVAL);
}

void rfic_enable_efuse (void)
{
	//--------------------------------------------------------------------------
	// Register CONFIG1 - CONFIG1   Ant2      0x4B
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(4, RF_ANTENNA2_FCSI_CONFIG1,
			RF_ANTENNA2_FCSI_CONFIG1_EN_INPUT_FECTL_56__ISMSK&
			RF_ANTENNA2_FCSI_CONFIG1_EN_RES_N__ISMSK&
			RF_ANTENNA2_FCSI_CONFIG1_EN_CLK_WRITE__ISMSK,
			RF_ANTENNA2_FCSI_CONFIG1_EN_INPUT_FECTL_56_1__SVAL |
			RF_ANTENNA2_FCSI_CONFIG1_EN_RES_N_1__SVAL |
			RF_ANTENNA2_FCSI_CONFIG1_EN_CLK_WRITE_1__SVAL);
}

void rfic_disable_efuse (void)
{
	//--------------------------------------------------------------------------
	// Register CONFIG1 - CONFIG1   Ant2      0x4B
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(4, RF_ANTENNA2_FCSI_CONFIG1,
			RF_ANTENNA2_FCSI_CONFIG1_EN_INPUT_FECTL_56__ISMSK&
			RF_ANTENNA2_FCSI_CONFIG1_EN_RES_N__ISMSK&
			RF_ANTENNA2_FCSI_CONFIG1_EN_CLK_WRITE__ISMSK,
			RF_ANTENNA2_FCSI_CONFIG1_EN_INPUT_FECTL_56_0__SVAL |
			RF_ANTENNA2_FCSI_CONFIG1_EN_RES_N_0__SVAL |
			RF_ANTENNA2_FCSI_CONFIG1_EN_CLK_WRITE_0__SVAL);
}


void rfic_read_address(uint16_t address, uint16_t *p_data)
{
	//--------------------------------------------------------------------------
	// Register Read from Address (all four antennas)
	//--------------------------------------------------------------------------
   RFIC_FCSI_Read(15, address, p_data);
}

uint8_t rfic_read_efuse_values(uint16_t sections, uint16_t *softfuse_data)
{

	uint16_t	data[4];
	uint16_t    fuse_data[16];
	// uint16_t 	efuse_chipid, efuse_tester_site, efuse_tprogram_version, efuse_handlertemp;
	uint16_t	efuse_vref;
	uint16_t	efuse_txldo1v2[4], efuse_rxldo1v2[4], efuse_bbldo1v2[4], efuse_filterldo1v2[4];
	uint16_t	efuse_rfldo2v5[4], efuse_lotreeldo[4];
	uint16_t    efuse_bbioldo1v2, efuse_fsysldo2v5; //, efuse_rx_mid_gain;
	uint16_t	efuse_lnastep[4];
	// uint16_t	efuse_rx_mid2high_gain;
	uint16_t	efuse_rx_band[4], efuse_tx_band[4];
	uint16_t	efuse_vcal_rsit;
	uint16_t	efuse_trimfilter_ant0_10MHz, efuse_trimfilter_ant0_20MHz, efuse_trimfilter_ant0_40MHz;
	uint16_t	efuse_trimfilter_ant2_10MHz, efuse_trimfilter_ant2_20MHz, efuse_trimfilter_ant2_40MHz;
	uint16_t	efuse_bias, efuse_fcsildo1v2;
	// uint16_t	efuse_fsys_vout, efuse_fsys_iref;
	// uint16_t	efuse_version, efuse_product;
	uint16_t	efuse_mcm;
	uint16_t    reg, ant, version;
	uint8_t		chip_fused = 1;
	uint8_t		RX_Band_nom = 5;
	uint8_t		TX_Band_nom = 3;
	uint8_t		Mid2HighStep_nom = 9;

	// force to read from softfuse data as long as softfuse_data[15] != 0
	if (softfuse_data[15] == 0)
	{
		for (reg=0; reg<16; reg++)
		{
			RFIC_FCSI_Read(15, reg+RF_ANTENNA3_FCSI_EFUSE0, &data[0]);
			fuse_data[reg] = data[3];
		}

		if ((fuse_data[15] & (7 << RF_ANTENNA3_FCSI_EFUSE15_PRODUCTCODE__POS)) == 0)
		{
			chip_fused = 0;
			// check if WRX514 A11
			RFIC_FCSI_Read(15, RF_ANTENNA2_FCSI_VERSION, &data[0]);
			version = ((data[2] >> RF_ANTENNA2_FCSI_VERSION_DESIGN_STEP__POS) & RF_ANTENNA2_FCSI_VERSION_DESIGN_STEP__MSK);
			if (version == 41) // = 0b0101001 --> A11: 01=A 01=1 001=1
				chip_fused = 2;
		}

	}
	else // or use external softfuse_data
	{
		for (reg=0; reg<16; reg++)
		{
			fuse_data[reg] = *(softfuse_data+reg);
			// write softfuse data to original fuse register locations (includes MCM bit) --> doesn't work - read-only
			// RFIC_FCSI_Write(8, reg+RF_ANTENNA3_FCSI_EFUSE0, fuse_data[reg]);
		}
	}

	if (chip_fused > 0)
	{
		if (chip_fused == 1)
		{
			// efuse_chipid		   = fuse_data[1] << 16 | fuse_data[0];
			// efuse_tester_site      = ((fuse_data[2] >> RF_ANTENNA3_FCSI_EFUSE2_TESTERSITE__POS) & RF_ANTENNA3_FCSI_EFUSE2_TESTERSITE__MSK);
			// efuse_tprogram_version = ((fuse_data[2] >> RF_ANTENNA3_FCSI_EFUSE2_PROGRAMMVERSION__POS) & RF_ANTENNA3_FCSI_EFUSE2_PROGRAMMVERSION__MSK)*100 + ((fuse_data[2] >> RF_ANTENNA3_FCSI_EFUSE2_PROGRAMMVERSION__POS+3) & RF_ANTENNA3_FCSI_EFUSE2_PROGRAMMVERSION__MSK);
			// efuse_handlertemp      = ((fuse_data[2] >> RF_ANTENNA3_FCSI_EFUSE2_HANDLERTEMP__POS) & RF_ANTENNA3_FCSI_EFUSE2_HANDLERTEMP__MSK);
			efuse_vref             = ((fuse_data[2] >> RF_ANTENNA3_FCSI_EFUSE2_CTL_TRIM_BGP__POS) & RF_ANTENNA3_FCSI_EFUSE2_CTL_TRIM_BGP__MSK);

			efuse_txldo1v2[0] = ((fuse_data[3] >> RF_ANTENNA3_FCSI_EFUSE3_TXLDO1V2__POS) & RF_ANTENNA3_FCSI_EFUSE3_TXLDO1V2__MSK);
			efuse_rxldo1v2[0] = ((fuse_data[3] >> RF_ANTENNA3_FCSI_EFUSE3_RXLDO1V2__POS) & RF_ANTENNA3_FCSI_EFUSE3_RXLDO1V2__MSK);
			efuse_bbldo1v2[0] = ((fuse_data[3] >> RF_ANTENNA3_FCSI_EFUSE3_BBLDO1V2__POS) & RF_ANTENNA3_FCSI_EFUSE3_BBLDO1V2__MSK);
			efuse_filterldo1v2[0] = ((fuse_data[3] >> RF_ANTENNA3_FCSI_EFUSE3_BBFILTLDO1V2__POS) & RF_ANTENNA3_FCSI_EFUSE3_BBFILTLDO1V2__MSK);

			efuse_txldo1v2[1] = ((fuse_data[4] >> RF_ANTENNA3_FCSI_EFUSE4_TXLDO1V2__POS) & RF_ANTENNA3_FCSI_EFUSE4_TXLDO1V2__MSK);
			efuse_rxldo1v2[1] = ((fuse_data[4] >> RF_ANTENNA3_FCSI_EFUSE4_RXLDO1V2__POS) & RF_ANTENNA3_FCSI_EFUSE4_RXLDO1V2__MSK);
			efuse_bbldo1v2[1] = ((fuse_data[4] >> RF_ANTENNA3_FCSI_EFUSE4_BBLDO1V2__POS) & RF_ANTENNA3_FCSI_EFUSE4_BBLDO1V2__MSK);
			efuse_filterldo1v2[1] = ((fuse_data[4] >> RF_ANTENNA3_FCSI_EFUSE4_BBFILTLDO1V2__POS) & RF_ANTENNA3_FCSI_EFUSE4_BBFILTLDO1V2__MSK);

			efuse_txldo1v2[2] = ((fuse_data[5] >> RF_ANTENNA3_FCSI_EFUSE5_TXLDO1V2__POS) & RF_ANTENNA3_FCSI_EFUSE5_TXLDO1V2__MSK);
			efuse_rxldo1v2[2] = ((fuse_data[5] >> RF_ANTENNA3_FCSI_EFUSE5_RXLDO1V2__POS) & RF_ANTENNA3_FCSI_EFUSE5_RXLDO1V2__MSK);
			efuse_bbldo1v2[2] = ((fuse_data[5] >> RF_ANTENNA3_FCSI_EFUSE5_BBLDO1V2__POS) & RF_ANTENNA3_FCSI_EFUSE5_BBLDO1V2__MSK);
			efuse_filterldo1v2[2] = ((fuse_data[5] >> RF_ANTENNA3_FCSI_EFUSE5_BBFILTLDO1V2__POS) & RF_ANTENNA3_FCSI_EFUSE5_BBFILTLDO1V2__MSK);

			efuse_txldo1v2[3] = ((fuse_data[6] >> RF_ANTENNA3_FCSI_EFUSE6_TXLDO1V2__POS) & RF_ANTENNA3_FCSI_EFUSE6_TXLDO1V2__MSK);
			efuse_rxldo1v2[3] = ((fuse_data[6] >> RF_ANTENNA3_FCSI_EFUSE6_RXLDO1V2__POS) & RF_ANTENNA3_FCSI_EFUSE6_RXLDO1V2__MSK);
			efuse_bbldo1v2[3] = ((fuse_data[6] >> RF_ANTENNA3_FCSI_EFUSE6_BBLDO1V2__POS) & RF_ANTENNA3_FCSI_EFUSE6_BBLDO1V2__MSK);
			efuse_filterldo1v2[3] = ((fuse_data[6] >> RF_ANTENNA3_FCSI_EFUSE6_BBFILTLDO1V2__POS) & RF_ANTENNA3_FCSI_EFUSE6_BBFILTLDO1V2__MSK);

			efuse_rfldo2v5[0] = ((fuse_data[7] >> RF_ANTENNA3_FCSI_EFUSE7_LDO2V5ANT0__POS) & RF_ANTENNA3_FCSI_EFUSE7_LDO2V5ANT0__MSK);
			efuse_rfldo2v5[1] = ((fuse_data[7] >> RF_ANTENNA3_FCSI_EFUSE7_LDO2V5ANT1__POS) & RF_ANTENNA3_FCSI_EFUSE7_LDO2V5ANT1__MSK);
			efuse_rfldo2v5[2] = ((fuse_data[7] >> RF_ANTENNA3_FCSI_EFUSE7_LDO2V5ANT2__POS) & RF_ANTENNA3_FCSI_EFUSE7_LDO2V5ANT2__MSK);
			efuse_rfldo2v5[3] = ((fuse_data[7] >> RF_ANTENNA3_FCSI_EFUSE7_LDO2V5ANT3__POS) & RF_ANTENNA3_FCSI_EFUSE7_LDO2V5ANT3__MSK);

			efuse_lotreeldo[0] = ((fuse_data[8] >> RF_ANTENNA3_FCSI_EFUSE8_LOTREELDOANT0__POS) & RF_ANTENNA3_FCSI_EFUSE8_LOTREELDOANT0__MSK);
			efuse_lotreeldo[1] = ((fuse_data[8] >> RF_ANTENNA3_FCSI_EFUSE8_LOTREELDOANT1__POS) & RF_ANTENNA3_FCSI_EFUSE8_LOTREELDOANT1__MSK);
			efuse_lotreeldo[2] = ((fuse_data[8] >> RF_ANTENNA3_FCSI_EFUSE8_LOTREELDOANT2__POS) & RF_ANTENNA3_FCSI_EFUSE8_LOTREELDOANT2__MSK);
			efuse_lotreeldo[3] = ((fuse_data[8] >> RF_ANTENNA3_FCSI_EFUSE8_LOTREELDOANT3__POS) & RF_ANTENNA3_FCSI_EFUSE8_LOTREELDOANT3__MSK);

			efuse_bbioldo1v2 = ((fuse_data[9] >> RF_ANTENNA3_FCSI_EFUSE9_BBIOLDO__POS) & RF_ANTENNA3_FCSI_EFUSE9_BBIOLDO__MSK);
			efuse_fsysldo2v5 = ((fuse_data[9] >> RF_ANTENNA3_FCSI_EFUSE9_FSYSLDO__POS) & RF_ANTENNA3_FCSI_EFUSE9_FSYSLDO__MSK);

			efuse_lnastep[0] = ((fuse_data[9] >> RF_ANTENNA3_FCSI_EFUSE9_LNASTEP_ANT0__POS) & RF_ANTENNA3_FCSI_EFUSE9_LNASTEP_ANT0__MSK);
			if (efuse_lnastep[0] > 1)
				efuse_lnastep[0] = efuse_lnastep[0] - 4;
			efuse_lnastep[1] = ((fuse_data[9] >> RF_ANTENNA3_FCSI_EFUSE9_LNASTEP_ANT1__POS) & RF_ANTENNA3_FCSI_EFUSE9_LNASTEP_ANT1__MSK);
			if (efuse_lnastep[1] > 1)
				efuse_lnastep[1] = efuse_lnastep[1] - 4;
			efuse_lnastep[2] = ((fuse_data[9] >> RF_ANTENNA3_FCSI_EFUSE9_LNASTEP_ANT2__POS) & RF_ANTENNA3_FCSI_EFUSE9_LNASTEP_ANT2__MSK);
			if (efuse_lnastep[2] > 1)
				efuse_lnastep[2] = efuse_lnastep[2] - 4;
			efuse_lnastep[3] = ((fuse_data[9] >> RF_ANTENNA3_FCSI_EFUSE9_LNASTEP_ANT3__POS) & RF_ANTENNA3_FCSI_EFUSE9_LNASTEP_ANT3__MSK);
			if (efuse_lnastep[3] > 1)
				efuse_lnastep[3] = efuse_lnastep[3] - 4;

			efuse_rx_band[0] = ((fuse_data[10] >> RF_ANTENNA3_FCSI_EFUSE10_RXBANDSELECTION_ANT0__POS) & RF_ANTENNA3_FCSI_EFUSE10_RXBANDSELECTION_ANT0__MSK) + RX_Band_nom;
			if (efuse_rx_band[0] > 1 + RX_Band_nom)
				efuse_rx_band[0] = efuse_rx_band[0] - 4;
			efuse_rx_band[1] = ((fuse_data[10] >> RF_ANTENNA3_FCSI_EFUSE10_RXBANDSELECTION_ANT1__POS) & RF_ANTENNA3_FCSI_EFUSE10_RXBANDSELECTION_ANT1__MSK) + RX_Band_nom;
			if (efuse_rx_band[1] > 1 + RX_Band_nom)
				efuse_rx_band[1] = efuse_rx_band[1] - 4;
			efuse_rx_band[2] = ((fuse_data[10] >> RF_ANTENNA3_FCSI_EFUSE10_RXBANDSELECTION_ANT2__POS) & RF_ANTENNA3_FCSI_EFUSE10_RXBANDSELECTION_ANT2__MSK) + RX_Band_nom;
			if (efuse_rx_band[2] > 1 + RX_Band_nom)
				efuse_rx_band[2] = efuse_rx_band[2] - 4;
			efuse_rx_band[3] = ((fuse_data[10] >> RF_ANTENNA3_FCSI_EFUSE10_RXBANDSELECTION_ANT3__POS) & RF_ANTENNA3_FCSI_EFUSE10_RXBANDSELECTION_ANT3__MSK) + RX_Band_nom;
			if (efuse_rx_band[3] > 1 + RX_Band_nom)
				efuse_rx_band[3] = efuse_rx_band[3] - 4;

			efuse_tx_band[0] = ((fuse_data[10] >> RF_ANTENNA3_FCSI_EFUSE10_TXBANDSELECTION_ANT0__POS) & RF_ANTENNA3_FCSI_EFUSE10_TXBANDSELECTION_ANT0__MSK) + TX_Band_nom;
			if (efuse_tx_band[0] > 1 + TX_Band_nom)
				efuse_tx_band[0] = efuse_tx_band[0] - 4;
			efuse_tx_band[1] = ((fuse_data[10] >> RF_ANTENNA3_FCSI_EFUSE10_TXBANDSELECTION_ANT1__POS) & RF_ANTENNA3_FCSI_EFUSE10_TXBANDSELECTION_ANT1__MSK) + TX_Band_nom;
			if (efuse_tx_band[1] > 1 + TX_Band_nom)
				efuse_tx_band[1] = efuse_tx_band[1] - 4;
			efuse_tx_band[2] = ((fuse_data[10] >> RF_ANTENNA3_FCSI_EFUSE10_TXBANDSELECTION_ANT2__POS) & RF_ANTENNA3_FCSI_EFUSE10_TXBANDSELECTION_ANT2__MSK) + TX_Band_nom;
			if (efuse_tx_band[2] > 1 + TX_Band_nom)
				efuse_tx_band[2] = efuse_tx_band[2] - 4;
			efuse_tx_band[3] = ((fuse_data[10] >> RF_ANTENNA3_FCSI_EFUSE10_TXBANDSELECTION_ANT3__POS) & RF_ANTENNA3_FCSI_EFUSE10_TXBANDSELECTION_ANT3__MSK) + TX_Band_nom;
			if (efuse_tx_band[3] > 1 + TX_Band_nom)
				efuse_tx_band[3] = efuse_tx_band[3] - 4;

			// efuse_chiptemp = ((fuse_data[11] >> RF_ANTENNA3_FCSI_EFUSE11_TEMPSENSORRESULT__POS) & RF_ANTENNA3_FCSI_EFUSE11_TEMPSENSORRESULT__MSK);
			efuse_vcal_rsit = ((fuse_data[11] >> RF_ANTENNA3_FCSI_EFUSE11_PROCESSCAL__POS) & RF_ANTENNA3_FCSI_EFUSE11_PROCESSCAL__MSK);

			efuse_trimfilter_ant0_10MHz = ((fuse_data[12] >> RF_ANTENNA3_FCSI_EFUSE12_FILTCORNERFREQ10MHZ__POS) & RF_ANTENNA3_FCSI_EFUSE12_FILTCORNERFREQ10MHZ__MSK);
			efuse_trimfilter_ant0_20MHz = ((fuse_data[12] >> RF_ANTENNA3_FCSI_EFUSE12_FILTCORNERFREQ20MHZ__POS) & RF_ANTENNA3_FCSI_EFUSE12_FILTCORNERFREQ20MHZ__MSK);
			efuse_trimfilter_ant0_40MHz = ((fuse_data[12] >> RF_ANTENNA3_FCSI_EFUSE12_FILTCORNERFREQ40MHZ__POS) & RF_ANTENNA3_FCSI_EFUSE12_FILTCORNERFREQ40MHZ__MSK);

			efuse_trimfilter_ant2_10MHz = ((fuse_data[13] >> RF_ANTENNA3_FCSI_EFUSE13_FILTCORNERFREQ10MHZ__POS) & RF_ANTENNA3_FCSI_EFUSE13_FILTCORNERFREQ10MHZ__MSK);
			efuse_trimfilter_ant2_20MHz = ((fuse_data[13] >> RF_ANTENNA3_FCSI_EFUSE13_FILTCORNERFREQ20MHZ__POS) & RF_ANTENNA3_FCSI_EFUSE13_FILTCORNERFREQ20MHZ__MSK);
			efuse_trimfilter_ant2_40MHz = ((fuse_data[13] >> RF_ANTENNA3_FCSI_EFUSE13_FILTCORNERFREQ40MHZ__POS) & RF_ANTENNA3_FCSI_EFUSE13_FILTCORNERFREQ40MHZ__MSK);

			efuse_bias = ((fuse_data[14] >> RF_ANTENNA3_FCSI_EFUSE14_CTL_CAL_ICONST__POS) & RF_ANTENNA3_FCSI_EFUSE14_CTL_CAL_ICONST__MSK);
			// efuse_fsys_vout = ((fuse_data[14] >> RF_ANTENNA3_FCSI_EFUSE14_CTL_FSYS2_RES__POS) & RF_ANTENNA3_FCSI_EFUSE14_CTL_FSYS2_RES__MSK);
			// efuse_fsys_iref = ((fuse_data[14] >> RF_ANTENNA3_FCSI_EFUSE14_CTL_FSYS2_CM__POS) & RF_ANTENNA3_FCSI_EFUSE14_CTL_FSYS2_CM__MSK);
			efuse_fcsildo1v2 = ((fuse_data[14] >> RF_ANTENNA3_FCSI_EFUSE14_FCSILDO__POS) & RF_ANTENNA3_FCSI_EFUSE14_FCSILDO__MSK);
			// efuse_lotree_slow = ((fuse_data[14] >> RF_ANTENNA3_FCSI_EFUSE14_SLOWCORNER__POS) & RF_ANTENNA3_FCSI_EFUSE14_SLOWCORNER__MSK);

			// efuse_version = ((fuse_data[15] >> RF_ANTENNA3_FCSI_EFUSE15_VERSIONNUMBER__POS) & RF_ANTENNA3_FCSI_EFUSE15_VERSIONNUMBER__MSK);
			// efuse_product = ((fuse_data[15] >> RF_ANTENNA3_FCSI_EFUSE15_PRODUCTCODE__POS) & RF_ANTENNA3_FCSI_EFUSE15_PRODUCTCODE__MSK);
			efuse_mcm = ((fuse_data[15] >> RF_ANTENNA3_FCSI_EFUSE15_MCM__POS) & RF_ANTENNA3_FCSI_EFUSE15_MCM__MSK);
		}
		// replacing with A11 default values
		else if (chip_fused == 2)
		{
			// EFUSE2
			efuse_vref             		= 0;

			// EFUSE3
			efuse_txldo1v2[0] 			= 13;
			efuse_rxldo1v2[0] 			= 0;
			efuse_bbldo1v2[0] 			= 14;
			efuse_filterldo1v2[0] 		= 15;

			// EFUSE4
			efuse_txldo1v2[1] 			= 14;
			efuse_rxldo1v2[1] 			= 1;
			efuse_bbldo1v2[1] 			= 15;
			efuse_filterldo1v2[1] 		= 0;

			// EFUSE5
			efuse_txldo1v2[2] 			= 15;
			efuse_rxldo1v2[2] 			= 2;
			efuse_bbldo1v2[2] 			= 0;
			efuse_filterldo1v2[2] 		= 1;

			// EFUSE6
			efuse_txldo1v2[3] 			= 0;
			efuse_rxldo1v2[3] 			= 3;
			efuse_bbldo1v2[3] 			= 1;
			efuse_filterldo1v2[3] 		= 2;

			// EFUSE7
			efuse_rfldo2v5[0] 			= 14;
			efuse_rfldo2v5[1] 			= 14;
			efuse_rfldo2v5[2] 			= 14;
			efuse_rfldo2v5[3] 			= 14;

			// EFUSE8
			efuse_lotreeldo[0] 			= 14;
			efuse_lotreeldo[1] 			= 14;
			efuse_lotreeldo[2] 			= 15;
			efuse_lotreeldo[3] 			= 15;

			// EFUSE9
			efuse_bbioldo1v2 			= 1;
			efuse_fsysldo2v5 			= 3;
			efuse_lnastep[0] 			= 1 + Mid2HighStep_nom;
			efuse_lnastep[1] 			= 1 + Mid2HighStep_nom;
			efuse_lnastep[2] 			= 1 + Mid2HighStep_nom;
			efuse_lnastep[3] 			= 1 + Mid2HighStep_nom;

			// EFUSE10
			efuse_rx_band[0] 			=  0 + RX_Band_nom;
			efuse_rx_band[1] 			=  0 + RX_Band_nom;
			efuse_rx_band[2] 			=  0 + RX_Band_nom;
			efuse_rx_band[3] 			=  0 + RX_Band_nom;
			efuse_tx_band[0] 			=  0 + TX_Band_nom;
			efuse_tx_band[1] 			=  0 + TX_Band_nom;
			efuse_tx_band[2] 			=  0 + TX_Band_nom;
			efuse_tx_band[3] 			=  0 + TX_Band_nom;

			// EFUSE11
			efuse_vcal_rsit 			= 22;

			// EFUSE12
			efuse_trimfilter_ant0_10MHz = 18;
			efuse_trimfilter_ant0_20MHz = 17;
			efuse_trimfilter_ant0_40MHz = 16;

			// EFUSE13
			efuse_trimfilter_ant2_10MHz = 18;
			efuse_trimfilter_ant2_20MHz = 17;
			efuse_trimfilter_ant2_40MHz = 16;

			// EFUSE14
			efuse_bias 					= 12;
			efuse_fcsildo1v2 			= 2;

			// EFUSE15
			efuse_mcm 					= 1;
		}

		if (sections & 1)
		{
			//--------------------------------------------------------------------------
			// write efuse_vref and efuse_bias to Register BIASCENT CTL_TRIM_BGP - Ant2 0x48
			//--------------------------------------------------------------------------
			RFIC_FCSI_RMW(4, RF_ANTENNA2_FCSI_BIASCENT,
					RF_ANTENNA2_FCSI_BIASCENT_CTL_TRIM_BGP__ISMSK
					& RF_ANTENNA2_FCSI_BIASCENT_CTL_CAL_ICONST__ISMSK,
					efuse_vref << RF_ANTENNA2_FCSI_BIASCENT_CTL_TRIM_BGP__POS
					| efuse_bias << RF_ANTENNA2_FCSI_BIASCENT_CTL_CAL_ICONST__POS);

			for (ant=0; ant < 4; ant++)
			{
				//--------------------------------------------------------------------------
				// write efuse_txldo1v2[x] to Register TXLDO1V2 CTL_VOUT - Antx 0x50
				//--------------------------------------------------------------------------
				RFIC_FCSI_RMW(1<<ant, RF_ANTENNA0_FCSI_TXLDO1V2,
						RF_ANTENNA0_FCSI_TXLDO1V2_CTL_VOUT__ISMSK,
						efuse_txldo1v2[ant] << RF_ANTENNA0_FCSI_TXLDO1V2_CTL_VOUT__POS);

				//--------------------------------------------------------------------------
				// write efuse_rxldo1v2[x] to Register RXLDO1V2 CTL_VOUT - Antx 0x51
				//--------------------------------------------------------------------------
				RFIC_FCSI_RMW(1<<ant, RF_ANTENNA0_FCSI_RXLDO1V2,
						RF_ANTENNA0_FCSI_RXLDO1V2_CTL_VOUT__ISMSK,
						efuse_rxldo1v2[ant] << RF_ANTENNA0_FCSI_RXLDO1V2_CTL_VOUT__POS);

				//--------------------------------------------------------------------------
				// write efuse_bbldo1v2[x] to Register BBLDO1V2 CTL_VOUT - Antx 0x52
				//--------------------------------------------------------------------------
				RFIC_FCSI_RMW(1<<ant, RF_ANTENNA0_FCSI_BBLDO1V2,
						RF_ANTENNA0_FCSI_BBLDO1V2_CTL_VOUT__ISMSK,
						efuse_bbldo1v2[ant] << RF_ANTENNA0_FCSI_BBLDO1V2_CTL_VOUT__POS);

				//--------------------------------------------------------------------------
				// write efuse_bbldo1v2[x] to Register BBFILTLDO1V2 CTL_VOUT - Antx 0x53
				//--------------------------------------------------------------------------
				RFIC_FCSI_RMW(1<<ant, RF_ANTENNA0_FCSI_BBFILTLDO1V2,
						RF_ANTENNA0_FCSI_BBFILTLDO1V2_CTL_VOUT__ISMSK,
						efuse_filterldo1v2[ant] << RF_ANTENNA0_FCSI_BBFILTLDO1V2_CTL_VOUT__POS);

				//--------------------------------------------------------------------------
				// write efuse_rfldo2v5[x] to Register RFLDO2V5 CTL_VOUT - Antx 0x54
				//--------------------------------------------------------------------------
				RFIC_FCSI_RMW(1<<ant, RF_ANTENNA0_FCSI_RFLDO2V5,
						RF_ANTENNA0_FCSI_RFLDO2V5_CTL_VOUT__ISMSK,
						efuse_rfldo2v5[ant] << RF_ANTENNA0_FCSI_RFLDO2V5_CTL_VOUT__POS);

				//--------------------------------------------------------------------------
				// write efuse_lotreeldo[x] to Register LOLDO0+x CTL_VOUT - Ant1 0x49+x
				//--------------------------------------------------------------------------
				RFIC_FCSI_RMW(2, RF_ANTENNA1_FCSI_LOLDO0+ant,
						RF_ANTENNA1_FCSI_LOLDO0_CTL_VOUT__ISMSK,
						efuse_lotreeldo[ant] << RF_ANTENNA1_FCSI_LOLDO0_CTL_VOUT__POS);

			}
			//--------------------------------------------------------------------------
			// write efuse_bbioldo1v2 to Register BBIOLDO1V2 CTL_VOUT - Ant2 0x44
			//--------------------------------------------------------------------------
			RFIC_FCSI_RMW(4, RF_ANTENNA2_FCSI_BBIOLDO1V2,
					RF_ANTENNA2_FCSI_BBIOLDO1V2_CTL_VOUT__ISMSK,
					efuse_bbioldo1v2 << RF_ANTENNA2_FCSI_BBIOLDO1V2_CTL_VOUT__POS);

			//--------------------------------------------------------------------------
			// write efuse_bbioldo1v2 to Register FSYSLDO2V5 CTL_VOUT - Ant1 0x45
			//--------------------------------------------------------------------------
			RFIC_FCSI_RMW(2, RF_ANTENNA1_FCSI_FSYSLDO2V5,
					RF_ANTENNA1_FCSI_FSYSLDO2V5_CTL_VOUT__ISMSK,
					efuse_fsysldo2v5 << RF_ANTENNA1_FCSI_FSYSLDO2V5_CTL_VOUT__POS);

			//--------------------------------------------------------------------------
			// write efuse_fcsildo1v2 to Register FCSILDO1V2 CTL_VOUT - Ant1 0x46
			//--------------------------------------------------------------------------
			RFIC_FCSI_RMW(2, RF_ANTENNA1_FCSI_FCSILDO1V2,
					RF_ANTENNA1_FCSI_FCSILDO1V2_CTL_VOUT__ISMSK,
					efuse_fcsildo1v2 << RF_ANTENNA1_FCSI_FCSILDO1V2_CTL_VOUT__POS);

/*
			if (efuse_lotree_slow)
			{
				//--------------------------------------------------------------------------
				// enable slow slices in Register LOCENTRAL EN_SLOW_xxx - Ant1 0x48
				//--------------------------------------------------------------------------
				// current behavior: activate ALL slow slices on ALL antennas if efuse_lotree_slow==1
				RFIC_FCSI_RMW(2, RF_ANTENNA1_FCSI_LOCENTRAL,
						RF_ANTENNA1_FCSI_LOCENTRAL_EN_SLOW_FOB_ANT0__ISMSK
						& RF_ANTENNA1_FCSI_LOCENTRAL_EN_SLOW_FOB_ANT1__ISMSK
						& RF_ANTENNA1_FCSI_LOCENTRAL_EN_SLOW_FOB_ANT2__ISMSK
						& RF_ANTENNA1_FCSI_LOCENTRAL_EN_SLOW_FOB_ANT3__ISMSK
						& RF_ANTENNA1_FCSI_LOCENTRAL_EN_SLOW_TML_DRV_ANT0__ISMSK
						& RF_ANTENNA1_FCSI_LOCENTRAL_EN_SLOW_TML_DRV_ANT1__ISMSK
						& RF_ANTENNA1_FCSI_LOCENTRAL_EN_SLOW_TML_DRV_ANT2__ISMSK
						& RF_ANTENNA1_FCSI_LOCENTRAL_EN_SLOW_TML_DRV_ANT3__ISMSK,
						RF_ANTENNA1_FCSI_LOCENTRAL_EN_SLOW_FOB_ANT0_1__SVAL
						| RF_ANTENNA1_FCSI_LOCENTRAL_EN_SLOW_FOB_ANT1_1__SVAL
						| RF_ANTENNA1_FCSI_LOCENTRAL_EN_SLOW_FOB_ANT2_1__SVAL
						| RF_ANTENNA1_FCSI_LOCENTRAL_EN_SLOW_FOB_ANT3_1__SVAL
						| RF_ANTENNA1_FCSI_LOCENTRAL_EN_SLOW_TML_DRV_ANT0_1__SVAL
						| RF_ANTENNA1_FCSI_LOCENTRAL_EN_SLOW_TML_DRV_ANT1_1__SVAL
						| RF_ANTENNA1_FCSI_LOCENTRAL_EN_SLOW_TML_DRV_ANT2_1__SVAL
						| RF_ANTENNA1_FCSI_LOCENTRAL_EN_SLOW_TML_DRV_ANT3_1__SVAL);

				for (ant=0; ant < 4; ant++)
				{
					//--------------------------------------------------------------------------
					// enable slow slices in Register LOCENTRAL EN_SLOW_xxx - Ant1 0x48
					//--------------------------------------------------------------------------
					// current behavior: activate ALL slow slices on ALL antennas if efuse_lotree_slow==1
					RFIC_FCSI_RMW(1<<ant, RF_ANTENNA0_FCSI_LOLOCAL,
							RF_ANTENNA0_FCSI_LOLOCAL_EN_SLOW_TXDRV__ISMSK
							& RF_ANTENNA0_FCSI_LOLOCAL_EN_SLOW_TXBUF__ISMSK
							& RF_ANTENNA0_FCSI_LOLOCAL_EN_SLOW_RXDRV__ISMSK
							& RF_ANTENNA0_FCSI_LOLOCAL_EN_SLOW_RXBUF__ISMSK,
							RF_ANTENNA0_FCSI_LOLOCAL_EN_SLOW_TXDRV_1__SVAL
							| RF_ANTENNA0_FCSI_LOLOCAL_EN_SLOW_TXBUF_1__SVAL
							| RF_ANTENNA0_FCSI_LOLOCAL_EN_SLOW_RXDRV_1__SVAL
							| RF_ANTENNA0_FCSI_LOLOCAL_EN_SLOW_RXBUF_1__SVAL);


				}
			}
*/
			//--------------------------------------------------------------------------
			// write efuse_trimfilter_ant0_xxx to Registers FILTTX & FILTRX of Ant0 & Ant1 0x64 & 0x65
			//--------------------------------------------------------------------------
			RFIC_FCSI_Write(1+2, RF_ANTENNA0_FCSI_FILTTX,
					efuse_trimfilter_ant0_10MHz << RF_ANTENNA0_FCSI_FILTTX_CTL_TRIMFILTER_TX_10MHZ__POS
					| efuse_trimfilter_ant0_20MHz << RF_ANTENNA0_FCSI_FILTTX_CTL_TRIMFILTER_TX_20MHZ__POS
					| efuse_trimfilter_ant0_40MHz << RF_ANTENNA0_FCSI_FILTTX_CTL_TRIMFILTER_TX_40MHZ__POS);

			RFIC_FCSI_Write(1+2, RF_ANTENNA0_FCSI_FILTRX,
					efuse_trimfilter_ant0_10MHz << RF_ANTENNA0_FCSI_FILTRX_CTL_TRIMFILTER_RX_10MHZ__POS
					| efuse_trimfilter_ant0_20MHz << RF_ANTENNA0_FCSI_FILTRX_CTL_TRIMFILTER_RX_20MHZ__POS
					| efuse_trimfilter_ant0_40MHz << RF_ANTENNA0_FCSI_FILTRX_CTL_TRIMFILTER_RX_40MHZ__POS);

			//--------------------------------------------------------------------------
			// write efuse_trimfilter_ant2_xxx to Registers FILTTX & FILTRX of Ant2 & Ant3 0x64 & 0x65
			//--------------------------------------------------------------------------
			RFIC_FCSI_Write(4+8, RF_ANTENNA2_FCSI_FILTTX,
					efuse_trimfilter_ant2_10MHz << RF_ANTENNA2_FCSI_FILTTX_CTL_TRIMFILTER_TX_10MHZ__POS
					| efuse_trimfilter_ant2_20MHz << RF_ANTENNA2_FCSI_FILTTX_CTL_TRIMFILTER_TX_20MHZ__POS
					| efuse_trimfilter_ant2_40MHz << RF_ANTENNA2_FCSI_FILTTX_CTL_TRIMFILTER_TX_40MHZ__POS);

			RFIC_FCSI_Write(4+8, RF_ANTENNA2_FCSI_FILTRX,
					efuse_trimfilter_ant2_10MHz << RF_ANTENNA2_FCSI_FILTRX_CTL_TRIMFILTER_RX_10MHZ__POS
					| efuse_trimfilter_ant2_20MHz << RF_ANTENNA2_FCSI_FILTRX_CTL_TRIMFILTER_RX_20MHZ__POS
					| efuse_trimfilter_ant2_40MHz << RF_ANTENNA2_FCSI_FILTRX_CTL_TRIMFILTER_RX_40MHZ__POS);

			for (ant=0; ant < 4; ant++)
			{
				//--------------------------------------------------------------------------
				// write efuse_rx_mid_gain to Registers General LNA 0x6a in each antenna
				//--------------------------------------------------------------------------
//				RFIC_FCSI_RMW(1<<ant, RF_ANTENNA0_FCSI_LNA,
//						RF_ANTENNA0_FCSI_LNA_CTL_FINE_GAIN__ISMSK,
//						efuse_rx_mid_gain << RF_ANTENNA0_FCSI_LNA_CTL_FINE_GAIN__POS);
				// efuse coding for LNA mid gain calibration changed for WRX514
				RFIC_FCSI_RMW(1<<ant, RF_ANTENNA0_FCSI_LNA,
						RF_ANTENNA0_FCSI_LNA_CTL_FINE_GAIN__ISMSK,
						(efuse_lnastep[ant]+Mid2HighStep_nom) << RF_ANTENNA0_FCSI_LNA_CTL_FINE_GAIN__POS);
			}

			//--------------------------------------------------------------------------
			// write efuse_vcal_rsit to Register TEMPSENS1 0x4d in Ant2
			//--------------------------------------------------------------------------
			RFIC_FCSI_RMW(4, RF_ANTENNA2_FCSI_TEMPSENS1,
					RF_ANTENNA2_FCSI_TEMPSENS1_VCAL_VAL__ISMSK,
					efuse_vcal_rsit << RF_ANTENNA2_FCSI_TEMPSENS1_VCAL_VAL__POS);

			//--------------------------------------------------------------------------
			// write efuse_mcm Bit to Register BBIO EN_MCM_MODE - Ant2 0x41
			//--------------------------------------------------------------------------
			RFIC_FCSI_RMW(4, RF_ANTENNA2_FCSI_BBIO,
					RF_ANTENNA2_FCSI_BBIO_EN_MCM_MODE__ISMSK,
					efuse_mcm << RF_ANTENNA2_FCSI_BBIO_EN_MCM_MODE__POS);


			for (ant=0; ant < 4; ant++)
			{
				//--------------------------------------------------------------------------
				// Correct TX/RX Band Selection for each Antenna - Antx SR0
				//--------------------------------------------------------------------------
				RFIC_FCSI_RMW(1<<ant, RF_ANTENNA0_FCSI_SR0,
						RF_ANTENNA0_FCSI_SR0_TX_BAND__ISMSK
						& RF_ANTENNA0_FCSI_SR0_RX_BAND__ISMSK,
						efuse_tx_band[ant] << RF_ANTENNA0_FCSI_SR0_TX_BAND__POS
						| efuse_rx_band[ant] << RF_ANTENNA0_FCSI_SR0_RX_BAND__POS);
			}

		}
	}
	return(chip_fused);
}


uint16_t rfic_read_efuse_handlertemp(uint16_t *softfuse_data)
{
	uint16_t handlertemp;
	uint16_t read_data[4];

    // force to read from softfuse data as long as softfuse_data[15] != 0
    if (softfuse_data[15] == 0)
    {
    	//--------------------------------------------------------------------------
    	// read EFUSE2 register (read on all antennas, but only Ant3 reading is used)
    	//--------------------------------------------------------------------------
    	RFIC_FCSI_Read(15, RF_ANTENNA3_FCSI_EFUSE2, read_data);
    }
    else // or use external softfuse_data
    {
    	//--------------------------------------------------------------------------
    	// write softfuse data for fuse_reg[2] to read_data[3] to mimic on-chip reading
    	//--------------------------------------------------------------------------
    	read_data[3] = softfuse_data[2];
    }
	handlertemp = ((read_data[3] >> RF_ANTENNA3_FCSI_EFUSE2_HANDLERTEMP__POS) & RF_ANTENNA3_FCSI_EFUSE2_HANDLERTEMP__MSK);

	return handlertemp;
}


uint16_t rfic_read_efuse_tempsensorresult(uint16_t *softfuse_data)
{
	uint16_t tempsensorresult;
	uint16_t read_data[4];

    // force to read from softfuse data as long softfuse_data[15] != 0
    if (softfuse_data[15] == 0)
    {
    	//--------------------------------------------------------------------------
    	// read EFUSE11 register (read on all antennas, but only Ant3 reading is used)
    	//--------------------------------------------------------------------------
    	RFIC_FCSI_Read(15, RF_ANTENNA3_FCSI_EFUSE11, read_data);
    }
    else // or use external softfuse_data
    {
    	//--------------------------------------------------------------------------
    	// write softfuse data for fuse_reg[11] to read_data[3] to mimic on-chip reading
    	//--------------------------------------------------------------------------
    	read_data[3] = softfuse_data[11];
    }
	tempsensorresult = ((read_data[3] >> RF_ANTENNA3_FCSI_EFUSE11_TEMPSENSORRESULT__POS) & RF_ANTENNA3_FCSI_EFUSE11_TEMPSENSORRESULT__MSK);

	return tempsensorresult;
}


void rfic_enable_bbio_x_y (uint8_t Antx, uint8_t Anty)
{
	uint16_t	Reg41Msk;
	uint16_t	Reg41Val;
	uint16_t	LoopControl;
	uint16_t	EnablePos;

	if (Anty == 0)
	{
		Reg41Msk = RF_ANTENNA2_FCSI_BBIO_EN_BBIO_ANT0__ISMSK;
		Reg41Val = RF_ANTENNA2_FCSI_BBIO_EN_BBIO_ANT0_1__SVAL;
		EnablePos = 1;
	}
	else if (Anty == 1)
	{
		Reg41Msk = RF_ANTENNA2_FCSI_BBIO_EN_BBIO_ANT1__ISMSK;
		Reg41Val = RF_ANTENNA2_FCSI_BBIO_EN_BBIO_ANT1_1__SVAL;
		EnablePos = 16;
	}
	else if (Anty == 2)
	{
		Reg41Msk = RF_ANTENNA2_FCSI_BBIO_EN_BBIO_ANT2__ISMSK;
		Reg41Val = RF_ANTENNA2_FCSI_BBIO_EN_BBIO_ANT2_1__SVAL;
		EnablePos = 256;
	}
	else if (Anty == 3)
	{
		Reg41Msk = RF_ANTENNA2_FCSI_BBIO_EN_BBIO_ANT3__ISMSK;
		Reg41Val = RF_ANTENNA2_FCSI_BBIO_EN_BBIO_ANT3_1__SVAL;
		EnablePos = 4096;
	}

	if ((Antx==0 && Anty==1) || (Antx==1 && Anty==2) || (Antx==2 && Anty==3) || (Antx==3 && Anty==0)) // EN_IN1
		LoopControl = EnablePos * 2;

	else if ((Antx==0 && Anty==2) || (Antx==1 && Anty==3) || (Antx==2 && Anty==0) || (Antx==3 && Anty==1)) // EN_IN2
		LoopControl = EnablePos * 4;

	else if ((Antx==0 && Anty==3) || (Antx==1 && Anty==0) || (Antx==2 && Anty==1) || (Antx==3 && Anty==2)) // EN_IN3
		LoopControl = EnablePos * 8;

	//--------------------------------------------------------------------------
	// Register BBIO - BBO + BBIO CONFIG		Ant2	0x41
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(4, RF_ANTENNA2_FCSI_BBIO,
			Reg41Msk,
			Reg41Val);

	//--------------------------------------------------------------------------
	// Register BBIOLOOP - BBIO LOOPS	Ant2	0x42
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(4, RF_ANTENNA2_FCSI_BBIOLOOP,
			LoopControl);
}

void rfic_disable_bbio_x_y (void)
{
	//--------------------------------------------------------------------------
	// Register BBIO - BBO + BBIO CONFIG		Ant2	0x41
	//--------------------------------------------------------------------------
	RFIC_FCSI_RMW(4, RF_ANTENNA2_FCSI_BBIO,
			RF_ANTENNA2_FCSI_BBIO_EN_BBIO_ANT0__ISMSK
			& RF_ANTENNA2_FCSI_BBIO_EN_BBIO_ANT1__ISMSK
			& RF_ANTENNA2_FCSI_BBIO_EN_BBIO_ANT2__ISMSK
			& RF_ANTENNA2_FCSI_BBIO_EN_BBIO_ANT3__ISMSK,
			RF_ANTENNA2_FCSI_BBIO_EN_BBIO_ANT0_0__SVAL
			| RF_ANTENNA2_FCSI_BBIO_EN_BBIO_ANT1_0__SVAL
			| RF_ANTENNA2_FCSI_BBIO_EN_BBIO_ANT2_0__SVAL
			| RF_ANTENNA2_FCSI_BBIO_EN_BBIO_ANT3_0__SVAL);

	//--------------------------------------------------------------------------
	// Register BBIOLOOP - BBIO LOOPS	Ant2	0x42
	//--------------------------------------------------------------------------
	RFIC_FCSI_Write(4, RF_ANTENNA2_FCSI_BBIOLOOP,
			0x0000);
}

void rfic_set_lotree_ldo(uint8_t AntMsk, int step)
{
	if (step>7)
		step = 7;
	if (step<-4)
		step = -4;
	if (step<0)
		step = step+16;

	if ((AntMsk-8)>=0)
	{
		//--------------------------------------------------------------------------
		// Register LOLDO3	LOTREE LDO ANT3		Ant1	0x4C
		//--------------------------------------------------------------------------
		RFIC_FCSI_RMW(2, RF_ANTENNA1_FCSI_LOLDO3,
				RF_ANTENNA1_FCSI_LOLDO3_CTL_VOUT__ISMSK,
				step << RF_ANTENNA1_FCSI_LOLDO3_CTL_VOUT__POS);

		AntMsk = AntMsk-8;
	}

	if ((AntMsk-4)>=0)
	{
		//--------------------------------------------------------------------------
		// Register LOLDO2	LOTREE LDO ANT2		Ant1	0x4B
		//--------------------------------------------------------------------------
		RFIC_FCSI_RMW(2, RF_ANTENNA1_FCSI_LOLDO2,
				RF_ANTENNA1_FCSI_LOLDO2_CTL_VOUT__ISMSK,
				step << RF_ANTENNA1_FCSI_LOLDO2_CTL_VOUT__POS);

		AntMsk = AntMsk-4;
	}

	if ((AntMsk-2)>=0)
	{
		//--------------------------------------------------------------------------
		// Register LOLDO1	LOTREE LDO ANT1		Ant1	0x4A
		//--------------------------------------------------------------------------
		RFIC_FCSI_RMW(2, RF_ANTENNA1_FCSI_LOLDO1,
				RF_ANTENNA1_FCSI_LOLDO1_CTL_VOUT__ISMSK,
				step << RF_ANTENNA1_FCSI_LOLDO1_CTL_VOUT__POS);

		AntMsk = AntMsk-2;
	}

	if ((AntMsk-1)>=0)
	{
		//--------------------------------------------------------------------------
		// Register LOLDO0	LOTREE LDO ANT1		Ant1	0x49
		//--------------------------------------------------------------------------
		RFIC_FCSI_RMW(2, RF_ANTENNA1_FCSI_LOLDO0,
				RF_ANTENNA1_FCSI_LOLDO0_CTL_VOUT__ISMSK,
				step << RF_ANTENNA1_FCSI_LOLDO0_CTL_VOUT__POS);
	}
}
