/**
 *
 */
// INITIAL
function initial () {
  var locationSearch = window.location.search;
  var keys = locationSearch.split ('?', 2);
  var moduleName = keys [1];
  var module = window [moduleName];

  createTitle (module);
  createDescription (module);
  genInfo (module, null);
  createAttributesTable (module, null);
  createModuleTable (module.modules, null);
  createPortTable (module.ports, null);
  createBusTable (module.buses, null);
  createDebugMsgTable (module, null);
  createFooter (module);

  initChapter ("description", 0);
  initChapter ("info", 0);
  initChapter ("attributes", 0);
  initChapter ("submodules", 1);
  initChapter ("ports", 1);
  initChapter ("buses", 1);
  initChapter ("debugmsg", 1);

  scaleObjects ();
  window.onresize = scaleObjects;
}

function createModuleTable (modulesArray, viewName) {
  if (modulesArray == undefined || modulesArray.length === 0) {
    hideBundle ("submodulesBody", undefined);
    return;
  }

  var refName = "submodules" + Math.ceil (Math.random () * 1000).toString ();
  modulesArray.jsName = refName;
  window [refName] = modulesArray;
  createModulesTable1Init (modulesArray, "submodules");
}
function createPortTable (portsArray, viewName) {
  if (portsArray == undefined || portsArray.length === 0) {
    hideBundle ("portsBody", undefined);
    return;
  }
  var refName = "ports" + Math.ceil (Math.random () * 1000).toString ();
  portsArray.jsName = refName;
  window [refName] = portsArray;
  createPortsTable1Init (portsArray, "ports");
}
function createBusTable (busesArray, viewName) {
  if (busesArray == undefined || busesArray.length === 0) {
    hideBundle ("busesBody", undefined);
    return;
  }
  var refName = "buses" + Math.ceil (Math.random () * 1000).toString ();
  busesArray.jsName = refName;
  window [refName] = busesArray;
  createBusesTable1Init (busesArray, "buses");
}

function genInfo (module, viewName) {
  var head = document.getElementById ("infoHead");

  head.innerHTML += createToggleImage ("info");

  genInfo0 (module, viewName);
}

function genInfo0 (module, viewName) {
  // Description
  var body = document.getElementById ("infoBody0");
  var row;
  var cell;
  var link;

  // Table Headers
  var headerCells = [ "Parameter", "Value" ];
  row = document.createElement ("tr");
  for (idx in headerCells) {
    cell = document.createElement ("th");
    cell.innerHTML = headerCells [idx];
    row.appendChild (cell);
  }
  body.appendChild (row);

  // Table Body
  // Row: Module
  row = document.createElement ("tr");
  row.className = "interleave";
  cell = document.createElement ("td");
  cell.innerHTML = "Module";
  row.appendChild (cell);
  cell = document.createElement ("td");
  cell.innerHTML = module.aliasName;
  cell.innerHTML += " (" + module.baseName + ")";
  row.appendChild (cell);
  body.appendChild (row);
  // Row: Module Parent
  row = document.createElement ("tr");
  cell = document.createElement ("td");
  cell.innerHTML = "Module Parent";
  row.appendChild (cell);
  cell = document.createElement ("td");
  if (module.parent.length > 0) {
    if (module.parent.match ("^system")) {
      cell.innerHTML = window [system.jsName].aliasName;
      cell.innerHTML += " (" + window [system.jsName].baseName + ")";
    } else {
      cell.innerHTML = window [module.parent].aliasName;
      cell.innerHTML += " (" + window [module.parent].baseName + ")";
    }

  } else {
    cell.innerHTML = "-";
  }
  row.appendChild (cell);
  body.appendChild (row);
  // Row: Number of Modules
  row = document.createElement ("tr");
  row.className = "interleave";
  cell = document.createElement ("td");
  cell.innerHTML = "Number of Sub-Modules";
  row.appendChild (cell);
  cell = createNrTableCell (module.modules.length, 32, "dec");
  row.appendChild (cell);
  body.appendChild (row);
  // Row: Number of Ports
  row = document.createElement ("tr");
  cell = document.createElement ("td");
  cell.innerHTML = "Number of Ports";
  row.appendChild (cell);
  cell = createNrTableCell (module.ports.length, 32, "dec");
  row.appendChild (cell);
  body.appendChild (row);
  // Row: Number of Buses
  row = document.createElement ("tr");
  row.className = "interleave";
  cell = document.createElement ("td");
  cell.innerHTML = "Number of Buses";
  row.appendChild (cell);
  cell = createNrTableCell (module.buses.length, 32, "dec");
  row.appendChild (cell);
  body.appendChild (row);
  // Row: Has Mutations ...
  row = document.createElement ("tr");
  cell = document.createElement ("td");
  cell.innerHTML = "Mutations By Attributes";
  row.appendChild (cell);
  cell = document.createElement ("td");
  if (module.hasMutationsByAttributes == "true") {
    cell.innerHTML = "YES";
  } else {
    cell.innerHTML = "NO";
  }
  row.appendChild (cell);
  body.appendChild (row);
  //Row: References
  row = document.createElement ("tr");
  row.className = "interleave";
  cell = document.createElement ("td");
  cell.innerHTML = "References";
  row.appendChild (cell);
  cell = document.createElement ("td");
  generateReference(cell, module, module.jsName, false);
  row.appendChild (cell);
  body.appendChild (row);
  //Enabled and Disabled Exporters
  row = document.createElement ("tr");
  cell = document.createElement ("td");
  var title1 = "Enabled";
  var title2 = "Disabled";
  cell.innerHTML = title1.fontcolor("green");
  cell.innerHTML += " /" + title2.fontcolor("red");
  cell.innerHTML += " Exporters";
  row.appendChild (cell);
  cell = document.createElement ("td");
  generateEnDisTypes (cell, module);
  row.appendChild (cell);
  body.appendChild (row);
  //Row: Source File
  row = document.createElement ("tr");
  row.className = "interleave";
  cell = document.createElement ("td");
  cell.innerHTML = "Source file";
  row.appendChild (cell);
  cell = document.createElement ("td");
  cell.innerHTML = module.sourceFile;
  row.appendChild (cell);
  body.appendChild (row);
  //Aliases
  row = document.createElement ("tr");
  cell = document.createElement ("td");
  cell.innerHTML = "Aliases";
  row.appendChild (cell);
  cell = document.createElement ("td");
  generateAliases (cell, module);
  row.appendChild (cell);
  body.appendChild (row);
}
